// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for a preemption of a CDP kernel.
 *
 * This activity record represents a preemption of a CDP kernel.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityPreemption extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityPreemption() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityPreemption(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityPreemption(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityPreemption position(long position) {
        return (CUpti_ActivityPreemption)super.position(position);
    }
    @Override public CUpti_ActivityPreemption getPointer(long i) {
        return new CUpti_ActivityPreemption((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_PREEMPTION
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityPreemption kind(int setter);

  /**
  * kind of the preemption
  */
  public native @Cast("CUpti_ActivityPreemptionKind") int preemptionKind(); public native CUpti_ActivityPreemption preemptionKind(int setter);

  /**
   * The timestamp of the preemption, in ns. A value of 0 indicates
   * that timestamp information could not be collected for the
   * preemption.
   */
  public native @Cast("uint64_t") long timestamp(); public native CUpti_ActivityPreemption timestamp(long setter);

  /**
  * The grid-id of the block that is preempted
  */
  public native @Cast("int64_t") long gridId(); public native CUpti_ActivityPreemption gridId(long setter);

  /**
   * The X-dimension of the block that is preempted
   */
  public native @Cast("uint32_t") int blockX(); public native CUpti_ActivityPreemption blockX(int setter);

  /**
   * The Y-dimension of the block that is preempted
   */
  public native @Cast("uint32_t") int blockY(); public native CUpti_ActivityPreemption blockY(int setter);

  /**
   * The Z-dimension of the block that is preempted
   */
  public native @Cast("uint32_t") int blockZ(); public native CUpti_ActivityPreemption blockZ(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivityPreemption pad(int setter);
}
