// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for source-level shared
 * access.
 *
 * This activity records the locations of the shared
 * accesses in the source
 * (CUPTI_ACTIVITY_KIND_SHARED_ACCESS).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivitySharedAccess extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivitySharedAccess() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivitySharedAccess(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivitySharedAccess(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivitySharedAccess position(long position) {
        return (CUpti_ActivitySharedAccess)super.position(position);
    }
    @Override public CUpti_ActivitySharedAccess getPointer(long i) {
        return new CUpti_ActivitySharedAccess((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_SHARED_ACCESS.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivitySharedAccess kind(int setter);

  /**
   * The properties of this shared access.
   */
  public native @Cast("CUpti_ActivityFlag") int flags(); public native CUpti_ActivitySharedAccess flags(int setter);

  /**
   * The ID for source locator.
   */
  public native @Cast("uint32_t") int sourceLocatorId(); public native CUpti_ActivitySharedAccess sourceLocatorId(int setter);

  /**
   * The correlation ID of the kernel to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivitySharedAccess correlationId(int setter);

 /**
  * Correlation ID with global/device function name
  */
  public native @Cast("uint32_t") int functionId(); public native CUpti_ActivitySharedAccess functionId(int setter);

  /**
   * The pc offset for the access.
   */
  public native @Cast("uint32_t") int pcOffset(); public native CUpti_ActivitySharedAccess pcOffset(int setter);

  /**
   * This increments each time when this instruction is executed by number
   * of threads that executed this instruction with predicate and condition code evaluating to true.
   */
  public native @Cast("uint64_t") long threadsExecuted(); public native CUpti_ActivitySharedAccess threadsExecuted(long setter);

  /**
   * The total number of shared memory transactions generated by this access
   */
  public native @Cast("uint64_t") long sharedTransactions(); public native CUpti_ActivitySharedAccess sharedTransactions(long setter);

  /**
   * The minimum number of shared memory transactions possible based on the access pattern.
   */
  public native @Cast("uint64_t") long theoreticalSharedTransactions(); public native CUpti_ActivitySharedAccess theoreticalSharedTransactions(long setter);

  /**
   * The number of times this instruction was executed per warp. It will be incremented
   * when at least one of thread among warp is active with predicate and condition code
   * evaluating to true.
   */
  public native @Cast("uint32_t") int executed(); public native CUpti_ActivitySharedAccess executed(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivitySharedAccess pad(int setter);
}
