// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for source locator.
 *
 * This activity record represents a source locator
 * (CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivitySourceLocator extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivitySourceLocator() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivitySourceLocator(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivitySourceLocator(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivitySourceLocator position(long position) {
        return (CUpti_ActivitySourceLocator)super.position(position);
    }
    @Override public CUpti_ActivitySourceLocator getPointer(long i) {
        return new CUpti_ActivitySourceLocator((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivitySourceLocator kind(int setter);

  /**
   * The ID for the source path, will be used in all the source level
   * results.
   */
  public native @Cast("uint32_t") int id(); public native CUpti_ActivitySourceLocator id(int setter);

  /**
   * The line number in the source .
   */
  public native @Cast("uint32_t") int lineNumber(); public native CUpti_ActivitySourceLocator lineNumber(int setter);

// #ifdef CUPTILP64
  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivitySourceLocator pad(int setter);
// #endif

  /**
   * The path for the file.
   */
  public native @Cast("const char*") BytePointer fileName(); public native CUpti_ActivitySourceLocator fileName(BytePointer setter);
}
