// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for synchronization management.
 *
 * This activity is used to track various CUDA synchronization APIs.
 * (CUPTI_ACTIVITY_KIND_SYNCHRONIZATION).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivitySynchronization2 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivitySynchronization2() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivitySynchronization2(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivitySynchronization2(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivitySynchronization2 position(long position) {
        return (CUpti_ActivitySynchronization2)super.position(position);
    }
    @Override public CUpti_ActivitySynchronization2 getPointer(long i) {
        return new CUpti_ActivitySynchronization2((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_SYNCHRONIZATION.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivitySynchronization2 kind(int setter);

  /**
   * The type of record.
   */
  public native @Cast("CUpti_ActivitySynchronizationType") int type(); public native CUpti_ActivitySynchronization2 type(int setter);

  /**
   * The start timestamp for the function, in ns. A value of 0 for
   * both the start and end timestamps indicates that timestamp
   * information could not be collected for the function.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivitySynchronization2 start(long setter);

  /**
   * The end timestamp for the function, in ns. A value of 0 for both
   * the start and end timestamps indicates that timestamp information
   * could not be collected for the function.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivitySynchronization2 end(long setter);

  /**
   * The correlation ID of the API to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivitySynchronization2 correlationId(int setter);

  /**
   * The ID of the context for which the synchronization API is called.
   * In case of context synchronization API it is the context id for which the API is called.
   * In case of stream/event synchronization it is the ID of the context where the stream/event was created.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivitySynchronization2 contextId(int setter);

  /**
   * The compute stream for which the synchronization API is called.
   * A CUPTI_SYNCHRONIZATION_INVALID_VALUE value indicate the field is not applicable for this record.
   * Not valid for cuCtxSynchronize, cuEventSynchronize.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivitySynchronization2 streamId(int setter);

  /**
   * The event ID for which the synchronization API is called.
   * A CUPTI_SYNCHRONIZATION_INVALID_VALUE value indicate the field is not applicable for this record.
   * Not valid for cuCtxSynchronize, cuStreamSynchronize.
   */
  public native @Cast("uint32_t") int cudaEventId(); public native CUpti_ActivitySynchronization2 cudaEventId(int setter);

  /**
   * A unique ID to associate event synchronization records
   * with the latest CUDA Event record. Similar field is added
   * in CUpti_ActivityCudaEvent2 to associate synchronization
   * record to the CUDA Event record.
   *
   * The same CUDA event can be used multiple times, so the
   * event id will not be unique to correlate the synchronization
   * record with the latest CUDA Event record.
   * This field will be unique and can be used to do the required
   * correlation.
   *
   * A CUPTI_SYNCHRONIZATION_INVALID_VALUE value indicates that
   * the field is not applicable for this record.
   * Valid only for synchronization records related to CUDA Events.
   */
  public native @Cast("uint64_t") long cudaEventSyncId(); public native CUpti_ActivitySynchronization2 cudaEventSyncId(long setter);

  /**
   * The return value for the synchronization record.
   * Use cuptiActivityEnableAllSyncRecords API to enable/disable
   * collection of synchronization records with return value being
   * non-zero. This will be a CUresult value.
   */
  public native @Cast("uint32_t") int returnValue(); public native CUpti_ActivitySynchronization2 returnValue(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivitySynchronization2 pad(int setter);
}
