// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief Function type for callback used by CUPTI to request an empty
 * buffer for storing activity records.
 *
 * This callback function signals the CUPTI client that an activity
 * buffer is needed by CUPTI. The activity buffer is used by CUPTI to
 * store activity records. The callback function can decline the
 * request by setting \p *buffer to NULL. In this case CUPTI may drop
 * activity records.
 *
 * @param buffer Returns the new buffer. If set to NULL then no buffer
 * is returned.
 * @param size Returns the size of the returned buffer.
 * @param maxNumRecords Returns the maximum number of records that
 * should be placed in the buffer. If 0 then the buffer is filled with
 * as many records as possible. If > 0 the buffer is filled with at
 * most that many records before it is returned.
 */
@Convention("CUPTIAPI") @Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_BuffersCallbackRequestFunc extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    CUpti_BuffersCallbackRequestFunc(Pointer p) { super(p); }
    protected CUpti_BuffersCallbackRequestFunc() { allocate(); }
    private native void allocate();
    public native void call(
    @Cast("uint8_t**") PointerPointer buffer,
    @Cast("size_t*") SizeTPointer size,
    @Cast("size_t*") SizeTPointer maxNumRecords);
}
