// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief Function type for a callback.
 *
 * Function type for a callback. The type of the data passed to the
 * callback in \p cbdata depends on the \p domain. If \p domain is
 * CUPTI_CB_DOMAIN_DRIVER_API or CUPTI_CB_DOMAIN_RUNTIME_API the type
 * of \p cbdata will be CUpti_CallbackData. If \p domain is
 * CUPTI_CB_DOMAIN_RESOURCE the type of \p cbdata will be
 * CUpti_ResourceData. If \p domain is CUPTI_CB_DOMAIN_SYNCHRONIZE the
 * type of \p cbdata will be CUpti_SynchronizeData. If \p domain is
 * CUPTI_CB_DOMAIN_NVTX the type of \p cbdata will be CUpti_NvtxData.
 *
 * @param userdata User data supplied at subscription of the callback
 * @param domain The domain of the callback
 * @param cbid The ID of the callback
 * @param cbdata Data passed to the callback.
 */
@Convention("CUPTIAPI") @Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_CallbackFunc extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    CUpti_CallbackFunc(Pointer p) { super(p); }
    protected CUpti_CallbackFunc() { allocate(); }
    private native void allocate();
    public native void call(
    Pointer userdata,
    @Cast("CUpti_CallbackDomain") int domain,
    @Cast("CUpti_CallbackId") int cbid,
    @Const Pointer cbdata);
}
