// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief A set of event group sets.
 *
 * A set of event group sets. When returned by \ref
 * cuptiEventGroupSetsCreate and \ref cuptiMetricCreateEventGroupSets
 * a CUpti_EventGroupSets indicates the number of passes required to
 * collect all the events, and the event groups that should be
 * collected during each pass.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_EventGroupSets extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_EventGroupSets() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_EventGroupSets(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_EventGroupSets(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_EventGroupSets position(long position) {
        return (CUpti_EventGroupSets)super.position(position);
    }
    @Override public CUpti_EventGroupSets getPointer(long i) {
        return new CUpti_EventGroupSets((Pointer)this).offsetAddress(i);
    }

  /**
   * Number of event group sets.
   */
  public native @Cast("uint32_t") int numSets(); public native CUpti_EventGroupSets numSets(int setter);
  /**
   * An array of \p numSets event group sets.
   */
  public native CUpti_EventGroupSet sets(); public native CUpti_EventGroupSets sets(CUpti_EventGroupSet setter);
}
