// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief CUDA graphs data passed into a resource callback function.
 *
 * CUDA graphs data passed into a resource callback function as the \p cbdata
 * argument to \ref CUpti_CallbackFunc. The \p cbdata will be this
 * type for \p domain equal to CUPTI_CB_DOMAIN_RESOURCE. The graph
 * data is valid only within the invocation of the callback function
 * that is passed the data. If you need to retain some data for use
 * outside of the callback, you must make a copy of that data.
 */

@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_GraphData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_GraphData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_GraphData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_GraphData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_GraphData position(long position) {
        return (CUpti_GraphData)super.position(position);
    }
    @Override public CUpti_GraphData getPointer(long i) {
        return new CUpti_GraphData((Pointer)this).offsetAddress(i);
    }

  /**
   * CUDA graph
   */
    public native CUgraph_st graph(); public native CUpti_GraphData graph(CUgraph_st setter);
  /**
   * The original CUDA graph from which @param graph is cloned
   */
    public native CUgraph_st originalGraph(); public native CUpti_GraphData originalGraph(CUgraph_st setter);
  /**
   * CUDA graph node
   */
    public native CUgraphNode_st node(); public native CUpti_GraphData node(CUgraphNode_st setter);
  /**
   * The original CUDA graph node from which @param node is cloned
   */
    public native CUgraphNode_st originalNode(); public native CUpti_GraphData originalNode(CUgraphNode_st setter);
  /**
   * Type of the @param node
   */
    public native @Cast("CUgraphNodeType") int nodeType(); public native CUpti_GraphData nodeType(int setter);
  /**
   * The dependent graph node
   * The size of the array is @param numDependencies.
   */
    public native CUgraphNode_st dependency(); public native CUpti_GraphData dependency(CUgraphNode_st setter);
  /**
   * CUDA executable graph
   */
    public native CUgraphExec_st graphExec(); public native CUpti_GraphData graphExec(CUgraphExec_st setter);
}
