// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief Data passed into a resource callback function.
 *
 * Data passed into a resource callback function as the \p cbdata
 * argument to \ref CUpti_CallbackFunc. The \p cbdata will be this
 * type for \p domain equal to CUPTI_CB_DOMAIN_RESOURCE. The callback
 * data is valid only within the invocation of the callback function
 * that is passed the data. If you need to retain some data for use
 * outside of the callback, you must make a copy of that data.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ResourceData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ResourceData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ResourceData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ResourceData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ResourceData position(long position) {
        return (CUpti_ResourceData)super.position(position);
    }
    @Override public CUpti_ResourceData getPointer(long i) {
        return new CUpti_ResourceData((Pointer)this).offsetAddress(i);
    }

  /**
   * For CUPTI_CBID_RESOURCE_CONTEXT_CREATED and
   * CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING, the context being
   * created or destroyed. For CUPTI_CBID_RESOURCE_STREAM_CREATED and
   * CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING, the context
   * containing the stream being created or destroyed.
   */
  public native CUctx_st context(); public native CUpti_ResourceData context(CUctx_st setter);

    /**
     * For CUPTI_CBID_RESOURCE_STREAM_CREATED and
     * CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING, the stream being
     * created or destroyed.
     */
    @Name("resourceHandle.stream") public native CUstream_st resourceHandle_stream(); public native CUpti_ResourceData resourceHandle_stream(CUstream_st setter);

  /**
   * Reserved for future use.
   */
  public native Pointer resourceDescriptor(); public native CUpti_ResourceData resourceDescriptor(Pointer setter);
}
