// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief Data passed into a synchronize callback function.
 *
 * Data passed into a synchronize callback function as the \p cbdata
 * argument to \ref CUpti_CallbackFunc. The \p cbdata will be this
 * type for \p domain equal to CUPTI_CB_DOMAIN_SYNCHRONIZE. The
 * callback data is valid only within the invocation of the callback
 * function that is passed the data. If you need to retain some data
 * for use outside of the callback, you must make a copy of that data.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_SynchronizeData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_SynchronizeData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_SynchronizeData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_SynchronizeData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_SynchronizeData position(long position) {
        return (CUpti_SynchronizeData)super.position(position);
    }
    @Override public CUpti_SynchronizeData getPointer(long i) {
        return new CUpti_SynchronizeData((Pointer)this).offsetAddress(i);
    }

  /**
   * The context of the stream being synchronized.
   */
  public native CUctx_st context(); public native CUpti_SynchronizeData context(CUctx_st setter);
  /**
   * The stream being synchronized.
   */
  public native CUstream_st stream(); public native CUpti_SynchronizeData stream(CUstream_st setter);
}
