// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.cublas.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class cublas extends org.bytedeco.cuda.presets.cublas {
    static { Loader.load(); }

// Parsed from <cublas_api.h>

/*
 * Copyright 1993-2022 NVIDIA Corporation. All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 * This is the public header file for the CUBLAS library, defining the API
 *
 * CUBLAS is an implementation of BLAS (Basic Linear Algebra Subroutines)
 * on top of the CUDA runtime.
 */

// #if !defined(CUBLAS_API_H_)
// #define CUBLAS_API_H_

// #ifndef CUBLASWINAPI
// #ifdef _WIN32
// #define CUBLASWINAPI __stdcall
// #else
// #define CUBLASWINAPI
// #endif
// #endif

// #ifndef CUBLASAPI
// #error "This file should not be included without defining CUBLASAPI"
// #endif

// #include <stdint.h>

// #include "driver_types.h"
// #include "cuComplex.h" /* import complex data type */

// #include <cuda_fp16.h>
// #include <cuda_bf16.h>

// #include <library_types.h>

// #if defined(__cplusplus)
// #endif /* __cplusplus */

public static final int CUBLAS_VER_MAJOR = 12;
public static final int CUBLAS_VER_MINOR = 9;
public static final int CUBLAS_VER_PATCH = 1;
public static final int CUBLAS_VER_BUILD = 4;
public static final int CUBLAS_VERSION = (CUBLAS_VER_MAJOR * 10000 + CUBLAS_VER_MINOR * 100 + CUBLAS_VER_PATCH);

/* CUBLAS status type returns */
/** enum cublasStatus_t */
public static final int
  CUBLAS_STATUS_SUCCESS = 0,
  CUBLAS_STATUS_NOT_INITIALIZED = 1,
  CUBLAS_STATUS_ALLOC_FAILED = 3,
  CUBLAS_STATUS_INVALID_VALUE = 7,
  CUBLAS_STATUS_ARCH_MISMATCH = 8,
  CUBLAS_STATUS_MAPPING_ERROR = 11,
  CUBLAS_STATUS_EXECUTION_FAILED = 13,
  CUBLAS_STATUS_INTERNAL_ERROR = 14,
  CUBLAS_STATUS_NOT_SUPPORTED = 15,
  CUBLAS_STATUS_LICENSE_ERROR = 16;

/** enum cublasFillMode_t */
public static final int CUBLAS_FILL_MODE_LOWER = 0, CUBLAS_FILL_MODE_UPPER = 1, CUBLAS_FILL_MODE_FULL = 2;

/** enum cublasDiagType_t */
public static final int CUBLAS_DIAG_NON_UNIT = 0, CUBLAS_DIAG_UNIT = 1;

/** enum cublasSideMode_t */
public static final int CUBLAS_SIDE_LEFT = 0, CUBLAS_SIDE_RIGHT = 1;

/** enum cublasOperation_t */
public static final int
  CUBLAS_OP_N = 0,
  CUBLAS_OP_T = 1,
  CUBLAS_OP_C = 2,
  CUBLAS_OP_HERMITAN = 2, /* synonym if CUBLAS_OP_C */
  CUBLAS_OP_CONJG = 3;     /* conjugate, placeholder - not supported in the current release */

/** enum cublasPointerMode_t */
public static final int CUBLAS_POINTER_MODE_HOST = 0, CUBLAS_POINTER_MODE_DEVICE = 1;

/** enum cublasAtomicsMode_t */
public static final int CUBLAS_ATOMICS_NOT_ALLOWED = 0, CUBLAS_ATOMICS_ALLOWED = 1;

/* For specifying different GEMM algorithms */
/** enum cublasGemmAlgo_t */
public static final int
  CUBLAS_GEMM_DFALT = -1,
  CUBLAS_GEMM_DEFAULT = -1,
  CUBLAS_GEMM_ALGO0 = 0,
  CUBLAS_GEMM_ALGO1 = 1,
  CUBLAS_GEMM_ALGO2 = 2,
  CUBLAS_GEMM_ALGO3 = 3,
  CUBLAS_GEMM_ALGO4 = 4,
  CUBLAS_GEMM_ALGO5 = 5,
  CUBLAS_GEMM_ALGO6 = 6,
  CUBLAS_GEMM_ALGO7 = 7,
  CUBLAS_GEMM_ALGO8 = 8,
  CUBLAS_GEMM_ALGO9 = 9,
  CUBLAS_GEMM_ALGO10 = 10,
  CUBLAS_GEMM_ALGO11 = 11,
  CUBLAS_GEMM_ALGO12 = 12,
  CUBLAS_GEMM_ALGO13 = 13,
  CUBLAS_GEMM_ALGO14 = 14,
  CUBLAS_GEMM_ALGO15 = 15,
  CUBLAS_GEMM_ALGO16 = 16,
  CUBLAS_GEMM_ALGO17 = 17,
  CUBLAS_GEMM_ALGO18 = 18,  // sliced 32x32
  CUBLAS_GEMM_ALGO19 = 19,  // sliced 64x32
  CUBLAS_GEMM_ALGO20 = 20,  // sliced 128x32
  CUBLAS_GEMM_ALGO21 = 21,  // sliced 32x32  -splitK
  CUBLAS_GEMM_ALGO22 = 22,  // sliced 64x32  -splitK
  CUBLAS_GEMM_ALGO23 = 23,  // sliced 128x32 -splitK
  CUBLAS_GEMM_DEFAULT_TENSOR_OP = 99,
  CUBLAS_GEMM_DFALT_TENSOR_OP = 99,
  CUBLAS_GEMM_ALGO0_TENSOR_OP = 100,
  CUBLAS_GEMM_ALGO1_TENSOR_OP = 101,
  CUBLAS_GEMM_ALGO2_TENSOR_OP = 102,
  CUBLAS_GEMM_ALGO3_TENSOR_OP = 103,
  CUBLAS_GEMM_ALGO4_TENSOR_OP = 104,
  CUBLAS_GEMM_ALGO5_TENSOR_OP = 105,
  CUBLAS_GEMM_ALGO6_TENSOR_OP = 106,
  CUBLAS_GEMM_ALGO7_TENSOR_OP = 107,
  CUBLAS_GEMM_ALGO8_TENSOR_OP = 108,
  CUBLAS_GEMM_ALGO9_TENSOR_OP = 109,
  CUBLAS_GEMM_ALGO10_TENSOR_OP = 110,
  CUBLAS_GEMM_ALGO11_TENSOR_OP = 111,
  CUBLAS_GEMM_ALGO12_TENSOR_OP = 112,
  CUBLAS_GEMM_ALGO13_TENSOR_OP = 113,
  CUBLAS_GEMM_ALGO14_TENSOR_OP = 114,
  CUBLAS_GEMM_ALGO15_TENSOR_OP = 115;

/* Enum for default math mode/tensor operation */
/** enum cublasMath_t */
public static final int
  CUBLAS_DEFAULT_MATH = 0,

  /* deprecated, same effect as using CUBLAS_COMPUTE_32F_FAST_16F, will be removed in a future release */
  CUBLAS_TENSOR_OP_MATH = 1,

  /* same as using matching _PEDANTIC compute type when using cublas<T>routine calls or cublasEx() calls with
     cudaDataType as compute type */
  CUBLAS_PEDANTIC_MATH = 2,

  /* allow accelerating single precision routines using TF32 tensor cores */
  CUBLAS_TF32_TENSOR_OP_MATH = 3,

  /* allow accelerating single precision routines using the BF16x9 algorithm */
  CUBLAS_FP32_EMULATED_BF16X9_MATH = 4,

  /* flag to force any reductons to use the accumulator type and not output type in case of mixed precision routines
     with lower size output type */
  CUBLAS_MATH_DISALLOW_REDUCED_PRECISION_REDUCTION = 16;

/* For backward compatibility purposes */

/* Enum for compute type
 *
 * - default types provide best available performance using all available hardware features
 *   and guarantee internal storage precision with at least the same precision and range;
 * - _PEDANTIC types ensure standard arithmetic and exact specified internal storage format;
 * - _FAST types allow for some loss of precision to enable higher throughput arithmetic.
 */
/** enum cublasComputeType_t */
public static final int
  CUBLAS_COMPUTE_16F = 64,                 /* half - default */
  CUBLAS_COMPUTE_16F_PEDANTIC = 65,        /* half - pedantic */
  CUBLAS_COMPUTE_32F = 68,                 /* float - default */
  CUBLAS_COMPUTE_32F_PEDANTIC = 69,        /* float - pedantic */
  CUBLAS_COMPUTE_32F_FAST_16F = 74,        /* float - fast, allows down-converting inputs to half or TF32 */
  CUBLAS_COMPUTE_32F_FAST_16BF = 75,       /* float - fast, allows down-converting inputs to bfloat16 or TF32 */
  CUBLAS_COMPUTE_32F_FAST_TF32 = 77,       /* float - fast, allows down-converting inputs to TF32 */
  CUBLAS_COMPUTE_32F_EMULATED_16BFX9 = 78, /* float - emulated, converts inputs into 3xBF16 values */
  CUBLAS_COMPUTE_64F = 70,                 /* double - default */
  CUBLAS_COMPUTE_64F_PEDANTIC = 71,        /* double - pedantic */
  CUBLAS_COMPUTE_32I = 72,                 /* signed 32-bit int - default */
  CUBLAS_COMPUTE_32I_PEDANTIC = 73;        /* signed 32-bit int - pedantic */

/* Enum for specifying how to leverage emulated algorithms */
/** enum cublasEmulationStrategy_t */
public static final int
  /* The default emulation strategy.  For emulated computations, this is equivalent to
   * CUBLAS_EMULATION_STRATEGY_PERFORMANT unless the CUBLAS_EMULATION_STRATEGY environment variable is set.
   */
  CUBLAS_EMULATION_STRATEGY_DEFAULT = 0,

  /* An emulation strategy which tells cuBLAS to use emulation when it provides a performance benefit */
  CUBLAS_EMULATION_STRATEGY_PERFORMANT = 1,

  /* An emulation strategy which tells cuBLAS to use emulation whenever possible */
  CUBLAS_EMULATION_STRATEGY_EAGER = 2;
// Targeting ..\cublas\cublasContext.java


// Targeting ..\cublas\cublasLogCallback.java



/* cuBLAS Exported API {{{ */

/* --------------- CUBLAS Helper Functions  ---------------- */

public static native @Cast("cublasStatus_t") int cublasCreate_v2(@ByPtrPtr cublasContext handle);

public static native @Cast("cublasStatus_t") int cublasDestroy_v2(cublasContext handle);

public static native @Cast("cublasStatus_t") int cublasGetVersion_v2(cublasContext handle, IntPointer version);
public static native @Cast("cublasStatus_t") int cublasGetVersion_v2(cublasContext handle, IntBuffer version);
public static native @Cast("cublasStatus_t") int cublasGetVersion_v2(cublasContext handle, int[] version);

public static native @Cast("cublasStatus_t") int cublasGetProperty(@Cast("libraryPropertyType") int type, IntPointer value);
public static native @Cast("cublasStatus_t") int cublasGetProperty(@Cast("libraryPropertyType") int type, IntBuffer value);
public static native @Cast("cublasStatus_t") int cublasGetProperty(@Cast("libraryPropertyType") int type, int[] value);

public static native @Cast("size_t") long cublasGetCudartVersion();

public static native @Cast("cublasStatus_t") int cublasSetWorkspace_v2(cublasContext handle,
                                                            Pointer workspace,
                                                            @Cast("size_t") long workspaceSizeInBytes);

public static native @Cast("cublasStatus_t") int cublasSetStream_v2(cublasContext handle, CUstream_st streamId);

public static native @Cast("cublasStatus_t") int cublasGetStream_v2(cublasContext handle, @ByPtrPtr CUstream_st streamId);

public static native @Cast("cublasStatus_t") int cublasGetPointerMode_v2(cublasContext handle, @Cast("cublasPointerMode_t*") IntPointer mode);
public static native @Cast("cublasStatus_t") int cublasGetPointerMode_v2(cublasContext handle, @Cast("cublasPointerMode_t*") IntBuffer mode);
public static native @Cast("cublasStatus_t") int cublasGetPointerMode_v2(cublasContext handle, @Cast("cublasPointerMode_t*") int[] mode);

public static native @Cast("cublasStatus_t") int cublasSetPointerMode_v2(cublasContext handle, @Cast("cublasPointerMode_t") int mode);

public static native @Cast("cublasStatus_t") int cublasGetAtomicsMode(cublasContext handle, @Cast("cublasAtomicsMode_t*") IntPointer mode);
public static native @Cast("cublasStatus_t") int cublasGetAtomicsMode(cublasContext handle, @Cast("cublasAtomicsMode_t*") IntBuffer mode);
public static native @Cast("cublasStatus_t") int cublasGetAtomicsMode(cublasContext handle, @Cast("cublasAtomicsMode_t*") int[] mode);

public static native @Cast("cublasStatus_t") int cublasSetAtomicsMode(cublasContext handle, @Cast("cublasAtomicsMode_t") int mode);

public static native @Cast("cublasStatus_t") int cublasGetMathMode(cublasContext handle, @Cast("cublasMath_t*") IntPointer mode);
public static native @Cast("cublasStatus_t") int cublasGetMathMode(cublasContext handle, @Cast("cublasMath_t*") IntBuffer mode);
public static native @Cast("cublasStatus_t") int cublasGetMathMode(cublasContext handle, @Cast("cublasMath_t*") int[] mode);

public static native @Cast("cublasStatus_t") int cublasSetMathMode(cublasContext handle, @Cast("cublasMath_t") int mode);

public static native @Cast("cublasStatus_t") int cublasGetSmCountTarget(cublasContext handle, IntPointer smCountTarget);
public static native @Cast("cublasStatus_t") int cublasGetSmCountTarget(cublasContext handle, IntBuffer smCountTarget);
public static native @Cast("cublasStatus_t") int cublasGetSmCountTarget(cublasContext handle, int[] smCountTarget);

public static native @Cast("cublasStatus_t") int cublasSetSmCountTarget(cublasContext handle, int smCountTarget);

public static native @Cast("cublasStatus_t") int cublasGetEmulationStrategy(cublasContext handle,
                                                                 @Cast("cublasEmulationStrategy_t*") IntPointer emulationStrategy);
public static native @Cast("cublasStatus_t") int cublasGetEmulationStrategy(cublasContext handle,
                                                                 @Cast("cublasEmulationStrategy_t*") IntBuffer emulationStrategy);
public static native @Cast("cublasStatus_t") int cublasGetEmulationStrategy(cublasContext handle,
                                                                 @Cast("cublasEmulationStrategy_t*") int[] emulationStrategy);

public static native @Cast("cublasStatus_t") int cublasSetEmulationStrategy(cublasContext handle,
                                                                 @Cast("cublasEmulationStrategy_t") int emulationStrategy);

public static native @Cast("const char*") BytePointer cublasGetStatusName(@Cast("cublasStatus_t") int status);

public static native @Cast("const char*") BytePointer cublasGetStatusString(@Cast("cublasStatus_t") int status);

public static native @Cast("cublasStatus_t") int cublasLoggerConfigure(int logIsOn,
                                                            int logToStdOut,
                                                            int logToStdErr,
                                                            @Cast("const char*") BytePointer logFileName);
public static native @Cast("cublasStatus_t") int cublasLoggerConfigure(int logIsOn,
                                                            int logToStdOut,
                                                            int logToStdErr,
                                                            String logFileName);

public static native @Cast("cublasStatus_t") int cublasSetLoggerCallback(cublasLogCallback userCallback);

public static native @Cast("cublasStatus_t") int cublasGetLoggerCallback(@ByPtrPtr cublasLogCallback userCallback);

public static native @Cast("cublasStatus_t") int cublasSetVector(int n, int elemSize, @Const Pointer x, int incx, Pointer devicePtr, int incy);

public static native @Cast("cublasStatus_t") int cublasSetVector_64(@Cast("int64_t") long n, @Cast("int64_t") long elemSize, @Const Pointer x, @Cast("int64_t") long incx, Pointer devicePtr, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasGetVector(int n, int elemSize, @Const Pointer x, int incx, Pointer y, int incy);

public static native @Cast("cublasStatus_t") int cublasGetVector_64(@Cast("int64_t") long n, @Cast("int64_t") long elemSize, @Const Pointer x, @Cast("int64_t") long incx, Pointer y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasSetMatrix(int rows, int cols, int elemSize, @Const Pointer A, int lda, Pointer B, int ldb);

public static native @Cast("cublasStatus_t") int cublasSetMatrix_64(@Cast("int64_t") long rows, @Cast("int64_t") long cols, @Cast("int64_t") long elemSize, @Const Pointer A, @Cast("int64_t") long lda, Pointer B, @Cast("int64_t") long ldb);

public static native @Cast("cublasStatus_t") int cublasGetMatrix(int rows, int cols, int elemSize, @Const Pointer A, int lda, Pointer B, int ldb);

public static native @Cast("cublasStatus_t") int cublasGetMatrix_64(@Cast("int64_t") long rows, @Cast("int64_t") long cols, @Cast("int64_t") long elemSize, @Const Pointer A, @Cast("int64_t") long lda, Pointer B, @Cast("int64_t") long ldb);

public static native @Cast("cublasStatus_t") int cublasSetVectorAsync(
    int n, int elemSize, @Const Pointer hostPtr, int incx, Pointer devicePtr, int incy, CUstream_st stream);

public static native @Cast("cublasStatus_t") int cublasSetVectorAsync_64(
    @Cast("int64_t") long n, @Cast("int64_t") long elemSize, @Const Pointer hostPtr, @Cast("int64_t") long incx, Pointer devicePtr, @Cast("int64_t") long incy, CUstream_st stream);

public static native @Cast("cublasStatus_t") int cublasGetVectorAsync(
    int n, int elemSize, @Const Pointer devicePtr, int incx, Pointer hostPtr, int incy, CUstream_st stream);

public static native @Cast("cublasStatus_t") int cublasGetVectorAsync_64(
    @Cast("int64_t") long n, @Cast("int64_t") long elemSize, @Const Pointer devicePtr, @Cast("int64_t") long incx, Pointer hostPtr, @Cast("int64_t") long incy, CUstream_st stream);

public static native @Cast("cublasStatus_t") int cublasSetMatrixAsync(int rows, int cols, int elemSize, @Const Pointer A, int lda, Pointer B, int ldb, CUstream_st stream);

public static native @Cast("cublasStatus_t") int cublasSetMatrixAsync_64(@Cast("int64_t") long rows,
                                                    @Cast("int64_t") long cols,
                                                    @Cast("int64_t") long elemSize,
                                                    @Const Pointer A,
                                                    @Cast("int64_t") long lda,
                                                    Pointer B,
                                                    @Cast("int64_t") long ldb,
                                                    CUstream_st stream);

public static native @Cast("cublasStatus_t") int cublasGetMatrixAsync(int rows, int cols, int elemSize, @Const Pointer A, int lda, Pointer B, int ldb, CUstream_st stream);

public static native @Cast("cublasStatus_t") int cublasGetMatrixAsync_64(@Cast("int64_t") long rows,
                                                    @Cast("int64_t") long cols,
                                                    @Cast("int64_t") long elemSize,
                                                    @Const Pointer A,
                                                    @Cast("int64_t") long lda,
                                                    Pointer B,
                                                    @Cast("int64_t") long ldb,
                                                    CUstream_st stream);

public static native void cublasXerbla(@Cast("const char*") BytePointer srName, int info);
public static native void cublasXerbla(String srName, int info);

/* --------------- CUBLAS BLAS1 Functions  ---------------- */

public static native @Cast("cublasStatus_t") int cublasNrm2Ex(cublasContext handle,
                                                   int n,
                                                   @Const Pointer x,
                                                   @Cast("cudaDataType") int xType,
                                                   int incx,
                                                   Pointer result,
                                                   @Cast("cudaDataType") int resultType,
                                                   @Cast("cudaDataType") int executionType);

public static native @Cast("cublasStatus_t") int cublasNrm2Ex_64(cublasContext handle,
                                                      @Cast("int64_t") long n,
                                                      @Const Pointer x,
                                                      @Cast("cudaDataType") int xType,
                                                      @Cast("int64_t") long incx,
                                                      Pointer result,
                                                      @Cast("cudaDataType") int resultType,
                                                      @Cast("cudaDataType") int executionType);

public static native @Cast("cublasStatus_t") int cublasSnrm2_v2(cublasContext handle, int n, @Const FloatPointer x, int incx, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasSnrm2_v2(cublasContext handle, int n, @Const FloatBuffer x, int incx, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasSnrm2_v2(cublasContext handle, int n, @Const float[] x, int incx, float[] result);

public static native @Cast("cublasStatus_t") int cublasSnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer x, @Cast("int64_t") long incx, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasSnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer x, @Cast("int64_t") long incx, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasSnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const float[] x, @Cast("int64_t") long incx, float[] result);

public static native @Cast("cublasStatus_t") int cublasDnrm2_v2(cublasContext handle, int n, @Const DoublePointer x, int incx, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDnrm2_v2(cublasContext handle, int n, @Const DoubleBuffer x, int incx, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDnrm2_v2(cublasContext handle, int n, @Const double[] x, int incx, double[] result);

public static native @Cast("cublasStatus_t") int cublasDnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer x, @Cast("int64_t") long incx, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer x, @Cast("int64_t") long incx, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const double[] x, @Cast("int64_t") long incx, double[] result);

public static native @Cast("cublasStatus_t") int cublasScnrm2_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasScnrm2_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasScnrm2_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, float[] result);

public static native @Cast("cublasStatus_t") int cublasScnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasScnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasScnrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, float[] result);

public static native @Cast("cublasStatus_t") int cublasDznrm2_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDznrm2_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDznrm2_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, double[] result);

public static native @Cast("cublasStatus_t") int cublasDznrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDznrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDznrm2_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, double[] result);

public static native @Cast("cublasStatus_t") int cublasDotEx(cublasContext handle,
                                                  int n,
                                                  @Const Pointer x,
                                                  @Cast("cudaDataType") int xType,
                                                  int incx,
                                                  @Const Pointer y,
                                                  @Cast("cudaDataType") int yType,
                                                  int incy,
                                                  Pointer result,
                                                  @Cast("cudaDataType") int resultType,
                                                  @Cast("cudaDataType") int executionType);

public static native @Cast("cublasStatus_t") int cublasDotEx_64(cublasContext handle,
                                                     @Cast("int64_t") long n,
                                                     @Const Pointer x,
                                                     @Cast("cudaDataType") int xType,
                                                     @Cast("int64_t") long incx,
                                                     @Const Pointer y,
                                                     @Cast("cudaDataType") int yType,
                                                     @Cast("int64_t") long incy,
                                                     Pointer result,
                                                     @Cast("cudaDataType") int resultType,
                                                     @Cast("cudaDataType") int executionType);

public static native @Cast("cublasStatus_t") int cublasDotcEx(cublasContext handle,
                                                   int n,
                                                   @Const Pointer x,
                                                   @Cast("cudaDataType") int xType,
                                                   int incx,
                                                   @Const Pointer y,
                                                   @Cast("cudaDataType") int yType,
                                                   int incy,
                                                   Pointer result,
                                                   @Cast("cudaDataType") int resultType,
                                                   @Cast("cudaDataType") int executionType);

public static native @Cast("cublasStatus_t") int cublasDotcEx_64(cublasContext handle,
                                                      @Cast("int64_t") long n,
                                                      @Const Pointer x,
                                                      @Cast("cudaDataType") int xType,
                                                      @Cast("int64_t") long incx,
                                                      @Const Pointer y,
                                                      @Cast("cudaDataType") int yType,
                                                      @Cast("int64_t") long incy,
                                                      Pointer result,
                                                      @Cast("cudaDataType") int resultType,
                                                      @Cast("cudaDataType") int executionType);

public static native @Cast("cublasStatus_t") int cublasSdot_v2(cublasContext handle, int n, @Const FloatPointer x, int incx, @Const FloatPointer y, int incy, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasSdot_v2(cublasContext handle, int n, @Const FloatBuffer x, int incx, @Const FloatBuffer y, int incy, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasSdot_v2(cublasContext handle, int n, @Const float[] x, int incx, @Const float[] y, int incy, float[] result);

public static native @Cast("cublasStatus_t") int cublasSdot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer x, @Cast("int64_t") long incx, @Const FloatPointer y, @Cast("int64_t") long incy, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasSdot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer x, @Cast("int64_t") long incx, @Const FloatBuffer y, @Cast("int64_t") long incy, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasSdot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const float[] x, @Cast("int64_t") long incx, @Const float[] y, @Cast("int64_t") long incy, float[] result);

public static native @Cast("cublasStatus_t") int cublasDdot_v2(cublasContext handle, int n, @Const DoublePointer x, int incx, @Const DoublePointer y, int incy, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDdot_v2(cublasContext handle, int n, @Const DoubleBuffer x, int incx, @Const DoubleBuffer y, int incy, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDdot_v2(cublasContext handle, int n, @Const double[] x, int incx, @Const double[] y, int incy, double[] result);

public static native @Cast("cublasStatus_t") int cublasDdot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer x, @Cast("int64_t") long incx, @Const DoublePointer y, @Cast("int64_t") long incy, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDdot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer x, @Cast("int64_t") long incx, @Const DoubleBuffer y, @Cast("int64_t") long incy, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDdot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const double[] x, @Cast("int64_t") long incx, @Const double[] y, @Cast("int64_t") long incy, double[] result);

public static native @Cast("cublasStatus_t") int cublasCdotu_v2(
    cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, @Cast("const cuComplex*") float2 y, int incy, @Cast("cuComplex*") float2 result);

public static native @Cast("cublasStatus_t") int cublasCdotu_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuComplex*") float2 result);

public static native @Cast("cublasStatus_t") int cublasCdotc_v2(
    cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, @Cast("const cuComplex*") float2 y, int incy, @Cast("cuComplex*") float2 result);

public static native @Cast("cublasStatus_t") int cublasCdotc_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuComplex*") float2 result);

public static native @Cast("cublasStatus_t") int cublasZdotu_v2(cublasContext handle,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Cast("cuDoubleComplex*") double2 result);

public static native @Cast("cublasStatus_t") int cublasZdotu_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuDoubleComplex*") double2 result);

public static native @Cast("cublasStatus_t") int cublasZdotc_v2(cublasContext handle,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Cast("cuDoubleComplex*") double2 result);

public static native @Cast("cublasStatus_t") int cublasZdotc_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuDoubleComplex*") double2 result);

public static native @Cast("cublasStatus_t") int cublasScalEx(cublasContext handle,
                                                   int n,
                                                   @Const Pointer alpha,
                                                   @Cast("cudaDataType") int alphaType,
                                                   Pointer x,
                                                   @Cast("cudaDataType") int xType,
                                                   int incx,
                                                   @Cast("cudaDataType") int executionType);

public static native @Cast("cublasStatus_t") int cublasScalEx_64(cublasContext handle,
                                                      @Cast("int64_t") long n,
                                                      @Const Pointer alpha,
                                                      @Cast("cudaDataType") int alphaType,
                                                      Pointer x,
                                                      @Cast("cudaDataType") int xType,
                                                      @Cast("int64_t") long incx,
                                                      @Cast("cudaDataType") int executionType);

public static native @Cast("cublasStatus_t") int cublasSscal_v2(cublasContext handle, int n, @Const FloatPointer alpha, FloatPointer x, int incx);
public static native @Cast("cublasStatus_t") int cublasSscal_v2(cublasContext handle, int n, @Const FloatBuffer alpha, FloatBuffer x, int incx);
public static native @Cast("cublasStatus_t") int cublasSscal_v2(cublasContext handle, int n, @Const float[] alpha, float[] x, int incx);

public static native @Cast("cublasStatus_t") int cublasSscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer alpha, FloatPointer x, @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasSscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer alpha, FloatBuffer x, @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasSscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const float[] alpha, float[] x, @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasDscal_v2(cublasContext handle, int n, @Const DoublePointer alpha, DoublePointer x, int incx);
public static native @Cast("cublasStatus_t") int cublasDscal_v2(cublasContext handle, int n, @Const DoubleBuffer alpha, DoubleBuffer x, int incx);
public static native @Cast("cublasStatus_t") int cublasDscal_v2(cublasContext handle, int n, @Const double[] alpha, double[] x, int incx);

public static native @Cast("cublasStatus_t") int cublasDscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer alpha, DoublePointer x, @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer alpha, DoubleBuffer x, @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const double[] alpha, double[] x, @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasCscal_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 alpha, @Cast("cuComplex*") float2 x, int incx);

public static native @Cast("cublasStatus_t") int cublasCscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 alpha, @Cast("cuComplex*") float2 x, @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasCsscal_v2(cublasContext handle, int n, @Const FloatPointer alpha, @Cast("cuComplex*") float2 x, int incx);
public static native @Cast("cublasStatus_t") int cublasCsscal_v2(cublasContext handle, int n, @Const FloatBuffer alpha, @Cast("cuComplex*") float2 x, int incx);
public static native @Cast("cublasStatus_t") int cublasCsscal_v2(cublasContext handle, int n, @Const float[] alpha, @Cast("cuComplex*") float2 x, int incx);

public static native @Cast("cublasStatus_t") int cublasCsscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer alpha, @Cast("cuComplex*") float2 x, @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasCsscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer alpha, @Cast("cuComplex*") float2 x, @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasCsscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const float[] alpha, @Cast("cuComplex*") float2 x, @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasZscal_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("cuDoubleComplex*") double2 x, int incx);

public static native @Cast("cublasStatus_t") int cublasZscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("cuDoubleComplex*") double2 x, @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasZdscal_v2(cublasContext handle, int n, @Const DoublePointer alpha, @Cast("cuDoubleComplex*") double2 x, int incx);
public static native @Cast("cublasStatus_t") int cublasZdscal_v2(cublasContext handle, int n, @Const DoubleBuffer alpha, @Cast("cuDoubleComplex*") double2 x, int incx);
public static native @Cast("cublasStatus_t") int cublasZdscal_v2(cublasContext handle, int n, @Const double[] alpha, @Cast("cuDoubleComplex*") double2 x, int incx);

public static native @Cast("cublasStatus_t") int cublasZdscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer alpha, @Cast("cuDoubleComplex*") double2 x, @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasZdscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer alpha, @Cast("cuDoubleComplex*") double2 x, @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasZdscal_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const double[] alpha, @Cast("cuDoubleComplex*") double2 x, @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasAxpyEx(cublasContext handle,
                                                   int n,
                                                   @Const Pointer alpha,
                                                   @Cast("cudaDataType") int alphaType,
                                                   @Const Pointer x,
                                                   @Cast("cudaDataType") int xType,
                                                   int incx,
                                                   Pointer y,
                                                   @Cast("cudaDataType") int yType,
                                                   int incy,
                                                   @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasAxpyEx_64(cublasContext handle,
                                                      @Cast("int64_t") long n,
                                                      @Const Pointer alpha,
                                                      @Cast("cudaDataType") int alphaType,
                                                      @Const Pointer x,
                                                      @Cast("cudaDataType") int xType,
                                                      @Cast("int64_t") long incx,
                                                      Pointer y,
                                                      @Cast("cudaDataType") int yType,
                                                      @Cast("int64_t") long incy,
                                                      @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasSaxpy_v2(cublasContext handle, int n, @Const FloatPointer alpha, @Const FloatPointer x, int incx, FloatPointer y, int incy);
public static native @Cast("cublasStatus_t") int cublasSaxpy_v2(cublasContext handle, int n, @Const FloatBuffer alpha, @Const FloatBuffer x, int incx, FloatBuffer y, int incy);
public static native @Cast("cublasStatus_t") int cublasSaxpy_v2(cublasContext handle, int n, @Const float[] alpha, @Const float[] x, int incx, float[] y, int incy);

public static native @Cast("cublasStatus_t") int cublasSaxpy_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer alpha, @Const FloatPointer x, @Cast("int64_t") long incx, FloatPointer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSaxpy_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer alpha, @Const FloatBuffer x, @Cast("int64_t") long incx, FloatBuffer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSaxpy_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const float[] alpha, @Const float[] x, @Cast("int64_t") long incx, float[] y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasDaxpy_v2(cublasContext handle, int n, @Const DoublePointer alpha, @Const DoublePointer x, int incx, DoublePointer y, int incy);
public static native @Cast("cublasStatus_t") int cublasDaxpy_v2(cublasContext handle, int n, @Const DoubleBuffer alpha, @Const DoubleBuffer x, int incx, DoubleBuffer y, int incy);
public static native @Cast("cublasStatus_t") int cublasDaxpy_v2(cublasContext handle, int n, @Const double[] alpha, @Const double[] x, int incx, double[] y, int incy);

public static native @Cast("cublasStatus_t") int cublasDaxpy_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer alpha, @Const DoublePointer x, @Cast("int64_t") long incx, DoublePointer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDaxpy_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer alpha, @Const DoubleBuffer x, @Cast("int64_t") long incx, DoubleBuffer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDaxpy_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Const double[] alpha, @Const double[] x, @Cast("int64_t") long incx, double[] y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasCaxpy_v2(
    cublasContext handle, int n, @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy);

public static native @Cast("cublasStatus_t") int cublasCaxpy_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZaxpy_v2(cublasContext handle,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasZaxpy_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasCopyEx(
    cublasContext handle, int n, @Const Pointer x, @Cast("cudaDataType") int xType, int incx, Pointer y, @Cast("cudaDataType") int yType, int incy);

public static native @Cast("cublasStatus_t") int cublasCopyEx_64(cublasContext handle,
                                                      @Cast("int64_t") long n,
                                                      @Const Pointer x,
                                                      @Cast("cudaDataType") int xType,
                                                      @Cast("int64_t") long incx,
                                                      Pointer y,
                                                      @Cast("cudaDataType") int yType,
                                                      @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasScopy_v2(cublasContext handle, int n, @Const FloatPointer x, int incx, FloatPointer y, int incy);
public static native @Cast("cublasStatus_t") int cublasScopy_v2(cublasContext handle, int n, @Const FloatBuffer x, int incx, FloatBuffer y, int incy);
public static native @Cast("cublasStatus_t") int cublasScopy_v2(cublasContext handle, int n, @Const float[] x, int incx, float[] y, int incy);

public static native @Cast("cublasStatus_t") int cublasScopy_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer x, @Cast("int64_t") long incx, FloatPointer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasScopy_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer x, @Cast("int64_t") long incx, FloatBuffer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasScopy_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const float[] x, @Cast("int64_t") long incx, float[] y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasDcopy_v2(cublasContext handle, int n, @Const DoublePointer x, int incx, DoublePointer y, int incy);
public static native @Cast("cublasStatus_t") int cublasDcopy_v2(cublasContext handle, int n, @Const DoubleBuffer x, int incx, DoubleBuffer y, int incy);
public static native @Cast("cublasStatus_t") int cublasDcopy_v2(cublasContext handle, int n, @Const double[] x, int incx, double[] y, int incy);

public static native @Cast("cublasStatus_t") int cublasDcopy_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer x, @Cast("int64_t") long incx, DoublePointer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDcopy_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer x, @Cast("int64_t") long incx, DoubleBuffer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDcopy_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const double[] x, @Cast("int64_t") long incx, double[] y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasCcopy_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy);

public static native @Cast("cublasStatus_t") int cublasCcopy_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, @Cast("cuComplex*") float2 y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZcopy_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 y, int incy);

public static native @Cast("cublasStatus_t") int cublasZcopy_v2_64(
    cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, @Cast("cuDoubleComplex*") double2 y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasSswap_v2(cublasContext handle, int n, FloatPointer x, int incx, FloatPointer y, int incy);
public static native @Cast("cublasStatus_t") int cublasSswap_v2(cublasContext handle, int n, FloatBuffer x, int incx, FloatBuffer y, int incy);
public static native @Cast("cublasStatus_t") int cublasSswap_v2(cublasContext handle, int n, float[] x, int incx, float[] y, int incy);

public static native @Cast("cublasStatus_t") int cublasSswap_v2_64(cublasContext handle, @Cast("int64_t") long n, FloatPointer x, @Cast("int64_t") long incx, FloatPointer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSswap_v2_64(cublasContext handle, @Cast("int64_t") long n, FloatBuffer x, @Cast("int64_t") long incx, FloatBuffer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSswap_v2_64(cublasContext handle, @Cast("int64_t") long n, float[] x, @Cast("int64_t") long incx, float[] y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasDswap_v2(cublasContext handle, int n, DoublePointer x, int incx, DoublePointer y, int incy);
public static native @Cast("cublasStatus_t") int cublasDswap_v2(cublasContext handle, int n, DoubleBuffer x, int incx, DoubleBuffer y, int incy);
public static native @Cast("cublasStatus_t") int cublasDswap_v2(cublasContext handle, int n, double[] x, int incx, double[] y, int incy);

public static native @Cast("cublasStatus_t") int cublasDswap_v2_64(cublasContext handle, @Cast("int64_t") long n, DoublePointer x, @Cast("int64_t") long incx, DoublePointer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDswap_v2_64(cublasContext handle, @Cast("int64_t") long n, DoubleBuffer x, @Cast("int64_t") long incx, DoubleBuffer y, @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDswap_v2_64(cublasContext handle, @Cast("int64_t") long n, double[] x, @Cast("int64_t") long incx, double[] y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasCswap_v2(cublasContext handle, int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy);

public static native @Cast("cublasStatus_t") int cublasCswap_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("cuComplex*") float2 x, @Cast("int64_t") long incx, @Cast("cuComplex*") float2 y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZswap_v2(cublasContext handle, int n, @Cast("cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 y, int incy);

public static native @Cast("cublasStatus_t") int cublasZswap_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, @Cast("cuDoubleComplex*") double2 y, @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasSwapEx(
    cublasContext handle, int n, Pointer x, @Cast("cudaDataType") int xType, int incx, Pointer y, @Cast("cudaDataType") int yType, int incy);

public static native @Cast("cublasStatus_t") int cublasSwapEx_64(cublasContext handle,
                                                      @Cast("int64_t") long n,
                                                      Pointer x,
                                                      @Cast("cudaDataType") int xType,
                                                      @Cast("int64_t") long incx,
                                                      Pointer y,
                                                      @Cast("cudaDataType") int yType,
                                                      @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasIsamax_v2(cublasContext handle, int n, @Const FloatPointer x, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIsamax_v2(cublasContext handle, int n, @Const FloatBuffer x, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIsamax_v2(cublasContext handle, int n, @Const float[] x, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIsamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer x, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIsamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer x, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIsamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const float[] x, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIdamax_v2(cublasContext handle, int n, @Const DoublePointer x, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIdamax_v2(cublasContext handle, int n, @Const DoubleBuffer x, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIdamax_v2(cublasContext handle, int n, @Const double[] x, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIdamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer x, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIdamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer x, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIdamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const double[] x, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIcamax_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIcamax_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIcamax_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIcamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIcamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIcamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIzamax_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIzamax_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIzamax_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIzamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIzamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIzamax_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIamaxEx(cublasContext handle, int n, @Const Pointer x, @Cast("cudaDataType") int xType, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIamaxEx(cublasContext handle, int n, @Const Pointer x, @Cast("cudaDataType") int xType, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIamaxEx(cublasContext handle, int n, @Const Pointer x, @Cast("cudaDataType") int xType, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIamaxEx_64(cublasContext handle, @Cast("int64_t") long n, @Const Pointer x, @Cast("cudaDataType") int xType, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIamaxEx_64(cublasContext handle, @Cast("int64_t") long n, @Const Pointer x, @Cast("cudaDataType") int xType, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIamaxEx_64(cublasContext handle, @Cast("int64_t") long n, @Const Pointer x, @Cast("cudaDataType") int xType, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIsamin_v2(cublasContext handle, int n, @Const FloatPointer x, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIsamin_v2(cublasContext handle, int n, @Const FloatBuffer x, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIsamin_v2(cublasContext handle, int n, @Const float[] x, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIsamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer x, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIsamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer x, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIsamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const float[] x, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIdamin_v2(cublasContext handle, int n, @Const DoublePointer x, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIdamin_v2(cublasContext handle, int n, @Const DoubleBuffer x, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIdamin_v2(cublasContext handle, int n, @Const double[] x, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIdamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer x, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIdamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer x, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIdamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const double[] x, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIcamin_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIcamin_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIcamin_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIcamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIcamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIcamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIzamin_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIzamin_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIzamin_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIzamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIzamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIzamin_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasIaminEx(cublasContext handle, int n, @Const Pointer x, @Cast("cudaDataType") int xType, int incx, IntPointer result);
public static native @Cast("cublasStatus_t") int cublasIaminEx(cublasContext handle, int n, @Const Pointer x, @Cast("cudaDataType") int xType, int incx, IntBuffer result);
public static native @Cast("cublasStatus_t") int cublasIaminEx(cublasContext handle, int n, @Const Pointer x, @Cast("cudaDataType") int xType, int incx, int[] result);

public static native @Cast("cublasStatus_t") int cublasIaminEx_64(cublasContext handle, @Cast("int64_t") long n, @Const Pointer x, @Cast("cudaDataType") int xType, @Cast("int64_t") long incx, @Cast("int64_t*") LongPointer result);
public static native @Cast("cublasStatus_t") int cublasIaminEx_64(cublasContext handle, @Cast("int64_t") long n, @Const Pointer x, @Cast("cudaDataType") int xType, @Cast("int64_t") long incx, @Cast("int64_t*") LongBuffer result);
public static native @Cast("cublasStatus_t") int cublasIaminEx_64(cublasContext handle, @Cast("int64_t") long n, @Const Pointer x, @Cast("cudaDataType") int xType, @Cast("int64_t") long incx, @Cast("int64_t*") long[] result);

public static native @Cast("cublasStatus_t") int cublasAsumEx(cublasContext handle,
                                                   int n,
                                                   @Const Pointer x,
                                                   @Cast("cudaDataType") int xType,
                                                   int incx,
                                                   Pointer result,
                                                   @Cast("cudaDataType") int resultType,
                                                   @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasAsumEx_64(cublasContext handle,
                                                      @Cast("int64_t") long n,
                                                      @Const Pointer x,
                                                      @Cast("cudaDataType") int xType,
                                                      @Cast("int64_t") long incx,
                                                      Pointer result,
                                                      @Cast("cudaDataType") int resultType,
                                                      @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasSasum_v2(cublasContext handle, int n, @Const FloatPointer x, int incx, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasSasum_v2(cublasContext handle, int n, @Const FloatBuffer x, int incx, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasSasum_v2(cublasContext handle, int n, @Const float[] x, int incx, float[] result);

public static native @Cast("cublasStatus_t") int cublasSasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatPointer x, @Cast("int64_t") long incx, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasSasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const FloatBuffer x, @Cast("int64_t") long incx, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasSasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const float[] x, @Cast("int64_t") long incx, float[] result);

public static native @Cast("cublasStatus_t") int cublasDasum_v2(cublasContext handle, int n, @Const DoublePointer x, int incx, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDasum_v2(cublasContext handle, int n, @Const DoubleBuffer x, int incx, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDasum_v2(cublasContext handle, int n, @Const double[] x, int incx, double[] result);

public static native @Cast("cublasStatus_t") int cublasDasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoublePointer x, @Cast("int64_t") long incx, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const DoubleBuffer x, @Cast("int64_t") long incx, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Const double[] x, @Cast("int64_t") long incx, double[] result);

public static native @Cast("cublasStatus_t") int cublasScasum_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasScasum_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasScasum_v2(cublasContext handle, int n, @Cast("const cuComplex*") float2 x, int incx, float[] result);

public static native @Cast("cublasStatus_t") int cublasScasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, FloatPointer result);
public static native @Cast("cublasStatus_t") int cublasScasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, FloatBuffer result);
public static native @Cast("cublasStatus_t") int cublasScasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuComplex*") float2 x, @Cast("int64_t") long incx, float[] result);

public static native @Cast("cublasStatus_t") int cublasDzasum_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDzasum_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDzasum_v2(cublasContext handle, int n, @Cast("const cuDoubleComplex*") double2 x, int incx, double[] result);

public static native @Cast("cublasStatus_t") int cublasDzasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, DoublePointer result);
public static native @Cast("cublasStatus_t") int cublasDzasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, DoubleBuffer result);
public static native @Cast("cublasStatus_t") int cublasDzasum_v2_64(cublasContext handle, @Cast("int64_t") long n, @Cast("const cuDoubleComplex*") double2 x, @Cast("int64_t") long incx, double[] result);

public static native @Cast("cublasStatus_t") int cublasSrot_v2(cublasContext handle, int n, FloatPointer x, int incx, FloatPointer y, int incy, @Const FloatPointer c, @Const FloatPointer s);
public static native @Cast("cublasStatus_t") int cublasSrot_v2(cublasContext handle, int n, FloatBuffer x, int incx, FloatBuffer y, int incy, @Const FloatBuffer c, @Const FloatBuffer s);
public static native @Cast("cublasStatus_t") int cublasSrot_v2(cublasContext handle, int n, float[] x, int incx, float[] y, int incy, @Const float[] c, @Const float[] s);

public static native @Cast("cublasStatus_t") int cublasSrot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, FloatPointer x, @Cast("int64_t") long incx, FloatPointer y, @Cast("int64_t") long incy, @Const FloatPointer c, @Const FloatPointer s);
public static native @Cast("cublasStatus_t") int cublasSrot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, FloatBuffer x, @Cast("int64_t") long incx, FloatBuffer y, @Cast("int64_t") long incy, @Const FloatBuffer c, @Const FloatBuffer s);
public static native @Cast("cublasStatus_t") int cublasSrot_v2_64(
    cublasContext handle, @Cast("int64_t") long n, float[] x, @Cast("int64_t") long incx, float[] y, @Cast("int64_t") long incy, @Const float[] c, @Const float[] s);

public static native @Cast("cublasStatus_t") int cublasDrot_v2(cublasContext handle, int n, DoublePointer x, int incx, DoublePointer y, int incy, @Const DoublePointer c, @Const DoublePointer s);
public static native @Cast("cublasStatus_t") int cublasDrot_v2(cublasContext handle, int n, DoubleBuffer x, int incx, DoubleBuffer y, int incy, @Const DoubleBuffer c, @Const DoubleBuffer s);
public static native @Cast("cublasStatus_t") int cublasDrot_v2(cublasContext handle, int n, double[] x, int incx, double[] y, int incy, @Const double[] c, @Const double[] s);

public static native @Cast("cublasStatus_t") int cublasDrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       DoublePointer x,
                                                       @Cast("int64_t") long incx,
                                                       DoublePointer y,
                                                       @Cast("int64_t") long incy,
                                                       @Const DoublePointer c,
                                                       @Const DoublePointer s);
public static native @Cast("cublasStatus_t") int cublasDrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       DoubleBuffer x,
                                                       @Cast("int64_t") long incx,
                                                       DoubleBuffer y,
                                                       @Cast("int64_t") long incy,
                                                       @Const DoubleBuffer c,
                                                       @Const DoubleBuffer s);
public static native @Cast("cublasStatus_t") int cublasDrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       double[] x,
                                                       @Cast("int64_t") long incx,
                                                       double[] y,
                                                       @Cast("int64_t") long incy,
                                                       @Const double[] c,
                                                       @Const double[] s);

public static native @Cast("cublasStatus_t") int cublasCrot_v2(
    cublasContext handle, int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy, @Const FloatPointer c, @Cast("const cuComplex*") float2 s);
public static native @Cast("cublasStatus_t") int cublasCrot_v2(
    cublasContext handle, int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy, @Const FloatBuffer c, @Cast("const cuComplex*") float2 s);
public static native @Cast("cublasStatus_t") int cublasCrot_v2(
    cublasContext handle, int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy, @Const float[] c, @Cast("const cuComplex*") float2 s);

public static native @Cast("cublasStatus_t") int cublasCrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       @Cast("cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 y,
                                                       @Cast("int64_t") long incy,
                                                       @Const FloatPointer c,
                                                       @Cast("const cuComplex*") float2 s);
public static native @Cast("cublasStatus_t") int cublasCrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       @Cast("cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 y,
                                                       @Cast("int64_t") long incy,
                                                       @Const FloatBuffer c,
                                                       @Cast("const cuComplex*") float2 s);
public static native @Cast("cublasStatus_t") int cublasCrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       @Cast("cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 y,
                                                       @Cast("int64_t") long incy,
                                                       @Const float[] c,
                                                       @Cast("const cuComplex*") float2 s);

public static native @Cast("cublasStatus_t") int cublasCsrot_v2(
    cublasContext handle, int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy, @Const FloatPointer c, @Const FloatPointer s);
public static native @Cast("cublasStatus_t") int cublasCsrot_v2(
    cublasContext handle, int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy, @Const FloatBuffer c, @Const FloatBuffer s);
public static native @Cast("cublasStatus_t") int cublasCsrot_v2(
    cublasContext handle, int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy, @Const float[] c, @Const float[] s);

public static native @Cast("cublasStatus_t") int cublasCsrot_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Const FloatPointer c,
                                                        @Const FloatPointer s);
public static native @Cast("cublasStatus_t") int cublasCsrot_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Const FloatBuffer c,
                                                        @Const FloatBuffer s);
public static native @Cast("cublasStatus_t") int cublasCsrot_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Const float[] c,
                                                        @Const float[] s);

public static native @Cast("cublasStatus_t") int cublasZrot_v2(cublasContext handle,
                                                    int n,
                                                    @Cast("cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 y,
                                                    int incy,
                                                    @Const DoublePointer c,
                                                    @Cast("const cuDoubleComplex*") double2 s);
public static native @Cast("cublasStatus_t") int cublasZrot_v2(cublasContext handle,
                                                    int n,
                                                    @Cast("cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 y,
                                                    int incy,
                                                    @Const DoubleBuffer c,
                                                    @Cast("const cuDoubleComplex*") double2 s);
public static native @Cast("cublasStatus_t") int cublasZrot_v2(cublasContext handle,
                                                    int n,
                                                    @Cast("cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 y,
                                                    int incy,
                                                    @Const double[] c,
                                                    @Cast("const cuDoubleComplex*") double2 s);

public static native @Cast("cublasStatus_t") int cublasZrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       @Cast("cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 y,
                                                       @Cast("int64_t") long incy,
                                                       @Const DoublePointer c,
                                                       @Cast("const cuDoubleComplex*") double2 s);
public static native @Cast("cublasStatus_t") int cublasZrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       @Cast("cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 y,
                                                       @Cast("int64_t") long incy,
                                                       @Const DoubleBuffer c,
                                                       @Cast("const cuDoubleComplex*") double2 s);
public static native @Cast("cublasStatus_t") int cublasZrot_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long n,
                                                       @Cast("cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 y,
                                                       @Cast("int64_t") long incy,
                                                       @Const double[] c,
                                                       @Cast("const cuDoubleComplex*") double2 s);

public static native @Cast("cublasStatus_t") int cublasZdrot_v2(cublasContext handle,
                                                     int n,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Const DoublePointer c,
                                                     @Const DoublePointer s);
public static native @Cast("cublasStatus_t") int cublasZdrot_v2(cublasContext handle,
                                                     int n,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Const DoubleBuffer c,
                                                     @Const DoubleBuffer s);
public static native @Cast("cublasStatus_t") int cublasZdrot_v2(cublasContext handle,
                                                     int n,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Const double[] c,
                                                     @Const double[] s);

public static native @Cast("cublasStatus_t") int cublasZdrot_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Const DoublePointer c,
                                                        @Const DoublePointer s);
public static native @Cast("cublasStatus_t") int cublasZdrot_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Const DoubleBuffer c,
                                                        @Const DoubleBuffer s);
public static native @Cast("cublasStatus_t") int cublasZdrot_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long n,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Const double[] c,
                                                        @Const double[] s);

public static native @Cast("cublasStatus_t") int cublasRotEx(cublasContext handle,
                                                  int n,
                                                  Pointer x,
                                                  @Cast("cudaDataType") int xType,
                                                  int incx,
                                                  Pointer y,
                                                  @Cast("cudaDataType") int yType,
                                                  int incy,
                                                  @Const Pointer c,
                                                  @Const Pointer s,
                                                  @Cast("cudaDataType") int csType,
                                                  @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasRotEx_64(cublasContext handle,
                                                     @Cast("int64_t") long n,
                                                     Pointer x,
                                                     @Cast("cudaDataType") int xType,
                                                     @Cast("int64_t") long incx,
                                                     Pointer y,
                                                     @Cast("cudaDataType") int yType,
                                                     @Cast("int64_t") long incy,
                                                     @Const Pointer c,
                                                     @Const Pointer s,
                                                     @Cast("cudaDataType") int csType,
                                                     @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasSrotg_v2(cublasContext handle, FloatPointer a, FloatPointer b, FloatPointer c, FloatPointer s);
public static native @Cast("cublasStatus_t") int cublasSrotg_v2(cublasContext handle, FloatBuffer a, FloatBuffer b, FloatBuffer c, FloatBuffer s);
public static native @Cast("cublasStatus_t") int cublasSrotg_v2(cublasContext handle, float[] a, float[] b, float[] c, float[] s);

public static native @Cast("cublasStatus_t") int cublasDrotg_v2(cublasContext handle, DoublePointer a, DoublePointer b, DoublePointer c, DoublePointer s);
public static native @Cast("cublasStatus_t") int cublasDrotg_v2(cublasContext handle, DoubleBuffer a, DoubleBuffer b, DoubleBuffer c, DoubleBuffer s);
public static native @Cast("cublasStatus_t") int cublasDrotg_v2(cublasContext handle, double[] a, double[] b, double[] c, double[] s);

public static native @Cast("cublasStatus_t") int cublasCrotg_v2(cublasContext handle, @Cast("cuComplex*") float2 a, @Cast("cuComplex*") float2 b, FloatPointer c, @Cast("cuComplex*") float2 s);
public static native @Cast("cublasStatus_t") int cublasCrotg_v2(cublasContext handle, @Cast("cuComplex*") float2 a, @Cast("cuComplex*") float2 b, FloatBuffer c, @Cast("cuComplex*") float2 s);
public static native @Cast("cublasStatus_t") int cublasCrotg_v2(cublasContext handle, @Cast("cuComplex*") float2 a, @Cast("cuComplex*") float2 b, float[] c, @Cast("cuComplex*") float2 s);

public static native @Cast("cublasStatus_t") int cublasZrotg_v2(cublasContext handle, @Cast("cuDoubleComplex*") double2 a, @Cast("cuDoubleComplex*") double2 b, DoublePointer c, @Cast("cuDoubleComplex*") double2 s);
public static native @Cast("cublasStatus_t") int cublasZrotg_v2(cublasContext handle, @Cast("cuDoubleComplex*") double2 a, @Cast("cuDoubleComplex*") double2 b, DoubleBuffer c, @Cast("cuDoubleComplex*") double2 s);
public static native @Cast("cublasStatus_t") int cublasZrotg_v2(cublasContext handle, @Cast("cuDoubleComplex*") double2 a, @Cast("cuDoubleComplex*") double2 b, double[] c, @Cast("cuDoubleComplex*") double2 s);

public static native @Cast("cublasStatus_t") int cublasRotgEx(cublasContext handle,
                                                   Pointer a,
                                                   Pointer b,
                                                   @Cast("cudaDataType") int abType,
                                                   Pointer c,
                                                   Pointer s,
                                                   @Cast("cudaDataType") int csType,
                                                   @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasSrotm_v2(cublasContext handle, int n, FloatPointer x, int incx, FloatPointer y, int incy, @Const FloatPointer param);
public static native @Cast("cublasStatus_t") int cublasSrotm_v2(cublasContext handle, int n, FloatBuffer x, int incx, FloatBuffer y, int incy, @Const FloatBuffer param);
public static native @Cast("cublasStatus_t") int cublasSrotm_v2(cublasContext handle, int n, float[] x, int incx, float[] y, int incy, @Const float[] param);

public static native @Cast("cublasStatus_t") int cublasSrotm_v2_64(cublasContext handle, @Cast("int64_t") long n, FloatPointer x, @Cast("int64_t") long incx, FloatPointer y, @Cast("int64_t") long incy, @Const FloatPointer param);
public static native @Cast("cublasStatus_t") int cublasSrotm_v2_64(cublasContext handle, @Cast("int64_t") long n, FloatBuffer x, @Cast("int64_t") long incx, FloatBuffer y, @Cast("int64_t") long incy, @Const FloatBuffer param);
public static native @Cast("cublasStatus_t") int cublasSrotm_v2_64(cublasContext handle, @Cast("int64_t") long n, float[] x, @Cast("int64_t") long incx, float[] y, @Cast("int64_t") long incy, @Const float[] param);

public static native @Cast("cublasStatus_t") int cublasDrotm_v2(cublasContext handle, int n, DoublePointer x, int incx, DoublePointer y, int incy, @Const DoublePointer param);
public static native @Cast("cublasStatus_t") int cublasDrotm_v2(cublasContext handle, int n, DoubleBuffer x, int incx, DoubleBuffer y, int incy, @Const DoubleBuffer param);
public static native @Cast("cublasStatus_t") int cublasDrotm_v2(cublasContext handle, int n, double[] x, int incx, double[] y, int incy, @Const double[] param);

public static native @Cast("cublasStatus_t") int cublasDrotm_v2_64(
    cublasContext handle, @Cast("int64_t") long n, DoublePointer x, @Cast("int64_t") long incx, DoublePointer y, @Cast("int64_t") long incy, @Const DoublePointer param);
public static native @Cast("cublasStatus_t") int cublasDrotm_v2_64(
    cublasContext handle, @Cast("int64_t") long n, DoubleBuffer x, @Cast("int64_t") long incx, DoubleBuffer y, @Cast("int64_t") long incy, @Const DoubleBuffer param);
public static native @Cast("cublasStatus_t") int cublasDrotm_v2_64(
    cublasContext handle, @Cast("int64_t") long n, double[] x, @Cast("int64_t") long incx, double[] y, @Cast("int64_t") long incy, @Const double[] param);

public static native @Cast("cublasStatus_t") int cublasRotmEx(cublasContext handle,
                                                   int n,
                                                   Pointer x,
                                                   @Cast("cudaDataType") int xType,
                                                   int incx,
                                                   Pointer y,
                                                   @Cast("cudaDataType") int yType,
                                                   int incy,
                                                   @Const Pointer param,
                                                   @Cast("cudaDataType") int paramType,
                                                   @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasRotmEx_64(cublasContext handle,
                                                      @Cast("int64_t") long n,
                                                      Pointer x,
                                                      @Cast("cudaDataType") int xType,
                                                      @Cast("int64_t") long incx,
                                                      Pointer y,
                                                      @Cast("cudaDataType") int yType,
                                                      @Cast("int64_t") long incy,
                                                      @Const Pointer param,
                                                      @Cast("cudaDataType") int paramType,
                                                      @Cast("cudaDataType") int executiontype);

public static native @Cast("cublasStatus_t") int cublasSrotmg_v2(cublasContext handle, FloatPointer d1, FloatPointer d2, FloatPointer x1, @Const FloatPointer y1, FloatPointer param);
public static native @Cast("cublasStatus_t") int cublasSrotmg_v2(cublasContext handle, FloatBuffer d1, FloatBuffer d2, FloatBuffer x1, @Const FloatBuffer y1, FloatBuffer param);
public static native @Cast("cublasStatus_t") int cublasSrotmg_v2(cublasContext handle, float[] d1, float[] d2, float[] x1, @Const float[] y1, float[] param);

public static native @Cast("cublasStatus_t") int cublasDrotmg_v2(cublasContext handle, DoublePointer d1, DoublePointer d2, DoublePointer x1, @Const DoublePointer y1, DoublePointer param);
public static native @Cast("cublasStatus_t") int cublasDrotmg_v2(cublasContext handle, DoubleBuffer d1, DoubleBuffer d2, DoubleBuffer x1, @Const DoubleBuffer y1, DoubleBuffer param);
public static native @Cast("cublasStatus_t") int cublasDrotmg_v2(cublasContext handle, double[] d1, double[] d2, double[] x1, @Const double[] y1, double[] param);

public static native @Cast("cublasStatus_t") int cublasRotmgEx(cublasContext handle,
                                                    Pointer d1,
                                                    @Cast("cudaDataType") int d1Type,
                                                    Pointer d2,
                                                    @Cast("cudaDataType") int d2Type,
                                                    Pointer x1,
                                                    @Cast("cudaDataType") int x1Type,
                                                    @Const Pointer y1,
                                                    @Cast("cudaDataType") int y1Type,
                                                    Pointer param,
                                                    @Cast("cudaDataType") int paramType,
                                                    @Cast("cudaDataType") int executiontype);

/* --------------- CUBLAS BLAS2 Functions  ---------------- */

/* GEMV */

public static native @Cast("cublasStatus_t") int cublasSgemv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     @Const FloatPointer x,
                                                     int incx,
                                                     @Const FloatPointer beta,
                                                     FloatPointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSgemv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     @Const FloatBuffer x,
                                                     int incx,
                                                     @Const FloatBuffer beta,
                                                     FloatBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSgemv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     @Const float[] x,
                                                     int incx,
                                                     @Const float[] beta,
                                                     float[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasSgemv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatPointer beta,
                                                        FloatPointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSgemv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatBuffer beta,
                                                        FloatBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSgemv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const float[] beta,
                                                        float[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasDgemv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     @Const DoublePointer x,
                                                     int incx,
                                                     @Const DoublePointer beta,
                                                     DoublePointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDgemv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     @Const DoubleBuffer x,
                                                     int incx,
                                                     @Const DoubleBuffer beta,
                                                     DoubleBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDgemv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     @Const double[] x,
                                                     int incx,
                                                     @Const double[] beta,
                                                     double[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasDgemv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoublePointer beta,
                                                        DoublePointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDgemv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoubleBuffer beta,
                                                        DoubleBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDgemv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const double[] beta,
                                                        double[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasCgemv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasCgemv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZgemv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasZgemv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy);

/* GBMV */

public static native @Cast("cublasStatus_t") int cublasSgbmv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     int kl,
                                                     int ku,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     @Const FloatPointer x,
                                                     int incx,
                                                     @Const FloatPointer beta,
                                                     FloatPointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSgbmv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     int kl,
                                                     int ku,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     @Const FloatBuffer x,
                                                     int incx,
                                                     @Const FloatBuffer beta,
                                                     FloatBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSgbmv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     int kl,
                                                     int ku,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     @Const float[] x,
                                                     int incx,
                                                     @Const float[] beta,
                                                     float[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasSgbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long kl,
                                                        @Cast("int64_t") long ku,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatPointer beta,
                                                        FloatPointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSgbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long kl,
                                                        @Cast("int64_t") long ku,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatBuffer beta,
                                                        FloatBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSgbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long kl,
                                                        @Cast("int64_t") long ku,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const float[] beta,
                                                        float[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasDgbmv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     int kl,
                                                     int ku,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     @Const DoublePointer x,
                                                     int incx,
                                                     @Const DoublePointer beta,
                                                     DoublePointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDgbmv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     int kl,
                                                     int ku,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     @Const DoubleBuffer x,
                                                     int incx,
                                                     @Const DoubleBuffer beta,
                                                     DoubleBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDgbmv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     int kl,
                                                     int ku,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     @Const double[] x,
                                                     int incx,
                                                     @Const double[] beta,
                                                     double[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasDgbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long kl,
                                                        @Cast("int64_t") long ku,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoublePointer beta,
                                                        DoublePointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDgbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long kl,
                                                        @Cast("int64_t") long ku,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoubleBuffer beta,
                                                        DoubleBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDgbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long kl,
                                                        @Cast("int64_t") long ku,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const double[] beta,
                                                        double[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasCgbmv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     int kl,
                                                     int ku,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasCgbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long kl,
                                                        @Cast("int64_t") long ku,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZgbmv_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int m,
                                                     int n,
                                                     int kl,
                                                     int ku,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasZgbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long kl,
                                                        @Cast("int64_t") long ku,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy);

/* TRMV */

public static native @Cast("cublasStatus_t") int cublasStrmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     FloatPointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStrmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     FloatBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStrmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const float[] A,
                                                     int lda,
                                                     float[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasStrmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatPointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStrmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStrmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        float[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasDtrmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     DoublePointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtrmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     DoubleBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtrmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const double[] A,
                                                     int lda,
                                                     double[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasDtrmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        DoublePointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtrmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        DoubleBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtrmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        double[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasCtrmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("cuComplex*") float2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasCtrmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasZtrmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasZtrmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx);

/* TBMV */

public static native @Cast("cublasStatus_t") int cublasStbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     FloatPointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     FloatBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const float[] A,
                                                     int lda,
                                                     float[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasStbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatPointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        float[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasDtbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     DoublePointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     DoubleBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const double[] A,
                                                     int lda,
                                                     double[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasDtbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        DoublePointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        DoubleBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        double[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasCtbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("cuComplex*") float2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasCtbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasZtbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasZtbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx);

/* TPMV */

public static native @Cast("cublasStatus_t") int cublasStpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const FloatPointer AP,
                                                     FloatPointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const FloatBuffer AP,
                                                     FloatBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const float[] AP,
                                                     float[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasStpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer AP,
                                                        FloatPointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer AP,
                                                        FloatBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] AP,
                                                        float[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasDtpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const DoublePointer AP,
                                                     DoublePointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const DoubleBuffer AP,
                                                     DoubleBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const double[] AP,
                                                     double[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasDtpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer AP,
                                                        DoublePointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer AP,
                                                        DoubleBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] AP,
                                                        double[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasCtpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 AP,
                                                     @Cast("cuComplex*") float2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasCtpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 AP,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasZtpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 AP,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasZtpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 AP,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx);

/* TRSV */

public static native @Cast("cublasStatus_t") int cublasStrsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     FloatPointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStrsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     FloatBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStrsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const float[] A,
                                                     int lda,
                                                     float[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasStrsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatPointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStrsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStrsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        float[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasDtrsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     DoublePointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtrsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     DoubleBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtrsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const double[] A,
                                                     int lda,
                                                     double[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasDtrsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        DoublePointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtrsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        DoubleBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtrsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        double[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasCtrsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("cuComplex*") float2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasCtrsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasZtrsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasZtrsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx);

/* TPSV */

public static native @Cast("cublasStatus_t") int cublasStpsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const FloatPointer AP,
                                                     FloatPointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStpsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const FloatBuffer AP,
                                                     FloatBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStpsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const float[] AP,
                                                     float[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasStpsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer AP,
                                                        FloatPointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStpsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer AP,
                                                        FloatBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStpsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] AP,
                                                        float[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasDtpsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const DoublePointer AP,
                                                     DoublePointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtpsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const DoubleBuffer AP,
                                                     DoubleBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtpsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Const double[] AP,
                                                     double[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasDtpsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer AP,
                                                        DoublePointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtpsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer AP,
                                                        DoubleBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtpsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] AP,
                                                        double[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasCtpsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 AP,
                                                     @Cast("cuComplex*") float2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasCtpsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 AP,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasZtpsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 AP,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasZtpsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 AP,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx);

/* TBSV */

public static native @Cast("cublasStatus_t") int cublasStbsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     FloatPointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStbsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     FloatBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasStbsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const float[] A,
                                                     int lda,
                                                     float[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasStbsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatPointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStbsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasStbsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        float[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasDtbsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     DoublePointer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtbsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     DoubleBuffer x,
                                                     int incx);
public static native @Cast("cublasStatus_t") int cublasDtbsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Const double[] A,
                                                     int lda,
                                                     double[] x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasDtbsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        DoublePointer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtbsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        DoubleBuffer x,
                                                        @Cast("int64_t") long incx);
public static native @Cast("cublasStatus_t") int cublasDtbsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        double[] x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasCtbsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("cuComplex*") float2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasCtbsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx);

public static native @Cast("cublasStatus_t") int cublasZtbsv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("cuDoubleComplex*") double2 x,
                                                     int incx);

public static native @Cast("cublasStatus_t") int cublasZtbsv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx);

/* SYMV/HEMV */

public static native @Cast("cublasStatus_t") int cublasSsymv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     @Const FloatPointer x,
                                                     int incx,
                                                     @Const FloatPointer beta,
                                                     FloatPointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSsymv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     @Const FloatBuffer x,
                                                     int incx,
                                                     @Const FloatBuffer beta,
                                                     FloatBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSsymv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     @Const float[] x,
                                                     int incx,
                                                     @Const float[] beta,
                                                     float[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasSsymv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatPointer beta,
                                                        FloatPointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSsymv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatBuffer beta,
                                                        FloatBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSsymv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const float[] beta,
                                                        float[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasDsymv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     @Const DoublePointer x,
                                                     int incx,
                                                     @Const DoublePointer beta,
                                                     DoublePointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDsymv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     @Const DoubleBuffer x,
                                                     int incx,
                                                     @Const DoubleBuffer beta,
                                                     DoubleBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDsymv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     @Const double[] x,
                                                     int incx,
                                                     @Const double[] beta,
                                                     double[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasDsymv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoublePointer beta,
                                                        DoublePointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDsymv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoubleBuffer beta,
                                                        DoubleBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDsymv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const double[] beta,
                                                        double[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasCsymv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasCsymv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZsymv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasZsymv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasChemv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasChemv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZhemv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasZhemv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy);

/* SBMV/HBMV */

public static native @Cast("cublasStatus_t") int cublasSsbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     int k,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     @Const FloatPointer x,
                                                     int incx,
                                                     @Const FloatPointer beta,
                                                     FloatPointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSsbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     int k,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     @Const FloatBuffer x,
                                                     int incx,
                                                     @Const FloatBuffer beta,
                                                     FloatBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSsbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     int k,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     @Const float[] x,
                                                     int incx,
                                                     @Const float[] beta,
                                                     float[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasSsbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatPointer beta,
                                                        FloatPointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSsbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatBuffer beta,
                                                        FloatBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSsbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const float[] beta,
                                                        float[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasDsbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     int k,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     @Const DoublePointer x,
                                                     int incx,
                                                     @Const DoublePointer beta,
                                                     DoublePointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDsbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     int k,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     @Const DoubleBuffer x,
                                                     int incx,
                                                     @Const DoubleBuffer beta,
                                                     DoubleBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDsbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     int k,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     @Const double[] x,
                                                     int incx,
                                                     @Const double[] beta,
                                                     double[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasDsbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoublePointer beta,
                                                        DoublePointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDsbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoubleBuffer beta,
                                                        DoubleBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDsbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const double[] beta,
                                                        double[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasChbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasChbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZhbmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasZhbmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy);

/* SPMV/HPMV */

public static native @Cast("cublasStatus_t") int cublasSspmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer AP,
                                                     @Const FloatPointer x,
                                                     int incx,
                                                     @Const FloatPointer beta,
                                                     FloatPointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSspmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer AP,
                                                     @Const FloatBuffer x,
                                                     int incx,
                                                     @Const FloatBuffer beta,
                                                     FloatBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasSspmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const float[] alpha,
                                                     @Const float[] AP,
                                                     @Const float[] x,
                                                     int incx,
                                                     @Const float[] beta,
                                                     float[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasSspmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer AP,
                                                        @Const FloatPointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatPointer beta,
                                                        FloatPointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSspmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer AP,
                                                        @Const FloatBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatBuffer beta,
                                                        FloatBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasSspmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] alpha,
                                                        @Const float[] AP,
                                                        @Const float[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const float[] beta,
                                                        float[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasDspmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer AP,
                                                     @Const DoublePointer x,
                                                     int incx,
                                                     @Const DoublePointer beta,
                                                     DoublePointer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDspmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer AP,
                                                     @Const DoubleBuffer x,
                                                     int incx,
                                                     @Const DoubleBuffer beta,
                                                     DoubleBuffer y,
                                                     int incy);
public static native @Cast("cublasStatus_t") int cublasDspmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const double[] alpha,
                                                     @Const double[] AP,
                                                     @Const double[] x,
                                                     int incx,
                                                     @Const double[] beta,
                                                     double[] y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasDspmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer AP,
                                                        @Const DoublePointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoublePointer beta,
                                                        DoublePointer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDspmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer AP,
                                                        @Const DoubleBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoubleBuffer beta,
                                                        DoubleBuffer y,
                                                        @Cast("int64_t") long incy);
public static native @Cast("cublasStatus_t") int cublasDspmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] alpha,
                                                        @Const double[] AP,
                                                        @Const double[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const double[] beta,
                                                        double[] y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasChpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 AP,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasChpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 AP,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy);

public static native @Cast("cublasStatus_t") int cublasZhpmv_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 AP,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 y,
                                                     int incy);

public static native @Cast("cublasStatus_t") int cublasZhpmv_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 AP,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy);

/* GER */

public static native @Cast("cublasStatus_t") int cublasSger_v2(cublasContext handle,
                                                    int m,
                                                    int n,
                                                    @Const FloatPointer alpha,
                                                    @Const FloatPointer x,
                                                    int incx,
                                                    @Const FloatPointer y,
                                                    int incy,
                                                    FloatPointer A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasSger_v2(cublasContext handle,
                                                    int m,
                                                    int n,
                                                    @Const FloatBuffer alpha,
                                                    @Const FloatBuffer x,
                                                    int incx,
                                                    @Const FloatBuffer y,
                                                    int incy,
                                                    FloatBuffer A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasSger_v2(cublasContext handle,
                                                    int m,
                                                    int n,
                                                    @Const float[] alpha,
                                                    @Const float[] x,
                                                    int incx,
                                                    @Const float[] y,
                                                    int incy,
                                                    float[] A,
                                                    int lda);

public static native @Cast("cublasStatus_t") int cublasSger_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatPointer alpha,
                                                       @Const FloatPointer x,
                                                       @Cast("int64_t") long incx,
                                                       @Const FloatPointer y,
                                                       @Cast("int64_t") long incy,
                                                       FloatPointer A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasSger_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatBuffer alpha,
                                                       @Const FloatBuffer x,
                                                       @Cast("int64_t") long incx,
                                                       @Const FloatBuffer y,
                                                       @Cast("int64_t") long incy,
                                                       FloatBuffer A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasSger_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Const float[] alpha,
                                                       @Const float[] x,
                                                       @Cast("int64_t") long incx,
                                                       @Const float[] y,
                                                       @Cast("int64_t") long incy,
                                                       float[] A,
                                                       @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasDger_v2(cublasContext handle,
                                                    int m,
                                                    int n,
                                                    @Const DoublePointer alpha,
                                                    @Const DoublePointer x,
                                                    int incx,
                                                    @Const DoublePointer y,
                                                    int incy,
                                                    DoublePointer A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasDger_v2(cublasContext handle,
                                                    int m,
                                                    int n,
                                                    @Const DoubleBuffer alpha,
                                                    @Const DoubleBuffer x,
                                                    int incx,
                                                    @Const DoubleBuffer y,
                                                    int incy,
                                                    DoubleBuffer A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasDger_v2(cublasContext handle,
                                                    int m,
                                                    int n,
                                                    @Const double[] alpha,
                                                    @Const double[] x,
                                                    int incx,
                                                    @Const double[] y,
                                                    int incy,
                                                    double[] A,
                                                    int lda);

public static native @Cast("cublasStatus_t") int cublasDger_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Const DoublePointer alpha,
                                                       @Const DoublePointer x,
                                                       @Cast("int64_t") long incx,
                                                       @Const DoublePointer y,
                                                       @Cast("int64_t") long incy,
                                                       DoublePointer A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasDger_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Const DoubleBuffer alpha,
                                                       @Const DoubleBuffer x,
                                                       @Cast("int64_t") long incx,
                                                       @Const DoubleBuffer y,
                                                       @Cast("int64_t") long incy,
                                                       DoubleBuffer A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasDger_v2_64(cublasContext handle,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Const double[] alpha,
                                                       @Const double[] x,
                                                       @Cast("int64_t") long incx,
                                                       @Const double[] y,
                                                       @Cast("int64_t") long incy,
                                                       double[] A,
                                                       @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasCgeru_v2(cublasContext handle,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 y,
                                                     int incy,
                                                     @Cast("cuComplex*") float2 A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasCgeru_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasCgerc_v2(cublasContext handle,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 y,
                                                     int incy,
                                                     @Cast("cuComplex*") float2 A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasCgerc_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasZgeru_v2(cublasContext handle,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Cast("cuDoubleComplex*") double2 A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasZgeru_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasZgerc_v2(cublasContext handle,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Cast("cuDoubleComplex*") double2 A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasZgerc_v2_64(cublasContext handle,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda);

/* SYR/HER */

public static native @Cast("cublasStatus_t") int cublasSsyr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const FloatPointer alpha,
                                                    @Const FloatPointer x,
                                                    int incx,
                                                    FloatPointer A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasSsyr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const FloatBuffer alpha,
                                                    @Const FloatBuffer x,
                                                    int incx,
                                                    FloatBuffer A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasSsyr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const float[] alpha,
                                                    @Const float[] x,
                                                    int incx,
                                                    float[] A,
                                                    int lda);

public static native @Cast("cublasStatus_t") int cublasSsyr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatPointer alpha,
                                                       @Const FloatPointer x,
                                                       @Cast("int64_t") long incx,
                                                       FloatPointer A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasSsyr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatBuffer alpha,
                                                       @Const FloatBuffer x,
                                                       @Cast("int64_t") long incx,
                                                       FloatBuffer A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasSsyr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const float[] alpha,
                                                       @Const float[] x,
                                                       @Cast("int64_t") long incx,
                                                       float[] A,
                                                       @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasDsyr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const DoublePointer alpha,
                                                    @Const DoublePointer x,
                                                    int incx,
                                                    DoublePointer A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasDsyr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const DoubleBuffer alpha,
                                                    @Const DoubleBuffer x,
                                                    int incx,
                                                    DoubleBuffer A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasDsyr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const double[] alpha,
                                                    @Const double[] x,
                                                    int incx,
                                                    double[] A,
                                                    int lda);

public static native @Cast("cublasStatus_t") int cublasDsyr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const DoublePointer alpha,
                                                       @Const DoublePointer x,
                                                       @Cast("int64_t") long incx,
                                                       DoublePointer A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasDsyr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const DoubleBuffer alpha,
                                                       @Const DoubleBuffer x,
                                                       @Cast("int64_t") long incx,
                                                       DoubleBuffer A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasDsyr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const double[] alpha,
                                                       @Const double[] x,
                                                       @Cast("int64_t") long incx,
                                                       double[] A,
                                                       @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasCsyr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Cast("const cuComplex*") float2 alpha,
                                                    @Cast("const cuComplex*") float2 x,
                                                    int incx,
                                                    @Cast("cuComplex*") float2 A,
                                                    int lda);

public static native @Cast("cublasStatus_t") int cublasCsyr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Cast("const cuComplex*") float2 alpha,
                                                       @Cast("const cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 A,
                                                       @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasZsyr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Cast("const cuDoubleComplex*") double2 alpha,
                                                    @Cast("const cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 A,
                                                    int lda);

public static native @Cast("cublasStatus_t") int cublasZsyr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Cast("const cuDoubleComplex*") double2 alpha,
                                                       @Cast("const cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 A,
                                                       @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasCher_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const FloatPointer alpha,
                                                    @Cast("const cuComplex*") float2 x,
                                                    int incx,
                                                    @Cast("cuComplex*") float2 A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasCher_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const FloatBuffer alpha,
                                                    @Cast("const cuComplex*") float2 x,
                                                    int incx,
                                                    @Cast("cuComplex*") float2 A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasCher_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const float[] alpha,
                                                    @Cast("const cuComplex*") float2 x,
                                                    int incx,
                                                    @Cast("cuComplex*") float2 A,
                                                    int lda);

public static native @Cast("cublasStatus_t") int cublasCher_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatPointer alpha,
                                                       @Cast("const cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasCher_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatBuffer alpha,
                                                       @Cast("const cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasCher_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const float[] alpha,
                                                       @Cast("const cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 A,
                                                       @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasZher_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const DoublePointer alpha,
                                                    @Cast("const cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasZher_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const DoubleBuffer alpha,
                                                    @Cast("const cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 A,
                                                    int lda);
public static native @Cast("cublasStatus_t") int cublasZher_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const double[] alpha,
                                                    @Cast("const cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 A,
                                                    int lda);

public static native @Cast("cublasStatus_t") int cublasZher_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const DoublePointer alpha,
                                                       @Cast("const cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasZher_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const DoubleBuffer alpha,
                                                       @Cast("const cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 A,
                                                       @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasZher_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const double[] alpha,
                                                       @Cast("const cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 A,
                                                       @Cast("int64_t") long lda);

/* SPR/HPR */

public static native @Cast("cublasStatus_t") int cublasSspr_v2(
    cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const FloatPointer alpha, @Const FloatPointer x, int incx, FloatPointer AP);
public static native @Cast("cublasStatus_t") int cublasSspr_v2(
    cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const FloatBuffer alpha, @Const FloatBuffer x, int incx, FloatBuffer AP);
public static native @Cast("cublasStatus_t") int cublasSspr_v2(
    cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const float[] alpha, @Const float[] x, int incx, float[] AP);

public static native @Cast("cublasStatus_t") int cublasSspr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatPointer alpha,
                                                       @Const FloatPointer x,
                                                       @Cast("int64_t") long incx,
                                                       FloatPointer AP);
public static native @Cast("cublasStatus_t") int cublasSspr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatBuffer alpha,
                                                       @Const FloatBuffer x,
                                                       @Cast("int64_t") long incx,
                                                       FloatBuffer AP);
public static native @Cast("cublasStatus_t") int cublasSspr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const float[] alpha,
                                                       @Const float[] x,
                                                       @Cast("int64_t") long incx,
                                                       float[] AP);

public static native @Cast("cublasStatus_t") int cublasDspr_v2(
    cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const DoublePointer alpha, @Const DoublePointer x, int incx, DoublePointer AP);
public static native @Cast("cublasStatus_t") int cublasDspr_v2(
    cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const DoubleBuffer alpha, @Const DoubleBuffer x, int incx, DoubleBuffer AP);
public static native @Cast("cublasStatus_t") int cublasDspr_v2(
    cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const double[] alpha, @Const double[] x, int incx, double[] AP);

public static native @Cast("cublasStatus_t") int cublasDspr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const DoublePointer alpha,
                                                       @Const DoublePointer x,
                                                       @Cast("int64_t") long incx,
                                                       DoublePointer AP);
public static native @Cast("cublasStatus_t") int cublasDspr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const DoubleBuffer alpha,
                                                       @Const DoubleBuffer x,
                                                       @Cast("int64_t") long incx,
                                                       DoubleBuffer AP);
public static native @Cast("cublasStatus_t") int cublasDspr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const double[] alpha,
                                                       @Const double[] x,
                                                       @Cast("int64_t") long incx,
                                                       double[] AP);

public static native @Cast("cublasStatus_t") int cublasChpr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const FloatPointer alpha,
                                                    @Cast("const cuComplex*") float2 x,
                                                    int incx,
                                                    @Cast("cuComplex*") float2 AP);
public static native @Cast("cublasStatus_t") int cublasChpr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const FloatBuffer alpha,
                                                    @Cast("const cuComplex*") float2 x,
                                                    int incx,
                                                    @Cast("cuComplex*") float2 AP);
public static native @Cast("cublasStatus_t") int cublasChpr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const float[] alpha,
                                                    @Cast("const cuComplex*") float2 x,
                                                    int incx,
                                                    @Cast("cuComplex*") float2 AP);

public static native @Cast("cublasStatus_t") int cublasChpr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatPointer alpha,
                                                       @Cast("const cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 AP);
public static native @Cast("cublasStatus_t") int cublasChpr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const FloatBuffer alpha,
                                                       @Cast("const cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 AP);
public static native @Cast("cublasStatus_t") int cublasChpr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const float[] alpha,
                                                       @Cast("const cuComplex*") float2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuComplex*") float2 AP);

public static native @Cast("cublasStatus_t") int cublasZhpr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const DoublePointer alpha,
                                                    @Cast("const cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 AP);
public static native @Cast("cublasStatus_t") int cublasZhpr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const DoubleBuffer alpha,
                                                    @Cast("const cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 AP);
public static native @Cast("cublasStatus_t") int cublasZhpr_v2(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    int n,
                                                    @Const double[] alpha,
                                                    @Cast("const cuDoubleComplex*") double2 x,
                                                    int incx,
                                                    @Cast("cuDoubleComplex*") double2 AP);

public static native @Cast("cublasStatus_t") int cublasZhpr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const DoublePointer alpha,
                                                       @Cast("const cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 AP);
public static native @Cast("cublasStatus_t") int cublasZhpr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const DoubleBuffer alpha,
                                                       @Cast("const cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 AP);
public static native @Cast("cublasStatus_t") int cublasZhpr_v2_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("int64_t") long n,
                                                       @Const double[] alpha,
                                                       @Cast("const cuDoubleComplex*") double2 x,
                                                       @Cast("int64_t") long incx,
                                                       @Cast("cuDoubleComplex*") double2 AP);

/* SYR2/HER2 */

public static native @Cast("cublasStatus_t") int cublasSsyr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer x,
                                                     int incx,
                                                     @Const FloatPointer y,
                                                     int incy,
                                                     FloatPointer A,
                                                     int lda);
public static native @Cast("cublasStatus_t") int cublasSsyr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer x,
                                                     int incx,
                                                     @Const FloatBuffer y,
                                                     int incy,
                                                     FloatBuffer A,
                                                     int lda);
public static native @Cast("cublasStatus_t") int cublasSsyr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const float[] alpha,
                                                     @Const float[] x,
                                                     int incx,
                                                     @Const float[] y,
                                                     int incy,
                                                     float[] A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasSsyr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatPointer y,
                                                        @Cast("int64_t") long incy,
                                                        FloatPointer A,
                                                        @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasSsyr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatBuffer y,
                                                        @Cast("int64_t") long incy,
                                                        FloatBuffer A,
                                                        @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasSsyr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] alpha,
                                                        @Const float[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const float[] y,
                                                        @Cast("int64_t") long incy,
                                                        float[] A,
                                                        @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasDsyr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer x,
                                                     int incx,
                                                     @Const DoublePointer y,
                                                     int incy,
                                                     DoublePointer A,
                                                     int lda);
public static native @Cast("cublasStatus_t") int cublasDsyr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer x,
                                                     int incx,
                                                     @Const DoubleBuffer y,
                                                     int incy,
                                                     DoubleBuffer A,
                                                     int lda);
public static native @Cast("cublasStatus_t") int cublasDsyr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const double[] alpha,
                                                     @Const double[] x,
                                                     int incx,
                                                     @Const double[] y,
                                                     int incy,
                                                     double[] A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasDsyr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoublePointer y,
                                                        @Cast("int64_t") long incy,
                                                        DoublePointer A,
                                                        @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasDsyr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoubleBuffer y,
                                                        @Cast("int64_t") long incy,
                                                        DoubleBuffer A,
                                                        @Cast("int64_t") long lda);
public static native @Cast("cublasStatus_t") int cublasDsyr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] alpha,
                                                        @Const double[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const double[] y,
                                                        @Cast("int64_t") long incy,
                                                        double[] A,
                                                        @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasCsyr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 y,
                                                     int incy,
                                                     @Cast("cuComplex*") float2 A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasCsyr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasZsyr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Cast("cuDoubleComplex*") double2 A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasZsyr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasCher2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 y,
                                                     int incy,
                                                     @Cast("cuComplex*") float2 A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasCher2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda);

public static native @Cast("cublasStatus_t") int cublasZher2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Cast("cuDoubleComplex*") double2 A,
                                                     int lda);

public static native @Cast("cublasStatus_t") int cublasZher2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda);

/* SPR2/HPR2 */

public static native @Cast("cublasStatus_t") int cublasSspr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer x,
                                                     int incx,
                                                     @Const FloatPointer y,
                                                     int incy,
                                                     FloatPointer AP);
public static native @Cast("cublasStatus_t") int cublasSspr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer x,
                                                     int incx,
                                                     @Const FloatBuffer y,
                                                     int incy,
                                                     FloatBuffer AP);
public static native @Cast("cublasStatus_t") int cublasSspr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const float[] alpha,
                                                     @Const float[] x,
                                                     int incx,
                                                     @Const float[] y,
                                                     int incy,
                                                     float[] AP);

public static native @Cast("cublasStatus_t") int cublasSspr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatPointer y,
                                                        @Cast("int64_t") long incy,
                                                        FloatPointer AP);
public static native @Cast("cublasStatus_t") int cublasSspr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const FloatBuffer y,
                                                        @Cast("int64_t") long incy,
                                                        FloatBuffer AP);
public static native @Cast("cublasStatus_t") int cublasSspr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] alpha,
                                                        @Const float[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const float[] y,
                                                        @Cast("int64_t") long incy,
                                                        float[] AP);

public static native @Cast("cublasStatus_t") int cublasDspr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer x,
                                                     int incx,
                                                     @Const DoublePointer y,
                                                     int incy,
                                                     DoublePointer AP);
public static native @Cast("cublasStatus_t") int cublasDspr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer x,
                                                     int incx,
                                                     @Const DoubleBuffer y,
                                                     int incy,
                                                     DoubleBuffer AP);
public static native @Cast("cublasStatus_t") int cublasDspr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Const double[] alpha,
                                                     @Const double[] x,
                                                     int incx,
                                                     @Const double[] y,
                                                     int incy,
                                                     double[] AP);

public static native @Cast("cublasStatus_t") int cublasDspr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoublePointer y,
                                                        @Cast("int64_t") long incy,
                                                        DoublePointer AP);
public static native @Cast("cublasStatus_t") int cublasDspr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer x,
                                                        @Cast("int64_t") long incx,
                                                        @Const DoubleBuffer y,
                                                        @Cast("int64_t") long incy,
                                                        DoubleBuffer AP);
public static native @Cast("cublasStatus_t") int cublasDspr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] alpha,
                                                        @Const double[] x,
                                                        @Cast("int64_t") long incx,
                                                        @Const double[] y,
                                                        @Cast("int64_t") long incy,
                                                        double[] AP);

public static native @Cast("cublasStatus_t") int cublasChpr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 x,
                                                     int incx,
                                                     @Cast("const cuComplex*") float2 y,
                                                     int incy,
                                                     @Cast("cuComplex*") float2 AP);

public static native @Cast("cublasStatus_t") int cublasChpr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuComplex*") float2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuComplex*") float2 AP);

public static native @Cast("cublasStatus_t") int cublasZhpr2_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     int incx,
                                                     @Cast("const cuDoubleComplex*") double2 y,
                                                     int incy,
                                                     @Cast("cuDoubleComplex*") double2 AP);

public static native @Cast("cublasStatus_t") int cublasZhpr2_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 x,
                                                        @Cast("int64_t") long incx,
                                                        @Cast("const cuDoubleComplex*") double2 y,
                                                        @Cast("int64_t") long incy,
                                                        @Cast("cuDoubleComplex*") double2 AP);

/* BATCH GEMV */

public static native @Cast("cublasStatus_t") int cublasSgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Const FloatPointer alpha,
                                                         @Cast("const float*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const float*const*") PointerPointer xarray,
                                                         int incx,
                                                         @Const FloatPointer beta,
                                                         @Cast("float*const*") PointerPointer yarray,
                                                         int incy,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Const FloatPointer alpha,
                                                         @Const @ByPtrPtr FloatPointer Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr FloatPointer xarray,
                                                         int incx,
                                                         @Const FloatPointer beta,
                                                         @ByPtrPtr FloatPointer yarray,
                                                         int incy,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Const FloatBuffer alpha,
                                                         @Const @ByPtrPtr FloatBuffer Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr FloatBuffer xarray,
                                                         int incx,
                                                         @Const FloatBuffer beta,
                                                         @ByPtrPtr FloatBuffer yarray,
                                                         int incy,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Const float[] alpha,
                                                         @Const @ByPtrPtr float[] Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr float[] xarray,
                                                         int incx,
                                                         @Const float[] beta,
                                                         @ByPtrPtr float[] yarray,
                                                         int incy,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasSgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const FloatPointer alpha,
                                                            @Cast("const float*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const float*const*") PointerPointer xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Const FloatPointer beta,
                                                            @Cast("float*const*") PointerPointer yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const FloatPointer alpha,
                                                            @Const @ByPtrPtr FloatPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr FloatPointer xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Const FloatPointer beta,
                                                            @ByPtrPtr FloatPointer yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const FloatBuffer alpha,
                                                            @Const @ByPtrPtr FloatBuffer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr FloatBuffer xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Const FloatBuffer beta,
                                                            @ByPtrPtr FloatBuffer yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const float[] alpha,
                                                            @Const @ByPtrPtr float[] Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr float[] xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Const float[] beta,
                                                            @ByPtrPtr float[] yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasDgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Const DoublePointer alpha,
                                                         @Cast("const double*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const double*const*") PointerPointer xarray,
                                                         int incx,
                                                         @Const DoublePointer beta,
                                                         @Cast("double*const*") PointerPointer yarray,
                                                         int incy,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Const DoublePointer alpha,
                                                         @Const @ByPtrPtr DoublePointer Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr DoublePointer xarray,
                                                         int incx,
                                                         @Const DoublePointer beta,
                                                         @ByPtrPtr DoublePointer yarray,
                                                         int incy,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Const DoubleBuffer alpha,
                                                         @Const @ByPtrPtr DoubleBuffer Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr DoubleBuffer xarray,
                                                         int incx,
                                                         @Const DoubleBuffer beta,
                                                         @ByPtrPtr DoubleBuffer yarray,
                                                         int incy,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Const double[] alpha,
                                                         @Const @ByPtrPtr double[] Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr double[] xarray,
                                                         int incx,
                                                         @Const double[] beta,
                                                         @ByPtrPtr double[] yarray,
                                                         int incy,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasDgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const DoublePointer alpha,
                                                            @Cast("const double*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const double*const*") PointerPointer xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Const DoublePointer beta,
                                                            @Cast("double*const*") PointerPointer yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const DoublePointer alpha,
                                                            @Const @ByPtrPtr DoublePointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr DoublePointer xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Const DoublePointer beta,
                                                            @ByPtrPtr DoublePointer yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const DoubleBuffer alpha,
                                                            @Const @ByPtrPtr DoubleBuffer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr DoubleBuffer xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Const DoubleBuffer beta,
                                                            @ByPtrPtr DoubleBuffer yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const double[] alpha,
                                                            @Const @ByPtrPtr double[] Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr double[] xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Const double[] beta,
                                                            @ByPtrPtr double[] yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const cuComplex*const*") PointerPointer xarray,
                                                         int incx,
                                                         @Cast("const cuComplex*") float2 beta,
                                                         @Cast("cuComplex*const*") PointerPointer yarray,
                                                         int incy,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasCgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                         int lda,
                                                         @Cast("const cuComplex*const*") @ByPtrPtr float2 xarray,
                                                         int incx,
                                                         @Cast("const cuComplex*") float2 beta,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 yarray,
                                                         int incy,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("const cuComplex*") float2 alpha,
                                                            @Cast("const cuComplex*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const cuComplex*const*") PointerPointer xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Cast("const cuComplex*") float2 beta,
                                                            @Cast("cuComplex*const*") PointerPointer yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasCgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("const cuComplex*") float2 alpha,
                                                            @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const cuComplex*const*") @ByPtrPtr float2 xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Cast("const cuComplex*") float2 beta,
                                                            @Cast("cuComplex*const*") @ByPtrPtr float2 yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasZgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const cuDoubleComplex*const*") PointerPointer xarray,
                                                         int incx,
                                                         @Cast("const cuDoubleComplex*") double2 beta,
                                                         @Cast("cuDoubleComplex*const*") PointerPointer yarray,
                                                         int incy,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasZgemvBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                         int lda,
                                                         @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 xarray,
                                                         int incx,
                                                         @Cast("const cuDoubleComplex*") double2 beta,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 yarray,
                                                         int incy,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasZgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("const cuDoubleComplex*") double2 alpha,
                                                            @Cast("const cuDoubleComplex*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const cuDoubleComplex*const*") PointerPointer xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Cast("const cuDoubleComplex*") double2 beta,
                                                            @Cast("cuDoubleComplex*const*") PointerPointer yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasZgemvBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("const cuDoubleComplex*") double2 alpha,
                                                            @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 xarray,
                                                            @Cast("int64_t") long incx,
                                                            @Cast("const cuDoubleComplex*") double2 beta,
                                                            @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 yarray,
                                                            @Cast("int64_t") long incy,
                                                            @Cast("int64_t") long batchCount);

// #if defined(__cplusplus)

public static native @Cast("cublasStatus_t") int cublasHSHgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatPointer alpha,
                                                           @Cast("const __half*const*") PointerPointer Aarray,
                                                           int lda,
                                                           @Cast("const __half*const*") PointerPointer xarray,
                                                           int incx,
                                                           @Const FloatPointer beta,
                                                           @Cast("__half*const*") PointerPointer yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatPointer alpha,
                                                           @Const @ByPtrPtr __half Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __half xarray,
                                                           int incx,
                                                           @Const FloatPointer beta,
                                                           @ByPtrPtr __half yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatBuffer alpha,
                                                           @Const @ByPtrPtr __half Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __half xarray,
                                                           int incx,
                                                           @Const FloatBuffer beta,
                                                           @ByPtrPtr __half yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const float[] alpha,
                                                           @Const @ByPtrPtr __half Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __half xarray,
                                                           int incx,
                                                           @Const float[] beta,
                                                           @ByPtrPtr __half yarray,
                                                           int incy,
                                                           int batchCount);

public static native @Cast("cublasStatus_t") int cublasHSHgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatPointer alpha,
                                                              @Cast("const __half*const*") PointerPointer Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Cast("const __half*const*") PointerPointer xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatPointer beta,
                                                              @Cast("__half*const*") PointerPointer yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatPointer alpha,
                                                              @Const @ByPtrPtr __half Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __half xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatPointer beta,
                                                              @ByPtrPtr __half yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatBuffer alpha,
                                                              @Const @ByPtrPtr __half Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __half xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatBuffer beta,
                                                              @ByPtrPtr __half yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const float[] alpha,
                                                              @Const @ByPtrPtr __half Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __half xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const float[] beta,
                                                              @ByPtrPtr __half yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasHSSgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatPointer alpha,
                                                           @Cast("const __half*const*") PointerPointer Aarray,
                                                           int lda,
                                                           @Cast("const __half*const*") PointerPointer xarray,
                                                           int incx,
                                                           @Const FloatPointer beta,
                                                           @Cast("float*const*") PointerPointer yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatPointer alpha,
                                                           @Const @ByPtrPtr __half Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __half xarray,
                                                           int incx,
                                                           @Const FloatPointer beta,
                                                           @ByPtrPtr FloatPointer yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatBuffer alpha,
                                                           @Const @ByPtrPtr __half Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __half xarray,
                                                           int incx,
                                                           @Const FloatBuffer beta,
                                                           @ByPtrPtr FloatBuffer yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const float[] alpha,
                                                           @Const @ByPtrPtr __half Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __half xarray,
                                                           int incx,
                                                           @Const float[] beta,
                                                           @ByPtrPtr float[] yarray,
                                                           int incy,
                                                           int batchCount);

public static native @Cast("cublasStatus_t") int cublasHSSgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatPointer alpha,
                                                              @Cast("const __half*const*") PointerPointer Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Cast("const __half*const*") PointerPointer xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatPointer beta,
                                                              @Cast("float*const*") PointerPointer yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatPointer alpha,
                                                              @Const @ByPtrPtr __half Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __half xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatPointer beta,
                                                              @ByPtrPtr FloatPointer yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatBuffer alpha,
                                                              @Const @ByPtrPtr __half Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __half xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatBuffer beta,
                                                              @ByPtrPtr FloatBuffer yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const float[] alpha,
                                                              @Const @ByPtrPtr __half Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __half xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const float[] beta,
                                                              @ByPtrPtr float[] yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasTSTgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatPointer alpha,
                                                           @Cast("const __nv_bfloat16*const*") PointerPointer Aarray,
                                                           int lda,
                                                           @Cast("const __nv_bfloat16*const*") PointerPointer xarray,
                                                           int incx,
                                                           @Const FloatPointer beta,
                                                           @Cast("__nv_bfloat16*const*") PointerPointer yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatPointer alpha,
                                                           @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                           int incx,
                                                           @Const FloatPointer beta,
                                                           @ByPtrPtr __nv_bfloat16 yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatBuffer alpha,
                                                           @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                           int incx,
                                                           @Const FloatBuffer beta,
                                                           @ByPtrPtr __nv_bfloat16 yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const float[] alpha,
                                                           @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                           int incx,
                                                           @Const float[] beta,
                                                           @ByPtrPtr __nv_bfloat16 yarray,
                                                           int incy,
                                                           int batchCount);

public static native @Cast("cublasStatus_t") int cublasTSTgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatPointer alpha,
                                                              @Cast("const __nv_bfloat16*const*") PointerPointer Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Cast("const __nv_bfloat16*const*") PointerPointer xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatPointer beta,
                                                              @Cast("__nv_bfloat16*const*") PointerPointer yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatPointer alpha,
                                                              @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatPointer beta,
                                                              @ByPtrPtr __nv_bfloat16 yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatBuffer alpha,
                                                              @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatBuffer beta,
                                                              @ByPtrPtr __nv_bfloat16 yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const float[] alpha,
                                                              @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const float[] beta,
                                                              @ByPtrPtr __nv_bfloat16 yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasTSSgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatPointer alpha,
                                                           @Cast("const __nv_bfloat16*const*") PointerPointer Aarray,
                                                           int lda,
                                                           @Cast("const __nv_bfloat16*const*") PointerPointer xarray,
                                                           int incx,
                                                           @Const FloatPointer beta,
                                                           @Cast("float*const*") PointerPointer yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatPointer alpha,
                                                           @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                           int incx,
                                                           @Const FloatPointer beta,
                                                           @ByPtrPtr FloatPointer yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const FloatBuffer alpha,
                                                           @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                           int incx,
                                                           @Const FloatBuffer beta,
                                                           @ByPtrPtr FloatBuffer yarray,
                                                           int incy,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int trans,
                                                           int m,
                                                           int n,
                                                           @Const float[] alpha,
                                                           @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                           int lda,
                                                           @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                           int incx,
                                                           @Const float[] beta,
                                                           @ByPtrPtr float[] yarray,
                                                           int incy,
                                                           int batchCount);

public static native @Cast("cublasStatus_t") int cublasTSSgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatPointer alpha,
                                                              @Cast("const __nv_bfloat16*const*") PointerPointer Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Cast("const __nv_bfloat16*const*") PointerPointer xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatPointer beta,
                                                              @Cast("float*const*") PointerPointer yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatPointer alpha,
                                                              @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatPointer beta,
                                                              @ByPtrPtr FloatPointer yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const FloatBuffer alpha,
                                                              @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const FloatBuffer beta,
                                                              @ByPtrPtr FloatBuffer yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int trans,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Const float[] alpha,
                                                              @Const @ByPtrPtr __nv_bfloat16 Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Const @ByPtrPtr __nv_bfloat16 xarray,
                                                              @Cast("int64_t") long incx,
                                                              @Const float[] beta,
                                                              @ByPtrPtr float[] yarray,
                                                              @Cast("int64_t") long incy,
                                                              @Cast("int64_t") long batchCount);

// #endif

public static native @Cast("cublasStatus_t") int cublasSgemvStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int trans,
                                                                int m,
                                                                int n,
                                                                @Const FloatPointer alpha,
                                                                @Const FloatPointer A,
                                                                int lda,
                                                                long strideA,
                                                                @Const FloatPointer x,
                                                                int incx,
                                                                long stridex,
                                                                @Const FloatPointer beta,
                                                                FloatPointer y,
                                                                int incy,
                                                                long stridey,
                                                                int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int trans,
                                                                int m,
                                                                int n,
                                                                @Const FloatBuffer alpha,
                                                                @Const FloatBuffer A,
                                                                int lda,
                                                                long strideA,
                                                                @Const FloatBuffer x,
                                                                int incx,
                                                                long stridex,
                                                                @Const FloatBuffer beta,
                                                                FloatBuffer y,
                                                                int incy,
                                                                long stridey,
                                                                int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int trans,
                                                                int m,
                                                                int n,
                                                                @Const float[] alpha,
                                                                @Const float[] A,
                                                                int lda,
                                                                long strideA,
                                                                @Const float[] x,
                                                                int incx,
                                                                long stridex,
                                                                @Const float[] beta,
                                                                float[] y,
                                                                int incy,
                                                                long stridey,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasSgemvStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int trans,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Const FloatPointer alpha,
                                                                   @Const FloatPointer A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const FloatPointer x,
                                                                   @Cast("int64_t") long incx,
                                                                   long stridex,
                                                                   @Const FloatPointer beta,
                                                                   FloatPointer y,
                                                                   @Cast("int64_t") long incy,
                                                                   long stridey,
                                                                   @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int trans,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Const FloatBuffer alpha,
                                                                   @Const FloatBuffer A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const FloatBuffer x,
                                                                   @Cast("int64_t") long incx,
                                                                   long stridex,
                                                                   @Const FloatBuffer beta,
                                                                   FloatBuffer y,
                                                                   @Cast("int64_t") long incy,
                                                                   long stridey,
                                                                   @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemvStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int trans,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Const float[] alpha,
                                                                   @Const float[] A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const float[] x,
                                                                   @Cast("int64_t") long incx,
                                                                   long stridex,
                                                                   @Const float[] beta,
                                                                   float[] y,
                                                                   @Cast("int64_t") long incy,
                                                                   long stridey,
                                                                   @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasDgemvStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int trans,
                                                                int m,
                                                                int n,
                                                                @Const DoublePointer alpha,
                                                                @Const DoublePointer A,
                                                                int lda,
                                                                long strideA,
                                                                @Const DoublePointer x,
                                                                int incx,
                                                                long stridex,
                                                                @Const DoublePointer beta,
                                                                DoublePointer y,
                                                                int incy,
                                                                long stridey,
                                                                int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int trans,
                                                                int m,
                                                                int n,
                                                                @Const DoubleBuffer alpha,
                                                                @Const DoubleBuffer A,
                                                                int lda,
                                                                long strideA,
                                                                @Const DoubleBuffer x,
                                                                int incx,
                                                                long stridex,
                                                                @Const DoubleBuffer beta,
                                                                DoubleBuffer y,
                                                                int incy,
                                                                long stridey,
                                                                int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int trans,
                                                                int m,
                                                                int n,
                                                                @Const double[] alpha,
                                                                @Const double[] A,
                                                                int lda,
                                                                long strideA,
                                                                @Const double[] x,
                                                                int incx,
                                                                long stridex,
                                                                @Const double[] beta,
                                                                double[] y,
                                                                int incy,
                                                                long stridey,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasDgemvStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int trans,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Const DoublePointer alpha,
                                                                   @Const DoublePointer A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const DoublePointer x,
                                                                   @Cast("int64_t") long incx,
                                                                   long stridex,
                                                                   @Const DoublePointer beta,
                                                                   DoublePointer y,
                                                                   @Cast("int64_t") long incy,
                                                                   long stridey,
                                                                   @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int trans,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Const DoubleBuffer alpha,
                                                                   @Const DoubleBuffer A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const DoubleBuffer x,
                                                                   @Cast("int64_t") long incx,
                                                                   long stridex,
                                                                   @Const DoubleBuffer beta,
                                                                   DoubleBuffer y,
                                                                   @Cast("int64_t") long incy,
                                                                   long stridey,
                                                                   @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemvStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int trans,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Const double[] alpha,
                                                                   @Const double[] A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const double[] x,
                                                                   @Cast("int64_t") long incx,
                                                                   long stridex,
                                                                   @Const double[] beta,
                                                                   double[] y,
                                                                   @Cast("int64_t") long incy,
                                                                   long stridey,
                                                                   @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemvStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int trans,
                                                                int m,
                                                                int n,
                                                                @Cast("const cuComplex*") float2 alpha,
                                                                @Cast("const cuComplex*") float2 A,
                                                                int lda,
                                                                long strideA,
                                                                @Cast("const cuComplex*") float2 x,
                                                                int incx,
                                                                long stridex,
                                                                @Cast("const cuComplex*") float2 beta,
                                                                @Cast("cuComplex*") float2 y,
                                                                int incy,
                                                                long stridey,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemvStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int trans,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("const cuComplex*") float2 alpha,
                                                                   @Cast("const cuComplex*") float2 A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Cast("const cuComplex*") float2 x,
                                                                   @Cast("int64_t") long incx,
                                                                   long stridex,
                                                                   @Cast("const cuComplex*") float2 beta,
                                                                   @Cast("cuComplex*") float2 y,
                                                                   @Cast("int64_t") long incy,
                                                                   long stridey,
                                                                   @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasZgemvStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int trans,
                                                                int m,
                                                                int n,
                                                                @Cast("const cuDoubleComplex*") double2 alpha,
                                                                @Cast("const cuDoubleComplex*") double2 A,
                                                                int lda,
                                                                long strideA,
                                                                @Cast("const cuDoubleComplex*") double2 x,
                                                                int incx,
                                                                long stridex,
                                                                @Cast("const cuDoubleComplex*") double2 beta,
                                                                @Cast("cuDoubleComplex*") double2 y,
                                                                int incy,
                                                                long stridey,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasZgemvStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int trans,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("const cuDoubleComplex*") double2 alpha,
                                                                   @Cast("const cuDoubleComplex*") double2 A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Cast("const cuDoubleComplex*") double2 x,
                                                                   @Cast("int64_t") long incx,
                                                                   long stridex,
                                                                   @Cast("const cuDoubleComplex*") double2 beta,
                                                                   @Cast("cuDoubleComplex*") double2 y,
                                                                   @Cast("int64_t") long incy,
                                                                   long stridey,
                                                                   @Cast("int64_t") long batchCount);

// #if defined(__cplusplus)

public static native @Cast("cublasStatus_t") int cublasHSHgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const FloatPointer alpha,
                                                                  @Const __half A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __half x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const FloatPointer beta,
                                                                  __half y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const FloatBuffer alpha,
                                                                  @Const __half A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __half x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const FloatBuffer beta,
                                                                  __half y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const float[] alpha,
                                                                  @Const __half A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __half x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const float[] beta,
                                                                  __half y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);

public static native @Cast("cublasStatus_t") int cublasHSHgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const FloatPointer alpha,
                                                                     @Const __half A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __half x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const FloatPointer beta,
                                                                     __half y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const FloatBuffer alpha,
                                                                     @Const __half A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __half x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const FloatBuffer beta,
                                                                     __half y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSHgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const float[] alpha,
                                                                     @Const __half A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __half x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const float[] beta,
                                                                     __half y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasHSSgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const FloatPointer alpha,
                                                                  @Const __half A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __half x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const FloatPointer beta,
                                                                  FloatPointer y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const FloatBuffer alpha,
                                                                  @Const __half A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __half x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const FloatBuffer beta,
                                                                  FloatBuffer y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const float[] alpha,
                                                                  @Const __half A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __half x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const float[] beta,
                                                                  float[] y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);

public static native @Cast("cublasStatus_t") int cublasHSSgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const FloatPointer alpha,
                                                                     @Const __half A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __half x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const FloatPointer beta,
                                                                     FloatPointer y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const FloatBuffer alpha,
                                                                     @Const __half A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __half x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const FloatBuffer beta,
                                                                     FloatBuffer y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHSSgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const float[] alpha,
                                                                     @Const __half A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __half x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const float[] beta,
                                                                     float[] y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasTSTgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const FloatPointer alpha,
                                                                  @Const __nv_bfloat16 A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __nv_bfloat16 x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const FloatPointer beta,
                                                                  __nv_bfloat16 y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const FloatBuffer alpha,
                                                                  @Const __nv_bfloat16 A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __nv_bfloat16 x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const FloatBuffer beta,
                                                                  __nv_bfloat16 y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const float[] alpha,
                                                                  @Const __nv_bfloat16 A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __nv_bfloat16 x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const float[] beta,
                                                                  __nv_bfloat16 y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);

public static native @Cast("cublasStatus_t") int cublasTSTgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const FloatPointer alpha,
                                                                     @Const __nv_bfloat16 A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __nv_bfloat16 x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const FloatPointer beta,
                                                                     __nv_bfloat16 y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const FloatBuffer alpha,
                                                                     @Const __nv_bfloat16 A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __nv_bfloat16 x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const FloatBuffer beta,
                                                                     __nv_bfloat16 y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSTgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const float[] alpha,
                                                                     @Const __nv_bfloat16 A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __nv_bfloat16 x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const float[] beta,
                                                                     __nv_bfloat16 y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasTSSgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const FloatPointer alpha,
                                                                  @Const __nv_bfloat16 A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __nv_bfloat16 x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const FloatPointer beta,
                                                                  FloatPointer y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const FloatBuffer alpha,
                                                                  @Const __nv_bfloat16 A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __nv_bfloat16 x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const FloatBuffer beta,
                                                                  FloatBuffer y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int trans,
                                                                  int m,
                                                                  int n,
                                                                  @Const float[] alpha,
                                                                  @Const __nv_bfloat16 A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Const __nv_bfloat16 x,
                                                                  int incx,
                                                                  long stridex,
                                                                  @Const float[] beta,
                                                                  float[] y,
                                                                  int incy,
                                                                  long stridey,
                                                                  int batchCount);

public static native @Cast("cublasStatus_t") int cublasTSSgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const FloatPointer alpha,
                                                                     @Const __nv_bfloat16 A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __nv_bfloat16 x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const FloatPointer beta,
                                                                     FloatPointer y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const FloatBuffer alpha,
                                                                     @Const __nv_bfloat16 A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __nv_bfloat16 x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const FloatBuffer beta,
                                                                     FloatBuffer y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasTSSgemvStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int trans,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Const float[] alpha,
                                                                     @Const __nv_bfloat16 A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Const __nv_bfloat16 x,
                                                                     @Cast("int64_t") long incx,
                                                                     long stridex,
                                                                     @Const float[] beta,
                                                                     float[] y,
                                                                     @Cast("int64_t") long incy,
                                                                     long stridey,
                                                                     @Cast("int64_t") long batchCount);

// #endif

/* ---------------- CUBLAS BLAS3 Functions ---------------- */

/* GEMM */

public static native @Cast("cublasStatus_t") int cublasSgemm_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     int m,
                                                     int n,
                                                     int k,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     @Const FloatPointer B,
                                                     int ldb,
                                                     @Const FloatPointer beta,
                                                     FloatPointer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasSgemm_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     int m,
                                                     int n,
                                                     int k,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     @Const FloatBuffer B,
                                                     int ldb,
                                                     @Const FloatBuffer beta,
                                                     FloatBuffer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasSgemm_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     int m,
                                                     int n,
                                                     int k,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     @Const float[] B,
                                                     int ldb,
                                                     @Const float[] beta,
                                                     float[] C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasSgemm_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int transa,
                                                        @Cast("cublasOperation_t") int transb,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const FloatPointer beta,
                                                        FloatPointer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSgemm_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int transa,
                                                        @Cast("cublasOperation_t") int transb,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const FloatBuffer beta,
                                                        FloatBuffer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSgemm_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int transa,
                                                        @Cast("cublasOperation_t") int transb,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const float[] beta,
                                                        float[] C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasDgemm_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     int m,
                                                     int n,
                                                     int k,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     @Const DoublePointer B,
                                                     int ldb,
                                                     @Const DoublePointer beta,
                                                     DoublePointer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasDgemm_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     int m,
                                                     int n,
                                                     int k,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     @Const DoubleBuffer B,
                                                     int ldb,
                                                     @Const DoubleBuffer beta,
                                                     DoubleBuffer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasDgemm_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     int m,
                                                     int n,
                                                     int k,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     @Const double[] B,
                                                     int ldb,
                                                     @Const double[] beta,
                                                     double[] C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasDgemm_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int transa,
                                                        @Cast("cublasOperation_t") int transb,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const DoublePointer beta,
                                                        DoublePointer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDgemm_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int transa,
                                                        @Cast("cublasOperation_t") int transb,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const DoubleBuffer beta,
                                                        DoubleBuffer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDgemm_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int transa,
                                                        @Cast("cublasOperation_t") int transb,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const double[] beta,
                                                        double[] C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCgemm_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     int m,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 B,
                                                     int ldb,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasCgemm_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int transa,
                                                        @Cast("cublasOperation_t") int transb,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 B,
                                                        @Cast("int64_t") long ldb,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCgemm3m(cublasContext handle,
                                                    @Cast("cublasOperation_t") int transa,
                                                    @Cast("cublasOperation_t") int transb,
                                                    int m,
                                                    int n,
                                                    int k,
                                                    @Cast("const cuComplex*") float2 alpha,
                                                    @Cast("const cuComplex*") float2 A,
                                                    int lda,
                                                    @Cast("const cuComplex*") float2 B,
                                                    int ldb,
                                                    @Cast("const cuComplex*") float2 beta,
                                                    @Cast("cuComplex*") float2 C,
                                                    int ldc);

public static native @Cast("cublasStatus_t") int cublasCgemm3m_64(cublasContext handle,
                                                       @Cast("cublasOperation_t") int transa,
                                                       @Cast("cublasOperation_t") int transb,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Cast("const cuComplex*") float2 alpha,
                                                       @Cast("const cuComplex*") float2 A,
                                                       @Cast("int64_t") long lda,
                                                       @Cast("const cuComplex*") float2 B,
                                                       @Cast("int64_t") long ldb,
                                                       @Cast("const cuComplex*") float2 beta,
                                                       @Cast("cuComplex*") float2 C,
                                                       @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCgemm3mEx(cublasContext handle,
                                                      @Cast("cublasOperation_t") int transa,
                                                      @Cast("cublasOperation_t") int transb,
                                                      int m,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Const Pointer A,
                                                      @Cast("cudaDataType") int Atype,
                                                      int lda,
                                                      @Const Pointer B,
                                                      @Cast("cudaDataType") int Btype,
                                                      int ldb,
                                                      @Cast("const cuComplex*") float2 beta,
                                                      Pointer C,
                                                      @Cast("cudaDataType") int Ctype,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasCgemm3mEx_64(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         @Cast("int64_t") long m,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Const Pointer A,
                                                         @Cast("cudaDataType") int Atype,
                                                         @Cast("int64_t") long lda,
                                                         @Const Pointer B,
                                                         @Cast("cudaDataType") int Btype,
                                                         @Cast("int64_t") long ldb,
                                                         @Cast("const cuComplex*") float2 beta,
                                                         Pointer C,
                                                         @Cast("cudaDataType") int Ctype,
                                                         @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZgemm_v2(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     int m,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 B,
                                                     int ldb,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasZgemm_v2_64(cublasContext handle,
                                                        @Cast("cublasOperation_t") int transa,
                                                        @Cast("cublasOperation_t") int transb,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 B,
                                                        @Cast("int64_t") long ldb,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZgemm3m(cublasContext handle,
                                                    @Cast("cublasOperation_t") int transa,
                                                    @Cast("cublasOperation_t") int transb,
                                                    int m,
                                                    int n,
                                                    int k,
                                                    @Cast("const cuDoubleComplex*") double2 alpha,
                                                    @Cast("const cuDoubleComplex*") double2 A,
                                                    int lda,
                                                    @Cast("const cuDoubleComplex*") double2 B,
                                                    int ldb,
                                                    @Cast("const cuDoubleComplex*") double2 beta,
                                                    @Cast("cuDoubleComplex*") double2 C,
                                                    int ldc);

public static native @Cast("cublasStatus_t") int cublasZgemm3m_64(cublasContext handle,
                                                       @Cast("cublasOperation_t") int transa,
                                                       @Cast("cublasOperation_t") int transb,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Cast("const cuDoubleComplex*") double2 alpha,
                                                       @Cast("const cuDoubleComplex*") double2 A,
                                                       @Cast("int64_t") long lda,
                                                       @Cast("const cuDoubleComplex*") double2 B,
                                                       @Cast("int64_t") long ldb,
                                                       @Cast("const cuDoubleComplex*") double2 beta,
                                                       @Cast("cuDoubleComplex*") double2 C,
                                                       @Cast("int64_t") long ldc);

// #if defined(__cplusplus)

public static native @Cast("cublasStatus_t") int cublasHgemm(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  int k,
                                                  @Const __half alpha,
                                                  @Const __half A,
                                                  int lda,
                                                  @Const __half B,
                                                  int ldb,
                                                  @Const __half beta,
                                                  __half C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasHgemm_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Cast("int64_t") long k,
                                                     @Const __half alpha,
                                                     @Const __half A,
                                                     @Cast("int64_t") long lda,
                                                     @Const __half B,
                                                     @Cast("int64_t") long ldb,
                                                     @Const __half beta,
                                                     __half C,
                                                     @Cast("int64_t") long ldc);

// #endif

public static native @Cast("cublasStatus_t") int cublasSgemmEx(cublasContext handle,
                                                    @Cast("cublasOperation_t") int transa,
                                                    @Cast("cublasOperation_t") int transb,
                                                    int m,
                                                    int n,
                                                    int k,
                                                    @Const FloatPointer alpha,
                                                    @Const Pointer A,
                                                    @Cast("cudaDataType") int Atype,
                                                    int lda,
                                                    @Const Pointer B,
                                                    @Cast("cudaDataType") int Btype,
                                                    int ldb,
                                                    @Const FloatPointer beta,
                                                    Pointer C,
                                                    @Cast("cudaDataType") int Ctype,
                                                    int ldc);
public static native @Cast("cublasStatus_t") int cublasSgemmEx(cublasContext handle,
                                                    @Cast("cublasOperation_t") int transa,
                                                    @Cast("cublasOperation_t") int transb,
                                                    int m,
                                                    int n,
                                                    int k,
                                                    @Const FloatBuffer alpha,
                                                    @Const Pointer A,
                                                    @Cast("cudaDataType") int Atype,
                                                    int lda,
                                                    @Const Pointer B,
                                                    @Cast("cudaDataType") int Btype,
                                                    int ldb,
                                                    @Const FloatBuffer beta,
                                                    Pointer C,
                                                    @Cast("cudaDataType") int Ctype,
                                                    int ldc);
public static native @Cast("cublasStatus_t") int cublasSgemmEx(cublasContext handle,
                                                    @Cast("cublasOperation_t") int transa,
                                                    @Cast("cublasOperation_t") int transb,
                                                    int m,
                                                    int n,
                                                    int k,
                                                    @Const float[] alpha,
                                                    @Const Pointer A,
                                                    @Cast("cudaDataType") int Atype,
                                                    int lda,
                                                    @Const Pointer B,
                                                    @Cast("cudaDataType") int Btype,
                                                    int ldb,
                                                    @Const float[] beta,
                                                    Pointer C,
                                                    @Cast("cudaDataType") int Ctype,
                                                    int ldc);

public static native @Cast("cublasStatus_t") int cublasSgemmEx_64(cublasContext handle,
                                                       @Cast("cublasOperation_t") int transa,
                                                       @Cast("cublasOperation_t") int transb,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Const FloatPointer alpha,
                                                       @Const Pointer A,
                                                       @Cast("cudaDataType") int Atype,
                                                       @Cast("int64_t") long lda,
                                                       @Const Pointer B,
                                                       @Cast("cudaDataType") int Btype,
                                                       @Cast("int64_t") long ldb,
                                                       @Const FloatPointer beta,
                                                       Pointer C,
                                                       @Cast("cudaDataType") int Ctype,
                                                       @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSgemmEx_64(cublasContext handle,
                                                       @Cast("cublasOperation_t") int transa,
                                                       @Cast("cublasOperation_t") int transb,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Const FloatBuffer alpha,
                                                       @Const Pointer A,
                                                       @Cast("cudaDataType") int Atype,
                                                       @Cast("int64_t") long lda,
                                                       @Const Pointer B,
                                                       @Cast("cudaDataType") int Btype,
                                                       @Cast("int64_t") long ldb,
                                                       @Const FloatBuffer beta,
                                                       Pointer C,
                                                       @Cast("cudaDataType") int Ctype,
                                                       @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSgemmEx_64(cublasContext handle,
                                                       @Cast("cublasOperation_t") int transa,
                                                       @Cast("cublasOperation_t") int transb,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Const float[] alpha,
                                                       @Const Pointer A,
                                                       @Cast("cudaDataType") int Atype,
                                                       @Cast("int64_t") long lda,
                                                       @Const Pointer B,
                                                       @Cast("cudaDataType") int Btype,
                                                       @Cast("int64_t") long ldb,
                                                       @Const float[] beta,
                                                       Pointer C,
                                                       @Cast("cudaDataType") int Ctype,
                                                       @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasGemmEx(cublasContext handle,
                                                   @Cast("cublasOperation_t") int transa,
                                                   @Cast("cublasOperation_t") int transb,
                                                   int m,
                                                   int n,
                                                   int k,
                                                   @Const Pointer alpha,
                                                   @Const Pointer A,
                                                   @Cast("cudaDataType") int Atype,
                                                   int lda,
                                                   @Const Pointer B,
                                                   @Cast("cudaDataType") int Btype,
                                                   int ldb,
                                                   @Const Pointer beta,
                                                   Pointer C,
                                                   @Cast("cudaDataType") int Ctype,
                                                   int ldc,
                                                   @Cast("cublasComputeType_t") int computeType,
                                                   @Cast("cublasGemmAlgo_t") int algo);

public static native @Cast("cublasStatus_t") int cublasGemmEx_64(cublasContext handle,
                                                      @Cast("cublasOperation_t") int transa,
                                                      @Cast("cublasOperation_t") int transb,
                                                      @Cast("int64_t") long m,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Const Pointer alpha,
                                                      @Const Pointer A,
                                                      @Cast("cudaDataType") int Atype,
                                                      @Cast("int64_t") long lda,
                                                      @Const Pointer B,
                                                      @Cast("cudaDataType") int Btype,
                                                      @Cast("int64_t") long ldb,
                                                      @Const Pointer beta,
                                                      Pointer C,
                                                      @Cast("cudaDataType") int Ctype,
                                                      @Cast("int64_t") long ldc,
                                                      @Cast("cublasComputeType_t") int computeType,
                                                      @Cast("cublasGemmAlgo_t") int algo);

public static native @Cast("cublasStatus_t") int cublasCgemmEx(cublasContext handle,
                                                    @Cast("cublasOperation_t") int transa,
                                                    @Cast("cublasOperation_t") int transb,
                                                    int m,
                                                    int n,
                                                    int k,
                                                    @Cast("const cuComplex*") float2 alpha,
                                                    @Const Pointer A,
                                                    @Cast("cudaDataType") int Atype,
                                                    int lda,
                                                    @Const Pointer B,
                                                    @Cast("cudaDataType") int Btype,
                                                    int ldb,
                                                    @Cast("const cuComplex*") float2 beta,
                                                    Pointer C,
                                                    @Cast("cudaDataType") int Ctype,
                                                    int ldc);

public static native @Cast("cublasStatus_t") int cublasCgemmEx_64(cublasContext handle,
                                                       @Cast("cublasOperation_t") int transa,
                                                       @Cast("cublasOperation_t") int transb,
                                                       @Cast("int64_t") long m,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Cast("const cuComplex*") float2 alpha,
                                                       @Const Pointer A,
                                                       @Cast("cudaDataType") int Atype,
                                                       @Cast("int64_t") long lda,
                                                       @Const Pointer B,
                                                       @Cast("cudaDataType") int Btype,
                                                       @Cast("int64_t") long ldb,
                                                       @Cast("const cuComplex*") float2 beta,
                                                       Pointer C,
                                                       @Cast("cudaDataType") int Ctype,
                                                       @Cast("int64_t") long ldc);

/* SYRK */

public static native @Cast("cublasStatus_t") int cublasSsyrk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     @Const FloatPointer beta,
                                                     FloatPointer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasSsyrk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     @Const FloatBuffer beta,
                                                     FloatBuffer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasSsyrk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     @Const float[] beta,
                                                     float[] C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasSsyrk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer beta,
                                                        FloatPointer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSsyrk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer beta,
                                                        FloatBuffer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSsyrk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] beta,
                                                        float[] C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasDsyrk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     @Const DoublePointer beta,
                                                     DoublePointer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasDsyrk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     @Const DoubleBuffer beta,
                                                     DoubleBuffer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasDsyrk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     @Const double[] beta,
                                                     double[] C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasDsyrk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer beta,
                                                        DoublePointer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDsyrk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer beta,
                                                        DoubleBuffer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDsyrk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] beta,
                                                        double[] C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCsyrk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasCsyrk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZsyrk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasZsyrk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCsyrkEx(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    @Cast("cublasOperation_t") int trans,
                                                    int n,
                                                    int k,
                                                    @Cast("const cuComplex*") float2 alpha,
                                                    @Const Pointer A,
                                                    @Cast("cudaDataType") int Atype,
                                                    int lda,
                                                    @Cast("const cuComplex*") float2 beta,
                                                    Pointer C,
                                                    @Cast("cudaDataType") int Ctype,
                                                    int ldc);

public static native @Cast("cublasStatus_t") int cublasCsyrkEx_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("cublasOperation_t") int trans,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Cast("const cuComplex*") float2 alpha,
                                                       @Const Pointer A,
                                                       @Cast("cudaDataType") int Atype,
                                                       @Cast("int64_t") long lda,
                                                       @Cast("const cuComplex*") float2 beta,
                                                       Pointer C,
                                                       @Cast("cudaDataType") int Ctype,
                                                       @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCsyrk3mEx(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Const Pointer A,
                                                      @Cast("cudaDataType") int Atype,
                                                      int lda,
                                                      @Cast("const cuComplex*") float2 beta,
                                                      Pointer C,
                                                      @Cast("cudaDataType") int Ctype,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasCsyrk3mEx_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Const Pointer A,
                                                         @Cast("cudaDataType") int Atype,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuComplex*") float2 beta,
                                                         Pointer C,
                                                         @Cast("cudaDataType") int Ctype,
                                                         @Cast("int64_t") long ldc);

/* HERK */

public static native @Cast("cublasStatus_t") int cublasCherk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const FloatPointer alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Const FloatPointer beta,
                                                     @Cast("cuComplex*") float2 C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasCherk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const FloatBuffer alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Const FloatBuffer beta,
                                                     @Cast("cuComplex*") float2 C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasCherk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const float[] alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Const float[] beta,
                                                     @Cast("cuComplex*") float2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasCherk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatPointer alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer beta,
                                                        @Cast("cuComplex*") float2 C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCherk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const FloatBuffer alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer beta,
                                                        @Cast("cuComplex*") float2 C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCherk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const float[] alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] beta,
                                                        @Cast("cuComplex*") float2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZherk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const DoublePointer alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Const DoublePointer beta,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasZherk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const DoubleBuffer alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Const DoubleBuffer beta,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasZherk_v2(cublasContext handle,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     int n,
                                                     int k,
                                                     @Const double[] alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Const double[] beta,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasZherk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoublePointer alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer beta,
                                                        @Cast("cuDoubleComplex*") double2 C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasZherk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const DoubleBuffer alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer beta,
                                                        @Cast("cuDoubleComplex*") double2 C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasZherk_v2_64(cublasContext handle,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("int64_t") long n,
                                                        @Cast("int64_t") long k,
                                                        @Const double[] alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] beta,
                                                        @Cast("cuDoubleComplex*") double2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCherkEx(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    @Cast("cublasOperation_t") int trans,
                                                    int n,
                                                    int k,
                                                    @Const FloatPointer alpha,
                                                    @Const Pointer A,
                                                    @Cast("cudaDataType") int Atype,
                                                    int lda,
                                                    @Const FloatPointer beta,
                                                    Pointer C,
                                                    @Cast("cudaDataType") int Ctype,
                                                    int ldc);
public static native @Cast("cublasStatus_t") int cublasCherkEx(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    @Cast("cublasOperation_t") int trans,
                                                    int n,
                                                    int k,
                                                    @Const FloatBuffer alpha,
                                                    @Const Pointer A,
                                                    @Cast("cudaDataType") int Atype,
                                                    int lda,
                                                    @Const FloatBuffer beta,
                                                    Pointer C,
                                                    @Cast("cudaDataType") int Ctype,
                                                    int ldc);
public static native @Cast("cublasStatus_t") int cublasCherkEx(cublasContext handle,
                                                    @Cast("cublasFillMode_t") int uplo,
                                                    @Cast("cublasOperation_t") int trans,
                                                    int n,
                                                    int k,
                                                    @Const float[] alpha,
                                                    @Const Pointer A,
                                                    @Cast("cudaDataType") int Atype,
                                                    int lda,
                                                    @Const float[] beta,
                                                    Pointer C,
                                                    @Cast("cudaDataType") int Ctype,
                                                    int ldc);

public static native @Cast("cublasStatus_t") int cublasCherkEx_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("cublasOperation_t") int trans,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Const FloatPointer alpha,
                                                       @Const Pointer A,
                                                       @Cast("cudaDataType") int Atype,
                                                       @Cast("int64_t") long lda,
                                                       @Const FloatPointer beta,
                                                       Pointer C,
                                                       @Cast("cudaDataType") int Ctype,
                                                       @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCherkEx_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("cublasOperation_t") int trans,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Const FloatBuffer alpha,
                                                       @Const Pointer A,
                                                       @Cast("cudaDataType") int Atype,
                                                       @Cast("int64_t") long lda,
                                                       @Const FloatBuffer beta,
                                                       Pointer C,
                                                       @Cast("cudaDataType") int Ctype,
                                                       @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCherkEx_64(cublasContext handle,
                                                       @Cast("cublasFillMode_t") int uplo,
                                                       @Cast("cublasOperation_t") int trans,
                                                       @Cast("int64_t") long n,
                                                       @Cast("int64_t") long k,
                                                       @Const float[] alpha,
                                                       @Const Pointer A,
                                                       @Cast("cudaDataType") int Atype,
                                                       @Cast("int64_t") long lda,
                                                       @Const float[] beta,
                                                       Pointer C,
                                                       @Cast("cudaDataType") int Ctype,
                                                       @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCherk3mEx(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const FloatPointer alpha,
                                                      @Const Pointer A,
                                                      @Cast("cudaDataType") int Atype,
                                                      int lda,
                                                      @Const FloatPointer beta,
                                                      Pointer C,
                                                      @Cast("cudaDataType") int Ctype,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasCherk3mEx(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const FloatBuffer alpha,
                                                      @Const Pointer A,
                                                      @Cast("cudaDataType") int Atype,
                                                      int lda,
                                                      @Const FloatBuffer beta,
                                                      Pointer C,
                                                      @Cast("cudaDataType") int Ctype,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasCherk3mEx(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const float[] alpha,
                                                      @Const Pointer A,
                                                      @Cast("cudaDataType") int Atype,
                                                      int lda,
                                                      @Const float[] beta,
                                                      Pointer C,
                                                      @Cast("cudaDataType") int Ctype,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasCherk3mEx_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const FloatPointer alpha,
                                                         @Const Pointer A,
                                                         @Cast("cudaDataType") int Atype,
                                                         @Cast("int64_t") long lda,
                                                         @Const FloatPointer beta,
                                                         Pointer C,
                                                         @Cast("cudaDataType") int Ctype,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCherk3mEx_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const FloatBuffer alpha,
                                                         @Const Pointer A,
                                                         @Cast("cudaDataType") int Atype,
                                                         @Cast("int64_t") long lda,
                                                         @Const FloatBuffer beta,
                                                         Pointer C,
                                                         @Cast("cudaDataType") int Ctype,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCherk3mEx_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const float[] alpha,
                                                         @Const Pointer A,
                                                         @Cast("cudaDataType") int Atype,
                                                         @Cast("int64_t") long lda,
                                                         @Const float[] beta,
                                                         Pointer C,
                                                         @Cast("cudaDataType") int Ctype,
                                                         @Cast("int64_t") long ldc);

/* SYR2K / HER2K */

public static native @Cast("cublasStatus_t") int cublasSsyr2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const FloatPointer alpha,
                                                      @Const FloatPointer A,
                                                      int lda,
                                                      @Const FloatPointer B,
                                                      int ldb,
                                                      @Const FloatPointer beta,
                                                      FloatPointer C,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasSsyr2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const FloatBuffer alpha,
                                                      @Const FloatBuffer A,
                                                      int lda,
                                                      @Const FloatBuffer B,
                                                      int ldb,
                                                      @Const FloatBuffer beta,
                                                      FloatBuffer C,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasSsyr2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const float[] alpha,
                                                      @Const float[] A,
                                                      int lda,
                                                      @Const float[] B,
                                                      int ldb,
                                                      @Const float[] beta,
                                                      float[] C,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasSsyr2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const FloatPointer alpha,
                                                         @Const FloatPointer A,
                                                         @Cast("int64_t") long lda,
                                                         @Const FloatPointer B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const FloatPointer beta,
                                                         FloatPointer C,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSsyr2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const FloatBuffer alpha,
                                                         @Const FloatBuffer A,
                                                         @Cast("int64_t") long lda,
                                                         @Const FloatBuffer B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const FloatBuffer beta,
                                                         FloatBuffer C,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSsyr2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const float[] alpha,
                                                         @Const float[] A,
                                                         @Cast("int64_t") long lda,
                                                         @Const float[] B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const float[] beta,
                                                         float[] C,
                                                         @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasDsyr2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const DoublePointer alpha,
                                                      @Const DoublePointer A,
                                                      int lda,
                                                      @Const DoublePointer B,
                                                      int ldb,
                                                      @Const DoublePointer beta,
                                                      DoublePointer C,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasDsyr2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const DoubleBuffer alpha,
                                                      @Const DoubleBuffer A,
                                                      int lda,
                                                      @Const DoubleBuffer B,
                                                      int ldb,
                                                      @Const DoubleBuffer beta,
                                                      DoubleBuffer C,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasDsyr2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Const double[] alpha,
                                                      @Const double[] A,
                                                      int lda,
                                                      @Const double[] B,
                                                      int ldb,
                                                      @Const double[] beta,
                                                      double[] C,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasDsyr2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const DoublePointer alpha,
                                                         @Const DoublePointer A,
                                                         @Cast("int64_t") long lda,
                                                         @Const DoublePointer B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const DoublePointer beta,
                                                         DoublePointer C,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDsyr2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const DoubleBuffer alpha,
                                                         @Const DoubleBuffer A,
                                                         @Cast("int64_t") long lda,
                                                         @Const DoubleBuffer B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const DoubleBuffer beta,
                                                         DoubleBuffer C,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDsyr2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Const double[] alpha,
                                                         @Const double[] A,
                                                         @Cast("int64_t") long lda,
                                                         @Const double[] B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const double[] beta,
                                                         double[] C,
                                                         @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCsyr2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Cast("const cuComplex*") float2 A,
                                                      int lda,
                                                      @Cast("const cuComplex*") float2 B,
                                                      int ldb,
                                                      @Cast("const cuComplex*") float2 beta,
                                                      @Cast("cuComplex*") float2 C,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasCsyr2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*") float2 A,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuComplex*") float2 B,
                                                         @Cast("int64_t") long ldb,
                                                         @Cast("const cuComplex*") float2 beta,
                                                         @Cast("cuComplex*") float2 C,
                                                         @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZsyr2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuDoubleComplex*") double2 alpha,
                                                      @Cast("const cuDoubleComplex*") double2 A,
                                                      int lda,
                                                      @Cast("const cuDoubleComplex*") double2 B,
                                                      int ldb,
                                                      @Cast("const cuDoubleComplex*") double2 beta,
                                                      @Cast("cuDoubleComplex*") double2 C,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasZsyr2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*") double2 A,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuDoubleComplex*") double2 B,
                                                         @Cast("int64_t") long ldb,
                                                         @Cast("const cuDoubleComplex*") double2 beta,
                                                         @Cast("cuDoubleComplex*") double2 C,
                                                         @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCher2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Cast("const cuComplex*") float2 A,
                                                      int lda,
                                                      @Cast("const cuComplex*") float2 B,
                                                      int ldb,
                                                      @Const FloatPointer beta,
                                                      @Cast("cuComplex*") float2 C,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasCher2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Cast("const cuComplex*") float2 A,
                                                      int lda,
                                                      @Cast("const cuComplex*") float2 B,
                                                      int ldb,
                                                      @Const FloatBuffer beta,
                                                      @Cast("cuComplex*") float2 C,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasCher2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Cast("const cuComplex*") float2 A,
                                                      int lda,
                                                      @Cast("const cuComplex*") float2 B,
                                                      int ldb,
                                                      @Const float[] beta,
                                                      @Cast("cuComplex*") float2 C,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasCher2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*") float2 A,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuComplex*") float2 B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const FloatPointer beta,
                                                         @Cast("cuComplex*") float2 C,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCher2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*") float2 A,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuComplex*") float2 B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const FloatBuffer beta,
                                                         @Cast("cuComplex*") float2 C,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCher2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*") float2 A,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuComplex*") float2 B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const float[] beta,
                                                         @Cast("cuComplex*") float2 C,
                                                         @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZher2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuDoubleComplex*") double2 alpha,
                                                      @Cast("const cuDoubleComplex*") double2 A,
                                                      int lda,
                                                      @Cast("const cuDoubleComplex*") double2 B,
                                                      int ldb,
                                                      @Const DoublePointer beta,
                                                      @Cast("cuDoubleComplex*") double2 C,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasZher2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuDoubleComplex*") double2 alpha,
                                                      @Cast("const cuDoubleComplex*") double2 A,
                                                      int lda,
                                                      @Cast("const cuDoubleComplex*") double2 B,
                                                      int ldb,
                                                      @Const DoubleBuffer beta,
                                                      @Cast("cuDoubleComplex*") double2 C,
                                                      int ldc);
public static native @Cast("cublasStatus_t") int cublasZher2k_v2(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      int n,
                                                      int k,
                                                      @Cast("const cuDoubleComplex*") double2 alpha,
                                                      @Cast("const cuDoubleComplex*") double2 A,
                                                      int lda,
                                                      @Cast("const cuDoubleComplex*") double2 B,
                                                      int ldb,
                                                      @Const double[] beta,
                                                      @Cast("cuDoubleComplex*") double2 C,
                                                      int ldc);

public static native @Cast("cublasStatus_t") int cublasZher2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*") double2 A,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuDoubleComplex*") double2 B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const DoublePointer beta,
                                                         @Cast("cuDoubleComplex*") double2 C,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasZher2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*") double2 A,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuDoubleComplex*") double2 B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const DoubleBuffer beta,
                                                         @Cast("cuDoubleComplex*") double2 C,
                                                         @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasZher2k_v2_64(cublasContext handle,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("int64_t") long n,
                                                         @Cast("int64_t") long k,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*") double2 A,
                                                         @Cast("int64_t") long lda,
                                                         @Cast("const cuDoubleComplex*") double2 B,
                                                         @Cast("int64_t") long ldb,
                                                         @Const double[] beta,
                                                         @Cast("cuDoubleComplex*") double2 C,
                                                         @Cast("int64_t") long ldc);

/* SYRKX / HERKX */

public static native @Cast("cublasStatus_t") int cublasSsyrkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Const FloatPointer alpha,
                                                   @Const FloatPointer A,
                                                   int lda,
                                                   @Const FloatPointer B,
                                                   int ldb,
                                                   @Const FloatPointer beta,
                                                   FloatPointer C,
                                                   int ldc);
public static native @Cast("cublasStatus_t") int cublasSsyrkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Const FloatBuffer alpha,
                                                   @Const FloatBuffer A,
                                                   int lda,
                                                   @Const FloatBuffer B,
                                                   int ldb,
                                                   @Const FloatBuffer beta,
                                                   FloatBuffer C,
                                                   int ldc);
public static native @Cast("cublasStatus_t") int cublasSsyrkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Const float[] alpha,
                                                   @Const float[] A,
                                                   int lda,
                                                   @Const float[] B,
                                                   int ldb,
                                                   @Const float[] beta,
                                                   float[] C,
                                                   int ldc);

public static native @Cast("cublasStatus_t") int cublasSsyrkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Const FloatPointer alpha,
                                                      @Const FloatPointer A,
                                                      @Cast("int64_t") long lda,
                                                      @Const FloatPointer B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const FloatPointer beta,
                                                      FloatPointer C,
                                                      @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSsyrkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Const FloatBuffer alpha,
                                                      @Const FloatBuffer A,
                                                      @Cast("int64_t") long lda,
                                                      @Const FloatBuffer B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const FloatBuffer beta,
                                                      FloatBuffer C,
                                                      @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSsyrkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Const float[] alpha,
                                                      @Const float[] A,
                                                      @Cast("int64_t") long lda,
                                                      @Const float[] B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const float[] beta,
                                                      float[] C,
                                                      @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasDsyrkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Const DoublePointer alpha,
                                                   @Const DoublePointer A,
                                                   int lda,
                                                   @Const DoublePointer B,
                                                   int ldb,
                                                   @Const DoublePointer beta,
                                                   DoublePointer C,
                                                   int ldc);
public static native @Cast("cublasStatus_t") int cublasDsyrkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Const DoubleBuffer alpha,
                                                   @Const DoubleBuffer A,
                                                   int lda,
                                                   @Const DoubleBuffer B,
                                                   int ldb,
                                                   @Const DoubleBuffer beta,
                                                   DoubleBuffer C,
                                                   int ldc);
public static native @Cast("cublasStatus_t") int cublasDsyrkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Const double[] alpha,
                                                   @Const double[] A,
                                                   int lda,
                                                   @Const double[] B,
                                                   int ldb,
                                                   @Const double[] beta,
                                                   double[] C,
                                                   int ldc);

public static native @Cast("cublasStatus_t") int cublasDsyrkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Const DoublePointer alpha,
                                                      @Const DoublePointer A,
                                                      @Cast("int64_t") long lda,
                                                      @Const DoublePointer B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const DoublePointer beta,
                                                      DoublePointer C,
                                                      @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDsyrkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Const DoubleBuffer alpha,
                                                      @Const DoubleBuffer A,
                                                      @Cast("int64_t") long lda,
                                                      @Const DoubleBuffer B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const DoubleBuffer beta,
                                                      DoubleBuffer C,
                                                      @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDsyrkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Const double[] alpha,
                                                      @Const double[] A,
                                                      @Cast("int64_t") long lda,
                                                      @Const double[] B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const double[] beta,
                                                      double[] C,
                                                      @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCsyrkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Cast("const cuComplex*") float2 alpha,
                                                   @Cast("const cuComplex*") float2 A,
                                                   int lda,
                                                   @Cast("const cuComplex*") float2 B,
                                                   int ldb,
                                                   @Cast("const cuComplex*") float2 beta,
                                                   @Cast("cuComplex*") float2 C,
                                                   int ldc);

public static native @Cast("cublasStatus_t") int cublasCsyrkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Cast("const cuComplex*") float2 A,
                                                      @Cast("int64_t") long lda,
                                                      @Cast("const cuComplex*") float2 B,
                                                      @Cast("int64_t") long ldb,
                                                      @Cast("const cuComplex*") float2 beta,
                                                      @Cast("cuComplex*") float2 C,
                                                      @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZsyrkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Cast("const cuDoubleComplex*") double2 alpha,
                                                   @Cast("const cuDoubleComplex*") double2 A,
                                                   int lda,
                                                   @Cast("const cuDoubleComplex*") double2 B,
                                                   int ldb,
                                                   @Cast("const cuDoubleComplex*") double2 beta,
                                                   @Cast("cuDoubleComplex*") double2 C,
                                                   int ldc);

public static native @Cast("cublasStatus_t") int cublasZsyrkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Cast("const cuDoubleComplex*") double2 alpha,
                                                      @Cast("const cuDoubleComplex*") double2 A,
                                                      @Cast("int64_t") long lda,
                                                      @Cast("const cuDoubleComplex*") double2 B,
                                                      @Cast("int64_t") long ldb,
                                                      @Cast("const cuDoubleComplex*") double2 beta,
                                                      @Cast("cuDoubleComplex*") double2 C,
                                                      @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCherkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Cast("const cuComplex*") float2 alpha,
                                                   @Cast("const cuComplex*") float2 A,
                                                   int lda,
                                                   @Cast("const cuComplex*") float2 B,
                                                   int ldb,
                                                   @Const FloatPointer beta,
                                                   @Cast("cuComplex*") float2 C,
                                                   int ldc);
public static native @Cast("cublasStatus_t") int cublasCherkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Cast("const cuComplex*") float2 alpha,
                                                   @Cast("const cuComplex*") float2 A,
                                                   int lda,
                                                   @Cast("const cuComplex*") float2 B,
                                                   int ldb,
                                                   @Const FloatBuffer beta,
                                                   @Cast("cuComplex*") float2 C,
                                                   int ldc);
public static native @Cast("cublasStatus_t") int cublasCherkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Cast("const cuComplex*") float2 alpha,
                                                   @Cast("const cuComplex*") float2 A,
                                                   int lda,
                                                   @Cast("const cuComplex*") float2 B,
                                                   int ldb,
                                                   @Const float[] beta,
                                                   @Cast("cuComplex*") float2 C,
                                                   int ldc);

public static native @Cast("cublasStatus_t") int cublasCherkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Cast("const cuComplex*") float2 A,
                                                      @Cast("int64_t") long lda,
                                                      @Cast("const cuComplex*") float2 B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const FloatPointer beta,
                                                      @Cast("cuComplex*") float2 C,
                                                      @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCherkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Cast("const cuComplex*") float2 A,
                                                      @Cast("int64_t") long lda,
                                                      @Cast("const cuComplex*") float2 B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const FloatBuffer beta,
                                                      @Cast("cuComplex*") float2 C,
                                                      @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasCherkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Cast("const cuComplex*") float2 alpha,
                                                      @Cast("const cuComplex*") float2 A,
                                                      @Cast("int64_t") long lda,
                                                      @Cast("const cuComplex*") float2 B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const float[] beta,
                                                      @Cast("cuComplex*") float2 C,
                                                      @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZherkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Cast("const cuDoubleComplex*") double2 alpha,
                                                   @Cast("const cuDoubleComplex*") double2 A,
                                                   int lda,
                                                   @Cast("const cuDoubleComplex*") double2 B,
                                                   int ldb,
                                                   @Const DoublePointer beta,
                                                   @Cast("cuDoubleComplex*") double2 C,
                                                   int ldc);
public static native @Cast("cublasStatus_t") int cublasZherkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Cast("const cuDoubleComplex*") double2 alpha,
                                                   @Cast("const cuDoubleComplex*") double2 A,
                                                   int lda,
                                                   @Cast("const cuDoubleComplex*") double2 B,
                                                   int ldb,
                                                   @Const DoubleBuffer beta,
                                                   @Cast("cuDoubleComplex*") double2 C,
                                                   int ldc);
public static native @Cast("cublasStatus_t") int cublasZherkx(cublasContext handle,
                                                   @Cast("cublasFillMode_t") int uplo,
                                                   @Cast("cublasOperation_t") int trans,
                                                   int n,
                                                   int k,
                                                   @Cast("const cuDoubleComplex*") double2 alpha,
                                                   @Cast("const cuDoubleComplex*") double2 A,
                                                   int lda,
                                                   @Cast("const cuDoubleComplex*") double2 B,
                                                   int ldb,
                                                   @Const double[] beta,
                                                   @Cast("cuDoubleComplex*") double2 C,
                                                   int ldc);

public static native @Cast("cublasStatus_t") int cublasZherkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Cast("const cuDoubleComplex*") double2 alpha,
                                                      @Cast("const cuDoubleComplex*") double2 A,
                                                      @Cast("int64_t") long lda,
                                                      @Cast("const cuDoubleComplex*") double2 B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const DoublePointer beta,
                                                      @Cast("cuDoubleComplex*") double2 C,
                                                      @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasZherkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Cast("const cuDoubleComplex*") double2 alpha,
                                                      @Cast("const cuDoubleComplex*") double2 A,
                                                      @Cast("int64_t") long lda,
                                                      @Cast("const cuDoubleComplex*") double2 B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const DoubleBuffer beta,
                                                      @Cast("cuDoubleComplex*") double2 C,
                                                      @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasZherkx_64(cublasContext handle,
                                                      @Cast("cublasFillMode_t") int uplo,
                                                      @Cast("cublasOperation_t") int trans,
                                                      @Cast("int64_t") long n,
                                                      @Cast("int64_t") long k,
                                                      @Cast("const cuDoubleComplex*") double2 alpha,
                                                      @Cast("const cuDoubleComplex*") double2 A,
                                                      @Cast("int64_t") long lda,
                                                      @Cast("const cuDoubleComplex*") double2 B,
                                                      @Cast("int64_t") long ldb,
                                                      @Const double[] beta,
                                                      @Cast("cuDoubleComplex*") double2 C,
                                                      @Cast("int64_t") long ldc);

/* SYMM */

public static native @Cast("cublasStatus_t") int cublasSsymm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     @Const FloatPointer B,
                                                     int ldb,
                                                     @Const FloatPointer beta,
                                                     FloatPointer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasSsymm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     @Const FloatBuffer B,
                                                     int ldb,
                                                     @Const FloatBuffer beta,
                                                     FloatBuffer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasSsymm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     @Const float[] B,
                                                     int ldb,
                                                     @Const float[] beta,
                                                     float[] C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasSsymm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const FloatPointer beta,
                                                        FloatPointer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSsymm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const FloatBuffer beta,
                                                        FloatBuffer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSsymm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const float[] beta,
                                                        float[] C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasDsymm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     @Const DoublePointer B,
                                                     int ldb,
                                                     @Const DoublePointer beta,
                                                     DoublePointer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasDsymm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     @Const DoubleBuffer B,
                                                     int ldb,
                                                     @Const DoubleBuffer beta,
                                                     DoubleBuffer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasDsymm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     @Const double[] B,
                                                     int ldb,
                                                     @Const double[] beta,
                                                     double[] C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasDsymm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const DoublePointer beta,
                                                        DoublePointer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDsymm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const DoubleBuffer beta,
                                                        DoubleBuffer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDsymm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] B,
                                                        @Cast("int64_t") long ldb,
                                                        @Const double[] beta,
                                                        double[] C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCsymm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 B,
                                                     int ldb,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasCsymm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 B,
                                                        @Cast("int64_t") long ldb,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZsymm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 B,
                                                     int ldb,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasZsymm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 B,
                                                        @Cast("int64_t") long ldb,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 C,
                                                        @Cast("int64_t") long ldc);

/* HEMM */

public static native @Cast("cublasStatus_t") int cublasChemm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 B,
                                                     int ldb,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("cuComplex*") float2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasChemm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 B,
                                                        @Cast("int64_t") long ldb,
                                                        @Cast("const cuComplex*") float2 beta,
                                                        @Cast("cuComplex*") float2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZhemm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 B,
                                                     int ldb,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasZhemm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 B,
                                                        @Cast("int64_t") long ldb,
                                                        @Cast("const cuDoubleComplex*") double2 beta,
                                                        @Cast("cuDoubleComplex*") double2 C,
                                                        @Cast("int64_t") long ldc);

/* TRSM */

public static native @Cast("cublasStatus_t") int cublasStrsm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     FloatPointer B,
                                                     int ldb);
public static native @Cast("cublasStatus_t") int cublasStrsm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     FloatBuffer B,
                                                     int ldb);
public static native @Cast("cublasStatus_t") int cublasStrsm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     float[] B,
                                                     int ldb);

public static native @Cast("cublasStatus_t") int cublasStrsm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatPointer B,
                                                        @Cast("int64_t") long ldb);
public static native @Cast("cublasStatus_t") int cublasStrsm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        FloatBuffer B,
                                                        @Cast("int64_t") long ldb);
public static native @Cast("cublasStatus_t") int cublasStrsm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        float[] B,
                                                        @Cast("int64_t") long ldb);

public static native @Cast("cublasStatus_t") int cublasDtrsm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     DoublePointer B,
                                                     int ldb);
public static native @Cast("cublasStatus_t") int cublasDtrsm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     DoubleBuffer B,
                                                     int ldb);
public static native @Cast("cublasStatus_t") int cublasDtrsm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     double[] B,
                                                     int ldb);

public static native @Cast("cublasStatus_t") int cublasDtrsm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        DoublePointer B,
                                                        @Cast("int64_t") long ldb);
public static native @Cast("cublasStatus_t") int cublasDtrsm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        DoubleBuffer B,
                                                        @Cast("int64_t") long ldb);
public static native @Cast("cublasStatus_t") int cublasDtrsm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        double[] B,
                                                        @Cast("int64_t") long ldb);

public static native @Cast("cublasStatus_t") int cublasCtrsm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("cuComplex*") float2 B,
                                                     int ldb);

public static native @Cast("cublasStatus_t") int cublasCtrsm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuComplex*") float2 B,
                                                        @Cast("int64_t") long ldb);

public static native @Cast("cublasStatus_t") int cublasZtrsm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("cuDoubleComplex*") double2 B,
                                                     int ldb);

public static native @Cast("cublasStatus_t") int cublasZtrsm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("cuDoubleComplex*") double2 B,
                                                        @Cast("int64_t") long ldb);

/* TRMM */

public static native @Cast("cublasStatus_t") int cublasStrmm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     int lda,
                                                     @Const FloatPointer B,
                                                     int ldb,
                                                     FloatPointer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasStrmm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     int lda,
                                                     @Const FloatBuffer B,
                                                     int ldb,
                                                     FloatBuffer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasStrmm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     int lda,
                                                     @Const float[] B,
                                                     int ldb,
                                                     float[] C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasStrmm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatPointer alpha,
                                                        @Const FloatPointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatPointer B,
                                                        @Cast("int64_t") long ldb,
                                                        FloatPointer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasStrmm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const FloatBuffer alpha,
                                                        @Const FloatBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const FloatBuffer B,
                                                        @Cast("int64_t") long ldb,
                                                        FloatBuffer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasStrmm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const float[] alpha,
                                                        @Const float[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const float[] B,
                                                        @Cast("int64_t") long ldb,
                                                        float[] C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasDtrmm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     int lda,
                                                     @Const DoublePointer B,
                                                     int ldb,
                                                     DoublePointer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasDtrmm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     int lda,
                                                     @Const DoubleBuffer B,
                                                     int ldb,
                                                     DoubleBuffer C,
                                                     int ldc);
public static native @Cast("cublasStatus_t") int cublasDtrmm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     int lda,
                                                     @Const double[] B,
                                                     int ldb,
                                                     double[] C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasDtrmm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const DoublePointer alpha,
                                                        @Const DoublePointer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoublePointer B,
                                                        @Cast("int64_t") long ldb,
                                                        DoublePointer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDtrmm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const DoubleBuffer alpha,
                                                        @Const DoubleBuffer A,
                                                        @Cast("int64_t") long lda,
                                                        @Const DoubleBuffer B,
                                                        @Cast("int64_t") long ldb,
                                                        DoubleBuffer C,
                                                        @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDtrmm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Const double[] alpha,
                                                        @Const double[] A,
                                                        @Cast("int64_t") long lda,
                                                        @Const double[] B,
                                                        @Cast("int64_t") long ldb,
                                                        double[] C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCtrmm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     int lda,
                                                     @Cast("const cuComplex*") float2 B,
                                                     int ldb,
                                                     @Cast("cuComplex*") float2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasCtrmm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuComplex*") float2 alpha,
                                                        @Cast("const cuComplex*") float2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuComplex*") float2 B,
                                                        @Cast("int64_t") long ldb,
                                                        @Cast("cuComplex*") float2 C,
                                                        @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZtrmm_v2(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int side,
                                                     @Cast("cublasFillMode_t") int uplo,
                                                     @Cast("cublasOperation_t") int trans,
                                                     @Cast("cublasDiagType_t") int diag,
                                                     int m,
                                                     int n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     int lda,
                                                     @Cast("const cuDoubleComplex*") double2 B,
                                                     int ldb,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     int ldc);

public static native @Cast("cublasStatus_t") int cublasZtrmm_v2_64(cublasContext handle,
                                                        @Cast("cublasSideMode_t") int side,
                                                        @Cast("cublasFillMode_t") int uplo,
                                                        @Cast("cublasOperation_t") int trans,
                                                        @Cast("cublasDiagType_t") int diag,
                                                        @Cast("int64_t") long m,
                                                        @Cast("int64_t") long n,
                                                        @Cast("const cuDoubleComplex*") double2 alpha,
                                                        @Cast("const cuDoubleComplex*") double2 A,
                                                        @Cast("int64_t") long lda,
                                                        @Cast("const cuDoubleComplex*") double2 B,
                                                        @Cast("int64_t") long ldb,
                                                        @Cast("cuDoubleComplex*") double2 C,
                                                        @Cast("int64_t") long ldc);

/* BATCH GEMM */

// #if defined(__cplusplus)

public static native @Cast("cublasStatus_t") int cublasHgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const __half alpha,
                                                         @Cast("const __half*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const __half*const*") PointerPointer Barray,
                                                         int ldb,
                                                         @Const __half beta,
                                                         @Cast("__half*const*") PointerPointer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasHgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const __half alpha,
                                                         @Const @ByPtrPtr __half Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr __half Barray,
                                                         int ldb,
                                                         @Const __half beta,
                                                         @ByPtrPtr __half Carray,
                                                         int ldc,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasHgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const __half alpha,
                                                            @Cast("const __half*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const __half*const*") PointerPointer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const __half beta,
                                                            @Cast("__half*const*") PointerPointer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasHgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const __half alpha,
                                                            @Const @ByPtrPtr __half Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr __half Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const __half beta,
                                                            @ByPtrPtr __half Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);

// #endif

public static native @Cast("cublasStatus_t") int cublasSgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const FloatPointer alpha,
                                                         @Cast("const float*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const float*const*") PointerPointer Barray,
                                                         int ldb,
                                                         @Const FloatPointer beta,
                                                         @Cast("float*const*") PointerPointer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const FloatPointer alpha,
                                                         @Const @ByPtrPtr FloatPointer Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr FloatPointer Barray,
                                                         int ldb,
                                                         @Const FloatPointer beta,
                                                         @ByPtrPtr FloatPointer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const FloatBuffer alpha,
                                                         @Const @ByPtrPtr FloatBuffer Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr FloatBuffer Barray,
                                                         int ldb,
                                                         @Const FloatBuffer beta,
                                                         @ByPtrPtr FloatBuffer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const float[] alpha,
                                                         @Const @ByPtrPtr float[] Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr float[] Barray,
                                                         int ldb,
                                                         @Const float[] beta,
                                                         @ByPtrPtr float[] Carray,
                                                         int ldc,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasSgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const FloatPointer alpha,
                                                            @Cast("const float*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const float*const*") PointerPointer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const FloatPointer beta,
                                                            @Cast("float*const*") PointerPointer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const FloatPointer alpha,
                                                            @Const @ByPtrPtr FloatPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr FloatPointer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const FloatPointer beta,
                                                            @ByPtrPtr FloatPointer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const FloatBuffer alpha,
                                                            @Const @ByPtrPtr FloatBuffer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr FloatBuffer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const FloatBuffer beta,
                                                            @ByPtrPtr FloatBuffer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const float[] alpha,
                                                            @Const @ByPtrPtr float[] Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr float[] Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const float[] beta,
                                                            @ByPtrPtr float[] Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasDgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const DoublePointer alpha,
                                                         @Cast("const double*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const double*const*") PointerPointer Barray,
                                                         int ldb,
                                                         @Const DoublePointer beta,
                                                         @Cast("double*const*") PointerPointer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const DoublePointer alpha,
                                                         @Const @ByPtrPtr DoublePointer Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr DoublePointer Barray,
                                                         int ldb,
                                                         @Const DoublePointer beta,
                                                         @ByPtrPtr DoublePointer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const DoubleBuffer alpha,
                                                         @Const @ByPtrPtr DoubleBuffer Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr DoubleBuffer Barray,
                                                         int ldb,
                                                         @Const DoubleBuffer beta,
                                                         @ByPtrPtr DoubleBuffer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Const double[] alpha,
                                                         @Const @ByPtrPtr double[] Aarray,
                                                         int lda,
                                                         @Const @ByPtrPtr double[] Barray,
                                                         int ldb,
                                                         @Const double[] beta,
                                                         @ByPtrPtr double[] Carray,
                                                         int ldc,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasDgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const DoublePointer alpha,
                                                            @Cast("const double*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const double*const*") PointerPointer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const DoublePointer beta,
                                                            @Cast("double*const*") PointerPointer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const DoublePointer alpha,
                                                            @Const @ByPtrPtr DoublePointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr DoublePointer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const DoublePointer beta,
                                                            @ByPtrPtr DoublePointer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const DoubleBuffer alpha,
                                                            @Const @ByPtrPtr DoubleBuffer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr DoubleBuffer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const DoubleBuffer beta,
                                                            @ByPtrPtr DoubleBuffer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Const double[] alpha,
                                                            @Const @ByPtrPtr double[] Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Const @ByPtrPtr double[] Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Const double[] beta,
                                                            @ByPtrPtr double[] Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const cuComplex*const*") PointerPointer Barray,
                                                         int ldb,
                                                         @Cast("const cuComplex*") float2 beta,
                                                         @Cast("cuComplex*const*") PointerPointer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasCgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                         int lda,
                                                         @Cast("const cuComplex*const*") @ByPtrPtr float2 Barray,
                                                         int ldb,
                                                         @Cast("const cuComplex*") float2 beta,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 Carray,
                                                         int ldc,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Cast("const cuComplex*") float2 alpha,
                                                            @Cast("const cuComplex*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const cuComplex*const*") PointerPointer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("const cuComplex*") float2 beta,
                                                            @Cast("cuComplex*const*") PointerPointer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasCgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Cast("const cuComplex*") float2 alpha,
                                                            @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const cuComplex*const*") @ByPtrPtr float2 Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("const cuComplex*") float2 beta,
                                                            @Cast("cuComplex*const*") @ByPtrPtr float2 Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemm3mBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int transa,
                                                           @Cast("cublasOperation_t") int transb,
                                                           int m,
                                                           int n,
                                                           int k,
                                                           @Cast("const cuComplex*") float2 alpha,
                                                           @Cast("const cuComplex*const*") PointerPointer Aarray,
                                                           int lda,
                                                           @Cast("const cuComplex*const*") PointerPointer Barray,
                                                           int ldb,
                                                           @Cast("const cuComplex*") float2 beta,
                                                           @Cast("cuComplex*const*") PointerPointer Carray,
                                                           int ldc,
                                                           int batchCount);
public static native @Cast("cublasStatus_t") int cublasCgemm3mBatched(cublasContext handle,
                                                           @Cast("cublasOperation_t") int transa,
                                                           @Cast("cublasOperation_t") int transb,
                                                           int m,
                                                           int n,
                                                           int k,
                                                           @Cast("const cuComplex*") float2 alpha,
                                                           @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                           int lda,
                                                           @Cast("const cuComplex*const*") @ByPtrPtr float2 Barray,
                                                           int ldb,
                                                           @Cast("const cuComplex*") float2 beta,
                                                           @Cast("cuComplex*const*") @ByPtrPtr float2 Carray,
                                                           int ldc,
                                                           int batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemm3mBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int transa,
                                                              @Cast("cublasOperation_t") int transb,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Cast("int64_t") long k,
                                                              @Cast("const cuComplex*") float2 alpha,
                                                              @Cast("const cuComplex*const*") PointerPointer Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Cast("const cuComplex*const*") PointerPointer Barray,
                                                              @Cast("int64_t") long ldb,
                                                              @Cast("const cuComplex*") float2 beta,
                                                              @Cast("cuComplex*const*") PointerPointer Carray,
                                                              @Cast("int64_t") long ldc,
                                                              @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasCgemm3mBatched_64(cublasContext handle,
                                                              @Cast("cublasOperation_t") int transa,
                                                              @Cast("cublasOperation_t") int transb,
                                                              @Cast("int64_t") long m,
                                                              @Cast("int64_t") long n,
                                                              @Cast("int64_t") long k,
                                                              @Cast("const cuComplex*") float2 alpha,
                                                              @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                              @Cast("int64_t") long lda,
                                                              @Cast("const cuComplex*const*") @ByPtrPtr float2 Barray,
                                                              @Cast("int64_t") long ldb,
                                                              @Cast("const cuComplex*") float2 beta,
                                                              @Cast("cuComplex*const*") @ByPtrPtr float2 Carray,
                                                              @Cast("int64_t") long ldc,
                                                              @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasZgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("const cuDoubleComplex*const*") PointerPointer Barray,
                                                         int ldb,
                                                         @Cast("const cuDoubleComplex*") double2 beta,
                                                         @Cast("cuDoubleComplex*const*") PointerPointer Carray,
                                                         int ldc,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasZgemmBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int transa,
                                                         @Cast("cublasOperation_t") int transb,
                                                         int m,
                                                         int n,
                                                         int k,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                         int lda,
                                                         @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Barray,
                                                         int ldb,
                                                         @Cast("const cuDoubleComplex*") double2 beta,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Carray,
                                                         int ldc,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasZgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Cast("const cuDoubleComplex*") double2 alpha,
                                                            @Cast("const cuDoubleComplex*const*") PointerPointer Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const cuDoubleComplex*const*") PointerPointer Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("const cuDoubleComplex*") double2 beta,
                                                            @Cast("cuDoubleComplex*const*") PointerPointer Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasZgemmBatched_64(cublasContext handle,
                                                            @Cast("cublasOperation_t") int transa,
                                                            @Cast("cublasOperation_t") int transb,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("int64_t") long k,
                                                            @Cast("const cuDoubleComplex*") double2 alpha,
                                                            @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Barray,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("const cuDoubleComplex*") double2 beta,
                                                            @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Carray,
                                                            @Cast("int64_t") long ldc,
                                                            @Cast("int64_t") long batchCount);

// #if defined(__cplusplus)

public static native @Cast("cublasStatus_t") int cublasHgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Const __half alpha,
                                                                @Const __half A,
                                                                int lda,
                                                                long strideA,
                                                                @Const __half B,
                                                                int ldb,
                                                                long strideB,
                                                                @Const __half beta,
                                                                __half C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasHgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Const __half alpha,
                                                                   @Const __half A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const __half B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Const __half beta,
                                                                   __half C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);

// #endif

public static native @Cast("cublasStatus_t") int cublasSgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Const FloatPointer alpha,
                                                                @Const FloatPointer A,
                                                                int lda,
                                                                long strideA,
                                                                @Const FloatPointer B,
                                                                int ldb,
                                                                long strideB,
                                                                @Const FloatPointer beta,
                                                                FloatPointer C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Const FloatBuffer alpha,
                                                                @Const FloatBuffer A,
                                                                int lda,
                                                                long strideA,
                                                                @Const FloatBuffer B,
                                                                int ldb,
                                                                long strideB,
                                                                @Const FloatBuffer beta,
                                                                FloatBuffer C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Const float[] alpha,
                                                                @Const float[] A,
                                                                int lda,
                                                                long strideA,
                                                                @Const float[] B,
                                                                int ldb,
                                                                long strideB,
                                                                @Const float[] beta,
                                                                float[] C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasSgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Const FloatPointer alpha,
                                                                   @Const FloatPointer A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const FloatPointer B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Const FloatPointer beta,
                                                                   FloatPointer C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Const FloatBuffer alpha,
                                                                   @Const FloatBuffer A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const FloatBuffer B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Const FloatBuffer beta,
                                                                   FloatBuffer C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasSgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Const float[] alpha,
                                                                   @Const float[] A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const float[] B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Const float[] beta,
                                                                   float[] C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasDgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Const DoublePointer alpha,
                                                                @Const DoublePointer A,
                                                                int lda,
                                                                long strideA,
                                                                @Const DoublePointer B,
                                                                int ldb,
                                                                long strideB,
                                                                @Const DoublePointer beta,
                                                                DoublePointer C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Const DoubleBuffer alpha,
                                                                @Const DoubleBuffer A,
                                                                int lda,
                                                                long strideA,
                                                                @Const DoubleBuffer B,
                                                                int ldb,
                                                                long strideB,
                                                                @Const DoubleBuffer beta,
                                                                DoubleBuffer C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Const double[] alpha,
                                                                @Const double[] A,
                                                                int lda,
                                                                long strideA,
                                                                @Const double[] B,
                                                                int ldb,
                                                                long strideB,
                                                                @Const double[] beta,
                                                                double[] C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasDgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Const DoublePointer alpha,
                                                                   @Const DoublePointer A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const DoublePointer B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Const DoublePointer beta,
                                                                   DoublePointer C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Const DoubleBuffer alpha,
                                                                   @Const DoubleBuffer A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const DoubleBuffer B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Const DoubleBuffer beta,
                                                                   DoubleBuffer C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Const double[] alpha,
                                                                   @Const double[] A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Const double[] B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Const double[] beta,
                                                                   double[] C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Cast("const cuComplex*") float2 alpha,
                                                                @Cast("const cuComplex*") float2 A,
                                                                int lda,
                                                                long strideA,
                                                                @Cast("const cuComplex*") float2 B,
                                                                int ldb,
                                                                long strideB,
                                                                @Cast("const cuComplex*") float2 beta,
                                                                @Cast("cuComplex*") float2 C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Cast("const cuComplex*") float2 alpha,
                                                                   @Cast("const cuComplex*") float2 A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Cast("const cuComplex*") float2 B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Cast("const cuComplex*") float2 beta,
                                                                   @Cast("cuComplex*") float2 C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemm3mStridedBatched(cublasContext handle,
                                                                  @Cast("cublasOperation_t") int transa,
                                                                  @Cast("cublasOperation_t") int transb,
                                                                  int m,
                                                                  int n,
                                                                  int k,
                                                                  @Cast("const cuComplex*") float2 alpha,
                                                                  @Cast("const cuComplex*") float2 A,
                                                                  int lda,
                                                                  long strideA,
                                                                  @Cast("const cuComplex*") float2 B,
                                                                  int ldb,
                                                                  long strideB,
                                                                  @Cast("const cuComplex*") float2 beta,
                                                                  @Cast("cuComplex*") float2 C,
                                                                  int ldc,
                                                                  long strideC,
                                                                  int batchCount);

public static native @Cast("cublasStatus_t") int cublasCgemm3mStridedBatched_64(cublasContext handle,
                                                                     @Cast("cublasOperation_t") int transa,
                                                                     @Cast("cublasOperation_t") int transb,
                                                                     @Cast("int64_t") long m,
                                                                     @Cast("int64_t") long n,
                                                                     @Cast("int64_t") long k,
                                                                     @Cast("const cuComplex*") float2 alpha,
                                                                     @Cast("const cuComplex*") float2 A,
                                                                     @Cast("int64_t") long lda,
                                                                     long strideA,
                                                                     @Cast("const cuComplex*") float2 B,
                                                                     @Cast("int64_t") long ldb,
                                                                     long strideB,
                                                                     @Cast("const cuComplex*") float2 beta,
                                                                     @Cast("cuComplex*") float2 C,
                                                                     @Cast("int64_t") long ldc,
                                                                     long strideC,
                                                                     @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasZgemmStridedBatched(cublasContext handle,
                                                                @Cast("cublasOperation_t") int transa,
                                                                @Cast("cublasOperation_t") int transb,
                                                                int m,
                                                                int n,
                                                                int k,
                                                                @Cast("const cuDoubleComplex*") double2 alpha,
                                                                @Cast("const cuDoubleComplex*") double2 A,
                                                                int lda,
                                                                long strideA,
                                                                @Cast("const cuDoubleComplex*") double2 B,
                                                                int ldb,
                                                                long strideB,
                                                                @Cast("const cuDoubleComplex*") double2 beta,
                                                                @Cast("cuDoubleComplex*") double2 C,
                                                                int ldc,
                                                                long strideC,
                                                                int batchCount);

public static native @Cast("cublasStatus_t") int cublasZgemmStridedBatched_64(cublasContext handle,
                                                                   @Cast("cublasOperation_t") int transa,
                                                                   @Cast("cublasOperation_t") int transb,
                                                                   @Cast("int64_t") long m,
                                                                   @Cast("int64_t") long n,
                                                                   @Cast("int64_t") long k,
                                                                   @Cast("const cuDoubleComplex*") double2 alpha,
                                                                   @Cast("const cuDoubleComplex*") double2 A,
                                                                   @Cast("int64_t") long lda,
                                                                   long strideA,
                                                                   @Cast("const cuDoubleComplex*") double2 B,
                                                                   @Cast("int64_t") long ldb,
                                                                   long strideB,
                                                                   @Cast("const cuDoubleComplex*") double2 beta,
                                                                   @Cast("cuDoubleComplex*") double2 C,
                                                                   @Cast("int64_t") long ldc,
                                                                   long strideC,
                                                                   @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasGemmBatchedEx(cublasContext handle,
                                                          @Cast("cublasOperation_t") int transa,
                                                          @Cast("cublasOperation_t") int transb,
                                                          int m,
                                                          int n,
                                                          int k,
                                                          @Const Pointer alpha,
                                                          @Cast("const void*const*") PointerPointer Aarray,
                                                          @Cast("cudaDataType") int Atype,
                                                          int lda,
                                                          @Cast("const void*const*") PointerPointer Barray,
                                                          @Cast("cudaDataType") int Btype,
                                                          int ldb,
                                                          @Const Pointer beta,
                                                          @Cast("void*const*") PointerPointer Carray,
                                                          @Cast("cudaDataType") int Ctype,
                                                          int ldc,
                                                          int batchCount,
                                                          @Cast("cublasComputeType_t") int computeType,
                                                          @Cast("cublasGemmAlgo_t") int algo);
public static native @Cast("cublasStatus_t") int cublasGemmBatchedEx(cublasContext handle,
                                                          @Cast("cublasOperation_t") int transa,
                                                          @Cast("cublasOperation_t") int transb,
                                                          int m,
                                                          int n,
                                                          int k,
                                                          @Const Pointer alpha,
                                                          @Cast("const void*const*") @ByPtrPtr Pointer Aarray,
                                                          @Cast("cudaDataType") int Atype,
                                                          int lda,
                                                          @Cast("const void*const*") @ByPtrPtr Pointer Barray,
                                                          @Cast("cudaDataType") int Btype,
                                                          int ldb,
                                                          @Const Pointer beta,
                                                          @Cast("void*const*") @ByPtrPtr Pointer Carray,
                                                          @Cast("cudaDataType") int Ctype,
                                                          int ldc,
                                                          int batchCount,
                                                          @Cast("cublasComputeType_t") int computeType,
                                                          @Cast("cublasGemmAlgo_t") int algo);

public static native @Cast("cublasStatus_t") int cublasGemmBatchedEx_64(cublasContext handle,
                                                             @Cast("cublasOperation_t") int transa,
                                                             @Cast("cublasOperation_t") int transb,
                                                             @Cast("int64_t") long m,
                                                             @Cast("int64_t") long n,
                                                             @Cast("int64_t") long k,
                                                             @Const Pointer alpha,
                                                             @Cast("const void*const*") PointerPointer Aarray,
                                                             @Cast("cudaDataType") int Atype,
                                                             @Cast("int64_t") long lda,
                                                             @Cast("const void*const*") PointerPointer Barray,
                                                             @Cast("cudaDataType") int Btype,
                                                             @Cast("int64_t") long ldb,
                                                             @Const Pointer beta,
                                                             @Cast("void*const*") PointerPointer Carray,
                                                             @Cast("cudaDataType") int Ctype,
                                                             @Cast("int64_t") long ldc,
                                                             @Cast("int64_t") long batchCount,
                                                             @Cast("cublasComputeType_t") int computeType,
                                                             @Cast("cublasGemmAlgo_t") int algo);
public static native @Cast("cublasStatus_t") int cublasGemmBatchedEx_64(cublasContext handle,
                                                             @Cast("cublasOperation_t") int transa,
                                                             @Cast("cublasOperation_t") int transb,
                                                             @Cast("int64_t") long m,
                                                             @Cast("int64_t") long n,
                                                             @Cast("int64_t") long k,
                                                             @Const Pointer alpha,
                                                             @Cast("const void*const*") @ByPtrPtr Pointer Aarray,
                                                             @Cast("cudaDataType") int Atype,
                                                             @Cast("int64_t") long lda,
                                                             @Cast("const void*const*") @ByPtrPtr Pointer Barray,
                                                             @Cast("cudaDataType") int Btype,
                                                             @Cast("int64_t") long ldb,
                                                             @Const Pointer beta,
                                                             @Cast("void*const*") @ByPtrPtr Pointer Carray,
                                                             @Cast("cudaDataType") int Ctype,
                                                             @Cast("int64_t") long ldc,
                                                             @Cast("int64_t") long batchCount,
                                                             @Cast("cublasComputeType_t") int computeType,
                                                             @Cast("cublasGemmAlgo_t") int algo);

public static native @Cast("cublasStatus_t") int cublasGemmStridedBatchedEx(cublasContext handle,
                                                                 @Cast("cublasOperation_t") int transa,
                                                                 @Cast("cublasOperation_t") int transb,
                                                                 int m,
                                                                 int n,
                                                                 int k,
                                                                 @Const Pointer alpha,
                                                                 @Const Pointer A,
                                                                 @Cast("cudaDataType") int Atype,
                                                                 int lda,
                                                                 long strideA,
                                                                 @Const Pointer B,
                                                                 @Cast("cudaDataType") int Btype,
                                                                 int ldb,
                                                                 long strideB,
                                                                 @Const Pointer beta,
                                                                 Pointer C,
                                                                 @Cast("cudaDataType") int Ctype,
                                                                 int ldc,
                                                                 long strideC,
                                                                 int batchCount,
                                                                 @Cast("cublasComputeType_t") int computeType,
                                                                 @Cast("cublasGemmAlgo_t") int algo);

public static native @Cast("cublasStatus_t") int cublasGemmStridedBatchedEx_64(cublasContext handle,
                                                                    @Cast("cublasOperation_t") int transa,
                                                                    @Cast("cublasOperation_t") int transb,
                                                                    @Cast("int64_t") long m,
                                                                    @Cast("int64_t") long n,
                                                                    @Cast("int64_t") long k,
                                                                    @Const Pointer alpha,
                                                                    @Const Pointer A,
                                                                    @Cast("cudaDataType") int Atype,
                                                                    @Cast("int64_t") long lda,
                                                                    long strideA,
                                                                    @Const Pointer B,
                                                                    @Cast("cudaDataType") int Btype,
                                                                    @Cast("int64_t") long ldb,
                                                                    long strideB,
                                                                    @Const Pointer beta,
                                                                    Pointer C,
                                                                    @Cast("cudaDataType") int Ctype,
                                                                    @Cast("int64_t") long ldc,
                                                                    long strideC,
                                                                    @Cast("int64_t") long batchCount,
                                                                    @Cast("cublasComputeType_t") int computeType,
                                                                    @Cast("cublasGemmAlgo_t") int algo);

public static native @Cast("cublasStatus_t") int cublasSgemmGroupedBatched(cublasContext handle,
                                                                @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                @Const IntPointer m_array,
                                                                @Const IntPointer n_array,
                                                                @Const IntPointer k_array,
                                                                @Const FloatPointer alpha_array,
                                                                @Cast("const float*const*") PointerPointer Aarray,
                                                                @Const IntPointer lda_array,
                                                                @Cast("const float*const*") PointerPointer Barray,
                                                                @Const IntPointer ldb_array,
                                                                @Const FloatPointer beta_array,
                                                                @Cast("float*const*") PointerPointer Carray,
                                                                @Const IntPointer ldc_array,
                                                                int group_count,
                                                                @Const IntPointer group_size);
public static native @Cast("cublasStatus_t") int cublasSgemmGroupedBatched(cublasContext handle,
                                                                @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                @Const IntPointer m_array,
                                                                @Const IntPointer n_array,
                                                                @Const IntPointer k_array,
                                                                @Const FloatPointer alpha_array,
                                                                @Const @ByPtrPtr FloatPointer Aarray,
                                                                @Const IntPointer lda_array,
                                                                @Const @ByPtrPtr FloatPointer Barray,
                                                                @Const IntPointer ldb_array,
                                                                @Const FloatPointer beta_array,
                                                                @ByPtrPtr FloatPointer Carray,
                                                                @Const IntPointer ldc_array,
                                                                int group_count,
                                                                @Const IntPointer group_size);
public static native @Cast("cublasStatus_t") int cublasSgemmGroupedBatched(cublasContext handle,
                                                                @Cast("const cublasOperation_t*") IntBuffer transa_array,
                                                                @Cast("const cublasOperation_t*") IntBuffer transb_array,
                                                                @Const IntBuffer m_array,
                                                                @Const IntBuffer n_array,
                                                                @Const IntBuffer k_array,
                                                                @Const FloatBuffer alpha_array,
                                                                @Const @ByPtrPtr FloatBuffer Aarray,
                                                                @Const IntBuffer lda_array,
                                                                @Const @ByPtrPtr FloatBuffer Barray,
                                                                @Const IntBuffer ldb_array,
                                                                @Const FloatBuffer beta_array,
                                                                @ByPtrPtr FloatBuffer Carray,
                                                                @Const IntBuffer ldc_array,
                                                                int group_count,
                                                                @Const IntBuffer group_size);
public static native @Cast("cublasStatus_t") int cublasSgemmGroupedBatched(cublasContext handle,
                                                                @Cast("const cublasOperation_t*") int[] transa_array,
                                                                @Cast("const cublasOperation_t*") int[] transb_array,
                                                                @Const int[] m_array,
                                                                @Const int[] n_array,
                                                                @Const int[] k_array,
                                                                @Const float[] alpha_array,
                                                                @Const @ByPtrPtr float[] Aarray,
                                                                @Const int[] lda_array,
                                                                @Const @ByPtrPtr float[] Barray,
                                                                @Const int[] ldb_array,
                                                                @Const float[] beta_array,
                                                                @ByPtrPtr float[] Carray,
                                                                @Const int[] ldc_array,
                                                                int group_count,
                                                                @Const int[] group_size);

public static native @Cast("cublasStatus_t") int cublasSgemmGroupedBatched_64(cublasContext handle,
                                                                   @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                   @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                   @Cast("const int64_t*") LongPointer m_array,
                                                                   @Cast("const int64_t*") LongPointer n_array,
                                                                   @Cast("const int64_t*") LongPointer k_array,
                                                                   @Const FloatPointer alpha_array,
                                                                   @Cast("const float*const*") PointerPointer Aarray,
                                                                   @Cast("const int64_t*") LongPointer lda_array,
                                                                   @Cast("const float*const*") PointerPointer Barray,
                                                                   @Cast("const int64_t*") LongPointer ldb_array,
                                                                   @Const FloatPointer beta_array,
                                                                   @Cast("float*const*") PointerPointer Carray,
                                                                   @Cast("const int64_t*") LongPointer ldc_array,
                                                                   @Cast("int64_t") long group_count,
                                                                   @Cast("const int64_t*") LongPointer group_size);
public static native @Cast("cublasStatus_t") int cublasSgemmGroupedBatched_64(cublasContext handle,
                                                                   @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                   @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                   @Cast("const int64_t*") LongPointer m_array,
                                                                   @Cast("const int64_t*") LongPointer n_array,
                                                                   @Cast("const int64_t*") LongPointer k_array,
                                                                   @Const FloatPointer alpha_array,
                                                                   @Const @ByPtrPtr FloatPointer Aarray,
                                                                   @Cast("const int64_t*") LongPointer lda_array,
                                                                   @Const @ByPtrPtr FloatPointer Barray,
                                                                   @Cast("const int64_t*") LongPointer ldb_array,
                                                                   @Const FloatPointer beta_array,
                                                                   @ByPtrPtr FloatPointer Carray,
                                                                   @Cast("const int64_t*") LongPointer ldc_array,
                                                                   @Cast("int64_t") long group_count,
                                                                   @Cast("const int64_t*") LongPointer group_size);
public static native @Cast("cublasStatus_t") int cublasSgemmGroupedBatched_64(cublasContext handle,
                                                                   @Cast("const cublasOperation_t*") IntBuffer transa_array,
                                                                   @Cast("const cublasOperation_t*") IntBuffer transb_array,
                                                                   @Cast("const int64_t*") LongBuffer m_array,
                                                                   @Cast("const int64_t*") LongBuffer n_array,
                                                                   @Cast("const int64_t*") LongBuffer k_array,
                                                                   @Const FloatBuffer alpha_array,
                                                                   @Const @ByPtrPtr FloatBuffer Aarray,
                                                                   @Cast("const int64_t*") LongBuffer lda_array,
                                                                   @Const @ByPtrPtr FloatBuffer Barray,
                                                                   @Cast("const int64_t*") LongBuffer ldb_array,
                                                                   @Const FloatBuffer beta_array,
                                                                   @ByPtrPtr FloatBuffer Carray,
                                                                   @Cast("const int64_t*") LongBuffer ldc_array,
                                                                   @Cast("int64_t") long group_count,
                                                                   @Cast("const int64_t*") LongBuffer group_size);
public static native @Cast("cublasStatus_t") int cublasSgemmGroupedBatched_64(cublasContext handle,
                                                                   @Cast("const cublasOperation_t*") int[] transa_array,
                                                                   @Cast("const cublasOperation_t*") int[] transb_array,
                                                                   @Cast("const int64_t*") long[] m_array,
                                                                   @Cast("const int64_t*") long[] n_array,
                                                                   @Cast("const int64_t*") long[] k_array,
                                                                   @Const float[] alpha_array,
                                                                   @Const @ByPtrPtr float[] Aarray,
                                                                   @Cast("const int64_t*") long[] lda_array,
                                                                   @Const @ByPtrPtr float[] Barray,
                                                                   @Cast("const int64_t*") long[] ldb_array,
                                                                   @Const float[] beta_array,
                                                                   @ByPtrPtr float[] Carray,
                                                                   @Cast("const int64_t*") long[] ldc_array,
                                                                   @Cast("int64_t") long group_count,
                                                                   @Cast("const int64_t*") long[] group_size);

public static native @Cast("cublasStatus_t") int cublasDgemmGroupedBatched(cublasContext handle,
                                                                @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                @Const IntPointer m_array,
                                                                @Const IntPointer n_array,
                                                                @Const IntPointer k_array,
                                                                @Const DoublePointer alpha_array,
                                                                @Cast("const double*const*") PointerPointer Aarray,
                                                                @Const IntPointer lda_array,
                                                                @Cast("const double*const*") PointerPointer Barray,
                                                                @Const IntPointer ldb_array,
                                                                @Const DoublePointer beta_array,
                                                                @Cast("double*const*") PointerPointer Carray,
                                                                @Const IntPointer ldc_array,
                                                                int group_count,
                                                                @Const IntPointer group_size);
public static native @Cast("cublasStatus_t") int cublasDgemmGroupedBatched(cublasContext handle,
                                                                @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                @Const IntPointer m_array,
                                                                @Const IntPointer n_array,
                                                                @Const IntPointer k_array,
                                                                @Const DoublePointer alpha_array,
                                                                @Const @ByPtrPtr DoublePointer Aarray,
                                                                @Const IntPointer lda_array,
                                                                @Const @ByPtrPtr DoublePointer Barray,
                                                                @Const IntPointer ldb_array,
                                                                @Const DoublePointer beta_array,
                                                                @ByPtrPtr DoublePointer Carray,
                                                                @Const IntPointer ldc_array,
                                                                int group_count,
                                                                @Const IntPointer group_size);
public static native @Cast("cublasStatus_t") int cublasDgemmGroupedBatched(cublasContext handle,
                                                                @Cast("const cublasOperation_t*") IntBuffer transa_array,
                                                                @Cast("const cublasOperation_t*") IntBuffer transb_array,
                                                                @Const IntBuffer m_array,
                                                                @Const IntBuffer n_array,
                                                                @Const IntBuffer k_array,
                                                                @Const DoubleBuffer alpha_array,
                                                                @Const @ByPtrPtr DoubleBuffer Aarray,
                                                                @Const IntBuffer lda_array,
                                                                @Const @ByPtrPtr DoubleBuffer Barray,
                                                                @Const IntBuffer ldb_array,
                                                                @Const DoubleBuffer beta_array,
                                                                @ByPtrPtr DoubleBuffer Carray,
                                                                @Const IntBuffer ldc_array,
                                                                int group_count,
                                                                @Const IntBuffer group_size);
public static native @Cast("cublasStatus_t") int cublasDgemmGroupedBatched(cublasContext handle,
                                                                @Cast("const cublasOperation_t*") int[] transa_array,
                                                                @Cast("const cublasOperation_t*") int[] transb_array,
                                                                @Const int[] m_array,
                                                                @Const int[] n_array,
                                                                @Const int[] k_array,
                                                                @Const double[] alpha_array,
                                                                @Const @ByPtrPtr double[] Aarray,
                                                                @Const int[] lda_array,
                                                                @Const @ByPtrPtr double[] Barray,
                                                                @Const int[] ldb_array,
                                                                @Const double[] beta_array,
                                                                @ByPtrPtr double[] Carray,
                                                                @Const int[] ldc_array,
                                                                int group_count,
                                                                @Const int[] group_size);

public static native @Cast("cublasStatus_t") int cublasDgemmGroupedBatched_64(cublasContext handle,
                                                                   @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                   @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                   @Cast("const int64_t*") LongPointer m_array,
                                                                   @Cast("const int64_t*") LongPointer n_array,
                                                                   @Cast("const int64_t*") LongPointer k_array,
                                                                   @Const DoublePointer alpha_array,
                                                                   @Cast("const double*const*") PointerPointer Aarray,
                                                                   @Cast("const int64_t*") LongPointer lda_array,
                                                                   @Cast("const double*const*") PointerPointer Barray,
                                                                   @Cast("const int64_t*") LongPointer ldb_array,
                                                                   @Const DoublePointer beta_array,
                                                                   @Cast("double*const*") PointerPointer Carray,
                                                                   @Cast("const int64_t*") LongPointer ldc_array,
                                                                   @Cast("int64_t") long group_count,
                                                                   @Cast("const int64_t*") LongPointer group_size);
public static native @Cast("cublasStatus_t") int cublasDgemmGroupedBatched_64(cublasContext handle,
                                                                   @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                   @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                   @Cast("const int64_t*") LongPointer m_array,
                                                                   @Cast("const int64_t*") LongPointer n_array,
                                                                   @Cast("const int64_t*") LongPointer k_array,
                                                                   @Const DoublePointer alpha_array,
                                                                   @Const @ByPtrPtr DoublePointer Aarray,
                                                                   @Cast("const int64_t*") LongPointer lda_array,
                                                                   @Const @ByPtrPtr DoublePointer Barray,
                                                                   @Cast("const int64_t*") LongPointer ldb_array,
                                                                   @Const DoublePointer beta_array,
                                                                   @ByPtrPtr DoublePointer Carray,
                                                                   @Cast("const int64_t*") LongPointer ldc_array,
                                                                   @Cast("int64_t") long group_count,
                                                                   @Cast("const int64_t*") LongPointer group_size);
public static native @Cast("cublasStatus_t") int cublasDgemmGroupedBatched_64(cublasContext handle,
                                                                   @Cast("const cublasOperation_t*") IntBuffer transa_array,
                                                                   @Cast("const cublasOperation_t*") IntBuffer transb_array,
                                                                   @Cast("const int64_t*") LongBuffer m_array,
                                                                   @Cast("const int64_t*") LongBuffer n_array,
                                                                   @Cast("const int64_t*") LongBuffer k_array,
                                                                   @Const DoubleBuffer alpha_array,
                                                                   @Const @ByPtrPtr DoubleBuffer Aarray,
                                                                   @Cast("const int64_t*") LongBuffer lda_array,
                                                                   @Const @ByPtrPtr DoubleBuffer Barray,
                                                                   @Cast("const int64_t*") LongBuffer ldb_array,
                                                                   @Const DoubleBuffer beta_array,
                                                                   @ByPtrPtr DoubleBuffer Carray,
                                                                   @Cast("const int64_t*") LongBuffer ldc_array,
                                                                   @Cast("int64_t") long group_count,
                                                                   @Cast("const int64_t*") LongBuffer group_size);
public static native @Cast("cublasStatus_t") int cublasDgemmGroupedBatched_64(cublasContext handle,
                                                                   @Cast("const cublasOperation_t*") int[] transa_array,
                                                                   @Cast("const cublasOperation_t*") int[] transb_array,
                                                                   @Cast("const int64_t*") long[] m_array,
                                                                   @Cast("const int64_t*") long[] n_array,
                                                                   @Cast("const int64_t*") long[] k_array,
                                                                   @Const double[] alpha_array,
                                                                   @Const @ByPtrPtr double[] Aarray,
                                                                   @Cast("const int64_t*") long[] lda_array,
                                                                   @Const @ByPtrPtr double[] Barray,
                                                                   @Cast("const int64_t*") long[] ldb_array,
                                                                   @Const double[] beta_array,
                                                                   @ByPtrPtr double[] Carray,
                                                                   @Cast("const int64_t*") long[] ldc_array,
                                                                   @Cast("int64_t") long group_count,
                                                                   @Cast("const int64_t*") long[] group_size);

public static native @Cast("cublasStatus_t") int cublasGemmGroupedBatchedEx(cublasContext handle,
                                                                 @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                 @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                 @Const IntPointer m_array,
                                                                 @Const IntPointer n_array,
                                                                 @Const IntPointer k_array,
                                                                 @Const Pointer alpha_array,
                                                                 @Cast("const void*const*") PointerPointer Aarray,
                                                                 @Cast("cudaDataType_t") int Atype,
                                                                 @Const IntPointer lda_array,
                                                                 @Cast("const void*const*") PointerPointer Barray,
                                                                 @Cast("cudaDataType_t") int Btype,
                                                                 @Const IntPointer ldb_array,
                                                                 @Const Pointer beta_array,
                                                                 @Cast("void*const*") PointerPointer Carray,
                                                                 @Cast("cudaDataType_t") int Ctype,
                                                                 @Const IntPointer ldc_array,
                                                                 int group_count,
                                                                 @Const IntPointer group_size,
                                                                 @Cast("cublasComputeType_t") int computeType);
public static native @Cast("cublasStatus_t") int cublasGemmGroupedBatchedEx(cublasContext handle,
                                                                 @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                 @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                 @Const IntPointer m_array,
                                                                 @Const IntPointer n_array,
                                                                 @Const IntPointer k_array,
                                                                 @Const Pointer alpha_array,
                                                                 @Cast("const void*const*") @ByPtrPtr Pointer Aarray,
                                                                 @Cast("cudaDataType_t") int Atype,
                                                                 @Const IntPointer lda_array,
                                                                 @Cast("const void*const*") @ByPtrPtr Pointer Barray,
                                                                 @Cast("cudaDataType_t") int Btype,
                                                                 @Const IntPointer ldb_array,
                                                                 @Const Pointer beta_array,
                                                                 @Cast("void*const*") @ByPtrPtr Pointer Carray,
                                                                 @Cast("cudaDataType_t") int Ctype,
                                                                 @Const IntPointer ldc_array,
                                                                 int group_count,
                                                                 @Const IntPointer group_size,
                                                                 @Cast("cublasComputeType_t") int computeType);
public static native @Cast("cublasStatus_t") int cublasGemmGroupedBatchedEx(cublasContext handle,
                                                                 @Cast("const cublasOperation_t*") IntBuffer transa_array,
                                                                 @Cast("const cublasOperation_t*") IntBuffer transb_array,
                                                                 @Const IntBuffer m_array,
                                                                 @Const IntBuffer n_array,
                                                                 @Const IntBuffer k_array,
                                                                 @Const Pointer alpha_array,
                                                                 @Cast("const void*const*") @ByPtrPtr Pointer Aarray,
                                                                 @Cast("cudaDataType_t") int Atype,
                                                                 @Const IntBuffer lda_array,
                                                                 @Cast("const void*const*") @ByPtrPtr Pointer Barray,
                                                                 @Cast("cudaDataType_t") int Btype,
                                                                 @Const IntBuffer ldb_array,
                                                                 @Const Pointer beta_array,
                                                                 @Cast("void*const*") @ByPtrPtr Pointer Carray,
                                                                 @Cast("cudaDataType_t") int Ctype,
                                                                 @Const IntBuffer ldc_array,
                                                                 int group_count,
                                                                 @Const IntBuffer group_size,
                                                                 @Cast("cublasComputeType_t") int computeType);
public static native @Cast("cublasStatus_t") int cublasGemmGroupedBatchedEx(cublasContext handle,
                                                                 @Cast("const cublasOperation_t*") int[] transa_array,
                                                                 @Cast("const cublasOperation_t*") int[] transb_array,
                                                                 @Const int[] m_array,
                                                                 @Const int[] n_array,
                                                                 @Const int[] k_array,
                                                                 @Const Pointer alpha_array,
                                                                 @Cast("const void*const*") @ByPtrPtr Pointer Aarray,
                                                                 @Cast("cudaDataType_t") int Atype,
                                                                 @Const int[] lda_array,
                                                                 @Cast("const void*const*") @ByPtrPtr Pointer Barray,
                                                                 @Cast("cudaDataType_t") int Btype,
                                                                 @Const int[] ldb_array,
                                                                 @Const Pointer beta_array,
                                                                 @Cast("void*const*") @ByPtrPtr Pointer Carray,
                                                                 @Cast("cudaDataType_t") int Ctype,
                                                                 @Const int[] ldc_array,
                                                                 int group_count,
                                                                 @Const int[] group_size,
                                                                 @Cast("cublasComputeType_t") int computeType);

public static native @Cast("cublasStatus_t") int cublasGemmGroupedBatchedEx_64(cublasContext handle,
                                                                    @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                    @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                    @Cast("const int64_t*") LongPointer m_array,
                                                                    @Cast("const int64_t*") LongPointer n_array,
                                                                    @Cast("const int64_t*") LongPointer k_array,
                                                                    @Const Pointer alpha_array,
                                                                    @Cast("const void*const*") PointerPointer Aarray,
                                                                    @Cast("cudaDataType_t") int Atype,
                                                                    @Cast("const int64_t*") LongPointer lda_array,
                                                                    @Cast("const void*const*") PointerPointer Barray,
                                                                    @Cast("cudaDataType_t") int Btype,
                                                                    @Cast("const int64_t*") LongPointer ldb_array,
                                                                    @Const Pointer beta_array,
                                                                    @Cast("void*const*") PointerPointer Carray,
                                                                    @Cast("cudaDataType_t") int Ctype,
                                                                    @Cast("const int64_t*") LongPointer ldc_array,
                                                                    @Cast("int64_t") long group_count,
                                                                    @Cast("const int64_t*") LongPointer group_size,
                                                                    @Cast("cublasComputeType_t") int computeType);
public static native @Cast("cublasStatus_t") int cublasGemmGroupedBatchedEx_64(cublasContext handle,
                                                                    @Cast("const cublasOperation_t*") IntPointer transa_array,
                                                                    @Cast("const cublasOperation_t*") IntPointer transb_array,
                                                                    @Cast("const int64_t*") LongPointer m_array,
                                                                    @Cast("const int64_t*") LongPointer n_array,
                                                                    @Cast("const int64_t*") LongPointer k_array,
                                                                    @Const Pointer alpha_array,
                                                                    @Cast("const void*const*") @ByPtrPtr Pointer Aarray,
                                                                    @Cast("cudaDataType_t") int Atype,
                                                                    @Cast("const int64_t*") LongPointer lda_array,
                                                                    @Cast("const void*const*") @ByPtrPtr Pointer Barray,
                                                                    @Cast("cudaDataType_t") int Btype,
                                                                    @Cast("const int64_t*") LongPointer ldb_array,
                                                                    @Const Pointer beta_array,
                                                                    @Cast("void*const*") @ByPtrPtr Pointer Carray,
                                                                    @Cast("cudaDataType_t") int Ctype,
                                                                    @Cast("const int64_t*") LongPointer ldc_array,
                                                                    @Cast("int64_t") long group_count,
                                                                    @Cast("const int64_t*") LongPointer group_size,
                                                                    @Cast("cublasComputeType_t") int computeType);
public static native @Cast("cublasStatus_t") int cublasGemmGroupedBatchedEx_64(cublasContext handle,
                                                                    @Cast("const cublasOperation_t*") IntBuffer transa_array,
                                                                    @Cast("const cublasOperation_t*") IntBuffer transb_array,
                                                                    @Cast("const int64_t*") LongBuffer m_array,
                                                                    @Cast("const int64_t*") LongBuffer n_array,
                                                                    @Cast("const int64_t*") LongBuffer k_array,
                                                                    @Const Pointer alpha_array,
                                                                    @Cast("const void*const*") @ByPtrPtr Pointer Aarray,
                                                                    @Cast("cudaDataType_t") int Atype,
                                                                    @Cast("const int64_t*") LongBuffer lda_array,
                                                                    @Cast("const void*const*") @ByPtrPtr Pointer Barray,
                                                                    @Cast("cudaDataType_t") int Btype,
                                                                    @Cast("const int64_t*") LongBuffer ldb_array,
                                                                    @Const Pointer beta_array,
                                                                    @Cast("void*const*") @ByPtrPtr Pointer Carray,
                                                                    @Cast("cudaDataType_t") int Ctype,
                                                                    @Cast("const int64_t*") LongBuffer ldc_array,
                                                                    @Cast("int64_t") long group_count,
                                                                    @Cast("const int64_t*") LongBuffer group_size,
                                                                    @Cast("cublasComputeType_t") int computeType);
public static native @Cast("cublasStatus_t") int cublasGemmGroupedBatchedEx_64(cublasContext handle,
                                                                    @Cast("const cublasOperation_t*") int[] transa_array,
                                                                    @Cast("const cublasOperation_t*") int[] transb_array,
                                                                    @Cast("const int64_t*") long[] m_array,
                                                                    @Cast("const int64_t*") long[] n_array,
                                                                    @Cast("const int64_t*") long[] k_array,
                                                                    @Const Pointer alpha_array,
                                                                    @Cast("const void*const*") @ByPtrPtr Pointer Aarray,
                                                                    @Cast("cudaDataType_t") int Atype,
                                                                    @Cast("const int64_t*") long[] lda_array,
                                                                    @Cast("const void*const*") @ByPtrPtr Pointer Barray,
                                                                    @Cast("cudaDataType_t") int Btype,
                                                                    @Cast("const int64_t*") long[] ldb_array,
                                                                    @Const Pointer beta_array,
                                                                    @Cast("void*const*") @ByPtrPtr Pointer Carray,
                                                                    @Cast("cudaDataType_t") int Ctype,
                                                                    @Cast("const int64_t*") long[] ldc_array,
                                                                    @Cast("int64_t") long group_count,
                                                                    @Cast("const int64_t*") long[] group_size,
                                                                    @Cast("cublasComputeType_t") int computeType);

/* ---------------- CUBLAS BLAS-like Extension ---------------- */

/* GEAM */

public static native @Cast("cublasStatus_t") int cublasSgeam(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  @Const FloatPointer alpha,
                                                  @Const FloatPointer A,
                                                  int lda,
                                                  @Const FloatPointer beta,
                                                  @Const FloatPointer B,
                                                  int ldb,
                                                  FloatPointer C,
                                                  int ldc);
public static native @Cast("cublasStatus_t") int cublasSgeam(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  @Const FloatBuffer alpha,
                                                  @Const FloatBuffer A,
                                                  int lda,
                                                  @Const FloatBuffer beta,
                                                  @Const FloatBuffer B,
                                                  int ldb,
                                                  FloatBuffer C,
                                                  int ldc);
public static native @Cast("cublasStatus_t") int cublasSgeam(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  @Const float[] alpha,
                                                  @Const float[] A,
                                                  int lda,
                                                  @Const float[] beta,
                                                  @Const float[] B,
                                                  int ldb,
                                                  float[] C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasSgeam_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const FloatPointer alpha,
                                                     @Const FloatPointer A,
                                                     @Cast("int64_t") long lda,
                                                     @Const FloatPointer beta,
                                                     @Const FloatPointer B,
                                                     @Cast("int64_t") long ldb,
                                                     FloatPointer C,
                                                     @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSgeam_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const FloatBuffer alpha,
                                                     @Const FloatBuffer A,
                                                     @Cast("int64_t") long lda,
                                                     @Const FloatBuffer beta,
                                                     @Const FloatBuffer B,
                                                     @Cast("int64_t") long ldb,
                                                     FloatBuffer C,
                                                     @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSgeam_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const float[] alpha,
                                                     @Const float[] A,
                                                     @Cast("int64_t") long lda,
                                                     @Const float[] beta,
                                                     @Const float[] B,
                                                     @Cast("int64_t") long ldb,
                                                     float[] C,
                                                     @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasDgeam(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  @Const DoublePointer alpha,
                                                  @Const DoublePointer A,
                                                  int lda,
                                                  @Const DoublePointer beta,
                                                  @Const DoublePointer B,
                                                  int ldb,
                                                  DoublePointer C,
                                                  int ldc);
public static native @Cast("cublasStatus_t") int cublasDgeam(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  @Const DoubleBuffer alpha,
                                                  @Const DoubleBuffer A,
                                                  int lda,
                                                  @Const DoubleBuffer beta,
                                                  @Const DoubleBuffer B,
                                                  int ldb,
                                                  DoubleBuffer C,
                                                  int ldc);
public static native @Cast("cublasStatus_t") int cublasDgeam(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  @Const double[] alpha,
                                                  @Const double[] A,
                                                  int lda,
                                                  @Const double[] beta,
                                                  @Const double[] B,
                                                  int ldb,
                                                  double[] C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasDgeam_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const DoublePointer alpha,
                                                     @Const DoublePointer A,
                                                     @Cast("int64_t") long lda,
                                                     @Const DoublePointer beta,
                                                     @Const DoublePointer B,
                                                     @Cast("int64_t") long ldb,
                                                     DoublePointer C,
                                                     @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDgeam_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const DoubleBuffer alpha,
                                                     @Const DoubleBuffer A,
                                                     @Cast("int64_t") long lda,
                                                     @Const DoubleBuffer beta,
                                                     @Const DoubleBuffer B,
                                                     @Cast("int64_t") long ldb,
                                                     DoubleBuffer C,
                                                     @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDgeam_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const double[] alpha,
                                                     @Const double[] A,
                                                     @Cast("int64_t") long lda,
                                                     @Const double[] beta,
                                                     @Const double[] B,
                                                     @Cast("int64_t") long ldb,
                                                     double[] C,
                                                     @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCgeam(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  @Cast("const cuComplex*") float2 alpha,
                                                  @Cast("const cuComplex*") float2 A,
                                                  int lda,
                                                  @Cast("const cuComplex*") float2 beta,
                                                  @Cast("const cuComplex*") float2 B,
                                                  int ldb,
                                                  @Cast("cuComplex*") float2 C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasCgeam_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Cast("const cuComplex*") float2 alpha,
                                                     @Cast("const cuComplex*") float2 A,
                                                     @Cast("int64_t") long lda,
                                                     @Cast("const cuComplex*") float2 beta,
                                                     @Cast("const cuComplex*") float2 B,
                                                     @Cast("int64_t") long ldb,
                                                     @Cast("cuComplex*") float2 C,
                                                     @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZgeam(cublasContext handle,
                                                  @Cast("cublasOperation_t") int transa,
                                                  @Cast("cublasOperation_t") int transb,
                                                  int m,
                                                  int n,
                                                  @Cast("const cuDoubleComplex*") double2 alpha,
                                                  @Cast("const cuDoubleComplex*") double2 A,
                                                  int lda,
                                                  @Cast("const cuDoubleComplex*") double2 beta,
                                                  @Cast("const cuDoubleComplex*") double2 B,
                                                  int ldb,
                                                  @Cast("cuDoubleComplex*") double2 C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasZgeam_64(cublasContext handle,
                                                     @Cast("cublasOperation_t") int transa,
                                                     @Cast("cublasOperation_t") int transb,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Cast("const cuDoubleComplex*") double2 alpha,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     @Cast("int64_t") long lda,
                                                     @Cast("const cuDoubleComplex*") double2 beta,
                                                     @Cast("const cuDoubleComplex*") double2 B,
                                                     @Cast("int64_t") long ldb,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     @Cast("int64_t") long ldc);

/* TRSM - Batched Triangular Solver */

public static native @Cast("cublasStatus_t") int cublasStrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Const FloatPointer alpha,
                                                         @Cast("const float*const*") PointerPointer A,
                                                         int lda,
                                                         @Cast("float*const*") PointerPointer B,
                                                         int ldb,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasStrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Const FloatPointer alpha,
                                                         @Const @ByPtrPtr FloatPointer A,
                                                         int lda,
                                                         @ByPtrPtr FloatPointer B,
                                                         int ldb,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasStrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Const FloatBuffer alpha,
                                                         @Const @ByPtrPtr FloatBuffer A,
                                                         int lda,
                                                         @ByPtrPtr FloatBuffer B,
                                                         int ldb,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasStrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Const float[] alpha,
                                                         @Const @ByPtrPtr float[] A,
                                                         int lda,
                                                         @ByPtrPtr float[] B,
                                                         int ldb,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasStrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const FloatPointer alpha,
                                                            @Cast("const float*const*") PointerPointer A,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("float*const*") PointerPointer B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasStrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const FloatPointer alpha,
                                                            @Const @ByPtrPtr FloatPointer A,
                                                            @Cast("int64_t") long lda,
                                                            @ByPtrPtr FloatPointer B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasStrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const FloatBuffer alpha,
                                                            @Const @ByPtrPtr FloatBuffer A,
                                                            @Cast("int64_t") long lda,
                                                            @ByPtrPtr FloatBuffer B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasStrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const float[] alpha,
                                                            @Const @ByPtrPtr float[] A,
                                                            @Cast("int64_t") long lda,
                                                            @ByPtrPtr float[] B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasDtrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Const DoublePointer alpha,
                                                         @Cast("const double*const*") PointerPointer A,
                                                         int lda,
                                                         @Cast("double*const*") PointerPointer B,
                                                         int ldb,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDtrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Const DoublePointer alpha,
                                                         @Const @ByPtrPtr DoublePointer A,
                                                         int lda,
                                                         @ByPtrPtr DoublePointer B,
                                                         int ldb,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDtrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Const DoubleBuffer alpha,
                                                         @Const @ByPtrPtr DoubleBuffer A,
                                                         int lda,
                                                         @ByPtrPtr DoubleBuffer B,
                                                         int ldb,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasDtrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Const double[] alpha,
                                                         @Const @ByPtrPtr double[] A,
                                                         int lda,
                                                         @ByPtrPtr double[] B,
                                                         int ldb,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasDtrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const DoublePointer alpha,
                                                            @Cast("const double*const*") PointerPointer A,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("double*const*") PointerPointer B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDtrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const DoublePointer alpha,
                                                            @Const @ByPtrPtr DoublePointer A,
                                                            @Cast("int64_t") long lda,
                                                            @ByPtrPtr DoublePointer B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDtrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const DoubleBuffer alpha,
                                                            @Const @ByPtrPtr DoubleBuffer A,
                                                            @Cast("int64_t") long lda,
                                                            @ByPtrPtr DoubleBuffer B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasDtrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Const double[] alpha,
                                                            @Const @ByPtrPtr double[] A,
                                                            @Cast("int64_t") long lda,
                                                            @ByPtrPtr double[] B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasCtrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*const*") PointerPointer A,
                                                         int lda,
                                                         @Cast("cuComplex*const*") PointerPointer B,
                                                         int ldb,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasCtrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Cast("const cuComplex*") float2 alpha,
                                                         @Cast("const cuComplex*const*") @ByPtrPtr float2 A,
                                                         int lda,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 B,
                                                         int ldb,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasCtrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("const cuComplex*") float2 alpha,
                                                            @Cast("const cuComplex*const*") PointerPointer A,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("cuComplex*const*") PointerPointer B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasCtrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("const cuComplex*") float2 alpha,
                                                            @Cast("const cuComplex*const*") @ByPtrPtr float2 A,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("cuComplex*const*") @ByPtrPtr float2 B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);

public static native @Cast("cublasStatus_t") int cublasZtrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*const*") PointerPointer A,
                                                         int lda,
                                                         @Cast("cuDoubleComplex*const*") PointerPointer B,
                                                         int ldb,
                                                         int batchCount);
public static native @Cast("cublasStatus_t") int cublasZtrsmBatched(cublasContext handle,
                                                         @Cast("cublasSideMode_t") int side,
                                                         @Cast("cublasFillMode_t") int uplo,
                                                         @Cast("cublasOperation_t") int trans,
                                                         @Cast("cublasDiagType_t") int diag,
                                                         int m,
                                                         int n,
                                                         @Cast("const cuDoubleComplex*") double2 alpha,
                                                         @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 A,
                                                         int lda,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 B,
                                                         int ldb,
                                                         int batchCount);

public static native @Cast("cublasStatus_t") int cublasZtrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("const cuDoubleComplex*") double2 alpha,
                                                            @Cast("const cuDoubleComplex*const*") PointerPointer A,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("cuDoubleComplex*const*") PointerPointer B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);
public static native @Cast("cublasStatus_t") int cublasZtrsmBatched_64(cublasContext handle,
                                                            @Cast("cublasSideMode_t") int side,
                                                            @Cast("cublasFillMode_t") int uplo,
                                                            @Cast("cublasOperation_t") int trans,
                                                            @Cast("cublasDiagType_t") int diag,
                                                            @Cast("int64_t") long m,
                                                            @Cast("int64_t") long n,
                                                            @Cast("const cuDoubleComplex*") double2 alpha,
                                                            @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 A,
                                                            @Cast("int64_t") long lda,
                                                            @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 B,
                                                            @Cast("int64_t") long ldb,
                                                            @Cast("int64_t") long batchCount);

/* DGMM */

public static native @Cast("cublasStatus_t") int cublasSdgmm(cublasContext handle,
                                                  @Cast("cublasSideMode_t") int mode,
                                                  int m,
                                                  int n,
                                                  @Const FloatPointer A,
                                                  int lda,
                                                  @Const FloatPointer x,
                                                  int incx,
                                                  FloatPointer C,
                                                  int ldc);
public static native @Cast("cublasStatus_t") int cublasSdgmm(cublasContext handle,
                                                  @Cast("cublasSideMode_t") int mode,
                                                  int m,
                                                  int n,
                                                  @Const FloatBuffer A,
                                                  int lda,
                                                  @Const FloatBuffer x,
                                                  int incx,
                                                  FloatBuffer C,
                                                  int ldc);
public static native @Cast("cublasStatus_t") int cublasSdgmm(cublasContext handle,
                                                  @Cast("cublasSideMode_t") int mode,
                                                  int m,
                                                  int n,
                                                  @Const float[] A,
                                                  int lda,
                                                  @Const float[] x,
                                                  int incx,
                                                  float[] C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasSdgmm_64(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int mode,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const FloatPointer A,
                                                     @Cast("int64_t") long lda,
                                                     @Const FloatPointer x,
                                                     @Cast("int64_t") long incx,
                                                     FloatPointer C,
                                                     @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSdgmm_64(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int mode,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const FloatBuffer A,
                                                     @Cast("int64_t") long lda,
                                                     @Const FloatBuffer x,
                                                     @Cast("int64_t") long incx,
                                                     FloatBuffer C,
                                                     @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasSdgmm_64(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int mode,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const float[] A,
                                                     @Cast("int64_t") long lda,
                                                     @Const float[] x,
                                                     @Cast("int64_t") long incx,
                                                     float[] C,
                                                     @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasDdgmm(cublasContext handle,
                                                  @Cast("cublasSideMode_t") int mode,
                                                  int m,
                                                  int n,
                                                  @Const DoublePointer A,
                                                  int lda,
                                                  @Const DoublePointer x,
                                                  int incx,
                                                  DoublePointer C,
                                                  int ldc);
public static native @Cast("cublasStatus_t") int cublasDdgmm(cublasContext handle,
                                                  @Cast("cublasSideMode_t") int mode,
                                                  int m,
                                                  int n,
                                                  @Const DoubleBuffer A,
                                                  int lda,
                                                  @Const DoubleBuffer x,
                                                  int incx,
                                                  DoubleBuffer C,
                                                  int ldc);
public static native @Cast("cublasStatus_t") int cublasDdgmm(cublasContext handle,
                                                  @Cast("cublasSideMode_t") int mode,
                                                  int m,
                                                  int n,
                                                  @Const double[] A,
                                                  int lda,
                                                  @Const double[] x,
                                                  int incx,
                                                  double[] C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasDdgmm_64(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int mode,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const DoublePointer A,
                                                     @Cast("int64_t") long lda,
                                                     @Const DoublePointer x,
                                                     @Cast("int64_t") long incx,
                                                     DoublePointer C,
                                                     @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDdgmm_64(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int mode,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const DoubleBuffer A,
                                                     @Cast("int64_t") long lda,
                                                     @Const DoubleBuffer x,
                                                     @Cast("int64_t") long incx,
                                                     DoubleBuffer C,
                                                     @Cast("int64_t") long ldc);
public static native @Cast("cublasStatus_t") int cublasDdgmm_64(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int mode,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Const double[] A,
                                                     @Cast("int64_t") long lda,
                                                     @Const double[] x,
                                                     @Cast("int64_t") long incx,
                                                     double[] C,
                                                     @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasCdgmm(cublasContext handle,
                                                  @Cast("cublasSideMode_t") int mode,
                                                  int m,
                                                  int n,
                                                  @Cast("const cuComplex*") float2 A,
                                                  int lda,
                                                  @Cast("const cuComplex*") float2 x,
                                                  int incx,
                                                  @Cast("cuComplex*") float2 C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasCdgmm_64(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int mode,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Cast("const cuComplex*") float2 A,
                                                     @Cast("int64_t") long lda,
                                                     @Cast("const cuComplex*") float2 x,
                                                     @Cast("int64_t") long incx,
                                                     @Cast("cuComplex*") float2 C,
                                                     @Cast("int64_t") long ldc);

public static native @Cast("cublasStatus_t") int cublasZdgmm(cublasContext handle,
                                                  @Cast("cublasSideMode_t") int mode,
                                                  int m,
                                                  int n,
                                                  @Cast("const cuDoubleComplex*") double2 A,
                                                  int lda,
                                                  @Cast("const cuDoubleComplex*") double2 x,
                                                  int incx,
                                                  @Cast("cuDoubleComplex*") double2 C,
                                                  int ldc);

public static native @Cast("cublasStatus_t") int cublasZdgmm_64(cublasContext handle,
                                                     @Cast("cublasSideMode_t") int mode,
                                                     @Cast("int64_t") long m,
                                                     @Cast("int64_t") long n,
                                                     @Cast("const cuDoubleComplex*") double2 A,
                                                     @Cast("int64_t") long lda,
                                                     @Cast("const cuDoubleComplex*") double2 x,
                                                     @Cast("int64_t") long incx,
                                                     @Cast("cuDoubleComplex*") double2 C,
                                                     @Cast("int64_t") long ldc);

/* Batched - MATINV*/

public static native @Cast("cublasStatus_t") int cublasSmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const float*const*") PointerPointer A,
                                                           int lda,
                                                           @Cast("float*const*") PointerPointer Ainv,
                                                           int lda_inv,
                                                           IntPointer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasSmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Const @ByPtrPtr FloatPointer A,
                                                           int lda,
                                                           @ByPtrPtr FloatPointer Ainv,
                                                           int lda_inv,
                                                           IntPointer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasSmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Const @ByPtrPtr FloatBuffer A,
                                                           int lda,
                                                           @ByPtrPtr FloatBuffer Ainv,
                                                           int lda_inv,
                                                           IntBuffer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasSmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Const @ByPtrPtr float[] A,
                                                           int lda,
                                                           @ByPtrPtr float[] Ainv,
                                                           int lda_inv,
                                                           int[] info,
                                                           int batchSize);

public static native @Cast("cublasStatus_t") int cublasDmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const double*const*") PointerPointer A,
                                                           int lda,
                                                           @Cast("double*const*") PointerPointer Ainv,
                                                           int lda_inv,
                                                           IntPointer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasDmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Const @ByPtrPtr DoublePointer A,
                                                           int lda,
                                                           @ByPtrPtr DoublePointer Ainv,
                                                           int lda_inv,
                                                           IntPointer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasDmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Const @ByPtrPtr DoubleBuffer A,
                                                           int lda,
                                                           @ByPtrPtr DoubleBuffer Ainv,
                                                           int lda_inv,
                                                           IntBuffer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasDmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Const @ByPtrPtr double[] A,
                                                           int lda,
                                                           @ByPtrPtr double[] Ainv,
                                                           int lda_inv,
                                                           int[] info,
                                                           int batchSize);

public static native @Cast("cublasStatus_t") int cublasCmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const cuComplex*const*") PointerPointer A,
                                                           int lda,
                                                           @Cast("cuComplex*const*") PointerPointer Ainv,
                                                           int lda_inv,
                                                           IntPointer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasCmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const cuComplex*const*") @ByPtrPtr float2 A,
                                                           int lda,
                                                           @Cast("cuComplex*const*") @ByPtrPtr float2 Ainv,
                                                           int lda_inv,
                                                           IntPointer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasCmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const cuComplex*const*") @ByPtrPtr float2 A,
                                                           int lda,
                                                           @Cast("cuComplex*const*") @ByPtrPtr float2 Ainv,
                                                           int lda_inv,
                                                           IntBuffer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasCmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const cuComplex*const*") @ByPtrPtr float2 A,
                                                           int lda,
                                                           @Cast("cuComplex*const*") @ByPtrPtr float2 Ainv,
                                                           int lda_inv,
                                                           int[] info,
                                                           int batchSize);

public static native @Cast("cublasStatus_t") int cublasZmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const cuDoubleComplex*const*") PointerPointer A,
                                                           int lda,
                                                           @Cast("cuDoubleComplex*const*") PointerPointer Ainv,
                                                           int lda_inv,
                                                           IntPointer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasZmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 A,
                                                           int lda,
                                                           @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Ainv,
                                                           int lda_inv,
                                                           IntPointer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasZmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 A,
                                                           int lda,
                                                           @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Ainv,
                                                           int lda_inv,
                                                           IntBuffer info,
                                                           int batchSize);
public static native @Cast("cublasStatus_t") int cublasZmatinvBatched(cublasContext handle,
                                                           int n,
                                                           @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 A,
                                                           int lda,
                                                           @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Ainv,
                                                           int lda_inv,
                                                           int[] info,
                                                           int batchSize);

/* Batch QR Factorization */

public static native @Cast("cublasStatus_t") int cublasSgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("float*const*") PointerPointer Aarray,
                                                          int lda,
                                                          @Cast("float*const*") PointerPointer TauArray,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @ByPtrPtr FloatPointer Aarray,
                                                          int lda,
                                                          @ByPtrPtr FloatPointer TauArray,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @ByPtrPtr FloatBuffer Aarray,
                                                          int lda,
                                                          @ByPtrPtr FloatBuffer TauArray,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @ByPtrPtr float[] Aarray,
                                                          int lda,
                                                          @ByPtrPtr float[] TauArray,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasDgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("double*const*") PointerPointer Aarray,
                                                          int lda,
                                                          @Cast("double*const*") PointerPointer TauArray,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @ByPtrPtr DoublePointer Aarray,
                                                          int lda,
                                                          @ByPtrPtr DoublePointer TauArray,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @ByPtrPtr DoubleBuffer Aarray,
                                                          int lda,
                                                          @ByPtrPtr DoubleBuffer TauArray,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @ByPtrPtr double[] Aarray,
                                                          int lda,
                                                          @ByPtrPtr double[] TauArray,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasCgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("cuComplex*const*") PointerPointer Aarray,
                                                          int lda,
                                                          @Cast("cuComplex*const*") PointerPointer TauArray,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                          int lda,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 TauArray,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                          int lda,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 TauArray,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                          int lda,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 TauArray,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasZgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("cuDoubleComplex*const*") PointerPointer Aarray,
                                                          int lda,
                                                          @Cast("cuDoubleComplex*const*") PointerPointer TauArray,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                          int lda,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 TauArray,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                          int lda,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 TauArray,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgeqrfBatched(cublasContext handle,
                                                          int m,
                                                          int n,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                          int lda,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 TauArray,
                                                          int[] info,
                                                          int batchSize);

/* Least Square Min only m >= n and Non-transpose supported */

public static native @Cast("cublasStatus_t") int cublasSgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("float*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("float*const*") PointerPointer Carray,
                                                         int ldc,
                                                         IntPointer info,
                                                         IntPointer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @ByPtrPtr FloatPointer Aarray,
                                                         int lda,
                                                         @ByPtrPtr FloatPointer Carray,
                                                         int ldc,
                                                         IntPointer info,
                                                         IntPointer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @ByPtrPtr FloatBuffer Aarray,
                                                         int lda,
                                                         @ByPtrPtr FloatBuffer Carray,
                                                         int ldc,
                                                         IntBuffer info,
                                                         IntBuffer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @ByPtrPtr float[] Aarray,
                                                         int lda,
                                                         @ByPtrPtr float[] Carray,
                                                         int ldc,
                                                         int[] info,
                                                         int[] devInfoArray,
                                                         int batchSize);

public static native @Cast("cublasStatus_t") int cublasDgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("double*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("double*const*") PointerPointer Carray,
                                                         int ldc,
                                                         IntPointer info,
                                                         IntPointer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @ByPtrPtr DoublePointer Aarray,
                                                         int lda,
                                                         @ByPtrPtr DoublePointer Carray,
                                                         int ldc,
                                                         IntPointer info,
                                                         IntPointer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @ByPtrPtr DoubleBuffer Aarray,
                                                         int lda,
                                                         @ByPtrPtr DoubleBuffer Carray,
                                                         int ldc,
                                                         IntBuffer info,
                                                         IntBuffer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @ByPtrPtr double[] Aarray,
                                                         int lda,
                                                         @ByPtrPtr double[] Carray,
                                                         int ldc,
                                                         int[] info,
                                                         int[] devInfoArray,
                                                         int batchSize);

public static native @Cast("cublasStatus_t") int cublasCgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("cuComplex*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("cuComplex*const*") PointerPointer Carray,
                                                         int ldc,
                                                         IntPointer info,
                                                         IntPointer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                         int lda,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 Carray,
                                                         int ldc,
                                                         IntPointer info,
                                                         IntPointer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                         int lda,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 Carray,
                                                         int ldc,
                                                         IntBuffer info,
                                                         IntBuffer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                         int lda,
                                                         @Cast("cuComplex*const*") @ByPtrPtr float2 Carray,
                                                         int ldc,
                                                         int[] info,
                                                         int[] devInfoArray,
                                                         int batchSize);

public static native @Cast("cublasStatus_t") int cublasZgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("cuDoubleComplex*const*") PointerPointer Aarray,
                                                         int lda,
                                                         @Cast("cuDoubleComplex*const*") PointerPointer Carray,
                                                         int ldc,
                                                         IntPointer info,
                                                         IntPointer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                         int lda,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Carray,
                                                         int ldc,
                                                         IntPointer info,
                                                         IntPointer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                         int lda,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Carray,
                                                         int ldc,
                                                         IntBuffer info,
                                                         IntBuffer devInfoArray,
                                                         int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgelsBatched(cublasContext handle,
                                                         @Cast("cublasOperation_t") int trans,
                                                         int m,
                                                         int n,
                                                         int nrhs,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                         int lda,
                                                         @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Carray,
                                                         int ldc,
                                                         int[] info,
                                                         int[] devInfoArray,
                                                         int batchSize);

/* TPTTR : Triangular Pack format to Triangular format */

public static native @Cast("cublasStatus_t") int cublasStpttr(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const FloatPointer AP, FloatPointer A, int lda);
public static native @Cast("cublasStatus_t") int cublasStpttr(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const FloatBuffer AP, FloatBuffer A, int lda);
public static native @Cast("cublasStatus_t") int cublasStpttr(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const float[] AP, float[] A, int lda);

public static native @Cast("cublasStatus_t") int cublasDtpttr(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const DoublePointer AP, DoublePointer A, int lda);
public static native @Cast("cublasStatus_t") int cublasDtpttr(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const DoubleBuffer AP, DoubleBuffer A, int lda);
public static native @Cast("cublasStatus_t") int cublasDtpttr(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const double[] AP, double[] A, int lda);

public static native @Cast("cublasStatus_t") int cublasCtpttr(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Cast("const cuComplex*") float2 AP, @Cast("cuComplex*") float2 A, int lda);

public static native @Cast("cublasStatus_t") int cublasZtpttr(
    cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Cast("const cuDoubleComplex*") double2 AP, @Cast("cuDoubleComplex*") double2 A, int lda);

/* TRTTP : Triangular format to Triangular Pack format */

public static native @Cast("cublasStatus_t") int cublasStrttp(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const FloatPointer A, int lda, FloatPointer AP);
public static native @Cast("cublasStatus_t") int cublasStrttp(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const FloatBuffer A, int lda, FloatBuffer AP);
public static native @Cast("cublasStatus_t") int cublasStrttp(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const float[] A, int lda, float[] AP);

public static native @Cast("cublasStatus_t") int cublasDtrttp(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const DoublePointer A, int lda, DoublePointer AP);
public static native @Cast("cublasStatus_t") int cublasDtrttp(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const DoubleBuffer A, int lda, DoubleBuffer AP);
public static native @Cast("cublasStatus_t") int cublasDtrttp(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Const double[] A, int lda, double[] AP);

public static native @Cast("cublasStatus_t") int cublasCtrttp(cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Cast("const cuComplex*") float2 A, int lda, @Cast("cuComplex*") float2 AP);

public static native @Cast("cublasStatus_t") int cublasZtrttp(
    cublasContext handle, @Cast("cublasFillMode_t") int uplo, int n, @Cast("const cuDoubleComplex*") double2 A, int lda, @Cast("cuDoubleComplex*") double2 AP);

/* Batched LU - GETRF*/

public static native @Cast("cublasStatus_t") int cublasSgetrfBatched(cublasContext handle, int n, @Cast("float*const*") PointerPointer A, int lda, IntPointer P, IntPointer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetrfBatched(cublasContext handle, int n, @ByPtrPtr FloatPointer A, int lda, IntPointer P, IntPointer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetrfBatched(cublasContext handle, int n, @ByPtrPtr FloatBuffer A, int lda, IntBuffer P, IntBuffer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetrfBatched(cublasContext handle, int n, @ByPtrPtr float[] A, int lda, int[] P, int[] info, int batchSize);

public static native @Cast("cublasStatus_t") int cublasDgetrfBatched(cublasContext handle, int n, @Cast("double*const*") PointerPointer A, int lda, IntPointer P, IntPointer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetrfBatched(cublasContext handle, int n, @ByPtrPtr DoublePointer A, int lda, IntPointer P, IntPointer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetrfBatched(cublasContext handle, int n, @ByPtrPtr DoubleBuffer A, int lda, IntBuffer P, IntBuffer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetrfBatched(cublasContext handle, int n, @ByPtrPtr double[] A, int lda, int[] P, int[] info, int batchSize);

public static native @Cast("cublasStatus_t") int cublasCgetrfBatched(cublasContext handle, int n, @Cast("cuComplex*const*") PointerPointer A, int lda, IntPointer P, IntPointer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetrfBatched(cublasContext handle, int n, @Cast("cuComplex*const*") @ByPtrPtr float2 A, int lda, IntPointer P, IntPointer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetrfBatched(cublasContext handle, int n, @Cast("cuComplex*const*") @ByPtrPtr float2 A, int lda, IntBuffer P, IntBuffer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetrfBatched(cublasContext handle, int n, @Cast("cuComplex*const*") @ByPtrPtr float2 A, int lda, int[] P, int[] info, int batchSize);

public static native @Cast("cublasStatus_t") int cublasZgetrfBatched(
    cublasContext handle, int n, @Cast("cuDoubleComplex*const*") PointerPointer A, int lda, IntPointer P, IntPointer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetrfBatched(
    cublasContext handle, int n, @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 A, int lda, IntPointer P, IntPointer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetrfBatched(
    cublasContext handle, int n, @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 A, int lda, IntBuffer P, IntBuffer info, int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetrfBatched(
    cublasContext handle, int n, @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 A, int lda, int[] P, int[] info, int batchSize);

/* Batched inversion based on LU factorization from getrf */

public static native @Cast("cublasStatus_t") int cublasSgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const float*const*") PointerPointer A,
                                                          int lda,
                                                          @Const IntPointer P,
                                                          @Cast("float*const*") PointerPointer C,
                                                          int ldc,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Const @ByPtrPtr FloatPointer A,
                                                          int lda,
                                                          @Const IntPointer P,
                                                          @ByPtrPtr FloatPointer C,
                                                          int ldc,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Const @ByPtrPtr FloatBuffer A,
                                                          int lda,
                                                          @Const IntBuffer P,
                                                          @ByPtrPtr FloatBuffer C,
                                                          int ldc,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Const @ByPtrPtr float[] A,
                                                          int lda,
                                                          @Const int[] P,
                                                          @ByPtrPtr float[] C,
                                                          int ldc,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasDgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const double*const*") PointerPointer A,
                                                          int lda,
                                                          @Const IntPointer P,
                                                          @Cast("double*const*") PointerPointer C,
                                                          int ldc,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Const @ByPtrPtr DoublePointer A,
                                                          int lda,
                                                          @Const IntPointer P,
                                                          @ByPtrPtr DoublePointer C,
                                                          int ldc,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Const @ByPtrPtr DoubleBuffer A,
                                                          int lda,
                                                          @Const IntBuffer P,
                                                          @ByPtrPtr DoubleBuffer C,
                                                          int ldc,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Const @ByPtrPtr double[] A,
                                                          int lda,
                                                          @Const int[] P,
                                                          @ByPtrPtr double[] C,
                                                          int ldc,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasCgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const cuComplex*const*") PointerPointer A,
                                                          int lda,
                                                          @Const IntPointer P,
                                                          @Cast("cuComplex*const*") PointerPointer C,
                                                          int ldc,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const cuComplex*const*") @ByPtrPtr float2 A,
                                                          int lda,
                                                          @Const IntPointer P,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 C,
                                                          int ldc,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const cuComplex*const*") @ByPtrPtr float2 A,
                                                          int lda,
                                                          @Const IntBuffer P,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 C,
                                                          int ldc,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const cuComplex*const*") @ByPtrPtr float2 A,
                                                          int lda,
                                                          @Const int[] P,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 C,
                                                          int ldc,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasZgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const cuDoubleComplex*const*") PointerPointer A,
                                                          int lda,
                                                          @Const IntPointer P,
                                                          @Cast("cuDoubleComplex*const*") PointerPointer C,
                                                          int ldc,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 A,
                                                          int lda,
                                                          @Const IntPointer P,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 C,
                                                          int ldc,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 A,
                                                          int lda,
                                                          @Const IntBuffer P,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 C,
                                                          int ldc,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetriBatched(cublasContext handle,
                                                          int n,
                                                          @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 A,
                                                          int lda,
                                                          @Const int[] P,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 C,
                                                          int ldc,
                                                          int[] info,
                                                          int batchSize);

/* Batched solver based on LU factorization from getrf */

public static native @Cast("cublasStatus_t") int cublasSgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const float*const*") PointerPointer Aarray,
                                                          int lda,
                                                          @Const IntPointer devIpiv,
                                                          @Cast("float*const*") PointerPointer Barray,
                                                          int ldb,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Const @ByPtrPtr FloatPointer Aarray,
                                                          int lda,
                                                          @Const IntPointer devIpiv,
                                                          @ByPtrPtr FloatPointer Barray,
                                                          int ldb,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Const @ByPtrPtr FloatBuffer Aarray,
                                                          int lda,
                                                          @Const IntBuffer devIpiv,
                                                          @ByPtrPtr FloatBuffer Barray,
                                                          int ldb,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasSgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Const @ByPtrPtr float[] Aarray,
                                                          int lda,
                                                          @Const int[] devIpiv,
                                                          @ByPtrPtr float[] Barray,
                                                          int ldb,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasDgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const double*const*") PointerPointer Aarray,
                                                          int lda,
                                                          @Const IntPointer devIpiv,
                                                          @Cast("double*const*") PointerPointer Barray,
                                                          int ldb,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Const @ByPtrPtr DoublePointer Aarray,
                                                          int lda,
                                                          @Const IntPointer devIpiv,
                                                          @ByPtrPtr DoublePointer Barray,
                                                          int ldb,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Const @ByPtrPtr DoubleBuffer Aarray,
                                                          int lda,
                                                          @Const IntBuffer devIpiv,
                                                          @ByPtrPtr DoubleBuffer Barray,
                                                          int ldb,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasDgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Const @ByPtrPtr double[] Aarray,
                                                          int lda,
                                                          @Const int[] devIpiv,
                                                          @ByPtrPtr double[] Barray,
                                                          int ldb,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasCgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const cuComplex*const*") PointerPointer Aarray,
                                                          int lda,
                                                          @Const IntPointer devIpiv,
                                                          @Cast("cuComplex*const*") PointerPointer Barray,
                                                          int ldb,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                          int lda,
                                                          @Const IntPointer devIpiv,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 Barray,
                                                          int ldb,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                          int lda,
                                                          @Const IntBuffer devIpiv,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 Barray,
                                                          int ldb,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasCgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const cuComplex*const*") @ByPtrPtr float2 Aarray,
                                                          int lda,
                                                          @Const int[] devIpiv,
                                                          @Cast("cuComplex*const*") @ByPtrPtr float2 Barray,
                                                          int ldb,
                                                          int[] info,
                                                          int batchSize);

public static native @Cast("cublasStatus_t") int cublasZgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const cuDoubleComplex*const*") PointerPointer Aarray,
                                                          int lda,
                                                          @Const IntPointer devIpiv,
                                                          @Cast("cuDoubleComplex*const*") PointerPointer Barray,
                                                          int ldb,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                          int lda,
                                                          @Const IntPointer devIpiv,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Barray,
                                                          int ldb,
                                                          IntPointer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                          int lda,
                                                          @Const IntBuffer devIpiv,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Barray,
                                                          int ldb,
                                                          IntBuffer info,
                                                          int batchSize);
public static native @Cast("cublasStatus_t") int cublasZgetrsBatched(cublasContext handle,
                                                          @Cast("cublasOperation_t") int trans,
                                                          int n,
                                                          int nrhs,
                                                          @Cast("const cuDoubleComplex*const*") @ByPtrPtr double2 Aarray,
                                                          int lda,
                                                          @Const int[] devIpiv,
                                                          @Cast("cuDoubleComplex*const*") @ByPtrPtr double2 Barray,
                                                          int ldb,
                                                          int[] info,
                                                          int batchSize);

/* Deprecated */

public static native @Cast("cublasStatus_t") int cublasUint8gemmBias(cublasContext handle,
                                                          @Cast("cublasOperation_t") int transa,
                                                          @Cast("cublasOperation_t") int transb,
                                                          @Cast("cublasOperation_t") int transc,
                                                          int m,
                                                          int n,
                                                          int k,
                                                          @Cast("const unsigned char*") BytePointer A,
                                                          int A_bias,
                                                          int lda,
                                                          @Cast("const unsigned char*") BytePointer B,
                                                          int B_bias,
                                                          int ldb,
                                                          @Cast("unsigned char*") BytePointer C,
                                                          int C_bias,
                                                          int ldc,
                                                          int C_mult,
                                                          int C_shift);
public static native @Cast("cublasStatus_t") int cublasUint8gemmBias(cublasContext handle,
                                                          @Cast("cublasOperation_t") int transa,
                                                          @Cast("cublasOperation_t") int transb,
                                                          @Cast("cublasOperation_t") int transc,
                                                          int m,
                                                          int n,
                                                          int k,
                                                          @Cast("const unsigned char*") ByteBuffer A,
                                                          int A_bias,
                                                          int lda,
                                                          @Cast("const unsigned char*") ByteBuffer B,
                                                          int B_bias,
                                                          int ldb,
                                                          @Cast("unsigned char*") ByteBuffer C,
                                                          int C_bias,
                                                          int ldc,
                                                          int C_mult,
                                                          int C_shift);
public static native @Cast("cublasStatus_t") int cublasUint8gemmBias(cublasContext handle,
                                                          @Cast("cublasOperation_t") int transa,
                                                          @Cast("cublasOperation_t") int transb,
                                                          @Cast("cublasOperation_t") int transc,
                                                          int m,
                                                          int n,
                                                          int k,
                                                          @Cast("const unsigned char*") byte[] A,
                                                          int A_bias,
                                                          int lda,
                                                          @Cast("const unsigned char*") byte[] B,
                                                          int B_bias,
                                                          int ldb,
                                                          @Cast("unsigned char*") byte[] C,
                                                          int C_bias,
                                                          int ldc,
                                                          int C_mult,
                                                          int C_shift);

/* }}} cuBLAS Exported API */

// #if defined(__cplusplus)

public static native @Cast("cublasStatus_t") int cublasMigrateComputeType(cublasContext handle,
                                                      @Cast("cudaDataType_t") int dataType,
                                                      @Cast("cublasComputeType_t*") IntPointer computeType);
public static native @Cast("cublasStatus_t") int cublasMigrateComputeType(cublasContext handle,
                                                      @Cast("cudaDataType_t") int dataType,
                                                      @Cast("cublasComputeType_t*") IntBuffer computeType);
public static native @Cast("cublasStatus_t") int cublasMigrateComputeType(cublasContext handle,
                                                      @Cast("cudaDataType_t") int dataType,
                                                      @Cast("cublasComputeType_t*") int[] computeType);
/* wrappers to accept old code with cudaDataType computeType when referenced from c++ code */
// #endif /* __cplusplus */

// #endif /* !defined(CUBLAS_API_H_) */


// Parsed from <cublas.h>

/*
 * Copyright 1993-2019 NVIDIA Corporation. All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 * This is the public header file for the CUBLAS library, defining the API
 *
 * CUBLAS is an implementation of BLAS (Basic Linear Algebra Subroutines)
 * on top of the CUDA runtime.
 */

// #if !defined(CUBLAS_H_)
// #define CUBLAS_H_

// #if defined(CUBLAS_V2_H_)
// #error "It is an error to include both cublas.h and cublas_v2.h"
// #endif

// #include <cuda_runtime.h>

// #ifndef CUBLASWINAPI
// #ifdef _WIN32
// #define CUBLASWINAPI __stdcall
// #else
// #define CUBLASWINAPI
// #endif
// #endif

// #undef CUBLASAPI
// #ifdef __CUDACC__
// #define CUBLASAPI __host__
// #else
// #define CUBLASAPI
// #endif

// #include "cublas_api.h"

// #if defined(__cplusplus)
// #endif

/* CUBLAS data types */
// #define cublasStatus cublasStatus_t

public static native @Cast("cublasStatus_t") int cublasInit();
public static native @Cast("cublasStatus_t") int cublasShutdown();
public static native @Cast("cublasStatus_t") int cublasGetError();

public static native @Cast("cublasStatus_t") int cublasGetVersion(IntPointer version);
public static native @Cast("cublasStatus_t") int cublasGetVersion(IntBuffer version);
public static native @Cast("cublasStatus_t") int cublasGetVersion(int[] version);
public static native @Cast("cublasStatus_t") int cublasAlloc(int n, int elemSize, @Cast("void**") PointerPointer devicePtr);
public static native @Cast("cublasStatus_t") int cublasAlloc(int n, int elemSize, @Cast("void**") @ByPtrPtr Pointer devicePtr);

public static native @Cast("cublasStatus_t") int cublasFree(Pointer devicePtr);

public static native @Cast("cublasStatus_t") int cublasSetKernelStream(CUstream_st stream);

/* ---------------- CUBLAS BLAS1 functions ---------------- */
/* NRM2 */
public static native float cublasSnrm2(int n, @Const FloatPointer x, int incx);
public static native float cublasSnrm2(int n, @Const FloatBuffer x, int incx);
public static native float cublasSnrm2(int n, @Const float[] x, int incx);
public static native double cublasDnrm2(int n, @Const DoublePointer x, int incx);
public static native double cublasDnrm2(int n, @Const DoubleBuffer x, int incx);
public static native double cublasDnrm2(int n, @Const double[] x, int incx);
public static native float cublasScnrm2(int n, @Cast("const cuComplex*") float2 x, int incx);
public static native double cublasDznrm2(int n, @Cast("const cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* DOT */
public static native float cublasSdot(int n, @Const FloatPointer x, int incx, @Const FloatPointer y, int incy);
public static native float cublasSdot(int n, @Const FloatBuffer x, int incx, @Const FloatBuffer y, int incy);
public static native float cublasSdot(int n, @Const float[] x, int incx, @Const float[] y, int incy);
public static native double cublasDdot(int n, @Const DoublePointer x, int incx, @Const DoublePointer y, int incy);
public static native double cublasDdot(int n, @Const DoubleBuffer x, int incx, @Const DoubleBuffer y, int incy);
public static native double cublasDdot(int n, @Const double[] x, int incx, @Const double[] y, int incy);
public static native @ByVal @Cast("cuComplex*") float2 cublasCdotu(int n, @Cast("const cuComplex*") float2 x, int incx, @Cast("const cuComplex*") float2 y, int incy);
public static native @ByVal @Cast("cuComplex*") float2 cublasCdotc(int n, @Cast("const cuComplex*") float2 x, int incx, @Cast("const cuComplex*") float2 y, int incy);
public static native @ByVal @Cast("cuDoubleComplex*") double2 cublasZdotu(int n, @Cast("const cuDoubleComplex*") double2 x, int incx, @Cast("const cuDoubleComplex*") double2 y, int incy);
public static native @ByVal @Cast("cuDoubleComplex*") double2 cublasZdotc(int n, @Cast("const cuDoubleComplex*") double2 x, int incx, @Cast("const cuDoubleComplex*") double2 y, int incy);
/*------------------------------------------------------------------------*/
/* SCAL */
public static native void cublasSscal(int n, float alpha, FloatPointer x, int incx);
public static native void cublasSscal(int n, float alpha, FloatBuffer x, int incx);
public static native void cublasSscal(int n, float alpha, float[] x, int incx);
public static native void cublasDscal(int n, double alpha, DoublePointer x, int incx);
public static native void cublasDscal(int n, double alpha, DoubleBuffer x, int incx);
public static native void cublasDscal(int n, double alpha, double[] x, int incx);
public static native void cublasCscal(int n, @ByVal @Cast("cuComplex*") float2 alpha, @Cast("cuComplex*") float2 x, int incx);
public static native void cublasZscal(int n, @ByVal @Cast("cuDoubleComplex*") double2 alpha, @Cast("cuDoubleComplex*") double2 x, int incx);

public static native void cublasCsscal(int n, float alpha, @Cast("cuComplex*") float2 x, int incx);
public static native void cublasZdscal(int n, double alpha, @Cast("cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* AXPY */
public static native void cublasSaxpy(int n, float alpha, @Const FloatPointer x, int incx, FloatPointer y, int incy);
public static native void cublasSaxpy(int n, float alpha, @Const FloatBuffer x, int incx, FloatBuffer y, int incy);
public static native void cublasSaxpy(int n, float alpha, @Const float[] x, int incx, float[] y, int incy);
public static native void cublasDaxpy(int n, double alpha, @Const DoublePointer x, int incx, DoublePointer y, int incy);
public static native void cublasDaxpy(int n, double alpha, @Const DoubleBuffer x, int incx, DoubleBuffer y, int incy);
public static native void cublasDaxpy(int n, double alpha, @Const double[] x, int incx, double[] y, int incy);
public static native void cublasCaxpy(int n, @ByVal @Cast("cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy);
public static native void cublasZaxpy(int n, @ByVal @Cast("cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 y, int incy);
/*------------------------------------------------------------------------*/
/* COPY */
public static native void cublasScopy(int n, @Const FloatPointer x, int incx, FloatPointer y, int incy);
public static native void cublasScopy(int n, @Const FloatBuffer x, int incx, FloatBuffer y, int incy);
public static native void cublasScopy(int n, @Const float[] x, int incx, float[] y, int incy);
public static native void cublasDcopy(int n, @Const DoublePointer x, int incx, DoublePointer y, int incy);
public static native void cublasDcopy(int n, @Const DoubleBuffer x, int incx, DoubleBuffer y, int incy);
public static native void cublasDcopy(int n, @Const double[] x, int incx, double[] y, int incy);
public static native void cublasCcopy(int n, @Cast("const cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy);
public static native void cublasZcopy(int n, @Cast("const cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 y, int incy);
/*------------------------------------------------------------------------*/
/* SWAP */
public static native void cublasSswap(int n, FloatPointer x, int incx, FloatPointer y, int incy);
public static native void cublasSswap(int n, FloatBuffer x, int incx, FloatBuffer y, int incy);
public static native void cublasSswap(int n, float[] x, int incx, float[] y, int incy);
public static native void cublasDswap(int n, DoublePointer x, int incx, DoublePointer y, int incy);
public static native void cublasDswap(int n, DoubleBuffer x, int incx, DoubleBuffer y, int incy);
public static native void cublasDswap(int n, double[] x, int incx, double[] y, int incy);
public static native void cublasCswap(int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy);
public static native void cublasZswap(int n, @Cast("cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 y, int incy);
/*------------------------------------------------------------------------*/
/* AMAX */
public static native int cublasIsamax(int n, @Const FloatPointer x, int incx);
public static native int cublasIsamax(int n, @Const FloatBuffer x, int incx);
public static native int cublasIsamax(int n, @Const float[] x, int incx);
public static native int cublasIdamax(int n, @Const DoublePointer x, int incx);
public static native int cublasIdamax(int n, @Const DoubleBuffer x, int incx);
public static native int cublasIdamax(int n, @Const double[] x, int incx);
public static native int cublasIcamax(int n, @Cast("const cuComplex*") float2 x, int incx);
public static native int cublasIzamax(int n, @Cast("const cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* AMIN */
public static native int cublasIsamin(int n, @Const FloatPointer x, int incx);
public static native int cublasIsamin(int n, @Const FloatBuffer x, int incx);
public static native int cublasIsamin(int n, @Const float[] x, int incx);
public static native int cublasIdamin(int n, @Const DoublePointer x, int incx);
public static native int cublasIdamin(int n, @Const DoubleBuffer x, int incx);
public static native int cublasIdamin(int n, @Const double[] x, int incx);

public static native int cublasIcamin(int n, @Cast("const cuComplex*") float2 x, int incx);
public static native int cublasIzamin(int n, @Cast("const cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* ASUM */
public static native float cublasSasum(int n, @Const FloatPointer x, int incx);
public static native float cublasSasum(int n, @Const FloatBuffer x, int incx);
public static native float cublasSasum(int n, @Const float[] x, int incx);
public static native double cublasDasum(int n, @Const DoublePointer x, int incx);
public static native double cublasDasum(int n, @Const DoubleBuffer x, int incx);
public static native double cublasDasum(int n, @Const double[] x, int incx);
public static native float cublasScasum(int n, @Cast("const cuComplex*") float2 x, int incx);
public static native double cublasDzasum(int n, @Cast("const cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* ROT */
public static native void cublasSrot(int n, FloatPointer x, int incx, FloatPointer y, int incy, float sc, float ss);
public static native void cublasSrot(int n, FloatBuffer x, int incx, FloatBuffer y, int incy, float sc, float ss);
public static native void cublasSrot(int n, float[] x, int incx, float[] y, int incy, float sc, float ss);
public static native void cublasDrot(int n, DoublePointer x, int incx, DoublePointer y, int incy, double sc, double ss);
public static native void cublasDrot(int n, DoubleBuffer x, int incx, DoubleBuffer y, int incy, double sc, double ss);
public static native void cublasDrot(int n, double[] x, int incx, double[] y, int incy, double sc, double ss);
public static native void cublasCrot(int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy, float c, @ByVal @Cast("cuComplex*") float2 s);
public static native void cublasZrot(int n, @Cast("cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 y, int incy, double sc, @ByVal @Cast("cuDoubleComplex*") double2 cs);
public static native void cublasCsrot(int n, @Cast("cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 y, int incy, float c, float s);
public static native void cublasZdrot(int n, @Cast("cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 y, int incy, double c, double s);
/*------------------------------------------------------------------------*/
/* ROTG */
public static native void cublasSrotg(FloatPointer sa, FloatPointer sb, FloatPointer sc, FloatPointer ss);
public static native void cublasSrotg(FloatBuffer sa, FloatBuffer sb, FloatBuffer sc, FloatBuffer ss);
public static native void cublasSrotg(float[] sa, float[] sb, float[] sc, float[] ss);
public static native void cublasDrotg(DoublePointer sa, DoublePointer sb, DoublePointer sc, DoublePointer ss);
public static native void cublasDrotg(DoubleBuffer sa, DoubleBuffer sb, DoubleBuffer sc, DoubleBuffer ss);
public static native void cublasDrotg(double[] sa, double[] sb, double[] sc, double[] ss);
public static native void cublasCrotg(@Cast("cuComplex*") float2 ca, @ByVal @Cast("cuComplex*") float2 cb, FloatPointer sc, @Cast("cuComplex*") float2 cs);
public static native void cublasCrotg(@Cast("cuComplex*") float2 ca, @ByVal @Cast("cuComplex*") float2 cb, FloatBuffer sc, @Cast("cuComplex*") float2 cs);
public static native void cublasCrotg(@Cast("cuComplex*") float2 ca, @ByVal @Cast("cuComplex*") float2 cb, float[] sc, @Cast("cuComplex*") float2 cs);
public static native void cublasZrotg(@Cast("cuDoubleComplex*") double2 ca, @ByVal @Cast("cuDoubleComplex*") double2 cb, DoublePointer sc, @Cast("cuDoubleComplex*") double2 cs);
public static native void cublasZrotg(@Cast("cuDoubleComplex*") double2 ca, @ByVal @Cast("cuDoubleComplex*") double2 cb, DoubleBuffer sc, @Cast("cuDoubleComplex*") double2 cs);
public static native void cublasZrotg(@Cast("cuDoubleComplex*") double2 ca, @ByVal @Cast("cuDoubleComplex*") double2 cb, double[] sc, @Cast("cuDoubleComplex*") double2 cs);
/*------------------------------------------------------------------------*/
/* ROTM */
public static native void cublasSrotm(int n, FloatPointer x, int incx, FloatPointer y, int incy, @Const FloatPointer sparam);
public static native void cublasSrotm(int n, FloatBuffer x, int incx, FloatBuffer y, int incy, @Const FloatBuffer sparam);
public static native void cublasSrotm(int n, float[] x, int incx, float[] y, int incy, @Const float[] sparam);
public static native void cublasDrotm(int n, DoublePointer x, int incx, DoublePointer y, int incy, @Const DoublePointer sparam);
public static native void cublasDrotm(int n, DoubleBuffer x, int incx, DoubleBuffer y, int incy, @Const DoubleBuffer sparam);
public static native void cublasDrotm(int n, double[] x, int incx, double[] y, int incy, @Const double[] sparam);
/*------------------------------------------------------------------------*/
/* ROTMG */
public static native void cublasSrotmg(FloatPointer sd1, FloatPointer sd2, FloatPointer sx1, @Const FloatPointer sy1, FloatPointer sparam);
public static native void cublasSrotmg(FloatBuffer sd1, FloatBuffer sd2, FloatBuffer sx1, @Const FloatBuffer sy1, FloatBuffer sparam);
public static native void cublasSrotmg(float[] sd1, float[] sd2, float[] sx1, @Const float[] sy1, float[] sparam);
public static native void cublasDrotmg(DoublePointer sd1, DoublePointer sd2, DoublePointer sx1, @Const DoublePointer sy1, DoublePointer sparam);
public static native void cublasDrotmg(DoubleBuffer sd1, DoubleBuffer sd2, DoubleBuffer sx1, @Const DoubleBuffer sy1, DoubleBuffer sparam);
public static native void cublasDrotmg(double[] sd1, double[] sd2, double[] sx1, @Const double[] sy1, double[] sparam);

/* --------------- CUBLAS BLAS2 functions  ---------------- */
/* GEMV */
public static native void cublasSgemv(@Cast("char") byte trans,
                              int m,
                              int n,
                              float alpha,
                              @Const FloatPointer A,
                              int lda,
                              @Const FloatPointer x,
                              int incx,
                              float beta,
                              FloatPointer y,
                              int incy);
public static native void cublasSgemv(@Cast("char") byte trans,
                              int m,
                              int n,
                              float alpha,
                              @Const FloatBuffer A,
                              int lda,
                              @Const FloatBuffer x,
                              int incx,
                              float beta,
                              FloatBuffer y,
                              int incy);
public static native void cublasSgemv(@Cast("char") byte trans,
                              int m,
                              int n,
                              float alpha,
                              @Const float[] A,
                              int lda,
                              @Const float[] x,
                              int incx,
                              float beta,
                              float[] y,
                              int incy);
public static native void cublasDgemv(@Cast("char") byte trans,
                              int m,
                              int n,
                              double alpha,
                              @Const DoublePointer A,
                              int lda,
                              @Const DoublePointer x,
                              int incx,
                              double beta,
                              DoublePointer y,
                              int incy);
public static native void cublasDgemv(@Cast("char") byte trans,
                              int m,
                              int n,
                              double alpha,
                              @Const DoubleBuffer A,
                              int lda,
                              @Const DoubleBuffer x,
                              int incx,
                              double beta,
                              DoubleBuffer y,
                              int incy);
public static native void cublasDgemv(@Cast("char") byte trans,
                              int m,
                              int n,
                              double alpha,
                              @Const double[] A,
                              int lda,
                              @Const double[] x,
                              int incx,
                              double beta,
                              double[] y,
                              int incy);
public static native void cublasCgemv(@Cast("char") byte trans,
                              int m,
                              int n,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("const cuComplex*") float2 x,
                              int incx,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 y,
                              int incy);
public static native void cublasZgemv(@Cast("char") byte trans,
                              int m,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 y,
                              int incy);
/*------------------------------------------------------------------------*/
/* GBMV */
public static native void cublasSgbmv(@Cast("char") byte trans,
                              int m,
                              int n,
                              int kl,
                              int ku,
                              float alpha,
                              @Const FloatPointer A,
                              int lda,
                              @Const FloatPointer x,
                              int incx,
                              float beta,
                              FloatPointer y,
                              int incy);
public static native void cublasSgbmv(@Cast("char") byte trans,
                              int m,
                              int n,
                              int kl,
                              int ku,
                              float alpha,
                              @Const FloatBuffer A,
                              int lda,
                              @Const FloatBuffer x,
                              int incx,
                              float beta,
                              FloatBuffer y,
                              int incy);
public static native void cublasSgbmv(@Cast("char") byte trans,
                              int m,
                              int n,
                              int kl,
                              int ku,
                              float alpha,
                              @Const float[] A,
                              int lda,
                              @Const float[] x,
                              int incx,
                              float beta,
                              float[] y,
                              int incy);
public static native void cublasDgbmv(@Cast("char") byte trans,
                              int m,
                              int n,
                              int kl,
                              int ku,
                              double alpha,
                              @Const DoublePointer A,
                              int lda,
                              @Const DoublePointer x,
                              int incx,
                              double beta,
                              DoublePointer y,
                              int incy);
public static native void cublasDgbmv(@Cast("char") byte trans,
                              int m,
                              int n,
                              int kl,
                              int ku,
                              double alpha,
                              @Const DoubleBuffer A,
                              int lda,
                              @Const DoubleBuffer x,
                              int incx,
                              double beta,
                              DoubleBuffer y,
                              int incy);
public static native void cublasDgbmv(@Cast("char") byte trans,
                              int m,
                              int n,
                              int kl,
                              int ku,
                              double alpha,
                              @Const double[] A,
                              int lda,
                              @Const double[] x,
                              int incx,
                              double beta,
                              double[] y,
                              int incy);
public static native void cublasCgbmv(@Cast("char") byte trans,
                              int m,
                              int n,
                              int kl,
                              int ku,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("const cuComplex*") float2 x,
                              int incx,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 y,
                              int incy);
public static native void cublasZgbmv(@Cast("char") byte trans,
                              int m,
                              int n,
                              int kl,
                              int ku,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 y,
                              int incy);
/*------------------------------------------------------------------------*/
/* TRMV */
public static native void cublasStrmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const FloatPointer A, int lda, FloatPointer x, int incx);
public static native void cublasStrmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const FloatBuffer A, int lda, FloatBuffer x, int incx);
public static native void cublasStrmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const float[] A, int lda, float[] x, int incx);
public static native void cublasDtrmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const DoublePointer A, int lda, DoublePointer x, int incx);
public static native void cublasDtrmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const DoubleBuffer A, int lda, DoubleBuffer x, int incx);
public static native void cublasDtrmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const double[] A, int lda, double[] x, int incx);
public static native void cublasCtrmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Cast("const cuComplex*") float2 A, int lda, @Cast("cuComplex*") float2 x, int incx);
public static native void cublasZtrmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Cast("const cuDoubleComplex*") double2 A, int lda, @Cast("cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* TBMV */
public static native void cublasStbmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const FloatPointer A, int lda, FloatPointer x, int incx);
public static native void cublasStbmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const FloatBuffer A, int lda, FloatBuffer x, int incx);
public static native void cublasStbmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const float[] A, int lda, float[] x, int incx);
public static native void cublasDtbmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const DoublePointer A, int lda, DoublePointer x, int incx);
public static native void cublasDtbmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const DoubleBuffer A, int lda, DoubleBuffer x, int incx);
public static native void cublasDtbmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const double[] A, int lda, double[] x, int incx);
public static native void cublasCtbmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Cast("const cuComplex*") float2 A, int lda, @Cast("cuComplex*") float2 x, int incx);
public static native void cublasZtbmv(
    @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Cast("const cuDoubleComplex*") double2 A, int lda, @Cast("cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* TPMV */
public static native void cublasStpmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const FloatPointer AP, FloatPointer x, int incx);
public static native void cublasStpmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const FloatBuffer AP, FloatBuffer x, int incx);
public static native void cublasStpmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const float[] AP, float[] x, int incx);

public static native void cublasDtpmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const DoublePointer AP, DoublePointer x, int incx);
public static native void cublasDtpmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const DoubleBuffer AP, DoubleBuffer x, int incx);
public static native void cublasDtpmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const double[] AP, double[] x, int incx);

public static native void cublasCtpmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Cast("const cuComplex*") float2 AP, @Cast("cuComplex*") float2 x, int incx);

public static native void cublasZtpmv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Cast("const cuDoubleComplex*") double2 AP, @Cast("cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* TRSV */
public static native void cublasStrsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const FloatPointer A, int lda, FloatPointer x, int incx);
public static native void cublasStrsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const FloatBuffer A, int lda, FloatBuffer x, int incx);
public static native void cublasStrsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const float[] A, int lda, float[] x, int incx);

public static native void cublasDtrsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const DoublePointer A, int lda, DoublePointer x, int incx);
public static native void cublasDtrsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const DoubleBuffer A, int lda, DoubleBuffer x, int incx);
public static native void cublasDtrsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const double[] A, int lda, double[] x, int incx);

public static native void cublasCtrsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Cast("const cuComplex*") float2 A, int lda, @Cast("cuComplex*") float2 x, int incx);

public static native void cublasZtrsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Cast("const cuDoubleComplex*") double2 A, int lda, @Cast("cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* TPSV */
public static native void cublasStpsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const FloatPointer AP, FloatPointer x, int incx);
public static native void cublasStpsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const FloatBuffer AP, FloatBuffer x, int incx);
public static native void cublasStpsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const float[] AP, float[] x, int incx);

public static native void cublasDtpsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const DoublePointer AP, DoublePointer x, int incx);
public static native void cublasDtpsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const DoubleBuffer AP, DoubleBuffer x, int incx);
public static native void cublasDtpsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Const double[] AP, double[] x, int incx);

public static native void cublasCtpsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Cast("const cuComplex*") float2 AP, @Cast("cuComplex*") float2 x, int incx);

public static native void cublasZtpsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, @Cast("const cuDoubleComplex*") double2 AP, @Cast("cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* TBSV */
public static native void cublasStbsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const FloatPointer A, int lda, FloatPointer x, int incx);
public static native void cublasStbsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const FloatBuffer A, int lda, FloatBuffer x, int incx);
public static native void cublasStbsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const float[] A, int lda, float[] x, int incx);

public static native void cublasDtbsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const DoublePointer A, int lda, DoublePointer x, int incx);
public static native void cublasDtbsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const DoubleBuffer A, int lda, DoubleBuffer x, int incx);
public static native void cublasDtbsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Const double[] A, int lda, double[] x, int incx);
public static native void cublasCtbsv(@Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Cast("const cuComplex*") float2 A, int lda, @Cast("cuComplex*") float2 x, int incx);

public static native void cublasZtbsv(
    @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag, int n, int k, @Cast("const cuDoubleComplex*") double2 A, int lda, @Cast("cuDoubleComplex*") double2 x, int incx);
/*------------------------------------------------------------------------*/
/* SYMV/HEMV */
public static native void cublasSsymv(
    @Cast("char") byte uplo, int n, float alpha, @Const FloatPointer A, int lda, @Const FloatPointer x, int incx, float beta, FloatPointer y, int incy);
public static native void cublasSsymv(
    @Cast("char") byte uplo, int n, float alpha, @Const FloatBuffer A, int lda, @Const FloatBuffer x, int incx, float beta, FloatBuffer y, int incy);
public static native void cublasSsymv(
    @Cast("char") byte uplo, int n, float alpha, @Const float[] A, int lda, @Const float[] x, int incx, float beta, float[] y, int incy);
public static native void cublasDsymv(@Cast("char") byte uplo,
                              int n,
                              double alpha,
                              @Const DoublePointer A,
                              int lda,
                              @Const DoublePointer x,
                              int incx,
                              double beta,
                              DoublePointer y,
                              int incy);
public static native void cublasDsymv(@Cast("char") byte uplo,
                              int n,
                              double alpha,
                              @Const DoubleBuffer A,
                              int lda,
                              @Const DoubleBuffer x,
                              int incx,
                              double beta,
                              DoubleBuffer y,
                              int incy);
public static native void cublasDsymv(@Cast("char") byte uplo,
                              int n,
                              double alpha,
                              @Const double[] A,
                              int lda,
                              @Const double[] x,
                              int incx,
                              double beta,
                              double[] y,
                              int incy);
public static native void cublasChemv(@Cast("char") byte uplo,
                              int n,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("const cuComplex*") float2 x,
                              int incx,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 y,
                              int incy);
public static native void cublasZhemv(@Cast("char") byte uplo,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 y,
                              int incy);
/*------------------------------------------------------------------------*/
/* SBMV/HBMV */
public static native void cublasSsbmv(@Cast("char") byte uplo,
                              int n,
                              int k,
                              float alpha,
                              @Const FloatPointer A,
                              int lda,
                              @Const FloatPointer x,
                              int incx,
                              float beta,
                              FloatPointer y,
                              int incy);
public static native void cublasSsbmv(@Cast("char") byte uplo,
                              int n,
                              int k,
                              float alpha,
                              @Const FloatBuffer A,
                              int lda,
                              @Const FloatBuffer x,
                              int incx,
                              float beta,
                              FloatBuffer y,
                              int incy);
public static native void cublasSsbmv(@Cast("char") byte uplo,
                              int n,
                              int k,
                              float alpha,
                              @Const float[] A,
                              int lda,
                              @Const float[] x,
                              int incx,
                              float beta,
                              float[] y,
                              int incy);
public static native void cublasDsbmv(@Cast("char") byte uplo,
                              int n,
                              int k,
                              double alpha,
                              @Const DoublePointer A,
                              int lda,
                              @Const DoublePointer x,
                              int incx,
                              double beta,
                              DoublePointer y,
                              int incy);
public static native void cublasDsbmv(@Cast("char") byte uplo,
                              int n,
                              int k,
                              double alpha,
                              @Const DoubleBuffer A,
                              int lda,
                              @Const DoubleBuffer x,
                              int incx,
                              double beta,
                              DoubleBuffer y,
                              int incy);
public static native void cublasDsbmv(@Cast("char") byte uplo,
                              int n,
                              int k,
                              double alpha,
                              @Const double[] A,
                              int lda,
                              @Const double[] x,
                              int incx,
                              double beta,
                              double[] y,
                              int incy);
public static native void cublasChbmv(@Cast("char") byte uplo,
                              int n,
                              int k,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("const cuComplex*") float2 x,
                              int incx,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 y,
                              int incy);
public static native void cublasZhbmv(@Cast("char") byte uplo,
                              int n,
                              int k,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 y,
                              int incy);
/*------------------------------------------------------------------------*/
/* SPMV/HPMV */
public static native void cublasSspmv(@Cast("char") byte uplo, int n, float alpha, @Const FloatPointer AP, @Const FloatPointer x, int incx, float beta, FloatPointer y, int incy);
public static native void cublasSspmv(@Cast("char") byte uplo, int n, float alpha, @Const FloatBuffer AP, @Const FloatBuffer x, int incx, float beta, FloatBuffer y, int incy);
public static native void cublasSspmv(@Cast("char") byte uplo, int n, float alpha, @Const float[] AP, @Const float[] x, int incx, float beta, float[] y, int incy);
public static native void cublasDspmv(
    @Cast("char") byte uplo, int n, double alpha, @Const DoublePointer AP, @Const DoublePointer x, int incx, double beta, DoublePointer y, int incy);
public static native void cublasDspmv(
    @Cast("char") byte uplo, int n, double alpha, @Const DoubleBuffer AP, @Const DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy);
public static native void cublasDspmv(
    @Cast("char") byte uplo, int n, double alpha, @Const double[] AP, @Const double[] x, int incx, double beta, double[] y, int incy);
public static native void cublasChpmv(@Cast("char") byte uplo,
                              int n,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 AP,
                              @Cast("const cuComplex*") float2 x,
                              int incx,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 y,
                              int incy);
public static native void cublasZhpmv(@Cast("char") byte uplo,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 AP,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 y,
                              int incy);

/*------------------------------------------------------------------------*/
/* GER */
public static native void cublasSger(int m, int n, float alpha, @Const FloatPointer x, int incx, @Const FloatPointer y, int incy, FloatPointer A, int lda);
public static native void cublasSger(int m, int n, float alpha, @Const FloatBuffer x, int incx, @Const FloatBuffer y, int incy, FloatBuffer A, int lda);
public static native void cublasSger(int m, int n, float alpha, @Const float[] x, int incx, @Const float[] y, int incy, float[] A, int lda);
public static native void cublasDger(int m, int n, double alpha, @Const DoublePointer x, int incx, @Const DoublePointer y, int incy, DoublePointer A, int lda);
public static native void cublasDger(int m, int n, double alpha, @Const DoubleBuffer x, int incx, @Const DoubleBuffer y, int incy, DoubleBuffer A, int lda);
public static native void cublasDger(int m, int n, double alpha, @Const double[] x, int incx, @Const double[] y, int incy, double[] A, int lda);

public static native void cublasCgeru(
    int m, int n, @ByVal @Cast("cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 x, int incx, @Cast("const cuComplex*") float2 y, int incy, @Cast("cuComplex*") float2 A, int lda);
public static native void cublasCgerc(
    int m, int n, @ByVal @Cast("cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 x, int incx, @Cast("const cuComplex*") float2 y, int incy, @Cast("cuComplex*") float2 A, int lda);
public static native void cublasZgeru(int m,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @Cast("const cuDoubleComplex*") double2 y,
                              int incy,
                              @Cast("cuDoubleComplex*") double2 A,
                              int lda);
public static native void cublasZgerc(int m,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @Cast("const cuDoubleComplex*") double2 y,
                              int incy,
                              @Cast("cuDoubleComplex*") double2 A,
                              int lda);
/*------------------------------------------------------------------------*/
/* SYR/HER */
public static native void cublasSsyr(@Cast("char") byte uplo, int n, float alpha, @Const FloatPointer x, int incx, FloatPointer A, int lda);
public static native void cublasSsyr(@Cast("char") byte uplo, int n, float alpha, @Const FloatBuffer x, int incx, FloatBuffer A, int lda);
public static native void cublasSsyr(@Cast("char") byte uplo, int n, float alpha, @Const float[] x, int incx, float[] A, int lda);
public static native void cublasDsyr(@Cast("char") byte uplo, int n, double alpha, @Const DoublePointer x, int incx, DoublePointer A, int lda);
public static native void cublasDsyr(@Cast("char") byte uplo, int n, double alpha, @Const DoubleBuffer x, int incx, DoubleBuffer A, int lda);
public static native void cublasDsyr(@Cast("char") byte uplo, int n, double alpha, @Const double[] x, int incx, double[] A, int lda);

public static native void cublasCher(@Cast("char") byte uplo, int n, float alpha, @Cast("const cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 A, int lda);
public static native void cublasZher(@Cast("char") byte uplo, int n, double alpha, @Cast("const cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 A, int lda);

/*------------------------------------------------------------------------*/
/* SPR/HPR */
public static native void cublasSspr(@Cast("char") byte uplo, int n, float alpha, @Const FloatPointer x, int incx, FloatPointer AP);
public static native void cublasSspr(@Cast("char") byte uplo, int n, float alpha, @Const FloatBuffer x, int incx, FloatBuffer AP);
public static native void cublasSspr(@Cast("char") byte uplo, int n, float alpha, @Const float[] x, int incx, float[] AP);
public static native void cublasDspr(@Cast("char") byte uplo, int n, double alpha, @Const DoublePointer x, int incx, DoublePointer AP);
public static native void cublasDspr(@Cast("char") byte uplo, int n, double alpha, @Const DoubleBuffer x, int incx, DoubleBuffer AP);
public static native void cublasDspr(@Cast("char") byte uplo, int n, double alpha, @Const double[] x, int incx, double[] AP);
public static native void cublasChpr(@Cast("char") byte uplo, int n, float alpha, @Cast("const cuComplex*") float2 x, int incx, @Cast("cuComplex*") float2 AP);
public static native void cublasZhpr(@Cast("char") byte uplo, int n, double alpha, @Cast("const cuDoubleComplex*") double2 x, int incx, @Cast("cuDoubleComplex*") double2 AP);
/*------------------------------------------------------------------------*/
/* SYR2/HER2 */
public static native void cublasSsyr2(@Cast("char") byte uplo, int n, float alpha, @Const FloatPointer x, int incx, @Const FloatPointer y, int incy, FloatPointer A, int lda);
public static native void cublasSsyr2(@Cast("char") byte uplo, int n, float alpha, @Const FloatBuffer x, int incx, @Const FloatBuffer y, int incy, FloatBuffer A, int lda);
public static native void cublasSsyr2(@Cast("char") byte uplo, int n, float alpha, @Const float[] x, int incx, @Const float[] y, int incy, float[] A, int lda);
public static native void cublasDsyr2(@Cast("char") byte uplo, int n, double alpha, @Const DoublePointer x, int incx, @Const DoublePointer y, int incy, DoublePointer A, int lda);
public static native void cublasDsyr2(@Cast("char") byte uplo, int n, double alpha, @Const DoubleBuffer x, int incx, @Const DoubleBuffer y, int incy, DoubleBuffer A, int lda);
public static native void cublasDsyr2(@Cast("char") byte uplo, int n, double alpha, @Const double[] x, int incx, @Const double[] y, int incy, double[] A, int lda);
public static native void cublasCher2(@Cast("char") byte uplo,
                              int n,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 x,
                              int incx,
                              @Cast("const cuComplex*") float2 y,
                              int incy,
                              @Cast("cuComplex*") float2 A,
                              int lda);
public static native void cublasZher2(@Cast("char") byte uplo,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @Cast("const cuDoubleComplex*") double2 y,
                              int incy,
                              @Cast("cuDoubleComplex*") double2 A,
                              int lda);

/*------------------------------------------------------------------------*/
/* SPR2/HPR2 */
public static native void cublasSspr2(@Cast("char") byte uplo, int n, float alpha, @Const FloatPointer x, int incx, @Const FloatPointer y, int incy, FloatPointer AP);
public static native void cublasSspr2(@Cast("char") byte uplo, int n, float alpha, @Const FloatBuffer x, int incx, @Const FloatBuffer y, int incy, FloatBuffer AP);
public static native void cublasSspr2(@Cast("char") byte uplo, int n, float alpha, @Const float[] x, int incx, @Const float[] y, int incy, float[] AP);
public static native void cublasDspr2(@Cast("char") byte uplo, int n, double alpha, @Const DoublePointer x, int incx, @Const DoublePointer y, int incy, DoublePointer AP);
public static native void cublasDspr2(@Cast("char") byte uplo, int n, double alpha, @Const DoubleBuffer x, int incx, @Const DoubleBuffer y, int incy, DoubleBuffer AP);
public static native void cublasDspr2(@Cast("char") byte uplo, int n, double alpha, @Const double[] x, int incx, @Const double[] y, int incy, double[] AP);
public static native void cublasChpr2(
    @Cast("char") byte uplo, int n, @ByVal @Cast("cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 x, int incx, @Cast("const cuComplex*") float2 y, int incy, @Cast("cuComplex*") float2 AP);
public static native void cublasZhpr2(@Cast("char") byte uplo,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 x,
                              int incx,
                              @Cast("const cuDoubleComplex*") double2 y,
                              int incy,
                              @Cast("cuDoubleComplex*") double2 AP);
/* ------------------------BLAS3 Functions ------------------------------- */
/* GEMM */
public static native void cublasSgemm(@Cast("char") byte transa,
                              @Cast("char") byte transb,
                              int m,
                              int n,
                              int k,
                              float alpha,
                              @Const FloatPointer A,
                              int lda,
                              @Const FloatPointer B,
                              int ldb,
                              float beta,
                              FloatPointer C,
                              int ldc);
public static native void cublasSgemm(@Cast("char") byte transa,
                              @Cast("char") byte transb,
                              int m,
                              int n,
                              int k,
                              float alpha,
                              @Const FloatBuffer A,
                              int lda,
                              @Const FloatBuffer B,
                              int ldb,
                              float beta,
                              FloatBuffer C,
                              int ldc);
public static native void cublasSgemm(@Cast("char") byte transa,
                              @Cast("char") byte transb,
                              int m,
                              int n,
                              int k,
                              float alpha,
                              @Const float[] A,
                              int lda,
                              @Const float[] B,
                              int ldb,
                              float beta,
                              float[] C,
                              int ldc);
public static native void cublasDgemm(@Cast("char") byte transa,
                              @Cast("char") byte transb,
                              int m,
                              int n,
                              int k,
                              double alpha,
                              @Const DoublePointer A,
                              int lda,
                              @Const DoublePointer B,
                              int ldb,
                              double beta,
                              DoublePointer C,
                              int ldc);
public static native void cublasDgemm(@Cast("char") byte transa,
                              @Cast("char") byte transb,
                              int m,
                              int n,
                              int k,
                              double alpha,
                              @Const DoubleBuffer A,
                              int lda,
                              @Const DoubleBuffer B,
                              int ldb,
                              double beta,
                              DoubleBuffer C,
                              int ldc);
public static native void cublasDgemm(@Cast("char") byte transa,
                              @Cast("char") byte transb,
                              int m,
                              int n,
                              int k,
                              double alpha,
                              @Const double[] A,
                              int lda,
                              @Const double[] B,
                              int ldb,
                              double beta,
                              double[] C,
                              int ldc);
public static native void cublasCgemm(@Cast("char") byte transa,
                              @Cast("char") byte transb,
                              int m,
                              int n,
                              int k,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("const cuComplex*") float2 B,
                              int ldb,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 C,
                              int ldc);
public static native void cublasZgemm(@Cast("char") byte transa,
                              @Cast("char") byte transb,
                              int m,
                              int n,
                              int k,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("const cuDoubleComplex*") double2 B,
                              int ldb,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 C,
                              int ldc);
/* -------------------------------------------------------*/
/* SYRK */
public static native void cublasSsyrk(@Cast("char") byte uplo, @Cast("char") byte trans, int n, int k, float alpha, @Const FloatPointer A, int lda, float beta, FloatPointer C, int ldc);
public static native void cublasSsyrk(@Cast("char") byte uplo, @Cast("char") byte trans, int n, int k, float alpha, @Const FloatBuffer A, int lda, float beta, FloatBuffer C, int ldc);
public static native void cublasSsyrk(@Cast("char") byte uplo, @Cast("char") byte trans, int n, int k, float alpha, @Const float[] A, int lda, float beta, float[] C, int ldc);
public static native void cublasDsyrk(
    @Cast("char") byte uplo, @Cast("char") byte trans, int n, int k, double alpha, @Const DoublePointer A, int lda, double beta, DoublePointer C, int ldc);
public static native void cublasDsyrk(
    @Cast("char") byte uplo, @Cast("char") byte trans, int n, int k, double alpha, @Const DoubleBuffer A, int lda, double beta, DoubleBuffer C, int ldc);
public static native void cublasDsyrk(
    @Cast("char") byte uplo, @Cast("char") byte trans, int n, int k, double alpha, @Const double[] A, int lda, double beta, double[] C, int ldc);

public static native void cublasCsyrk(@Cast("char") byte uplo,
                              @Cast("char") byte trans,
                              int n,
                              int k,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 C,
                              int ldc);
public static native void cublasZsyrk(@Cast("char") byte uplo,
                              @Cast("char") byte trans,
                              int n,
                              int k,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 C,
                              int ldc);
/* ------------------------------------------------------- */
/* HERK */
public static native void cublasCherk(
    @Cast("char") byte uplo, @Cast("char") byte trans, int n, int k, float alpha, @Cast("const cuComplex*") float2 A, int lda, float beta, @Cast("cuComplex*") float2 C, int ldc);
public static native void cublasZherk(@Cast("char") byte uplo,
                              @Cast("char") byte trans,
                              int n,
                              int k,
                              double alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              double beta,
                              @Cast("cuDoubleComplex*") double2 C,
                              int ldc);
/* ------------------------------------------------------- */
/* SYR2K */
public static native void cublasSsyr2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               float alpha,
                               @Const FloatPointer A,
                               int lda,
                               @Const FloatPointer B,
                               int ldb,
                               float beta,
                               FloatPointer C,
                               int ldc);
public static native void cublasSsyr2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               float alpha,
                               @Const FloatBuffer A,
                               int lda,
                               @Const FloatBuffer B,
                               int ldb,
                               float beta,
                               FloatBuffer C,
                               int ldc);
public static native void cublasSsyr2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               float alpha,
                               @Const float[] A,
                               int lda,
                               @Const float[] B,
                               int ldb,
                               float beta,
                               float[] C,
                               int ldc);

public static native void cublasDsyr2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               double alpha,
                               @Const DoublePointer A,
                               int lda,
                               @Const DoublePointer B,
                               int ldb,
                               double beta,
                               DoublePointer C,
                               int ldc);
public static native void cublasDsyr2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               double alpha,
                               @Const DoubleBuffer A,
                               int lda,
                               @Const DoubleBuffer B,
                               int ldb,
                               double beta,
                               DoubleBuffer C,
                               int ldc);
public static native void cublasDsyr2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               double alpha,
                               @Const double[] A,
                               int lda,
                               @Const double[] B,
                               int ldb,
                               double beta,
                               double[] C,
                               int ldc);
public static native void cublasCsyr2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               @ByVal @Cast("cuComplex*") float2 alpha,
                               @Cast("const cuComplex*") float2 A,
                               int lda,
                               @Cast("const cuComplex*") float2 B,
                               int ldb,
                               @ByVal @Cast("cuComplex*") float2 beta,
                               @Cast("cuComplex*") float2 C,
                               int ldc);

public static native void cublasZsyr2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                               @Cast("const cuDoubleComplex*") double2 A,
                               int lda,
                               @Cast("const cuDoubleComplex*") double2 B,
                               int ldb,
                               @ByVal @Cast("cuDoubleComplex*") double2 beta,
                               @Cast("cuDoubleComplex*") double2 C,
                               int ldc);
/* ------------------------------------------------------- */
/* HER2K */
public static native void cublasCher2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               @ByVal @Cast("cuComplex*") float2 alpha,
                               @Cast("const cuComplex*") float2 A,
                               int lda,
                               @Cast("const cuComplex*") float2 B,
                               int ldb,
                               float beta,
                               @Cast("cuComplex*") float2 C,
                               int ldc);

public static native void cublasZher2k(@Cast("char") byte uplo,
                               @Cast("char") byte trans,
                               int n,
                               int k,
                               @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                               @Cast("const cuDoubleComplex*") double2 A,
                               int lda,
                               @Cast("const cuDoubleComplex*") double2 B,
                               int ldb,
                               double beta,
                               @Cast("cuDoubleComplex*") double2 C,
                               int ldc);

/*------------------------------------------------------------------------*/
/* SYMM*/
public static native void cublasSsymm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              float alpha,
                              @Const FloatPointer A,
                              int lda,
                              @Const FloatPointer B,
                              int ldb,
                              float beta,
                              FloatPointer C,
                              int ldc);
public static native void cublasSsymm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              float alpha,
                              @Const FloatBuffer A,
                              int lda,
                              @Const FloatBuffer B,
                              int ldb,
                              float beta,
                              FloatBuffer C,
                              int ldc);
public static native void cublasSsymm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              float alpha,
                              @Const float[] A,
                              int lda,
                              @Const float[] B,
                              int ldb,
                              float beta,
                              float[] C,
                              int ldc);
public static native void cublasDsymm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              double alpha,
                              @Const DoublePointer A,
                              int lda,
                              @Const DoublePointer B,
                              int ldb,
                              double beta,
                              DoublePointer C,
                              int ldc);
public static native void cublasDsymm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              double alpha,
                              @Const DoubleBuffer A,
                              int lda,
                              @Const DoubleBuffer B,
                              int ldb,
                              double beta,
                              DoubleBuffer C,
                              int ldc);
public static native void cublasDsymm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              double alpha,
                              @Const double[] A,
                              int lda,
                              @Const double[] B,
                              int ldb,
                              double beta,
                              double[] C,
                              int ldc);

public static native void cublasCsymm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("const cuComplex*") float2 B,
                              int ldb,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 C,
                              int ldc);

public static native void cublasZsymm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("const cuDoubleComplex*") double2 B,
                              int ldb,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 C,
                              int ldc);
/*------------------------------------------------------------------------*/
/* HEMM*/
public static native void cublasChemm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("const cuComplex*") float2 B,
                              int ldb,
                              @ByVal @Cast("cuComplex*") float2 beta,
                              @Cast("cuComplex*") float2 C,
                              int ldc);
public static native void cublasZhemm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              int m,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("const cuDoubleComplex*") double2 B,
                              int ldb,
                              @ByVal @Cast("cuDoubleComplex*") double2 beta,
                              @Cast("cuDoubleComplex*") double2 C,
                              int ldc);

/*------------------------------------------------------------------------*/
/* TRSM*/
public static native void cublasStrsm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              float alpha,
                              @Const FloatPointer A,
                              int lda,
                              FloatPointer B,
                              int ldb);
public static native void cublasStrsm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              float alpha,
                              @Const FloatBuffer A,
                              int lda,
                              FloatBuffer B,
                              int ldb);
public static native void cublasStrsm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              float alpha,
                              @Const float[] A,
                              int lda,
                              float[] B,
                              int ldb);

public static native void cublasDtrsm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              double alpha,
                              @Const DoublePointer A,
                              int lda,
                              DoublePointer B,
                              int ldb);
public static native void cublasDtrsm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              double alpha,
                              @Const DoubleBuffer A,
                              int lda,
                              DoubleBuffer B,
                              int ldb);
public static native void cublasDtrsm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              double alpha,
                              @Const double[] A,
                              int lda,
                              double[] B,
                              int ldb);

public static native void cublasCtrsm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("cuComplex*") float2 B,
                              int ldb);

public static native void cublasZtrsm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("cuDoubleComplex*") double2 B,
                              int ldb);
/*------------------------------------------------------------------------*/
/* TRMM*/
public static native void cublasStrmm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              float alpha,
                              @Const FloatPointer A,
                              int lda,
                              FloatPointer B,
                              int ldb);
public static native void cublasStrmm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              float alpha,
                              @Const FloatBuffer A,
                              int lda,
                              FloatBuffer B,
                              int ldb);
public static native void cublasStrmm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              float alpha,
                              @Const float[] A,
                              int lda,
                              float[] B,
                              int ldb);
public static native void cublasDtrmm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              double alpha,
                              @Const DoublePointer A,
                              int lda,
                              DoublePointer B,
                              int ldb);
public static native void cublasDtrmm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              double alpha,
                              @Const DoubleBuffer A,
                              int lda,
                              DoubleBuffer B,
                              int ldb);
public static native void cublasDtrmm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              double alpha,
                              @Const double[] A,
                              int lda,
                              double[] B,
                              int ldb);
public static native void cublasCtrmm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              @ByVal @Cast("cuComplex*") float2 alpha,
                              @Cast("const cuComplex*") float2 A,
                              int lda,
                              @Cast("cuComplex*") float2 B,
                              int ldb);
public static native void cublasZtrmm(@Cast("char") byte side,
                              @Cast("char") byte uplo,
                              @Cast("char") byte transa,
                              @Cast("char") byte diag,
                              int m,
                              int n,
                              @ByVal @Cast("cuDoubleComplex*") double2 alpha,
                              @Cast("const cuDoubleComplex*") double2 A,
                              int lda,
                              @Cast("cuDoubleComplex*") double2 B,
                              int ldb);

// #if defined(__cplusplus)
// #endif /* __cplusplus */

// #endif /* !defined(CUBLAS_H_) */


// Parsed from <cublasLt.h>

/*
 * Copyright 1993-2022 NVIDIA Corporation. All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */
// #pragma once

// #ifndef CUBLASAPI
// #ifdef __CUDACC__
// #define CUBLASAPI __host__ __device__
// #else
// #define CUBLASAPI
// #endif
// #endif

// #include <cublas_api.h>

// #include <stdint.h>
// #include <stddef.h>
// #include <stdio.h>

// #if defined(__cplusplus)
// Targeting ..\cublas\cublasLtContext.java



public static native @Cast("cublasStatus_t") int cublasLtCreate(@ByPtrPtr cublasLtContext lightHandle);

public static native @Cast("cublasStatus_t") int cublasLtDestroy(cublasLtContext lightHandle);

public static native @Cast("const char*") BytePointer cublasLtGetStatusName(@Cast("cublasStatus_t") int status);

public static native @Cast("const char*") BytePointer cublasLtGetStatusString(@Cast("cublasStatus_t") int status);

public static native @Cast("size_t") long cublasLtGetVersion();

public static native @Cast("size_t") long cublasLtGetCudartVersion();

public static native @Cast("cublasStatus_t") int cublasLtGetProperty(@Cast("libraryPropertyType") int type, IntPointer value);
public static native @Cast("cublasStatus_t") int cublasLtGetProperty(@Cast("libraryPropertyType") int type, IntBuffer value);
public static native @Cast("cublasStatus_t") int cublasLtGetProperty(@Cast("libraryPropertyType") int type, int[] value);

public static native @Cast("cublasStatus_t") int cublasLtHeuristicsCacheGetCapacity(@Cast("size_t*") SizeTPointer _capacity);
public static native @Cast("cublasStatus_t") int cublasLtHeuristicsCacheSetCapacity(@Cast("size_t") long _capacity);

/** Restricts usage of CPU instructions (ISA) specified by the flags in the mask.
 *
 * Flags can be combined with bitwise OR(|) operator. Supported flags:
 * - 0x1 -- x86-64 AVX512 ISA
 *
 * Default mask: 0 (any applicable ISA is allowed).
 *
 * The function returns the previous value of the mask.
 * The function takes precedence over the environment variable CUBLASLT_DISABLE_CPU_INSTRUCTIONS_MASK.
 */

// Targeting ..\cublas\cublasLtMatrixLayoutOpaque_t.java



/** Opaque descriptor for matrix memory layout
 */
// Targeting ..\cublas\cublasLtMatmulAlgo_t.java


// Targeting ..\cublas\cublasLtMatmulDescOpaque_t.java



/** Opaque descriptor for cublasLtMatmul() operation details
 */
// Targeting ..\cublas\cublasLtMatrixTransformDescOpaque_t.java



/** Opaque descriptor for cublasLtMatrixTransform() operation details
 */
// Targeting ..\cublas\cublasLtMatmulPreferenceOpaque_t.java



/** Opaque descriptor for cublasLtMatmulAlgoGetHeuristic() configuration
 */

/** Tile size (in C/D matrix Rows x Cols)
 *
 * General order of tile IDs is sorted by size first and by first dimension second.
 */
/** enum cublasLtMatmulTile_t */
public static final int
  CUBLASLT_MATMUL_TILE_UNDEFINED = 0,
  CUBLASLT_MATMUL_TILE_8x8 = 1,
  CUBLASLT_MATMUL_TILE_8x16 = 2,
  CUBLASLT_MATMUL_TILE_16x8 = 3,
  CUBLASLT_MATMUL_TILE_8x32 = 4,
  CUBLASLT_MATMUL_TILE_16x16 = 5,
  CUBLASLT_MATMUL_TILE_32x8 = 6,
  CUBLASLT_MATMUL_TILE_8x64 = 7,
  CUBLASLT_MATMUL_TILE_16x32 = 8,
  CUBLASLT_MATMUL_TILE_32x16 = 9,
  CUBLASLT_MATMUL_TILE_64x8 = 10,
  CUBLASLT_MATMUL_TILE_32x32 = 11,
  CUBLASLT_MATMUL_TILE_32x64 = 12,
  CUBLASLT_MATMUL_TILE_64x32 = 13,
  CUBLASLT_MATMUL_TILE_32x128 = 14,
  CUBLASLT_MATMUL_TILE_64x64 = 15,
  CUBLASLT_MATMUL_TILE_128x32 = 16,
  CUBLASLT_MATMUL_TILE_64x128 = 17,
  CUBLASLT_MATMUL_TILE_128x64 = 18,
  CUBLASLT_MATMUL_TILE_64x256 = 19,
  CUBLASLT_MATMUL_TILE_128x128 = 20,
  CUBLASLT_MATMUL_TILE_256x64 = 21,
  CUBLASLT_MATMUL_TILE_64x512 = 22,
  CUBLASLT_MATMUL_TILE_128x256 = 23,
  CUBLASLT_MATMUL_TILE_256x128 = 24,
  CUBLASLT_MATMUL_TILE_512x64 = 25,
  CUBLASLT_MATMUL_TILE_64x96 = 26,
  CUBLASLT_MATMUL_TILE_96x64 = 27,
  CUBLASLT_MATMUL_TILE_96x128 = 28,
  CUBLASLT_MATMUL_TILE_128x160 = 29,
  CUBLASLT_MATMUL_TILE_160x128 = 30,
  CUBLASLT_MATMUL_TILE_192x128 = 31,
  CUBLASLT_MATMUL_TILE_128x192 = 32,
  CUBLASLT_MATMUL_TILE_128x96 = 33,
  CUBLASLT_MATMUL_TILE_32x256 = 34,
  CUBLASLT_MATMUL_TILE_256x32 = 35,
  CUBLASLT_MATMUL_TILE_8x128 = 36,
  CUBLASLT_MATMUL_TILE_8x192 = 37,
  CUBLASLT_MATMUL_TILE_8x256 = 38,
  CUBLASLT_MATMUL_TILE_8x320 = 39,
  CUBLASLT_MATMUL_TILE_8x384 = 40,
  CUBLASLT_MATMUL_TILE_8x448 = 41,
  CUBLASLT_MATMUL_TILE_8x512 = 42,
  CUBLASLT_MATMUL_TILE_8x576 = 43,
  CUBLASLT_MATMUL_TILE_8x640 = 44,
  CUBLASLT_MATMUL_TILE_8x704 = 45,
  CUBLASLT_MATMUL_TILE_8x768 = 46,
  CUBLASLT_MATMUL_TILE_16x64 = 47,
  CUBLASLT_MATMUL_TILE_16x128 = 48,
  CUBLASLT_MATMUL_TILE_16x192 = 49,
  CUBLASLT_MATMUL_TILE_16x256 = 50,
  CUBLASLT_MATMUL_TILE_16x320 = 51,
  CUBLASLT_MATMUL_TILE_16x384 = 52,
  CUBLASLT_MATMUL_TILE_16x448 = 53,
  CUBLASLT_MATMUL_TILE_16x512 = 54,
  CUBLASLT_MATMUL_TILE_16x576 = 55,
  CUBLASLT_MATMUL_TILE_16x640 = 56,
  CUBLASLT_MATMUL_TILE_16x704 = 57,
  CUBLASLT_MATMUL_TILE_16x768 = 58,
  CUBLASLT_MATMUL_TILE_24x64 = 59,
  CUBLASLT_MATMUL_TILE_24x128 = 60,
  CUBLASLT_MATMUL_TILE_24x192 = 61,
  CUBLASLT_MATMUL_TILE_24x256 = 62,
  CUBLASLT_MATMUL_TILE_24x320 = 63,
  CUBLASLT_MATMUL_TILE_24x384 = 64,
  CUBLASLT_MATMUL_TILE_24x448 = 65,
  CUBLASLT_MATMUL_TILE_24x512 = 66,
  CUBLASLT_MATMUL_TILE_24x576 = 67,
  CUBLASLT_MATMUL_TILE_24x640 = 68,
  CUBLASLT_MATMUL_TILE_24x704 = 69,
  CUBLASLT_MATMUL_TILE_24x768 = 70,
  CUBLASLT_MATMUL_TILE_32x192 = 71,
  CUBLASLT_MATMUL_TILE_32x320 = 72,
  CUBLASLT_MATMUL_TILE_32x384 = 73,
  CUBLASLT_MATMUL_TILE_32x448 = 74,
  CUBLASLT_MATMUL_TILE_32x512 = 75,
  CUBLASLT_MATMUL_TILE_32x576 = 76,
  CUBLASLT_MATMUL_TILE_32x640 = 77,
  CUBLASLT_MATMUL_TILE_32x704 = 78,
  CUBLASLT_MATMUL_TILE_32x768 = 79,
  CUBLASLT_MATMUL_TILE_40x64 = 80,
  CUBLASLT_MATMUL_TILE_40x128 = 81,
  CUBLASLT_MATMUL_TILE_40x192 = 82,
  CUBLASLT_MATMUL_TILE_40x256 = 83,
  CUBLASLT_MATMUL_TILE_40x320 = 84,
  CUBLASLT_MATMUL_TILE_40x384 = 85,
  CUBLASLT_MATMUL_TILE_40x448 = 86,
  CUBLASLT_MATMUL_TILE_40x512 = 87,
  CUBLASLT_MATMUL_TILE_40x576 = 88,
  CUBLASLT_MATMUL_TILE_40x640 = 89,
  CUBLASLT_MATMUL_TILE_40x704 = 90,
  CUBLASLT_MATMUL_TILE_40x768 = 91,
  CUBLASLT_MATMUL_TILE_48x64 = 92,
  CUBLASLT_MATMUL_TILE_48x128 = 93,
  CUBLASLT_MATMUL_TILE_48x192 = 94,
  CUBLASLT_MATMUL_TILE_48x256 = 95,
  CUBLASLT_MATMUL_TILE_48x320 = 96,
  CUBLASLT_MATMUL_TILE_48x384 = 97,
  CUBLASLT_MATMUL_TILE_48x448 = 98,
  CUBLASLT_MATMUL_TILE_48x512 = 99,
  CUBLASLT_MATMUL_TILE_48x576 = 100,
  CUBLASLT_MATMUL_TILE_48x640 = 101,
  CUBLASLT_MATMUL_TILE_48x704 = 102,
  CUBLASLT_MATMUL_TILE_48x768 = 103,
  CUBLASLT_MATMUL_TILE_56x64 = 104,
  CUBLASLT_MATMUL_TILE_56x128 = 105,
  CUBLASLT_MATMUL_TILE_56x192 = 106,
  CUBLASLT_MATMUL_TILE_56x256 = 107,
  CUBLASLT_MATMUL_TILE_56x320 = 108,
  CUBLASLT_MATMUL_TILE_56x384 = 109,
  CUBLASLT_MATMUL_TILE_56x448 = 110,
  CUBLASLT_MATMUL_TILE_56x512 = 111,
  CUBLASLT_MATMUL_TILE_56x576 = 112,
  CUBLASLT_MATMUL_TILE_56x640 = 113,
  CUBLASLT_MATMUL_TILE_56x704 = 114,
  CUBLASLT_MATMUL_TILE_56x768 = 115,
  CUBLASLT_MATMUL_TILE_64x192 = 116,
  CUBLASLT_MATMUL_TILE_64x320 = 117,
  CUBLASLT_MATMUL_TILE_64x384 = 118,
  CUBLASLT_MATMUL_TILE_64x448 = 119,
  CUBLASLT_MATMUL_TILE_64x576 = 120,
  CUBLASLT_MATMUL_TILE_64x640 = 121,
  CUBLASLT_MATMUL_TILE_64x704 = 122,
  CUBLASLT_MATMUL_TILE_64x768 = 123,
  CUBLASLT_MATMUL_TILE_72x64 = 124,
  CUBLASLT_MATMUL_TILE_72x128 = 125,
  CUBLASLT_MATMUL_TILE_72x192 = 126,
  CUBLASLT_MATMUL_TILE_72x256 = 127,
  CUBLASLT_MATMUL_TILE_72x320 = 128,
  CUBLASLT_MATMUL_TILE_72x384 = 129,
  CUBLASLT_MATMUL_TILE_72x448 = 130,
  CUBLASLT_MATMUL_TILE_72x512 = 131,
  CUBLASLT_MATMUL_TILE_72x576 = 132,
  CUBLASLT_MATMUL_TILE_72x640 = 133,
  CUBLASLT_MATMUL_TILE_80x64 = 134,
  CUBLASLT_MATMUL_TILE_80x128 = 135,
  CUBLASLT_MATMUL_TILE_80x192 = 136,
  CUBLASLT_MATMUL_TILE_80x256 = 137,
  CUBLASLT_MATMUL_TILE_80x320 = 138,
  CUBLASLT_MATMUL_TILE_80x384 = 139,
  CUBLASLT_MATMUL_TILE_80x448 = 140,
  CUBLASLT_MATMUL_TILE_80x512 = 141,
  CUBLASLT_MATMUL_TILE_80x576 = 142,
  CUBLASLT_MATMUL_TILE_88x64 = 143,
  CUBLASLT_MATMUL_TILE_88x128 = 144,
  CUBLASLT_MATMUL_TILE_88x192 = 145,
  CUBLASLT_MATMUL_TILE_88x256 = 146,
  CUBLASLT_MATMUL_TILE_88x320 = 147,
  CUBLASLT_MATMUL_TILE_88x384 = 148,
  CUBLASLT_MATMUL_TILE_88x448 = 149,
  CUBLASLT_MATMUL_TILE_88x512 = 150,
  CUBLASLT_MATMUL_TILE_96x192 = 151,
  CUBLASLT_MATMUL_TILE_96x256 = 152,
  CUBLASLT_MATMUL_TILE_96x320 = 153,
  CUBLASLT_MATMUL_TILE_96x384 = 154,
  CUBLASLT_MATMUL_TILE_96x448 = 155,
  CUBLASLT_MATMUL_TILE_96x512 = 156,
  CUBLASLT_MATMUL_TILE_104x64 = 157,
  CUBLASLT_MATMUL_TILE_104x128 = 158,
  CUBLASLT_MATMUL_TILE_104x192 = 159,
  CUBLASLT_MATMUL_TILE_104x256 = 160,
  CUBLASLT_MATMUL_TILE_104x320 = 161,
  CUBLASLT_MATMUL_TILE_104x384 = 162,
  CUBLASLT_MATMUL_TILE_104x448 = 163,
  CUBLASLT_MATMUL_TILE_112x64 = 164,
  CUBLASLT_MATMUL_TILE_112x128 = 165,
  CUBLASLT_MATMUL_TILE_112x192 = 166,
  CUBLASLT_MATMUL_TILE_112x256 = 167,
  CUBLASLT_MATMUL_TILE_112x320 = 168,
  CUBLASLT_MATMUL_TILE_112x384 = 169,
  CUBLASLT_MATMUL_TILE_120x64 = 170,
  CUBLASLT_MATMUL_TILE_120x128 = 171,
  CUBLASLT_MATMUL_TILE_120x192 = 172,
  CUBLASLT_MATMUL_TILE_120x256 = 173,
  CUBLASLT_MATMUL_TILE_120x320 = 174,
  CUBLASLT_MATMUL_TILE_120x384 = 175,
  CUBLASLT_MATMUL_TILE_128x320 = 176,
  CUBLASLT_MATMUL_TILE_128x384 = 177,
  CUBLASLT_MATMUL_TILE_136x64 = 178,
  CUBLASLT_MATMUL_TILE_136x128 = 179,
  CUBLASLT_MATMUL_TILE_136x192 = 180,
  CUBLASLT_MATMUL_TILE_136x256 = 181,
  CUBLASLT_MATMUL_TILE_136x320 = 182,
  CUBLASLT_MATMUL_TILE_144x64 = 183,
  CUBLASLT_MATMUL_TILE_144x128 = 184,
  CUBLASLT_MATMUL_TILE_144x192 = 185,
  CUBLASLT_MATMUL_TILE_144x256 = 186,
  CUBLASLT_MATMUL_TILE_144x320 = 187,
  CUBLASLT_MATMUL_TILE_152x64 = 188,
  CUBLASLT_MATMUL_TILE_152x128 = 189,
  CUBLASLT_MATMUL_TILE_152x192 = 190,
  CUBLASLT_MATMUL_TILE_152x256 = 191,
  CUBLASLT_MATMUL_TILE_152x320 = 192,
  CUBLASLT_MATMUL_TILE_160x64 = 193,
  CUBLASLT_MATMUL_TILE_160x192 = 194,
  CUBLASLT_MATMUL_TILE_160x256 = 195,
  CUBLASLT_MATMUL_TILE_168x64 = 196,
  CUBLASLT_MATMUL_TILE_168x128 = 197,
  CUBLASLT_MATMUL_TILE_168x192 = 198,
  CUBLASLT_MATMUL_TILE_168x256 = 199,
  CUBLASLT_MATMUL_TILE_176x64 = 200,
  CUBLASLT_MATMUL_TILE_176x128 = 201,
  CUBLASLT_MATMUL_TILE_176x192 = 202,
  CUBLASLT_MATMUL_TILE_176x256 = 203,
  CUBLASLT_MATMUL_TILE_184x64 = 204,
  CUBLASLT_MATMUL_TILE_184x128 = 205,
  CUBLASLT_MATMUL_TILE_184x192 = 206,
  CUBLASLT_MATMUL_TILE_184x256 = 207,
  CUBLASLT_MATMUL_TILE_192x64 = 208,
  CUBLASLT_MATMUL_TILE_192x192 = 209,
  CUBLASLT_MATMUL_TILE_192x256 = 210,
  CUBLASLT_MATMUL_TILE_200x64 = 211,
  CUBLASLT_MATMUL_TILE_200x128 = 212,
  CUBLASLT_MATMUL_TILE_200x192 = 213,
  CUBLASLT_MATMUL_TILE_208x64 = 214,
  CUBLASLT_MATMUL_TILE_208x128 = 215,
  CUBLASLT_MATMUL_TILE_208x192 = 216,
  CUBLASLT_MATMUL_TILE_216x64 = 217,
  CUBLASLT_MATMUL_TILE_216x128 = 218,
  CUBLASLT_MATMUL_TILE_216x192 = 219,
  CUBLASLT_MATMUL_TILE_224x64 = 220,
  CUBLASLT_MATMUL_TILE_224x128 = 221,
  CUBLASLT_MATMUL_TILE_224x192 = 222,
  CUBLASLT_MATMUL_TILE_232x64 = 223,
  CUBLASLT_MATMUL_TILE_232x128 = 224,
  CUBLASLT_MATMUL_TILE_232x192 = 225,
  CUBLASLT_MATMUL_TILE_240x64 = 226,
  CUBLASLT_MATMUL_TILE_240x128 = 227,
  CUBLASLT_MATMUL_TILE_240x192 = 228,
  CUBLASLT_MATMUL_TILE_248x64 = 229,
  CUBLASLT_MATMUL_TILE_248x128 = 230,
  CUBLASLT_MATMUL_TILE_248x192 = 231,
  CUBLASLT_MATMUL_TILE_256x192 = 232,
  CUBLASLT_MATMUL_TILE_264x64 = 233,
  CUBLASLT_MATMUL_TILE_264x128 = 234,
  CUBLASLT_MATMUL_TILE_272x64 = 235,
  CUBLASLT_MATMUL_TILE_272x128 = 236,
  CUBLASLT_MATMUL_TILE_280x64 = 237,
  CUBLASLT_MATMUL_TILE_280x128 = 238,
  CUBLASLT_MATMUL_TILE_288x64 = 239,
  CUBLASLT_MATMUL_TILE_288x128 = 240,
  CUBLASLT_MATMUL_TILE_296x64 = 241,
  CUBLASLT_MATMUL_TILE_296x128 = 242,
  CUBLASLT_MATMUL_TILE_304x64 = 243,
  CUBLASLT_MATMUL_TILE_304x128 = 244,
  CUBLASLT_MATMUL_TILE_312x64 = 245,
  CUBLASLT_MATMUL_TILE_312x128 = 246,
  CUBLASLT_MATMUL_TILE_320x64 = 247,
  CUBLASLT_MATMUL_TILE_320x128 = 248,
  CUBLASLT_MATMUL_TILE_328x64 = 249,
  CUBLASLT_MATMUL_TILE_328x128 = 250,
  CUBLASLT_MATMUL_TILE_336x64 = 251,
  CUBLASLT_MATMUL_TILE_336x128 = 252,
  CUBLASLT_MATMUL_TILE_344x64 = 253,
  CUBLASLT_MATMUL_TILE_344x128 = 254,
  CUBLASLT_MATMUL_TILE_352x64 = 255,
  CUBLASLT_MATMUL_TILE_352x128 = 256,
  CUBLASLT_MATMUL_TILE_360x64 = 257,
  CUBLASLT_MATMUL_TILE_360x128 = 258,
  CUBLASLT_MATMUL_TILE_368x64 = 259,
  CUBLASLT_MATMUL_TILE_368x128 = 260,
  CUBLASLT_MATMUL_TILE_376x64 = 261,
  CUBLASLT_MATMUL_TILE_376x128 = 262,
  CUBLASLT_MATMUL_TILE_384x64 = 263,
  CUBLASLT_MATMUL_TILE_384x128 = 264,
  CUBLASLT_MATMUL_TILE_392x64 = 265,
  CUBLASLT_MATMUL_TILE_400x64 = 266,
  CUBLASLT_MATMUL_TILE_408x64 = 267,
  CUBLASLT_MATMUL_TILE_416x64 = 268,
  CUBLASLT_MATMUL_TILE_424x64 = 269,
  CUBLASLT_MATMUL_TILE_432x64 = 270,
  CUBLASLT_MATMUL_TILE_440x64 = 271,
  CUBLASLT_MATMUL_TILE_448x64 = 272,
  CUBLASLT_MATMUL_TILE_456x64 = 273,
  CUBLASLT_MATMUL_TILE_464x64 = 274,
  CUBLASLT_MATMUL_TILE_472x64 = 275,
  CUBLASLT_MATMUL_TILE_480x64 = 276,
  CUBLASLT_MATMUL_TILE_488x64 = 277,
  CUBLASLT_MATMUL_TILE_496x64 = 278,
  CUBLASLT_MATMUL_TILE_504x64 = 279,
  CUBLASLT_MATMUL_TILE_520x64 = 280,
  CUBLASLT_MATMUL_TILE_528x64 = 281,
  CUBLASLT_MATMUL_TILE_536x64 = 282,
  CUBLASLT_MATMUL_TILE_544x64 = 283,
  CUBLASLT_MATMUL_TILE_552x64 = 284,
  CUBLASLT_MATMUL_TILE_560x64 = 285,
  CUBLASLT_MATMUL_TILE_568x64 = 286,
  CUBLASLT_MATMUL_TILE_576x64 = 287,
  CUBLASLT_MATMUL_TILE_584x64 = 288,
  CUBLASLT_MATMUL_TILE_592x64 = 289,
  CUBLASLT_MATMUL_TILE_600x64 = 290,
  CUBLASLT_MATMUL_TILE_608x64 = 291,
  CUBLASLT_MATMUL_TILE_616x64 = 292,
  CUBLASLT_MATMUL_TILE_624x64 = 293,
  CUBLASLT_MATMUL_TILE_632x64 = 294,
  CUBLASLT_MATMUL_TILE_640x64 = 295,
  CUBLASLT_MATMUL_TILE_648x64 = 296,
  CUBLASLT_MATMUL_TILE_656x64 = 297,
  CUBLASLT_MATMUL_TILE_664x64 = 298,
  CUBLASLT_MATMUL_TILE_672x64 = 299,
  CUBLASLT_MATMUL_TILE_680x64 = 300,
  CUBLASLT_MATMUL_TILE_688x64 = 301,
  CUBLASLT_MATMUL_TILE_696x64 = 302,
  CUBLASLT_MATMUL_TILE_704x64 = 303,
  CUBLASLT_MATMUL_TILE_712x64 = 304,
  CUBLASLT_MATMUL_TILE_720x64 = 305,
  CUBLASLT_MATMUL_TILE_728x64 = 306,
  CUBLASLT_MATMUL_TILE_736x64 = 307,
  CUBLASLT_MATMUL_TILE_744x64 = 308,
  CUBLASLT_MATMUL_TILE_752x64 = 309,
  CUBLASLT_MATMUL_TILE_760x64 = 310,
  CUBLASLT_MATMUL_TILE_768x64 = 311,
  CUBLASLT_MATMUL_TILE_64x16 = 312,
  CUBLASLT_MATMUL_TILE_64x24 = 313,
  CUBLASLT_MATMUL_TILE_64x40 = 314,
  CUBLASLT_MATMUL_TILE_64x48 = 315,
  CUBLASLT_MATMUL_TILE_64x56 = 316,
  CUBLASLT_MATMUL_TILE_64x72 = 317,
  CUBLASLT_MATMUL_TILE_64x80 = 318,
  CUBLASLT_MATMUL_TILE_64x88 = 319,
  CUBLASLT_MATMUL_TILE_64x104 = 320,
  CUBLASLT_MATMUL_TILE_64x112 = 321,
  CUBLASLT_MATMUL_TILE_64x120 = 322,
  CUBLASLT_MATMUL_TILE_64x136 = 323,
  CUBLASLT_MATMUL_TILE_64x144 = 324,
  CUBLASLT_MATMUL_TILE_64x152 = 325,
  CUBLASLT_MATMUL_TILE_64x160 = 326,
  CUBLASLT_MATMUL_TILE_64x168 = 327,
  CUBLASLT_MATMUL_TILE_64x176 = 328,
  CUBLASLT_MATMUL_TILE_64x184 = 329,
  CUBLASLT_MATMUL_TILE_64x200 = 330,
  CUBLASLT_MATMUL_TILE_64x208 = 331,
  CUBLASLT_MATMUL_TILE_64x216 = 332,
  CUBLASLT_MATMUL_TILE_64x224 = 333,
  CUBLASLT_MATMUL_TILE_64x232 = 334,
  CUBLASLT_MATMUL_TILE_64x240 = 335,
  CUBLASLT_MATMUL_TILE_64x248 = 336,
  CUBLASLT_MATMUL_TILE_64x264 = 337,
  CUBLASLT_MATMUL_TILE_64x272 = 338,
  CUBLASLT_MATMUL_TILE_64x280 = 339,
  CUBLASLT_MATMUL_TILE_64x288 = 340,
  CUBLASLT_MATMUL_TILE_64x296 = 341,
  CUBLASLT_MATMUL_TILE_64x304 = 342,
  CUBLASLT_MATMUL_TILE_64x312 = 343,
  CUBLASLT_MATMUL_TILE_64x328 = 344,
  CUBLASLT_MATMUL_TILE_64x336 = 345,
  CUBLASLT_MATMUL_TILE_64x344 = 346,
  CUBLASLT_MATMUL_TILE_64x352 = 347,
  CUBLASLT_MATMUL_TILE_64x360 = 348,
  CUBLASLT_MATMUL_TILE_64x368 = 349,
  CUBLASLT_MATMUL_TILE_64x376 = 350,
  CUBLASLT_MATMUL_TILE_64x392 = 351,
  CUBLASLT_MATMUL_TILE_64x400 = 352,
  CUBLASLT_MATMUL_TILE_64x408 = 353,
  CUBLASLT_MATMUL_TILE_64x416 = 354,
  CUBLASLT_MATMUL_TILE_64x424 = 355,
  CUBLASLT_MATMUL_TILE_64x432 = 356,
  CUBLASLT_MATMUL_TILE_64x440 = 357,
  CUBLASLT_MATMUL_TILE_64x456 = 358,
  CUBLASLT_MATMUL_TILE_64x464 = 359,
  CUBLASLT_MATMUL_TILE_64x472 = 360,
  CUBLASLT_MATMUL_TILE_64x480 = 361,
  CUBLASLT_MATMUL_TILE_64x488 = 362,
  CUBLASLT_MATMUL_TILE_64x496 = 363,
  CUBLASLT_MATMUL_TILE_64x504 = 364,
  CUBLASLT_MATMUL_TILE_64x520 = 365,
  CUBLASLT_MATMUL_TILE_64x528 = 366,
  CUBLASLT_MATMUL_TILE_64x536 = 367,
  CUBLASLT_MATMUL_TILE_64x544 = 368,
  CUBLASLT_MATMUL_TILE_64x552 = 369,
  CUBLASLT_MATMUL_TILE_64x560 = 370,
  CUBLASLT_MATMUL_TILE_64x568 = 371,
  CUBLASLT_MATMUL_TILE_64x584 = 372,
  CUBLASLT_MATMUL_TILE_64x592 = 373,
  CUBLASLT_MATMUL_TILE_64x600 = 374,
  CUBLASLT_MATMUL_TILE_64x608 = 375,
  CUBLASLT_MATMUL_TILE_64x616 = 376,
  CUBLASLT_MATMUL_TILE_64x624 = 377,
  CUBLASLT_MATMUL_TILE_64x632 = 378,
  CUBLASLT_MATMUL_TILE_64x648 = 379,
  CUBLASLT_MATMUL_TILE_64x656 = 380,
  CUBLASLT_MATMUL_TILE_64x664 = 381,
  CUBLASLT_MATMUL_TILE_64x672 = 382,
  CUBLASLT_MATMUL_TILE_64x680 = 383,
  CUBLASLT_MATMUL_TILE_64x688 = 384,
  CUBLASLT_MATMUL_TILE_64x696 = 385,
  CUBLASLT_MATMUL_TILE_64x712 = 386,
  CUBLASLT_MATMUL_TILE_64x720 = 387,
  CUBLASLT_MATMUL_TILE_64x728 = 388,
  CUBLASLT_MATMUL_TILE_64x736 = 389,
  CUBLASLT_MATMUL_TILE_64x744 = 390,
  CUBLASLT_MATMUL_TILE_64x752 = 391,
  CUBLASLT_MATMUL_TILE_64x760 = 392,
  CUBLASLT_MATMUL_TILE_128x8 = 393,
  CUBLASLT_MATMUL_TILE_128x16 = 394,
  CUBLASLT_MATMUL_TILE_128x24 = 395,
  CUBLASLT_MATMUL_TILE_128x40 = 396,
  CUBLASLT_MATMUL_TILE_128x48 = 397,
  CUBLASLT_MATMUL_TILE_128x56 = 398,
  CUBLASLT_MATMUL_TILE_128x72 = 399,
  CUBLASLT_MATMUL_TILE_128x80 = 400,
  CUBLASLT_MATMUL_TILE_128x88 = 401,
  CUBLASLT_MATMUL_TILE_128x104 = 402,
  CUBLASLT_MATMUL_TILE_128x112 = 403,
  CUBLASLT_MATMUL_TILE_128x120 = 404,
  CUBLASLT_MATMUL_TILE_128x136 = 405,
  CUBLASLT_MATMUL_TILE_128x144 = 406,
  CUBLASLT_MATMUL_TILE_128x152 = 407,
  CUBLASLT_MATMUL_TILE_128x168 = 408,
  CUBLASLT_MATMUL_TILE_128x176 = 409,
  CUBLASLT_MATMUL_TILE_128x184 = 410,
  CUBLASLT_MATMUL_TILE_128x200 = 411,
  CUBLASLT_MATMUL_TILE_128x208 = 412,
  CUBLASLT_MATMUL_TILE_128x216 = 413,
  CUBLASLT_MATMUL_TILE_128x224 = 414,
  CUBLASLT_MATMUL_TILE_128x232 = 415,
  CUBLASLT_MATMUL_TILE_128x240 = 416,
  CUBLASLT_MATMUL_TILE_128x248 = 417,
  CUBLASLT_MATMUL_TILE_128x264 = 418,
  CUBLASLT_MATMUL_TILE_128x272 = 419,
  CUBLASLT_MATMUL_TILE_128x280 = 420,
  CUBLASLT_MATMUL_TILE_128x288 = 421,
  CUBLASLT_MATMUL_TILE_128x296 = 422,
  CUBLASLT_MATMUL_TILE_128x304 = 423,
  CUBLASLT_MATMUL_TILE_128x312 = 424,
  CUBLASLT_MATMUL_TILE_128x328 = 425,
  CUBLASLT_MATMUL_TILE_128x336 = 426,
  CUBLASLT_MATMUL_TILE_128x344 = 427,
  CUBLASLT_MATMUL_TILE_128x352 = 428,
  CUBLASLT_MATMUL_TILE_128x360 = 429,
  CUBLASLT_MATMUL_TILE_128x368 = 430,
  CUBLASLT_MATMUL_TILE_128x376 = 431,
  CUBLASLT_MATMUL_TILE_128x392 = 432,
  CUBLASLT_MATMUL_TILE_128x400 = 433,
  CUBLASLT_MATMUL_TILE_128x408 = 434,
  CUBLASLT_MATMUL_TILE_128x416 = 435,
  CUBLASLT_MATMUL_TILE_128x424 = 436,
  CUBLASLT_MATMUL_TILE_128x432 = 437,
  CUBLASLT_MATMUL_TILE_128x440 = 438,
  CUBLASLT_MATMUL_TILE_128x448 = 439,
  CUBLASLT_MATMUL_TILE_128x456 = 440,
  CUBLASLT_MATMUL_TILE_128x464 = 441,
  CUBLASLT_MATMUL_TILE_128x472 = 442,
  CUBLASLT_MATMUL_TILE_128x480 = 443,
  CUBLASLT_MATMUL_TILE_128x488 = 444,
  CUBLASLT_MATMUL_TILE_128x496 = 445,
  CUBLASLT_MATMUL_TILE_128x504 = 446,
  CUBLASLT_MATMUL_TILE_128x512 = 447,
  CUBLASLT_MATMUL_TILE_192x8 = 448,
  CUBLASLT_MATMUL_TILE_192x16 = 449,
  CUBLASLT_MATMUL_TILE_192x24 = 450,
  CUBLASLT_MATMUL_TILE_192x32 = 451,
  CUBLASLT_MATMUL_TILE_192x40 = 452,
  CUBLASLT_MATMUL_TILE_192x48 = 453,
  CUBLASLT_MATMUL_TILE