// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.cudnn.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;

public class cudnn extends org.bytedeco.cuda.presets.cudnn {
    static { Loader.load(); }

// Parsed from <cudnn.h>

/*
 * Copyright 2014-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*   cudnn : Neural Networks Library  */

// #if !defined(CUDNN_H_)
// #define CUDNN_H_
// #if defined(__cplusplus)
// #endif

// #include <cuda_runtime_api.h>
// #include "cudnn_version.h"
// #include "cudnn_graph.h"
// #include "cudnn_ops.h"
// #include "cudnn_adv.h"
// #include "cudnn_cnn.h"

// #if defined(__cplusplus)
// #endif
// #endif /* CUDNN_H_ */


// Parsed from <cudnn_version.h>

/*
 * Copyright 2014-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/**
 * \file: The master cuDNN version file.
 */

// #ifndef CUDNN_VERSION_H_
// #define CUDNN_VERSION_H_

public static final int CUDNN_MAJOR = 9;
public static final int CUDNN_MINOR = 10;
public static final int CUDNN_PATCHLEVEL = 2;

public static final int CUDNN_VERSION = (CUDNN_MAJOR * 10000 + CUDNN_MINOR * 100 + CUDNN_PATCHLEVEL);

/* cannot use constexpr here since this is a C-only file */
/* Below is the max SM version this cuDNN library is aware of and supports natively */

public static final int CUDNN_MAX_SM_MAJOR_NUMBER = 12;
public static final int CUDNN_MAX_SM_MINOR_NUMBER = 0;
public static final int CUDNN_MAX_DEVICE_VERSION = (CUDNN_MAX_SM_MAJOR_NUMBER * 100 + CUDNN_MAX_SM_MINOR_NUMBER * 10);

// #endif /* CUDNN_VERSION_H */


// Parsed from <cudnn_graph.h>

/*
 * Copyright 2014-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 *  cudnn_graph : cuDNN's basic definitions operations.
 */

// #if !defined(CUDNN_GRAPH_H_)
// #define CUDNN_GRAPH_H_

// #include <cuda_runtime_api.h>
// #include <library_types.h>

// #include <stdint.h>

// #include "cudnn_version.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_GRAPH_MAJOR = 9;
public static final int CUDNN_GRAPH_MINOR = 10;
public static final int CUDNN_GRAPH_PATCH = 2;

// #if (CUDNN_GRAPH_MAJOR != CUDNN_MAJOR) || (CUDNN_GRAPH_MINOR != CUDNN_MINOR) || (CUDNN_GRAPH_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN GRAPH!!!
// #endif

// #ifndef CUDNNWINAPI
// #ifdef _WIN32
// #define CUDNNWINAPI __stdcall
// #else
// #define CUDNNWINAPI
// #endif
// #endif

/* Warnings for deprecated API-s are enabled using the CUDNN_WARN_DEPRECATED macro */
// #if defined(CUDNN_WARN_DEPRECATED) && (defined(__GNUC__) || defined(__clang__))
/* GCC, Intel C/C++, Cray C/C++, CLANG, IBM XL C/C++ little endian */
// #define CUDNN_DEPRECATED __attribute__((deprecated))
// #define CUDNN_DEPRECATED_ENUM __attribute__((deprecated))
// #elif defined(CUDNN_WARN_DEPRECATED) && defined(_MSC_VER)
/* Microsoft Visual C++ */
// #define CUDNN_DEPRECATED __declspec(deprecated)
// #define CUDNN_DEPRECATED_ENUM __declspec(deprecated)
// #elif defined(CUDNN_WARN_DEPRECATED) && (__cplusplus >= 201402L)
/* C++14 compilers */
// #define CUDNN_DEPRECATED [[deprecated]]
// #define CUDNN_DEPRECATED_ENUM [[deprecated]]
// #else
/* No support for the deprecated attribute */
// #define CUDNN_DEPRECATED
// #define CUDNN_DEPRECATED_ENUM
// #endif

// #if defined(__cplusplus)
// Targeting ..\cudnn\cudnnContext.java



public static native @Cast("size_t") long cudnnGetVersion();

public static native @Cast("size_t") long cudnnGetMaxDeviceVersion();

/* Returns CUDA Runtime version statically linked against cudnn */
public static native @Cast("size_t") long cudnnGetCudartVersion();

/*
 * CUDNN return codes
 */
/** enum cudnnStatus_t */
public static final int
    CUDNN_STATUS_SUCCESS = 0,

    /* Uncategorized errors */
    CUDNN_STATUS_NOT_INITIALIZED                = 1001,
    CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH    = 1002,
    CUDNN_STATUS_SERIALIZATION_VERSION_MISMATCH = 1003,
    CUDNN_STATUS_DEPRECATED                     = 1004,
    CUDNN_STATUS_LICENSE_ERROR                  = 1005,
    CUDNN_STATUS_RUNTIME_IN_PROGRESS            = 1006,
    CUDNN_STATUS_RUNTIME_FP_OVERFLOW            = 1007,
    CUDNN_STATUS_SUBLIBRARY_LOADING_FAILED      = 1008,

    CUDNN_STATUS_BAD_PARAM                     = 2000,
    CUDNN_STATUS_BAD_PARAM_NULL_POINTER        = 2002,
    CUDNN_STATUS_BAD_PARAM_MISALIGNED_POINTER  = 2003,
    CUDNN_STATUS_BAD_PARAM_NOT_FINALIZED       = 2004,
    CUDNN_STATUS_BAD_PARAM_OUT_OF_BOUND        = 2005,
    CUDNN_STATUS_BAD_PARAM_SIZE_INSUFFICIENT   = 2006,
    CUDNN_STATUS_BAD_PARAM_STREAM_MISMATCH     = 2007,
    CUDNN_STATUS_BAD_PARAM_SHAPE_MISMATCH      = 2008,
    CUDNN_STATUS_BAD_PARAM_DUPLICATED_ENTRIES  = 2009,
    CUDNN_STATUS_BAD_PARAM_ATTRIBUTE_TYPE      = 2010,
    CUDNN_STATUS_BAD_PARAM_CUDA_GRAPH_MISMATCH = 2011,
    CUDNN_STATUS_BAD_PARAM_DESCRIPTOR_TYPE     = 2012,

    CUDNN_STATUS_NOT_SUPPORTED                              = 3000,
    CUDNN_STATUS_NOT_SUPPORTED_GRAPH_PATTERN                = 3001,
    CUDNN_STATUS_NOT_SUPPORTED_SHAPE                        = 3002,
    CUDNN_STATUS_NOT_SUPPORTED_DATA_TYPE                    = 3003,
    CUDNN_STATUS_NOT_SUPPORTED_LAYOUT                       = 3004,
    CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDA_DRIVER     = 3005,
    CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDART          = 3006,
    CUDNN_STATUS_NOT_SUPPORTED_ARCH_MISMATCH                = 3007,
    CUDNN_STATUS_NOT_SUPPORTED_RUNTIME_PREREQUISITE_MISSING = 3008,
    CUDNN_STATUS_NOT_SUPPORTED_SUBLIBRARY_UNAVAILABLE       = 3009,
    CUDNN_STATUS_NOT_SUPPORTED_SHARED_MEMORY_INSUFFICIENT   = 3010,
    CUDNN_STATUS_NOT_SUPPORTED_PADDING                      = 3011,
    CUDNN_STATUS_NOT_SUPPORTED_BAD_LAUNCH_PARAM             = 3012,
    CUDNN_STATUS_NOT_SUPPORTED_CUDA_GRAPH_NATIVE_API        = 3013,

    CUDNN_STATUS_INTERNAL_ERROR                          = 4000,
    CUDNN_STATUS_INTERNAL_ERROR_COMPILATION_FAILED       = 4001,
    CUDNN_STATUS_INTERNAL_ERROR_UNEXPECTED_VALUE         = 4002,
    CUDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED   = 4003,
    CUDNN_STATUS_INTERNAL_ERROR_DEVICE_ALLOCATION_FAILED = 4004,
    CUDNN_STATUS_INTERNAL_ERROR_BAD_LAUNCH_PARAM         = 4005,
    CUDNN_STATUS_INTERNAL_ERROR_TEXTURE_CREATION_FAILED  = 4006,

    CUDNN_STATUS_EXECUTION_FAILED             = 5000,
    CUDNN_STATUS_EXECUTION_FAILED_CUDA_DRIVER = 5001,
    CUDNN_STATUS_EXECUTION_FAILED_CUBLAS      = 5002,
    CUDNN_STATUS_EXECUTION_FAILED_CUDART      = 5003,
    CUDNN_STATUS_EXECUTION_FAILED_CURAND      = 5004,

    CUDNN_STATUS_ALLOC_FAILED = CUDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED,
    CUDNN_STATUS_INVALID_VALUE = 2001,
    CUDNN_STATUS_ARCH_MISMATCH = CUDNN_STATUS_NOT_SUPPORTED_ARCH_MISMATCH,
    CUDNN_STATUS_MAPPING_ERROR = CUDNN_STATUS_INTERNAL_ERROR_TEXTURE_CREATION_FAILED,
    CUDNN_STATUS_RUNTIME_PREREQUISITE_MISSING = 
        CUDNN_STATUS_NOT_SUPPORTED_RUNTIME_PREREQUISITE_MISSING,
    CUDNN_STATUS_VERSION_MISMATCH = CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH;

// #define CUDNN_STATUS_FULL_ERROR_CODE(category, specific_err) ((cudnnStatus_t)(0 + (category) + (specific_err)))
// #define CUDNN_STATUS_CATEGORY(full_error_code) ((full_error_code) / 1000 * 1000)
// #define CUDNN_STATUS_SPECIFIC_ERROR(full_error_code) ((full_error_code) % 1000)

/* human-readable error messages */
public static native @Cast("const char*") BytePointer cudnnGetErrorString(@Cast("cudnnStatus_t") int status);

public static native void cudnnGetLastErrorString(@Cast("char*") BytePointer message, @Cast("size_t") long max_size);
public static native void cudnnGetLastErrorString(@Cast("char*") ByteBuffer message, @Cast("size_t") long max_size);
public static native void cudnnGetLastErrorString(@Cast("char*") byte[] message, @Cast("size_t") long max_size);
// Targeting ..\cudnn\cudnnRuntimeTag_t.java



/** enum cudnnErrQueryMode_t */
public static final int
    CUDNN_ERRQUERY_RAWCODE     = 0,
    CUDNN_ERRQUERY_NONBLOCKING = 1,
    CUDNN_ERRQUERY_BLOCKING    = 2;

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnQueryRuntimeError(cudnnContext handle, @Cast("cudnnStatus_t*") IntPointer rstatus, @Cast("cudnnErrQueryMode_t") int mode, cudnnRuntimeTag_t tag);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnQueryRuntimeError(cudnnContext handle, @Cast("cudnnStatus_t*") IntBuffer rstatus, @Cast("cudnnErrQueryMode_t") int mode, cudnnRuntimeTag_t tag);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnQueryRuntimeError(cudnnContext handle, @Cast("cudnnStatus_t*") int[] rstatus, @Cast("cudnnErrQueryMode_t") int mode, cudnnRuntimeTag_t tag);

public static native @Cast("cudnnStatus_t") int cudnnGetProperty(@Cast("libraryPropertyType") int type, IntPointer value);
public static native @Cast("cudnnStatus_t") int cudnnGetProperty(@Cast("libraryPropertyType") int type, IntBuffer value);
public static native @Cast("cudnnStatus_t") int cudnnGetProperty(@Cast("libraryPropertyType") int type, int[] value);

public static native @Cast("cudnnStatus_t") int cudnnCreate(@ByPtrPtr cudnnContext handle);
public static native @Cast("cudnnStatus_t") int cudnnDestroy(cudnnContext handle);
public static native @Cast("cudnnStatus_t") int cudnnSetStream(cudnnContext handle, CUstream_st streamId);
public static native @Cast("cudnnStatus_t") int cudnnGetStream(cudnnContext handle, @ByPtrPtr CUstream_st streamId);
/*
 * CUDNN data type
 */
/** enum cudnnDataType_t */
public static final int
    CUDNN_DATA_FLOAT                         = 0,
    CUDNN_DATA_DOUBLE                        = 1,
    CUDNN_DATA_HALF                          = 2,
    CUDNN_DATA_INT8                          = 3,
    CUDNN_DATA_INT32                         = 4,
    CUDNN_DATA_INT8x4 = 5,
    CUDNN_DATA_UINT8                         = 6,
    CUDNN_DATA_UINT8x4 = 7,
    CUDNN_DATA_INT8x32 = 8,
    CUDNN_DATA_BFLOAT16                      = 9,
    CUDNN_DATA_INT64                         = 10,
    CUDNN_DATA_BOOLEAN                       = 11,
    CUDNN_DATA_FP8_E4M3                      = 12,
    CUDNN_DATA_FP8_E5M2                      = 13,
    CUDNN_DATA_FAST_FLOAT_FOR_FP8            = 14,
    CUDNN_DATA_FP8_E8M0                      = 15,
    CUDNN_DATA_FP4_E2M1                      = 16;

/*
 * CUDNN math type
 */
/** enum cudnnMathType_t */
public static final int
    CUDNN_DEFAULT_MATH                    = 0,
    CUDNN_TENSOR_OP_MATH                  = 1,
    CUDNN_TENSOR_OP_MATH_ALLOW_CONVERSION = 2,
    CUDNN_FMA_MATH                        = 3;

/*
 * CUDNN propagate Nan
 */
/** enum cudnnNanPropagation_t */
public static final int
    CUDNN_NOT_PROPAGATE_NAN = 0,
    CUDNN_PROPAGATE_NAN = 1;

/*
 * Behavior for OOB samples. OOB samples are samples where L+R > T is encountered during the gradient calculation. If
 * gradMode is set to CUDNN_CTC_SKIP_OOB_GRADIENTS, then the CTC loss function does not write to the gradient buffer for
 * that sample. Instead, the current values, even not finite, are retained. If gradMode is set to
 * CUDNN_CTC_ZERO_OOB_GRADIENTS, then the gradient for that sample is set to zero. This guarantees a finite gradient.
 */
/** enum cudnnCTCGradMode_t */
public static final int
    CUDNN_CTC_ZERO_OOB_GRADIENTS = 0,
    CUDNN_CTC_SKIP_OOB_GRADIENTS = 1;

/** enum cudnnTensorFormat_t */
public static final int
    CUDNN_TENSOR_NCHW        = 0, /* row major (wStride = 1, hStride = w) */
    CUDNN_TENSOR_NHWC        = 1, /* feature maps interleaved ( cStride = 1 )*/
    CUDNN_TENSOR_NCHW_VECT_C = 2; /* each image point is vector of element of C, vector length in data type */

/*
 * CUDNN ReduceTensor op type
 */
/** enum cudnnReduceTensorOp_t */
public static final int
    CUDNN_REDUCE_TENSOR_ADD          = 0,
    CUDNN_REDUCE_TENSOR_MUL          = 1,
    CUDNN_REDUCE_TENSOR_MIN          = 2,
    CUDNN_REDUCE_TENSOR_MAX          = 3,
    CUDNN_REDUCE_TENSOR_AMAX         = 4,
    CUDNN_REDUCE_TENSOR_AVG          = 5,
    CUDNN_REDUCE_TENSOR_NORM1        = 6,
    CUDNN_REDUCE_TENSOR_NORM2        = 7,
    CUDNN_REDUCE_TENSOR_MUL_NO_ZEROS = 8;

/*
 * activation mode
 */
/** enum deprecated */
public static final int
    CUDNN_ACTIVATION_SIGMOID      = 0,
    CUDNN_ACTIVATION_RELU         = 1,
    CUDNN_ACTIVATION_TANH         = 2,
    CUDNN_ACTIVATION_CLIPPED_RELU = 3,
    CUDNN_ACTIVATION_ELU          = 4,
    CUDNN_ACTIVATION_IDENTITY     = 5,
    CUDNN_ACTIVATION_SWISH        = 6;

/** enum cudnnSeverity_t */
public static final int
    CUDNN_SEV_FATAL   = 0,
    CUDNN_SEV_ERROR   = 1,
    CUDNN_SEV_WARNING = 2,
    CUDNN_SEV_INFO    = 3;

/* Message masks to be used with cudnnSetCallback() */
public static final int CUDNN_SEV_ERROR_EN = (1 << CUDNN_SEV_ERROR);
public static final int CUDNN_SEV_WARNING_EN = (1 << CUDNN_SEV_WARNING);
public static final int CUDNN_SEV_INFO_EN = (1 << CUDNN_SEV_INFO);
// Targeting ..\cudnn\cudnnDebug_t.java


// Targeting ..\cudnn\cudnnCallback_t.java



public static native @Cast("cudnnStatus_t") int cudnnSetCallback(@Cast("unsigned") int mask, Pointer udata, cudnnCallback_t fptr);

public static native @Cast("cudnnStatus_t") int cudnnGetCallback(@Cast("unsigned*") IntPointer mask, @Cast("void**") PointerPointer udata, @ByPtrPtr cudnnCallback_t fptr);
public static native @Cast("cudnnStatus_t") int cudnnGetCallback(@Cast("unsigned*") IntPointer mask, @Cast("void**") @ByPtrPtr Pointer udata, @ByPtrPtr cudnnCallback_t fptr);
public static native @Cast("cudnnStatus_t") int cudnnGetCallback(@Cast("unsigned*") IntBuffer mask, @Cast("void**") @ByPtrPtr Pointer udata, @ByPtrPtr cudnnCallback_t fptr);
public static native @Cast("cudnnStatus_t") int cudnnGetCallback(@Cast("unsigned*") int[] mask, @Cast("void**") @ByPtrPtr Pointer udata, @ByPtrPtr cudnnCallback_t fptr);

/*
 * \brief Cross-library version checker.
 * This function is implemented differently in each sub-library. Each sublib
 * checks whether its own version matches that of its dependencies.
 * \returns CUDNN_STATUS_SUCCESS if the version check passes,
 *          CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH if the versions are inconsistent.
 */
public static native @Cast("cudnnStatus_t") int cudnnGraphVersionCheck();

/* Maximum supported number of tensor dimensions */
public static final int CUDNN_DIM_MAX = 8;

/*
 *  convolution mode
 */
/** enum cudnnConvolutionMode_t */
public static final int CUDNN_CONVOLUTION = 0, CUDNN_CROSS_CORRELATION = 1;

/*
 * CUDNN Reorder
 */
/** enum deprecated */
public static final int
    CUDNN_DEFAULT_REORDER = 0,
    CUDNN_NO_REORDER      = 1;
// Targeting ..\cudnn\cudnnBackendDescriptor_t.java


// Targeting ..\cudnn\cudnnFraction_t.java



/** enum cudnnPointwiseMode_t */
public static final int
    CUDNN_POINTWISE_ADD        = 0,
    CUDNN_POINTWISE_ADD_SQUARE = 5,
    CUDNN_POINTWISE_DIV        = 6,
    CUDNN_POINTWISE_MAX        = 3,
    CUDNN_POINTWISE_MIN        = 2,
    CUDNN_POINTWISE_MOD        = 7,
    CUDNN_POINTWISE_MUL        = 1,
    CUDNN_POINTWISE_POW        = 8,
    CUDNN_POINTWISE_SUB        = 9,

    CUDNN_POINTWISE_ABS        = 10,
    CUDNN_POINTWISE_CEIL       = 11,
    CUDNN_POINTWISE_COS        = 12,
    CUDNN_POINTWISE_EXP        = 13,
    CUDNN_POINTWISE_FLOOR      = 14,
    CUDNN_POINTWISE_LOG        = 15,
    CUDNN_POINTWISE_NEG        = 16,
    CUDNN_POINTWISE_RSQRT      = 17,
    CUDNN_POINTWISE_SIN        = 18,
    CUDNN_POINTWISE_SQRT       = 4,
    CUDNN_POINTWISE_TAN        = 19,
    CUDNN_POINTWISE_ERF        = 20,
    CUDNN_POINTWISE_IDENTITY   = 21,
    CUDNN_POINTWISE_RECIPROCAL = 22,
    CUDNN_POINTWISE_ATAN2      = 23,

    CUDNN_POINTWISE_RELU_FWD             = 100,
    CUDNN_POINTWISE_TANH_FWD             = 101,
    CUDNN_POINTWISE_SIGMOID_FWD          = 102,
    CUDNN_POINTWISE_ELU_FWD              = 103,
    CUDNN_POINTWISE_GELU_FWD             = 104,
    CUDNN_POINTWISE_SOFTPLUS_FWD         = 105,
    CUDNN_POINTWISE_SWISH_FWD            = 106,
    CUDNN_POINTWISE_GELU_APPROX_TANH_FWD = 107,

    CUDNN_POINTWISE_RELU_BWD             = 200,
    CUDNN_POINTWISE_TANH_BWD             = 201,
    CUDNN_POINTWISE_SIGMOID_BWD          = 202,
    CUDNN_POINTWISE_ELU_BWD              = 203,
    CUDNN_POINTWISE_GELU_BWD             = 204,
    CUDNN_POINTWISE_SOFTPLUS_BWD         = 205,
    CUDNN_POINTWISE_SWISH_BWD            = 206,
    CUDNN_POINTWISE_GELU_APPROX_TANH_BWD = 207,

    CUDNN_POINTWISE_CMP_EQ  = 300,
    CUDNN_POINTWISE_CMP_NEQ = 301,
    CUDNN_POINTWISE_CMP_GT  = 302,
    CUDNN_POINTWISE_CMP_GE  = 303,
    CUDNN_POINTWISE_CMP_LT  = 304,
    CUDNN_POINTWISE_CMP_LE  = 305,

    CUDNN_POINTWISE_LOGICAL_AND = 400,
    CUDNN_POINTWISE_LOGICAL_OR  = 401,
    CUDNN_POINTWISE_LOGICAL_NOT = 402,

    CUDNN_POINTWISE_GEN_INDEX = 501,

    CUDNN_POINTWISE_BINARY_SELECT = 601;

/** enum cudnnResampleMode_t */
public static final int
    CUDNN_RESAMPLE_NEAREST                 = 0,
    CUDNN_RESAMPLE_BILINEAR                = 1,
    CUDNN_RESAMPLE_AVGPOOL                 = 2,
    CUDNN_RESAMPLE_AVGPOOL_INCLUDE_PADDING = 2,
    CUDNN_RESAMPLE_AVGPOOL_EXCLUDE_PADDING = 4,
    CUDNN_RESAMPLE_MAXPOOL                 = 3;

/** enum cudnnSignalMode_t */
public static final int
    CUDNN_SIGNAL_SET  = 0,
    CUDNN_SIGNAL_WAIT = 1;

/** enum cudnnGenStatsMode_t */
public static final int
    CUDNN_GENSTATS_SUM_SQSUM = 0;

/** enum cudnnBnFinalizeStatsMode_t */
public static final int
    CUDNN_BN_FINALIZE_STATISTICS_TRAINING  = 0,
    CUDNN_BN_FINALIZE_STATISTICS_INFERENCE = 1;

/** enum cudnnRngDistribution_t */
public static final int
    CUDNN_RNG_DISTRIBUTION_BERNOULLI = 0,
    CUDNN_RNG_DISTRIBUTION_UNIFORM   = 1,
    CUDNN_RNG_DISTRIBUTION_NORMAL    = 2;

/** enum cudnnBackendAttributeName_t */
public static final int
    CUDNN_ATTR_POINTWISE_MODE                                  = 0,
    CUDNN_ATTR_POINTWISE_MATH_PREC                             = 1,
    CUDNN_ATTR_POINTWISE_NAN_PROPAGATION = 2,
    CUDNN_ATTR_POINTWISE_RELU_LOWER_CLIP                       = 3,
    CUDNN_ATTR_POINTWISE_RELU_UPPER_CLIP                       = 4,
    CUDNN_ATTR_POINTWISE_RELU_LOWER_CLIP_SLOPE                 = 5,
    CUDNN_ATTR_POINTWISE_ELU_ALPHA                             = 6,
    CUDNN_ATTR_POINTWISE_SOFTPLUS_BETA                         = 7,
    CUDNN_ATTR_POINTWISE_SWISH_BETA                            = 8,
    CUDNN_ATTR_POINTWISE_AXIS                                  = 9,

    CUDNN_ATTR_CONVOLUTION_COMP_TYPE      = 100,
    CUDNN_ATTR_CONVOLUTION_CONV_MODE      = 101,
    CUDNN_ATTR_CONVOLUTION_DILATIONS      = 102,
    CUDNN_ATTR_CONVOLUTION_FILTER_STRIDES = 103,
    CUDNN_ATTR_CONVOLUTION_POST_PADDINGS  = 104,
    CUDNN_ATTR_CONVOLUTION_PRE_PADDINGS   = 105,
    CUDNN_ATTR_CONVOLUTION_SPATIAL_DIMS   = 106,

    CUDNN_ATTR_ENGINEHEUR_MODE            = 200,
    CUDNN_ATTR_ENGINEHEUR_OPERATION_GRAPH = 201,
    CUDNN_ATTR_ENGINEHEUR_RESULTS         = 202,
    CUDNN_ATTR_ENGINEHEUR_SM_COUNT_TARGET = 203,
    CUDNN_ATTR_ENGINEHEUR_DEVICEPROP      = 204,

    CUDNN_ATTR_ENGINECFG_ENGINE             = 300,
    CUDNN_ATTR_ENGINECFG_INTERMEDIATE_INFO  = 301,
    CUDNN_ATTR_ENGINECFG_KNOB_CHOICES       = 302,
    CUDNN_ATTR_ENGINECFG_WORKSPACE_SIZE     = 303,
    CUDNN_ATTR_ENGINECFG_SHARED_MEMORY_USED = 304,

    CUDNN_ATTR_EXECUTION_PLAN_HANDLE = 400,
    CUDNN_ATTR_EXECUTION_PLAN_ENGINE_CONFIG                = 401,
    CUDNN_ATTR_EXECUTION_PLAN_WORKSPACE_SIZE               = 402,
    CUDNN_ATTR_EXECUTION_PLAN_COMPUTED_INTERMEDIATE_UIDS   = 403,
    CUDNN_ATTR_EXECUTION_PLAN_RUN_ONLY_INTERMEDIATE_UIDS   = 404,
    CUDNN_ATTR_EXECUTION_PLAN_JSON_REPRESENTATION          = 405,
    CUDNN_ATTR_EXECUTION_PLAN_KERNEL_CACHE                 = 406,
    CUDNN_ATTR_EXECUTION_PLAN_DEVICEPROP                   = 407,

    CUDNN_ATTR_INTERMEDIATE_INFO_UNIQUE_ID            = 500,
    CUDNN_ATTR_INTERMEDIATE_INFO_SIZE                 = 501,
    CUDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_DATA_UIDS  = 502,
    CUDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_ATTRIBUTES = 503,

    CUDNN_ATTR_KNOB_CHOICE_KNOB_TYPE  = 600,
    CUDNN_ATTR_KNOB_CHOICE_KNOB_VALUE = 601,

    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_ALPHA        = 700,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_BETA         = 701,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_CONV_DESC    = 702,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_W            = 703,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_X            = 704,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_Y            = 705,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_ALPHA       = 706,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_BETA        = 707,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_CONV_DESC   = 708,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_W           = 709,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_DX          = 710,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_DY          = 711,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_ALPHA     = 712,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_BETA      = 713,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_CONV_DESC = 714,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_DW        = 715,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_X         = 716,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_DY        = 717,

    CUDNN_ATTR_OPERATION_POINTWISE_PW_DESCRIPTOR = 750,
    CUDNN_ATTR_OPERATION_POINTWISE_XDESC         = 751,
    CUDNN_ATTR_OPERATION_POINTWISE_BDESC         = 752,
    CUDNN_ATTR_OPERATION_POINTWISE_YDESC         = 753,
    CUDNN_ATTR_OPERATION_POINTWISE_ALPHA1        = 754,
    CUDNN_ATTR_OPERATION_POINTWISE_ALPHA2        = 755,
    CUDNN_ATTR_OPERATION_POINTWISE_DXDESC        = 756,
    CUDNN_ATTR_OPERATION_POINTWISE_DYDESC        = 757,
    CUDNN_ATTR_OPERATION_POINTWISE_TDESC         = 758,

    CUDNN_ATTR_OPERATION_GENSTATS_MODE      = 770,
    CUDNN_ATTR_OPERATION_GENSTATS_MATH_PREC = 771,
    CUDNN_ATTR_OPERATION_GENSTATS_XDESC     = 772,
    CUDNN_ATTR_OPERATION_GENSTATS_SUMDESC   = 773,
    CUDNN_ATTR_OPERATION_GENSTATS_SQSUMDESC = 774,

    CUDNN_ATTR_OPERATION_BN_FINALIZE_STATS_MODE                = 780,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_MATH_PREC                 = 781,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_Y_SUM_DESC                = 782,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_Y_SQ_SUM_DESC             = 783,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SCALE_DESC                = 784,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_BIAS_DESC                 = 785,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_PREV_RUNNING_MEAN_DESC    = 786,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_PREV_RUNNING_VAR_DESC     = 787,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_UPDATED_RUNNING_MEAN_DESC = 788,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_UPDATED_RUNNING_VAR_DESC  = 789,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SAVED_MEAN_DESC           = 790,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SAVED_INV_STD_DESC        = 791,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EQ_SCALE_DESC             = 792,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EQ_BIAS_DESC              = 793,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_ACCUM_COUNT_DESC          = 794,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EPSILON_DESC              = 795,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EXP_AVERATE_FACTOR_DESC   = 796,

    CUDNN_ATTR_OPERATIONGRAPH_HANDLE = 800,
    CUDNN_ATTR_OPERATIONGRAPH_OPS                          = 801,
    CUDNN_ATTR_OPERATIONGRAPH_ENGINE_GLOBAL_COUNT          = 802,
    CUDNN_ATTR_OPERATIONGRAPH_IS_DYNAMIC_SHAPE_ENABLED     = 803,
    CUDNN_ATTR_OPERATIONGRAPH_IS_SAME_TOPOLOGY             = 804,

    CUDNN_ATTR_TENSOR_BYTE_ALIGNMENT       = 900,
    CUDNN_ATTR_TENSOR_DATA_TYPE            = 901,
    CUDNN_ATTR_TENSOR_DIMENSIONS           = 902,
    CUDNN_ATTR_TENSOR_STRIDES              = 903,
    CUDNN_ATTR_TENSOR_VECTOR_COUNT         = 904,
    CUDNN_ATTR_TENSOR_VECTORIZED_DIMENSION = 905,
    CUDNN_ATTR_TENSOR_UNIQUE_ID            = 906,
    CUDNN_ATTR_TENSOR_IS_VIRTUAL           = 907,
    CUDNN_ATTR_TENSOR_IS_BY_VALUE          = 908,
    CUDNN_ATTR_TENSOR_REORDERING_MODE      = 909,
    CUDNN_ATTR_TENSOR_RAGGED_OFFSET_DESC   = 913,

    CUDNN_ATTR_VARIANT_PACK_UNIQUE_IDS    = 1000,
    CUDNN_ATTR_VARIANT_PACK_DATA_POINTERS = 1001,
    CUDNN_ATTR_VARIANT_PACK_INTERMEDIATES = 1002,
    CUDNN_ATTR_VARIANT_PACK_WORKSPACE     = 1003,

    CUDNN_ATTR_LAYOUT_INFO_TENSOR_UID = 1100,
    CUDNN_ATTR_LAYOUT_INFO_TYPES      = 1101,

    CUDNN_ATTR_KNOB_INFO_TYPE          = 1200,
    CUDNN_ATTR_KNOB_INFO_MAXIMUM_VALUE = 1201,
    CUDNN_ATTR_KNOB_INFO_MINIMUM_VALUE = 1202,
    CUDNN_ATTR_KNOB_INFO_STRIDE        = 1203,

    CUDNN_ATTR_ENGINE_OPERATION_GRAPH = 1300,
    CUDNN_ATTR_ENGINE_GLOBAL_INDEX    = 1301,
    CUDNN_ATTR_ENGINE_KNOB_INFO       = 1302,
    CUDNN_ATTR_ENGINE_NUMERICAL_NOTE  = 1303,
    CUDNN_ATTR_ENGINE_LAYOUT_INFO     = 1304,
    CUDNN_ATTR_ENGINE_BEHAVIOR_NOTE   = 1305,
    CUDNN_ATTR_ENGINE_SM_COUNT_TARGET = 1306,
    CUDNN_ATTR_ENGINE_DEVICEPROP      = 1307,

    CUDNN_ATTR_MATMUL_COMP_TYPE     = 1500,
    CUDNN_ATTR_MATMUL_PADDING_VALUE = 1503,

    CUDNN_ATTR_OPERATION_MATMUL_ADESC                                                 = 1520,
    CUDNN_ATTR_OPERATION_MATMUL_BDESC                                                 = 1521,
    CUDNN_ATTR_OPERATION_MATMUL_CDESC                                                 = 1522,
    CUDNN_ATTR_OPERATION_MATMUL_DESC                                                  = 1523,
    CUDNN_ATTR_OPERATION_MATMUL_IRREGULARLY_STRIDED_BATCH_COUNT = 1524,
    CUDNN_ATTR_OPERATION_MATMUL_GEMM_M_OVERRIDE_DESC                                  = 1525,
    CUDNN_ATTR_OPERATION_MATMUL_GEMM_N_OVERRIDE_DESC                                  = 1526,
    CUDNN_ATTR_OPERATION_MATMUL_GEMM_K_OVERRIDE_DESC                                  = 1527,

    CUDNN_ATTR_REDUCTION_OPERATOR  = 1600,
    CUDNN_ATTR_REDUCTION_COMP_TYPE = 1601,

    CUDNN_ATTR_OPERATION_REDUCTION_XDESC = 1610,
    CUDNN_ATTR_OPERATION_REDUCTION_YDESC = 1611,
    CUDNN_ATTR_OPERATION_REDUCTION_DESC  = 1612,

    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_MATH_PREC        = 1620,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_MEAN_DESC        = 1621,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_INVSTD_DESC      = 1622,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_BN_SCALE_DESC    = 1623,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_X_DESC           = 1624,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DY_DESC          = 1625,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DBN_SCALE_DESC   = 1626,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DBN_BIAS_DESC    = 1627,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_DY_SCALE_DESC = 1628,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_X_SCALE_DESC  = 1629,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_BIAS          = 1630,

    CUDNN_ATTR_RESAMPLE_MODE            = 1700,
    CUDNN_ATTR_RESAMPLE_COMP_TYPE       = 1701,
    CUDNN_ATTR_RESAMPLE_SPATIAL_DIMS    = 1702,
    CUDNN_ATTR_RESAMPLE_POST_PADDINGS   = 1703,
    CUDNN_ATTR_RESAMPLE_PRE_PADDINGS    = 1704,
    CUDNN_ATTR_RESAMPLE_STRIDES         = 1705,
    CUDNN_ATTR_RESAMPLE_WINDOW_DIMS     = 1706,
    CUDNN_ATTR_RESAMPLE_NAN_PROPAGATION = 1707,
    CUDNN_ATTR_RESAMPLE_PADDING_MODE    = 1708,

    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_XDESC                       = 1710,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_YDESC                       = 1711,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_IDXDESC                     = 1712,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_ALPHA = 1713,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_BETA = 1714,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_DESC                        = 1716,

    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DXDESC                      = 1720,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DYDESC                      = 1721,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_IDXDESC                     = 1722,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_ALPHA = 1723,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_BETA = 1724,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DESC                        = 1725,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_XDESC                       = 1726,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_YDESC                       = 1727,

    CUDNN_ATTR_OPERATION_CONCAT_AXIS          = 1800,
    CUDNN_ATTR_OPERATION_CONCAT_INPUT_DESCS   = 1801,
    CUDNN_ATTR_OPERATION_CONCAT_INPLACE_INDEX = 1802,
    CUDNN_ATTR_OPERATION_CONCAT_OUTPUT_DESC   = 1803,

    CUDNN_ATTR_OPERATION_SIGNAL_MODE     = 1900,
    CUDNN_ATTR_OPERATION_SIGNAL_FLAGDESC = 1901,
    CUDNN_ATTR_OPERATION_SIGNAL_VALUE    = 1902,
    CUDNN_ATTR_OPERATION_SIGNAL_XDESC    = 1903,
    CUDNN_ATTR_OPERATION_SIGNAL_YDESC    = 1904,

    CUDNN_ATTR_OPERATION_PAGED_CACHE_LOAD_CONTAINER_DESC  = 1950,
    CUDNN_ATTR_OPERATION_PAGED_CACHE_LOAD_YDESC           = 1951,
    CUDNN_ATTR_OPERATION_PAGED_CACHE_LOAD_SEQUENCE_DESC   = 1952,
    CUDNN_ATTR_OPERATION_PAGED_CACHE_LOAD_PAGE_TABLE_DESC = 1953,

    CUDNN_ATTR_OPERATION_NORM_FWD_MODE                     = 2000,
    CUDNN_ATTR_OPERATION_NORM_FWD_PHASE                    = 2001,
    CUDNN_ATTR_OPERATION_NORM_FWD_XDESC                    = 2002,
    CUDNN_ATTR_OPERATION_NORM_FWD_MEAN_DESC                = 2003,
    CUDNN_ATTR_OPERATION_NORM_FWD_INV_VARIANCE_DESC        = 2004,
    CUDNN_ATTR_OPERATION_NORM_FWD_SCALE_DESC               = 2005,
    CUDNN_ATTR_OPERATION_NORM_FWD_BIAS_DESC                = 2006,
    CUDNN_ATTR_OPERATION_NORM_FWD_EPSILON_DESC             = 2007,
    CUDNN_ATTR_OPERATION_NORM_FWD_EXP_AVG_FACTOR_DESC      = 2008,
    CUDNN_ATTR_OPERATION_NORM_FWD_INPUT_RUNNING_MEAN_DESC  = 2009,
    CUDNN_ATTR_OPERATION_NORM_FWD_INPUT_RUNNING_VAR_DESC   = 2010,
    CUDNN_ATTR_OPERATION_NORM_FWD_OUTPUT_RUNNING_MEAN_DESC = 2011,
    CUDNN_ATTR_OPERATION_NORM_FWD_OUTPUT_RUNNING_VAR_DESC  = 2012,
    CUDNN_ATTR_OPERATION_NORM_FWD_YDESC                    = 2013,
    CUDNN_ATTR_OPERATION_NORM_FWD_PEER_STAT_DESCS          = 2014,

    CUDNN_ATTR_OPERATION_NORM_BWD_MODE              = 2100,
    CUDNN_ATTR_OPERATION_NORM_BWD_XDESC             = 2101,
    CUDNN_ATTR_OPERATION_NORM_BWD_MEAN_DESC         = 2102,
    CUDNN_ATTR_OPERATION_NORM_BWD_INV_VARIANCE_DESC = 2103,
    CUDNN_ATTR_OPERATION_NORM_BWD_DYDESC            = 2104,
    CUDNN_ATTR_OPERATION_NORM_BWD_SCALE_DESC        = 2105,
    CUDNN_ATTR_OPERATION_NORM_BWD_EPSILON_DESC      = 2106,
    CUDNN_ATTR_OPERATION_NORM_BWD_DSCALE_DESC       = 2107,
    CUDNN_ATTR_OPERATION_NORM_BWD_DBIAS_DESC        = 2108,
    CUDNN_ATTR_OPERATION_NORM_BWD_DXDESC            = 2109,
    CUDNN_ATTR_OPERATION_NORM_BWD_PEER_STAT_DESCS   = 2110,

    CUDNN_ATTR_OPERATION_RESHAPE_XDESC = 2200,
    CUDNN_ATTR_OPERATION_RESHAPE_YDESC = 2201,

    CUDNN_ATTR_OPERATION_EXPAND_BAND_MATRIX_XDESC                = 2250,
    CUDNN_ATTR_OPERATION_EXPAND_BAND_MATRIX_YDESC                = 2251,
    CUDNN_ATTR_OPERATION_EXPAND_BAND_MATRIX_LOWER_BANDWIDTH      = 2252,
    CUDNN_ATTR_OPERATION_EXPAND_BAND_MATRIX_UPPER_BANDWIDTH      = 2253,
    CUDNN_ATTR_OPERATION_EXPAND_BAND_MATRIX_AXIS                 = 2254,
    CUDNN_ATTR_OPERATION_EXPAND_BAND_MATRIX_PAD_VALUE            = 2255,
    CUDNN_ATTR_OPERATION_EXPAND_BAND_MATRIX_KV_TOKEN_OFFSET_DESC = 2256,

    CUDNN_ATTR_OPERATION_CONTRACT_BAND_MATRIX_XDESC           = 2270,
    CUDNN_ATTR_OPERATION_CONTRACT_BAND_MATRIX_YDESC           = 2271,
    CUDNN_ATTR_OPERATION_CONTRACT_BAND_MATRIX_LOWER_BANDWIDTH = 2272,
    CUDNN_ATTR_OPERATION_CONTRACT_BAND_MATRIX_UPPER_BANDWIDTH = 2273,
    CUDNN_ATTR_OPERATION_CONTRACT_BAND_MATRIX_AXIS            = 2274,
    CUDNN_ATTR_OPERATION_CONTRACT_BAND_MATRIX_PAD_VALUE       = 2275,
    CUDNN_ATTR_OPERATION_CONTRACT_BAND_MAX_TOKEN_VALUE        = 2276,

    CUDNN_ATTR_RNG_DISTRIBUTION                   = 2300,
    CUDNN_ATTR_RNG_NORMAL_DIST_MEAN               = 2301,
    CUDNN_ATTR_RNG_NORMAL_DIST_STANDARD_DEVIATION = 2302,
    CUDNN_ATTR_RNG_UNIFORM_DIST_MAXIMUM           = 2303,
    CUDNN_ATTR_RNG_UNIFORM_DIST_MINIMUM           = 2304,
    CUDNN_ATTR_RNG_BERNOULLI_DIST_PROBABILITY     = 2305,

    CUDNN_ATTR_OPERATION_RNG_YDESC       = 2310,
    CUDNN_ATTR_OPERATION_RNG_SEED        = 2311,
    CUDNN_ATTR_OPERATION_RNG_DESC        = 2312,
    CUDNN_ATTR_OPERATION_RNG_OFFSET_DESC = 2313,

    CUDNN_ATTR_KERNEL_CACHE_OPERATION_GRAPH            = 2400,
    CUDNN_ATTR_KERNEL_CACHE_IS_ENGINECFG_KERNEL_CACHED = 2401,
    CUDNN_ATTR_KERNEL_CACHE_JSON_REPRESENTATION        = 2402,

    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_XDESC      = 2500,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_YDESC      = 2501,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_SCALE_DESC = 2502,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_MATH_PREC  = 2503,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_BLOCK_SIZE = 2504,

    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_XDESC      = 2600,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_SCALE_DESC = 2601,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_YDESC      = 2602,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_MATH_PREC  = 2603,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_BLOCK_SIZE = 2604,

    CUDNN_ATTR_DEVICEPROP_DEVICE_ID           = 2700,
    CUDNN_ATTR_DEVICEPROP_HANDLE              = 2701,
    CUDNN_ATTR_DEVICEPROP_JSON_REPRESENTATION = 2702;

/** enum cudnnBackendAttributeType_t */
public static final int
    CUDNN_TYPE_HANDLE                                = 0,
    CUDNN_TYPE_DATA_TYPE                             = 1,
    CUDNN_TYPE_BOOLEAN                               = 2,
    CUDNN_TYPE_INT64                                 = 3,
    CUDNN_TYPE_FLOAT                                 = 4,
    CUDNN_TYPE_DOUBLE                                = 5,
    CUDNN_TYPE_VOID_PTR                              = 6,
    CUDNN_TYPE_CONVOLUTION_MODE                      = 7,
    CUDNN_TYPE_HEUR_MODE                             = 8,
    CUDNN_TYPE_KNOB_TYPE                             = 9,
    CUDNN_TYPE_NAN_PROPOGATION = 10,
    CUDNN_TYPE_NUMERICAL_NOTE                        = 11,
    CUDNN_TYPE_LAYOUT_TYPE                           = 12,
    CUDNN_TYPE_ATTRIB_NAME                           = 13,
    CUDNN_TYPE_POINTWISE_MODE                        = 14,
    CUDNN_TYPE_BACKEND_DESCRIPTOR                    = 15,
    CUDNN_TYPE_GENSTATS_MODE                         = 16,
    CUDNN_TYPE_BN_FINALIZE_STATS_MODE                = 17,
    CUDNN_TYPE_REDUCTION_OPERATOR_TYPE               = 18,
    CUDNN_TYPE_BEHAVIOR_NOTE                         = 19,
    CUDNN_TYPE_TENSOR_REORDERING_MODE                = 20,
    CUDNN_TYPE_RESAMPLE_MODE                         = 21,
    CUDNN_TYPE_PADDING_MODE                          = 22,
    CUDNN_TYPE_INT32                                 = 23,
    CUDNN_TYPE_CHAR                                  = 24,
    CUDNN_TYPE_SIGNAL_MODE                           = 25,
    CUDNN_TYPE_FRACTION                              = 26,
    CUDNN_TYPE_NORM_MODE                             = 27,
    CUDNN_TYPE_NORM_FWD_PHASE                        = 28,
    CUDNN_TYPE_RNG_DISTRIBUTION                      = 29;

/** enum cudnnBackendDescriptorType_t */
public static final int
    CUDNN_BACKEND_POINTWISE_DESCRIPTOR                             = 0,
    CUDNN_BACKEND_CONVOLUTION_DESCRIPTOR                           = 1,
    CUDNN_BACKEND_ENGINE_DESCRIPTOR                                = 2,
    CUDNN_BACKEND_ENGINECFG_DESCRIPTOR                             = 3,
    CUDNN_BACKEND_ENGINEHEUR_DESCRIPTOR                            = 4,
    CUDNN_BACKEND_EXECUTION_PLAN_DESCRIPTOR                        = 5,
    CUDNN_BACKEND_INTERMEDIATE_INFO_DESCRIPTOR                     = 6,
    CUDNN_BACKEND_KNOB_CHOICE_DESCRIPTOR                           = 7,
    CUDNN_BACKEND_KNOB_INFO_DESCRIPTOR                             = 8,
    CUDNN_BACKEND_LAYOUT_INFO_DESCRIPTOR                           = 9,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_FORWARD_DESCRIPTOR         = 10,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_BACKWARD_FILTER_DESCRIPTOR = 11,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_BACKWARD_DATA_DESCRIPTOR   = 12,
    CUDNN_BACKEND_OPERATION_POINTWISE_DESCRIPTOR                   = 13,
    CUDNN_BACKEND_OPERATION_GEN_STATS_DESCRIPTOR                   = 14,
    CUDNN_BACKEND_OPERATIONGRAPH_DESCRIPTOR                        = 15,
    CUDNN_BACKEND_VARIANT_PACK_DESCRIPTOR                          = 16,
    CUDNN_BACKEND_TENSOR_DESCRIPTOR                                = 17,
    CUDNN_BACKEND_MATMUL_DESCRIPTOR                                = 18,
    CUDNN_BACKEND_OPERATION_MATMUL_DESCRIPTOR                      = 19,
    CUDNN_BACKEND_OPERATION_BN_FINALIZE_STATISTICS_DESCRIPTOR      = 20,
    CUDNN_BACKEND_REDUCTION_DESCRIPTOR                             = 21,
    CUDNN_BACKEND_OPERATION_REDUCTION_DESCRIPTOR                   = 22,
    CUDNN_BACKEND_OPERATION_BN_BWD_WEIGHTS_DESCRIPTOR              = 23,
    CUDNN_BACKEND_RESAMPLE_DESCRIPTOR                              = 24,
    CUDNN_BACKEND_OPERATION_RESAMPLE_FWD_DESCRIPTOR                = 25,
    CUDNN_BACKEND_OPERATION_RESAMPLE_BWD_DESCRIPTOR                = 26,
    CUDNN_BACKEND_OPERATION_CONCAT_DESCRIPTOR                      = 27,
    CUDNN_BACKEND_OPERATION_SIGNAL_DESCRIPTOR                      = 28,
    CUDNN_BACKEND_OPERATION_NORM_FORWARD_DESCRIPTOR                = 29,
    CUDNN_BACKEND_OPERATION_NORM_BACKWARD_DESCRIPTOR               = 30,
    CUDNN_BACKEND_OPERATION_RESHAPE_DESCRIPTOR                     = 31,
    CUDNN_BACKEND_RNG_DESCRIPTOR                                   = 32,
    CUDNN_BACKEND_OPERATION_RNG_DESCRIPTOR                         = 33,
    CUDNN_BACKEND_KERNEL_CACHE_DESCRIPTOR                          = 34,
    CUDNN_BACKEND_OPERATION_PAGED_CACHE_LOAD_DESCRIPTOR            = 35,
    CUDNN_BACKEND_OPERATION_BLOCK_SCALE_QUANTIZE_DESCRIPTOR        = 36,
    CUDNN_BACKEND_OPERATION_BLOCK_SCALE_DEQUANTIZE_DESCRIPTOR      = 37,
    CUDNN_BACKEND_DEVICEPROP_DESCRIPTOR                            = 38,
    CUDNN_BACKEND_OPERATION_EXPAND_BAND_MATRIX_DESCRIPTOR          = 39,
    CUDNN_BACKEND_OPERATION_CONTRACT_BAND_MATRIX_DESCRIPTOR        = 40;

/** enum cudnnBackendNumericalNote_t */
public static final int
    CUDNN_NUMERICAL_NOTE_TENSOR_CORE                 = 0,
    CUDNN_NUMERICAL_NOTE_DOWN_CONVERT_INPUTS         = 1,
    CUDNN_NUMERICAL_NOTE_REDUCED_PRECISION_REDUCTION = 2,
    CUDNN_NUMERICAL_NOTE_FFT                         = 3,
    CUDNN_NUMERICAL_NOTE_NONDETERMINISTIC            = 4,
    CUDNN_NUMERICAL_NOTE_WINOGRAD                    = 5,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_4x4           = 6,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_6x6           = 7,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_13x13         = 8,
    CUDNN_NUMERICAL_NOTE_STRICT_NAN_PROP             = 9,
    CUDNN_NUMERICAL_NOTE_TYPE_COUNT                  = 10;

/** enum cudnnBackendBehaviorNote_t */
public static final int
    CUDNN_BEHAVIOR_NOTE_RUNTIME_COMPILATION             = 0,
    CUDNN_BEHAVIOR_NOTE_REQUIRES_FILTER_INT8x32_REORDER = 1,
    CUDNN_BEHAVIOR_NOTE_REQUIRES_BIAS_INT8x32_REORDER   = 2,
    CUDNN_BEHAVIOR_NOTE_SUPPORTS_CUDA_GRAPH_NATIVE_API  = 3,
    CUDNN_BEHAVIOR_NOTE_TYPE_COUNT                      = 4;

/** enum cudnnBackendKnobType_t */
public static final int
    CUDNN_KNOB_TYPE_SPLIT_K = 0,
    CUDNN_KNOB_TYPE_SWIZZLE                                = 1,
    CUDNN_KNOB_TYPE_TILE_SIZE                              = 2,
    CUDNN_KNOB_TYPE_USE_TEX = 3,
    CUDNN_KNOB_TYPE_EDGE                                   = 4,
    CUDNN_KNOB_TYPE_KBLOCK = 5,
    CUDNN_KNOB_TYPE_LDGA = 6,
    CUDNN_KNOB_TYPE_LDGB = 7,
    CUDNN_KNOB_TYPE_CHUNK_K = 8,
    CUDNN_KNOB_TYPE_SPLIT_H = 9,
    CUDNN_KNOB_TYPE_WINO_TILE = 10,
    CUDNN_KNOB_TYPE_MULTIPLY                               = 11,
    CUDNN_KNOB_TYPE_SPLIT_K_BUF                            = 12,
    CUDNN_KNOB_TYPE_TILEK                                  = 13,
    CUDNN_KNOB_TYPE_STAGES                                 = 14,
    CUDNN_KNOB_TYPE_REDUCTION_MODE                         = 15,
    CUDNN_KNOB_TYPE_CTA_SPLIT_K_MODE = 16,
    CUDNN_KNOB_TYPE_SPLIT_K_SLC                            = 17,
    CUDNN_KNOB_TYPE_IDX_MODE                               = 18,
    CUDNN_KNOB_TYPE_SLICED = 19,
    CUDNN_KNOB_TYPE_SPLIT_RS = 20,
    CUDNN_KNOB_TYPE_SINGLEBUFFER = 21,
    CUDNN_KNOB_TYPE_LDGC = 22,
    CUDNN_KNOB_TYPE_SPECFILT                               = 23,
    CUDNN_KNOB_TYPE_KERNEL_CFG                             = 24,
    CUDNN_KNOB_TYPE_WORKSPACE                              = 25,
    CUDNN_KNOB_TYPE_TILE_CGA = 26,
    CUDNN_KNOB_TYPE_TILE_CGA_M                             = 27,
    CUDNN_KNOB_TYPE_TILE_CGA_N                             = 28,
    CUDNN_KNOB_TYPE_BLOCK_SIZE                             = 29,
    CUDNN_KNOB_TYPE_OCCUPANCY                              = 30,
    CUDNN_KNOB_TYPE_ARRAY_SIZE_PER_THREAD                  = 31,
    CUDNN_KNOB_TYPE_NUM_C_PER_BLOCK = 32,
    CUDNN_KNOB_TYPE_SPLIT_COLS                             = 33,
    CUDNN_KNOB_TYPE_TILE_ROWS                              = 34,
    CUDNN_KNOB_TYPE_TILE_COLS                              = 35,
    CUDNN_KNOB_TYPE_LOAD_SIZE                              = 36,
    CUDNN_KNOB_TYPE_CTA_COUNT                              = 37,
    CUDNN_KNOB_TYPE_STREAM_K                               = 38,
    CUDNN_KNOB_TYPE_SPLIT_P_SLC                            = 39,
    CUDNN_KNOB_TYPE_TILE_M                                 = 40,
    CUDNN_KNOB_TYPE_TILE_N                                 = 41,
    CUDNN_KNOB_TYPE_WARP_SPEC_CFG                          = 42,
    CUDNN_KNOB_TYPE_COUNTS                                 = 43;

/** enum cudnnBackendLayoutType_t */
public static final int
    CUDNN_LAYOUT_TYPE_PREFERRED_NCHW   = 0,
    CUDNN_LAYOUT_TYPE_PREFERRED_NHWC   = 1,
    CUDNN_LAYOUT_TYPE_PREFERRED_PAD4CK = 2,
    CUDNN_LAYOUT_TYPE_PREFERRED_PAD8CK = 3,
    CUDNN_LAYOUT_TYPE_COUNT            = 4;

/** enum cudnnBackendHeurMode_t */
public static final int
    CUDNN_HEUR_MODE_INSTANT  = 0,
    CUDNN_HEUR_MODE_B        = 1,
    CUDNN_HEUR_MODE_FALLBACK = 2,
    CUDNN_HEUR_MODE_A        = 3,
    CUDNN_HEUR_MODES_COUNT   = 4;

/** enum cudnnBackendTensorReordering_t */
public static final int
    CUDNN_TENSOR_REORDERING_NONE     = 0,
    CUDNN_TENSOR_REORDERING_INT8x32  = 1,
    CUDNN_TENSOR_REORDERING_F16x16   = 2,
    CUDNN_TENSOR_REORDERING_F8_128x4 = 3;

/** enum cudnnPaddingMode_t */
public static final int
    CUDNN_ZERO_PAD     = 0,
    CUDNN_NEG_INF_PAD  = 1,
    CUDNN_EDGE_VAL_PAD = 2;

/** enum cudnnBackendNormMode_t */
public static final int
    CUDNN_LAYER_NORM     = 0,
    CUDNN_INSTANCE_NORM  = 1,
    CUDNN_BATCH_NORM     = 2,
    CUDNN_GROUP_NORM     = 3,
    CUDNN_RMS_NORM       = 4,
    CUDNN_ADA_LAYER_NORM = 5;

/** enum cudnnBackendNormFwdPhase_t */
public static final int
    CUDNN_NORM_FWD_INFERENCE = 0,
    CUDNN_NORM_FWD_TRAINING  = 1;

public static native @Cast("cudnnStatus_t") int cudnnBackendCreateDescriptor(@Cast("cudnnBackendDescriptorType_t") int descriptorType, @ByPtrPtr cudnnBackendDescriptor_t descriptor);

public static native @Cast("cudnnStatus_t") int cudnnBackendDestroyDescriptor(cudnnBackendDescriptor_t descriptor);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnBackendInitialize(cudnnBackendDescriptor_t descriptor);

public static native @Cast("cudnnStatus_t") int cudnnBackendFinalize(cudnnBackendDescriptor_t descriptor);

public static native @Cast("cudnnStatus_t") int cudnnBackendSetAttribute(cudnnBackendDescriptor_t descriptor,
                         @Cast("cudnnBackendAttributeName_t") int attributeName,
                         @Cast("cudnnBackendAttributeType_t") int attributeType,
                         @Cast("int64_t") long elementCount,
                         @Const Pointer arrayOfElements);

public static native @Cast("cudnnStatus_t") int cudnnBackendGetAttribute(cudnnBackendDescriptor_t descriptor,
                         @Cast("cudnnBackendAttributeName_t") int attributeName,
                         @Cast("cudnnBackendAttributeType_t") int attributeType,
                         @Cast("int64_t") long requestedElementCount,
                         @Cast("int64_t*") LongPointer elementCount,
                         Pointer arrayOfElements);
public static native @Cast("cudnnStatus_t") int cudnnBackendGetAttribute(cudnnBackendDescriptor_t descriptor,
                         @Cast("cudnnBackendAttributeName_t") int attributeName,
                         @Cast("cudnnBackendAttributeType_t") int attributeType,
                         @Cast("int64_t") long requestedElementCount,
                         @Cast("int64_t*") LongBuffer elementCount,
                         Pointer arrayOfElements);
public static native @Cast("cudnnStatus_t") int cudnnBackendGetAttribute(cudnnBackendDescriptor_t descriptor,
                         @Cast("cudnnBackendAttributeName_t") int attributeName,
                         @Cast("cudnnBackendAttributeType_t") int attributeType,
                         @Cast("int64_t") long requestedElementCount,
                         @Cast("int64_t*") long[] elementCount,
                         Pointer arrayOfElements);

public static native @Cast("cudnnStatus_t") int cudnnBackendExecute(cudnnContext handle, cudnnBackendDescriptor_t executionPlan, cudnnBackendDescriptor_t variantPack);

public static native @Cast("cudnnStatus_t") int cudnnBackendPopulateCudaGraph(cudnnContext handle,
                              cudnnBackendDescriptor_t executionPlan,
                              cudnnBackendDescriptor_t variantPack,
                              CUgraph_st graph);

public static native @Cast("cudnnStatus_t") int cudnnBackendUpdateCudaGraph(cudnnContext handle,
                            cudnnBackendDescriptor_t executionPlan,
                            cudnnBackendDescriptor_t variantPack,
                            CUgraph_st graph);

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_GRAPH_H_ */


// Parsed from <cudnn_ops.h>

/*
 * Copyright 2014-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 *  cudnn_ops : cuDNN's basic definitions and basic operations.
 */

// #if !defined(CUDNN_OPS_H_)
// #define CUDNN_OPS_H_

// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_graph.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_OPS_MAJOR = 9;
public static final int CUDNN_OPS_MINOR = 10;
public static final int CUDNN_OPS_PATCH = 2;

// #if (CUDNN_OPS_MAJOR != CUDNN_MAJOR) || (CUDNN_OPS_MINOR != CUDNN_MINOR) || (CUDNN_OPS_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN OPS INFER!!!
// #endif

// #if defined(__cplusplus)
// Targeting ..\cudnn\cudnnTensorStruct.java


// Targeting ..\cudnn\cudnnPoolingStruct.java


// Targeting ..\cudnn\cudnnFilterStruct.java


// Targeting ..\cudnn\cudnnLRNStruct.java


// Targeting ..\cudnn\cudnnActivationStruct.java


// Targeting ..\cudnn\cudnnSpatialTransformerStruct.java


// Targeting ..\cudnn\cudnnOpTensorStruct.java


// Targeting ..\cudnn\cudnnReduceTensorStruct.java


// Targeting ..\cudnn\cudnnCTCLossStruct.java


// Targeting ..\cudnn\cudnnTensorTransformStruct.java


/*
 * CUDNN Determinism
 */
/** enum cudnnDeterminism_t */
public static final int
    CUDNN_NON_DETERMINISTIC = 0,
    CUDNN_DETERMINISTIC     = 1;

/* Create an instance of a generic Tensor descriptor */
public static native @Cast("cudnnStatus_t") int cudnnCreateTensorDescriptor(@Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct tensorDesc);
public static native @Cast("cudnnStatus_t") int cudnnCreateTensorDescriptor(@Cast("cudnnTensorStruct**") PointerPointer tensorDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetTensor4dDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnTensorFormat_t") int format,
                           @Cast("cudnnDataType_t") int dataType,
                           int n,
                           int c,
                           int h,
                           int w);                   /* width of input section */

public static native @Cast("cudnnStatus_t") int cudnnSetTensor4dDescriptorEx(cudnnTensorStruct tensorDesc,
                             @Cast("cudnnDataType_t") int dataType,
                             int n,
                             int c,
                             int h,
                             int w,
                             int nStride,
                             int cStride,
                             int hStride,
                             int wStride);

public static native @Cast("cudnnStatus_t") int cudnnGetTensor4dDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t*") IntPointer dataType,
                           IntPointer n,
                           IntPointer c,
                           IntPointer h,
                           IntPointer w,
                           IntPointer nStride,
                           IntPointer cStride,
                           IntPointer hStride,
                           IntPointer wStride);
public static native @Cast("cudnnStatus_t") int cudnnGetTensor4dDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t*") IntBuffer dataType,
                           IntBuffer n,
                           IntBuffer c,
                           IntBuffer h,
                           IntBuffer w,
                           IntBuffer nStride,
                           IntBuffer cStride,
                           IntBuffer hStride,
                           IntBuffer wStride);
public static native @Cast("cudnnStatus_t") int cudnnGetTensor4dDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t*") int[] dataType,
                           int[] n,
                           int[] c,
                           int[] h,
                           int[] w,
                           int[] nStride,
                           int[] cStride,
                           int[] hStride,
                           int[] wStride);

public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           int nbDims,
                           @Const IntPointer dimA,
                           @Const IntPointer strideA);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           int nbDims,
                           @Const IntBuffer dimA,
                           @Const IntBuffer strideA);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           int nbDims,
                           @Const int[] dimA,
                           @Const int[] strideA);

public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptorEx(cudnnTensorStruct tensorDesc,
                             @Cast("cudnnTensorFormat_t") int format,
                             @Cast("cudnnDataType_t") int dataType,
                             int nbDims,
                             @Const IntPointer dimA);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptorEx(cudnnTensorStruct tensorDesc,
                             @Cast("cudnnTensorFormat_t") int format,
                             @Cast("cudnnDataType_t") int dataType,
                             int nbDims,
                             @Const IntBuffer dimA);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptorEx(cudnnTensorStruct tensorDesc,
                             @Cast("cudnnTensorFormat_t") int format,
                             @Cast("cudnnDataType_t") int dataType,
                             int nbDims,
                             @Const int[] dimA);

public static native @Cast("cudnnStatus_t") int cudnnGetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") IntPointer dataType,
                           IntPointer nbDims,
                           IntPointer dimA,
                           IntPointer strideA);
public static native @Cast("cudnnStatus_t") int cudnnGetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") IntBuffer dataType,
                           IntBuffer nbDims,
                           IntBuffer dimA,
                           IntBuffer strideA);
public static native @Cast("cudnnStatus_t") int cudnnGetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") int[] dataType,
                           int[] nbDims,
                           int[] dimA,
                           int[] strideA);

public static native @Cast("cudnnStatus_t") int cudnnGetTensorSizeInBytes(cudnnTensorStruct tensorDesc, @Cast("size_t*") SizeTPointer size);

/* PixelOffset( n, c, h, w ) = n *input_stride + c * feature_stride + h * h_stride + w * w_stride

   1)Example of all images in row major order one batch of features after the other (with an optional padding on row)
   input_stride :  c x h x h_stride
   feature_stride : h x h_stride
   h_stride  :  >= w  ( h_stride = w if no padding)
   w_stride  : 1


   2)Example of all images in row major with features maps interleaved
   input_stride :  c x h x h_stride
   feature_stride : 1
   h_stride  :  w x c
   w_stride  : c

   3)Example of all images in column major order one batch of features after the other (with optional padding on column)
   input_stride :  c x w x w_stride
   feature_stride : w x w_stride
   h_stride  :  1
   w_stride  :  >= h

*/

/* Destroy an instance of Tensor4d descriptor */
public static native @Cast("cudnnStatus_t") int cudnnDestroyTensorDescriptor(cudnnTensorStruct tensorDesc);

/* Fold/unfold transforms */
/** enum cudnnFoldingDirection_t */
public static final int
    CUDNN_TRANSFORM_FOLD   = 0,
    CUDNN_TRANSFORM_UNFOLD = 1;

/** Create a destination descriptor for cudnnTransformTensor */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnInitTransformDest(cudnnTensorTransformStruct transformDesc,
                       cudnnTensorStruct srcDesc,
                       cudnnTensorStruct destDesc,
                       @Cast("size_t*") SizeTPointer destSizeInBytes);

/** Create an empty tensor transform descriptor */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateTensorTransformDescriptor(@ByPtrPtr cudnnTensorTransformStruct transformDesc);

/** Initialize a previously created tensor transform descriptor. */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("const uint32_t") int nbDims,
                                  @Cast("const cudnnTensorFormat_t") int destFormat,
                                  @Const IntPointer padBeforeA,
                                  @Const IntPointer padAfterA,
                                  @Cast("const uint32_t*") IntPointer foldA,
                                  @Cast("const cudnnFoldingDirection_t") int direction);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("const uint32_t") int nbDims,
                                  @Cast("const cudnnTensorFormat_t") int destFormat,
                                  @Const IntBuffer padBeforeA,
                                  @Const IntBuffer padAfterA,
                                  @Cast("const uint32_t*") IntBuffer foldA,
                                  @Cast("const cudnnFoldingDirection_t") int direction);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("const uint32_t") int nbDims,
                                  @Cast("const cudnnTensorFormat_t") int destFormat,
                                  @Const int[] padBeforeA,
                                  @Const int[] padAfterA,
                                  @Cast("const uint32_t*") int[] foldA,
                                  @Cast("const cudnnFoldingDirection_t") int direction);

/**
 * Retrieves the values stored in a previously initialized tensor transform
 * descriptor.
 */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("uint32_t") int nbDimsRequested,
                                  @Cast("cudnnTensorFormat_t*") IntPointer destFormat,
                                  IntPointer padBeforeA,
                                  IntPointer padAfterA,
                                  @Cast("uint32_t*") IntPointer foldA,
                                  @Cast("cudnnFoldingDirection_t*") IntPointer direction);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("uint32_t") int nbDimsRequested,
                                  @Cast("cudnnTensorFormat_t*") IntBuffer destFormat,
                                  IntBuffer padBeforeA,
                                  IntBuffer padAfterA,
                                  @Cast("uint32_t*") IntBuffer foldA,
                                  @Cast("cudnnFoldingDirection_t*") IntBuffer direction);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("uint32_t") int nbDimsRequested,
                                  @Cast("cudnnTensorFormat_t*") int[] destFormat,
                                  int[] padBeforeA,
                                  int[] padAfterA,
                                  @Cast("uint32_t*") int[] foldA,
                                  @Cast("cudnnFoldingDirection_t*") int[] direction);

/**
 * Destroys a previously created tensor transform descriptor.
 */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc);

/* Tensor layout conversion helper (y = alpha * x + beta * y) */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnTransformTensor(cudnnContext handle,
                     @Const Pointer alpha,
                     cudnnTensorStruct xDesc,
                     @Const Pointer x,
                     @Const Pointer beta,
                     cudnnTensorStruct yDesc,
                     Pointer y);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnTransformTensorEx(cudnnContext handle,
                       cudnnTensorTransformStruct transDesc,
                       @Const Pointer alpha,
                       cudnnTensorStruct srcDesc,
                       @Const Pointer srcData,
                       @Const Pointer beta,
                       cudnnTensorStruct destDesc,
                       Pointer destData);

/* Tensor Bias addition : C = alpha * A + beta * C  */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnAddTensor(cudnnContext handle,
               @Const Pointer alpha,
               cudnnTensorStruct aDesc,
               @Const Pointer A,
               @Const Pointer beta,
               cudnnTensorStruct cDesc,
               Pointer C);

/*
 * CUDNN OpTensor op type
 */
/** enum cudnnOpTensorOp_t */
public static final int
    CUDNN_OP_TENSOR_ADD  = 0,
    CUDNN_OP_TENSOR_MUL  = 1,
    CUDNN_OP_TENSOR_MIN  = 2,
    CUDNN_OP_TENSOR_MAX  = 3,
    CUDNN_OP_TENSOR_SQRT = 4,
    CUDNN_OP_TENSOR_NOT  = 5;

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateOpTensorDescriptor(@ByPtrPtr cudnnOpTensorStruct opTensorDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc,
                           @Cast("cudnnOpTensorOp_t") int opTensorOp,
                           @Cast("cudnnDataType_t") int opTensorCompType,
                           @Cast("cudnnNanPropagation_t") int opTensorNanOpt);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc,
                           @Cast("cudnnOpTensorOp_t*") IntPointer opTensorOp,
                           @Cast("cudnnDataType_t*") IntPointer opTensorCompType,
                           @Cast("cudnnNanPropagation_t*") IntPointer opTensorNanOpt);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc,
                           @Cast("cudnnOpTensorOp_t*") IntBuffer opTensorOp,
                           @Cast("cudnnDataType_t*") IntBuffer opTensorCompType,
                           @Cast("cudnnNanPropagation_t*") IntBuffer opTensorNanOpt);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc,
                           @Cast("cudnnOpTensorOp_t*") int[] opTensorOp,
                           @Cast("cudnnDataType_t*") int[] opTensorCompType,
                           @Cast("cudnnNanPropagation_t*") int[] opTensorNanOpt);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc);

/* Tensor operation : C = op( alpha1 * A, alpha2 * B ) + beta * C */
/* B tensor is ignored for CUDNN_OP_TENSOR_SQRT, CUDNN_OP_TENSOR_NOT. */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnOpTensor(cudnnContext handle,
              cudnnOpTensorStruct opTensorDesc,
              @Const Pointer alpha1,
              cudnnTensorStruct aDesc,
              @Const Pointer A,
              @Const Pointer alpha2,
              cudnnTensorStruct bDesc,
              @Const Pointer B,
              @Const Pointer beta,
              cudnnTensorStruct cDesc,
              Pointer C);

/*
 * CUDNN ReduceTensor indices type
 */
/** enum deprecated */
public static final int
    CUDNN_REDUCE_TENSOR_NO_INDICES        = 0,
    CUDNN_REDUCE_TENSOR_FLATTENED_INDICES = 1;

/*
 * CUDNN tensor indices type size (all unsigned)
 * Currently not supported, default is 32 bit unsigned.
 */
/** enum deprecated */
public static final int
    CUDNN_32BIT_INDICES = 0,
    CUDNN_64BIT_INDICES = 1,
    CUDNN_16BIT_INDICES = 2,
    CUDNN_8BIT_INDICES  = 3;

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateReduceTensorDescriptor(@ByPtrPtr cudnnReduceTensorStruct reduceTensorDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc,
                               @Cast("cudnnReduceTensorOp_t") int reduceTensorOp,
                               @Cast("cudnnDataType_t") int reduceTensorCompType,
                               @Cast("cudnnNanPropagation_t") int reduceTensorNanOpt,
                               @Cast("cudnnReduceTensorIndices_t") int reduceTensorIndices,
                               @Cast("cudnnIndicesType_t") int reduceTensorIndicesType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc,
                               @Cast("cudnnReduceTensorOp_t*") IntPointer reduceTensorOp,
                               @Cast("cudnnDataType_t*") IntPointer reduceTensorCompType,
                               @Cast("cudnnNanPropagation_t*") IntPointer reduceTensorNanOpt,
                               @Cast("cudnnReduceTensorIndices_t*") IntPointer reduceTensorIndices,
                               @Cast("cudnnIndicesType_t*") IntPointer reduceTensorIndicesType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc,
                               @Cast("cudnnReduceTensorOp_t*") IntBuffer reduceTensorOp,
                               @Cast("cudnnDataType_t*") IntBuffer reduceTensorCompType,
                               @Cast("cudnnNanPropagation_t*") IntBuffer reduceTensorNanOpt,
                               @Cast("cudnnReduceTensorIndices_t*") IntBuffer reduceTensorIndices,
                               @Cast("cudnnIndicesType_t*") IntBuffer reduceTensorIndicesType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc,
                               @Cast("cudnnReduceTensorOp_t*") int[] reduceTensorOp,
                               @Cast("cudnnDataType_t*") int[] reduceTensorCompType,
                               @Cast("cudnnNanPropagation_t*") int[] reduceTensorNanOpt,
                               @Cast("cudnnReduceTensorIndices_t*") int[] reduceTensorIndices,
                               @Cast("cudnnIndicesType_t*") int[] reduceTensorIndicesType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc);

/* Helper function to return the minimum size of the index space to be passed to the reduction given the input and
 * output tensors */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetReductionIndicesSize(cudnnContext handle,
                             cudnnReduceTensorStruct reduceTensorDesc,
                             cudnnTensorStruct aDesc,
                             cudnnTensorStruct cDesc,
                             @Cast("size_t*") SizeTPointer sizeInBytes);

/* Helper function to return the minimum size of the workspace to be passed to the reduction given the input and output
 * tensors */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetReductionWorkspaceSize(cudnnContext handle,
                               cudnnReduceTensorStruct reduceTensorDesc,
                               cudnnTensorStruct aDesc,
                               cudnnTensorStruct cDesc,
                               @Cast("size_t*") SizeTPointer sizeInBytes);

/* Tensor operation : C = reduce op( alpha * A ) + beta * C */
/* The NaN propagation enum applies to only the min and max reduce ops; the other reduce ops propagate NaN as usual. */
/* The indices space is ignored for reduce ops other than min or max. */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnReduceTensor(cudnnContext handle,
                  cudnnReduceTensorStruct reduceTensorDesc,
                  Pointer indices,
                  @Cast("size_t") long indicesSizeInBytes,
                  Pointer workspace,
                  @Cast("size_t") long workspaceSizeInBytes,
                  @Const Pointer alpha,
                  cudnnTensorStruct aDesc,
                  @Const Pointer A,
                  @Const Pointer beta,
                  cudnnTensorStruct cDesc,
                  Pointer C);

/* Set all values of a tensor to a given value : y[i] = value[0] */
public static native @Cast("cudnnStatus_t") int cudnnSetTensor(cudnnContext handle, cudnnTensorStruct yDesc, Pointer y, @Const Pointer valuePtr);

/* Scale all values of a tensor by a given factor : y[i] = alpha * y[i] */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnScaleTensor(cudnnContext handle, cudnnTensorStruct yDesc, Pointer y, @Const Pointer alpha);

/* Create an instance of FilterStruct */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateFilterDescriptor(@ByPtrPtr cudnnFilterStruct filterDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetFilter4dDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           @Cast("cudnnTensorFormat_t") int format,
                           int k,
                           int c,
                           int h,
                           int w); /* width of  each input filter */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFilter4dDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t*") IntPointer dataType,
                           @Cast("cudnnTensorFormat_t*") IntPointer format,
                           IntPointer k,
                           IntPointer c,
                           IntPointer h,
                           IntPointer w);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFilter4dDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t*") IntBuffer dataType,
                           @Cast("cudnnTensorFormat_t*") IntBuffer format,
                           IntBuffer k,
                           IntBuffer c,
                           IntBuffer h,
                           IntBuffer w);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFilter4dDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t*") int[] dataType,
                           @Cast("cudnnTensorFormat_t*") int[] format,
                           int[] k,
                           int[] c,
                           int[] h,
                           int[] w); /* width of  each input filter */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           @Cast("cudnnTensorFormat_t") int format,
                           int nbDims,
                           @Const IntPointer filterDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           @Cast("cudnnTensorFormat_t") int format,
                           int nbDims,
                           @Const IntBuffer filterDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           @Cast("cudnnTensorFormat_t") int format,
                           int nbDims,
                           @Const int[] filterDimA);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") IntPointer dataType,
                           @Cast("cudnnTensorFormat_t*") IntPointer format,
                           IntPointer nbDims,
                           IntPointer filterDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") IntBuffer dataType,
                           @Cast("cudnnTensorFormat_t*") IntBuffer format,
                           IntBuffer nbDims,
                           IntBuffer filterDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") int[] dataType,
                           @Cast("cudnnTensorFormat_t*") int[] format,
                           int[] nbDims,
                           int[] filterDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFilterSizeInBytes(cudnnFilterStruct filterDesc, @Cast("size_t*") SizeTPointer size);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnTransformFilter(cudnnContext handle,
                     cudnnTensorTransformStruct transDesc,
                     @Const Pointer alpha,
                     cudnnFilterStruct srcDesc,
                     @Const Pointer srcData,
                     @Const Pointer beta,
                     cudnnFilterStruct destDesc,
                     Pointer destData);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyFilterDescriptor(cudnnFilterStruct filterDesc);

/*
 *  softmax algorithm
 */
/** enum cudnnSoftmaxAlgorithm_t */
public static final int
    CUDNN_SOFTMAX_FAST     = 0, /* straightforward implementation */
    CUDNN_SOFTMAX_ACCURATE = 1, /* subtract max from every point to avoid overflow */
    CUDNN_SOFTMAX_LOG      = 2;

/** enum cudnnSoftmaxMode_t */
public static final int
    CUDNN_SOFTMAX_MODE_INSTANCE = 0, /* compute the softmax over all C, H, W for each N */
    CUDNN_SOFTMAX_MODE_CHANNEL  = 1;  /* compute the softmax over all C for each H, W, N */

/* Softmax functions: All of the form "output = alpha * Op(inputs) + beta * output" */

/* Function to perform forward softmax */
public static native @Cast("cudnnStatus_t") int cudnnSoftmaxForward(cudnnContext handle,
                    @Cast("cudnnSoftmaxAlgorithm_t") int algo,
                    @Cast("cudnnSoftmaxMode_t") int mode,
                    @Const Pointer alpha,
                    cudnnTensorStruct xDesc,
                    @Const Pointer x,
                    @Const Pointer beta,
                    cudnnTensorStruct yDesc,
                    Pointer y);

/*
 *  pooling mode
 */
/** enum deprecated */
public static final int
    CUDNN_POOLING_MAX                           = 0,
    CUDNN_POOLING_AVERAGE_COUNT_INCLUDE_PADDING = 1, /* count for average includes padded values */
    CUDNN_POOLING_AVERAGE_COUNT_EXCLUDE_PADDING = 2, /* count for average does not include padded values */
    CUDNN_POOLING_MAX_DETERMINISTIC             = 3;

/* Create an instance of pooling descriptor */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreatePoolingDescriptor(@ByPtrPtr cudnnPoolingStruct poolingDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetPooling2dDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("cudnnPoolingMode_t") int mode,
                            @Cast("cudnnNanPropagation_t") int maxpoolingNanOpt,
                            int windowHeight,
                            int windowWidth,
                            int verticalPadding,
                            int horizontalPadding,
                            int verticalStride,
                            int horizontalStride);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPooling2dDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("cudnnPoolingMode_t*") IntPointer mode,
                            @Cast("cudnnNanPropagation_t*") IntPointer maxpoolingNanOpt,
                            IntPointer windowHeight,
                            IntPointer windowWidth,
                            IntPointer verticalPadding,
                            IntPointer horizontalPadding,
                            IntPointer verticalStride,
                            IntPointer horizontalStride);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPooling2dDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("cudnnPoolingMode_t*") IntBuffer mode,
                            @Cast("cudnnNanPropagation_t*") IntBuffer maxpoolingNanOpt,
                            IntBuffer windowHeight,
                            IntBuffer windowWidth,
                            IntBuffer verticalPadding,
                            IntBuffer horizontalPadding,
                            IntBuffer verticalStride,
                            IntBuffer horizontalStride);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPooling2dDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("cudnnPoolingMode_t*") int[] mode,
                            @Cast("cudnnNanPropagation_t*") int[] maxpoolingNanOpt,
                            int[] windowHeight,
                            int[] windowWidth,
                            int[] verticalPadding,
                            int[] horizontalPadding,
                            int[] verticalStride,
                            int[] horizontalStride);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("const cudnnPoolingMode_t") int mode,
                            @Cast("const cudnnNanPropagation_t") int maxpoolingNanOpt,
                            int nbDims,
                            @Const IntPointer windowDimA,
                            @Const IntPointer paddingA,
                            @Const IntPointer strideA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("const cudnnPoolingMode_t") int mode,
                            @Cast("const cudnnNanPropagation_t") int maxpoolingNanOpt,
                            int nbDims,
                            @Const IntBuffer windowDimA,
                            @Const IntBuffer paddingA,
                            @Const IntBuffer strideA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("const cudnnPoolingMode_t") int mode,
                            @Cast("const cudnnNanPropagation_t") int maxpoolingNanOpt,
                            int nbDims,
                            @Const int[] windowDimA,
                            @Const int[] paddingA,
                            @Const int[] strideA);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            int nbDimsRequested,
                            @Cast("cudnnPoolingMode_t*") IntPointer mode,
                            @Cast("cudnnNanPropagation_t*") IntPointer maxpoolingNanOpt,
                            IntPointer nbDims,
                            IntPointer windowDimA,
                            IntPointer paddingA,
                            IntPointer strideA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            int nbDimsRequested,
                            @Cast("cudnnPoolingMode_t*") IntBuffer mode,
                            @Cast("cudnnNanPropagation_t*") IntBuffer maxpoolingNanOpt,
                            IntBuffer nbDims,
                            IntBuffer windowDimA,
                            IntBuffer paddingA,
                            IntBuffer strideA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            int nbDimsRequested,
                            @Cast("cudnnPoolingMode_t*") int[] mode,
                            @Cast("cudnnNanPropagation_t*") int[] maxpoolingNanOpt,
                            int[] nbDims,
                            int[] windowDimA,
                            int[] paddingA,
                            int[] strideA);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPoolingNdForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  int nbDims,
                                  IntPointer outputTensorDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPoolingNdForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  int nbDims,
                                  IntBuffer outputTensorDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPoolingNdForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  int nbDims,
                                  int[] outputTensorDimA);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPooling2dForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  IntPointer n,
                                  IntPointer c,
                                  IntPointer h,
                                  IntPointer w);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPooling2dForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  IntBuffer n,
                                  IntBuffer c,
                                  IntBuffer h,
                                  IntBuffer w);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetPooling2dForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  int[] n,
                                  int[] c,
                                  int[] h,
                                  int[] w);

/* Destroy an instance of pooling descriptor */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyPoolingDescriptor(cudnnPoolingStruct poolingDesc);

/* Pooling functions: All of the form "output = alpha * Op(inputs) + beta * output" */

/* Function to perform forward pooling */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnPoolingForward(cudnnContext handle,
                    cudnnPoolingStruct poolingDesc,
                    @Const Pointer alpha,
                    cudnnTensorStruct xDesc,
                    @Const Pointer x,
                    @Const Pointer beta,
                    cudnnTensorStruct yDesc,
                    Pointer y);

/* Activation functions: All of the form "output = alpha * Op(inputs) + beta * output" */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateActivationDescriptor(@ByPtrPtr cudnnActivationStruct activationDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetActivationDescriptor(cudnnActivationStruct activationDesc,
                             @Cast("cudnnActivationMode_t") int mode,
                             @Cast("cudnnNanPropagation_t") int reluNanOpt,
                             double coef); /* ceiling for clipped RELU, alpha for ELU */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetActivationDescriptor(cudnnActivationStruct activationDesc,
                             @Cast("cudnnActivationMode_t*") IntPointer mode,
                             @Cast("cudnnNanPropagation_t*") IntPointer reluNanOpt,
                             DoublePointer coef);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetActivationDescriptor(cudnnActivationStruct activationDesc,
                             @Cast("cudnnActivationMode_t*") IntBuffer mode,
                             @Cast("cudnnNanPropagation_t*") IntBuffer reluNanOpt,
                             DoubleBuffer coef);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetActivationDescriptor(cudnnActivationStruct activationDesc,
                             @Cast("cudnnActivationMode_t*") int[] mode,
                             @Cast("cudnnNanPropagation_t*") int[] reluNanOpt,
                             double[] coef); /* ceiling for clipped RELU, alpha for ELU */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetActivationDescriptorSwishBeta(cudnnActivationStruct activationDesc, double swish_beta);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetActivationDescriptorSwishBeta(cudnnActivationStruct activationDesc, DoublePointer swish_beta);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetActivationDescriptorSwishBeta(cudnnActivationStruct activationDesc, DoubleBuffer swish_beta);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetActivationDescriptorSwishBeta(cudnnActivationStruct activationDesc, double[] swish_beta);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyActivationDescriptor(cudnnActivationStruct activationDesc);

/* Function to perform forward activation  */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnActivationForward(cudnnContext handle,
                       cudnnActivationStruct activationDesc,
                       @Const Pointer alpha,
                       cudnnTensorStruct xDesc,
                       @Const Pointer x,
                       @Const Pointer beta,
                       cudnnTensorStruct yDesc,
                       Pointer y);

/*
 * Create an instance of LRN (Local Response Normalization) descriptor
 * Uses lrnN=5, lrnAlpha=1e-4, lrnBeta=0.75, lrnK=2.0 as defaults from Krizhevsky'12 ImageNet paper
 */
public static native @Cast("cudnnStatus_t") int cudnnCreateLRNDescriptor(@ByPtrPtr cudnnLRNStruct normDesc);

public static final int CUDNN_LRN_MIN_N = 1;       /* minimum allowed lrnN */
public static final int CUDNN_LRN_MAX_N = 16;      /* maximum allowed lrnN */
public static final double CUDNN_LRN_MIN_K = 1e-5;    /* minimum allowed lrnK */
public static final double CUDNN_LRN_MIN_BETA = 0.01; /* minimum allowed lrnBeta */

/* LRN layer mode */
/** enum cudnnLRNMode_t */
public static final int
    CUDNN_LRN_CROSS_CHANNEL_DIM1 = 0; /* Normalize across tensor's dimA[1] dimension */

/*
 * Uses a window [center-lookBehind, center+lookAhead], where
 * lookBehind = floor( (lrnN-1)/2 ), lookAhead = lrnN-lookBehind-1.
 * Values of double parameters cast to tensor data type.
 */
public static native @Cast("cudnnStatus_t") int cudnnSetLRNDescriptor(cudnnLRNStruct normDesc, @Cast("unsigned") int lrnN, double lrnAlpha, double lrnBeta, double lrnK);
/*
 * Retrieve the settings currently stored in an LRN layer descriptor
 * Any of the provided pointers can be NULL (no corresponding value will be returned)
 */
public static native @Cast("cudnnStatus_t") int cudnnGetLRNDescriptor(cudnnLRNStruct normDesc, @Cast("unsigned*") IntPointer lrnN, DoublePointer lrnAlpha, DoublePointer lrnBeta, DoublePointer lrnK);
public static native @Cast("cudnnStatus_t") int cudnnGetLRNDescriptor(cudnnLRNStruct normDesc, @Cast("unsigned*") IntBuffer lrnN, DoubleBuffer lrnAlpha, DoubleBuffer lrnBeta, DoubleBuffer lrnK);
public static native @Cast("cudnnStatus_t") int cudnnGetLRNDescriptor(cudnnLRNStruct normDesc, @Cast("unsigned*") int[] lrnN, double[] lrnAlpha, double[] lrnBeta, double[] lrnK);

/* Destroy an instance of LRN descriptor */
public static native @Cast("cudnnStatus_t") int cudnnDestroyLRNDescriptor(cudnnLRNStruct lrnDesc);

/* LRN functions: output = alpha * normalize(x) + beta * old_y */

/* LRN cross-channel forward computation. Double parameters cast to tensor data type */
public static native @Cast("cudnnStatus_t") int cudnnLRNCrossChannelForward(cudnnContext handle,
                            cudnnLRNStruct normDesc,
                            @Cast("cudnnLRNMode_t") int lrnMode,
                            @Const Pointer alpha,
                            cudnnTensorStruct xDesc,
                            @Const Pointer x,
                            @Const Pointer beta,
                            cudnnTensorStruct yDesc,
                            Pointer y);

/** enum cudnnDivNormMode_t */
public static final int
    CUDNN_DIVNORM_PRECOMPUTED_MEANS = 0;

/* LCN/divisive normalization functions: y = alpha * normalize(x) + beta * y */
public static native @Cast("cudnnStatus_t") int cudnnDivisiveNormalizationForward(cudnnContext handle,
                                  cudnnLRNStruct normDesc,
                                  @Cast("cudnnDivNormMode_t") int mode,
                                  @Const Pointer alpha,
                                  cudnnTensorStruct xDesc,
                                  @Const Pointer x,
                                  @Const Pointer means,
                                  Pointer temp,
                                  Pointer temp2,
                                  @Const Pointer beta,
                                  cudnnTensorStruct yDesc,
                                  Pointer y);

/** enum deprecated */
public static final int
    /* bnScale, bnBias tensor dims are 1xCxHxWx.. (one value per CHW...-slice, normalized over N slice) */
    CUDNN_BATCHNORM_PER_ACTIVATION = 0,

    /* bnScale, bnBias tensor dims are 1xCx1x1 (one value per C-dim normalized over Nx1xHxW subtensors) */
    CUDNN_BATCHNORM_SPATIAL = 1,

    /*
     * bnScale, bnBias tensor dims are 1xCx1x1 (one value per C-dim normalized over Nx1xHxW subtensors).
     * May be faster than CUDNN_BATCHNORM_SPATIAL but imposes some limits on the range of values
     */
    CUDNN_BATCHNORM_SPATIAL_PERSISTENT = 2;

public static final double CUDNN_BN_MIN_EPSILON = 0.0; /* Minimum epsilon allowed to be used in the Batch Normalization formula */

/*
 * Derives a tensor descriptor from layer data descriptor for BatchNormalization
 * scale, invVariance, bnBias, bnScale tensors. Use this tensor desc for
 * bnScaleBiasMeanVarDesc and bnScaleBiasDiffDesc in Batch Normalization forward and backward functions.
 */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDeriveBNTensorDescriptor(cudnnTensorStruct derivedBnDesc,
                              cudnnTensorStruct xDesc,
                              @Cast("cudnnBatchNormMode_t") int mode);

/** enum deprecated */
public static final int
    CUDNN_BATCHNORM_OPS_BN                = 0, /* do batch normalization only */
    CUDNN_BATCHNORM_OPS_BN_ACTIVATION     = 1, /* do batchNorm, then activation */
    CUDNN_BATCHNORM_OPS_BN_ADD_ACTIVATION = 2; /* do batchNorm, then elemWiseAdd, then activation */

/*
 * Performs Batch Normalization during Inference:
 * y[i] = bnScale[k]*(x[i]-estimatedMean[k])/sqrt(epsilon+estimatedVariance[k]) + bnBias[k]
 * with bnScale, bnBias, runningMean, runningInvVariance tensors indexed
 * according to spatial or per-activation mode. Refer to cudnnBatchNormalizationForwardTraining
 * above for notes on function arguments.
 */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnBatchNormalizationForwardInference(cudnnContext handle,
                                        @Cast("cudnnBatchNormMode_t") int mode,
                                        @Const Pointer alpha,
                                        @Const Pointer beta,
                                        cudnnTensorStruct xDesc,
                                        @Const Pointer x,
                                        cudnnTensorStruct yDesc,
                                        Pointer y,
                                        cudnnTensorStruct bnScaleBiasMeanVarDesc,
                                        @Const Pointer bnScale,
                                        @Const Pointer bnBias,
                                        @Const Pointer estimatedMean,
                                        @Const Pointer estimatedVariance,
                                        double epsilon);

/** enum deprecated */
public static final int
    /* bnScale, bnBias tensor dims are 1xCxHxWx.. (one value per CHW...-slice, normalized over N slice) */
    CUDNN_NORM_PER_ACTIVATION = 0,

    /* bnScale, bnBias tensor dims are 1xCx1x1 (one value per C-dim normalized over Nx1xHxW subtensors) */
    CUDNN_NORM_PER_CHANNEL = 1;

/** enum deprecated */
public static final int CUDNN_NORM_ALGO_STANDARD = 0, CUDNN_NORM_ALGO_PERSIST = 1;

/*
 * Derives a tensor descriptor from layer data descriptor for Normalization
 * scale, invVariance, bnBias, bnScale tensors. Use this tensor desc for
 * normScaleBiasMeanVarDesc and normScaleBiasDiffDesc in Normalization forward and backward functions.
 */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDeriveNormTensorDescriptor(cudnnTensorStruct derivedNormScaleBiasDesc,
                                cudnnTensorStruct derivedNormMeanVarDesc,
                                cudnnTensorStruct xDesc,
                                @Cast("cudnnNormMode_t") int mode,
                                int groupCnt); /* Place hold for future work, should be set to 1 now*/

/** enum deprecated */
public static final int
    CUDNN_NORM_OPS_NORM                = 0, /* do normalization only */
    CUDNN_NORM_OPS_NORM_ACTIVATION     = 1, /* do Norm, then activation */
    CUDNN_NORM_OPS_NORM_ADD_ACTIVATION = 2; /* do Norm, then elemWiseAdd, then activation */

/*
 * Performs Normalization during Inference:
 * y[i] = normScale[k]*(x[i]-estimatedMean[k])/sqrt(epsilon+estimatedVariance[k]) + normBias[k]
 * with normScale, normBias, runningMean, runningInvVariance tensors indexed
 * according to per-channel or per-activation mode. Refer to cudnnNormalizationForwardTraining
 * above for notes on function arguments.
 */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnNormalizationForwardInference(cudnnContext handle,
                                   @Cast("cudnnNormMode_t") int mode,
                                   @Cast("cudnnNormOps_t") int normOps,
                                   @Cast("cudnnNormAlgo_t") int algo,
                                   @Const Pointer alpha,
                                   @Const Pointer beta,
                                   cudnnTensorStruct xDesc,
                                   @Const Pointer x,
                                   cudnnTensorStruct normScaleBiasDesc,
                                   @Const Pointer normScale,
                                   @Const Pointer normBias,
                                   cudnnTensorStruct normMeanVarDesc,
                                   @Const Pointer estimatedMean,
                                   @Const Pointer estimatedVariance,
                                   cudnnTensorStruct zDesc,
                                   @Const Pointer z,
                                   cudnnActivationStruct activationDesc,
                                   cudnnTensorStruct yDesc,
                                   Pointer y,
                                   double epsilon,
                                   int groupCnt); /* Place hold for future work*/

/* APIs for spatial transformer network*/
/** enum cudnnSamplerType_t */
public static final int
    CUDNN_SAMPLER_BILINEAR = 0;

public static native @Cast("cudnnStatus_t") int cudnnCreateSpatialTransformerDescriptor(@ByPtrPtr cudnnSpatialTransformerStruct stDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetSpatialTransformerNdDescriptor(cudnnSpatialTransformerStruct stDesc,
                                       @Cast("cudnnSamplerType_t") int samplerType,
                                       @Cast("cudnnDataType_t") int dataType,
                                       int nbDims,
                                       @Const IntPointer dimA);
public static native @Cast("cudnnStatus_t") int cudnnSetSpatialTransformerNdDescriptor(cudnnSpatialTransformerStruct stDesc,
                                       @Cast("cudnnSamplerType_t") int samplerType,
                                       @Cast("cudnnDataType_t") int dataType,
                                       int nbDims,
                                       @Const IntBuffer dimA);
public static native @Cast("cudnnStatus_t") int cudnnSetSpatialTransformerNdDescriptor(cudnnSpatialTransformerStruct stDesc,
                                       @Cast("cudnnSamplerType_t") int samplerType,
                                       @Cast("cudnnDataType_t") int dataType,
                                       int nbDims,
                                       @Const int[] dimA);

public static native @Cast("cudnnStatus_t") int cudnnDestroySpatialTransformerDescriptor(cudnnSpatialTransformerStruct stDesc);

public static native @Cast("cudnnStatus_t") int cudnnSpatialTfGridGeneratorForward(cudnnContext handle,
                                   cudnnSpatialTransformerStruct stDesc,
                                   @Const Pointer theta,
                                   Pointer grid);

public static native @Cast("cudnnStatus_t") int cudnnSpatialTfSamplerForward(cudnnContext handle,
                             cudnnSpatialTransformerStruct stDesc,
                             @Const Pointer alpha,
                             cudnnTensorStruct xDesc,
                             @Const Pointer x,
                             @Const Pointer grid,
                             @Const Pointer beta,
                             cudnnTensorStruct yDesc,
                             Pointer y);
// Targeting ..\cudnn\cudnnDropoutStruct.java



public static native @Cast("cudnnStatus_t") int cudnnCreateDropoutDescriptor(@ByPtrPtr cudnnDropoutStruct dropoutDesc);

public static native @Cast("cudnnStatus_t") int cudnnDestroyDropoutDescriptor(cudnnDropoutStruct dropoutDesc);

/*helper function to determine size of the states to be passed to cudnnSetDropoutDescriptor */
public static native @Cast("cudnnStatus_t") int cudnnDropoutGetStatesSize(cudnnContext handle, @Cast("size_t*") SizeTPointer sizeInBytes);

/*helper function to determine size of the reserve space to be passed to dropout forward/backward calls */
public static native @Cast("cudnnStatus_t") int cudnnDropoutGetReserveSpaceSize(cudnnTensorStruct xdesc, @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnSetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          float dropout,
                          Pointer states,
                          @Cast("size_t") long stateSizeInBytes,
                          @Cast("unsigned long long") long seed);

/* Restores the dropout descriptor to a previously saved-off state */
public static native @Cast("cudnnStatus_t") int cudnnRestoreDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                              cudnnContext handle,
                              float dropout,
                              Pointer states,
                              @Cast("size_t") long stateSizeInBytes,
                              @Cast("unsigned long long") long seed);

public static native @Cast("cudnnStatus_t") int cudnnGetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          FloatPointer dropout,
                          @Cast("void**") PointerPointer states,
                          @Cast("unsigned long long*") LongPointer seed);
public static native @Cast("cudnnStatus_t") int cudnnGetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          FloatPointer dropout,
                          @Cast("void**") @ByPtrPtr Pointer states,
                          @Cast("unsigned long long*") LongPointer seed);
public static native @Cast("cudnnStatus_t") int cudnnGetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          FloatBuffer dropout,
                          @Cast("void**") @ByPtrPtr Pointer states,
                          @Cast("unsigned long long*") LongBuffer seed);
public static native @Cast("cudnnStatus_t") int cudnnGetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          float[] dropout,
                          @Cast("void**") @ByPtrPtr Pointer states,
                          @Cast("unsigned long long*") long[] seed);

public static native @Cast("cudnnStatus_t") int cudnnDropoutForward(cudnnContext handle,
                    cudnnDropoutStruct dropoutDesc,
                    cudnnTensorStruct xdesc,
                    @Const Pointer x,
                    cudnnTensorStruct ydesc,
                    Pointer y,
                    Pointer reserveSpace,
                    @Cast("size_t") long reserveSpaceSizeInBytes);

/* TODO: move these enums out to the appropriate submodule */
/** enum cudnnConvolutionFwdAlgo_t */
public static final int
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_GEMM         = 0,
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_PRECOMP_GEMM = 1,
    CUDNN_CONVOLUTION_FWD_ALGO_GEMM                  = 2,
    CUDNN_CONVOLUTION_FWD_ALGO_DIRECT                = 3,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT                   = 4,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT_TILING            = 5,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD              = 6,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD_NONFUSED     = 7,
    CUDNN_CONVOLUTION_FWD_ALGO_COUNT                 = 8;

/** enum cudnnConvolutionBwdFilterAlgo_t */
public static final int
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_0                 = 0, /* non-deterministic */
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_1                 = 1,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT               = 2,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_3                 = 3, /* non-deterministic */
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD          = 4, /* not implemented */
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT_TILING        = 6,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_COUNT             = 7;

/** enum cudnnConvolutionBwdDataAlgo_t */
public static final int
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_0                 = 0, /* non-deterministic */
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_1                 = 1,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT               = 2,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT_TILING        = 3,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD          = 4,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_COUNT             = 6;

/** enum cudnnCTCLossAlgo_t */
public static final int CUDNN_CTC_LOSS_ALGO_DETERMINISTIC = 0, CUDNN_CTC_LOSS_ALGO_NON_DETERMINISTIC = 1;

/*
 * \brief Cross-library version checker.
 * This function is implemented differently in each sub-library. Each sublib
 * checks whether its own version matches that of its dependencies.
 * \returns CUDNN_STATUS_SUCCESS if the version check passes,
 *          CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH if the versions are inconsistent.
 */
public static native @Cast("cudnnStatus_t") int cudnnOpsVersionCheck();

/* Function to perform backward softmax */
public static native @Cast("cudnnStatus_t") int cudnnSoftmaxBackward(cudnnContext handle,
                     @Cast("cudnnSoftmaxAlgorithm_t") int algo,
                     @Cast("cudnnSoftmaxMode_t") int mode,
                     @Const Pointer alpha,
                     cudnnTensorStruct yDesc,
                     @Const Pointer y,
                     cudnnTensorStruct dyDesc,
                     @Const Pointer dy,
                     @Const Pointer beta,
                     cudnnTensorStruct dxDesc,
                     Pointer dx);

/* Function to perform backward pooling */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnPoolingBackward(cudnnContext handle,
                     cudnnPoolingStruct poolingDesc,
                     @Const Pointer alpha,
                     cudnnTensorStruct yDesc,
                     @Const Pointer y,
                     cudnnTensorStruct dyDesc,
                     @Const Pointer dy,
                     cudnnTensorStruct xDesc,
                     @Const Pointer x,
                     @Const Pointer beta,
                     cudnnTensorStruct dxDesc,
                     Pointer dx);

/* Function to perform backward activation  */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnActivationBackward(cudnnContext handle,
                        cudnnActivationStruct activationDesc,
                        @Const Pointer alpha,
                        cudnnTensorStruct yDesc,
                        @Const Pointer y,
                        cudnnTensorStruct dyDesc,
                        @Const Pointer dy,
                        cudnnTensorStruct xDesc,
                        @Const Pointer x,
                        @Const Pointer beta,
                        cudnnTensorStruct dxDesc,
                        Pointer dx);

/* LRN cross-channel backward computation. Double parameters cast to tensor data type */
public static native @Cast("cudnnStatus_t") int cudnnLRNCrossChannelBackward(cudnnContext handle,
                             cudnnLRNStruct normDesc,
                             @Cast("cudnnLRNMode_t") int lrnMode,
                             @Const Pointer alpha,
                             cudnnTensorStruct yDesc,
                             @Const Pointer y,
                             cudnnTensorStruct dyDesc,
                             @Const Pointer dy,
                             cudnnTensorStruct xDesc,
                             @Const Pointer x,
                             @Const Pointer beta,
                             cudnnTensorStruct dxDesc,
                             Pointer dx);

public static native @Cast("cudnnStatus_t") int cudnnDivisiveNormalizationBackward(cudnnContext handle,
                                   cudnnLRNStruct normDesc,
                                   @Cast("cudnnDivNormMode_t") int mode,
                                   @Const Pointer alpha,
                                   cudnnTensorStruct xDesc,
                                   @Const Pointer x,
                                   @Const Pointer means,
                                   @Const Pointer dy,
                                   Pointer temp,
                                   Pointer temp2,
                                   @Const Pointer beta,
                                   cudnnTensorStruct dXdMeansDesc,
                                   Pointer dx,
                                   Pointer dMeans); /* output means differential, can be NULL */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize(cudnnContext handle,
                                                         @Cast("cudnnBatchNormMode_t") int mode,
                                                         @Cast("cudnnBatchNormOps_t") int bnOps,
                                                         cudnnTensorStruct xDesc,
                                                         cudnnTensorStruct zDesc,
                                                         cudnnTensorStruct yDesc,
                                                         cudnnTensorStruct bnScaleBiasMeanVarDesc,
                                                         cudnnActivationStruct activationDesc,
                                                         @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetBatchNormalizationBackwardExWorkspaceSize(cudnnContext handle,
                                                  @Cast("cudnnBatchNormMode_t") int mode,
                                                  @Cast("cudnnBatchNormOps_t") int bnOps,
                                                  cudnnTensorStruct xDesc,
                                                  cudnnTensorStruct yDesc,
                                                  cudnnTensorStruct dyDesc,
                                                  cudnnTensorStruct dzDesc,
                                                  cudnnTensorStruct dxDesc,
                                                  cudnnTensorStruct dBnScaleBiasDesc,
                                                  cudnnActivationStruct activationDesc,
                                                  @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetBatchNormalizationTrainingExReserveSpaceSize(cudnnContext handle,
                                                     @Cast("cudnnBatchNormMode_t") int mode,
                                                     @Cast("cudnnBatchNormOps_t") int bnOps,
                                                     cudnnActivationStruct activationDesc,
                                                     cudnnTensorStruct xDesc,
                                                     @Cast("size_t*") SizeTPointer sizeInBytes);

/* Computes y = BN(x). Also accumulates moving averages of mean and inverse variances */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnBatchNormalizationForwardTraining(
    cudnnContext handle,
    @Cast("cudnnBatchNormMode_t") int mode,

    @Const Pointer alpha,
    @Const Pointer beta,

    cudnnTensorStruct xDesc,
    @Const Pointer x,
    cudnnTensorStruct yDesc,
    Pointer y,
    cudnnTensorStruct bnScaleBiasMeanVarDesc,
    @Const Pointer bnScale,
    @Const Pointer bnBias,
    double exponentialAverageFactor,
    Pointer resultRunningMean,
    Pointer resultRunningVariance,
    double epsilon,
    Pointer resultSaveMean,
    Pointer resultSaveInvVariance);

/* Computes y = relu(BN(x) + z). Also accumulates moving averages of mean and inverse variances */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnBatchNormalizationForwardTrainingEx(
    cudnnContext handle,
    @Cast("cudnnBatchNormMode_t") int mode,
    @Cast("cudnnBatchNormOps_t") int bnOps,

    @Const Pointer alpha,
    @Const Pointer beta,

    cudnnTensorStruct xDesc,
    @Const Pointer xData,
    cudnnTensorStruct zDesc,
    @Const Pointer zData,
    cudnnTensorStruct yDesc,
    Pointer yData,

    cudnnTensorStruct bnScaleBiasMeanVarDesc,
    @Const Pointer bnScale,
    @Const Pointer bnBias,

    double exponentialAverageFactor,
    Pointer resultRunningMean,
    Pointer resultRunningVariance,
    double epsilon,
    Pointer resultSaveMean,
    Pointer resultSaveInvVariance,

    cudnnActivationStruct activationDesc,
    Pointer workspace,
    @Cast("size_t") long workSpaceSizeInBytes,
    Pointer reserveSpace,
    @Cast("size_t") long reserveSpaceSizeInBytes);

/* Performs backward pass of Batch Normalization layer. Returns x gradient,
 * bnScale gradient and bnBias gradient */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnBatchNormalizationBackward(cudnnContext handle,
                                @Cast("cudnnBatchNormMode_t") int mode,
                                @Const Pointer alphaDataDiff,
                                @Const Pointer betaDataDiff,
                                @Const Pointer alphaParamDiff,
                                @Const Pointer betaParamDiff,
                                cudnnTensorStruct xDesc,
                                @Const Pointer x,
                                cudnnTensorStruct dyDesc,
                                @Const Pointer dy,
                                cudnnTensorStruct dxDesc,
                                Pointer dx,
                                cudnnTensorStruct dBnScaleBiasDesc,
                                @Const Pointer bnScale,
                                Pointer dBnScaleResult,
                                Pointer dBnBiasResult,
                                double epsilon,
                                @Const Pointer savedMean,
                                @Const Pointer savedInvVariance);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnBatchNormalizationBackwardEx(cudnnContext handle,
                                  @Cast("cudnnBatchNormMode_t") int mode,
                                  @Cast("cudnnBatchNormOps_t") int bnOps,

                                  @Const Pointer alphaDataDiff,
                                  @Const Pointer betaDataDiff,
                                  @Const Pointer alphaParamDiff,
                                  @Const Pointer betaParamDiff,
                                  cudnnTensorStruct xDesc,
                                  @Const Pointer xData,
                                  cudnnTensorStruct yDesc,
                                  @Const Pointer yData,
                                  cudnnTensorStruct dyDesc,
                                  @Const Pointer dyData,
                                  cudnnTensorStruct dzDesc,
                                  Pointer dzData,
                                  cudnnTensorStruct dxDesc,
                                  Pointer dxData,
                                  cudnnTensorStruct dBnScaleBiasDesc,
                                  @Const Pointer bnScaleData,
                                  @Const Pointer bnBiasData,
                                  Pointer dBnScaleData,
                                  Pointer dBnBiasData,
                                  double epsilon,
                                  @Const Pointer savedMean,
                                  @Const Pointer savedInvVariance,
                                  cudnnActivationStruct activationDesc,
                                  Pointer workSpace,
                                  @Cast("size_t") long workSpaceSizeInBytes,
                                  Pointer reserveSpace,
                                  @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetNormalizationForwardTrainingWorkspaceSize(cudnnContext handle,
                                                  @Cast("cudnnNormMode_t") int mode,
                                                  @Cast("cudnnNormOps_t") int normOps,
                                                  @Cast("cudnnNormAlgo_t") int algo,
                                                  cudnnTensorStruct xDesc,
                                                  cudnnTensorStruct zDesc,
                                                  cudnnTensorStruct yDesc,
                                                  cudnnTensorStruct normScaleBiasDesc,
                                                  cudnnActivationStruct activationDesc,
                                                  cudnnTensorStruct normMeanVarDesc,
                                                  @Cast("size_t*") SizeTPointer sizeInBytes,
                                                  int groupCnt); /* Place hold for future work, should be set to 1 now*/

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetNormalizationBackwardWorkspaceSize(cudnnContext handle,
                                           @Cast("cudnnNormMode_t") int mode,
                                           @Cast("cudnnNormOps_t") int normOps,
                                           @Cast("cudnnNormAlgo_t") int algo,
                                           cudnnTensorStruct xDesc,
                                           cudnnTensorStruct yDesc,
                                           cudnnTensorStruct dyDesc,
                                           cudnnTensorStruct dzDesc,
                                           cudnnTensorStruct dxDesc,
                                           cudnnTensorStruct dNormScaleBiasDesc,
                                           cudnnActivationStruct activationDesc,
                                           cudnnTensorStruct normMeanVarDesc,
                                           @Cast("size_t*") SizeTPointer sizeInBytes,
                                           int groupCnt); /* Place hold for future work, should be set to 1 now*/

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetNormalizationTrainingReserveSpaceSize(cudnnContext handle,
                                              @Cast("cudnnNormMode_t") int mode,
                                              @Cast("cudnnNormOps_t") int normOps,
                                              @Cast("cudnnNormAlgo_t") int algo,
                                              cudnnActivationStruct activationDesc,
                                              cudnnTensorStruct xDesc,
                                              @Cast("size_t*") SizeTPointer sizeInBytes,
                                              int groupCnt); /* Place hold for future work, should be set to 1 now*/

/* Computes y = relu(Norm(x) + z). Also accumulates moving averages of mean and inverse variances */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnNormalizationForwardTraining(cudnnContext handle,
                                  @Cast("cudnnNormMode_t") int mode,
                                  @Cast("cudnnNormOps_t") int normOps,
                                  @Cast("cudnnNormAlgo_t") int algo,
                                  @Const Pointer alpha,
                                  @Const Pointer beta,
                                  cudnnTensorStruct xDesc,
                                  @Const Pointer xData,
                                  cudnnTensorStruct normScaleBiasDesc,
                                  @Const Pointer normScale,
                                  @Const Pointer normBias,
                                  double exponentialAverageFactor,
                                  cudnnTensorStruct normMeanVarDesc,
                                  Pointer resultRunningMean,
                                  Pointer resultRunningVariance,
                                  double epsilon,
                                  Pointer resultSaveMean,
                                  Pointer resultSaveInvVariance,
                                  cudnnActivationStruct activationDesc,
                                  cudnnTensorStruct zDesc,
                                  @Const Pointer zData,
                                  cudnnTensorStruct yDesc,
                                  Pointer yData,
                                  Pointer workspace,
                                  @Cast("size_t") long workSpaceSizeInBytes,
                                  Pointer reserveSpace,
                                  @Cast("size_t") long reserveSpaceSizeInBytes,
                                  int groupCnt); /* Place hold for future work, should be set to 1 now*/

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnNormalizationBackward(cudnnContext handle,
                           @Cast("cudnnNormMode_t") int mode,
                           @Cast("cudnnNormOps_t") int normOps,
                           @Cast("cudnnNormAlgo_t") int algo,
                           @Const Pointer alphaDataDiff,
                           @Const Pointer betaDataDiff,
                           @Const Pointer alphaParamDiff,
                           @Const Pointer betaParamDiff,
                           cudnnTensorStruct xDesc,
                           @Const Pointer xData,
                           cudnnTensorStruct yDesc,
                           @Const Pointer yData,
                           cudnnTensorStruct dyDesc,
                           @Const Pointer dyData,
                           cudnnTensorStruct dzDesc,
                           Pointer dzData,
                           cudnnTensorStruct dxDesc,
                           Pointer dxData,
                           cudnnTensorStruct dNormScaleBiasDesc,
                           @Const Pointer normScaleData,
                           @Const Pointer normBiasData,
                           Pointer dNormScaleData,
                           Pointer dNormBiasData,
                           double epsilon,
                           cudnnTensorStruct normMeanVarDesc,
                           @Const Pointer savedMean,
                           @Const Pointer savedInvVariance,
                           cudnnActivationStruct activationDesc,
                           Pointer workSpace,
                           @Cast("size_t") long workSpaceSizeInBytes,
                           Pointer reserveSpace,
                           @Cast("size_t") long reserveSpaceSizeInBytes,
                           int groupCnt); /* Place hold for future work, should be set to 1 now*/

public static native @Cast("cudnnStatus_t") int cudnnSpatialTfGridGeneratorBackward(cudnnContext handle,
                                    cudnnSpatialTransformerStruct stDesc,
                                    @Const Pointer dgrid,
                                    Pointer dtheta);

public static native @Cast("cudnnStatus_t") int cudnnSpatialTfSamplerBackward(cudnnContext handle,
                              cudnnSpatialTransformerStruct stDesc,
                              @Const Pointer alpha,
                              cudnnTensorStruct xDesc,
                              @Const Pointer x,
                              @Const Pointer beta,
                              cudnnTensorStruct dxDesc,
                              Pointer dx,
                              @Const Pointer alphaDgrid,
                              cudnnTensorStruct dyDesc,
                              @Const Pointer dy,
                              @Const Pointer grid,
                              @Const Pointer betaDgrid,
                              Pointer dgrid);

public static native @Cast("cudnnStatus_t") int cudnnDropoutBackward(cudnnContext handle,
                     cudnnDropoutStruct dropoutDesc,
                     cudnnTensorStruct dydesc,
                     @Const Pointer dy,
                     cudnnTensorStruct dxdesc,
                     Pointer dx,
                     Pointer reserveSpace,
                     @Cast("size_t") long reserveSpaceSizeInBytes);

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_OPS_H_ */


// Parsed from <cudnn_adv.h>

/*
 * Copyright 2014-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*   cudnn_adv : cuDNN's advanced and experimental features.

*/

// #if !defined(CUDNN_ADV_H_)
// #define CUDNN_ADV_H_

// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_ops.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_ADV_MAJOR = 9;
public static final int CUDNN_ADV_MINOR = 10;
public static final int CUDNN_ADV_PATCH = 2;

// #if (CUDNN_ADV_MAJOR != CUDNN_MAJOR) || (CUDNN_ADV_MINOR != CUDNN_MINOR) || (CUDNN_ADV_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN ADV INFER!!!
// #endif

// #if defined(__cplusplus)
// #endif

/* BASIC RNN API */

/** enum cudnnRNNAlgo_t */
public static final int
    CUDNN_RNN_ALGO_STANDARD               = 0,
    CUDNN_RNN_ALGO_PERSIST_STATIC         = 1,
    CUDNN_RNN_ALGO_PERSIST_DYNAMIC        = 2,
    CUDNN_RNN_ALGO_PERSIST_STATIC_SMALL_H = 3,
    CUDNN_RNN_ALGO_COUNT                  = 4;

/** enum cudnnForwardMode_t */
public static final int
    CUDNN_FWD_MODE_INFERENCE = 0,
    CUDNN_FWD_MODE_TRAINING  = 1;

/** enum cudnnRNNMode_t */
public static final int
    CUDNN_RNN_RELU = 0, /* basic RNN cell type with ReLu activation */
    CUDNN_RNN_TANH = 1, /* basic RNN cell type with tanh activation */
    CUDNN_LSTM     = 2, /* LSTM with optional recurrent projection and clipping */
    CUDNN_GRU      = 3; /* Using h' = tanh(r * Uh(t-1) + Wx) and h = (1 - z) * h' + z * h(t-1); */

/** enum cudnnRNNBiasMode_t */
public static final int
    CUDNN_RNN_NO_BIAS         = 0, /* rnn cell formulas do not use biases */
    CUDNN_RNN_SINGLE_INP_BIAS = 1, /* rnn cell formulas use one input bias in input GEMM */
    CUDNN_RNN_DOUBLE_BIAS     = 2, /* default, rnn cell formulas use two bias vectors */
    CUDNN_RNN_SINGLE_REC_BIAS = 3;  /* rnn cell formulas use one recurrent bias in recurrent GEMM */

/** enum cudnnDirectionMode_t */
public static final int
    CUDNN_UNIDIRECTIONAL = 0, /* single direction network */
    CUDNN_BIDIRECTIONAL  = 1; /* output concatination at each layer */

/** enum cudnnRNNInputMode_t */
public static final int
    CUDNN_LINEAR_INPUT = 0, /* adjustable weight matrix in first layer input GEMM */
    CUDNN_SKIP_INPUT   = 1; /* fixed identity matrix in the first layer input GEMM */

/** enum cudnnRNNClipMode_t */
public static final int
    CUDNN_RNN_CLIP_NONE   = 0, /* disables LSTM cell clipping */
    CUDNN_RNN_CLIP_MINMAX = 1; /* enables LSTM cell clipping */

/** enum cudnnRNNDataLayout_t */
public static final int
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_UNPACKED   = 0, /* padded, outer stride from one time-step to the next */
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_PACKED     = 1, /* sequence length sorted and packed as in basic RNN api */
    CUDNN_RNN_DATA_LAYOUT_BATCH_MAJOR_UNPACKED = 2; /* padded, outer stride from one batch to the next */

/* For auxFlags in cudnnSetRNNDescriptor_v8() */
public static final int CUDNN_RNN_PADDED_IO_DISABLED = 0;
public static final int CUDNN_RNN_PADDED_IO_ENABLED = (1 << 0);
// Targeting ..\cudnn\cudnnRNNStruct.java


// Targeting ..\cudnn\cudnnRNNDataStruct.java



public static native @Cast("cudnnStatus_t") int cudnnCreateRNNDescriptor(@ByPtrPtr cudnnRNNStruct rnnDesc);

public static native @Cast("cudnnStatus_t") int cudnnDestroyRNNDescriptor(cudnnRNNStruct rnnDesc);

/*
 * mathPrec in cudnnSetRNNDescriptor_v8() specifies compute precision.
 * Compute precision is further modified by mathType that sets the
 * preferred option for using NVIDIA Tensor Cores.  dataType specify
 * input/output data type and weight/bias type.
 */

public static native @Cast("cudnnStatus_t") int cudnnSetRNNDescriptor_v8(cudnnRNNStruct rnnDesc,
                         @Cast("cudnnRNNAlgo_t") int algo,
                         @Cast("cudnnRNNMode_t") int cellMode,
                         @Cast("cudnnRNNBiasMode_t") int biasMode,
                         @Cast("cudnnDirectionMode_t") int dirMode,
                         @Cast("cudnnRNNInputMode_t") int inputMode,
                         @Cast("cudnnDataType_t") int dataType,
                         @Cast("cudnnDataType_t") int mathPrec,
                         @Cast("cudnnMathType_t") int mathType,
                         int inputSize,
                         int hiddenSize,
                         int projSize,
                         int numLayers,
                         cudnnDropoutStruct dropoutDesc,
                         @Cast("uint32_t") int auxFlags);

public static native @Cast("cudnnStatus_t") int cudnnGetRNNDescriptor_v8(cudnnRNNStruct rnnDesc,
                         @Cast("cudnnRNNAlgo_t*") IntPointer algo,
                         @Cast("cudnnRNNMode_t*") IntPointer cellMode,
                         @Cast("cudnnRNNBiasMode_t*") IntPointer biasMode,
                         @Cast("cudnnDirectionMode_t*") IntPointer dirMode,
                         @Cast("cudnnRNNInputMode_t*") IntPointer inputMode,
                         @Cast("cudnnDataType_t*") IntPointer dataType,
                         @Cast("cudnnDataType_t*") IntPointer mathPrec,
                         @Cast("cudnnMathType_t*") IntPointer mathType,
                         IntPointer inputSize,
                         IntPointer hiddenSize,
                         IntPointer projSize,
                         IntPointer numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("uint32_t*") IntPointer auxFlags);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNDescriptor_v8(cudnnRNNStruct rnnDesc,
                         @Cast("cudnnRNNAlgo_t*") IntBuffer algo,
                         @Cast("cudnnRNNMode_t*") IntBuffer cellMode,
                         @Cast("cudnnRNNBiasMode_t*") IntBuffer biasMode,
                         @Cast("cudnnDirectionMode_t*") IntBuffer dirMode,
                         @Cast("cudnnRNNInputMode_t*") IntBuffer inputMode,
                         @Cast("cudnnDataType_t*") IntBuffer dataType,
                         @Cast("cudnnDataType_t*") IntBuffer mathPrec,
                         @Cast("cudnnMathType_t*") IntBuffer mathType,
                         IntBuffer inputSize,
                         IntBuffer hiddenSize,
                         IntBuffer projSize,
                         IntBuffer numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("uint32_t*") IntBuffer auxFlags);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNDescriptor_v8(cudnnRNNStruct rnnDesc,
                         @Cast("cudnnRNNAlgo_t*") int[] algo,
                         @Cast("cudnnRNNMode_t*") int[] cellMode,
                         @Cast("cudnnRNNBiasMode_t*") int[] biasMode,
                         @Cast("cudnnDirectionMode_t*") int[] dirMode,
                         @Cast("cudnnRNNInputMode_t*") int[] inputMode,
                         @Cast("cudnnDataType_t*") int[] dataType,
                         @Cast("cudnnDataType_t*") int[] mathPrec,
                         @Cast("cudnnMathType_t*") int[] mathType,
                         int[] inputSize,
                         int[] hiddenSize,
                         int[] projSize,
                         int[] numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("uint32_t*") int[] auxFlags);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNSetClip_v8(cudnnRNNStruct rnnDesc,
                   @Cast("cudnnRNNClipMode_t") int clipMode,
                   @Cast("cudnnNanPropagation_t") int clipNanOpt,
                   double lclip,
                   double rclip);

public static native @Cast("cudnnStatus_t") int cudnnRNNSetClip_v9(cudnnRNNStruct rnnDesc, @Cast("cudnnRNNClipMode_t") int clipMode, double lclip, double rclip);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNGetClip_v8(cudnnRNNStruct rnnDesc,
                   @Cast("cudnnRNNClipMode_t*") IntPointer clipMode,
                   @Cast("cudnnNanPropagation_t*") IntPointer clipNanOpt,
                   DoublePointer lclip,
                   DoublePointer rclip);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNGetClip_v8(cudnnRNNStruct rnnDesc,
                   @Cast("cudnnRNNClipMode_t*") IntBuffer clipMode,
                   @Cast("cudnnNanPropagation_t*") IntBuffer clipNanOpt,
                   DoubleBuffer lclip,
                   DoubleBuffer rclip);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNGetClip_v8(cudnnRNNStruct rnnDesc,
                   @Cast("cudnnRNNClipMode_t*") int[] clipMode,
                   @Cast("cudnnNanPropagation_t*") int[] clipNanOpt,
                   double[] lclip,
                   double[] rclip);

public static native @Cast("cudnnStatus_t") int cudnnRNNGetClip_v9(cudnnRNNStruct rnnDesc, @Cast("cudnnRNNClipMode_t*") IntPointer clipMode, DoublePointer lclip, DoublePointer rclip);
public static native @Cast("cudnnStatus_t") int cudnnRNNGetClip_v9(cudnnRNNStruct rnnDesc, @Cast("cudnnRNNClipMode_t*") IntBuffer clipMode, DoubleBuffer lclip, DoubleBuffer rclip);
public static native @Cast("cudnnStatus_t") int cudnnRNNGetClip_v9(cudnnRNNStruct rnnDesc, @Cast("cudnnRNNClipMode_t*") int[] clipMode, double[] lclip, double[] rclip);

public static native @Cast("cudnnStatus_t") int cudnnBuildRNNDynamic(cudnnContext handle, cudnnRNNStruct rnnDesc, int miniBatch);

public static native @Cast("cudnnStatus_t") int cudnnGetRNNTempSpaceSizes(cudnnContext handle,
                          cudnnRNNStruct rnnDesc,
                          @Cast("cudnnForwardMode_t") int fwdMode,
                          cudnnRNNDataStruct xDesc,
                          @Cast("size_t*") SizeTPointer workSpaceSize,
                          @Cast("size_t*") SizeTPointer reserveSpaceSize);

public static native @Cast("cudnnStatus_t") int cudnnGetRNNWeightSpaceSize(cudnnContext handle, cudnnRNNStruct rnnDesc, @Cast("size_t*") SizeTPointer weightSpaceSize);

public static native @Cast("cudnnStatus_t") int cudnnGetRNNWeightParams(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        int pseudoLayer,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        int linLayerID,
                        cudnnTensorStruct mDesc,
                        @Cast("void**") PointerPointer mAddr,
                        cudnnTensorStruct bDesc,
                        @Cast("void**") PointerPointer bAddr);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNWeightParams(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        int pseudoLayer,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        int linLayerID,
                        cudnnTensorStruct mDesc,
                        @Cast("void**") @ByPtrPtr Pointer mAddr,
                        cudnnTensorStruct bDesc,
                        @Cast("void**") @ByPtrPtr Pointer bAddr);

public static native @Cast("cudnnStatus_t") int cudnnCreateRNNDataDescriptor(@ByPtrPtr cudnnRNNDataStruct rnnDataDesc);

public static native @Cast("cudnnStatus_t") int cudnnDestroyRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          @Cast("cudnnRNNDataLayout_t") int layout,
                          int maxSeqLength,
                          int batchSize,
                          int vectorSize,
                          @Const IntPointer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnSetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          @Cast("cudnnRNNDataLayout_t") int layout,
                          int maxSeqLength,
                          int batchSize,
                          int vectorSize,
                          @Const IntBuffer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnSetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          @Cast("cudnnRNNDataLayout_t") int layout,
                          int maxSeqLength,
                          int batchSize,
                          int vectorSize,
                          @Const int[] seqLengthArray,
                          Pointer paddingFill);         /* symbol for filling padding position in output */

public static native @Cast("cudnnStatus_t") int cudnnGetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t*") IntPointer dataType,
                          @Cast("cudnnRNNDataLayout_t*") IntPointer layout,
                          IntPointer maxSeqLength,
                          IntPointer batchSize,
                          IntPointer vectorSize,
                          int arrayLengthRequested,
                          IntPointer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t*") IntBuffer dataType,
                          @Cast("cudnnRNNDataLayout_t*") IntBuffer layout,
                          IntBuffer maxSeqLength,
                          IntBuffer batchSize,
                          IntBuffer vectorSize,
                          int arrayLengthRequested,
                          IntBuffer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t*") int[] dataType,
                          @Cast("cudnnRNNDataLayout_t*") int[] layout,
                          int[] maxSeqLength,
                          int[] batchSize,
                          int[] vectorSize,
                          int arrayLengthRequested,
                          int[] seqLengthArray,
                          Pointer paddingFill);

public static native @Cast("cudnnStatus_t") int cudnnRNNForward(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnForwardMode_t") int fwdMode,
                @Const IntPointer devSeqLengths,
                cudnnRNNDataStruct xDesc,
                @Const Pointer x,
                cudnnRNNDataStruct yDesc,
                Pointer y,
                cudnnTensorStruct hDesc,
                @Const Pointer hx,
                Pointer hy,
                cudnnTensorStruct cDesc,
                @Const Pointer cx,
                Pointer cy,
                @Cast("size_t") long weightSpaceSize,
                @Const Pointer weightSpace,
                @Cast("size_t") long workSpaceSize,
                Pointer workSpace,
                @Cast("size_t") long reserveSpaceSize,
                Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNForward(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnForwardMode_t") int fwdMode,
                @Const IntBuffer devSeqLengths,
                cudnnRNNDataStruct xDesc,
                @Const Pointer x,
                cudnnRNNDataStruct yDesc,
                Pointer y,
                cudnnTensorStruct hDesc,
                @Const Pointer hx,
                Pointer hy,
                cudnnTensorStruct cDesc,
                @Const Pointer cx,
                Pointer cy,
                @Cast("size_t") long weightSpaceSize,
                @Const Pointer weightSpace,
                @Cast("size_t") long workSpaceSize,
                Pointer workSpace,
                @Cast("size_t") long reserveSpaceSize,
                Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNForward(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnForwardMode_t") int fwdMode,
                @Const int[] devSeqLengths,
                cudnnRNNDataStruct xDesc,
                @Const Pointer x,
                cudnnRNNDataStruct yDesc,
                Pointer y,
                cudnnTensorStruct hDesc,
                @Const Pointer hx,
                Pointer hy,
                cudnnTensorStruct cDesc,
                @Const Pointer cx,
                Pointer cy,
                @Cast("size_t") long weightSpaceSize,
                @Const Pointer weightSpace,
                @Cast("size_t") long workSpaceSize,
                Pointer workSpace,
                @Cast("size_t") long reserveSpaceSize,
                Pointer reserveSpace);

/* Sequence data descriptor */

/** enum cudnnSeqDataAxis_t */
public static final int
    CUDNN_SEQDATA_TIME_DIM  = 0, /* index in time */
    CUDNN_SEQDATA_BATCH_DIM = 1, /* index in batch */
    CUDNN_SEQDATA_BEAM_DIM  = 2, /* index in beam */
    CUDNN_SEQDATA_VECT_DIM  = 3;  /* index in vector */
// Targeting ..\cudnn\cudnnSeqDataStruct.java



public static final int CUDNN_SEQDATA_DIM_COUNT = 4; /* dimension count */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateSeqDataDescriptor(@ByPtrPtr cudnnSeqDataStruct seqDataDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroySeqDataDescriptor(cudnnSeqDataStruct seqDataDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          int nbDims,
                          @Const IntPointer dimA,
                          @Cast("const cudnnSeqDataAxis_t*") IntPointer axes,
                          @Cast("size_t") long seqLengthArraySize,
                          @Const IntPointer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          int nbDims,
                          @Const IntBuffer dimA,
                          @Cast("const cudnnSeqDataAxis_t*") IntBuffer axes,
                          @Cast("size_t") long seqLengthArraySize,
                          @Const IntBuffer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          int nbDims,
                          @Const int[] dimA,
                          @Cast("const cudnnSeqDataAxis_t*") int[] axes,
                          @Cast("size_t") long seqLengthArraySize,
                          @Const int[] seqLengthArray,
                          Pointer paddingFill);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t*") IntPointer dataType,
                          IntPointer nbDims,
                          int nbDimsRequested,
                          IntPointer dimA,
                          @Cast("cudnnSeqDataAxis_t*") IntPointer axes,
                          @Cast("size_t*") SizeTPointer seqLengthArraySize,
                          @Cast("size_t") long seqLengthSizeRequested,
                          IntPointer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t*") IntBuffer dataType,
                          IntBuffer nbDims,
                          int nbDimsRequested,
                          IntBuffer dimA,
                          @Cast("cudnnSeqDataAxis_t*") IntBuffer axes,
                          @Cast("size_t*") SizeTPointer seqLengthArraySize,
                          @Cast("size_t") long seqLengthSizeRequested,
                          IntBuffer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t*") int[] dataType,
                          int[] nbDims,
                          int nbDimsRequested,
                          int[] dimA,
                          @Cast("cudnnSeqDataAxis_t*") int[] axes,
                          @Cast("size_t*") SizeTPointer seqLengthArraySize,
                          @Cast("size_t") long seqLengthSizeRequested,
                          int[] seqLengthArray,
                          Pointer paddingFill);

/* Multihead Attention */

/*
 * Multi-head attention options passed via 'attnMode' in cudnnSetAttnDescriptor().
 * Use the bitwise OR operator to combine several settings listed below.  Additional
 * minor options can be added here w/o changing or introducing new API functions.
 */
public static final int CUDNN_ATTN_QUERYMAP_ALL_TO_ONE = 0;         /* multiple Q-s map to a single (K,V) set when beam size > 1 */
public static final int CUDNN_ATTN_QUERYMAP_ONE_TO_ONE = (1 << 0); /* multiple Q-s map to multiple (K,V) sets when beam size > 1 */
public static final int CUDNN_ATTN_DISABLE_PROJ_BIASES = 0;         /* no biases in attention input and output projections */
public static final int CUDNN_ATTN_ENABLE_PROJ_BIASES = (1 << 1);
// Targeting ..\cudnn\cudnnAttnStruct.java



public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateAttnDescriptor(@ByPtrPtr cudnnAttnStruct attnDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyAttnDescriptor(cudnnAttnStruct attnDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetAttnDescriptor(cudnnAttnStruct attnDesc,
                       @Cast("unsigned") int attnMode,
                       int nHeads,
                       double smScaler,
                       @Cast("cudnnDataType_t") int dataType,
                       @Cast("cudnnDataType_t") int computePrec,
                       @Cast("cudnnMathType_t") int mathType,
                       cudnnDropoutStruct attnDropoutDesc,
                       cudnnDropoutStruct postDropoutDesc,
                       int qSize,
                       int kSize,
                       int vSize,
                       int qProjSize,
                       int kProjSize,
                       int vProjSize,
                       int oProjSize,
                       int qoMaxSeqLength,
                       int kvMaxSeqLength,
                       int maxBatchSize,
                       int maxBeamSize);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetAttnDescriptor(cudnnAttnStruct attnDesc,
                       @Cast("unsigned*") IntPointer attnMode,
                       IntPointer nHeads,
                       DoublePointer smScaler,
                       @Cast("cudnnDataType_t*") IntPointer dataType,
                       @Cast("cudnnDataType_t*") IntPointer computePrec,
                       @Cast("cudnnMathType_t*") IntPointer mathType,
                       @ByPtrPtr cudnnDropoutStruct attnDropoutDesc,
                       @ByPtrPtr cudnnDropoutStruct postDropoutDesc,
                       IntPointer qSize,
                       IntPointer kSize,
                       IntPointer vSize,
                       IntPointer qProjSize,
                       IntPointer kProjSize,
                       IntPointer vProjSize,
                       IntPointer oProjSize,
                       IntPointer qoMaxSeqLength,
                       IntPointer kvMaxSeqLength,
                       IntPointer maxBatchSize,
                       IntPointer maxBeamSize);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetAttnDescriptor(cudnnAttnStruct attnDesc,
                       @Cast("unsigned*") IntBuffer attnMode,
                       IntBuffer nHeads,
                       DoubleBuffer smScaler,
                       @Cast("cudnnDataType_t*") IntBuffer dataType,
                       @Cast("cudnnDataType_t*") IntBuffer computePrec,
                       @Cast("cudnnMathType_t*") IntBuffer mathType,
                       @ByPtrPtr cudnnDropoutStruct attnDropoutDesc,
                       @ByPtrPtr cudnnDropoutStruct postDropoutDesc,
                       IntBuffer qSize,
                       IntBuffer kSize,
                       IntBuffer vSize,
                       IntBuffer qProjSize,
                       IntBuffer kProjSize,
                       IntBuffer vProjSize,
                       IntBuffer oProjSize,
                       IntBuffer qoMaxSeqLength,
                       IntBuffer kvMaxSeqLength,
                       IntBuffer maxBatchSize,
                       IntBuffer maxBeamSize);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetAttnDescriptor(cudnnAttnStruct attnDesc,
                       @Cast("unsigned*") int[] attnMode,
                       int[] nHeads,
                       double[] smScaler,
                       @Cast("cudnnDataType_t*") int[] dataType,
                       @Cast("cudnnDataType_t*") int[] computePrec,
                       @Cast("cudnnMathType_t*") int[] mathType,
                       @ByPtrPtr cudnnDropoutStruct attnDropoutDesc,
                       @ByPtrPtr cudnnDropoutStruct postDropoutDesc,
                       int[] qSize,
                       int[] kSize,
                       int[] vSize,
                       int[] qProjSize,
                       int[] kProjSize,
                       int[] vProjSize,
                       int[] oProjSize,
                       int[] qoMaxSeqLength,
                       int[] kvMaxSeqLength,
                       int[] maxBatchSize,
                       int[] maxBeamSize);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetMultiHeadAttnBuffers(cudnnContext handle,
                             cudnnAttnStruct attnDesc,
                             @Cast("size_t*") SizeTPointer weightSizeInBytes,
                             @Cast("size_t*") SizeTPointer workSpaceSizeInBytes,
                             @Cast("size_t*") SizeTPointer reserveSpaceSizeInBytes);

/** enum cudnnMultiHeadAttnWeightKind_t */
public static final int
    CUDNN_MH_ATTN_Q_WEIGHTS = 0, /* input projection weights for 'queries' */
    CUDNN_MH_ATTN_K_WEIGHTS = 1, /* input projection weights for 'keys' */
    CUDNN_MH_ATTN_V_WEIGHTS = 2, /* input projection weights for 'values' */
    CUDNN_MH_ATTN_O_WEIGHTS = 3, /* output projection weights */
    CUDNN_MH_ATTN_Q_BIASES  = 4, /* input projection bias tensor for 'queries' */
    CUDNN_MH_ATTN_K_BIASES  = 5, /* input projection bias for 'keys' */
    CUDNN_MH_ATTN_V_BIASES  = 6, /* input projection bias for 'values' */
    CUDNN_MH_ATTN_O_BIASES  = 7; /* output projection biases */

public static final int CUDNN_ATTN_WKIND_COUNT = 8; /* Number of attention weight/bias tensors */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetMultiHeadAttnWeights(cudnnContext handle,
                             cudnnAttnStruct attnDesc,
                             @Cast("cudnnMultiHeadAttnWeightKind_t") int wKind,
                             @Cast("size_t") long weightSizeInBytes,
                             @Const Pointer weights,
                             cudnnTensorStruct wDesc,
                             @Cast("void**") PointerPointer wAddr);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetMultiHeadAttnWeights(cudnnContext handle,
                             cudnnAttnStruct attnDesc,
                             @Cast("cudnnMultiHeadAttnWeightKind_t") int wKind,
                             @Cast("size_t") long weightSizeInBytes,
                             @Const Pointer weights,
                             cudnnTensorStruct wDesc,
                             @Cast("void**") @ByPtrPtr Pointer wAddr);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnMultiHeadAttnForward(cudnnContext handle,
                          cudnnAttnStruct attnDesc,
                          int currIdx,
                          @Const IntPointer loWinIdx,
                          @Const IntPointer hiWinIdx,
                          @Const IntPointer devSeqLengthsQO,
                          @Const IntPointer devSeqLengthsKV,
                          cudnnSeqDataStruct qDesc,
                          @Const Pointer queries,
                          @Const Pointer residuals,
                          cudnnSeqDataStruct kDesc,
                          @Const Pointer keys,
                          cudnnSeqDataStruct vDesc,
                          @Const Pointer values,
                          cudnnSeqDataStruct oDesc,
                          Pointer out,
                          @Cast("size_t") long weightSizeInBytes,
                          @Const Pointer weights,
                          @Cast("size_t") long workSpaceSizeInBytes,
                          Pointer workSpace,
                          @Cast("size_t") long reserveSpaceSizeInBytes,
                          Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnMultiHeadAttnForward(cudnnContext handle,
                          cudnnAttnStruct attnDesc,
                          int currIdx,
                          @Const IntBuffer loWinIdx,
                          @Const IntBuffer hiWinIdx,
                          @Const IntBuffer devSeqLengthsQO,
                          @Const IntBuffer devSeqLengthsKV,
                          cudnnSeqDataStruct qDesc,
                          @Const Pointer queries,
                          @Const Pointer residuals,
                          cudnnSeqDataStruct kDesc,
                          @Const Pointer keys,
                          cudnnSeqDataStruct vDesc,
                          @Const Pointer values,
                          cudnnSeqDataStruct oDesc,
                          Pointer out,
                          @Cast("size_t") long weightSizeInBytes,
                          @Const Pointer weights,
                          @Cast("size_t") long workSpaceSizeInBytes,
                          Pointer workSpace,
                          @Cast("size_t") long reserveSpaceSizeInBytes,
                          Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnMultiHeadAttnForward(cudnnContext handle,
                          cudnnAttnStruct attnDesc,
                          int currIdx,
                          @Const int[] loWinIdx,
                          @Const int[] hiWinIdx,
                          @Const int[] devSeqLengthsQO,
                          @Const int[] devSeqLengthsKV,
                          cudnnSeqDataStruct qDesc,
                          @Const Pointer queries,
                          @Const Pointer residuals,
                          cudnnSeqDataStruct kDesc,
                          @Const Pointer keys,
                          cudnnSeqDataStruct vDesc,
                          @Const Pointer values,
                          cudnnSeqDataStruct oDesc,
                          Pointer out,
                          @Cast("size_t") long weightSizeInBytes,
                          @Const Pointer weights,
                          @Cast("size_t") long workSpaceSizeInBytes,
                          Pointer workSpace,
                          @Cast("size_t") long reserveSpaceSizeInBytes,
                          Pointer reserveSpace);

/*
 * \brief Cross-library version checker.
 * This function is implemented differently in each sub-library. Each sublib
 * checks whether its own version matches that of its dependencies.
 * \returns CUDNN_STATUS_SUCCESS if the version check passes,
 *          CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH if the versions are inconsistent.
 */
public static native @Cast("cudnnStatus_t") int cudnnAdvVersionCheck();

/** enum cudnnWgradMode_t */
public static final int
    CUDNN_WGRAD_MODE_ADD = 0, /* add partial gradients to wgrad output buffers */
    CUDNN_WGRAD_MODE_SET = 1; /* write partial gradients to wgrad output buffers */

public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardData_v8(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        @Const IntPointer devSeqLengths,
                        cudnnRNNDataStruct yDesc,
                        @Const Pointer y,
                        @Const Pointer dy,
                        cudnnRNNDataStruct xDesc,
                        Pointer dx,
                        cudnnTensorStruct hDesc,
                        @Const Pointer hx,
                        @Const Pointer dhy,
                        Pointer dhx,
                        cudnnTensorStruct cDesc,
                        @Const Pointer cx,
                        @Const Pointer dcy,
                        Pointer dcx,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        @Cast("size_t") long workSpaceSize,
                        Pointer workSpace,
                        @Cast("size_t") long reserveSpaceSize,
                        Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardData_v8(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        @Const IntBuffer devSeqLengths,
                        cudnnRNNDataStruct yDesc,
                        @Const Pointer y,
                        @Const Pointer dy,
                        cudnnRNNDataStruct xDesc,
                        Pointer dx,
                        cudnnTensorStruct hDesc,
                        @Const Pointer hx,
                        @Const Pointer dhy,
                        Pointer dhx,
                        cudnnTensorStruct cDesc,
                        @Const Pointer cx,
                        @Const Pointer dcy,
                        Pointer dcx,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        @Cast("size_t") long workSpaceSize,
                        Pointer workSpace,
                        @Cast("size_t") long reserveSpaceSize,
                        Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardData_v8(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        @Const int[] devSeqLengths,
                        cudnnRNNDataStruct yDesc,
                        @Const Pointer y,
                        @Const Pointer dy,
                        cudnnRNNDataStruct xDesc,
                        Pointer dx,
                        cudnnTensorStruct hDesc,
                        @Const Pointer hx,
                        @Const Pointer dhy,
                        Pointer dhx,
                        cudnnTensorStruct cDesc,
                        @Const Pointer cx,
                        @Const Pointer dcy,
                        Pointer dcx,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        @Cast("size_t") long workSpaceSize,
                        Pointer workSpace,
                        @Cast("size_t") long reserveSpaceSize,
                        Pointer reserveSpace);

public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardWeights_v8(cudnnContext handle,
                           cudnnRNNStruct rnnDesc,
                           @Cast("cudnnWgradMode_t") int addGrad,
                           @Const IntPointer devSeqLengths,
                           cudnnRNNDataStruct xDesc,
                           @Const Pointer x,
                           cudnnTensorStruct hDesc,
                           @Const Pointer hx,
                           cudnnRNNDataStruct yDesc,
                           @Const Pointer y,
                           @Cast("size_t") long weightSpaceSize,
                           Pointer dweightSpace,
                           @Cast("size_t") long workSpaceSize,
                           Pointer workSpace,
                           @Cast("size_t") long reserveSpaceSize,
                           Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardWeights_v8(cudnnContext handle,
                           cudnnRNNStruct rnnDesc,
                           @Cast("cudnnWgradMode_t") int addGrad,
                           @Const IntBuffer devSeqLengths,
                           cudnnRNNDataStruct xDesc,
                           @Const Pointer x,
                           cudnnTensorStruct hDesc,
                           @Const Pointer hx,
                           cudnnRNNDataStruct yDesc,
                           @Const Pointer y,
                           @Cast("size_t") long weightSpaceSize,
                           Pointer dweightSpace,
                           @Cast("size_t") long workSpaceSize,
                           Pointer workSpace,
                           @Cast("size_t") long reserveSpaceSize,
                           Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardWeights_v8(cudnnContext handle,
                           cudnnRNNStruct rnnDesc,
                           @Cast("cudnnWgradMode_t") int addGrad,
                           @Const int[] devSeqLengths,
                           cudnnRNNDataStruct xDesc,
                           @Const Pointer x,
                           cudnnTensorStruct hDesc,
                           @Const Pointer hx,
                           cudnnRNNDataStruct yDesc,
                           @Const Pointer y,
                           @Cast("size_t") long weightSpaceSize,
                           Pointer dweightSpace,
                           @Cast("size_t") long workSpaceSize,
                           Pointer workSpace,
                           @Cast("size_t") long reserveSpaceSize,
                           Pointer reserveSpace);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnMultiHeadAttnBackwardData(cudnnContext handle,
                               cudnnAttnStruct attnDesc,
                               @Const IntPointer loWinIdx,
                               @Const IntPointer hiWinIdx,
                               @Const IntPointer devSeqLengthsDQDO,
                               @Const IntPointer devSeqLengthsDKDV,
                               cudnnSeqDataStruct doDesc,
                               @Const Pointer dout,
                               cudnnSeqDataStruct dqDesc,
                               Pointer dqueries,
                               @Const Pointer queries,
                               cudnnSeqDataStruct dkDesc,
                               Pointer dkeys,
                               @Const Pointer keys,
                               cudnnSeqDataStruct dvDesc,
                               Pointer dvalues,
                               @Const Pointer values,
                               @Cast("size_t") long weightSizeInBytes,
                               @Const Pointer weights,
                               @Cast("size_t") long workSpaceSizeInBytes,
                               Pointer workSpace,
                               @Cast("size_t") long reserveSpaceSizeInBytes,
                               Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnMultiHeadAttnBackwardData(cudnnContext handle,
                               cudnnAttnStruct attnDesc,
                               @Const IntBuffer loWinIdx,
                               @Const IntBuffer hiWinIdx,
                               @Const IntBuffer devSeqLengthsDQDO,
                               @Const IntBuffer devSeqLengthsDKDV,
                               cudnnSeqDataStruct doDesc,
                               @Const Pointer dout,
                               cudnnSeqDataStruct dqDesc,
                               Pointer dqueries,
                               @Const Pointer queries,
                               cudnnSeqDataStruct dkDesc,
                               Pointer dkeys,
                               @Const Pointer keys,
                               cudnnSeqDataStruct dvDesc,
                               Pointer dvalues,
                               @Const Pointer values,
                               @Cast("size_t") long weightSizeInBytes,
                               @Const Pointer weights,
                               @Cast("size_t") long workSpaceSizeInBytes,
                               Pointer workSpace,
                               @Cast("size_t") long reserveSpaceSizeInBytes,
                               Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnMultiHeadAttnBackwardData(cudnnContext handle,
                               cudnnAttnStruct attnDesc,
                               @Const int[] loWinIdx,
                               @Const int[] hiWinIdx,
                               @Const int[] devSeqLengthsDQDO,
                               @Const int[] devSeqLengthsDKDV,
                               cudnnSeqDataStruct doDesc,
                               @Const Pointer dout,
                               cudnnSeqDataStruct dqDesc,
                               Pointer dqueries,
                               @Const Pointer queries,
                               cudnnSeqDataStruct dkDesc,
                               Pointer dkeys,
                               @Const Pointer keys,
                               cudnnSeqDataStruct dvDesc,
                               Pointer dvalues,
                               @Const Pointer values,
                               @Cast("size_t") long weightSizeInBytes,
                               @Const Pointer weights,
                               @Cast("size_t") long workSpaceSizeInBytes,
                               Pointer workSpace,
                               @Cast("size_t") long reserveSpaceSizeInBytes,
                               Pointer reserveSpace);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnMultiHeadAttnBackwardWeights(cudnnContext handle,
                                  cudnnAttnStruct attnDesc,
                                  @Cast("cudnnWgradMode_t") int addGrad,
                                  cudnnSeqDataStruct qDesc,
                                  @Const Pointer queries,
                                  cudnnSeqDataStruct kDesc,
                                  @Const Pointer keys,
                                  cudnnSeqDataStruct vDesc,
                                  @Const Pointer values,
                                  cudnnSeqDataStruct doDesc,
                                  @Const Pointer dout,
                                  @Cast("size_t") long weightSizeInBytes,
                                  @Const Pointer weights,
                                  Pointer dweights,
                                  @Cast("size_t") long workSpaceSizeInBytes,
                                  Pointer workSpace,
                                  @Cast("size_t") long reserveSpaceSizeInBytes,
                                  Pointer reserveSpace);

/*
 * CTC (Connectionist Temporal Classification) loss descriptor create/destory/set/get functions
 */
/* Input normalization mode for loss function */
/** enum cudnnLossNormalizationMode_t */
public static final int
    CUDNN_LOSS_NORMALIZATION_NONE    = 0,
    CUDNN_LOSS_NORMALIZATION_SOFTMAX = 1;

public static native @Cast("cudnnStatus_t") int cudnnCreateCTCLossDescriptor(@ByPtrPtr cudnnCTCLossStruct ctcLossDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc, @Cast("cudnnDataType_t") int compType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetCTCLossDescriptorEx(cudnnCTCLossStruct ctcLossDesc,
                            @Cast("cudnnDataType_t") int compType,
                            @Cast("cudnnLossNormalizationMode_t") int normMode,
                            @Cast("cudnnNanPropagation_t") int gradMode);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetCTCLossDescriptor_v8(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t") int compType,
                             @Cast("cudnnLossNormalizationMode_t") int normMode,
                             @Cast("cudnnNanPropagation_t") int gradMode,
                             int maxLabelLength);

public static native @Cast("cudnnStatus_t") int cudnnSetCTCLossDescriptor_v9(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t") int compType,
                             @Cast("cudnnLossNormalizationMode_t") int normMode,
                             @Cast("cudnnCTCGradMode_t") int ctcGradMode,
                             int maxLabelLength);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc, @Cast("cudnnDataType_t*") IntPointer compType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc, @Cast("cudnnDataType_t*") IntBuffer compType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc, @Cast("cudnnDataType_t*") int[] compType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptorEx(cudnnCTCLossStruct ctcLossDesc,
                            @Cast("cudnnDataType_t*") IntPointer compType,
                            @Cast("cudnnLossNormalizationMode_t*") IntPointer normMode,
                            @Cast("cudnnNanPropagation_t*") IntPointer gradMode);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptorEx(cudnnCTCLossStruct ctcLossDesc,
                            @Cast("cudnnDataType_t*") IntBuffer compType,
                            @Cast("cudnnLossNormalizationMode_t*") IntBuffer normMode,
                            @Cast("cudnnNanPropagation_t*") IntBuffer gradMode);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptorEx(cudnnCTCLossStruct ctcLossDesc,
                            @Cast("cudnnDataType_t*") int[] compType,
                            @Cast("cudnnLossNormalizationMode_t*") int[] normMode,
                            @Cast("cudnnNanPropagation_t*") int[] gradMode);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptor_v8(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") IntPointer compType,
                             @Cast("cudnnLossNormalizationMode_t*") IntPointer normMode,
                             @Cast("cudnnNanPropagation_t*") IntPointer gradMode,
                             IntPointer maxLabelLength);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptor_v8(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") IntBuffer compType,
                             @Cast("cudnnLossNormalizationMode_t*") IntBuffer normMode,
                             @Cast("cudnnNanPropagation_t*") IntBuffer gradMode,
                             IntBuffer maxLabelLength);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetCTCLossDescriptor_v8(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") int[] compType,
                             @Cast("cudnnLossNormalizationMode_t*") int[] normMode,
                             @Cast("cudnnNanPropagation_t*") int[] gradMode,
                             int[] maxLabelLength);

public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor_v9(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") IntPointer compType,
                             @Cast("cudnnLossNormalizationMode_t*") IntPointer normMode,
                             @Cast("cudnnCTCGradMode_t*") IntPointer ctcGradMode,
                             IntPointer maxLabelLength);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor_v9(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") IntBuffer compType,
                             @Cast("cudnnLossNormalizationMode_t*") IntBuffer normMode,
                             @Cast("cudnnCTCGradMode_t*") IntBuffer ctcGradMode,
                             IntBuffer maxLabelLength);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor_v9(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") int[] compType,
                             @Cast("cudnnLossNormalizationMode_t*") int[] normMode,
                             @Cast("cudnnCTCGradMode_t*") int[] ctcGradMode,
                             int[] maxLabelLength);

public static native @Cast("cudnnStatus_t") int cudnnDestroyCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc);

/* return the ctc costs and gradients, given the probabilities and labels */
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const IntPointer hostLabels,
    @Const IntPointer hostLabelLengths,
    @Const IntPointer hostInputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    Pointer workspace,
    @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const IntBuffer hostLabels,
    @Const IntBuffer hostLabelLengths,
    @Const IntBuffer hostInputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    Pointer workspace,
    @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const int[] hostLabels,
    @Const int[] hostLabelLengths,
    @Const int[] hostInputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    Pointer workspace,
    @Cast("size_t") long workSpaceSizeInBytes); /* size of the workspace */

/* return the ctc costs and gradients, given the probabilities and labels */
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss_v8(
    cudnnContext handle,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const IntPointer labels,
    @Const IntPointer labelLengths,
    @Const IntPointer inputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("size_t") long workSpaceSizeInBytes,
    Pointer workspace);
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss_v8(
    cudnnContext handle,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const IntBuffer labels,
    @Const IntBuffer labelLengths,
    @Const IntBuffer inputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("size_t") long workSpaceSizeInBytes,
    Pointer workspace);
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss_v8(
    cudnnContext handle,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const int[] labels,
    @Const int[] labelLengths,
    @Const int[] inputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("size_t") long workSpaceSizeInBytes,
    Pointer workspace);            /* pointer to the workspace, in GPU memory */

/* return the workspace size needed for ctc */
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossWorkspaceSize(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    cudnnTensorStruct gradientsDesc,
    @Const IntPointer labels,
    @Const IntPointer labelLengths,
    @Const IntPointer inputLengths,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    @Cast("size_t*") SizeTPointer sizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossWorkspaceSize(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    cudnnTensorStruct gradientsDesc,
    @Const IntBuffer labels,
    @Const IntBuffer labelLengths,
    @Const IntBuffer inputLengths,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    @Cast("size_t*") SizeTPointer sizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossWorkspaceSize(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    cudnnTensorStruct gradientsDesc,
    @Const int[] labels,
    @Const int[] labelLengths,
    @Const int[] inputLengths,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    @Cast("size_t*") SizeTPointer sizeInBytes); /* pointer to the returned workspace size */

/* return the workspace size needed for ctc */
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossWorkspaceSize_v8(
    cudnnContext handle,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    cudnnTensorStruct probsDesc,
    cudnnTensorStruct gradientsDesc,
    @Cast("size_t*") SizeTPointer sizeInBytes);                        /* pointer to the returned workspace size */

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_ADV_H_ */


// Parsed from <cudnn_cnn.h>

/*
 * Copyright 2014-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 *  cudnn_cnn : cuDNN's basic definitions and CNN functions.
 */

// #if !defined(CUDNN_CNN_H_)
// #define CUDNN_CNN_H_

// #pragma once
// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_ops.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_CNN_MAJOR = 9;
public static final int CUDNN_CNN_MINOR = 10;
public static final int CUDNN_CNN_PATCH = 2;

// #if (CUDNN_CNN_MAJOR != CUDNN_MAJOR) || (CUDNN_CNN_MINOR != CUDNN_MINOR) || (CUDNN_CNN_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN CNN INFER!!!
// #endif

// #if defined(__cplusplus)
// Targeting ..\cudnn\cudnnConvolutionStruct.java


// Targeting ..\cudnn\cudnnConvolutionFwdAlgoPerf_t.java



/* Create an instance of convolution descriptor */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateConvolutionDescriptor(@ByPtrPtr cudnnConvolutionStruct convDesc);

/* Destroy an instance of convolution descriptor */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyConvolutionDescriptor(cudnnConvolutionStruct convDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetConvolutionMathType(cudnnConvolutionStruct convDesc, @Cast("cudnnMathType_t") int mathType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionMathType(cudnnConvolutionStruct convDesc, @Cast("cudnnMathType_t*") IntPointer mathType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionMathType(cudnnConvolutionStruct convDesc, @Cast("cudnnMathType_t*") IntBuffer mathType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionMathType(cudnnConvolutionStruct convDesc, @Cast("cudnnMathType_t*") int[] mathType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetConvolutionGroupCount(cudnnConvolutionStruct convDesc, int groupCount);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionGroupCount(cudnnConvolutionStruct convDesc, IntPointer groupCount);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionGroupCount(cudnnConvolutionStruct convDesc, IntBuffer groupCount);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionGroupCount(cudnnConvolutionStruct convDesc, int[] groupCount);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetConvolutionReorderType(cudnnConvolutionStruct convDesc, @Cast("cudnnReorderType_t") int reorderType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionReorderType(cudnnConvolutionStruct convDesc, @Cast("cudnnReorderType_t*") IntPointer reorderType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionReorderType(cudnnConvolutionStruct convDesc, @Cast("cudnnReorderType_t*") IntBuffer reorderType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionReorderType(cudnnConvolutionStruct convDesc, @Cast("cudnnReorderType_t*") int[] reorderType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetConvolution2dDescriptor(cudnnConvolutionStruct convDesc,
                                int pad_h,
                                int pad_w,
                                int u,
                                int v,
                                int dilation_h,
                                int dilation_w,
                                @Cast("cudnnConvolutionMode_t") int mode,
                                @Cast("cudnnDataType_t") int computeType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolution2dDescriptor(cudnnConvolutionStruct convDesc,
                                IntPointer pad_h,
                                IntPointer pad_w,
                                IntPointer u,
                                IntPointer v,
                                IntPointer dilation_h,
                                IntPointer dilation_w,
                                @Cast("cudnnConvolutionMode_t*") IntPointer mode,
                                @Cast("cudnnDataType_t*") IntPointer computeType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolution2dDescriptor(cudnnConvolutionStruct convDesc,
                                IntBuffer pad_h,
                                IntBuffer pad_w,
                                IntBuffer u,
                                IntBuffer v,
                                IntBuffer dilation_h,
                                IntBuffer dilation_w,
                                @Cast("cudnnConvolutionMode_t*") IntBuffer mode,
                                @Cast("cudnnDataType_t*") IntBuffer computeType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolution2dDescriptor(cudnnConvolutionStruct convDesc,
                                int[] pad_h,
                                int[] pad_w,
                                int[] u,
                                int[] v,
                                int[] dilation_h,
                                int[] dilation_w,
                                @Cast("cudnnConvolutionMode_t*") int[] mode,
                                @Cast("cudnnDataType_t*") int[] computeType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLength,
                                @Const IntPointer padA,
                                @Const IntPointer filterStrideA,
                                @Const IntPointer dilationA,
                                @Cast("cudnnConvolutionMode_t") int mode,
                                @Cast("cudnnDataType_t") int computeType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLength,
                                @Const IntBuffer padA,
                                @Const IntBuffer filterStrideA,
                                @Const IntBuffer dilationA,
                                @Cast("cudnnConvolutionMode_t") int mode,
                                @Cast("cudnnDataType_t") int computeType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLength,
                                @Const int[] padA,
                                @Const int[] filterStrideA,
                                @Const int[] dilationA,
                                @Cast("cudnnConvolutionMode_t") int mode,
                                @Cast("cudnnDataType_t") int computeType); /* convolution data type */

/* Helper function to return the dimensions of the output tensor given a convolution descriptor */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLengthRequested,
                                IntPointer arrayLength,
                                IntPointer padA,
                                IntPointer strideA,
                                IntPointer dilationA,
                                @Cast("cudnnConvolutionMode_t*") IntPointer mode,
                                @Cast("cudnnDataType_t*") IntPointer computeType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLengthRequested,
                                IntBuffer arrayLength,
                                IntBuffer padA,
                                IntBuffer strideA,
                                IntBuffer dilationA,
                                @Cast("cudnnConvolutionMode_t*") IntBuffer mode,
                                @Cast("cudnnDataType_t*") IntBuffer computeType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLengthRequested,
                                int[] arrayLength,
                                int[] padA,
                                int[] strideA,
                                int[] dilationA,
                                @Cast("cudnnConvolutionMode_t*") int[] mode,
                                @Cast("cudnnDataType_t*") int[] computeType); /* convolution data type */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolution2dForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      IntPointer n,
                                      IntPointer c,
                                      IntPointer h,
                                      IntPointer w);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolution2dForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      IntBuffer n,
                                      IntBuffer c,
                                      IntBuffer h,
                                      IntBuffer w);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolution2dForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      int[] n,
                                      int[] c,
                                      int[] h,
                                      int[] w);

/* Helper function to return the dimensions of the output tensor given a convolution descriptor */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionNdForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      int nbDims,
                                      IntPointer tensorOuputDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionNdForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      int nbDims,
                                      IntBuffer tensorOuputDimA);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionNdForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      int nbDims,
                                      int[] tensorOuputDimA);

/* helper function to provide the convolution forward algo that fit best the requirement */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionForwardAlgorithmMaxCount(cudnnContext handle, IntPointer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionForwardAlgorithmMaxCount(cudnnContext handle, IntBuffer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionForwardAlgorithmMaxCount(cudnnContext handle, int[] count);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionForwardAlgorithm_v7(cudnnContext handle,
                                       cudnnTensorStruct srcDesc,
                                       cudnnFilterStruct filterDesc,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct destDesc,
                                       int requestedAlgoCount,
                                       IntPointer returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionForwardAlgorithm_v7(cudnnContext handle,
                                       cudnnTensorStruct srcDesc,
                                       cudnnFilterStruct filterDesc,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct destDesc,
                                       int requestedAlgoCount,
                                       IntBuffer returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionForwardAlgorithm_v7(cudnnContext handle,
                                       cudnnTensorStruct srcDesc,
                                       cudnnFilterStruct filterDesc,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct destDesc,
                                       int requestedAlgoCount,
                                       int[] returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionForwardAlgorithm(cudnnContext handle,
                                     cudnnTensorStruct xDesc,
                                     cudnnFilterStruct wDesc,
                                     cudnnConvolutionStruct convDesc,
                                     cudnnTensorStruct yDesc,
                                     int requestedAlgoCount,
                                     IntPointer returnedAlgoCount,
                                     cudnnConvolutionFwdAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionForwardAlgorithm(cudnnContext handle,
                                     cudnnTensorStruct xDesc,
                                     cudnnFilterStruct wDesc,
                                     cudnnConvolutionStruct convDesc,
                                     cudnnTensorStruct yDesc,
                                     int requestedAlgoCount,
                                     IntBuffer returnedAlgoCount,
                                     cudnnConvolutionFwdAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionForwardAlgorithm(cudnnContext handle,
                                     cudnnTensorStruct xDesc,
                                     cudnnFilterStruct wDesc,
                                     cudnnConvolutionStruct convDesc,
                                     cudnnTensorStruct yDesc,
                                     int requestedAlgoCount,
                                     int[] returnedAlgoCount,
                                     cudnnConvolutionFwdAlgoPerf_t perfResults);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionForwardAlgorithmEx(cudnnContext handle,
                                       cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct yDesc,
                                       Pointer y,
                                       int requestedAlgoCount,
                                       IntPointer returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults,
                                       Pointer workSpace,
                                       @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionForwardAlgorithmEx(cudnnContext handle,
                                       cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct yDesc,
                                       Pointer y,
                                       int requestedAlgoCount,
                                       IntBuffer returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults,
                                       Pointer workSpace,
                                       @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionForwardAlgorithmEx(cudnnContext handle,
                                       cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct yDesc,
                                       Pointer y,
                                       int requestedAlgoCount,
                                       int[] returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults,
                                       Pointer workSpace,
                                       @Cast("size_t") long workSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnIm2Col(cudnnContext handle,
            cudnnTensorStruct xDesc,
            @Const Pointer x,
            cudnnFilterStruct wDesc,
            cudnnConvolutionStruct convDesc,
            Pointer colBuffer);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnReorderFilterAndBias(cudnnContext handle,
                          cudnnFilterStruct filterDesc,
                          @Cast("cudnnReorderType_t") int reorderType,
                          @Const Pointer filterData,
                          Pointer reorderedFilterData,
                          int reorderBias,
                          @Const Pointer biasData,
                          Pointer reorderedBiasData);

/* Helper function to return the minimum size of the workspace to be passed to the convolution given an algo*/
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionForwardWorkspaceSize(cudnnContext handle,
                                        cudnnTensorStruct xDesc,
                                        cudnnFilterStruct wDesc,
                                        cudnnConvolutionStruct convDesc,
                                        cudnnTensorStruct yDesc,
                                        @Cast("cudnnConvolutionFwdAlgo_t") int algo,
                                        @Cast("size_t*") SizeTPointer sizeInBytes);

/* Convolution functions: All of the form "output = alpha * Op(inputs) + beta * output" */

/* Function to perform the forward pass for batch convolution */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnConvolutionForward(cudnnContext handle,
                        @Const Pointer alpha,
                        cudnnTensorStruct xDesc,
                        @Const Pointer x,
                        cudnnFilterStruct wDesc,
                        @Const Pointer w,
                        cudnnConvolutionStruct convDesc,
                        @Cast("cudnnConvolutionFwdAlgo_t") int algo,
                        Pointer workSpace,
                        @Cast("size_t") long workSpaceSizeInBytes,
                        @Const Pointer beta,
                        cudnnTensorStruct yDesc,
                        Pointer y);

/* Fused conv/bias/activation operation : y = Act( alpha1 * conv(x) + alpha2 * z + bias ) */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnConvolutionBiasActivationForward(cudnnContext handle,
                                      @Const Pointer alpha1,
                                      cudnnTensorStruct xDesc,
                                      @Const Pointer x,
                                      cudnnFilterStruct wDesc,
                                      @Const Pointer w,
                                      cudnnConvolutionStruct convDesc,
                                      @Cast("cudnnConvolutionFwdAlgo_t") int algo,
                                      Pointer workSpace,
                                      @Cast("size_t") long workSpaceSizeInBytes,
                                      @Const Pointer alpha2,
                                      cudnnTensorStruct zDesc,
                                      @Const Pointer z,
                                      cudnnTensorStruct biasDesc,
                                      @Const Pointer bias,
                                      cudnnActivationStruct activationDesc,
                                      cudnnTensorStruct yDesc,
                                      Pointer y);
// Targeting ..\cudnn\cudnnConvolutionBwdDataAlgoPerf_t.java



public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardDataAlgorithmMaxCount(cudnnContext handle, IntPointer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardDataAlgorithmMaxCount(cudnnContext handle, IntBuffer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardDataAlgorithmMaxCount(cudnnContext handle, int[] count);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardDataAlgorithm(cudnnContext handle,
                                          cudnnFilterStruct wDesc,
                                          cudnnTensorStruct dyDesc,
                                          cudnnConvolutionStruct convDesc,
                                          cudnnTensorStruct dxDesc,
                                          int requestedAlgoCount,
                                          IntPointer returnedAlgoCount,
                                          cudnnConvolutionBwdDataAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardDataAlgorithm(cudnnContext handle,
                                          cudnnFilterStruct wDesc,
                                          cudnnTensorStruct dyDesc,
                                          cudnnConvolutionStruct convDesc,
                                          cudnnTensorStruct dxDesc,
                                          int requestedAlgoCount,
                                          IntBuffer returnedAlgoCount,
                                          cudnnConvolutionBwdDataAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardDataAlgorithm(cudnnContext handle,
                                          cudnnFilterStruct wDesc,
                                          cudnnTensorStruct dyDesc,
                                          cudnnConvolutionStruct convDesc,
                                          cudnnTensorStruct dxDesc,
                                          int requestedAlgoCount,
                                          int[] returnedAlgoCount,
                                          cudnnConvolutionBwdDataAlgoPerf_t perfResults);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardDataAlgorithmEx(cudnnContext handle,
                                            cudnnFilterStruct wDesc,
                                            @Const Pointer w,
                                            cudnnTensorStruct dyDesc,
                                            @Const Pointer dy,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct dxDesc,
                                            Pointer dx,
                                            int requestedAlgoCount,
                                            IntPointer returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults,
                                            Pointer workSpace,
                                            @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardDataAlgorithmEx(cudnnContext handle,
                                            cudnnFilterStruct wDesc,
                                            @Const Pointer w,
                                            cudnnTensorStruct dyDesc,
                                            @Const Pointer dy,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct dxDesc,
                                            Pointer dx,
                                            int requestedAlgoCount,
                                            IntBuffer returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults,
                                            Pointer workSpace,
                                            @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardDataAlgorithmEx(cudnnContext handle,
                                            cudnnFilterStruct wDesc,
                                            @Const Pointer w,
                                            cudnnTensorStruct dyDesc,
                                            @Const Pointer dy,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct dxDesc,
                                            Pointer dx,
                                            int requestedAlgoCount,
                                            int[] returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults,
                                            Pointer workSpace,
                                            @Cast("size_t") long workSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardDataAlgorithm_v7(cudnnContext handle,
                                            cudnnFilterStruct filterDesc,
                                            cudnnTensorStruct diffDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct gradDesc,
                                            int requestedAlgoCount,
                                            IntPointer returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardDataAlgorithm_v7(cudnnContext handle,
                                            cudnnFilterStruct filterDesc,
                                            cudnnTensorStruct diffDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct gradDesc,
                                            int requestedAlgoCount,
                                            IntBuffer returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardDataAlgorithm_v7(cudnnContext handle,
                                            cudnnFilterStruct filterDesc,
                                            cudnnTensorStruct diffDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct gradDesc,
                                            int requestedAlgoCount,
                                            int[] returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults);

/*
 *  convolution algorithm (which requires potentially some workspace)
 */

/* Helper function to return the minimum size of the workspace to be passed to the convolution given an algo*/
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardDataWorkspaceSize(cudnnContext handle,
                                             cudnnFilterStruct wDesc,
                                             cudnnTensorStruct dyDesc,
                                             cudnnConvolutionStruct convDesc,
                                             cudnnTensorStruct dxDesc,
                                             @Cast("cudnnConvolutionBwdDataAlgo_t") int algo,
                                             @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnConvolutionBackwardData(cudnnContext handle,
                             @Const Pointer alpha,
                             cudnnFilterStruct wDesc,
                             @Const Pointer w,
                             cudnnTensorStruct dyDesc,
                             @Const Pointer dy,
                             cudnnConvolutionStruct convDesc,
                             @Cast("cudnnConvolutionBwdDataAlgo_t") int algo,
                             Pointer workSpace,
                             @Cast("size_t") long workSpaceSizeInBytes,
                             @Const Pointer beta,
                             cudnnTensorStruct dxDesc,
                             Pointer dx);

/* Helper function to calculate folding descriptors for dgrad */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFoldedConvBackwardDataDescriptors(cudnnContext handle,
                                          cudnnFilterStruct filterDesc,
                                          cudnnTensorStruct diffDesc,
                                          cudnnConvolutionStruct convDesc,
                                          cudnnTensorStruct gradDesc,
                                          @Cast("const cudnnTensorFormat_t") int transformFormat,
                                          cudnnFilterStruct foldedFilterDesc,
                                          cudnnTensorStruct paddedDiffDesc,
                                          cudnnConvolutionStruct foldedConvDesc,
                                          cudnnTensorStruct foldedGradDesc,
                                          cudnnTensorTransformStruct filterFoldTransDesc,
                                          cudnnTensorTransformStruct diffPadTransDesc,
                                          cudnnTensorTransformStruct gradFoldTransDesc,
                                          cudnnTensorTransformStruct gradUnfoldTransDesc);
// Targeting ..\cudnn\cudnnFusedOpsConstParamStruct.java


// Targeting ..\cudnn\cudnnFusedOpsVariantParamStruct.java


// Targeting ..\cudnn\cudnnFusedOpsPlanStruct.java



/** enum deprecated */
public static final int
    /* each op in [ ] can be disabled by passing NULL ptr */
    /* [per channel scale], [per channel bias], [activation], convolution, [generate BN stats] */
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_CONV_BNSTATS = 0,
    /* [per channel scale], [per channel bias], [activation], convolutionBackwardWeights */
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_WGRAD = 1,
    /* utility for BN training in BN-conv fusion */
    /* computes the equivalent scale and bias from ySum ySqSum and learned scale, bias */
    /* optionally update running stats and generate saved stats */
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_TRAINING = 2,
    /* utility for BN inference in BN-conv fusion */
    /* computes the equivalent scale and bias from learned running stats and learned scale, bias */
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_INFERENCE = 3,
    /* reserved for future use: convolution, [per channel scale], [per channel bias], [residual add], [activation] */
    CUDNN_FUSED_CONV_SCALE_BIAS_ADD_ACTIVATION = 4,
    /* reserved for future use: [per channel scale], [per channel bias], [residual add],  activation, bitmask */
    CUDNN_FUSED_SCALE_BIAS_ADD_ACTIVATION_GEN_BITMASK = 5,
    /* reserved for future use */
    CUDNN_FUSED_DACTIVATION_FORK_DBATCHNORM = 6;

/** enum deprecated */
public static final int
    /* set XDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get XDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_XDESC = 0,
    /* set/get XDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_XDATA_PLACEHOLDER = 1,
    /* set/get BN_MODE: pass cudnnBatchNormMode_t* */
    CUDNN_PARAM_BN_MODE = 2,
    /* set CUDNN_PARAM_BN_EQSCALEBIAS_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get CUDNN_PARAM_BN_EQSCALEBIAS_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_BN_EQSCALEBIAS_DESC = 3,
    /* set/get BN_EQSCALE_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_EQSCALE_PLACEHOLDER = 4,
    /* set/get BN_EQBIAS_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_EQBIAS_PLACEHOLDER = 5,
    /* set ACTIVATION_DESC: pass previously initialized cudnnActivationDescriptor_t */
    /* get ACTIVATION_DESC: pass previously created cudnnActivationDescriptor_t */
    CUDNN_PARAM_ACTIVATION_DESC = 6,
    /* set CONV_DESC: pass previously initialized cudnnConvolutionDescriptor_t */
    /* get CONV_DESC: pass previously created cudnnConvolutionDescriptor_t */
    CUDNN_PARAM_CONV_DESC = 7,
    /* set WDESC: pass previously initialized cudnnFilterDescriptor_t */
    /* get WDESC: pass previously created cudnnFilterDescriptor_t */
    CUDNN_PARAM_WDESC = 8,
    /* set/get WDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_WDATA_PLACEHOLDER = 9,
    /* set DWDESC: pass previously initialized cudnnFilterDescriptor_t */
    /* get DWDESC: pass previously created cudnnFilterDescriptor_t */
    CUDNN_PARAM_DWDESC = 10,
    /* set/get DWDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_DWDATA_PLACEHOLDER = 11,
    /* set YDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get YDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_YDESC = 12,
    /* set/get YDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_YDATA_PLACEHOLDER = 13,
    /* set DYDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get DYDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_DYDESC = 14,
    /* set/get DYDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_DYDATA_PLACEHOLDER = 15,
    /* set YSTATS_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get YSTATS_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_YSTATS_DESC = 16,
    /* set/get YSUM_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_YSUM_PLACEHOLDER = 17,
    /* set/get YSQSUM_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_YSQSUM_PLACEHOLDER = 18,
    /* set CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC = 19,
    /* set/get CUDNN_PARAM_BN_SCALE_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_SCALE_PLACEHOLDER = 20,
    /* set/get CUDNN_PARAM_BN_BIAS_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_BIAS_PLACEHOLDER = 21,
    /* set/get CUDNN_PARAM_BN_SAVED_MEAN_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_SAVED_MEAN_PLACEHOLDER = 22,
    /* set/get CUDNN_PARAM_BN_SAVED_INVSTD_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_SAVED_INVSTD_PLACEHOLDER = 23,
    /* set/get CUDNN_PARAM_BN_RUNNING_MEAN_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_RUNNING_MEAN_PLACEHOLDER = 24,
    /* set/get CUDNN_PARAM_BN_RUNNING_VAR_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_RUNNING_VAR_PLACEHOLDER = 25,

    /* set ZDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get ZDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_ZDESC = 26,
    /* set/get ZDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_ZDATA_PLACEHOLDER = 27,
    /* set BN_Z_EQSCALEBIAS_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get BN_Z_EQSCALEBIAS_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_BN_Z_EQSCALEBIAS_DESC = 28,
    /* set/get BN_Z_EQSCALE_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_Z_EQSCALE_PLACEHOLDER = 29,
    /* set/get BN_Z_EQBIAS_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_Z_EQBIAS_PLACEHOLDER = 30,

    /* set ACTIVATION_BITMASK_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get ACTIVATION_BITMASK_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_ACTIVATION_BITMASK_DESC = 31,
    /* set/get ACTIVATION_BITMASK_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_ACTIVATION_BITMASK_PLACEHOLDER = 32,

    /* set DXDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get DXDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_DXDESC = 33,
    /* set/get DXDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_DXDATA_PLACEHOLDER = 34,
    /* set DZDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get DZDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_DZDESC = 35,
    /* set/get DZDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_DZDATA_PLACEHOLDER = 36,
    /* set/get CUDNN_PARAM_BN_DSCALE_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_DSCALE_PLACEHOLDER = 37,
    /* set/get CUDNN_PARAM_BN_DBIAS_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_DBIAS_PLACEHOLDER = 38;

/** enum deprecated */
public static final int
    CUDNN_PTR_NULL         = 0,
    CUDNN_PTR_ELEM_ALIGNED = 1,
    CUDNN_PTR_16B_ALIGNED  = 2;

/** enum deprecated */
public static final int
    /* set: pass void* pointing to dev memory */
    /* get: pass void** pointing to host memory */
    CUDNN_PTR_XDATA              = 0,
    CUDNN_PTR_BN_EQSCALE         = 1,
    CUDNN_PTR_BN_EQBIAS          = 2,
    CUDNN_PTR_WDATA              = 3,
    CUDNN_PTR_DWDATA             = 4,
    CUDNN_PTR_YDATA              = 5,
    CUDNN_PTR_DYDATA             = 6,
    CUDNN_PTR_YSUM               = 7,
    CUDNN_PTR_YSQSUM             = 8,
    CUDNN_PTR_WORKSPACE          = 9,
    CUDNN_PTR_BN_SCALE           = 10,
    CUDNN_PTR_BN_BIAS            = 11,
    CUDNN_PTR_BN_SAVED_MEAN      = 12,
    CUDNN_PTR_BN_SAVED_INVSTD    = 13,
    CUDNN_PTR_BN_RUNNING_MEAN    = 14,
    CUDNN_PTR_BN_RUNNING_VAR     = 15,
    CUDNN_PTR_ZDATA              = 16,
    CUDNN_PTR_BN_Z_EQSCALE       = 17,
    CUDNN_PTR_BN_Z_EQBIAS        = 18,
    CUDNN_PTR_ACTIVATION_BITMASK = 19,
    CUDNN_PTR_DXDATA             = 20,
    CUDNN_PTR_DZDATA             = 21,
    CUDNN_PTR_BN_DSCALE          = 22,
    CUDNN_PTR_BN_DBIAS           = 23,

    /* set/get: pass size_t* pointing to host memory */
    CUDNN_SCALAR_SIZE_T_WORKSPACE_SIZE_IN_BYTES = 100,
    /* set/get: pass int64_t* pointing to host memory */
    CUDNN_SCALAR_INT64_T_BN_ACCUMULATION_COUNT = 101,
    /* set/get: pass double* pointing to host memory */
    CUDNN_SCALAR_DOUBLE_BN_EXP_AVG_FACTOR = 102,
    /* set/get: pass double* pointing to host memory */
    CUDNN_SCALAR_DOUBLE_BN_EPSILON = 103;

public static native @Cast("cudnnStatus_t") int cudnnCnnVersionCheck();
// Targeting ..\cudnn\cudnnConvolutionBwdFilterAlgoPerf_t.java



public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(cudnnContext handle, IntPointer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(cudnnContext handle, IntBuffer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(cudnnContext handle, int[] count);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardFilterAlgorithm(cudnnContext handle,
                                            cudnnTensorStruct xDesc,
                                            cudnnTensorStruct dyDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnFilterStruct dwDesc,
                                            int requestedAlgoCount,
                                            IntPointer returnedAlgoCount,
                                            cudnnConvolutionBwdFilterAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardFilterAlgorithm(cudnnContext handle,
                                            cudnnTensorStruct xDesc,
                                            cudnnTensorStruct dyDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnFilterStruct dwDesc,
                                            int requestedAlgoCount,
                                            IntBuffer returnedAlgoCount,
                                            cudnnConvolutionBwdFilterAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardFilterAlgorithm(cudnnContext handle,
                                            cudnnTensorStruct xDesc,
                                            cudnnTensorStruct dyDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnFilterStruct dwDesc,
                                            int requestedAlgoCount,
                                            int[] returnedAlgoCount,
                                            cudnnConvolutionBwdFilterAlgoPerf_t perfResults);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardFilterAlgorithmEx(cudnnContext handle,
                                              cudnnTensorStruct xDesc,
                                              @Const Pointer x,
                                              cudnnTensorStruct dyDesc,
                                              @Const Pointer y,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct dwDesc,
                                              Pointer dw,
                                              int requestedAlgoCount,
                                              IntPointer returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults,
                                              Pointer workSpace,
                                              @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardFilterAlgorithmEx(cudnnContext handle,
                                              cudnnTensorStruct xDesc,
                                              @Const Pointer x,
                                              cudnnTensorStruct dyDesc,
                                              @Const Pointer y,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct dwDesc,
                                              Pointer dw,
                                              int requestedAlgoCount,
                                              IntBuffer returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults,
                                              Pointer workSpace,
                                              @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindConvolutionBackwardFilterAlgorithmEx(cudnnContext handle,
                                              cudnnTensorStruct xDesc,
                                              @Const Pointer x,
                                              cudnnTensorStruct dyDesc,
                                              @Const Pointer y,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct dwDesc,
                                              Pointer dw,
                                              int requestedAlgoCount,
                                              int[] returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults,
                                              Pointer workSpace,
                                              @Cast("size_t") long workSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardFilterAlgorithm_v7(cudnnContext handle,
                                              cudnnTensorStruct srcDesc,
                                              cudnnTensorStruct diffDesc,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct gradDesc,
                                              int requestedAlgoCount,
                                              IntPointer returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardFilterAlgorithm_v7(cudnnContext handle,
                                              cudnnTensorStruct srcDesc,
                                              cudnnTensorStruct diffDesc,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct gradDesc,
                                              int requestedAlgoCount,
                                              IntBuffer returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardFilterAlgorithm_v7(cudnnContext handle,
                                              cudnnTensorStruct srcDesc,
                                              cudnnTensorStruct diffDesc,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct gradDesc,
                                              int requestedAlgoCount,
                                              int[] returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults);

/*
 *  convolution algorithm (which requires potentially some workspace)
 */

/* Helper function to return the minimum size of the workspace to be passed to the convolution given an algo*/
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetConvolutionBackwardFilterWorkspaceSize(cudnnContext handle,
                                               cudnnTensorStruct xDesc,
                                               cudnnTensorStruct dyDesc,
                                               cudnnConvolutionStruct convDesc,
                                               cudnnFilterStruct gradDesc,
                                               @Cast("cudnnConvolutionBwdFilterAlgo_t") int algo,
                                               @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnConvolutionBackwardFilter(cudnnContext handle,
                               @Const Pointer alpha,
                               cudnnTensorStruct xDesc,
                               @Const Pointer x,
                               cudnnTensorStruct dyDesc,
                               @Const Pointer dy,
                               cudnnConvolutionStruct convDesc,
                               @Cast("cudnnConvolutionBwdFilterAlgo_t") int algo,
                               Pointer workSpace,
                               @Cast("size_t") long workSpaceSizeInBytes,
                               @Const Pointer beta,
                               cudnnFilterStruct dwDesc,
                               Pointer dw);

/* Function to compute the bias gradient for batch convolution */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnConvolutionBackwardBias(cudnnContext handle,
                             @Const Pointer alpha,
                             cudnnTensorStruct dyDesc,
                             @Const Pointer dy,
                             @Const Pointer beta,
                             cudnnTensorStruct dbDesc,
                             Pointer db);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateFusedOpsConstParamPack(@ByPtrPtr cudnnFusedOpsConstParamStruct constPack, @Cast("cudnnFusedOps_t") int ops);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyFusedOpsConstParamPack(cudnnFusedOpsConstParamStruct constPack);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetFusedOpsConstParamPackAttribute(cudnnFusedOpsConstParamStruct constPack,
                                        @Cast("cudnnFusedOpsConstParamLabel_t") int paramLabel,
                                        @Const Pointer param);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFusedOpsConstParamPackAttribute(cudnnFusedOpsConstParamStruct constPack,
                                        @Cast("cudnnFusedOpsConstParamLabel_t") int paramLabel,
                                        Pointer param,
                                        IntPointer isNULL);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFusedOpsConstParamPackAttribute(cudnnFusedOpsConstParamStruct constPack,
                                        @Cast("cudnnFusedOpsConstParamLabel_t") int paramLabel,
                                        Pointer param,
                                        IntBuffer isNULL);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFusedOpsConstParamPackAttribute(cudnnFusedOpsConstParamStruct constPack,
                                        @Cast("cudnnFusedOpsConstParamLabel_t") int paramLabel,
                                        Pointer param,
                                        int[] isNULL);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateFusedOpsVariantParamPack(@ByPtrPtr cudnnFusedOpsVariantParamStruct varPack, @Cast("cudnnFusedOps_t") int ops);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyFusedOpsVariantParamPack(cudnnFusedOpsVariantParamStruct varPack);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetFusedOpsVariantParamPackAttribute(cudnnFusedOpsVariantParamStruct varPack,
                                          @Cast("cudnnFusedOpsVariantParamLabel_t") int paramLabel,
                                          Pointer ptr);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetFusedOpsVariantParamPackAttribute(cudnnFusedOpsVariantParamStruct varPack,
                                          @Cast("cudnnFusedOpsVariantParamLabel_t") int paramLabel,
                                          Pointer ptr);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateFusedOpsPlan(@ByPtrPtr cudnnFusedOpsPlanStruct plan, @Cast("cudnnFusedOps_t") int ops);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyFusedOpsPlan(cudnnFusedOpsPlanStruct plan);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnMakeFusedOpsPlan(cudnnContext handle,
                      cudnnFusedOpsPlanStruct plan,
                      cudnnFusedOpsConstParamStruct constPack,
                      @Cast("size_t*") SizeTPointer workspaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFusedOpsExecute(cudnnContext handle, cudnnFusedOpsPlanStruct plan, cudnnFusedOpsVariantParamStruct varPack);

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_CNN_H_ */


// Parsed from <cudnn_backend.h>

/*
 * Copyright 2014-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #ifndef _CUDNN_BACKEND_H_
// #define _CUDNN_BACKEND_H_

/*
 * The content of this header has been moved into cudnn_graph.h.
 * This header is kept for the backward compatibility purpose.
 */

// #include "cudnn_graph.h"

// #endif /* _CUDNN_BACKEND_H_ */


}
