// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nppc;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nppc.*;


/**
 * Profile data type for radial and linear profiles
 */
@Properties(inherit = org.bytedeco.cuda.presets.nppc.class)
public class NppiProfileData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NppiProfileData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NppiProfileData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NppiProfileData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NppiProfileData position(long position) {
        return (NppiProfileData)super.position(position);
    }
    @Override public NppiProfileData getPointer(long i) {
        return new NppiProfileData((Pointer)this).offsetAddress(i);
    }

    /** profile data pixel count. */
    public native int nPixels(); public native NppiProfileData nPixels(int setter);    
    /** profile data mean intensity. */
    public native @Cast("Npp32f") float nMeanIntensity(); public native NppiProfileData nMeanIntensity(float setter);
    /** profile data standard deviation intensity. */
    public native @Cast("Npp32f") float nStdDevIntensity(); public native NppiProfileData nStdDevIntensity(float setter);
}
