// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvcomp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvcomp.*;


/**
 * \brief Config used to aggregate information about a particular decompression.
 *
 * Contains a "PinnedPtrHandle" to an nvcompStatus. After the decompression is complete,
 * the user can check the result status which resides in pinned host memory.
 */
@Namespace("nvcomp") @NoOffset @Properties(inherit = org.bytedeco.cuda.presets.nvcomp.class)
public class DecompressionConfig extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DecompressionConfig(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DecompressionConfig(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DecompressionConfig position(long position) {
        return (DecompressionConfig)super.position(position);
    }
    @Override public DecompressionConfig getPointer(long i) {
        return new DecompressionConfig((Pointer)this).offsetAddress(i);
    }

  @Opaque public static class DecompressionConfigImpl extends Pointer {
      /** Empty constructor. Calls {@code super((Pointer)null)}. */
      public DecompressionConfigImpl() { super((Pointer)null); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public DecompressionConfigImpl(Pointer p) { super(p); }
  }
  

  public native @Cast("size_t") long decomp_data_size(); public native DecompressionConfig decomp_data_size(long setter);
  public native @Cast("size_t") long num_chunks(); public native DecompressionConfig num_chunks(long setter);
  public native @Cast("bool") boolean checksums_present(); public native DecompressionConfig checksums_present(boolean setter);
  /**
  * \brief Default constructor that initializes members with default values.
  * The user cannot use the default constructor becaue PinnedPtrPool is forward declared,
  * and the pool cannot be created by the user. 
  */
  public DecompressionConfig() { super((Pointer)null); allocate(); }
  private native void allocate();

  /**
   * \brief Construct the config given an nvcompStatus_t memory pool
   */

  /**
   * \brief Get the nvcompStatus_t*
   */
  public native @Cast("nvcompStatus_t*") IntPointer get_status();

  public DecompressionConfig(@ByRef(true) DecompressionConfig other) { super((Pointer)null); allocate(other); }
  private native void allocate(@ByRef(true) DecompressionConfig other);
  public native @ByRef @Name("operator =") DecompressionConfig put(@ByRef(true) DecompressionConfig other);
}
