// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvcomp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvcomp.*;


/**
 * \brief Format specification for Deflate compression
 */
@Namespace("nvcomp") @Properties(inherit = org.bytedeco.cuda.presets.nvcomp.class)
public class DeflateFormatSpecHeader extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public DeflateFormatSpecHeader() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DeflateFormatSpecHeader(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DeflateFormatSpecHeader(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public DeflateFormatSpecHeader position(long position) {
        return (DeflateFormatSpecHeader)super.position(position);
    }
    @Override public DeflateFormatSpecHeader getPointer(long i) {
        return new DeflateFormatSpecHeader((Pointer)this).offsetAddress(i);
    }

/**
 * Compression algorithm to use. Permitted values are:
 * - 0: highest-throughput, entropy-only compression (use for symmetric compression/decompression performance)
 * - 1: high-throughput, low compression ratio (default)
 * - 2: medium-througput, medium compression ratio, beat Zlib level 1 on the compression ratio
 * - 3: placeholder for further compression level support, will fall into MEDIUM_COMPRESSION at this point
 * - 4: lower-throughput, higher compression ratio, beat Zlib level 6 on the compression ratio
 * - 5: lowest-throughput, highest compression ratio
 */
    public native int algo(); public native DeflateFormatSpecHeader algo(int setter);
}
