// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvcomp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvcomp.*;


/**
 * \brief Interface class between nvcompManagerBase and
 * algorithm specific implementation class
 */
@Namespace("nvcomp") @Properties(inherit = org.bytedeco.cuda.presets.nvcomp.class)
public class PimplManager extends nvcompManagerBase {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PimplManager(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public PimplManager(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public PimplManager position(long position) {
        return (PimplManager)super.position(position);
    }
    @Override public PimplManager getPointer(long i) {
        return new PimplManager((Pointer)this).offsetAddress(i);
    }


  

  public PimplManager() { super((Pointer)null); allocate(); }
  private native void allocate();

  
  

  public native @ByVal CompressionConfig configure_compression(@Cast("const size_t") long uncomp_buffer_size);

  public native @StdVector CompressionConfig configure_compression(
      @Cast("size_t*") @StdVector SizeTPointer uncomp_buffer_sizes);

  public native void compress(
      @Cast("const uint8_t*") BytePointer uncomp_buffer,
      @Cast("uint8_t*") BytePointer comp_buffer,
      @Const @ByRef CompressionConfig comp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void compress(
      @Cast("const uint8_t*") BytePointer uncomp_buffer,
      @Cast("uint8_t*") BytePointer comp_buffer,
      @Const @ByRef CompressionConfig comp_config);
  public native void compress(
      @Cast("const uint8_t*") ByteBuffer uncomp_buffer,
      @Cast("uint8_t*") ByteBuffer comp_buffer,
      @Const @ByRef CompressionConfig comp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void compress(
      @Cast("const uint8_t*") ByteBuffer uncomp_buffer,
      @Cast("uint8_t*") ByteBuffer comp_buffer,
      @Const @ByRef CompressionConfig comp_config);
  public native void compress(
      @Cast("const uint8_t*") byte[] uncomp_buffer,
      @Cast("uint8_t*") byte[] comp_buffer,
      @Const @ByRef CompressionConfig comp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void compress(
      @Cast("const uint8_t*") byte[] uncomp_buffer,
      @Cast("uint8_t*") byte[] comp_buffer,
      @Const @ByRef CompressionConfig comp_config);

  public native void compress(
      @Cast("const uint8_t*const*") PointerPointer uncomp_buffers,
      @Cast("uint8_t*const*") PointerPointer comp_buffers,
      @StdVector CompressionConfig comp_configs,
      @Cast("size_t*") SizeTPointer comp_sizes/*=nullptr*/);

  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") BytePointer comp_buffer, @Cast("const size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") BytePointer comp_buffer);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") ByteBuffer comp_buffer, @Cast("const size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") ByteBuffer comp_buffer);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") byte[] comp_buffer, @Cast("const size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") byte[] comp_buffer);

  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") PointerPointer comp_buffers, @Cast("size_t") long batch_size, @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr BytePointer comp_buffers, @Cast("size_t") long batch_size);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr BytePointer comp_buffers, @Cast("size_t") long batch_size, @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr ByteBuffer comp_buffers, @Cast("size_t") long batch_size, @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr ByteBuffer comp_buffers, @Cast("size_t") long batch_size);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr byte[] comp_buffers, @Cast("size_t") long batch_size, @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr byte[] comp_buffers, @Cast("size_t") long batch_size);

  public native @ByVal DecompressionConfig configure_decompression(@Const @ByRef CompressionConfig comp_config);

  public native void decompress(
      @Cast("uint8_t*") BytePointer decomp_buffer,
      @Cast("const uint8_t*") BytePointer comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void decompress(
      @Cast("uint8_t*") BytePointer decomp_buffer,
      @Cast("const uint8_t*") BytePointer comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config);
  public native void decompress(
      @Cast("uint8_t*") ByteBuffer decomp_buffer,
      @Cast("const uint8_t*") ByteBuffer comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void decompress(
      @Cast("uint8_t*") ByteBuffer decomp_buffer,
      @Cast("const uint8_t*") ByteBuffer comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config);
  public native void decompress(
      @Cast("uint8_t*") byte[] decomp_buffer,
      @Cast("const uint8_t*") byte[] comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void decompress(
      @Cast("uint8_t*") byte[] decomp_buffer,
      @Cast("const uint8_t*") byte[] comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config);

  public native void decompress(
      @Cast("uint8_t*const*") PointerPointer decomp_buffers,
      @Cast("const uint8_t*const*") PointerPointer comp_buffers,
      @StdVector DecompressionConfig decomp_configs,
      @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);

  

  public native @Cast("size_t") long get_compressed_output_size(@Cast("const uint8_t*") BytePointer comp_buffer);
  public native @Cast("size_t") long get_compressed_output_size(@Cast("const uint8_t*") ByteBuffer comp_buffer);
  public native @Cast("size_t") long get_compressed_output_size(@Cast("const uint8_t*") byte[] comp_buffer);

  public native @Cast("size_t*") @StdVector SizeTPointer get_compressed_output_size(
      @Cast("const uint8_t*const*") PointerPointer comp_buffers, @Cast("size_t") long batch_size);
  public native @Cast("size_t*") @StdVector SizeTPointer get_compressed_output_size(
      @Cast("const uint8_t*const*") @ByPtrPtr BytePointer comp_buffers, @Cast("size_t") long batch_size);
  public native @Cast("size_t*") @StdVector SizeTPointer get_compressed_output_size(
      @Cast("const uint8_t*const*") @ByPtrPtr ByteBuffer comp_buffers, @Cast("size_t") long batch_size);
  public native @Cast("size_t*") @StdVector SizeTPointer get_compressed_output_size(
      @Cast("const uint8_t*const*") @ByPtrPtr byte[] comp_buffers, @Cast("size_t") long batch_size);

  public native void deallocate_gpu_mem();
}
