// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvcomp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvcomp.*;

// #endif

/******************************************************************************
 * Batched compression/decompression interface
 *****************************************************************************/

/**
 * \brief Structure for configuring Bitcomp compression.
 */
@Properties(inherit = org.bytedeco.cuda.presets.nvcomp.class)
public class nvcompBatchedBitcompOpts_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public nvcompBatchedBitcompOpts_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public nvcompBatchedBitcompOpts_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvcompBatchedBitcompOpts_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public nvcompBatchedBitcompOpts_t position(long position) {
        return (nvcompBatchedBitcompOpts_t)super.position(position);
    }
    @Override public nvcompBatchedBitcompOpts_t getPointer(long i) {
        return new nvcompBatchedBitcompOpts_t((Pointer)this).offsetAddress(i);
    }

  /**
   * \brief Bitcomp algorithm options.
   * 
   * - 0 : Default algorithm, usually gives the best compression ratios
   * - 1 : "Sparse" algorithm, works well on sparse data (with lots of zeroes)
   *        and is usually faster than the default algorithm.
   */
  public native int algorithm_type(); public native nvcompBatchedBitcompOpts_t algorithm_type(int setter);
  /**
   * \brief One of nvcomp's possible data types
   */
  public native @Cast("nvcompType_t") int data_type(); public native nvcompBatchedBitcompOpts_t data_type(int setter);
}
