// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvcomp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvcomp.*;


/**
 * \brief Abstract base class that defines the nvCOMP high-level interface
 */
@Namespace("nvcomp") @Properties(inherit = org.bytedeco.cuda.presets.nvcomp.class)
public class nvcompManagerBase extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvcompManagerBase(Pointer p) { super(p); }

  /**
   * \brief Configure the compression of a single buffer.
   *
   * This routine computes the size of the required result buffer. The result config also
   * contains the nvcompStatus* that allows error checking.
   *
   * @param uncomp_buffer_size [in] The uncompressed input data size (in bytes).
   *
   * @return CompressionConfig for the size provided.
   */
  public native @ByVal CompressionConfig configure_compression(
      @Cast("const size_t") long uncomp_buffer_size);

  /**
   * \brief Configure the compression of a batch of buffers.
   *
   * This routine computes the size of the required result buffer for each element of the batch.
   * The result config also contains the nvcompStatus* that allows error checking.
   *
   * @param uncomp_buffer_sizes [in] The vector of uncompressed input data sizes (in bytes) for each element of the batch.
   *
   * @return A vector with CompressionConfig for each of the size provided.
   */
  public native @StdVector CompressionConfig configure_compression(
      @Cast("size_t*") @StdVector SizeTPointer uncomp_buffer_sizes);

  /**
   * \brief Perform compression asynchronously for a single buffer.
   *
   * @param uncomp_buffer [in] The uncompressed input data.
   * (a pointer to device continuous memory).
   *
   * @param comp_buffer [out] The location to output the compressed data to.
   * (a pointer to device continuous memory)
   * Size requirement is provided in CompressionConfig.
   *
   * @param comp_config [in] Generated for the current uncomp_buffer with configure_compression.
   *
   * @param comp_size [out] The location to output size in bytes after compression.
   * (a pointer to a single size_t variable on device)
   * Optional when bitstream kind is NVCOMP_NATIVE.
   */
  public native void compress(
      @Cast("const uint8_t*") BytePointer uncomp_buffer,
      @Cast("uint8_t*") BytePointer comp_buffer,
      @Const @ByRef CompressionConfig comp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void compress(
      @Cast("const uint8_t*") BytePointer uncomp_buffer,
      @Cast("uint8_t*") BytePointer comp_buffer,
      @Const @ByRef CompressionConfig comp_config);
  public native void compress(
      @Cast("const uint8_t*") ByteBuffer uncomp_buffer,
      @Cast("uint8_t*") ByteBuffer comp_buffer,
      @Const @ByRef CompressionConfig comp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void compress(
      @Cast("const uint8_t*") ByteBuffer uncomp_buffer,
      @Cast("uint8_t*") ByteBuffer comp_buffer,
      @Const @ByRef CompressionConfig comp_config);
  public native void compress(
      @Cast("const uint8_t*") byte[] uncomp_buffer,
      @Cast("uint8_t*") byte[] comp_buffer,
      @Const @ByRef CompressionConfig comp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void compress(
      @Cast("const uint8_t*") byte[] uncomp_buffer,
      @Cast("uint8_t*") byte[] comp_buffer,
      @Const @ByRef CompressionConfig comp_config);

  /**
   * \brief Perform compression asynchronously for a batch of buffers.
   * Batch size is inferred from comp_configs size.
   *
   * @param uncomp_buffers [in] The uncompressed input data.
   * (a pointer to a host array of pointers to device continuous memory)
   *
   * @param comp_buffers [out] The location to output the compressed data to.
   * (a pointer to a host array of pointers to device continuous memory)
   * Size requirement is provided in CompressionConfig.
   *
   * @param comp_configs [in] Generated for the current uncomp_buffers with configure_compression.
   *
   * @param comp_sizes [out] The location to output size in bytes after compression.
   * (a pointer to a device array, with size enough to contain batch_size elements of type size_t)
   * Optional when bitstream kind is NVCOMP_NATIVE.
   */
  public native void compress(
      @Cast("const uint8_t*const*") PointerPointer uncomp_buffers,
      @Cast("uint8_t*const*") PointerPointer comp_buffers,
      @StdVector CompressionConfig comp_configs,
      @Cast("size_t*") SizeTPointer comp_sizes/*=nullptr*/);

  /**
   * \brief Configure the decompression for a single buffer using a compressed buffer.
   *
   * Synchronizes the user stream.
   * - If bitstream kind is NVCOMP_NATIVE, it will parse the header in comp_buffer.
   * - If bitstream kind is RAW, it may be required (e.g for LZ4) to parse the whole comp_buffer,
   *   which could be significantly slower that other options.
   * - If bitstream kind is WITH_UNCOMPRESSED_SIZE, it will read the size from the beginning of the comp_buffer.
   *
   * @param comp_buffer [in] The compressed input data.
   * (a pointer to device continuous memory)
   *
   * @param comp_size [in] Size of the compressed input data. This is required only for RAW format.
   * (a pointer to device variable with compressed size)
   *
   * @return DecompressionConfig for the comp_buffer provided.
   */
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") BytePointer comp_buffer, @Cast("const size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") BytePointer comp_buffer);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") ByteBuffer comp_buffer, @Cast("const size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") ByteBuffer comp_buffer);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") byte[] comp_buffer, @Cast("const size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") byte[] comp_buffer);

  /**
   * \brief Configure the decompression for a batch of buffers using a compressed buffer.
   *
   * Synchronizes the user stream.
   * - If bitstream kind is NVCOMP_NATIVE, it will parse the header in comp_buffers.
   * - If bitstream kind is RAW, it may be required (e.g for LZ4) to parse the whole comp_buffers,
   *   which could be significantly slower that other options.
   * - If bitstream kind is WITH_UNCOMPRESSED_SIZE, it will read the size from the beginning of the comp_buffers.
   *
   * @param comp_buffers [in] The compressed input data.
   * (a pointer to host arrays of pointers to device continuous memory)
   *
   * @param batch_size [in] The size of the batch.
   *
   * @param comp_sizes [in] Size of the compressed input data.
   * (a pointer to device array)
   * This is required only for RAW format.
   *
   * @return A vector of DecompressionConfig for each of the comp_buffer provided.
   */
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") PointerPointer comp_buffers, @Cast("size_t") long batch_size, @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr BytePointer comp_buffers, @Cast("size_t") long batch_size);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr BytePointer comp_buffers, @Cast("size_t") long batch_size, @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr ByteBuffer comp_buffers, @Cast("size_t") long batch_size, @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr ByteBuffer comp_buffers, @Cast("size_t") long batch_size);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr byte[] comp_buffers, @Cast("size_t") long batch_size, @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);
  public native @StdVector DecompressionConfig configure_decompression(
      @Cast("const uint8_t*const*") @ByPtrPtr byte[] comp_buffers, @Cast("size_t") long batch_size);

  /**
   * \brief Configure the decompression for a single buffer using a CompressionConfig object.
   *
   * Does not synchronize the user stream.
   *
   * @param comp_config [in] The config used to compress a buffer.
   *
   * @return DecompressionConfig based on compression config provided.
   */
  public native @ByVal DecompressionConfig configure_decompression(
      @Const @ByRef CompressionConfig comp_config);

  /**
   * \brief Configure the decompression for a batch of buffers using a CompressionConfig objects.
   *
   * Does not synchronize the user stream.
   *
   * @param comp_configs [in] A vector of configs used to compress a batch of buffers.
   *
   * @return A vector of DecompressionConfig based on compression configs provided.
   */

  /**
   * \brief Perform decompression asynchronously of a single buffer.
   *
   * @param decomp_buffer [out] The location to output the decompressed data to.
   * (a pointer to device continuous memory)
   * Size requirement is provided in DecompressionConfig.
   *
   * @param comp_buffer [in] The compressed input data.
   * (a pointer to device continuous memory)
   *
   * @param decomp_config [in] Resulted from configure_decompression given this comp_buffer.
   * Contains nvcompStatus* in host/device-accessible memory to allow error checking.
   *
   * @param comp_size [in] The size of compressed input data passed.
   * (a pointer to a single size_t variable on device)
   * Optional when bitstream kind is NVCOMP_NATIVE.
   */
  public native void decompress(
      @Cast("uint8_t*") BytePointer decomp_buffer,
      @Cast("const uint8_t*") BytePointer comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void decompress(
      @Cast("uint8_t*") BytePointer decomp_buffer,
      @Cast("const uint8_t*") BytePointer comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config);
  public native void decompress(
      @Cast("uint8_t*") ByteBuffer decomp_buffer,
      @Cast("const uint8_t*") ByteBuffer comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void decompress(
      @Cast("uint8_t*") ByteBuffer decomp_buffer,
      @Cast("const uint8_t*") ByteBuffer comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config);
  public native void decompress(
      @Cast("uint8_t*") byte[] decomp_buffer,
      @Cast("const uint8_t*") byte[] comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config,
      @Cast("size_t*") SizeTPointer comp_size/*=nullptr*/);
  public native void decompress(
      @Cast("uint8_t*") byte[] decomp_buffer,
      @Cast("const uint8_t*") byte[] comp_buffer,
      @Const @ByRef DecompressionConfig decomp_config);

  /**
   * \brief Perform decompression asynchronously of a batch of buffers.
   *
   * @param decomp_buffers [out] The location to output the decompressed data to.
   * (a pointer to a host array of pointers to device continuous memory)
   * Size requirement is provided in DecompressionConfig.
   *
   * @param comp_buffers [in] The compressed input data.
   * (a pointer to a host array of pointers to device continuous memory with uncompressed data)
   *
   * @param decomp_configs [in] Resulted from configure_decompression given this comp_buffers.
   * Contains nvcompStatus* in host/device-accessible memory to allow error checking.
   *
   * @param comp_sizes [in] The size of compressed input data passed.
   * (a pointer to a device array, with size enough to contain batch_size elements of type size_t)
   * Optional when bitstream kind is NVCOMP_NATIVE.
   */
  public native void decompress(
      @Cast("uint8_t*const*") PointerPointer decomp_buffers,
      @Cast("const uint8_t*const*") PointerPointer comp_buffers,
      @StdVector DecompressionConfig decomp_configs,
      @Cast("const size_t*") SizeTPointer comp_sizes/*=nullptr*/);

  /**
   * \brief Allows the user to provide a function for allocating / deallocating memory
   *
   * The manager requires scratch memory to perform its operations.
   * By default, it will use internal allocators which make use of
   * cudaMallocAsync / cudaFreeAsync
   * The user can override the allocation functions with this API.
   * The required signatures are
   *   void* alloc_fn(size_t alloc_size)
   * and
   *   void dealloc_fn(void* buffer, size_t alloc_size)
   *
   * This API copies the allocation functions. The copied functions must be valid until
   * either
   *  1) deallocate_gpu_mem() is called or
   *  2) the nvcompManager instance is destroyed
   *
   * If a scratch buffer was previously allocated, it is first deallocated using the prior
   * dealloc_fn (or cudaFreeAsync if one wasn't previously provided)
   *
   * @param alloc_fn [in] The host function to use to alloc a new scratch result buffer.
   * @param dealloc_fn [in] The host function to use to dealloc a scratch result buffer.
   * 
   */
  
  
  /** 
   * \brief Computes the compressed output size (in bytes) of a given buffer.
   *
   * Synchronously copies the size of the compressed buffer to a host variable for return.
   *
   * Can only be used with NVCOMP_NATIVE bitstream kind.
   *
   * To obtain compressed sizes one can also cudaMemcpy sizes from comp_sizes passed to compress function.
   *
   * @param comp_buffer [in] The compressed input data.
   * (a pointer to device continuous memory)
   *
   * @return Size of the compressed buffer.
   */
  public native @Cast("size_t") long get_compressed_output_size(@Cast("const uint8_t*") BytePointer comp_buffer);
  public native @Cast("size_t") long get_compressed_output_size(@Cast("const uint8_t*") ByteBuffer comp_buffer);
  public native @Cast("size_t") long get_compressed_output_size(@Cast("const uint8_t*") byte[] comp_buffer);

  /**
   * \brief Computes the compressed output size (in bytes) of a given batch of buffers.
   *
   * Synchronously copies the size of the compressed buffer to a host variable for return.
   *
   * Can only be used with NVCOMP_NATIVE bitstream kind.
   *
   * To obtain compressed sizes one can also cudaMemcpy sizes from comp_sizes passed to compress function.
   *
   * @param comp_buffers [in] The compressed input data.
   * (a pointer host array of pointers to device continuous memory)
   *
   * @return A vector with sizes of each compressed buffer in the batch.
   */ 
  public native @Cast("size_t*") @StdVector SizeTPointer get_compressed_output_size(
      @Cast("const uint8_t*const*") PointerPointer comp_buffers, @Cast("size_t") long batch_size);
  public native @Cast("size_t*") @StdVector SizeTPointer get_compressed_output_size(
      @Cast("const uint8_t*const*") @ByPtrPtr BytePointer comp_buffers, @Cast("size_t") long batch_size);
  public native @Cast("size_t*") @StdVector SizeTPointer get_compressed_output_size(
      @Cast("const uint8_t*const*") @ByPtrPtr ByteBuffer comp_buffers, @Cast("size_t") long batch_size);
  public native @Cast("size_t*") @StdVector SizeTPointer get_compressed_output_size(
      @Cast("const uint8_t*const*") @ByPtrPtr byte[] comp_buffers, @Cast("size_t") long batch_size);


  /**
   * \brief Frees any internal GPU memory used by the nvCOMP HLIF
   *
   * Returns this memory back through the deallocator if one was specified through set_scratch_allocators()
  */
  public native void deallocate_gpu_mem();
}
