// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvml;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvml.*;


/**
 * Structure to store platform information (v2)
 */
@Properties(inherit = org.bytedeco.cuda.presets.nvml.class)
public class nvmlPlatformInfo_v2_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public nvmlPlatformInfo_v2_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public nvmlPlatformInfo_v2_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvmlPlatformInfo_v2_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public nvmlPlatformInfo_v2_t position(long position) {
        return (nvmlPlatformInfo_v2_t)super.position(position);
    }
    @Override public nvmlPlatformInfo_v2_t getPointer(long i) {
        return new nvmlPlatformInfo_v2_t((Pointer)this).offsetAddress(i);
    }

    /** the API version number */
    public native @Cast("unsigned int") int version(); public native nvmlPlatformInfo_v2_t version(int setter);
    /** Infiniband GUID reported by platform (for Blackwell, ibGuid is 8 bytes so indices 8-15 are zero) */
    public native @Cast("unsigned char") byte ibGuid(int i); public native nvmlPlatformInfo_v2_t ibGuid(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer ibGuid();
    /** Serial number of the chassis containing this GPU (for Blackwell it is 13 bytes so indices 13-15 are zero) */
    public native @Cast("unsigned char") byte chassisSerialNumber(int i); public native nvmlPlatformInfo_v2_t chassisSerialNumber(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer chassisSerialNumber();
    /** The slot number in the chassis containing this GPU (includes switches) */
    public native @Cast("unsigned char") byte slotNumber(); public native nvmlPlatformInfo_v2_t slotNumber(byte setter);
    /** The tray index within the compute slots in the chassis containing this GPU (does not include switches) */
    public native @Cast("unsigned char") byte trayIndex(); public native nvmlPlatformInfo_v2_t trayIndex(byte setter);
    /** Index of the node within the slot containing this GPU */
    public native @Cast("unsigned char") byte hostId(); public native nvmlPlatformInfo_v2_t hostId(byte setter);
    /** Platform indicated NVLink-peer type (e.g. switch present or not) */
    public native @Cast("unsigned char") byte peerType(); public native nvmlPlatformInfo_v2_t peerType(byte setter);
    /** ID of this GPU within the node */
    public native @Cast("unsigned char") byte moduleId(); public native nvmlPlatformInfo_v2_t moduleId(byte setter);
}
