// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvrtc;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvrtc.*;


/**
 * \ingroup compilation
 * \brief   nvrtcSetFlowCallback registers a callback function that the compiler 
 *          will invoke at different points during a call to nvrtcCompileProgram, 
 *          and the callback function can decide whether to cancel compilation by
 *          returning specific values.
 * 
 * The callback function must satisfy the following constraints:
 * 
 * (1) Its signature should be:
 *     <pre>{@code
 *     int callback(void* param1, void* param2);
 *     }</pre>
 *     When invoking the callback, the compiler will always pass \p payload to 
 *     param1 so that the callback may make decisions based on \p payload . It'll
 *     always pass NULL to param2 for now which is reserved for future extensions.
 * 
 * (2) It must return 1 to cancel compilation or 0 to continue. 
 *     Other return values are reserved for future use. 
 * 
 * (3) It must return consistent values. Once it returns 1 at one point, it must
 *     return 1 in all following invocations during the current nvrtcCompileProgram
 *     call in progress.
 * 
 * (4) It must be thread-safe.
 * 
 * (5) It must not invoke any nvrtc/libnvvm/ptx APIs.
 *  
 * @param prog [in] CUDA Runtime Compilation program.
 * @param callback [in] the callback that issues cancellation signal.
 * @param payload [in] to be passed as a parameter when invoking the callback.
 * @return
 *   - \link #nvrtcResult NVRTC_SUCCESS \endlink
 *   - \link #nvrtcResult NVRTC_ERROR_INVALID_PROGRAM \endlink
 *   - \link #nvrtcResult NVRTC_ERROR_INVALID_INPUT \endlink
 */
@Properties(inherit = org.bytedeco.cuda.presets.nvrtc.class)
public class Callback_Pointer_Pointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    Callback_Pointer_Pointer(Pointer p) { super(p); }
    protected Callback_Pointer_Pointer() { allocate(); }
    private native void allocate();
    public native int call(Pointer arg0, Pointer arg1);
}
