// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;

/**
 * CalibrationHandler is an interface to read/load/write structured calibration and device data.
 * The following fields are protected and aren't allowed to be overridden by default:
 *  - boardName
 *  - boardRev
 *  - boardConf
 *  - hardwareConf
 *  - batchName
 *  - batchTime
 *  - boardOptions
 *  - productName
 */
@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class CalibrationHandler extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CalibrationHandler(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CalibrationHandler(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public CalibrationHandler position(long position) {
        return (CalibrationHandler)super.position(position);
    }
    @Override public CalibrationHandler getPointer(long i) {
        return new CalibrationHandler((Pointer)this).offsetAddress(i);
    }

    public CalibrationHandler() { super((Pointer)null); allocate(); }
    private native void allocate();

    /**
     * Construct a new Calibration Handler object using the
     * eeprom json file created from calibration procedure.
     *
     * @param eepromDataPath takes the full path to the json file containing the calibration and device info.
     */
    public CalibrationHandler(@ByVal Path eepromDataPath) { super((Pointer)null); allocate(eepromDataPath); }
    private native void allocate(@ByVal Path eepromDataPath);

    /**
     * Construct a new Calibration Handler object using the board
     * config json file and .calib binary files created using gen1 calibration.
     *
     * @param calibrationDataPath Full Path to the .calib binary file from the gen1 calibration. (Supports only Version 5)
     * @param boardConfigPath Full Path to the board config json file containing device information.
     */
    public CalibrationHandler(@ByVal Path calibrationDataPath, @ByVal Path boardConfigPath) { super((Pointer)null); allocate(calibrationDataPath, boardConfigPath); }
    private native void allocate(@ByVal Path calibrationDataPath, @ByVal Path boardConfigPath);

    /**
     * Construct a new Calibration Handler object from EepromData object.
     *
     * @param eepromData EepromData data structure containing the calibration data.
     */
    public CalibrationHandler(@ByVal EepromData eepromData) { super((Pointer)null); allocate(eepromData); }
    private native void allocate(@ByVal EepromData eepromData);

    /**
     * Construct a new Calibration Handler object from JSON EepromData.
     *
     * @param eepromDataJson EepromData as JSON
     */
    public static native @ByVal CalibrationHandler fromJson(@ByVal @Cast("nlohmann::json*") Pointer eepromDataJson);

    /**
     * Get the Eeprom Data object
     *
     * @return EepromData object which contains the raw calibration data
     */
    public native @ByVal EepromData getEepromData();

    /**
     * Get the Camera Intrinsics object
     *
     * @param cameraId Uses the cameraId to identify which camera intrinsics to return
     * @param resizewidth resized width of the image for which intrinsics is requested.  resizewidth = -1 represents width is same as default intrinsics
     * @param resizeHeight resized height of the image for which intrinsics is requested.  resizeHeight = -1 represents height is same as default intrinsics
     * @param topLeftPixelId (x, y) point represents the top left corner coordinates of the cropped image which is used to modify the intrinsics for the
     * respective cropped image
     * @param bottomRightPixelId (x, y) point represents the bottom right corner coordinates of the cropped image which is used to modify the intrinsics for
     * the respective cropped image
     * @param keepAspectRatio Enabling this will scale on width or height depending on which provides the max resolution and crops the remaining part of the
     * other side
     * @return Represents the 3x3 intrinsics matrix of the respective camera at the requested size and crop dimensions.
     *
     * Matrix representation of intrinsic matrix
     * <pre>{@code \[ \text{Intrinsic Matrix} = \left [ \begin{matrix}
     *                                        f_x & 0 & c_x \\
     *                                        0 & f_y & c_y \\
     *                                        0 &  0  & 1
     *                                      \end{matrix} \right ] \]}</pre>
     *
     */
    public native @ByVal FloatVectorVector getCameraIntrinsics(CameraBoardSocket cameraId,
                                                            int resizeWidth/*=-1*/,
                                                            int resizeHeight/*=-1*/,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f topLeftPixelId,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f bottomRightPixelId,
                                                            @Cast("bool") boolean keepAspectRatio/*=true*/);
    public native @ByVal FloatVectorVector getCameraIntrinsics(CameraBoardSocket cameraId);
    public native @ByVal FloatVectorVector getCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId,
                                                            int resizeWidth/*=-1*/,
                                                            int resizeHeight/*=-1*/,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f topLeftPixelId,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f bottomRightPixelId,
                                                            @Cast("bool") boolean keepAspectRatio/*=true*/);
    public native @ByVal FloatVectorVector getCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId);

    /**
     * Get the Camera Intrinsics object
     *
     * @param cameraId Uses the cameraId to identify which camera intrinsics to return
     * @param destShape resized width and height of the image for which intrinsics is requested.
     * @param topLeftPixelId (x, y) point represents the top left corner coordinates of the cropped image which is used to modify the intrinsics for the
     * respective cropped image
     * @param bottomRightPixelId (x, y) point represents the bottom right corner coordinates of the cropped image which is used to modify the intrinsics for
     * the respective cropped image
     * @param keepAspectRatio Enabling this will scale on width or height depending on which provides the max resolution and crops the remaining part of the
     * other side
     * @return Represents the 3x3 intrinsics matrix of the respective camera at the requested size and crop dimensions.
     *
     * Matrix representation of intrinsic matrix
     * <pre>{@code \[ \text{Intrinsic Matrix} = \left [ \begin{matrix}
     *                                        f_x & 0 & c_x \\
     *                                        0 & f_y & c_y \\
     *                                        0 &  0  & 1
     *                                      \end{matrix} \right ] \]}</pre>
     *
     */
    public native @ByVal FloatVectorVector getCameraIntrinsics(CameraBoardSocket cameraId,
                                                            @ByVal Size2f destShape,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f topLeftPixelId,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f bottomRightPixelId,
                                                            @Cast("bool") boolean keepAspectRatio/*=true*/);
    public native @ByVal FloatVectorVector getCameraIntrinsics(CameraBoardSocket cameraId,
                                                            @ByVal Size2f destShape);
    public native @ByVal FloatVectorVector getCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId,
                                                            @ByVal Size2f destShape,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f topLeftPixelId,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f bottomRightPixelId,
                                                            @Cast("bool") boolean keepAspectRatio/*=true*/);
    public native @ByVal FloatVectorVector getCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId,
                                                            @ByVal Size2f destShape);

    /**
     * Get the Camera Intrinsics object
     *
     * @param cameraId Uses the cameraId to identify which camera intrinsics to return
     * @param destShape resized width and height of the image for which intrinsics is requested.
     * @param topLeftPixelId (x, y) point represents the top left corner coordinates of the cropped image which is used to modify the intrinsics for the
     * respective cropped image
     * @param bottomRightPixelId (x, y) point represents the bottom right corner coordinates of the cropped image which is used to modify the intrinsics for
     * the respective cropped image
     * @param keepAspectRatio Enabling this will scale on width or height depending on which provides the max resolution and crops the remaining part of the
     * other side
     * @return Represents the 3x3 intrinsics matrix of the respective camera at the requested size and crop dimensions.
     *
     * Matrix representation of intrinsic matrix
     * <pre>{@code \[ \text{Intrinsic Matrix} = \left [ \begin{matrix}
     *                                        f_x & 0 & c_x \\
     *                                        0 & f_y & c_y \\
     *                                        0 &  0  & 1
     *                                      \end{matrix} \right ] \]}</pre>
     *
     */
    public native @ByVal FloatVectorVector getCameraIntrinsics(CameraBoardSocket cameraId,
                                                            @ByVal @Cast("std::tuple<int,int>*") Pointer destShape,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f topLeftPixelId,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f bottomRightPixelId,
                                                            @Cast("bool") boolean keepAspectRatio/*=true*/);
    public native @ByVal FloatVectorVector getCameraIntrinsics(CameraBoardSocket cameraId,
                                                            @ByVal @Cast("std::tuple<int,int>*") Pointer destShape);
    public native @ByVal FloatVectorVector getCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId,
                                                            @ByVal @Cast("std::tuple<int,int>*") Pointer destShape,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f topLeftPixelId,
                                                            @ByVal(nullValue = "dai::Point2f()") Point2f bottomRightPixelId,
                                                            @Cast("bool") boolean keepAspectRatio/*=true*/);
    public native @ByVal FloatVectorVector getCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId,
                                                            @ByVal @Cast("std::tuple<int,int>*") Pointer destShape);

    /**
     * Get the Default Intrinsics object
     *
     * @param cameraId Uses the cameraId to identify which camera intrinsics to return
     * @return Represents the 3x3 intrinsics matrix of the respective camera along with width and height at which it was calibrated.
     *
     * Matrix representation of intrinsic matrix
     * <pre>{@code \[ \text{Intrinsic Matrix} = \left [ \begin{matrix}
     *                                        f_x & 0 & c_x \\
     *                                        0 & f_y & c_y \\
     *                                        0 &  0  & 1
     *                                      \end{matrix} \right ] \]}</pre>
     *
     */
    public native @ByVal FloatVectorVectorIntIntTuple getDefaultIntrinsics(CameraBoardSocket cameraId);
    public native @ByVal FloatVectorVectorIntIntTuple getDefaultIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId);

    /**
     * Get the Distortion Coefficients object
     *
     * @param cameraId Uses the cameraId to identify which distortion Coefficients to return.
     * @return the distortion coefficients of the requested camera in this order: [k1,k2,p1,p2,k3,k4,k5,k6,s1,s2,s3,s4,??x,??y]
     */
    public native @StdVector FloatPointer getDistortionCoefficients(CameraBoardSocket cameraId);
    public native @StdVector FloatBuffer getDistortionCoefficients(@Cast("dai::CameraBoardSocket") int cameraId);

    /**
     *  Get the Fov of the camera
     *
     * @param cameraId of the camera of which we are fetching fov.
     * @param useSpec Disabling this bool will calculate the fov based on intrinsics (focal length, image width), instead of getting it from the camera specs
     * @return field of view of the camera with given cameraId.
     */
    public native float getFov(CameraBoardSocket cameraId, @Cast("bool") boolean useSpec/*=true*/);
    public native float getFov(CameraBoardSocket cameraId);
    public native float getFov(@Cast("dai::CameraBoardSocket") int cameraId, @Cast("bool") boolean useSpec/*=true*/);
    public native float getFov(@Cast("dai::CameraBoardSocket") int cameraId);

    /**
     *  Get the lens position of the given camera
     *
     * @param cameraId of the camera with lens position is requested.
     * @return lens position of the camera with given cameraId at which it was calibrated.
     */
    public native @Cast("uint8_t") byte getLensPosition(CameraBoardSocket cameraId);
    public native @Cast("uint8_t") byte getLensPosition(@Cast("dai::CameraBoardSocket") int cameraId);

    /**
     *  Get the distortion model of the given camera
     *
     * @param cameraId of the camera with lens position is requested.
     * @return lens position of the camera with given cameraId at which it was calibrated.
     */
    public native CameraModel getDistortionModel(CameraBoardSocket cameraId);
    public native @Cast("dai::CameraModel") byte getDistortionModel(@Cast("dai::CameraBoardSocket") int cameraId);

    /**
     * Get the Camera Extrinsics object between two cameras from the calibration data if there is a linked connection
     *  between any two cameras then the relative rotation and translation (in centimeters) is returned by this function.
     *
     * @param srcCamera Camera Id of the camera which will be considered as origin.
     * @param dstCamera  Camera Id of the destination camera to which we are fetching the rotation and translation from the SrcCamera
     * @param useSpecTranslation Enabling this bool uses the translation information from the board design data
     * @return a transformationMatrix which is 4x4 in homogeneous coordinate system
     *
     * Matrix representation of transformation matrix
     * <pre>{@code \[ \text{Transformation Matrix} = \left [ \begin{matrix}
     *                                             r_{00} & r_{01} & r_{02} & T_x \\
     *                                             r_{10} & r_{11} & r_{12} & T_y \\
     *                                             r_{20} & r_{21} & r_{22} & T_z \\
     *                                               0    &   0    &   0    & 1
     *                                            \end{matrix} \right ] \]}</pre>
     *
     */
    public native @ByVal FloatVectorVector getCameraExtrinsics(CameraBoardSocket srcCamera, CameraBoardSocket dstCamera, @Cast("bool") boolean useSpecTranslation/*=false*/);
    public native @ByVal FloatVectorVector getCameraExtrinsics(CameraBoardSocket srcCamera, CameraBoardSocket dstCamera);
    public native @ByVal FloatVectorVector getCameraExtrinsics(@Cast("dai::CameraBoardSocket") int srcCamera, @Cast("dai::CameraBoardSocket") int dstCamera, @Cast("bool") boolean useSpecTranslation/*=false*/);
    public native @ByVal FloatVectorVector getCameraExtrinsics(@Cast("dai::CameraBoardSocket") int srcCamera, @Cast("dai::CameraBoardSocket") int dstCamera);

    /**
     * Get the Camera translation vector between two cameras from the calibration data.
     *
     * @param srcCamera Camera Id of the camera which will be considered as origin.
     * @param dstCamera  Camera Id of the destination camera to which we are fetching the translation vector from the SrcCamera
     * @param useSpecTranslation Disabling this bool uses the translation information from the calibration data (not the board design data)
     * @return a translation vector like [x, y, z] in centimeters
     */
    public native @StdVector FloatPointer getCameraTranslationVector(CameraBoardSocket srcCamera, CameraBoardSocket dstCamera, @Cast("bool") boolean useSpecTranslation/*=true*/);
    public native @StdVector FloatPointer getCameraTranslationVector(CameraBoardSocket srcCamera, CameraBoardSocket dstCamera);
    public native @StdVector FloatBuffer getCameraTranslationVector(@Cast("dai::CameraBoardSocket") int srcCamera, @Cast("dai::CameraBoardSocket") int dstCamera, @Cast("bool") boolean useSpecTranslation/*=true*/);
    public native @StdVector FloatBuffer getCameraTranslationVector(@Cast("dai::CameraBoardSocket") int srcCamera, @Cast("dai::CameraBoardSocket") int dstCamera);

    /**
     * Get the baseline distance between two specified cameras. By default it will get the baseline between CameraBoardSocket.RIGHT
     * and CameraBoardSocket.LEFT.
     *
     * @param cam1 First camera
     * @param cam2 Second camera
     * @param useSpecTranslation Enabling this bool uses the translation information from the board design data (not the calibration data)
     * @return baseline distance in centimeters
     */
    public native float getBaselineDistance(CameraBoardSocket cam1/*=dai::CameraBoardSocket::RIGHT*/,
                                  CameraBoardSocket cam2/*=dai::CameraBoardSocket::LEFT*/,
                                  @Cast("bool") boolean useSpecTranslation/*=true*/);
    public native float getBaselineDistance();
    public native float getBaselineDistance(@Cast("dai::CameraBoardSocket") int cam1/*=dai::CameraBoardSocket::RIGHT*/,
                                  @Cast("dai::CameraBoardSocket") int cam2/*=dai::CameraBoardSocket::LEFT*/,
                                  @Cast("bool") boolean useSpecTranslation/*=true*/);

    /**
     * Get the Camera To Imu Extrinsics object
     * From the data loaded if there is a linked connection between IMU and the given camera then there relative rotation and translation from the camera to IMU
     * is returned.
     *
     * @param cameraId Camera Id of the camera which will be considered as origin. from which Transformation matrix to the IMU will be found
     * @param useSpecTranslation Enabling this bool uses the translation information from the board design data
     * @return Returns a transformationMatrix which is 4x4 in homogeneous coordinate system
     *
     * Matrix representation of transformation matrix
     * <pre>{@code \[ \text{Transformation Matrix} = \left [ \begin{matrix}
     *                                             r_{00} & r_{01} & r_{02} & T_x \\
     *                                             r_{10} & r_{11} & r_{12} & T_y \\
     *                                             r_{20} & r_{21} & r_{22} & T_z \\
     *                                               0    &   0    &   0    & 1
     *                                            \end{matrix} \right ] \]}</pre>
     *
     */
    public native @ByVal FloatVectorVector getCameraToImuExtrinsics(CameraBoardSocket cameraId, @Cast("bool") boolean useSpecTranslation/*=false*/);
    public native @ByVal FloatVectorVector getCameraToImuExtrinsics(CameraBoardSocket cameraId);
    public native @ByVal FloatVectorVector getCameraToImuExtrinsics(@Cast("dai::CameraBoardSocket") int cameraId, @Cast("bool") boolean useSpecTranslation/*=false*/);
    public native @ByVal FloatVectorVector getCameraToImuExtrinsics(@Cast("dai::CameraBoardSocket") int cameraId);

    /**
     * Get the Imu To Camera Extrinsics object from the data loaded if there is a linked connection
     * between IMU and the given camera then there relative rotation and translation from the IMU to Camera
     * is returned.
     *
     * @param cameraId Camera Id of the camera which will be considered as destination. To which Transformation matrix from the IMU will be found.
     * @param useSpecTranslation Enabling this bool uses the translation information from the board design data
     * @return Returns a transformationMatrix which is 4x4 in homogeneous coordinate system
     *
     * Matrix representation of transformation matrix
     * <pre>{@code \[ \text{Transformation Matrix} = \left [ \begin{matrix}
     *                                             r_{00} & r_{01} & r_{02} & T_x \\
     *                                             r_{10} & r_{11} & r_{12} & T_y \\
     *                                             r_{20} & r_{21} & r_{22} & T_z \\
     *                                               0    &   0    &   0    & 1
     *                                            \end{matrix} \right ] \]}</pre>
     *
     */
    public native @ByVal FloatVectorVector getImuToCameraExtrinsics(CameraBoardSocket cameraId, @Cast("bool") boolean useSpecTranslation/*=false*/);
    public native @ByVal FloatVectorVector getImuToCameraExtrinsics(CameraBoardSocket cameraId);
    public native @ByVal FloatVectorVector getImuToCameraExtrinsics(@Cast("dai::CameraBoardSocket") int cameraId, @Cast("bool") boolean useSpecTranslation/*=false*/);
    public native @ByVal FloatVectorVector getImuToCameraExtrinsics(@Cast("dai::CameraBoardSocket") int cameraId);

    /**
     *
     * Get the Stereo Right Rectification Rotation object
     *
     * @return returns a 3x3 rectification rotation matrix
     */
    public native @ByVal FloatVectorVector getStereoRightRectificationRotation();

    /**
     * Get the Stereo Left Rectification Rotation object
     *
     * @return returns a 3x3 rectification rotation matrix
     */
    public native @ByVal FloatVectorVector getStereoLeftRectificationRotation();

    /**
     * Get the camera id of the camera which is used as left camera of the stereo setup
     *
     * @return cameraID of the camera used as left camera
     */
    public native CameraBoardSocket getStereoLeftCameraId();

    /**
     * Get the camera id of the camera which is used as right camera of the stereo setup
     *
     * @return cameraID of the camera used as right camera
     */
    public native CameraBoardSocket getStereoRightCameraId();

    /**
     * Write raw calibration/board data to json file.
     *
     * @param destPath  Full path to the json file in which raw calibration data will be stored
     * @return True on success, false otherwise
     */
    public native @Cast("bool") boolean eepromToJsonFile(@ByVal Path destPath);

    /**
     * Get JSON representation of calibration data
     *
     * @return JSON structure
     */
    public native @ByVal @Cast("nlohmann::json*") Pointer eepromToJson();

    /**
     * Set the Board Info object
     *
     * @param version Sets the version of the Calibration data(Current version is 6)
     * @param boardName Sets your board name.
     * @param boardRev set your board revision id.
     */
    public native void setBoardInfo(@StdString BytePointer boardName, @StdString BytePointer boardRev);
    public native void setBoardInfo(@StdString ByteBuffer boardName, @StdString ByteBuffer boardRev);
    public native void setBoardInfo(@StdString String boardName, @StdString String boardRev);

    /**
     * Set the Board Info object. Creates version 7 EEPROM data
     *
     * @param productName Sets product name (alias).
     * @param boardName Sets board name.
     * @param boardRev Sets board revision id.
     * @param boardConf Sets board configuration id.
     * @param hardwareConf Sets hardware configuration id.
     * @param batchName Sets batch name.
     * @param batchTime Sets batch time (unix timestamp).
     * @param boardCustom Sets a custom board (Default empty string).
     */
    public native void setBoardInfo(@StdString BytePointer productName,
                          @StdString BytePointer boardName,
                          @StdString BytePointer boardRev,
                          @StdString BytePointer boardConf,
                          @StdString BytePointer hardwareConf,
                          @StdString BytePointer batchName,
                          @Cast("uint64_t") long batchTime,
                          @Cast("uint32_t") int boardOptions,
                          @StdString BytePointer boardCustom/*=""*/);
    public native void setBoardInfo(@StdString BytePointer productName,
                          @StdString BytePointer boardName,
                          @StdString BytePointer boardRev,
                          @StdString BytePointer boardConf,
                          @StdString BytePointer hardwareConf,
                          @StdString BytePointer batchName,
                          @Cast("uint64_t") long batchTime,
                          @Cast("uint32_t") int boardOptions);
    public native void setBoardInfo(@StdString ByteBuffer productName,
                          @StdString ByteBuffer boardName,
                          @StdString ByteBuffer boardRev,
                          @StdString ByteBuffer boardConf,
                          @StdString ByteBuffer hardwareConf,
                          @StdString ByteBuffer batchName,
                          @Cast("uint64_t") long batchTime,
                          @Cast("uint32_t") int boardOptions,
                          @StdString ByteBuffer boardCustom/*=""*/);
    public native void setBoardInfo(@StdString ByteBuffer productName,
                          @StdString ByteBuffer boardName,
                          @StdString ByteBuffer boardRev,
                          @StdString ByteBuffer boardConf,
                          @StdString ByteBuffer hardwareConf,
                          @StdString ByteBuffer batchName,
                          @Cast("uint64_t") long batchTime,
                          @Cast("uint32_t") int boardOptions);
    public native void setBoardInfo(@StdString String productName,
                          @StdString String boardName,
                          @StdString String boardRev,
                          @StdString String boardConf,
                          @StdString String hardwareConf,
                          @StdString String batchName,
                          @Cast("uint64_t") long batchTime,
                          @Cast("uint32_t") int boardOptions,
                          @StdString String boardCustom/*=""*/);
    public native void setBoardInfo(@StdString String productName,
                          @StdString String boardName,
                          @StdString String boardRev,
                          @StdString String boardConf,
                          @StdString String hardwareConf,
                          @StdString String batchName,
                          @Cast("uint64_t") long batchTime,
                          @Cast("uint32_t") int boardOptions);

    /**
     * Set the productName which acts as alisas for users to identify the device
     *
     * @param productName Sets product name (alias).
     */

    public native void setProductName(@StdString BytePointer productName);
    public native void setProductName(@StdString ByteBuffer productName);
    public native void setProductName(@StdString String productName);

    /**
     * Set the Camera Intrinsics object
     *
     * @param cameraId CameraId of the camera for which Camera intrinsics are being loaded
     * @param intrinsics 3x3 intrinsics matrix
     * @param frameSize Represents the width and height of the image at which intrinsics are calculated.
     *
     * Matrix representation of intrinsic matrix
     * <pre>{@code \[ \text{Intrinsic Matrix} = \left [ \begin{matrix}
     *                                        f_x & 0 & c_x \\
     *                                        0 & f_y & c_y \\
     *                                        0 &  0  & 1
     *                                      \end{matrix} \right ] \]}</pre>
     *
     */
    public native void setCameraIntrinsics(CameraBoardSocket cameraId, @ByVal FloatVectorVector intrinsics, @ByVal Size2f frameSize);
    public native void setCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId, @ByVal FloatVectorVector intrinsics, @ByVal Size2f frameSize);

    /**
     * Set the Camera Intrinsics object
     *
     * @param cameraId CameraId of the camera for which Camera intrinsics are being loaded
     * @param intrinsics 3x3 intrinsics matrix
     * @param width Represents the width of the image at which intrinsics are calculated.
     * @param height Represents the height of the image at which intrinsics are calculated.
     *
     * Matrix representation of intrinsic matrix
     * <pre>{@code \[ \text{Intrinsic Matrix} = \left [ \begin{matrix}
     *                                        f_x & 0 & c_x \\
     *                                        0 & f_y & c_y \\
     *                                        0 &  0  & 1
     *                                      \end{matrix} \right ] \]}</pre>
     *
     */
    public native void setCameraIntrinsics(CameraBoardSocket cameraId, @ByVal FloatVectorVector intrinsics, int width, int height);
    public native void setCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId, @ByVal FloatVectorVector intrinsics, int width, int height);

    /**
     * Set the Camera Intrinsics object
     *
     * @param cameraId CameraId of the camera for which Camera intrinsics are being loaded
     * @param intrinsics 3x3 intrinsics matrix
     * @param frameSize Represents the width and height of the image at which intrinsics are calculated.
     *
     * Matrix representation of intrinsic matrix
     * <pre>{@code \[ \text{Intrinsic Matrix} = \left [ \begin{matrix}
     *                                        f_x & 0 & c_x \\
     *                                        0 & f_y & c_y \\
     *                                        0 &  0  & 1
     *                                      \end{matrix} \right ] \]}</pre>
     *
     */
    public native void setCameraIntrinsics(CameraBoardSocket cameraId, @ByVal FloatVectorVector intrinsics, @ByVal @Cast("std::tuple<int,int>*") Pointer frameSize);
    public native void setCameraIntrinsics(@Cast("dai::CameraBoardSocket") int cameraId, @ByVal FloatVectorVector intrinsics, @ByVal @Cast("std::tuple<int,int>*") Pointer frameSize);

    /**
     * Sets the distortion Coefficients obtained from camera calibration
     *
     * @param cameraId Camera Id of the camera for which distortion coefficients are computed
     * @param distortionCoefficients Distortion Coefficients of the respective Camera.
     */
    public native void setDistortionCoefficients(CameraBoardSocket cameraId, @StdVector FloatPointer distortionCoefficients);
    public native void setDistortionCoefficients(@Cast("dai::CameraBoardSocket") int cameraId, @StdVector FloatBuffer distortionCoefficients);
    public native void setDistortionCoefficients(CameraBoardSocket cameraId, @StdVector float[] distortionCoefficients);
    public native void setDistortionCoefficients(@Cast("dai::CameraBoardSocket") int cameraId, @StdVector FloatPointer distortionCoefficients);
    public native void setDistortionCoefficients(CameraBoardSocket cameraId, @StdVector FloatBuffer distortionCoefficients);
    public native void setDistortionCoefficients(@Cast("dai::CameraBoardSocket") int cameraId, @StdVector float[] distortionCoefficients);

    /**
     * Set the Fov of the Camera
     *
     * @param cameraId Camera Id of the camera
     * @param hfov Horizontal fov of the camera from Camera Datasheet
     */
    public native void setFov(CameraBoardSocket cameraId, float hfov);
    public native void setFov(@Cast("dai::CameraBoardSocket") int cameraId, float hfov);

    /**
     * Sets the distortion Coefficients obtained from camera calibration
     *
     * @param cameraId Camera Id of the camera
     * @param lensPosition lens posiotion value of the camera at the time of calibration
     */
    public native void setLensPosition(CameraBoardSocket cameraId, @Cast("uint8_t") byte lensPosition);
    public native void setLensPosition(@Cast("dai::CameraBoardSocket") int cameraId, @Cast("uint8_t") byte lensPosition);

    /**
     * Set the Camera Type object
     *
     * @param cameraId CameraId of the camera for which cameraModel Type is being updated.
     * @param cameraModel Type of the model the camera represents
     */
    public native void setCameraType(CameraBoardSocket cameraId, CameraModel cameraModel);
    public native void setCameraType(@Cast("dai::CameraBoardSocket") int cameraId, @Cast("dai::CameraModel") byte cameraModel);

    /**
     * Set the Camera Extrinsics object
     *
     * @param srcCameraId Camera Id of the camera which will be considered as relative origin.
     * @param destCameraId Camera Id of the camera which will be considered as destination from srcCameraId.
     * @param rotationMatrix Rotation between srcCameraId and destCameraId origins.
     * @param translation Translation between srcCameraId and destCameraId origins.
     * @param specTranslation Translation between srcCameraId and destCameraId origins from the design.
     */
    public native void setCameraExtrinsics(CameraBoardSocket srcCameraId,
                                 CameraBoardSocket destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector FloatPointer translation,
                                 @StdVector FloatPointer specTranslation/*={0, 0, 0}*/);
    public native void setCameraExtrinsics(CameraBoardSocket srcCameraId,
                                 CameraBoardSocket destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector FloatPointer translation);
    public native void setCameraExtrinsics(@Cast("dai::CameraBoardSocket") int srcCameraId,
                                 @Cast("dai::CameraBoardSocket") int destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector FloatBuffer translation,
                                 @StdVector FloatBuffer specTranslation/*={0, 0, 0}*/);
    public native void setCameraExtrinsics(@Cast("dai::CameraBoardSocket") int srcCameraId,
                                 @Cast("dai::CameraBoardSocket") int destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector FloatBuffer translation);
    public native void setCameraExtrinsics(CameraBoardSocket srcCameraId,
                                 CameraBoardSocket destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector float[] translation,
                                 @StdVector float[] specTranslation/*={0, 0, 0}*/);
    public native void setCameraExtrinsics(CameraBoardSocket srcCameraId,
                                 CameraBoardSocket destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector float[] translation);
    public native void setCameraExtrinsics(@Cast("dai::CameraBoardSocket") int srcCameraId,
                                 @Cast("dai::CameraBoardSocket") int destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector FloatPointer translation,
                                 @StdVector FloatPointer specTranslation/*={0, 0, 0}*/);
    public native void setCameraExtrinsics(@Cast("dai::CameraBoardSocket") int srcCameraId,
                                 @Cast("dai::CameraBoardSocket") int destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector FloatPointer translation);
    public native void setCameraExtrinsics(CameraBoardSocket srcCameraId,
                                 CameraBoardSocket destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector FloatBuffer translation,
                                 @StdVector FloatBuffer specTranslation/*={0, 0, 0}*/);
    public native void setCameraExtrinsics(CameraBoardSocket srcCameraId,
                                 CameraBoardSocket destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector FloatBuffer translation);
    public native void setCameraExtrinsics(@Cast("dai::CameraBoardSocket") int srcCameraId,
                                 @Cast("dai::CameraBoardSocket") int destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector float[] translation,
                                 @StdVector float[] specTranslation/*={0, 0, 0}*/);
    public native void setCameraExtrinsics(@Cast("dai::CameraBoardSocket") int srcCameraId,
                                 @Cast("dai::CameraBoardSocket") int destCameraId,
                                 @ByVal FloatVectorVector rotationMatrix,
                                 @StdVector float[] translation);

    /**
     * Set the Imu to Camera Extrinsics object
     *
     * @param destCameraId Camera Id of the camera which will be considered as destination from IMU.
     * @param rotationMatrix Rotation between srcCameraId and destCameraId origins.
     * @param translation Translation between IMU and destCameraId origins.
     * @param specTranslation Translation between IMU and destCameraId origins from the design.
     */
    public native void setImuExtrinsics(CameraBoardSocket destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector FloatPointer translation,
                              @StdVector FloatPointer specTranslation/*={0, 0, 0}*/);
    public native void setImuExtrinsics(CameraBoardSocket destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector FloatPointer translation);
    public native void setImuExtrinsics(@Cast("dai::CameraBoardSocket") int destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector FloatBuffer translation,
                              @StdVector FloatBuffer specTranslation/*={0, 0, 0}*/);
    public native void setImuExtrinsics(@Cast("dai::CameraBoardSocket") int destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector FloatBuffer translation);
    public native void setImuExtrinsics(CameraBoardSocket destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector float[] translation,
                              @StdVector float[] specTranslation/*={0, 0, 0}*/);
    public native void setImuExtrinsics(CameraBoardSocket destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector float[] translation);
    public native void setImuExtrinsics(@Cast("dai::CameraBoardSocket") int destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector FloatPointer translation,
                              @StdVector FloatPointer specTranslation/*={0, 0, 0}*/);
    public native void setImuExtrinsics(@Cast("dai::CameraBoardSocket") int destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector FloatPointer translation);
    public native void setImuExtrinsics(CameraBoardSocket destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector FloatBuffer translation,
                              @StdVector FloatBuffer specTranslation/*={0, 0, 0}*/);
    public native void setImuExtrinsics(CameraBoardSocket destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector FloatBuffer translation);
    public native void setImuExtrinsics(@Cast("dai::CameraBoardSocket") int destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector float[] translation,
                              @StdVector float[] specTranslation/*={0, 0, 0}*/);
    public native void setImuExtrinsics(@Cast("dai::CameraBoardSocket") int destCameraId,
                              @ByVal FloatVectorVector rotationMatrix,
                              @StdVector float[] translation);

    /**
     * Set the Stereo Left Rectification object
     *
     * @param cameraId CameraId of the camera which will be used as left Camera of stereo Setup
     * @param rectifiedRotation Rectification rotation of the left camera required for feature matching
     *
     * Homography of the Left Rectification = Intrinsics_right * rectifiedRotation * inv(Intrinsics_left)
     */
    public native void setStereoLeft(CameraBoardSocket cameraId, @ByVal FloatVectorVector rectifiedRotation);
    public native void setStereoLeft(@Cast("dai::CameraBoardSocket") int cameraId, @ByVal FloatVectorVector rectifiedRotation);

    /**
     * Set the Stereo Right Rectification object
     *
     * @param cameraId CameraId of the camera which will be used as left Camera of stereo Setup
     * @param rectifiedRotation Rectification rotation of the left camera required for feature matching
     *
     * Homography of the Right Rectification = Intrinsics_right * rectifiedRotation * inv(Intrinsics_right)
     */
    public native void setStereoRight(CameraBoardSocket cameraId, @ByVal FloatVectorVector rectifiedRotation);
    public native void setStereoRight(@Cast("dai::CameraBoardSocket") int cameraId, @ByVal FloatVectorVector rectifiedRotation);

    /**
     * Using left camera as the head it iterates over the camera extrinsics connection
     * to check if all the camera extrinsics are connected and no loop exists.
     *
     * @return true on proper connection with no loops.
     */
    public native @Cast("bool") boolean validateCameraArray();
}
