// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/**
 * CameraFeatures structure
 *
 * Characterizes detected cameras on board
 */
@Namespace("dai") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class CameraFeatures extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CameraFeatures() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CameraFeatures(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CameraFeatures(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CameraFeatures position(long position) {
        return (CameraFeatures)super.position(position);
    }
    @Override public CameraFeatures getPointer(long i) {
        return new CameraFeatures((Pointer)this).offsetAddress(i);
    }

    /**
     * Board socket where the camera was detected
     */
    public native CameraBoardSocket socket(); public native CameraFeatures socket(CameraBoardSocket setter);
    /**
     * Camera sensor name, e.g: "IMX378", "OV9282"
     */
    public native @StdString BytePointer sensorName(); public native CameraFeatures sensorName(BytePointer setter);
    /**
     * Maximum sensor resolution
     */
    public native @Cast("std::int32_t") int width(); public native CameraFeatures width(int setter);
    public native @Cast("std::int32_t") int height(); public native CameraFeatures height(int setter);
    /**
     * Default camera orientation, board dependent
     */
    public native CameraImageOrientation orientation(); public native CameraFeatures orientation(CameraImageOrientation setter);
    /**
     * List of supported types of processing for the given camera.
     *
     * For some sensors it's not possible to determine if they are color or mono
     * (e.g. OV9782 and OV9282), so this could return more than one entry
     */
    public native @StdVector @Cast("dai::CameraSensorType*") IntPointer supportedTypes(); public native CameraFeatures supportedTypes(IntPointer setter);
    /**
     *  Whether an autofocus VCM IC was detected
     */
    public native @Cast("bool") boolean hasAutofocus(); public native CameraFeatures hasAutofocus(boolean setter);
    /**
     * Camera name or alias
     */
    public native @StdString BytePointer name(); public native CameraFeatures name(BytePointer setter);
    /**
     * Available sensor configs
     */
    public native @StdVector CameraSensorConfig configs(); public native CameraFeatures configs(CameraSensorConfig setter);
}
