// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/**
 * \brief DetectionParser node. Parses detection results from different neural networks and is being used internally by MobileNetDetectionNetwork and
 * YoloDetectionNetwork.
 */
@Namespace("dai::node") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class DetectionParser extends DetectionParserPropertiesNode {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DetectionParser(Pointer p) { super(p); }

    @MemberGetter public static native @Cast("const char*") BytePointer NAME();
    public DetectionParser(@SharedPtr PipelineImpl par, @Cast("int64_t") long nodeId) { super((Pointer)null); allocate(par, nodeId); }
    private native void allocate(@SharedPtr PipelineImpl par, @Cast("int64_t") long nodeId);
    public DetectionParser(@SharedPtr PipelineImpl par, @Cast("int64_t") long nodeId, @UniquePtr DetectionParserProperties props) { super((Pointer)null); allocate(par, nodeId, props); }
    private native void allocate(@SharedPtr PipelineImpl par, @Cast("int64_t") long nodeId, @UniquePtr DetectionParserProperties props);

    /**
     * Input NN results with detection data to parse
     * Default queue is blocking with size 5
     */
    @MemberGetter public native @ByRef Input input();

    /**
     * Outputs image frame with detected edges
     */
    @MemberGetter public native @ByRef Output out();

    /**
     * Specify number of frames in pool.
     * @param numFramesPool How many frames should the pool have
     */
    public native void setNumFramesPool(int numFramesPool);

    /**
     * Returns number of frames in pool
     *
     */
    public native int getNumFramesPool();

    /**
     * Retrieves some input tensor information from the blob
     *
     * @param blob OpenVINO blob to retrieve the information from
     */
    public native void setBlob(@Const @ByRef OpenVINO.Blob blob);

    /**
     * Sets NN Family to parse
     */
    public native void setNNFamily(DetectionNetworkType type);
    public native void setNNFamily(@Cast("DetectionNetworkType") int type);

    /**
     * Gets NN Family to parse
     */
    public native DetectionNetworkType getNNFamily();

    /**
     * Specifies confidence threshold at which to filter the rest of the detections.
     * @param thresh Detection confidence must be greater than specified threshold to be added to the list
     */
    public native void setConfidenceThreshold(float thresh);

    /**
     * Retrieves threshold at which to filter the rest of the detections.
     * @return Detection confidence
     */
    public native float getConfidenceThreshold();

    /** Set num classes */
    public native void setNumClasses(int numClasses);
    /** Set coordianate size */
    public native void setCoordinateSize(int coordinates);
    /** Set anchors */
    public native void setAnchors(@StdVector FloatPointer anchors);
    public native void setAnchors(@StdVector FloatBuffer anchors);
    public native void setAnchors(@StdVector float[] anchors);
    /** Set anchor masks */
    public native void setAnchorMasks(@ByVal StringIntVectorMap anchorMasks);
    /** Set Iou threshold */
    public native void setIouThreshold(float thresh);

    /** Get num classes */
    public native int getNumClasses();
    /** Get coordianate size */
    public native int getCoordinateSize();
    /** Get anchors */
    public native @StdVector FloatPointer getAnchors();
    /** Get anchor masks */
    public native @ByVal StringIntVectorMap getAnchorMasks();
    /** Get Iou threshold */
    public native float getIouThreshold();
}
