// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


// DeviceBootloader (RAII), connects to device and maintains watchdog ...

/**
 * Represents the DepthAI bootloader with the methods to interact with it.
 */
@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class DeviceBootloader extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DeviceBootloader(Pointer p) { super(p); }

    // Alias

    // Derive and extend bootloader::Config for easier usage
    @NoOffset public static class Config extends BootloaderConfig {
        static { Loader.load(); }
        /** Default native constructor. */
        public Config() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Config(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Config(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public Config position(long position) {
            return (Config)super.position(position);
        }
        @Override public Config getPointer(long i) {
            return new Config((Pointer)this).offsetAddress(i);
        }
    
        /** Setting a static IPv4 won't start DHCP client */
        public native void setStaticIPv4(@StdString BytePointer ip, @StdString BytePointer mask, @StdString BytePointer gateway);
        public native void setStaticIPv4(@StdString ByteBuffer ip, @StdString ByteBuffer mask, @StdString ByteBuffer gateway);
        public native void setStaticIPv4(@StdString String ip, @StdString String mask, @StdString String gateway);
        /** Setting a dynamic IPv4 will set that IP as well as start DHCP client */
        public native void setDynamicIPv4(@StdString BytePointer ip, @StdString BytePointer mask, @StdString BytePointer gateway);
        public native void setDynamicIPv4(@StdString ByteBuffer ip, @StdString ByteBuffer mask, @StdString ByteBuffer gateway);
        public native void setDynamicIPv4(@StdString String ip, @StdString String mask, @StdString String gateway);
        /** Get if static IPv4 configuration is set */
        public native @Cast("bool") boolean isStaticIPV4();
        /** Get IPv4 */
        public native @StdString BytePointer getIPv4();
        /** Get IPv4 mask */
        public native @StdString BytePointer getIPv4Mask();
        /** Get IPv4 gateway */
        public native @StdString BytePointer getIPv4Gateway();
        /** Set IPv4 DNS options */
        public native void setDnsIPv4(@StdString BytePointer dns, @StdString BytePointer dnsAlt/*=""*/);
        public native void setDnsIPv4(@StdString BytePointer dns);
        public native void setDnsIPv4(@StdString ByteBuffer dns, @StdString ByteBuffer dnsAlt/*=""*/);
        public native void setDnsIPv4(@StdString ByteBuffer dns);
        public native void setDnsIPv4(@StdString String dns, @StdString String dnsAlt/*=""*/);
        public native void setDnsIPv4(@StdString String dns);
        /** Get primary IPv4 DNS server */
        public native @StdString BytePointer getDnsIPv4();
        /** Get alternate IPv4 DNS server */
        public native @StdString BytePointer getDnsAltIPv4();

        /** Set USB timeout */
        public native void setUsbTimeout(@ByVal @Cast("std::chrono::milliseconds*") Pointer ms);
        /** Get USB timeout */
        public native @ByVal @Cast("std::chrono::milliseconds*") Pointer getUsbTimeout();

        /** Set NETWOR timeout */
        public native void setNetworkTimeout(@ByVal @Cast("std::chrono::milliseconds*") Pointer ms);
        /** Get NETWORK timeout */
        public native @ByVal @Cast("std::chrono::milliseconds*") Pointer getNetworkTimeout();

        /** Set MAC address if not flashed on controller */
        public native void setMacAddress(@StdString BytePointer mac);
        public native void setMacAddress(@StdString ByteBuffer mac);
        public native void setMacAddress(@StdString String mac);
        /** Get MAC address if not flashed on controller */
        public native @StdString BytePointer getMacAddress();

        /** Set maxUsbSpeed */
        public native void setUsbMaxSpeed(UsbSpeed speed);
        public native void setUsbMaxSpeed(@Cast("dai::UsbSpeed") int speed);
        /** Get maxUsbSpeed */
        public native UsbSpeed getUsbMaxSpeed();

        /** To JSON */
        public native @ByVal @Cast("nlohmann::json*") Pointer toJson();

        /** from JSON */
        public static native @ByVal Config fromJson(@ByVal @Cast("nlohmann::json*") Pointer arg0);
    }

    // Add an alias to Version

    public static class ApplicationInfo extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public ApplicationInfo() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ApplicationInfo(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ApplicationInfo(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public ApplicationInfo position(long position) {
            return (ApplicationInfo)super.position(position);
        }
        @Override public ApplicationInfo getPointer(long i) {
            return new ApplicationInfo((Pointer)this).offsetAddress(i);
        }
    
        public native Memory memory(); public native ApplicationInfo memory(Memory setter);
        public native @Cast("bool") boolean hasApplication(); public native ApplicationInfo hasApplication(boolean setter);
        public native @StdString BytePointer firmwareVersion(); public native ApplicationInfo firmwareVersion(BytePointer setter);
        public native @StdString BytePointer applicationName(); public native ApplicationInfo applicationName(BytePointer setter);
    }

    public static class MemoryInfo extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public MemoryInfo() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public MemoryInfo(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public MemoryInfo(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public MemoryInfo position(long position) {
            return (MemoryInfo)super.position(position);
        }
        @Override public MemoryInfo getPointer(long i) {
            return new MemoryInfo((Pointer)this).offsetAddress(i);
        }
    
        public native @Cast("bool") boolean available(); public native MemoryInfo available(boolean setter);
        public native @Cast("std::int64_t") long size(); public native MemoryInfo size(long setter);
        public native @StdString BytePointer info(); public native MemoryInfo info(BytePointer setter);
    }

    // constants

    /** Default Bootloader type */
    @MemberGetter public static native Type DEFAULT_TYPE();

    // Static API
    /**
     * Searches for connected devices in either UNBOOTED or BOOTLOADER states and returns first available.
     * @return Tuple of boolean and DeviceInfo. If found boolean is true and DeviceInfo describes the device. Otherwise false
     */
    public static native @ByVal @Cast("std::tuple<bool,dai::DeviceInfo>*") Pointer getFirstAvailableDevice();

    /**
     * Searches for connected devices in either UNBOOTED or BOOTLOADER states.
     * @return Vector of all found devices
     */
    public static native @StdVector DeviceInfo getAllAvailableDevices();

    /**
     * Creates application package which can be flashed to depthai device.
     * @param pipeline Pipeline from which to create the application package
     * @param pathToCmd Optional path to custom device firmware
     * @param compress Optional boolean which specifies if contents should be compressed
     * @param applicationName Optional name the application that is flashed
     * @return Depthai application package
     */
    public static native @ByVal ByteVector createDepthaiApplicationPackage(
            @Const @ByRef Pipeline pipeline, @Const @ByRef(nullValue = "dai::Path{}") Path pathToCmd, @Cast("bool") boolean compress/*=false*/, @StdString BytePointer applicationName/*=""*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public static native @ByVal ByteVector createDepthaiApplicationPackage(
            @Const @ByRef Pipeline pipeline);
    public static native @ByVal ByteVector createDepthaiApplicationPackage(
            @Const @ByRef Pipeline pipeline, @Const @ByRef(nullValue = "dai::Path{}") Path pathToCmd, @Cast("bool") boolean compress/*=false*/, @StdString ByteBuffer applicationName/*=""*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public static native @ByVal ByteVector createDepthaiApplicationPackage(
            @Const @ByRef Pipeline pipeline, @Const @ByRef(nullValue = "dai::Path{}") Path pathToCmd, @Cast("bool") boolean compress/*=false*/, @StdString String applicationName/*=""*/, @Cast("bool") boolean checkChecksum/*=false*/);

    /**
     * Creates application package which can be flashed to depthai device.
     * @param pipeline Pipeline from which to create the application package
     * @param compress Specifies if contents should be compressed
     * @param applicationName Name the application that is flashed
     * @return Depthai application package
     */
    public static native @ByVal ByteVector createDepthaiApplicationPackage(@Const @ByRef Pipeline pipeline,
                                                                    @Cast("bool") boolean compress,
                                                                    @StdString BytePointer applicationName/*=""*/,
                                                                    @Cast("bool") boolean checkChecksum/*=false*/);
    public static native @ByVal ByteVector createDepthaiApplicationPackage(@Const @ByRef Pipeline pipeline,
                                                                    @Cast("bool") boolean compress);
    public static native @ByVal ByteVector createDepthaiApplicationPackage(@Const @ByRef Pipeline pipeline,
                                                                    @Cast("bool") boolean compress,
                                                                    @StdString ByteBuffer applicationName/*=""*/,
                                                                    @Cast("bool") boolean checkChecksum/*=false*/);
    public static native @ByVal ByteVector createDepthaiApplicationPackage(@Const @ByRef Pipeline pipeline,
                                                                    @Cast("bool") boolean compress,
                                                                    @StdString String applicationName/*=""*/,
                                                                    @Cast("bool") boolean checkChecksum/*=false*/);

    /**
     * Saves application package to a file which can be flashed to depthai device.
     * @param path Path where to save the application package
     * @param pipeline Pipeline from which to create the application package
     * @param pathToCmd Optional path to custom device firmware
     * @param compress Optional boolean which specifies if contents should be compressed
     * @param applicationName Optional name the application that is flashed
     */
    public static native void saveDepthaiApplicationPackage(@Const @ByRef Path path,
                                                  @Const @ByRef Pipeline pipeline,
                                                  @Const @ByRef(nullValue = "dai::Path{}") Path pathToCmd,
                                                  @Cast("bool") boolean compress/*=false*/,
                                                  @StdString BytePointer applicationName/*=""*/,
                                                  @Cast("bool") boolean checkChecksum/*=false*/);
    public static native void saveDepthaiApplicationPackage(@Const @ByRef Path path,
                                                  @Const @ByRef Pipeline pipeline);
    public static native void saveDepthaiApplicationPackage(@Const @ByRef Path path,
                                                  @Const @ByRef Pipeline pipeline,
                                                  @Const @ByRef(nullValue = "dai::Path{}") Path pathToCmd,
                                                  @Cast("bool") boolean compress/*=false*/,
                                                  @StdString ByteBuffer applicationName/*=""*/,
                                                  @Cast("bool") boolean checkChecksum/*=false*/);
    public static native void saveDepthaiApplicationPackage(@Const @ByRef Path path,
                                                  @Const @ByRef Pipeline pipeline,
                                                  @Const @ByRef(nullValue = "dai::Path{}") Path pathToCmd,
                                                  @Cast("bool") boolean compress/*=false*/,
                                                  @StdString String applicationName/*=""*/,
                                                  @Cast("bool") boolean checkChecksum/*=false*/);

    /**
     * Saves application package to a file which can be flashed to depthai device.
     * @param path Path where to save the application package
     * @param pipeline Pipeline from which to create the application package
     * @param compress Specifies if contents should be compressed
     * @param applicationName Optional name the application that is flashed
     */
    public static native void saveDepthaiApplicationPackage(
            @Const @ByRef Path path, @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress, @StdString BytePointer applicationName/*=""*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public static native void saveDepthaiApplicationPackage(
            @Const @ByRef Path path, @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress);
    public static native void saveDepthaiApplicationPackage(
            @Const @ByRef Path path, @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress, @StdString ByteBuffer applicationName/*=""*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public static native void saveDepthaiApplicationPackage(
            @Const @ByRef Path path, @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress, @StdString String applicationName/*=""*/, @Cast("bool") boolean checkChecksum/*=false*/);

    /**
     * @return Embedded bootloader version
     */
    public static native @ByVal Version getEmbeddedBootloaderVersion();

    /**
     * @return Embedded bootloader binary
     */
    public static native @Cast("std::uint8_t*") @StdVector BytePointer getEmbeddedBootloaderBinary(Type type/*=dai::DeviceBootloader::DEFAULT_TYPE*/);
    public static native @Cast("std::uint8_t*") @StdVector BytePointer getEmbeddedBootloaderBinary();
    public static native @Cast("std::uint8_t*") @StdVector ByteBuffer getEmbeddedBootloaderBinary(@Cast("dai::bootloader::Type") int type/*=dai::DeviceBootloader::DEFAULT_TYPE*/);

    

    /**
     * Connects to or boots device in bootloader mode depending on devInfo state; flashing not allowed
     * @param devInfo DeviceInfo of which to boot or connect to
     */
    public DeviceBootloader(@Const @ByRef DeviceInfo devInfo) { super((Pointer)null); allocate(devInfo); }
    private native void allocate(@Const @ByRef DeviceInfo devInfo);

    /**
     * Connects to or boots device in bootloader mode depending on devInfo state.
     * @param devInfo DeviceInfo of which to boot or connect to
     * @param allowFlashingBootloader (bool) Set to true to allow flashing the devices bootloader
     */

    /**
     * Connects to device in bootloader of specified type. Throws if it wasn't possible.
     * This constructor will automatically boot into specified bootloader type if not already running
     * @param devInfo DeviceInfo of which to boot or connect to
     * @param type Type of bootloader to boot/connect to.
     * @param allowFlashingBootloader Set to true to allow flashing the devices bootloader. Defaults to false
     */
    public DeviceBootloader(@Const @ByRef DeviceInfo devInfo, Type type, @Cast("bool") boolean allowFlashingBootloader/*=false*/) { super((Pointer)null); allocate(devInfo, type, allowFlashingBootloader); }
    private native void allocate(@Const @ByRef DeviceInfo devInfo, Type type, @Cast("bool") boolean allowFlashingBootloader/*=false*/);
    public DeviceBootloader(@Const @ByRef DeviceInfo devInfo, Type type) { super((Pointer)null); allocate(devInfo, type); }
    private native void allocate(@Const @ByRef DeviceInfo devInfo, Type type);
    public DeviceBootloader(@Const @ByRef DeviceInfo devInfo, @Cast("dai::bootloader::Type") int type, @Cast("bool") boolean allowFlashingBootloader/*=false*/) { super((Pointer)null); allocate(devInfo, type, allowFlashingBootloader); }
    private native void allocate(@Const @ByRef DeviceInfo devInfo, @Cast("dai::bootloader::Type") int type, @Cast("bool") boolean allowFlashingBootloader/*=false*/);
    public DeviceBootloader(@Const @ByRef DeviceInfo devInfo, @Cast("dai::bootloader::Type") int type) { super((Pointer)null); allocate(devInfo, type); }
    private native void allocate(@Const @ByRef DeviceInfo devInfo, @Cast("dai::bootloader::Type") int type);

    /**
     * Connects to or boots device in bootloader mode depending on devInfo state with a custom bootloader firmware.
     * @param devInfo DeviceInfo of which to boot or connect to
     * @param pathToBootloader Custom bootloader firmware to boot
     * @param allowFlashingBootloader Set to true to allow flashing the devices bootloader. Defaults to false
     */
    public DeviceBootloader(@Const @ByRef DeviceInfo devInfo, @Const @ByRef Path pathToBootloader, @Cast("bool") boolean allowFlashingBootloader/*=false*/) { super((Pointer)null); allocate(devInfo, pathToBootloader, allowFlashingBootloader); }
    private native void allocate(@Const @ByRef DeviceInfo devInfo, @Const @ByRef Path pathToBootloader, @Cast("bool") boolean allowFlashingBootloader/*=false*/);
    public DeviceBootloader(@Const @ByRef DeviceInfo devInfo, @Const @ByRef Path pathToBootloader) { super((Pointer)null); allocate(devInfo, pathToBootloader); }
    private native void allocate(@Const @ByRef DeviceInfo devInfo, @Const @ByRef Path pathToBootloader);

    /**
     * Connects to device with specified name/device id
     *
     * @param nameOrDeviceId Creates DeviceInfo with nameOrDeviceId to connect to
     * @param allowFlashingBootloader Set to true to allow flashing the devices bootloader. Defaults to false
     */
    public DeviceBootloader(@StdString BytePointer nameOrDeviceId, @Cast("bool") boolean allowFlashingBootloader/*=false*/) { super((Pointer)null); allocate(nameOrDeviceId, allowFlashingBootloader); }
    private native void allocate(@StdString BytePointer nameOrDeviceId, @Cast("bool") boolean allowFlashingBootloader/*=false*/);
    public DeviceBootloader(@StdString BytePointer nameOrDeviceId) { super((Pointer)null); allocate(nameOrDeviceId); }
    private native void allocate(@StdString BytePointer nameOrDeviceId);
    public DeviceBootloader(@StdString ByteBuffer nameOrDeviceId, @Cast("bool") boolean allowFlashingBootloader/*=false*/) { super((Pointer)null); allocate(nameOrDeviceId, allowFlashingBootloader); }
    private native void allocate(@StdString ByteBuffer nameOrDeviceId, @Cast("bool") boolean allowFlashingBootloader/*=false*/);
    public DeviceBootloader(@StdString ByteBuffer nameOrDeviceId) { super((Pointer)null); allocate(nameOrDeviceId); }
    private native void allocate(@StdString ByteBuffer nameOrDeviceId);
    public DeviceBootloader(@StdString String nameOrDeviceId, @Cast("bool") boolean allowFlashingBootloader/*=false*/) { super((Pointer)null); allocate(nameOrDeviceId, allowFlashingBootloader); }
    private native void allocate(@StdString String nameOrDeviceId, @Cast("bool") boolean allowFlashingBootloader/*=false*/);
    public DeviceBootloader(@StdString String nameOrDeviceId) { super((Pointer)null); allocate(nameOrDeviceId); }
    private native void allocate(@StdString String nameOrDeviceId);

    /**
     * \brief Destroy the Device Bootloader object
     *
     */

    /**
     * Flashes a given pipeline to the device.
     * @param progressCallback Callback that sends back a value between 0..1 which signifies current flashing progress
     * @param pipeline Pipeline to flash to the board
     * @param compress Compresses application to reduce needed memory size
     * @param applicationName Name the application that is flashed
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(ProgressCallback progressCallback,
                                            @Const @ByRef Pipeline pipeline,
                                            @Cast("bool") boolean compress/*=false*/,
                                            @StdString BytePointer applicationName/*=""*/,
                                            Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/,
                                            @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(ProgressCallback progressCallback,
                                            @Const @ByRef Pipeline pipeline);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(ProgressCallback progressCallback,
                                            @Const @ByRef Pipeline pipeline,
                                            @Cast("bool") boolean compress/*=false*/,
                                            @StdString ByteBuffer applicationName/*=""*/,
                                            @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/,
                                            @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(ProgressCallback progressCallback,
                                            @Const @ByRef Pipeline pipeline,
                                            @Cast("bool") boolean compress/*=false*/,
                                            @StdString String applicationName/*=""*/,
                                            Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/,
                                            @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(ProgressCallback progressCallback,
                                            @Const @ByRef Pipeline pipeline,
                                            @Cast("bool") boolean compress/*=false*/,
                                            @StdString BytePointer applicationName/*=""*/,
                                            @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/,
                                            @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(ProgressCallback progressCallback,
                                            @Const @ByRef Pipeline pipeline,
                                            @Cast("bool") boolean compress/*=false*/,
                                            @StdString ByteBuffer applicationName/*=""*/,
                                            Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/,
                                            @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(ProgressCallback progressCallback,
                                            @Const @ByRef Pipeline pipeline,
                                            @Cast("bool") boolean compress/*=false*/,
                                            @StdString String applicationName/*=""*/,
                                            @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/,
                                            @Cast("bool") boolean checkChecksum/*=false*/);

    /**
     * Flashes a given pipeline to the device.
     * @param pipeline Pipeline to flash to the board
     * @param compress Compresses application to reduce needed memory size
     * @param applicationName Optional name the application that is flashed
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(
            @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress/*=false*/, @StdString BytePointer applicationName/*=""*/, Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(
            @Const @ByRef Pipeline pipeline);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(
            @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress/*=false*/, @StdString ByteBuffer applicationName/*=""*/, @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(
            @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress/*=false*/, @StdString String applicationName/*=""*/, Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(
            @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress/*=false*/, @StdString BytePointer applicationName/*=""*/, @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(
            @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress/*=false*/, @StdString ByteBuffer applicationName/*=""*/, Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("bool") boolean checkChecksum/*=false*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flash(
            @Const @ByRef Pipeline pipeline, @Cast("bool") boolean compress/*=false*/, @StdString String applicationName/*=""*/, @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("bool") boolean checkChecksum/*=false*/);

    /**
     * Reads information about flashed application in specified memory from device
     * @param memory Specifies which memory to query
     */
    public native @ByVal ApplicationInfo readApplicationInfo(Memory memory);
    public native @ByVal ApplicationInfo readApplicationInfo(@Cast("dai::bootloader::Memory") int memory);

    /**
     * Flashes a specific depthai application package that was generated using createDepthaiApplicationPackage or saveDepthaiApplicationPackage
     * @param progressCallback Callback that sends back a value between 0..1 which signifies current flashing progress
     * @param package Depthai application package to flash to the board
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashDepthaiApplicationPackage(ProgressCallback progressCallback,
                                                                     @ByVal ByteVector _package,
                                                                     Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashDepthaiApplicationPackage(ProgressCallback progressCallback,
                                                                     @ByVal ByteVector _package);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashDepthaiApplicationPackage(ProgressCallback progressCallback,
                                                                     @ByVal ByteVector _package,
                                                                     @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/);

    /**
     * Flashes a specific depthai application package that was generated using createDepthaiApplicationPackage or saveDepthaiApplicationPackage
     * @param package Depthai application package to flash to the board
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashDepthaiApplicationPackage(@ByVal ByteVector _package, Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashDepthaiApplicationPackage(@ByVal ByteVector _package);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashDepthaiApplicationPackage(@ByVal ByteVector _package, @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/);

    /**
     * Clears flashed application on the device, by removing SBR boot structure
     * Doesn't remove fast boot header capability to still boot the application
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashClear(Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashClear();
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashClear(@Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/);

    /**
     * Flashes bootloader to the current board
     * @param progressCallback Callback that sends back a value between 0..1 which signifies current flashing progress
     * @param path Optional parameter to custom bootloader to flash
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootloader(ProgressCallback progressCallback, @Const @ByRef(nullValue = "dai::Path{}") Path path);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootloader(ProgressCallback progressCallback);

    /**
     * Flash selected bootloader to the current board
     * @param memory Memory to flash
     * @param type Bootloader type to flash
     * @param progressCallback Callback that sends back a value between 0..1 which signifies current flashing progress
     * @param path Optional parameter to custom bootloader to flash
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootloader(Memory memory, Type type, ProgressCallback progressCallback, @Const @ByRef(nullValue = "dai::Path{}") Path path);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootloader(Memory memory, Type type, ProgressCallback progressCallback);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootloader(@Cast("dai::bootloader::Memory") int memory, @Cast("dai::bootloader::Type") int type, ProgressCallback progressCallback, @Const @ByRef(nullValue = "dai::Path{}") Path path);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootloader(@Cast("dai::bootloader::Memory") int memory, @Cast("dai::bootloader::Type") int type, ProgressCallback progressCallback);

    /**
     * Flashes user bootloader to the current board. Available for NETWORK bootloader type
     * @param progressCallback Callback that sends back a value between 0..1 which signifies current flashing progress
     * @param path Optional parameter to custom bootloader to flash
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashUserBootloader(ProgressCallback progressCallback, @Const @ByRef(nullValue = "dai::Path{}") Path path);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashUserBootloader(ProgressCallback progressCallback);

    /**
     * Flash boot header which boots same as equivalent GPIO mode would
     * @param gpioMode GPIO mode equivalent
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashGpioModeBootHeader(Memory memory, int gpioMode);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashGpioModeBootHeader(@Cast("dai::bootloader::Memory") int memory, int gpioMode);

    /**
     * Flash USB recovery boot header. Switches to USB ROM Bootloader
     * @param memory Which memory to flash the header to
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashUsbRecoveryBootHeader(Memory memory);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashUsbRecoveryBootHeader(@Cast("dai::bootloader::Memory") int memory);

    /**
     * Flash optimized boot header
     * @param memory Which memory to flasht the header to
     * @param frequency SPI specific parameter, frequency in MHz
     * @param location Target location the header should boot to. Default to location of bootloader
     * @param dummyCycles SPI specific parameter
     * @param offset Offset in memory to flash the header to. Defaults to offset of boot header
     * @return status as std::tuple<bool, std::string>
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootHeader(Memory memory, int frequency/*=-1*/, @Cast("int64_t") long location/*=-1*/, int dummyCycles/*=-1*/, @Cast("int64_t") long offset/*=-1*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootHeader(Memory memory);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootHeader(@Cast("dai::bootloader::Memory") int memory, int frequency/*=-1*/, @Cast("int64_t") long location/*=-1*/, int dummyCycles/*=-1*/, @Cast("int64_t") long offset/*=-1*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashBootHeader(@Cast("dai::bootloader::Memory") int memory);

    /**
     * Flash fast boot header. Application must already be present in flash, or location must be specified manually.
     * Note - Can soft brick your device if firmware location changes.
     * @param memory Which memory to flash the header to
     * @param frequency SPI specific parameter, frequency in MHz
     * @param location Target location the header should boot to. Default to location of bootloader
     * @param dummyCycles SPI specific parameter
     * @param offset Offset in memory to flash the header to. Defaults to offset of boot header
     * @return status as std::tuple<bool, std::string>
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashFastBootHeader(
            Memory memory, int frequency/*=-1*/, @Cast("int64_t") long location/*=-1*/, int dummyCycles/*=-1*/, @Cast("int64_t") long offset/*=-1*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashFastBootHeader(
            Memory memory);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashFastBootHeader(
            @Cast("dai::bootloader::Memory") int memory, int frequency/*=-1*/, @Cast("int64_t") long location/*=-1*/, int dummyCycles/*=-1*/, @Cast("int64_t") long offset/*=-1*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashFastBootHeader(
            @Cast("dai::bootloader::Memory") int memory);

    /**
     * Flash arbitrary data at custom offset in specified memory
     * @param memory Memory to flash
     * @param offset Offset at which to flash the given data in bytes
     * @param progressCallback Callback that sends back a value between 0..1 which signifies current flashing progress
     * @param data Data to flash
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @Const @ByRef ByteVector data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @Const @ByRef ByteVector data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Const @ByRef ByteVector data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Const @ByRef ByteVector data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @Cast("const uint8_t*") BytePointer data, @Cast("size_t") long size, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @Cast("const uint8_t*") BytePointer data, @Cast("size_t") long size);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("const uint8_t*") ByteBuffer data, @Cast("size_t") long size, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("const uint8_t*") ByteBuffer data, @Cast("size_t") long size);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @Cast("const uint8_t*") byte[] data, @Cast("size_t") long size, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @Cast("const uint8_t*") byte[] data, @Cast("size_t") long size);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("const uint8_t*") BytePointer data, @Cast("size_t") long size, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("const uint8_t*") BytePointer data, @Cast("size_t") long size);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @Cast("const uint8_t*") ByteBuffer data, @Cast("size_t") long size, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @Cast("const uint8_t*") ByteBuffer data, @Cast("size_t") long size);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("const uint8_t*") byte[] data, @Cast("size_t") long size, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("const uint8_t*") byte[] data, @Cast("size_t") long size);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @StdString BytePointer filename, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @StdString BytePointer filename);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @StdString ByteBuffer filename, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @StdString ByteBuffer filename);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @StdString String filename, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @StdString String filename);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @StdString BytePointer filename, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @StdString BytePointer filename);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @StdString ByteBuffer filename, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(Memory memory, @Cast("size_t") long offset, @StdString ByteBuffer filename);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @StdString String filename, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @StdString String filename);

    /**
     * Reads arbitrary data at custom offset in specified memory
     * @param memory Memory to read
     * @param offset Offset at which to read the specified bytes
     * @param size Number of bytes to read
     * @param data Data to read to. Must be at least 'size' number of bytes big
     * @param progressCallback Callback that sends back a value between 0..1 which signifies current reading progress
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(
            Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @ByRef ByteVector data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(
            Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @ByRef ByteVector data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(
            @Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @ByRef ByteVector data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(
            @Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @ByRef ByteVector data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") BytePointer data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") BytePointer data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") ByteBuffer data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") ByteBuffer data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") byte[] data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") byte[] data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") BytePointer data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") BytePointer data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") ByteBuffer data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") ByteBuffer data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") byte[] data, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @Cast("uint8_t*") byte[] data);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @StdString String filename, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, @StdString String filename);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @StdString String filename, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, @StdString String filename);
    public native @ByVal BoolStringByteVectorTuple readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal BoolStringByteVectorTuple readCustom(Memory memory, @Cast("size_t") long offset, @Cast("size_t") long size);
    public native @ByVal BoolStringByteVectorTuple readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size, ProgressCallback progressCb/*=nullptr*/);
    public native @ByVal BoolStringByteVectorTuple readCustom(@Cast("dai::bootloader::Memory") int memory, @Cast("size_t") long offset, @Cast("size_t") long size);

    /**
     * Reads configuration data from bootloader
     * @return Unstructured configuration data
     * @param memory Optional - from which memory to read configuration data
     * @param type Optional - from which type of bootloader to read configuration data
     */
    public native @ByVal @Cast("nlohmann::json*") Pointer readConfigData(Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, Type type/*=dai::DeviceBootloader::Type::AUTO*/);
    public native @ByVal @Cast("nlohmann::json*") Pointer readConfigData();
    public native @ByVal @Cast("nlohmann::json*") Pointer readConfigData(@Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("dai::bootloader::Type") int type/*=dai::DeviceBootloader::Type::AUTO*/);

    /**
     * Flashes configuration data to bootloader
     * @param configData Unstructured configuration data
     * @param memory Optional - to which memory flash configuration
     * @param type Optional - for which type of bootloader to flash configuration
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigData(@ByVal @Cast("nlohmann::json*") Pointer configData, Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, Type type/*=dai::DeviceBootloader::Type::AUTO*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigData(@ByVal @Cast("nlohmann::json*") Pointer configData);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigData(@ByVal @Cast("nlohmann::json*") Pointer configData, @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("dai::bootloader::Type") int type/*=dai::DeviceBootloader::Type::AUTO*/);

    /**
     * Flashes configuration data to bootloader
     * @param configPath Unstructured configuration data
     * @param memory Optional - to which memory flash configuration
     * @param type Optional - for which type of bootloader to flash configuration
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigFile(@Const @ByRef Path configPath, Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, Type type/*=dai::DeviceBootloader::Type::AUTO*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigFile(@Const @ByRef Path configPath);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigFile(@Const @ByRef Path configPath, @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("dai::bootloader::Type") int type/*=dai::DeviceBootloader::Type::AUTO*/);

    /**
     * Clears configuration data
     * @param memory Optional - on which memory to clear configuration data
     * @param type Optional - for which type of bootloader to clear configuration data
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigClear(Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, Type type/*=dai::DeviceBootloader::Type::AUTO*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigClear();
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfigClear(@Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("dai::bootloader::Type") int type/*=dai::DeviceBootloader::Type::AUTO*/);

    /**
     * Reads configuration from bootloader
     * @param memory Optional - from which memory to read configuration
     * @param type Optional - from which type of bootloader to read configuration
     * @return Configuration structure
     */
    public native @ByVal Config readConfig(Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, Type type/*=dai::DeviceBootloader::Type::AUTO*/);
    public native @ByVal Config readConfig();
    public native @ByVal Config readConfig(@Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("dai::bootloader::Type") int type/*=dai::DeviceBootloader::Type::AUTO*/);

    /**
     * Flashes configuration to bootloader
     * @param configData Configuration structure
     * @param memory Optional - to which memory flash configuration
     * @param type Optional - for which type of bootloader to flash configuration
     */
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfig(@Const @ByRef Config config, Memory memory/*=dai::DeviceBootloader::Memory::AUTO*/, Type type/*=dai::DeviceBootloader::Type::AUTO*/);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfig(@Const @ByRef Config config);
    public native @ByVal @Cast("std::tuple<bool,std::string>*") Pointer flashConfig(@Const @ByRef Config config, @Cast("dai::bootloader::Memory") int memory/*=dai::DeviceBootloader::Memory::AUTO*/, @Cast("dai::bootloader::Type") int type/*=dai::DeviceBootloader::Type::AUTO*/);

    /**
     * Retrieves information about specified memory
     * @param memory Specifies which memory to query
     */
    public native @ByVal MemoryInfo getMemoryInfo(Memory memory);
    public native @ByVal MemoryInfo getMemoryInfo(@Cast("dai::bootloader::Memory") int memory);

    /**
     * Checks whether User Bootloader is supported with current bootloader
     * @return true of User Bootloader is supported, false otherwise
     */
    public native @Cast("bool") boolean isUserBootloaderSupported();

    /**
     * Retrieves whether current bootloader is User Bootloader (B out of A/B configuration)
     */
    public native @Cast("bool") boolean isUserBootloader();

    /**
     * Boots a custom FW in memory
     * @param fw
     * @throws A runtime exception if there are any communication issues
     */
    public native void bootMemory(@Const @ByRef ByteVector fw);

    /**
     * Boots into integrated ROM bootloader in USB mode
     * @throws A runtime exception if there are any communication issues
     */
    public native void bootUsbRomBootloader();

    /**
     * @return Version of current running bootloader
     */
    public native @ByVal Version getVersion();

    /**
     * @return True when bootloader was booted using latest bootloader integrated in the library.
     * False when bootloader is already running on the device and just connected to.
     */
    public native @Cast("bool") boolean isEmbeddedVersion();

    /**
     * @return Type of currently connected bootloader
     */
    public native Type getType();

    /**
     * @return True if allowed to flash bootloader
     */
    public native @Cast("bool") boolean isAllowedFlashingBootloader();

    /**
     * Explicitly closes connection to device.
     * \note This function does not need to be explicitly called
     * as destructor closes the device automatically
     */
    public native @Name("close") void _close();

    /**
     * Is the device already closed (or disconnected)
     *
     * \warning This function is thread-unsafe and may return outdated incorrect values. It is
     * only meant for use in simple single-threaded code. Well written code should handle
     * exceptions when calling any DepthAI apis to handle hardware events and multithreaded use.
     */
    public native @Cast("bool") boolean isClosed();
}
