// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class IMUProperties extends IMUPropertiesSerializable {
    static { Loader.load(); }
    /** Default native constructor. */
    public IMUProperties() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IMUProperties(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IMUProperties(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public IMUProperties position(long position) {
        return (IMUProperties)super.position(position);
    }
    @Override public IMUProperties getPointer(long i) {
        return new IMUProperties((Pointer)this).offsetAddress(i);
    }

    /* Enabled IMU sensors */
    public native @StdVector IMUSensorConfig imuSensors(); public native IMUProperties imuSensors(IMUSensorConfig setter);
    /* Above this packet threshold data will be sent to host, if queue is not blocked */
    public native @Cast("std::int32_t") int batchReportThreshold(); public native IMUProperties batchReportThreshold(int setter);
    /* Maximum number of IMU packets in a batch. Maximum 5. */
    public native @Cast("std::int32_t") int maxBatchReports(); public native IMUProperties maxBatchReports(int setter);
    /*
     * Whether to perform firmware update or not.
     * Default value: false.
     */
    public native @ByRef BoolOptional enableFirmwareUpdate(); public native IMUProperties enableFirmwareUpdate(BoolOptional setter);
}
