// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/** RawAprilTags configuration structure */
@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class RawAprilTagConfig extends RawBuffer {
    static { Loader.load(); }
    /** Default native constructor. */
    public RawAprilTagConfig() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public RawAprilTagConfig(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RawAprilTagConfig(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public RawAprilTagConfig position(long position) {
        return (RawAprilTagConfig)super.position(position);
    }
    @Override public RawAprilTagConfig getPointer(long i) {
        return new RawAprilTagConfig((Pointer)this).offsetAddress(i);
    }

    /**
     * Supported AprilTag families.
     */
    public enum Family { TAG_36H11(0), TAG_36H10(1), TAG_25H9(2), TAG_16H5(3), TAG_CIR21H7(4), TAG_STAND41H12(5);

        public final int value;
        private Family(int v) { this.value = v; }
        private Family(Family e) { this.value = e.value; }
        public Family intern() { for (Family e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /**
     * AprilTag family.
     */
    public native Family family(); public native RawAprilTagConfig family(Family setter);

    /**
     * Detection of quads can be done on a lower-resolution image,
     * improving speed at a cost of pose accuracy and a slight
     * decrease in detection rate. Decoding the binary payload is
     * still done at full resolution.
     */
    public native @Cast("std::int32_t") int quadDecimate(); public native RawAprilTagConfig quadDecimate(int setter);

    /**
     * What Gaussian blur should be applied to the segmented image.
     * Parameter is the standard deviation in pixels.
     * Very noisy images benefit from non-zero values (e.g. 0.8).
     */
    public native float quadSigma(); public native RawAprilTagConfig quadSigma(float setter);

    /**
     * When non-zero, the edges of the each quad are adjusted to "snap
     * to" strong gradients nearby. This is useful when decimation is
     * employed, as it can increase the quality of the initial quad
     * estimate substantially. Generally recommended to be on.
     * Very computationally inexpensive. Option is ignored if quadDecimate = 1.
     */
    public native @Cast("bool") boolean refineEdges(); public native RawAprilTagConfig refineEdges(boolean setter);

    /**
     * How much sharpening should be done to decoded images? This
     * can help decode small tags but may or may not help in odd
     * lighting conditions or low light conditions.
     * The default value is 0.25.
     */
    public native float decodeSharpening(); public native RawAprilTagConfig decodeSharpening(float setter);

    /**
     * Max number of error bits that should be corrected. Accepting large numbers of
     * corrected errors leads to greatly increased false positive rates.
     * As of this implementation, the detector cannot detect tags with
     * a hamming distance greater than 2.
     */
    public native @Cast("std::int32_t") int maxHammingDistance(); public native RawAprilTagConfig maxHammingDistance(int setter);

    /**
     * AprilTag quad threshold parameters.
     */
    public static class QuadThresholds extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public QuadThresholds() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public QuadThresholds(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public QuadThresholds(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public QuadThresholds position(long position) {
            return (QuadThresholds)super.position(position);
        }
        @Override public QuadThresholds getPointer(long i) {
            return new QuadThresholds((Pointer)this).offsetAddress(i);
        }
    
        /**
         * Reject quads containing too few pixels.
         */
        public native @Cast("std::int32_t") int minClusterPixels(); public native QuadThresholds minClusterPixels(int setter);

        /**
         * How many corner candidates to consider when segmenting a group of pixels into a quad.
         */
        public native @Cast("std::int32_t") int maxNmaxima(); public native QuadThresholds maxNmaxima(int setter);

        /**
         * Reject quads where pairs of edges have angles that are close to
         * straight or close to 180 degrees. Zero means that no quads are
         * rejected. (In degrees).
         */
        public native float criticalDegree(); public native QuadThresholds criticalDegree(float setter);

        /**
         * When fitting lines to the contours, what is the maximum mean
         * squared error allowed?  This is useful in rejecting contours
         * that are far from being quad shaped; rejecting these quads "early"
         * saves expensive decoding processing.
         */
        public native float maxLineFitMse(); public native QuadThresholds maxLineFitMse(float setter);

        /**
         * When we build our model of black & white pixels, we add an
         * extra check that the white model must be (overall) brighter
         * than the black model. How much brighter? (in pixel values: [0,255]).
         */
        public native @Cast("std::int32_t") int minWhiteBlackDiff(); public native QuadThresholds minWhiteBlackDiff(int setter);

        /**
         * Should the thresholded image be deglitched? Only useful for very noisy images
         */
        public native @Cast("bool") boolean deglitch(); public native QuadThresholds deglitch(boolean setter);
    }

    /**
     * AprilTag quad threshold parameters.
     */
    public native @ByRef QuadThresholds quadThresholds(); public native RawAprilTagConfig quadThresholds(QuadThresholds setter);

    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector BytePointer metadata, @ByRef @Cast("dai::DatatypeEnum*") IntPointer datatype);
    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector ByteBuffer metadata, @ByRef @Cast("dai::DatatypeEnum*") IntBuffer datatype);
    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector byte[] metadata, @ByRef @Cast("dai::DatatypeEnum*") int[] datatype);
}
