// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/** RawCameraControl structure */
@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class RawCameraControl extends RawBuffer {
    static { Loader.load(); }
    /** Default native constructor. */
    public RawCameraControl() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public RawCameraControl(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RawCameraControl(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public RawCameraControl position(long position) {
        return (RawCameraControl)super.position(position);
    }
    @Override public RawCameraControl getPointer(long i) {
        return new RawCameraControl((Pointer)this).offsetAddress(i);
    }

    public enum Command {
        START_STREAM((byte)(1)),
        STOP_STREAM((byte)(2)),
        STILL_CAPTURE((byte)(3)),
        MOVE_LENS((byte)(4)), /* [1] lens position: 0-255
                        */
        AF_TRIGGER((byte)(5)),
        AE_MANUAL((byte)(6)), /* [1] exposure time [us]
                        * [2] sensitivity [iso]
                        * [3] frame duration [us]
                        */
        AE_AUTO((byte)(7)),
        AWB_MODE((byte)(8)),                  /* [1] awb_mode: AutoWhiteBalanceMode
                                        */
        SCENE_MODE((byte)(9)),                /* [1] scene_mode: SceneMode
                                        */
        ANTIBANDING_MODE((byte)(10)),         /* [1] antibanding_mode: AntiBandingMode
                                        */
        EXPOSURE_COMPENSATION((byte)(11)),    /* [1] value
                                        */
        AE_LOCK((byte)(13)),                  /* [1] ae_lock_mode: bool
                                        */
        AE_TARGET_FPS_RANGE((byte)(14)),      /* [1] min_fps
                                        * [2] max_fps
                                        */
        AWB_LOCK((byte)(16)),                 /* [1] awb_lock_mode: bool
                                        */
        CAPTURE_INTENT((byte)(17)),           /* [1] capture_intent_mode: CaptureIntent
                                        */
        CONTROL_MODE((byte)(18)),             /* [1] control_mode: ControlMode
                                        */
        FRAME_DURATION((byte)(21)),           /* [1] frame_duration
                                        */
        SENSITIVITY((byte)(23)),              /* [1] iso_val
                                        */
        EFFECT_MODE((byte)(24)),              /* [1] effect_mode: EffectMode
                                        */
        AF_MODE((byte)(26)),                  /* [1] af_mode: AutoFocusMode
                                        */
        NOISE_REDUCTION_STRENGTH((byte)(27)), /* [1] value
                                        */
        SATURATION((byte)(28)),               /* [1] value
                                        */
        BRIGHTNESS((byte)(31)),               /* [1] value
                                        */
        STREAM_FORMAT((byte)(33)),            /* [1] format
                                        */
        RESOLUTION((byte)(34)),               /* [1] width
                                        * [2] height
                                        */
        SHARPNESS((byte)(35)),                /* [1] value
                                        */
        CUSTOM_USECASE((byte)(40)),           /* [1] value
                                        */
        CUSTOM_CAPT_MODE((byte)(41)),         /* [1] value
                                        */
        CUSTOM_EXP_BRACKETS((byte)(42)),      /* [1] val1
                                        * [2] val2
                                        * [3] val3
                                        */
        CUSTOM_CAPTURE((byte)(43)),           /* [1] value
                                        */
        CONTRAST((byte)(44)),                 /* [1] value
                                        */
        AE_REGION((byte)(45)),                /* [1] x
                                        * [2] y
                                        * [3] width
                                        * [4] height
                                        * [5] priority
                                        */
        AF_REGION((byte)(46)),                /* [1] x
                                        * [2] y
                                        * [3] width
                                        * [4] height
                                        * [5] priority
                                        */
        LUMA_DENOISE((byte)(47)),             /* [1] value
                                        */
        CHROMA_DENOISE((byte)(48)),           /* [1] value
                                        */
        WB_COLOR_TEMP((byte)(49)),            /* [1] value
                                        */
        EXTERNAL_TRIGGER((byte)(50)),
        AF_LENS_RANGE((byte)(51)),
        FRAME_SYNC((byte)(52)),
        STROBE_CONFIG((byte)(53)),
        STROBE_TIMINGS((byte)(54));

        public final byte value;
        private Command(byte v) { this.value = v; }
        private Command(Command e) { this.value = e.value; }
        public Command intern() { for (Command e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum AutoFocusMode {
        /**
         * Autofocus disabled. Suitable for manual focus
         */
        OFF((byte)(0)),
        /**
         * Basic automatic focus mode. In this mode, the lens does not move unless the autofocus trigger action is called.
         */
        AUTO((byte)(1)),
        /**
         * Close-up focusing mode - this mode is optimized for focusing on objects very close to the camera.
         */
        MACRO((byte)(2)),
        /**
         * In this mode, the AF algorithm modifies the lens position continually to attempt to provide a constantly-in-focus image stream.
         * The focusing behavior should be suitable for good quality video recording; typically this means slower focus movement and no overshoots.
         */
        CONTINUOUS_VIDEO((byte)(3)),
        /**
         * In this mode, the AF algorithm modifies the lens position continually to attempt to provide a constantly-in-focus image stream.
         * The focusing behavior should be suitable for still image capture; typically this means focusing as fast as possible
         */
        CONTINUOUS_PICTURE((byte)(4)),
        /**
         * Extended depth of field (digital focus) mode. The camera device will produce images with an extended depth of field automatically.
         * AF triggers are ignored.
         */
        EDOF((byte)(5));

        public final byte value;
        private AutoFocusMode(byte v) { this.value = v; }
        private AutoFocusMode(AutoFocusMode e) { this.value = e.value; }
        public AutoFocusMode intern() { for (AutoFocusMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum AutoWhiteBalanceMode {
        /**
         * The camera device's auto-white balance routine is disabled.
         */
        OFF((byte)(0)),
        /**
         * The camera device's auto-white balance routine is active.
         */
        AUTO((byte)(1)),
        /**
         * The camera device's auto-white balance routine is disabled; the camera device uses incandescent light as the assumed scene illumination for white
         * balance.
         */
        INCANDESCENT((byte)(2)),
        /**
         * The camera device's auto-white balance routine is disabled; the camera device uses fluorescent light as the assumed scene illumination for white
         * balance.
         */
        FLUORESCENT((byte)(3)),
        /**
         * The camera device's auto-white balance routine is disabled; the camera device uses warm fluorescent light as the assumed scene illumination for white
         * balance.
         */
        WARM_FLUORESCENT((byte)(4)),
        /**
         * The camera device's auto-white balance routine is disabled; the camera device uses daylight light as the assumed scene illumination for white
         * balance.
         */
        DAYLIGHT((byte)(5)),
        /**
         * The camera device's auto-white balance routine is disabled; the camera device uses cloudy daylight light as the assumed scene illumination for white
         * balance.
         */
        CLOUDY_DAYLIGHT((byte)(6)),
        /**
         * The camera device's auto-white balance routine is disabled; the camera device uses twilight light as the assumed scene illumination for white
         * balance.
         */
        TWILIGHT((byte)(7)),
        /**
         * The camera device's auto-white balance routine is disabled; the camera device uses shade light as the assumed scene illumination for white balance.
         */
        SHADE((byte)(8));

        public final byte value;
        private AutoWhiteBalanceMode(byte v) { this.value = v; }
        private AutoWhiteBalanceMode(AutoWhiteBalanceMode e) { this.value = e.value; }
        public AutoWhiteBalanceMode intern() { for (AutoWhiteBalanceMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum SceneMode {
        /**
         * Indicates that no scene modes are set for a given capture request.
         */
        UNSUPPORTED((byte)(0)),
        /**
         * If face detection support exists, use face detection data for auto-focus, auto-white balance, and auto-exposure routines.
         */
        FACE_PRIORITY((byte)(1)),
        /**
         * Optimized for photos of quickly moving objects. Similar to SPORTS scene mode.
         */
        ACTION((byte)(2)),
        /**
         * Optimized for still photos of people.
         */
        PORTRAIT((byte)(3)),
        /**
         * Optimized for photos of distant macroscopic objects.
         */
        LANDSCAPE((byte)(4)),
        /**
         * Optimized for low-light settings.
         */
        NIGHT((byte)(5)),
        /**
         * Optimized for still photos of people in low-light settings.
         */
        NIGHT_PORTRAIT((byte)(6)),
        /**
         * Optimized for dim, indoor settings where flash must remain off.
         */
        THEATRE((byte)(7)),
        /**
         * Optimized for bright, outdoor beach settings.
         */
        BEACH((byte)(8)),
        /**
         * Optimized for bright, outdoor settings containing snow.
         */
        SNOW((byte)(9)),
        /**
         * Optimized for scenes of the setting sun.
         */
        SUNSET((byte)(10)),
        /**
         * Optimized to avoid blurry photos due to small amounts of device motion (for example: due to hand shake).
         */
        STEADYPHOTO((byte)(11)),
        /**
         * Optimized for nighttime photos of fireworks.
         */
        FIREWORKS((byte)(12)),
        /**
         * Optimized for photos of quickly moving people.
         */
        SPORTS((byte)(13)),
        /**
         * Optimized for dim, indoor settings with multiple moving people.
         */
        PARTY((byte)(14)),
        /**
         * Optimized for dim settings where the main light source is a candle.
         */
        CANDLELIGHT((byte)(15)),
        /**
         * Optimized for accurately capturing a photo of barcode for use by camera applications that wish to read the barcode value.
         */
        BARCODE((byte)(16));

        public final byte value;
        private SceneMode(byte v) { this.value = v; }
        private SceneMode(SceneMode e) { this.value = e.value; }
        public SceneMode intern() { for (SceneMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum AntiBandingMode {
        /**
         * The camera device will not adjust exposure duration to avoid banding problems.
         */
        OFF((byte)(0)),
        /**
         * The camera device will adjust exposure duration to avoid banding problems with 50Hz illumination sources.
         */
        MAINS_50_HZ((byte)(1)),
        /**
         * The camera device will adjust exposure duration to avoid banding problems with 60Hz illumination sources.
         */
        MAINS_60_HZ((byte)(2)),
        /**
         * The camera device will automatically adapt its antibanding routine to the current illumination condition. This is the default mode if AUTO is
         * available on given camera device.
         */
        AUTO((byte)(3));

        public final byte value;
        private AntiBandingMode(byte v) { this.value = v; }
        private AntiBandingMode(AntiBandingMode e) { this.value = e.value; }
        public AntiBandingMode intern() { for (AntiBandingMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum CaptureIntent {
        /**
         * The goal of this request doesn't fall into the other categories. The camera device will default to preview-like behavior.
         */
        CUSTOM((byte)(0)),
        /**
         * This request is for a preview-like use case.
         */
        PREVIEW((byte)(1)),
        /**
         * This request is for a still capture-type use case.
         */
        STILL_CAPTURE((byte)(2)),
        /**
         * This request is for a video recording use case.
         */
        VIDEO_RECORD((byte)(3)),
        /**
         * This request is for a video snapshot (still image while recording video) use case.
         * The camera device should take the highest-quality image possible (given the other settings)
         * without disrupting the frame rate of video recording.
         */
        VIDEO_SNAPSHOT((byte)(4)),
        /**
         * This request is for a ZSL usecase; the application will stream full-resolution images and reprocess one or several later for a final capture.
         */
        ZERO_SHUTTER_LAG((byte)(5));

        public final byte value;
        private CaptureIntent(byte v) { this.value = v; }
        private CaptureIntent(CaptureIntent e) { this.value = e.value; }
        public CaptureIntent intern() { for (CaptureIntent e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum ControlMode {
        /**
         * Full application control of pipeline. All control by the device's metering and focusing (3A) routines is disabled.
         */
        OFF((byte)(0)),
        /**
         * Use settings for each individual 3A routine. Manual control of capture parameters is disabled.
         */
        AUTO((byte)(1)),
        /**
         * Use a specific scene mode. Enabling this disables Auto-Exposure, AWB and AF controls;
         */
        USE_SCENE_MODE((byte)(2));

        public final byte value;
        private ControlMode(byte v) { this.value = v; }
        private ControlMode(ControlMode e) { this.value = e.value; }
        public ControlMode intern() { for (ControlMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum EffectMode {
        /**
         *  No color effect will be applied.
         */
        OFF((byte)(0)),
        /**
         * A "monocolor" effect where the image is mapped into a single color. This will typically be grayscale.
         */
        MONO((byte)(1)),
        /**
         * A "photo-negative" effect where the image's colors are inverted.
         */
        NEGATIVE((byte)(2)),
        /**
         * A "solarisation" effect (Sabattier effect) where the image is wholly or partially reversed in tone.
         */
        SOLARIZE((byte)(3)),
        /**
         * A "sepia" effect where the image is mapped into warm gray, red, and brown tones.
         */
        SEPIA((byte)(4)),
        /**
         * A "posterization" effect where the image uses discrete regions of tone rather than a continuous gradient of tones.
         */
        POSTERIZE((byte)(5)),
        /**
         * A "whiteboard" effect where the image is typically displayed as regions of white, with black or grey details.
         */
        WHITEBOARD((byte)(6)),
        /**
         * A "blackboard" effect where the image is typically displayed as regions of black, with white or grey details.
         */
        BLACKBOARD((byte)(7)),
        /**
         * An "aqua" effect where a blue hue is added to the image.
         */
        AQUA((byte)(8));

        public final byte value;
        private EffectMode(byte v) { this.value = v; }
        private EffectMode(EffectMode e) { this.value = e.value; }
        public EffectMode intern() { for (EffectMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum FrameSyncMode {
        OFF((byte)(0)),
        OUTPUT((byte)(1)),
        INPUT((byte)(2));
        // TODO soft sync modes?

        public final byte value;
        private FrameSyncMode(byte v) { this.value = v; }
        private FrameSyncMode(FrameSyncMode e) { this.value = e.value; }
        public FrameSyncMode intern() { for (FrameSyncMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public static class ManualExposureParams extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public ManualExposureParams() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ManualExposureParams(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ManualExposureParams(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public ManualExposureParams position(long position) {
            return (ManualExposureParams)super.position(position);
        }
        @Override public ManualExposureParams getPointer(long i) {
            return new ManualExposureParams((Pointer)this).offsetAddress(i);
        }
    
        public native @Cast("uint32_t") int exposureTimeUs(); public native ManualExposureParams exposureTimeUs(int setter);
        public native @Cast("uint32_t") int sensitivityIso(); public native ManualExposureParams sensitivityIso(int setter);
        public native @Cast("uint32_t") int frameDurationUs(); public native ManualExposureParams frameDurationUs(int setter);
    }

    // AE_REGION / AF_REGION
    public static class RegionParams extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public RegionParams() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public RegionParams(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public RegionParams(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public RegionParams position(long position) {
            return (RegionParams)super.position(position);
        }
        @Override public RegionParams getPointer(long i) {
            return new RegionParams((Pointer)this).offsetAddress(i);
        }
    
        public native @Cast("uint16_t") short x(); public native RegionParams x(short setter);
        public native @Cast("uint16_t") short y(); public native RegionParams y(short setter);
        public native @Cast("uint16_t") short width(); public native RegionParams width(short setter);
        public native @Cast("uint16_t") short height(); public native RegionParams height(short setter);
        // Set to 1 for now. TODO
        public native @Cast("uint32_t") int priority(); public native RegionParams priority(int setter);
    }

    public static class StrobeTimings extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public StrobeTimings() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public StrobeTimings(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public StrobeTimings(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public StrobeTimings position(long position) {
            return (StrobeTimings)super.position(position);
        }
        @Override public StrobeTimings getPointer(long i) {
            return new StrobeTimings((Pointer)this).offsetAddress(i);
        }
    
        /** Start offset in microseconds, relative to exposure window */
        public native int exposureBeginOffsetUs(); public native StrobeTimings exposureBeginOffsetUs(int setter);
        /** End offset in microseconds, relative to exposure window */
        public native int exposureEndOffsetUs(); public native StrobeTimings exposureEndOffsetUs(int setter);
        /** Fixed duration in microseconds. If set (non-zero), overrides {@code exposureEndOffsetUs} */
        public native @Cast("uint32_t") int durationUs(); public native StrobeTimings durationUs(int setter);
    }

    public static class StrobeConfig extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public StrobeConfig() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public StrobeConfig(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public StrobeConfig(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public StrobeConfig position(long position) {
            return (StrobeConfig)super.position(position);
        }
        @Override public StrobeConfig getPointer(long i) {
            return new StrobeConfig((Pointer)this).offsetAddress(i);
        }
    
        /** Enable strobe output */
        public native @Cast("uint8_t") byte enable(); public native StrobeConfig enable(byte setter);
        /** 1 for normal polarity (high-active), 0 otherwise */
        public native @Cast("uint8_t") byte activeLevel(); public native StrobeConfig activeLevel(byte setter);
        /** GPIO number to drive, or -1 if sensor driven */
        public native byte gpioNumber(); public native StrobeConfig gpioNumber(byte setter);
    }

    public native @Cast("uint64_t") long cmdMask(); public native RawCameraControl cmdMask(long setter);

    public native AutoFocusMode autoFocusMode(); public native RawCameraControl autoFocusMode(AutoFocusMode setter);

    /**
     * Lens/VCM position, range: 0..255. Used with {@code autoFocusMode = OFF}.
     * With current IMX378 modules:
     * - max 255: macro focus, at 8cm distance
     * - infinite focus at about 120..130 (may vary from module to module)
     * - lower values lead to out-of-focus (lens too close to the sensor array)
     */
    public native @Cast("uint8_t") byte lensPosition(); public native RawCameraControl lensPosition(byte setter);
    public native @Cast("uint8_t") byte lensPosAutoInfinity(); public native RawCameraControl lensPosAutoInfinity(byte setter);
    public native @Cast("uint8_t") byte lensPosAutoMacro(); public native RawCameraControl lensPosAutoMacro(byte setter);

    public native @ByRef ManualExposureParams expManual(); public native RawCameraControl expManual(ManualExposureParams setter);
    public native @ByRef RegionParams aeRegion(); public native RawCameraControl aeRegion(RegionParams setter);
    public native @ByRef RegionParams afRegion(); public native RawCameraControl afRegion(RegionParams setter);
    public native AutoWhiteBalanceMode awbMode(); public native RawCameraControl awbMode(AutoWhiteBalanceMode setter);
    public native SceneMode sceneMode(); public native RawCameraControl sceneMode(SceneMode setter);
    public native AntiBandingMode antiBandingMode(); public native RawCameraControl antiBandingMode(AntiBandingMode setter);
    public native EffectMode effectMode(); public native RawCameraControl effectMode(EffectMode setter);
    public native FrameSyncMode frameSyncMode(); public native RawCameraControl frameSyncMode(FrameSyncMode setter);
    public native @ByRef StrobeConfig strobeConfig(); public native RawCameraControl strobeConfig(StrobeConfig setter);
    public native @ByRef StrobeTimings strobeTimings(); public native RawCameraControl strobeTimings(StrobeTimings setter);
    public native @Cast("bool") boolean aeLockMode(); public native RawCameraControl aeLockMode(boolean setter);
    public native @Cast("bool") boolean awbLockMode(); public native RawCameraControl awbLockMode(boolean setter);
    public native byte expCompensation(); public native RawCameraControl expCompensation(byte setter);  //  -9 ..  9
    public native byte brightness(); public native RawCameraControl brightness(byte setter);       // -10 .. 10
    public native byte contrast(); public native RawCameraControl contrast(byte setter);         // -10 .. 10
    public native byte saturation(); public native RawCameraControl saturation(byte setter);       // -10 .. 10
    public native @Cast("uint8_t") byte sharpness(); public native RawCameraControl sharpness(byte setter);       //   0 ..  4
    public native @Cast("uint8_t") byte lumaDenoise(); public native RawCameraControl lumaDenoise(byte setter);     //   0 ..  4
    public native @Cast("uint8_t") byte chromaDenoise(); public native RawCameraControl chromaDenoise(byte setter);   //   0 ..  4
    public native @Cast("uint16_t") short wbColorTemp(); public native RawCameraControl wbColorTemp(short setter);    // 1000 .. 12000
    public native @Cast("uint8_t") byte lowPowerNumFramesBurst(); public native RawCameraControl lowPowerNumFramesBurst(byte setter);
    public native @Cast("uint8_t") byte lowPowerNumFramesDiscard(); public native RawCameraControl lowPowerNumFramesDiscard(byte setter);

    public native void setCommand(Command cmd, @Cast("bool") boolean value/*=true*/);
    public native void setCommand(Command cmd);
    public native void setCommand(@Cast("dai::RawCameraControl::Command") byte cmd, @Cast("bool") boolean value/*=true*/);
    public native void setCommand(@Cast("dai::RawCameraControl::Command") byte cmd);
    public native void clearCommand(Command cmd);
    public native void clearCommand(@Cast("dai::RawCameraControl::Command") byte cmd);
    public native @Cast("bool") boolean getCommand(Command cmd);
    public native @Cast("bool") boolean getCommand(@Cast("dai::RawCameraControl::Command") byte cmd);

    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector BytePointer metadata, @ByRef @Cast("dai::DatatypeEnum*") IntPointer datatype);
    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector ByteBuffer metadata, @ByRef @Cast("dai::DatatypeEnum*") IntBuffer datatype);
    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector byte[] metadata, @ByRef @Cast("dai::DatatypeEnum*") int[] datatype);
}
