// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/** SpatialLocation configuration data structure */
@Namespace("dai") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class SpatialLocationCalculatorConfigData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public SpatialLocationCalculatorConfigData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public SpatialLocationCalculatorConfigData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SpatialLocationCalculatorConfigData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public SpatialLocationCalculatorConfigData position(long position) {
        return (SpatialLocationCalculatorConfigData)super.position(position);
    }
    @Override public SpatialLocationCalculatorConfigData getPointer(long i) {
        return new SpatialLocationCalculatorConfigData((Pointer)this).offsetAddress(i);
    }

    @MemberGetter public static native @Cast("const std::int32_t") int AUTO();
    public static final int AUTO = AUTO();

    /**
     * Region of interest for spatial location calculation.
     */
    public native @ByRef Rect roi(); public native SpatialLocationCalculatorConfigData roi(Rect setter);
    /**
     * Upper and lower thresholds for depth values to take into consideration.
     */
    public native @ByRef SpatialLocationCalculatorConfigThresholds depthThresholds(); public native SpatialLocationCalculatorConfigData depthThresholds(SpatialLocationCalculatorConfigThresholds setter);
    /**
     * Calculation method used to obtain spatial locations
     * Average/mean: the average of ROI is used for calculation.
     * Min: the minimum value inside ROI is used for calculation.
     * Max: the maximum value inside ROI is used for calculation.
     * Mode: the most frequent value inside ROI is used for calculation.
     * Median: the median value inside ROI is used for calculation.
     * Default: median.
     */
    public native SpatialLocationCalculatorAlgorithm calculationAlgorithm(); public native SpatialLocationCalculatorConfigData calculationAlgorithm(SpatialLocationCalculatorAlgorithm setter);
    /**
     * Step size for calculation.
     * Step size 1 means that every pixel is taken into calculation, size 2 means every second etc.
     * Default value AUTO: for AVERAGE, MIN, MAX step size is 1; for MODE/MEDIAN it's 2.
     */
    public native @Cast("std::int32_t") int stepSize(); public native SpatialLocationCalculatorConfigData stepSize(int setter);
}
