// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


// Config
@Namespace("dai::bootloader") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class UsbConfig extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public UsbConfig() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public UsbConfig(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public UsbConfig(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public UsbConfig position(long position) {
        return (UsbConfig)super.position(position);
    }
    @Override public UsbConfig getPointer(long i) {
        return new UsbConfig((Pointer)this).offsetAddress(i);
    }

    /**
     * If timeout < 0 - waits forever
     * if timeout == 0 - no timeout
     * if timeout > 0 - waits timeout milliseconds
     */
    public native int timeoutMs(); public native UsbConfig timeoutMs(int setter);

    /**
     * UNKNOWN = 0, LOW, FULL, HIGH, SUPER, SUPER_PLUS
     */
    public native int maxUsbSpeed(); public native UsbConfig maxUsbSpeed(int setter);

    /** VID/PID pair used by bootloader */
    public native @Cast("uint16_t") short vid(); public native UsbConfig vid(short setter);
    public native @Cast("uint16_t") short pid(); public native UsbConfig pid(short setter);
}
