// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.depthai.global;

import org.bytedeco.depthai.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

public class depthai extends org.bytedeco.depthai.presets.depthai {
    static { Loader.load(); }

// Targeting ../BoolOptional.java


// Targeting ../FloatOptional.java


// Targeting ../IntOptional.java


// Targeting ../SizeTOptional.java


// Targeting ../StringOptional.java


// Targeting ../BoardConfigIMUOptional.java


// Targeting ../CameraSensorTypeOptional.java


// Targeting ../CameraImageOrientationOptional.java


// Targeting ../EepromDataOptional.java


// Targeting ../LogLevelOptional.java


// Targeting ../VersionOptional.java


// Targeting ../StringIntVectorMap.java


// Targeting ../StringAssetViewPairVector.java


// Targeting ../ByteVector.java


// Targeting ../IntVector.java


// Targeting ../StringVector.java


// Targeting ../FloatVectorVector.java


// Targeting ../FloatFloatPairVector.java


// Targeting ../Point2fVector.java


// Targeting ../AssetVector.java


// Targeting ../ADatatypeVector.java


// Targeting ../NodeVector.java


// Targeting ../BoolFloatTuple.java


// Targeting ../StringIntIntTuple.java


// Targeting ../StringStringTuple.java


// Targeting ../FloatVectorVectorIntIntTuple.java


// Targeting ../BoolStringByteVectorTuple.java


// Targeting ../StringNodeInputMap.java


// Targeting ../StringNodeOutputMap.java


// Targeting ../CameraBoardSocketStringMap.java


// Targeting ../CameraBoardSocketCameraInfoMap.java


// Targeting ../CameraBoardSocketBoardConfigCameraMap.java


// Targeting ../NodeIdConnectionSetMap.java


// Targeting ../NodeIdNodeMap.java


// Targeting ../LongNodeObjInfoMap.java


// Targeting ../ByteGPIOMap.java


// Targeting ../ByteUARTMap.java


// Targeting ../StringTensorInfoMap.java


// Targeting ../StringNodeIoInfoMap.java


// Targeting ../StringNodeInputMap.java


// Targeting ../StringNodeOutputMap.java


// Targeting ../StringNodeInputMapMap.java


// Targeting ../StringNodeOutputMapMap.java


// Targeting ../ConnectionSet.java


// Parsed from XLink/XLinkPublicDefines.h

// Copyright (C) 2018-2021 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

/**
 *  \file
 * 
 *  \brief     Application configuration Leon header
 *  */
// #ifndef _XLINKPUBLICDEFINES_H
// #define _XLINKPUBLICDEFINES_H
// #include <stdint.h>
// #include <stdbool.h>
// #ifdef __cplusplus
// #endif

public static final int XLINK_MAX_MX_ID_SIZE = 32;
public static final int XLINK_MAX_NAME_SIZE = 64;

// #ifdef XLINK_MAX_STREAM_RES
// #else
public static final int XLINK_MAX_STREAMS = 32;
// #endif
public static final int XLINK_MAX_PACKETS_PER_STREAM = 64;
public static final int XLINK_NO_RW_TIMEOUT = 0xFFFFFFFF;


/** enum UsbSpeed_t */
public static final int
    X_LINK_USB_SPEED_UNKNOWN = 0,
    X_LINK_USB_SPEED_LOW = 1,
    X_LINK_USB_SPEED_FULL = 2,
    X_LINK_USB_SPEED_HIGH = 3,
    X_LINK_USB_SPEED_SUPER = 4,
    X_LINK_USB_SPEED_SUPER_PLUS = 5;

/** enum XLinkError_t */
public static final int
    X_LINK_SUCCESS = 0,
    X_LINK_ALREADY_OPEN = 1,
    X_LINK_COMMUNICATION_NOT_OPEN = 2,
    X_LINK_COMMUNICATION_FAIL = 3,
    X_LINK_COMMUNICATION_UNKNOWN_ERROR = 4,
    X_LINK_DEVICE_NOT_FOUND = 5,
    X_LINK_TIMEOUT = 6,
    X_LINK_ERROR = 7,
    X_LINK_OUT_OF_MEMORY = 8,
    X_LINK_INSUFFICIENT_PERMISSIONS = 9,
    X_LINK_DEVICE_ALREADY_IN_USE = 10,
    X_LINK_NOT_IMPLEMENTED = 11,
    X_LINK_INIT_USB_ERROR = 12,
    X_LINK_INIT_TCP_IP_ERROR = 13,
    X_LINK_INIT_PCIE_ERROR = 14;

/** enum XLinkProtocol_t */
public static final int
    X_LINK_USB_VSC = 0,
    X_LINK_USB_CDC = 1,
    X_LINK_PCIE = 2,
    X_LINK_IPC = 3,
    X_LINK_TCP_IP = 4,
    X_LINK_NMB_OF_PROTOCOLS = 5,
    X_LINK_ANY_PROTOCOL = 6;

/** enum XLinkPlatform_t */
public static final int
    X_LINK_ANY_PLATFORM = 0,
    X_LINK_MYRIAD_2 = 2450,
    X_LINK_MYRIAD_X = 2480;

/** enum XLinkDeviceState_t */
public static final int
    /**
     * Used only for searching devices. It means that the device state is not important.
     */
    X_LINK_ANY_STATE = 0,
    /**
     * The device is booted (firmware is loaded) and the pipeline is running.
     */
    X_LINK_BOOTED = 1,
    /**
     * Device isn't booted, e.g. for USB devices with no bootloader flashed. In such case it's waiting for the USB boot.
     */
    X_LINK_UNBOOTED = 2,
    /**
     * The device is in bootloader and waiting for a connection. After the connection the state will change to BOOTED.
     */
    X_LINK_BOOTLOADER = 3,
    /**
     * The device has booted the flashed firmware/pipeline (e.g. in case of OAK POE devices in standalone mode).
     */
    X_LINK_FLASH_BOOTED = 4,
    /**
     * The device has booted the flashed firmware/pipeline (e.g. in case of OAK POE devices in standalone mode).
     */
    X_LINK_BOOTED_NON_EXCLUSIVE = X_LINK_FLASH_BOOTED;

/** enum XLinkPCIEBootloader */
public static final int
    X_LINK_PCIE_UNKNOWN_BOOTLOADER = 0,
    X_LINK_PCIE_SIMPLIFIED_BOOTLOADER = 1,
    X_LINK_PCIE_UNIFIED_BOOTLOADER = 2;

public static final int INVALID_STREAM_ID = 0xDEADDEAD;
public static final int INVALID_STREAM_ID_OUT_OF_MEMORY = 0xDEADFFFF;
public static final int INVALID_LINK_ID =   0xFF;
public static final int MAX_STREAM_NAME_LENGTH = 64;
// Targeting ../deviceDesc_t.java


// Targeting ../streamPacketDesc_t.java


// Targeting ../XLinkProf_t.java


// Targeting ../XLinkGlobalHandler_t.java


// Targeting ../XLinkHandler_t.java



//Deprecated defines. Begin.

/** enum XLinkProtocol_deprecated_t */
public static final int
    USB_VSC = 0,
    USB_CDC = 1,
    PCIE = 2,
    IPC = 3,
    NMB_OF_PROTOCOLS = 4;

//Deprecated defines. End.

// #ifdef __cplusplus
// #endif

// #endif

/* end of include file */


// Parsed from depthai/depthai.hpp

// #pragma once

// Includes common classes needed to start the development

// Include initialization utility
// #include "utility/Initialization.hpp"

// Include some common device classes
// #include "device/CalibrationHandler.hpp"
// #include "device/Device.hpp"
// #include "device/DeviceBootloader.hpp"

// Include Pipeline
// #include "pipeline/Pipeline.hpp"

// Include common nodes
// #include "pipeline/nodes.hpp"

// Include common datatypes
// #include "pipeline/datatypes.hpp"

// namespace dai {
// namespace{
// bool initializeForce = [](){initialize();};
// } // namespace
// }


// Parsed from depthai/build/config.hpp

/*
 * Generated by CMake build tool.
 */
// #pragma once

// This build supports OpenCV integration?
// #define DEPTHAI_HAVE_OPENCV_SUPPORT

// Build specific settings overwrite
// #ifdef DEPTHAI_TARGET_CORE
// #ifndef DEPTHAI_TARGET_OPENCV
// #undef DEPTHAI_HAVE_OPENCV_SUPPORT
// #endif
// #endif


// Parsed from depthai/utility/Initialization.hpp

// #pragma once

// #include <string>

@Namespace("dai") public static native @Cast("bool") boolean initialize();
@Namespace("dai") public static native @Cast("bool") boolean initialize(@StdString BytePointer additionalInfo, @Cast("bool") boolean installSignalHandler/*=true*/, Pointer javavm/*=nullptr*/);
@Namespace("dai") public static native @Cast("bool") boolean initialize(@StdString BytePointer additionalInfo);
@Namespace("dai") public static native @Cast("bool") boolean initialize(@StdString ByteBuffer additionalInfo, @Cast("bool") boolean installSignalHandler/*=true*/, Pointer javavm/*=nullptr*/);
@Namespace("dai") public static native @Cast("bool") boolean initialize(@StdString ByteBuffer additionalInfo);
@Namespace("dai") public static native @Cast("bool") boolean initialize(@StdString String additionalInfo, @Cast("bool") boolean installSignalHandler/*=true*/, Pointer javavm/*=nullptr*/);
@Namespace("dai") public static native @Cast("bool") boolean initialize(@StdString String additionalInfo);
@Namespace("dai") public static native @Cast("bool") boolean initialize(Pointer javavm);

  // namespace dai


// Parsed from depthai/utility/LockingQueue.hpp

// #pragma once
// #include <atomic>
// #include <condition_variable>
// #include <functional>
// #include <limits>
// #include <mutex>
// #include <queue>

  // namespace dai


// Parsed from depthai/utility/Pimpl.hpp

// https://herbsutter.com/gotw/_101/

// #pragma once

// #include <memory>

  // namespace dai


// Parsed from depthai/utility/Path.hpp

// #pragma once
// #if(__cplusplus >= 201703L) || (_MSVC_LANG >= 201703L)
//     #define DEPTHAI_NODISCARD [[nodiscard]]
//     #if(defined(_MSC_VER)) || (defined(__has_include) && __has_include(<filesystem>)) || (__cplusplus >= 202002L)
//         #include <filesystem>
//     #endif
// #else
//     #define DEPTHAI_NODISCARD
// #endif
// #include <string>
// Targeting ../Path.java



  // namespace dai


// Parsed from depthai-shared/utility/Serialization.hpp

// #pragma once

// std
// #include <cstddef>
// #include <cstdint>
// #include <vector>

// libraries
// #include <nop/serializer.h>
// #include <nop/structure.h>
// #include <nop/utility/buffer_reader.h>
// #include <nop/utility/stream_writer.h>

// project
// #include "NlohmannJsonCompat.hpp"

// To not require exceptions for embedded usecases.
// #ifndef __has_feature           // Optional of course.
//     #define __has_feature(x) 0  // Compatibility with non-clang compilers.
// #endif
// #if __has_feature(cxx_exceptions) || defined(__cpp_exceptions) || (defined(_MSC_VER) && defined(_CPPUNWIND)) || defined(__EXCEPTIONS)
//     #define DEPTHAI_EXCEPTIONS
// #endif

@Namespace("dai") public enum SerializationType {
    LIBNOP(0),
    JSON(1),
    JSON_MSGPACK(2);

    public final int value;
    private SerializationType(int v) { this.value = v; }
    private SerializationType(SerializationType e) { this.value = e.value; }
    public SerializationType intern() { for (SerializationType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// JSON-msgpack serialization

// JSON serialization
// Targeting ../VectorWriter.java


// NOLINTEND

// libnop serialization
// If exceptions are available it throws in error cases
// Otherwise return value can be checked

// Serialization using enum

// Serialization using templates

// Defaults

  // namespace utility

// // In dai scope
// template<typename Base, typename Derived>
// struct Serializable : Base {
//     virtual void serialize(std::vector<std::uint8_t>& data) {
//         utility::serialize(static_cast<const Derived&>(*this), data);
//     }
// };

  // namespace dai

// #define DEPTHAI_DEFERRED_EXPAND(x) x
// #if defined(_MSC_VER) && (!defined(_MSVC_TRADITIONAL) || _MSVC_TRADITIONAL)
   // Logic using the traditional preprocessor
    // This is for suppressing false positive warnings when compiling
    // without /Zc:preprocessor
//     #pragma warning(disable : 4003)
// #endif

// #define DEPTHAI_NLOHMANN_JSON_OPTIONAL_TO(v1) nlohmann::to_json(nlohmann_json_j[#v1], nlohmann_json_t.v1);
// #define DEPTHAI_NLOHMANN_JSON_OPTIONAL_FROM(v1)
//     if(nlohmann_json_j.contains(#v1)) nlohmann_json_j[#v1].get_to(nlohmann_json_t.v1);
// #define DEPTHAI_NLOHMANN_DEFINE_TYPE_OPTIONAL_NON_INTRUSIVE(Type, ...)
//     inline void to_json(nlohmann::json& nlohmann_json_j, const Type& nlohmann_json_t) {
//         DEPTHAI_NLOHMANN_JSON_EXPAND(DEPTHAI_NLOHMANN_JSON_PASTE(DEPTHAI_NLOHMANN_JSON_OPTIONAL_TO, __VA_ARGS__))
//     }
//     inline void from_json(const nlohmann::json& nlohmann_json_j, Type& nlohmann_json_t) {
//         DEPTHAI_NLOHMANN_JSON_EXPAND(DEPTHAI_NLOHMANN_JSON_PASTE(DEPTHAI_NLOHMANN_JSON_OPTIONAL_FROM, __VA_ARGS__))
//     }
// #define DEPTHAI_NLOHMANN_DEFINE_TYPE_OPTIONAL_INTRUSIVE(Type, ...)
//     friend void to_json(nlohmann::json& nlohmann_json_j, const Type& nlohmann_json_t) {
//         DEPTHAI_NLOHMANN_JSON_EXPAND(DEPTHAI_NLOHMANN_JSON_PASTE(DEPTHAI_NLOHMANN_JSON_OPTIONAL_TO, __VA_ARGS__))
//     }
//     friend void from_json(const nlohmann::json& nlohmann_json_j, Type& nlohmann_json_t) {
//         DEPTHAI_NLOHMANN_JSON_EXPAND(DEPTHAI_NLOHMANN_JSON_PASTE(DEPTHAI_NLOHMANN_JSON_OPTIONAL_FROM, __VA_ARGS__))
//     }

// Macros
// #define DEPTHAI_SERIALIZE_OPTIONAL_EXT(...)
//     DEPTHAI_DEFERRED_EXPAND(DEPTHAI_NLOHMANN_DEFINE_TYPE_OPTIONAL_NON_INTRUSIVE(__VA_ARGS__))
//     DEPTHAI_DEFERRED_EXPAND(NOP_EXTERNAL_STRUCTURE(__VA_ARGS__))

// #define DEPTHAI_SERIALIZE_OPTIONAL(...)
//     DEPTHAI_DEFERRED_EXPAND(DEPTHAI_NLOHMANN_DEFINE_TYPE_OPTIONAL_INTRUSIVE(__VA_ARGS__))
//     DEPTHAI_DEFERRED_EXPAND(NOP_EXTERNAL_STRUCTURE(__VA_ARGS__))

// #define DEPTHAI_SERIALIZE_EXT(...)
//     DEPTHAI_DEFERRED_EXPAND(DEPTHAI_NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(__VA_ARGS__))
//     DEPTHAI_DEFERRED_EXPAND(NOP_EXTERNAL_STRUCTURE(__VA_ARGS__))

// #define DEPTHAI_SERIALIZE(...)
//     DEPTHAI_DEFERRED_EXPAND(DEPTHAI_NLOHMANN_DEFINE_TYPE_INTRUSIVE(__VA_ARGS__))
//     DEPTHAI_DEFERRED_EXPAND(NOP_STRUCTURE(__VA_ARGS__))


// Parsed from depthai-shared/common/CameraBoardSocket.hpp

// #pragma once
// #include <cstdint>
/**
 * Which Camera socket to use.
 *
 * AUTO denotes that the decision will be made by device
 */
@Namespace("dai") public enum CameraBoardSocket {
    AUTO(-1),
    RGB(0),
    LEFT(1),
    RIGHT(2),
    CENTER(RGB.value),
    CAM_A(RGB.value),
    CAM_B(LEFT.value),
    CAM_C(RIGHT.value),
    CAM_D(RIGHT.value + 1),
    CAM_E(RIGHT.value + 2),
    CAM_F(RIGHT.value + 3),
    CAM_G(RIGHT.value + 4),
    CAM_H(RIGHT.value + 5);

    public final int value;
    private CameraBoardSocket(int v) { this.value = v; }
    private CameraBoardSocket(CameraBoardSocket e) { this.value = e.value; }
    public CameraBoardSocket intern() { for (CameraBoardSocket e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai


// Parsed from depthai-shared/common/CameraImageOrientation.hpp

// #pragma once
// #include <cstdint>
/**
 * Camera sensor image orientation / pixel readout.
 * This exposes direct sensor settings. 90 or 270 degrees rotation is not available.
 *
 * AUTO denotes that the decision will be made by device (e.g. on OAK-1/megaAI: ROTATE_180_DEG).
 */
@Namespace("dai") public enum CameraImageOrientation { AUTO(-1), NORMAL(0), HORIZONTAL_MIRROR(1), VERTICAL_FLIP(2), ROTATE_180_DEG(3);

    public final int value;
    private CameraImageOrientation(int v) { this.value = v; }
    private CameraImageOrientation(CameraImageOrientation e) { this.value = e.value; }
    public CameraImageOrientation intern() { for (CameraImageOrientation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai


// Parsed from depthai-shared/common/CameraSensorType.hpp

// #pragma once

// #include <nlohmann/json.hpp>

/** Camera sensor type */
@Namespace("dai") public enum CameraSensorType { AUTO(-1), COLOR(0), MONO(1), TOF(2), THERMAL(3);

    public final int value;
    private CameraSensorType(int v) { this.value = v; }
    private CameraSensorType(CameraSensorType e) { this.value = e.value; }
    public CameraSensorType intern() { for (CameraSensorType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai


// Parsed from depthai-shared/common/CameraFeatures.hpp

// #pragma once

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/CameraImageOrientation.hpp"
// #include "depthai-shared/common/CameraSensorType.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../CameraSensorConfig.java



// Targeting ../CameraFeatures.java



  // namespace dai


// Parsed from depthai-shared/common/ChipTemperature.hpp

// #pragma once

// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../ChipTemperature.java





  // namespace dai

// Parsed from depthai-shared/common/CpuUsage.hpp

// #pragma once

// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../CpuUsage.java





  // namespace dai

// Parsed from depthai-shared/common/DetectionNetworkType.hpp

// #pragma once

// #include <cstdint>

public enum DetectionNetworkType { YOLO(0), MOBILENET(1);

    public final int value;
    private DetectionNetworkType(int v) { this.value = v; }
    private DetectionNetworkType(DetectionNetworkType e) { this.value = e.value; }
    public DetectionNetworkType intern() { for (DetectionNetworkType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}


// Parsed from depthai-shared/common/DetectionParserOptions.hpp

// #pragma once

// #include "depthai-shared/common/DetectionNetworkType.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../DetectionParserOptions.java





  // namespace dai

// Parsed from depthai-shared/common/MemoryInfo.hpp

// #pragma once

// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../MemoryInfo.java





  // namespace dai

// Parsed from depthai-shared/common/Point2f.hpp

// #pragma once

// std
// #include <cstdint>

// project
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../Point2f.java





  // namespace dai


// Parsed from depthai-shared/common/Point3f.hpp

// #pragma once

// std
// #include <cstdint>

// project
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../Point3f.java





  // namespace dai


// Parsed from depthai-shared/common/Size2f.hpp

// #pragma once

// std
// #include <cstdint>

// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../Size2f.java





  // namespace dai


// Parsed from depthai-shared/common/Rect.hpp

// #pragma once

// libraries
// #include <algorithm>

// #include "depthai-shared/common/Point2f.hpp"
// #include "depthai-shared/common/Size2f.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../Rect.java




  // namespace dai


// Parsed from depthai-shared/common/RotatedRect.hpp

// #pragma once

// std
// #include <cstdint>

// shared
// #include "depthai-shared/common/Point2f.hpp"
// #include "depthai-shared/common/Size2f.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../RotatedRect.java





  // namespace dai


// Parsed from depthai-shared/common/Extrinsics.hpp

// #pragma once

// #include <vector>

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/Point3f.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../Extrinsics.java



  // namespace dai

// Parsed from depthai-shared/common/CameraModel.hpp

// #pragma once

// #include <cstdint>
/**
 * Which CameraModel to initialize the calibration with.
 */
@Namespace("dai") public enum CameraModel { Perspective((byte)(0)), Fisheye((byte)(1)), Equirectangular((byte)(2)), RadialDivision((byte)(3));

    public final byte value;
    private CameraModel(byte v) { this.value = v; }
    private CameraModel(CameraModel e) { this.value = e.value; }
    public CameraModel intern() { for (CameraModel e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai

// Parsed from depthai-shared/common/CameraInfo.hpp

// #pragma once

// #include "depthai-shared/common/CameraModel.hpp"
// #include "depthai-shared/common/Extrinsics.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../CameraInfo.java



  // namespace dai

// Parsed from depthai-shared/common/Colormap.hpp

// #pragma once

// #include <nlohmann/json.hpp>

/** Camera sensor type */
@Namespace("dai") public enum Colormap {
    NONE(0),
    TURBO(1),
    JET(2),
    STEREO_TURBO(3),
    STEREO_JET(4);
    // AUTUMN,
    // BONE,
    // JET,
    // WINTER,
    // RAINBOW,
    // OCEAN,
    // SUMMER,
    // SPRING,
    // COOL,
    // HSV,
    // PINK,
    // HOT,
    // PARULA,
    // MAGMA,
    // INFERNO,
    // PLASMA,
    // VIRIDIS,
    // CIVIDIS,
    // TWILIGHT,
    // TWILIGHT_SHIFTED,
    // DEEPGREEN

    public final int value;
    private Colormap(int v) { this.value = v; }
    private Colormap(Colormap e) { this.value = e.value; }
    public Colormap intern() { for (Colormap e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai


// Parsed from depthai-shared/common/FrameEvent.hpp

// #pragma once

// std
// #include <cstdint>

@Namespace("dai") public enum FrameEvent { NONE(0), READOUT_START(1), READOUT_END(2);

    public final int value;
    private FrameEvent(int v) { this.value = v; }
    private FrameEvent(FrameEvent e) { this.value = e.value; }
    public FrameEvent intern() { for (FrameEvent e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai


// Parsed from depthai-shared/common/ProcessorType.hpp

// #pragma once

// #include <cstdint>

/**
 * On which processor the node will be placed
 *
 * Enum specifying processor
 */
@Namespace("dai") public enum ProcessorType { LEON_CSS(0), LEON_MSS(1);

    public final int value;
    private ProcessorType(int v) { this.value = v; }
    private ProcessorType(ProcessorType e) { this.value = e.value; }
    public ProcessorType intern() { for (ProcessorType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai

// Parsed from depthai-shared/common/StereoRectification.hpp

// #pragma once

// #include <vector>

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../StereoRectification.java





  // namespace dai


// Parsed from depthai-shared/common/EepromData.hpp

// #pragma once
// #include <string>
// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/CameraInfo.hpp"
// #include "depthai-shared/common/Extrinsics.hpp"
// #include "depthai-shared/common/Point3f.hpp"
// #include "depthai-shared/common/StereoRectification.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../EepromData.java



@Namespace("dai") public static native void to_json(@Cast("nlohmann::json*") @ByRef Pointer nlohmann_json_j, @Const @ByRef EepromData nlohmann_json_t);
    @Namespace("dai") public static native void from_json(@Cast("const nlohmann::json*") @ByRef Pointer nlohmann_json_j, @ByRef EepromData nlohmann_json_t);
    

  // namespace dai


// Parsed from depthai-shared/common/TensorInfo.hpp

// #pragma once

// std
// #include <cstdint>

// project
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../TensorInfo.java





  // namespace dai

// Parsed from depthai-shared/common/Timestamp.hpp

// #pragma once

// std
// #include <chrono>
// #include <cstdint>

// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../Timestamp.java





  // namespace dai


// Parsed from depthai-shared/common/UsbSpeed.hpp

// #pragma once

// std
// #include <cstdint>

/**
 * Get USB Speed
 */

@Namespace("dai") public enum UsbSpeed { UNKNOWN(0), LOW(1), FULL(2), HIGH(3), SUPER(4), SUPER_PLUS(5);

    public final int value;
    private UsbSpeed(int v) { this.value = v; }
    private UsbSpeed(UsbSpeed e) { this.value = e.value; }
    public UsbSpeed intern() { for (UsbSpeed e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai


// Parsed from depthai-shared/datatype/DatatypeEnum.hpp

// #pragma once

// #include <cstdint>

@Namespace("dai") public enum DatatypeEnum {
    Buffer(0),
    ImgFrame(1),
    NNData(2),
    ImageManipConfig(3),
    CameraControl(4),
    ImgDetections(5),
    SpatialImgDetections(6),
    SystemInformation(7),
    SpatialLocationCalculatorConfig(8),
    SpatialLocationCalculatorData(9),
    EdgeDetectorConfig(10),
    AprilTagConfig(11),
    AprilTags(12),
    Tracklets(13),
    IMUData(14),
    StereoDepthConfig(15),
    FeatureTrackerConfig(16),
    TrackedFeatures(17);

    public final int value;
    private DatatypeEnum(int v) { this.value = v; }
    private DatatypeEnum(DatatypeEnum e) { this.value = e.value; }
    public DatatypeEnum intern() { for (DatatypeEnum e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
@Namespace("dai") public static native @Cast("bool") boolean isDatatypeSubclassOf(DatatypeEnum parent, DatatypeEnum children);
@Namespace("dai") public static native @Cast("bool") boolean isDatatypeSubclassOf(@Cast("dai::DatatypeEnum") int parent, @Cast("dai::DatatypeEnum") int children);

  // namespace dai


// Parsed from depthai-shared/datatype/RawBuffer.hpp

// #pragma once
// #include <cstdint>
// #include <vector>

// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../RawBuffer.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawAprilTagConfig.hpp

// #pragma once

// #include <cstdint>
// #include <vector>

// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../RawAprilTagConfig.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawAprilTags.hpp

// #pragma once
// #include <cstdint>
// #include <vector>

// #include "depthai-shared/common/Point2f.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawAprilTagConfig.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../AprilTag.java



// Targeting ../RawAprilTags.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawIMUData.hpp

// #pragma once

// #include "depthai-shared/common/Point3f.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../IMUReport.java



// Targeting ../IMUReportAccelerometer.java



// Targeting ../IMUReportGyroscope.java



// Targeting ../IMUReportMagneticField.java



// Targeting ../IMUReportRotationVectorWAcc.java



// Targeting ../IMUPacket.java




// Targeting ../RawIMUData.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawCameraControl.hpp

// #pragma once
// #include <cstdint>
// #include <vector>

// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../RawCameraControl.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawEdgeDetectorConfig.hpp

// #pragma once
// #include <cstdint>
// #include <vector>

// #include "RawImgFrame.hpp"
// #include "depthai-shared/common/Rect.hpp"
// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../EdgeDetectorConfigData.java



// Targeting ../RawEdgeDetectorConfig.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawImgFrame.hpp

// #pragma once

// #include <unordered_map>

// #include "depthai-shared/common/FrameEvent.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../RawImgFrame.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawImgDetections.hpp

// #pragma once

// #include "depthai-shared/common/Point3f.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../ImgDetection.java




// Targeting ../RawImgDetections.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawImageManipConfig.hpp

// #pragma once
// #include <cstdint>
// #include <vector>

// #include "RawImgFrame.hpp"
// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"

// shared
// #include "depthai-shared/common/Colormap.hpp"
// #include "depthai-shared/common/Point2f.hpp"
// #include "depthai-shared/common/RotatedRect.hpp"
// #include "depthai-shared/common/Size2f.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../RawImageManipConfig.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawNNData.hpp

// #pragma once

// #include "depthai-shared/common/TensorInfo.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../RawNNData.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawSpatialImgDetections.hpp

// #pragma once

// #include "RawImgDetections.hpp"
// #include "depthai-shared/common/Point3f.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/datatype/RawSpatialLocationCalculatorConfig.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../SpatialImgDetection.java




// Targeting ../RawSpatialImgDetections.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawSpatialLocationCalculatorConfig.hpp

// #pragma once
// #include <cstdint>
// #include <vector>

// #include "RawImgFrame.hpp"
// #include "depthai-shared/common/Rect.hpp"
// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../SpatialLocationCalculatorConfigThresholds.java




/**
 * SpatialLocationCalculatorAlgorithm configuration modes
 *
 * Contains calculation method used to obtain spatial locations.
 */
@Namespace("dai") public enum SpatialLocationCalculatorAlgorithm { AVERAGE(0), MEAN(AVERAGE.value), MIN(AVERAGE.value + 1), MAX(AVERAGE.value + 2), MODE(AVERAGE.value + 3), MEDIAN(AVERAGE.value + 4);

    public final int value;
    private SpatialLocationCalculatorAlgorithm(int v) { this.value = v; }
    private SpatialLocationCalculatorAlgorithm(SpatialLocationCalculatorAlgorithm e) { this.value = e.value; }
    public SpatialLocationCalculatorAlgorithm intern() { for (SpatialLocationCalculatorAlgorithm e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../SpatialLocationCalculatorConfigData.java



// Targeting ../RawSpatialLocationCalculatorConfig.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawSpatialLocations.hpp

// #pragma once
// #include <cstdint>
// #include <vector>

// #include "RawSpatialLocationCalculatorConfig.hpp"
// #include "depthai-shared/common/Point3f.hpp"
// #include "depthai-shared/common/Rect.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../SpatialLocations.java



// Targeting ../RawSpatialLocations.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawStereoDepthConfig.hpp

// #pragma once
// #include <cstdint>
// #include <depthai-shared/common/optional.hpp>
// #include <vector>

// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"

/**
 * Median filter config for disparity post-processing
 */
@Namespace("dai") public enum MedianFilter { MEDIAN_OFF(0), KERNEL_3x3(3), KERNEL_5x5(5), KERNEL_7x7(7);

    public final int value;
    private MedianFilter(int v) { this.value = v; }
    private MedianFilter(MedianFilter e) { this.value = e.value; }
    public MedianFilter intern() { for (MedianFilter e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../RawStereoDepthConfig.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawSystemInformation.hpp

// #pragma once
// #include <cstdint>
// #include <vector>

// #include "depthai-shared/common/ChipTemperature.hpp"
// #include "depthai-shared/common/CpuUsage.hpp"
// #include "depthai-shared/common/MemoryInfo.hpp"
// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../RawSystemInformation.java



  // namespace dai


// Parsed from depthai-shared/datatype/RawTracklets.hpp

// #pragma once

// #include <iostream>

// #include "depthai-shared/common/Point3f.hpp"
// #include "depthai-shared/common/Rect.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/datatype/RawImgDetections.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../Tracklet.java


// Targeting ../RawTracklets.java



  // namespace dai


// Parsed from depthai-shared/device/BoardConfig.hpp

// #pragma once

// std
// #include <cstdint>
// #include <unordered_map>

// project
// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/CameraImageOrientation.hpp"
// #include "depthai-shared/common/CameraSensorType.hpp"
// #include "depthai-shared/common/UsbSpeed.hpp"
// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/log/LogLevel.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// #include "depthai-shared/xlink/XLinkConstants.hpp"

@Namespace("dai") @MemberGetter public static native @Cast("const uint32_t") int BOARD_CONFIG_MAGIC1();
public static final int BOARD_CONFIG_MAGIC1 = BOARD_CONFIG_MAGIC1();
@Namespace("dai") @MemberGetter public static native @Cast("const uint32_t") int BOARD_CONFIG_MAGIC2();
public static final int BOARD_CONFIG_MAGIC2 = BOARD_CONFIG_MAGIC2();
// Targeting ../BoardConfig.java











  // namespace dai


// Parsed from depthai-shared/device/CrashDump.hpp

// #pragma once

// std
// #include <cstdint>
// #include <unordered_map>

// project
// #include "depthai-shared/common/ProcessorType.hpp"
// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../CrashDump.java





  // namespace dai


// Parsed from depthai-shared/log/LogLevel.hpp

// #pragma once

// std
// #include <cstdint>

// project
// #include "depthai-shared/utility/Serialization.hpp"

// Follows spdlog levels
@Namespace("dai") public enum LogLevel { TRACE(0), DEBUG(1), INFO(2), WARN(3), ERR(4), CRITICAL(5), OFF(6);

    public final int value;
    private LogLevel(int v) { this.value = v; }
    private LogLevel(LogLevel e) { this.value = e.value; }
    public LogLevel intern() { for (LogLevel e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai


// Parsed from depthai-shared/log/LogMessage.hpp

// #pragma once

// std
// #include <cstdint>

// project
// #include "LogLevel.hpp"
// #include "depthai-shared/common/Timestamp.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../LogMessage.java





  // namespace dai


// Parsed from depthai-shared/xlink/XLinkConstants.hpp

// #pragma once

// #include <chrono>
// #include <cstdint>

// channel names
@Namespace("dai::device") @MemberGetter public static native @Cast("const char*") BytePointer XLINK_CHANNEL_PIPELINE_CONFIG();
@Namespace("dai::device") @MemberGetter public static native @Cast("const char*") BytePointer XLINK_CHANNEL_MAIN_RPC();
@Namespace("dai::device") @MemberGetter public static native @Cast("const char*") BytePointer XLINK_CHANNEL_TIMESYNC();
@Namespace("dai::device") @MemberGetter public static native @Cast("const char*") BytePointer XLINK_CHANNEL_LOG();
@Namespace("dai::device") @MemberGetter public static native @Cast("const char*") BytePointer XLINK_CHANNEL_WATCHDOG();

// usb buffer maximum size
@Namespace("dai::device") @MemberGetter public static native @Cast("const std::uint32_t") int XLINK_USB_BUFFER_MAX_SIZE();
public static final int XLINK_USB_BUFFER_MAX_SIZE = XLINK_USB_BUFFER_MAX_SIZE();

// Watchdog timeout
@Namespace("dai::device") @MemberGetter public static native @ByRef @Cast("const std::chrono::milliseconds*") Pointer XLINK_USB_WATCHDOG_TIMEOUT();
@Namespace("dai::device") @MemberGetter public static native @ByRef @Cast("const std::chrono::milliseconds*") Pointer XLINK_TCP_WATCHDOG_TIMEOUT();

// Maximum metadata size
@Namespace("dai::device") @MemberGetter public static native int XLINK_MESSAGE_METADATA_MAX_SIZE();
public static final int XLINK_MESSAGE_METADATA_MAX_SIZE = XLINK_MESSAGE_METADATA_MAX_SIZE();

  // namespace device
  // namespace dai


// Parsed from depthai-shared/properties/Properties.hpp

// #pragma once

// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../DaiProperties.java


// Targeting ../IMUPropertiesSerializable.java


// Targeting ../AprilTagPropertiesSerializable.java


// Targeting ../ColorCameraPropertiesSerializable.java


// Targeting ../MonoCameraPropertiesSerializable.java


// Targeting ../ImageManipPropertiesSerializable.java


// Targeting ../EdgeDetectorPropertiesSerializable.java


// Targeting ../GlobalPropertiesSerializable.java


// Targeting ../NeuralNetworkPropertiesSerializable.java


// Targeting ../DetectionNetworkPropertiesSerializable.java


// Targeting ../DetectionParserPropertiesSerializable.java


// Targeting ../ObjectTrackerPropertiesSerializable.java


// Targeting ../SPIOutPropertiesSerializable.java


// Targeting ../SpatialDetectionNetworkPropertiesSerializable.java


// Targeting ../SpatialLocationCalculatorPropertiesSerializable.java


// Targeting ../StereoDepthPropertiesSerializable.java


// Targeting ../SystemLoggerPropertiesSerializable.java


// Targeting ../VideoEncoderPropertiesSerializable.java


// Targeting ../WarpPropertiesSerializable.java


// Targeting ../XLinkInPropertiesSerializable.java


// Targeting ../XLinkOutPropertiesSerializable.java



  // namespace dai

// Parsed from depthai-shared/properties/AprilTagProperties.hpp

// #pragma once

// #include <depthai-shared/datatype/RawAprilTagConfig.hpp>
// #include <vector>

// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../AprilTagProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/IMUProperties.hpp

// #pragma once

// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/datatype/RawIMUData.hpp"
// #include "depthai-shared/properties/Properties.hpp"

/**
 * Available IMU sensors.
 * More details about each sensor can be found in the datasheet:
 *
 * https://www.ceva-dsp.com/wp-content/uploads/2019/10/BNO080_085-Datasheet.pdf
 */
@Namespace("dai") public enum IMUSensor {
    /**
     * Section 2.1.1
     *
     * Acceleration of the device without any postprocessing, straight from the sensor.
     * Units are [m/s^2]
     */
    ACCELEROMETER_RAW(0x14),
    /**
     * Section 2.1.1
     *
     * Acceleration of the device including gravity.
     * Units are [m/s^2]
     */
    ACCELEROMETER(0x01),
    /**
     * Section 2.1.1
     *
     * Acceleration of the device with gravity removed.
     * Units are [m/s^2]
     */
    LINEAR_ACCELERATION(0x04),
    /**
     * Section 2.1.1
     *
     * Gravity.
     * Units are [m/s^2]
     */
    GRAVITY(0x06),
    /**
     * Section 2.1.2
     *
     * The angular velocity of the device without any postprocessing, straight from the sensor.
     * Units are [rad/s]
     */
    GYROSCOPE_RAW(0x15),
    /**
     * Section 2.1.2
     *
     * The angular velocity of the device.
     * Units are [rad/s]
     */
    GYROSCOPE_CALIBRATED(0x02),
    /**
     * Section 2.1.2
     *
     * Angular velocity without bias compensation.
     * Units are [rad/s]
     */
    GYROSCOPE_UNCALIBRATED(0x07),
    /**
     * Section 2.1.3
     *
     * Magnetic field measurement without any postprocessing, straight from the sensor.
     * Units are [uTesla]
     */
    MAGNETOMETER_RAW(0x16),
    /**
     * Section 2.1.3
     *
     * The fully calibrated magnetic field measurement.
     * Units are [uTesla]
     */
    MAGNETOMETER_CALIBRATED(0x03),
    /**
     * Section 2.1.3
     *
     * The magnetic field measurement without hard-iron offset applied.
     * Units are [uTesla]
     */
    MAGNETOMETER_UNCALIBRATED(0x0f),
    /**
     * Section 2.2
     *
     * The rotation vector provides an orientation output that is expressed as a quaternion referenced to magnetic north
     * and gravity. It is produced by fusing the outputs of the accelerometer, gyroscope and magnetometer. The rotation
     * vector is the most accurate orientation estimate available. The magnetometer provides correction in yaw to
     * reduce drift and the gyroscope enables the most responsive performance.
     */
    ROTATION_VECTOR(0x05),
    /**
     * Section 2.2
     *
     * The game rotation vector is an orientation output that is expressed as a quaternion with no specific reference for
     * heading, while roll and pitch are referenced against gravity. It is produced by fusing the outputs of the
     * accelerometer and the gyroscope (i.e. no magnetometer). The game rotation vector does not use the
     * magnetometer to correct the gyroscopes drift in yaw. This is a deliberate omission (as specified by Google) to
     * allow gaming applications to use a smoother representation of the orientation without the jumps that an
     * instantaneous correction provided by a magnetic field update could provide. Long term the output will likely drift in
     * yaw due to the characteristics of gyroscopes, but this is seen as preferable for this output versus a corrected output.
     */
    GAME_ROTATION_VECTOR(0x08),
    /**
     * Section 2.2
     *
     * The geomagnetic rotation vector is an orientation output that is expressed as a quaternion referenced to magnetic
     * north and gravity. It is produced by fusing the outputs of the accelerometer and magnetometer. The gyroscope is
     * specifically excluded in order to produce a rotation vector output using less power than is required to produce the
     * rotation vector of section 2.2.4. The consequences of removing the gyroscope are:
     * Less responsive output since the highly dynamic outputs of the gyroscope are not used
     * More errors in the presence of varying magnetic fields.
     */
    GEOMAGNETIC_ROTATION_VECTOR(0x09),
    /**
     * Section 2.2
     *
     * Estimates of the magnetic field and the roll/pitch of the device can create a potential correction in the rotation
     * vector produced. For applications (typically augmented or virtual reality applications) where a sudden jump can be
     * disturbing, the output is adjusted to prevent these jumps in a manner that takes account of the velocity of the
     * sensor system.
     */
    ARVR_STABILIZED_ROTATION_VECTOR(0x28),
    /**
     * Section 2.2
     *
     * While the magnetometer is removed from the calculation of the game rotation vector, the accelerometer itself can
     * create a potential correction in the rotation vector produced (i.e. the estimate of gravity changes). For applications
     * (typically augmented or virtual reality applications) where a sudden jump can be disturbing, the output is adjusted
     * to prevent these jumps in a manner that takes account of the velocity of the sensor system. This process is called
     * AR/VR stabilization.
     */
    ARVR_STABILIZED_GAME_ROTATION_VECTOR(0x29);
    // GYRO_INTEGRATED_ROTATION_VECTOR = 0x2A,

    public final int value;
    private IMUSensor(int v) { this.value = v; }
    private IMUSensor(IMUSensor e) { this.value = e.value; }
    public IMUSensor intern() { for (IMUSensor e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../IMUSensorConfig.java



// Targeting ../IMUProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/GlobalProperties.hpp

// #pragma once

// #include "depthai-shared/common/EepromData.hpp"
// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../GlobalProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/ColorCameraProperties.hpp

// #pragma once

// #include <vector>

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/CameraImageOrientation.hpp"
// #include "depthai-shared/common/FrameEvent.hpp"
// #include "depthai-shared/datatype/RawCameraControl.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../ColorCameraProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/ImageManipProperties.hpp

// #pragma once

// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/datatype/RawImageManipConfig.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../ImageManipProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/MonoCameraProperties.hpp

// #pragma once

// #include <vector>

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/CameraImageOrientation.hpp"
// #include "depthai-shared/common/FrameEvent.hpp"
// #include "depthai-shared/datatype/RawCameraControl.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../MonoCameraProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/EdgeDetectorProperties.hpp

// #pragma once

// #include <vector>

// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/datatype/RawEdgeDetectorConfig.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../EdgeDetectorProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/NeuralNetworkProperties.hpp

// #pragma once

// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../NeuralNetworkProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/DetectionNetworkProperties.hpp

// #pragma once

// std
// #include <vector>

// project
// #include "NeuralNetworkProperties.hpp"
// #include "depthai-shared/common/DetectionParserOptions.hpp"
// #include "depthai-shared/common/optional.hpp"
// Targeting ../DetectionNetworkProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/DetectionParserProperties.hpp

// #pragma once

// #include <vector>

// #include "depthai-shared/common/DetectionParserOptions.hpp"
// #include "depthai-shared/common/TensorInfo.hpp"
// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/datatype/RawEdgeDetectorConfig.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../DetectionParserProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/ObjectTrackerProperties.hpp

// #pragma once

// std
// #include <vector>

// project
// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/properties/Properties.hpp"

@Namespace("dai") public enum TrackerType {
    /** Kernelized Correlation Filter tracking */
    SHORT_TERM_KCF(1),
    /** Short term tracking without using image data */
    SHORT_TERM_IMAGELESS(3),
    /** Ability to track the objects without accessing image data. */
    ZERO_TERM_IMAGELESS(5),
    /** Tracking using image data too. */
    ZERO_TERM_COLOR_HISTOGRAM(6);

    public final int value;
    private TrackerType(int v) { this.value = v; }
    private TrackerType(TrackerType e) { this.value = e.value; }
    public TrackerType intern() { for (TrackerType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

@Namespace("dai") public enum TrackerIdAssignmentPolicy {
    /** Always take a new, unique ID */
    UNIQUE_ID(0),
    /** Take the smallest available ID */
    SMALLEST_ID(1);

    public final int value;
    private TrackerIdAssignmentPolicy(int v) { this.value = v; }
    private TrackerIdAssignmentPolicy(TrackerIdAssignmentPolicy e) { this.value = e.value; }
    public TrackerIdAssignmentPolicy intern() { for (TrackerIdAssignmentPolicy e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../ObjectTrackerProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/SPIOutProperties.hpp

// #pragma once

// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../SPIOutProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/SpatialDetectionNetworkProperties.hpp

// #pragma once

// std
// #include <vector>

// libraries

// project
// #include "DetectionNetworkProperties.hpp"
// #include "depthai-shared/common/DetectionNetworkType.hpp"
// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/datatype/RawSpatialLocationCalculatorConfig.hpp"
// Targeting ../SpatialDetectionNetworkProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/SpatialLocationCalculatorProperties.hpp

// #pragma once

// #include <vector>

// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/datatype/RawSpatialLocationCalculatorConfig.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../SpatialLocationCalculatorProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/StereoDepthProperties.hpp

// #pragma once

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/EepromData.hpp"
// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/datatype/RawStereoDepthConfig.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../StereoDepthProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/SystemLoggerProperties.hpp

// #pragma once

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/CameraImageOrientation.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../SystemLoggerProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/VideoEncoderProperties.hpp

// #pragma once

// #include <depthai-shared/common/optional.hpp>

// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../VideoEncoderProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/WarpProperties.hpp

// #pragma once

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/EepromData.hpp"
// #include "depthai-shared/common/optional.hpp"
// #include "depthai-shared/datatype/RawStereoDepthConfig.hpp"
// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../WarpProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/XLinkInProperties.hpp

// #pragma once

// #include "depthai-shared/properties/Properties.hpp"
// #include "depthai-shared/xlink/XLinkConstants.hpp"
// Targeting ../XLinkInProperties.java





  // namespace dai


// Parsed from depthai-shared/properties/XLinkOutProperties.hpp

// #pragma once

// #include "depthai-shared/properties/Properties.hpp"
// Targeting ../XLinkOutProperties.java





  // namespace dai


// Parsed from depthai-shared/pipeline/Assets.hpp

// #pragma once

// standard
// #include <cstdint>
// #include <exception>
// #include <unordered_map>

// project
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../AssetView.java


// Targeting ../Assets.java



  // namespace dai


// Parsed from depthai-shared/pipeline/NodeConnectionSchema.hpp

// #pragma once

// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../NodeConnectionSchema.java





  // namespace dai


// Parsed from depthai-shared/pipeline/NodeIoInfo.hpp

// #pragma once

// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../NodeIoInfo.java





  // namespace dai


// Parsed from depthai-shared/pipeline/NodeObjInfo.hpp

// #pragma once

// #include <tuple>

// #include "NodeIoInfo.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../NodeObjInfo.java





  // namespace dai


// Parsed from depthai-shared/pipeline/PipelineSchema.hpp

// #pragma once

// #include "NodeConnectionSchema.hpp"
// #include "NodeObjInfo.hpp"
// #include "depthai-shared/properties/GlobalProperties.hpp"
// #include "depthai-shared/utility/Serialization.hpp"
// Targeting ../PipelineSchema.java





  // namespace dai


// Parsed from depthai/openvino/OpenVINO.hpp

// #pragma once

// #include <algorithm>
// #include <exception>
// #include <map>
// #include <string>
// #include <unordered_map>
// #include <utility>
// #include <vector>

// #include "depthai-shared/common/TensorInfo.hpp"
// #include "depthai/utility/Path.hpp"
// Targeting ../OpenVINO.java



  // namespace dai


// Parsed from depthai/common/UsbSpeed.hpp

// #pragma once

// #include <ostream>

// #include "depthai-shared/common/UsbSpeed.hpp"

// Global namespace
public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, UsbSpeed speed);
public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, @Cast("dai::UsbSpeed") int speed);


// Parsed from depthai/common/CameraBoardSocket.hpp

// #pragma once

// #include <ostream>

// #include "depthai-shared/common/CameraBoardSocket.hpp"

// Global namespace
public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, CameraBoardSocket socket);


// Parsed from depthai/common/CameraExposureOffset.hpp

// #pragma once

// std
// #include <cstdint>

/**
 * Describe possible exposure offsets
 */
@Namespace("dai") public enum CameraExposureOffset { START(0), MIDDLE(1), END(2);

    public final int value;
    private CameraExposureOffset(int v) { this.value = v; }
    private CameraExposureOffset(CameraExposureOffset e) { this.value = e.value; }
    public CameraExposureOffset intern() { for (CameraExposureOffset e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

  // namespace dai


// Parsed from depthai/common/CameraFeatures.hpp

// #pragma once

// #include <ostream>
// #include <vector>

// #include "depthai-shared/common/CameraFeatures.hpp"
// #include "depthai/common/CameraBoardSocket.hpp"
// #include "depthai/common/CameraImageOrientation.hpp"
// #include "depthai/common/CameraSensorType.hpp"

// Global namespace
public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, @Const @ByRef CameraFeatures camera);

// Parsed from depthai/pipeline/datatype/ADatatype.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawBuffer.hpp"
// Targeting ../ADatatype.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/AprilTagConfig.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawAprilTagConfig.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../AprilTagConfig.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/AprilTags.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawAprilTags.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../AprilTags.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/Buffer.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai/pipeline/datatype/ADatatype.hpp"
// Targeting ../Buffer.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/IMUData.hpp

// #pragma once

// #include <chrono>
// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawIMUData.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../IMUData.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/CameraControl.hpp

// #pragma once

// #include <chrono>
// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawCameraControl.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../CameraControl.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/EdgeDetectorConfig.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawEdgeDetectorConfig.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../EdgeDetectorConfig.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/ImgFrame.hpp

// #pragma once

// #include <chrono>
// #include <unordered_map>
// #include <vector>

// project
// #include "depthai/build/config.hpp"
// #include "depthai/common/CameraExposureOffset.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"

// shared
// #include "depthai-shared/datatype/RawImgFrame.hpp"

// optional
// #ifdef DEPTHAI_HAVE_OPENCV_SUPPORT
//     #include <opencv2/opencv.hpp>
// #endif
// Targeting ../ImgFrame.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/ImgDetections.hpp

// #pragma once

// #include <chrono>
// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawImgDetections.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../ImgDetections.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/ImageManipConfig.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawImageManipConfig.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// #include "depthai/pipeline/datatype/ImgFrame.hpp"
// Targeting ../ImageManipConfig.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/NNData.hpp

// #pragma once

// #include <chrono>
// #include <limits>
// #include <unordered_map>
// #include <vector>

// #include "Buffer.hpp"
// #include "depthai-shared/datatype/RawNNData.hpp"
// Targeting ../NNData.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/SpatialImgDetections.hpp

// #pragma once

// #include <chrono>
// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawSpatialImgDetections.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../SpatialImgDetections.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/SpatialLocationCalculatorData.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawSpatialLocations.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../SpatialLocationCalculatorData.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/SpatialLocationCalculatorConfig.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawSpatialLocationCalculatorConfig.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../SpatialLocationCalculatorConfig.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/StereoDepthConfig.hpp

// #pragma once

// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawStereoDepthConfig.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../StereoDepthConfig.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/SystemInformation.hpp

// #pragma once

// #include <chrono>
// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawSystemInformation.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../SystemInformation.java



  // namespace dai


// Parsed from depthai/pipeline/datatype/Tracklets.hpp

// #pragma once

// #include <ostream>
// #include <unordered_map>
// #include <vector>

// #include "depthai-shared/datatype/RawTracklets.hpp"
// #include "depthai/pipeline/datatype/Buffer.hpp"
// Targeting ../Tracklets.java



  // namespace dai

// Global namespace
public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, Tracklet.TrackingStatus status);

// Parsed from depthai/pipeline/AssetManager.hpp

// #pragma once

// #include <map>
// #include <memory>
// #include <vector>

// #include "depthai-shared/pipeline/Assets.hpp"
// #include "depthai/utility/Path.hpp"
// Targeting ../Asset.java


// Targeting ../AssetsMutable.java


// Targeting ../AssetManager.java



  // namespace dai


// Parsed from depthai/pipeline/Node.hpp

// #pragma once

// #include <algorithm>
// #include <memory>
// #include <set>
// #include <string>
// #include <tuple>

// project
// #include "depthai/openvino/OpenVINO.hpp"
// #include "depthai/pipeline/AssetManager.hpp"
// #include "depthai/utility/copyable_unique_ptr.hpp"

// depthai-shared
// #include "depthai-shared/datatype/DatatypeEnum.hpp"
// #include "depthai-shared/properties/Properties.hpp"

// libraries
// #include "tl/optional.hpp"
// fwd declare Pipeline
// Targeting ../Node.java


// Targeting ../IMUPropertiesNode.java


// Targeting ../AprilTagPropertiesNode.java


// Targeting ../ColorCameraPropertiesNode.java


// Targeting ../ImageManipPropertiesNode.java


// Targeting ../EdgeDetectorPropertiesNode.java


// Targeting ../NeuralNetworkPropertiesNode.java


// Targeting ../DetectionNetworkPropertiesNode.java


// Targeting ../MobileNetDetectionNetworkPropertiesNode.java


// Targeting ../YoloDetectionNetworkPropertiesNode.java


// Targeting ../ObjectTrackerPropertiesNode.java


// Targeting ../SPIOutPropertiesNode.java


// Targeting ../SpatialDetectionNetworkPropertiesNode.java


// Targeting ../MobileNetSpatialDetectionNetworkPropertiesNode.java


// Targeting ../YoloSpatialDetectionNetworkPropertiesNode.java


// Targeting ../DetectionParserPropertiesNode.java


// Targeting ../SpatialLocationCalculatorPropertiesNode.java


// Targeting ../StereoDepthPropertiesNode.java


// Targeting ../SystemLoggerPropertiesNode.java


// Targeting ../VideoEncoderPropertiesNode.java


// Targeting ../WarpPropertiesNode.java


// Targeting ../XLinkInPropertiesNode.java


// Targeting ../XLinkOutPropertiesNode.java




// Targeting ../ConnectionHash.java



  // namespace std


// Parsed from depthai/pipeline/Pipeline.hpp

// #pragma once

// standard
// #include <map>
// #include <memory>
// #include <unordered_set>
// #include <vector>

// project
// #include "AssetManager.hpp"
// #include "Node.hpp"
// #include "depthai/device/CalibrationHandler.hpp"
// #include "depthai/device/Device.hpp"
// #include "depthai/openvino/OpenVINO.hpp"

// shared
// #include "depthai-shared/device/BoardConfig.hpp"
// #include "depthai-shared/pipeline/PipelineSchema.hpp"
// #include "depthai-shared/properties/GlobalProperties.hpp"
// Targeting ../PipelineImpl.java


// Targeting ../Pipeline.java



  // namespace dai


// Parsed from depthai/pipeline/nodes.hpp

// #pragma once

// all the nodes
// #include "node/AprilTag.hpp"
// #include "node/ColorCamera.hpp"
// #include "node/DetectionNetwork.hpp"
// #include "node/DetectionParser.hpp"
// #include "node/EdgeDetector.hpp"
// #include "node/FeatureTracker.hpp"
// #include "node/IMU.hpp"
// #include "node/ImageManip.hpp"
// #include "node/MonoCamera.hpp"
// #include "node/NeuralNetwork.hpp"
// #include "node/ObjectTracker.hpp"
// #include "node/SPIIn.hpp"
// #include "node/SPIOut.hpp"
// #include "node/Script.hpp"
// #include "node/SpatialDetectionNetwork.hpp"
// #include "node/SpatialLocationCalculator.hpp"
// #include "node/StereoDepth.hpp"
// #include "node/SystemLogger.hpp"
// #include "node/VideoEncoder.hpp"
// #include "node/Warp.hpp"
// #include "node/XLinkIn.hpp"
// #include "node/XLinkOut.hpp"

// Parsed from depthai/pipeline/datatypes.hpp

// #pragma once

// all the data types
// #include "datatype/ADatatype.hpp"
// #include "datatype/AprilTagConfig.hpp"
// #include "datatype/AprilTags.hpp"
// #include "datatype/Buffer.hpp"
// #include "datatype/CameraControl.hpp"
// #include "datatype/EdgeDetectorConfig.hpp"
// #include "datatype/FeatureTrackerConfig.hpp"
// #include "datatype/IMUData.hpp"
// #include "datatype/ImageManipConfig.hpp"
// #include "datatype/ImgDetections.hpp"
// #include "datatype/ImgFrame.hpp"
// #include "datatype/NNData.hpp"
// #include "datatype/SpatialImgDetections.hpp"
// #include "datatype/SpatialLocationCalculatorConfig.hpp"
// #include "datatype/SpatialLocationCalculatorData.hpp"
// #include "datatype/StereoDepthConfig.hpp"
// #include "datatype/SystemInformation.hpp"
// #include "datatype/TrackedFeatures.hpp"
// #include "datatype/Tracklets.hpp"


// Parsed from depthai/pipeline/node/IMU.hpp

// #pragma once

// #include "depthai/pipeline/Node.hpp"

// shared
// #include <depthai-shared/properties/IMUProperties.hpp>
// Targeting ../IMU.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/AprilTag.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// shared
// #include <depthai-shared/properties/AprilTagProperties.hpp>

// #include "depthai/pipeline/datatype/AprilTagConfig.hpp"
// Targeting ../AprilTagNode.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/ColorCamera.hpp

// #pragma once

// #include <depthai/pipeline/datatype/CameraControl.hpp>

// #include "depthai/pipeline/Node.hpp"

// shared
// #include <depthai-shared/properties/ColorCameraProperties.hpp>
// Targeting ../ColorCamera.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/ImageManip.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>
// #include <depthai/pipeline/datatype/ImageManipConfig.hpp>

// shared
// #include <depthai-shared/properties/ImageManipProperties.hpp>
// Targeting ../ImageManip.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/MonoCamera.hpp

// #pragma once

// #include <depthai/pipeline/datatype/CameraControl.hpp>

// #include "depthai/common/CameraBoardSocket.hpp"
// #include "depthai/pipeline/Node.hpp"

// shared
// #include <depthai-shared/properties/MonoCameraProperties.hpp>
// Targeting ../MonoCamera.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/EdgeDetector.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// standard
// #include <fstream>

// shared
// #include <depthai-shared/properties/EdgeDetectorProperties.hpp>

// #include "depthai/pipeline/datatype/EdgeDetectorConfig.hpp"
// Targeting ../EdgeDetector.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/NeuralNetwork.hpp

// #pragma once

// #include "depthai/openvino/OpenVINO.hpp"
// #include "depthai/pipeline/Node.hpp"

// standard
// #include <fstream>

// shared
// #include <depthai-shared/properties/NeuralNetworkProperties.hpp>
// Targeting ../NeuralNetwork.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/DetectionNetwork.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>
// #include <depthai/pipeline/node/NeuralNetwork.hpp>

// #include "depthai/openvino/OpenVINO.hpp"

// standard
// #include <fstream>

// shared
// #include <depthai-shared/properties/DetectionNetworkProperties.hpp>
// Targeting ../DetectionNetwork.java


// Targeting ../MobileNetDetectionNetwork.java


// Targeting ../YoloDetectionNetwork.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/DetectionParser.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// standard
// #include <fstream>

// shared
// #include <depthai-shared/properties/DetectionParserProperties.hpp>
// Targeting ../DetectionParser.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/ObjectTracker.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// #include "depthai/pipeline/datatype/Tracklets.hpp"

// standard
// #include <fstream>

// shared
// #include <depthai-shared/properties/ObjectTrackerProperties.hpp>
// Targeting ../ObjectTracker.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/SPIOut.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// shared
// #include <depthai-shared/properties/SPIOutProperties.hpp>
// Targeting ../SPIOut.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/SpatialDetectionNetwork.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>
// #include <depthai/pipeline/node/DetectionNetwork.hpp>

// #include "depthai/openvino/OpenVINO.hpp"

// standard
// #include <fstream>

// shared
// #include <depthai-shared/properties/SpatialDetectionNetworkProperties.hpp>
// Targeting ../SpatialDetectionNetwork.java


// Targeting ../MobileNetSpatialDetectionNetwork.java


// Targeting ../YoloSpatialDetectionNetwork.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/SpatialLocationCalculator.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// standard
// #include <fstream>

// shared
// #include <depthai-shared/properties/SpatialLocationCalculatorProperties.hpp>

// #include "depthai/pipeline/datatype/SpatialLocationCalculatorConfig.hpp"
// Targeting ../SpatialLocationCalculator.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/StereoDepth.hpp

// #pragma once

// #include "depthai/pipeline/Node.hpp"

// shared
// #include "depthai-shared/properties/StereoDepthProperties.hpp"
// #include "depthai/pipeline/datatype/StereoDepthConfig.hpp"
// Targeting ../StereoDepth.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/SystemLogger.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// shared
// #include <depthai-shared/properties/SystemLoggerProperties.hpp>
// Targeting ../SystemLogger.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/VideoEncoder.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// shared
// #include <depthai-shared/properties/VideoEncoderProperties.hpp>
// Targeting ../VideoEncoder.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/Warp.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>
// #include <depthai/pipeline/datatype/WarpConfig.hpp>

// shared
// #include <depthai-shared/common/Point2f.hpp>
// #include <depthai-shared/properties/WarpProperties.hpp>
// Targeting ../Warp.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/XLinkIn.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// shared
// #include <depthai-shared/properties/XLinkInProperties.hpp>
// Targeting ../XLinkIn.java



  // namespace node
  // namespace dai


// Parsed from depthai/pipeline/node/XLinkOut.hpp

// #pragma once

// #include <depthai/pipeline/Node.hpp>

// shared
// #include <depthai-shared/properties/XLinkOutProperties.hpp>
// Targeting ../XLinkOut.java



  // namespace node
  // namespace dai


// Parsed from depthai/xlink/XLinkConnection.hpp

// #pragma once

// Std
// #include <atomic>
// #include <chrono>
// #include <cstdint>
// #include <list>
// #include <mutex>
// #include <string>
// #include <thread>
// #include <tuple>
// #include <unordered_map>
// #include <vector>

// project
// #include "depthai/utility/Path.hpp"

// Libraries
// #include <XLink/XLinkPublicDefines.h>
// Targeting ../DeviceInfo.java


// Targeting ../XLinkConnection.java



  // namespace dai


// Parsed from depthai/xlink/XLinkStream.hpp

// #pragma once

// Std
// #include <atomic>
// #include <chrono>
// #include <cstdint>
// #include <list>
// #include <memory>
// #include <mutex>
// #include <stdexcept>
// #include <string>
// #include <thread>
// #include <tuple>
// #include <unordered_map>
// #include <utility>
// #include <vector>

// libraries
// #include <XLink/XLinkPublicDefines.h>

// project
// #include "depthai/xlink/XLinkConnection.hpp"
// Targeting ../StreamPacketDesc.java


// Targeting ../XLinkStream.java


// Targeting ../XLinkError.java


// Targeting ../XLinkReadError.java


// Targeting ../XLinkWriteError.java



  // namespace dai


// Parsed from depthai-bootloader-shared/Config.hpp

// #pragma once

// #include "Memory.hpp"

// std
// #include <array>
// #include <chrono>
// #include <cstdint>

// libraries
// #include "NlohmannJsonCompat.hpp"

// #define DEPTHAI_BOOTLOADER_NLOHMANN_JSON_OPTIONAL_TO(v1) nlohmann::to_json(nlohmann_json_j[#v1], nlohmann_json_t.v1);
// #define DEPTHAI_BOOTLOADER_NLOHMANN_JSON_OPTIONAL_FROM(v1) if(nlohmann_json_j.contains(#v1)) nlohmann_json_j[#v1].get_to(nlohmann_json_t.v1);

// #define DEPTHAI_BOOTLOADER_NLOHMANN_DEFINE_TYPE_OPTIONAL_NON_INTRUSIVE(Type, ...)
//     inline void to_json(nlohmann::json& nlohmann_json_j, const Type& nlohmann_json_t) { DEPTHAI_BOOTLOADER_NLOHMANN_JSON_EXPAND(DEPTHAI_BOOTLOADER_NLOHMANN_JSON_PASTE(DEPTHAI_BOOTLOADER_NLOHMANN_JSON_OPTIONAL_TO, __VA_ARGS__)) }
//     inline void from_json(const nlohmann::json& nlohmann_json_j, Type& nlohmann_json_t) { DEPTHAI_BOOTLOADER_NLOHMANN_JSON_EXPAND(DEPTHAI_BOOTLOADER_NLOHMANN_JSON_PASTE(DEPTHAI_BOOTLOADER_NLOHMANN_JSON_OPTIONAL_FROM, __VA_ARGS__)) }
// Targeting ../NetworkConfig.java


@Namespace("dai::bootloader") public static native void to_json(@Cast("nlohmann::json*") @ByRef Pointer nlohmann_json_j, @Const @ByRef NetworkConfig nlohmann_json_t);
    @Namespace("dai::bootloader") public static native void from_json(@Cast("const nlohmann::json*") @ByRef Pointer nlohmann_json_j, @ByRef NetworkConfig nlohmann_json_t);
// Targeting ../UsbConfig.java


@Namespace("dai::bootloader") public static native void to_json(@Cast("nlohmann::json*") @ByRef Pointer nlohmann_json_j, @Const @ByRef UsbConfig nlohmann_json_t);
    @Namespace("dai::bootloader") public static native void from_json(@Cast("const nlohmann::json*") @ByRef Pointer nlohmann_json_j, @ByRef UsbConfig nlohmann_json_t);
// Targeting ../BootloaderConfig.java


@Namespace("dai::bootloader") public static native void to_json(@Cast("nlohmann::json*") @ByRef Pointer nlohmann_json_j, @Const @ByRef BootloaderConfig nlohmann_json_t);
    @Namespace("dai::bootloader") public static native void from_json(@Cast("const nlohmann::json*") @ByRef Pointer nlohmann_json_j, @ByRef BootloaderConfig nlohmann_json_t);

 // namespace bootloader
 // namespace dai



// Parsed from depthai-bootloader-shared/Memory.hpp

// #pragma once

// std
// #include <cstdint>

@Namespace("dai::bootloader") public enum Memory {
    AUTO(-1), FLASH(0), EMMC(1);

    public final int value;
    private Memory(int v) { this.value = v; }
    private Memory(Memory e) { this.value = e.value; }
    public Memory intern() { for (Memory e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

 // namespace bootloader
 // namespace dai


// Parsed from depthai-bootloader-shared/Section.hpp

// #pragma once

// std
// #include <cstdint>

@Namespace("dai::bootloader") public enum Section {
    AUTO(-1), HEADER(0), BOOTLOADER(1), BOOTLOADER_CONFIG(2), APPLICATION(3), USER_BOOTLOADER(4);

    public final int value;
    private Section(int v) { this.value = v; }
    private Section(Section e) { this.value = e.value; }
    public Section intern() { for (Section e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

 // namespace bootloader
 // namespace dai



// Parsed from depthai-bootloader-shared/Type.hpp

// #pragma once

// std
// #include <cstdint>

@Namespace("dai::bootloader") public enum Type {
    AUTO(-1), USB(0), NETWORK(1);

    public final int value;
    private Type(int v) { this.value = v; }
    private Type(Type e) { this.value = e.value; }
    public Type intern() { for (Type e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

 // namespace bootloader
 // namespace dai


// Parsed from depthai/device/Version.hpp

// #pragma once

// #include <string>
// Targeting ../Version.java



  // namespace dai

// Parsed from depthai/device/DataQueue.hpp

// #pragma once

// std
// #include <atomic>
// #include <memory>
// #include <vector>

// project
// #include "depthai/pipeline/datatype/ADatatype.hpp"
// #include "depthai/utility/LockingQueue.hpp"
// #include "depthai/xlink/XLinkConnection.hpp"

// shared
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/xlink/XLinkConstants.hpp"
// Targeting ../DataOutputQueue.java


// Targeting ../DataInputQueue.java



  // namespace dai


// Parsed from depthai/device/DeviceBase.hpp

// #pragma once

// std
// #include <atomic>
// #include <chrono>
// #include <condition_variable>
// #include <functional>
// #include <memory>
// #include <mutex>
// #include <string>
// #include <thread>
// #include <tuple>
// #include <type_traits>
// #include <unordered_map>
// #include <vector>

// project
// #include "depthai/common/CameraBoardSocket.hpp"
// #include "depthai/common/CameraFeatures.hpp"
// #include "depthai/common/UsbSpeed.hpp"
// #include "depthai/device/CalibrationHandler.hpp"
// #include "depthai/device/Version.hpp"
// #include "depthai/openvino/OpenVINO.hpp"
// #include "depthai/utility/Pimpl.hpp"
// #include "depthai/xlink/XLinkConnection.hpp"
// #include "depthai/xlink/XLinkStream.hpp"

// shared
// #include "depthai-shared/common/ChipTemperature.hpp"
// #include "depthai-shared/common/CpuUsage.hpp"
// #include "depthai-shared/common/MemoryInfo.hpp"
// #include "depthai-shared/datatype/RawIMUData.hpp"
// #include "depthai-shared/device/BoardConfig.hpp"
// #include "depthai-shared/device/CrashDump.hpp"
// #include "depthai-shared/log/LogLevel.hpp"
// #include "depthai-shared/log/LogMessage.hpp"

// Forward declare Pipeline
// Targeting ../DeviceBase.java


  // namespace dai


// Parsed from depthai/device/CalibrationHandler.hpp

// #pragma once
// #include <string>
// #include <tuple>

// #include "depthai-shared/common/CameraBoardSocket.hpp"
// #include "depthai-shared/common/EepromData.hpp"
// #include "depthai-shared/common/Point2f.hpp"
// #include "depthai-shared/common/Size2f.hpp"
// #include "depthai/utility/Path.hpp"
// Targeting ../CalibrationHandler.java



  // namespace dai

// Parsed from depthai/device/CallbackHandler.hpp

// #pragma once

// std
// #include <functional>
// #include <memory>

// shared
// #include "depthai-shared/datatype/RawBuffer.hpp"
// #include "depthai-shared/xlink/XLinkConstants.hpp"

// project
// #include "DataQueue.hpp"
// #include "depthai/xlink/XLinkConnection.hpp"
// Targeting ../CallbackHandler.java



  // namespace dai


// Parsed from depthai/device/Device.hpp

// #pragma once

// std
// #include <chrono>
// #include <condition_variable>
// #include <deque>
// #include <memory>
// #include <mutex>
// #include <string>
// #include <unordered_map>

// project
// #include "DataQueue.hpp"
// #include "depthai/device/DeviceBase.hpp"
// Targeting ../Device.java



  // namespace dai


// Parsed from depthai/device/DeviceBootloader.hpp

// #pragma once

// std
// #include <string>
// #include <thread>
// #include <type_traits>

// project
// #include "CallbackHandler.hpp"
// #include "DataQueue.hpp"
// #include "depthai/common/UsbSpeed.hpp"
// #include "depthai/pipeline/Pipeline.hpp"
// #include "depthai/xlink/XLinkConnection.hpp"
// #include "depthai/xlink/XLinkStream.hpp"

// shared
// #include "depthai-bootloader-shared/Config.hpp"
// #include "depthai-bootloader-shared/Memory.hpp"
// #include "depthai-bootloader-shared/Section.hpp"
// #include "depthai-bootloader-shared/Type.hpp"
// Targeting ../DeviceBootloader.java



  // namespace dai

// Global namespace
public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, Type type);

public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, Memory memory);

public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, Section type);

public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, @Const @ByRef Version v);

}
