/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import org.bytedeco.depthai.BoardConfigIMUOptional;
import org.bytedeco.depthai.BoolOptional;
import org.bytedeco.depthai.ByteGPIOMap;
import org.bytedeco.depthai.ByteUARTMap;
import org.bytedeco.depthai.CameraBoardSocketBoardConfigCameraMap;
import org.bytedeco.depthai.CameraImageOrientationOptional;
import org.bytedeco.depthai.CameraSensorTypeOptional;
import org.bytedeco.depthai.IntOptional;
import org.bytedeco.depthai.LogLevelOptional;
import org.bytedeco.depthai.SizeTOptional;
import org.bytedeco.depthai.StringOptional;
import org.bytedeco.depthai.StringVector;
import org.bytedeco.depthai.global.depthai;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdString;

@Namespace(value="dai")
@Properties(inherit={depthai.class})
public class BoardConfig
extends Pointer {
    public BoardConfig() {
        super((Pointer)null);
        this.allocate();
    }

    public BoardConfig(long size) {
        super((Pointer)null);
        this.allocateArray(size);
    }

    public BoardConfig(Pointer p) {
        super(p);
    }

    private native void allocate();

    private native void allocateArray(long var1);

    public BoardConfig position(long position) {
        return (BoardConfig)super.position(position);
    }

    public BoardConfig getPointer(long i) {
        return (BoardConfig)new BoardConfig(this).offsetAddress(i);
    }

    @ByRef
    public native USB usb();

    public native BoardConfig usb(USB var1);

    @ByRef
    public native Network network();

    public native BoardConfig network(Network var1);

    @ByRef
    public native StringVector sysctl();

    public native BoardConfig sysctl(StringVector var1);

    @ByRef
    @Cast(value={"tl::optional<uint32_t>*"})
    public native IntOptional watchdogTimeoutMs();

    public native BoardConfig watchdogTimeoutMs(IntOptional var1);

    @ByRef
    @Cast(value={"tl::optional<uint32_t>*"})
    public native IntOptional watchdogInitialDelayMs();

    public native BoardConfig watchdogInitialDelayMs(IntOptional var1);

    @ByRef
    public native ByteGPIOMap gpio();

    public native BoardConfig gpio(ByteGPIOMap var1);

    @ByRef
    public native ByteUARTMap uart();

    public native BoardConfig uart(ByteUARTMap var1);

    @ByRef
    public native BoolOptional pcieInternalClock();

    public native BoardConfig pcieInternalClock(BoolOptional var1);

    @ByRef
    public native BoolOptional usb3PhyInternalClock();

    public native BoardConfig usb3PhyInternalClock(BoolOptional var1);

    @ByRef
    public native BoolOptional mipi4LaneRgb();

    public native BoardConfig mipi4LaneRgb(BoolOptional var1);

    @ByRef
    public native BoolOptional emmc();

    public native BoardConfig emmc(BoolOptional var1);

    @ByRef
    public native StringOptional logPath();

    public native BoardConfig logPath(StringOptional var1);

    @ByRef
    public native SizeTOptional logSizeMax();

    public native BoardConfig logSizeMax(SizeTOptional var1);

    @ByRef
    public native LogLevelOptional logVerbosity();

    public native BoardConfig logVerbosity(LogLevelOptional var1);

    @ByRef
    public native BoolOptional logDevicePrints();

    public native BoardConfig logDevicePrints(BoolOptional var1);

    @Cast(value={"bool"})
    public native boolean nonExclusiveMode();

    public native BoardConfig nonExclusiveMode(boolean var1);

    @ByRef
    public native CameraBoardSocketBoardConfigCameraMap camera();

    public native BoardConfig camera(CameraBoardSocketBoardConfigCameraMap var1);

    @ByRef
    public native BoardConfigIMUOptional imu();

    public native BoardConfig imu(BoardConfigIMUOptional var1);

    static {
        Loader.load();
    }

    @NoOffset
    public static class IMU
    extends Pointer {
        public IMU(Pointer p) {
            super(p);
        }

        public IMU(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        private native void allocateArray(long var1);

        public IMU position(long position) {
            return (IMU)super.position(position);
        }

        public IMU getPointer(long i) {
            return (IMU)new IMU(this).offsetAddress(i);
        }

        public IMU() {
            super((Pointer)null);
            this.allocate();
        }

        private native void allocate();

        public native byte bus();

        public native IMU bus(byte var1);

        public native byte interrupt();

        public native IMU interrupt(byte var1);

        public native byte wake();

        public native IMU wake(byte var1);

        public native byte csGpio();

        public native IMU csGpio(byte var1);

        static {
            Loader.load();
        }
    }

    public static class Camera
    extends Pointer {
        public Camera() {
            super((Pointer)null);
            this.allocate();
        }

        public Camera(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public Camera(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public Camera position(long position) {
            return (Camera)super.position(position);
        }

        public Camera getPointer(long i) {
            return (Camera)new Camera(this).offsetAddress(i);
        }

        @StdString
        public native BytePointer name();

        public native Camera name(BytePointer var1);

        @ByRef
        public native CameraSensorTypeOptional sensorType();

        public native Camera sensorType(CameraSensorTypeOptional var1);

        @ByRef
        public native CameraImageOrientationOptional orientation();

        public native Camera orientation(CameraImageOrientationOptional var1);

        static {
            Loader.load();
        }
    }

    public static class UART
    extends Pointer {
        public UART() {
            super((Pointer)null);
            this.allocate();
        }

        public UART(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public UART(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public UART position(long position) {
            return (UART)super.position(position);
        }

        public UART getPointer(long i) {
            return (UART)new UART(this).offsetAddress(i);
        }

        public native byte tmp();

        public native UART tmp(byte var1);

        static {
            Loader.load();
        }
    }

    @NoOffset
    public static class GPIO
    extends Pointer {
        public GPIO(Pointer p) {
            super(p);
        }

        public GPIO(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        private native void allocateArray(long var1);

        public GPIO position(long position) {
            return (GPIO)super.position(position);
        }

        public GPIO getPointer(long i) {
            return (GPIO)new GPIO(this).offsetAddress(i);
        }

        public native Mode mode();

        public native GPIO mode(Mode var1);

        public native Direction direction();

        public native GPIO direction(Direction var1);

        public native Level level();

        public native GPIO level(Level var1);

        public native Pull pull();

        public native GPIO pull(Pull var1);

        public native Drive drive();

        public native GPIO drive(Drive var1);

        @Cast(value={"bool"})
        public native boolean schmitt();

        public native GPIO schmitt(boolean var1);

        @Cast(value={"bool"})
        public native boolean slewFast();

        public native GPIO slewFast(boolean var1);

        public GPIO() {
            super((Pointer)null);
            this.allocate();
        }

        private native void allocate();

        public GPIO(Direction direction) {
            super((Pointer)null);
            this.allocate(direction);
        }

        private native void allocate(Direction var1);

        public GPIO(@Cast(value={"dai::BoardConfig::GPIO::Direction"}) byte direction) {
            super((Pointer)null);
            this.allocate(direction);
        }

        private native void allocate(@Cast(value={"dai::BoardConfig::GPIO::Direction"}) byte var1);

        public GPIO(Direction direction, Level level) {
            super((Pointer)null);
            this.allocate(direction, level);
        }

        private native void allocate(Direction var1, Level var2);

        public GPIO(@Cast(value={"dai::BoardConfig::GPIO::Direction"}) byte direction, @Cast(value={"dai::BoardConfig::GPIO::Level"}) byte level) {
            super((Pointer)null);
            this.allocate(direction, level);
        }

        private native void allocate(@Cast(value={"dai::BoardConfig::GPIO::Direction"}) byte var1, @Cast(value={"dai::BoardConfig::GPIO::Level"}) byte var2);

        public GPIO(Direction direction, Level level, Pull pull) {
            super((Pointer)null);
            this.allocate(direction, level, pull);
        }

        private native void allocate(Direction var1, Level var2, Pull var3);

        public GPIO(@Cast(value={"dai::BoardConfig::GPIO::Direction"}) byte direction, @Cast(value={"dai::BoardConfig::GPIO::Level"}) byte level, @Cast(value={"dai::BoardConfig::GPIO::Pull"}) byte pull) {
            super((Pointer)null);
            this.allocate(direction, level, pull);
        }

        private native void allocate(@Cast(value={"dai::BoardConfig::GPIO::Direction"}) byte var1, @Cast(value={"dai::BoardConfig::GPIO::Level"}) byte var2, @Cast(value={"dai::BoardConfig::GPIO::Pull"}) byte var3);

        public GPIO(Direction direction, Mode mode) {
            super((Pointer)null);
            this.allocate(direction, mode);
        }

        private native void allocate(Direction var1, Mode var2);

        public GPIO(Direction direction, Mode mode, Pull pull) {
            super((Pointer)null);
            this.allocate(direction, mode, pull);
        }

        private native void allocate(Direction var1, Mode var2, Pull var3);

        static {
            Loader.load();
        }

        public static enum Drive {
            MA_2(2),
            MA_4(4),
            MA_8(8),
            MA_12(12);

            public final byte value;

            private Drive(byte v) {
                this.value = v;
            }

            private Drive(Drive e) {
                this.value = e.value;
            }

            public Drive intern() {
                for (Drive e : Drive.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }

        public static enum Pull {
            NO_PULL(0),
            PULL_UP(1),
            PULL_DOWN(2),
            BUS_KEEPER(3);

            public final byte value;

            private Pull(byte v) {
                this.value = v;
            }

            private Pull(Pull e) {
                this.value = e.value;
            }

            public Pull intern() {
                for (Pull e : Pull.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }

        public static enum Level {
            LOW(0),
            HIGH(1);

            public final byte value;

            private Level(byte v) {
                this.value = v;
            }

            private Level(Level e) {
                this.value = e.value;
            }

            public Level intern() {
                for (Level e : Level.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }

        public static enum Direction {
            INPUT(0),
            OUTPUT(1);

            public final byte value;

            private Direction(byte v) {
                this.value = v;
            }

            private Direction(Direction e) {
                this.value = e.value;
            }

            public Direction intern() {
                for (Direction e : Direction.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }

        public static enum Mode {
            ALT_MODE_0(0),
            ALT_MODE_1(1),
            ALT_MODE_2(2),
            ALT_MODE_3(3),
            ALT_MODE_4(4),
            ALT_MODE_5(5),
            ALT_MODE_6(6),
            DIRECT(7);

            public final byte value;

            private Mode(byte v) {
                this.value = v;
            }

            private Mode(Mode e) {
                this.value = e.value;
            }

            public Mode intern() {
                for (Mode e : Mode.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }
    }

    public static class Network
    extends Pointer {
        public Network() {
            super((Pointer)null);
            this.allocate();
        }

        public Network(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public Network(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public Network position(long position) {
            return (Network)super.position(position);
        }

        public Network getPointer(long i) {
            return (Network)new Network(this).offsetAddress(i);
        }

        @Cast(value={"uint16_t"})
        public native short mtu();

        public native Network mtu(short var1);

        @Cast(value={"bool"})
        public native boolean xlinkTcpNoDelay();

        public native Network xlinkTcpNoDelay(boolean var1);

        static {
            Loader.load();
        }
    }

    public static class USB
    extends Pointer {
        public USB() {
            super((Pointer)null);
            this.allocate();
        }

        public USB(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public USB(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public USB position(long position) {
            return (USB)super.position(position);
        }

        public USB getPointer(long i) {
            return (USB)new USB(this).offsetAddress(i);
        }

        @Cast(value={"uint16_t"})
        public native short vid();

        public native USB vid(short var1);

        @Cast(value={"uint16_t"})
        public native short pid();

        public native USB pid(short var1);

        @Cast(value={"uint16_t"})
        public native short flashBootedVid();

        public native USB flashBootedVid(short var1);

        @Cast(value={"uint16_t"})
        public native short flashBootedPid();

        public native USB flashBootedPid(short var1);

        public native depthai.UsbSpeed maxSpeed();

        public native USB maxSpeed(depthai.UsbSpeed var1);

        static {
            Loader.load();
        }
    }
}

