/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import java.util.Arrays;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;

@Name(value={"std::vector<uint8_t>"})
@Properties(inherit={depthai.class})
public class ByteVector
extends Pointer {
    public ByteVector(Pointer p) {
        super(p);
    }

    public ByteVector(byte value) {
        this(1L);
        this.put(0L, value);
    }

    public ByteVector(byte ... array) {
        this(array.length);
        this.put(array);
    }

    public ByteVector() {
        this.allocate();
    }

    public ByteVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native ByteVector put(@ByRef ByteVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @Cast(value={"uint8_t"})
    public native byte get(@Cast(value={"size_t"}) long var1);

    public native ByteVector put(@Cast(value={"size_t"}) long var1, byte var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"uint8_t"}) byte var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public byte[] get() {
        byte[] array = new byte[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public byte pop_back() {
        long size = this.size();
        byte value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public ByteVector push_back(byte value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public ByteVector put(byte value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public ByteVector put(byte ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Cast(value={"uint8_t"})
        public native byte get();
    }
}

