/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import java.nio.ByteBuffer;
import org.bytedeco.depthai.BoardConfig;
import org.bytedeco.depthai.BoolFloatTuple;
import org.bytedeco.depthai.CalibrationHandler;
import org.bytedeco.depthai.CameraBoardSocketStringMap;
import org.bytedeco.depthai.CameraFeatures;
import org.bytedeco.depthai.ChipTemperature;
import org.bytedeco.depthai.CpuUsage;
import org.bytedeco.depthai.CrashDump;
import org.bytedeco.depthai.DeviceInfo;
import org.bytedeco.depthai.MemoryInfo;
import org.bytedeco.depthai.Path;
import org.bytedeco.depthai.Pipeline;
import org.bytedeco.depthai.StringIntIntTuple;
import org.bytedeco.depthai.Version;
import org.bytedeco.depthai.VersionOptional;
import org.bytedeco.depthai.XLinkConnection;
import org.bytedeco.depthai.global.depthai;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.SharedPtr;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.javacpp.annotation.StdVector;

@Namespace(value="dai")
@NoOffset
@Properties(inherit={depthai.class})
public class DeviceBase
extends Pointer {
    public static final float DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ;
    public static final int DEFAULT_TIMESYNC_NUM_SAMPLES;
    public static final boolean DEFAULT_TIMESYNC_RANDOM;

    public DeviceBase(Pointer p) {
        super(p);
    }

    @MemberGetter
    @ByRef
    @Cast(value={"const std::chrono::seconds*"})
    public static native Pointer DEFAULT_SEARCH_TIME();

    @MemberGetter
    public static native float DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ();

    @MemberGetter
    public static native depthai.UsbSpeed DEFAULT_USB_SPEED();

    @MemberGetter
    @ByRef
    @Cast(value={"const std::chrono::milliseconds*"})
    public static native Pointer DEFAULT_TIMESYNC_PERIOD();

    @MemberGetter
    public static native int DEFAULT_TIMESYNC_NUM_SAMPLES();

    @MemberGetter
    @Cast(value={"const bool"})
    public static native boolean DEFAULT_TIMESYNC_RANDOM();

    @ByVal
    @Cast(value={"std::chrono::milliseconds*"})
    public static native Pointer getDefaultSearchTime();

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getAnyAvailableDevice(@ByVal @Cast(value={"std::chrono::milliseconds*"}) Pointer var0);

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getAnyAvailableDevice();

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getAnyAvailableDevice(@ByVal @Cast(value={"std::chrono::milliseconds*"}) Pointer var0, depthai.Callback var1);

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getFirstAvailableDevice(@Cast(value={"bool"}) boolean var0);

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getFirstAvailableDevice();

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getDeviceByMxId(@StdString BytePointer var0);

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getDeviceByMxId(@StdString ByteBuffer var0);

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getDeviceByMxId(@StdString String var0);

    @StdVector
    public static native DeviceInfo getAllAvailableDevices();

    @StdVector
    public static native DeviceInfo getAllConnectedDevices();

    @Cast(value={"std::uint8_t*"})
    @StdVector
    public static native BytePointer getEmbeddedDeviceBinary(@Cast(value={"bool"}) boolean var0, @Cast(value={"dai::OpenVINO::Version"}) int var1);

    @Cast(value={"std::uint8_t*"})
    @StdVector
    public static native BytePointer getEmbeddedDeviceBinary(@Cast(value={"bool"}) boolean var0);

    @Cast(value={"std::uint8_t*"})
    @StdVector
    public static native BytePointer getEmbeddedDeviceBinary(@ByVal Config var0);

    public DeviceBase(@Const @ByRef Pipeline pipeline) {
        super((Pointer)null);
        this.allocate(pipeline);
    }

    private native void allocate(@Const @ByRef Pipeline var1);

    public DeviceBase(@Const @ByRef Pipeline pipeline, depthai.UsbSpeed maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(pipeline, maxUsbSpeed);
    }

    private native void allocate(@Const @ByRef Pipeline var1, depthai.UsbSpeed var2);

    public DeviceBase(@Const @ByRef Pipeline pipeline, @Cast(value={"dai::UsbSpeed"}) int maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(pipeline, maxUsbSpeed);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Cast(value={"dai::UsbSpeed"}) int var2);

    public DeviceBase(@Const @ByRef Pipeline pipeline, @Const @ByRef Path pathToCmd) {
        super((Pointer)null);
        this.allocate(pipeline, pathToCmd);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef Path var2);

    public DeviceBase(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo) {
        super((Pointer)null);
        this.allocate(pipeline, devInfo);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef DeviceInfo var2);

    public DeviceBase(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, depthai.UsbSpeed maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(pipeline, devInfo, maxUsbSpeed);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef DeviceInfo var2, depthai.UsbSpeed var3);

    public DeviceBase(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, @Cast(value={"dai::UsbSpeed"}) int maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(pipeline, devInfo, maxUsbSpeed);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef DeviceInfo var2, @Cast(value={"dai::UsbSpeed"}) int var3);

    public DeviceBase(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, @Const @ByRef Path pathToCmd) {
        super((Pointer)null);
        this.allocate(pipeline, devInfo, pathToCmd);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef DeviceInfo var2, @Const @ByRef Path var3);

    public DeviceBase() {
        super((Pointer)null);
        this.allocate();
    }

    private native void allocate();

    public DeviceBase(@Cast(value={"dai::OpenVINO::Version"}) int version) {
        super((Pointer)null);
        this.allocate(version);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1);

    public DeviceBase(@Cast(value={"dai::OpenVINO::Version"}) int version, depthai.UsbSpeed maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(version, maxUsbSpeed);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, depthai.UsbSpeed var2);

    public DeviceBase(@Cast(value={"dai::OpenVINO::Version"}) int version, @Cast(value={"dai::UsbSpeed"}) int maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(version, maxUsbSpeed);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Cast(value={"dai::UsbSpeed"}) int var2);

    public DeviceBase(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef Path pathToCmd) {
        super((Pointer)null);
        this.allocate(version, pathToCmd);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef Path var2);

    public DeviceBase(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef DeviceInfo devInfo) {
        super((Pointer)null);
        this.allocate(version, devInfo);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef DeviceInfo var2);

    public DeviceBase(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef DeviceInfo devInfo, depthai.UsbSpeed maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(version, devInfo, maxUsbSpeed);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef DeviceInfo var2, depthai.UsbSpeed var3);

    public DeviceBase(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef DeviceInfo devInfo, @Cast(value={"dai::UsbSpeed"}) int maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(version, devInfo, maxUsbSpeed);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef DeviceInfo var2, @Cast(value={"dai::UsbSpeed"}) int var3);

    public DeviceBase(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef DeviceInfo devInfo, @Const @ByRef Path pathToCmd) {
        super((Pointer)null);
        this.allocate(version, devInfo, pathToCmd);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef DeviceInfo var2, @Const @ByRef Path var3);

    public DeviceBase(@ByVal Config config) {
        super((Pointer)null);
        this.allocate(config);
    }

    private native void allocate(@ByVal Config var1);

    public DeviceBase(@ByVal Config config, @Const @ByRef DeviceInfo devInfo) {
        super((Pointer)null);
        this.allocate(config, devInfo);
    }

    private native void allocate(@ByVal Config var1, @Const @ByRef DeviceInfo var2);

    public DeviceBase(@Const @ByRef DeviceInfo devInfo) {
        super((Pointer)null);
        this.allocate(devInfo);
    }

    private native void allocate(@Const @ByRef DeviceInfo var1);

    public DeviceBase(@Const @ByRef DeviceInfo devInfo, depthai.UsbSpeed maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(devInfo, maxUsbSpeed);
    }

    private native void allocate(@Const @ByRef DeviceInfo var1, depthai.UsbSpeed var2);

    public DeviceBase(@Const @ByRef DeviceInfo devInfo, @Cast(value={"dai::UsbSpeed"}) int maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(devInfo, maxUsbSpeed);
    }

    private native void allocate(@Const @ByRef DeviceInfo var1, @Cast(value={"dai::UsbSpeed"}) int var2);

    public DeviceBase(@StdString BytePointer nameOrDeviceId) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId);
    }

    private native void allocate(@StdString BytePointer var1);

    public DeviceBase(@StdString ByteBuffer nameOrDeviceId) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId);
    }

    private native void allocate(@StdString ByteBuffer var1);

    public DeviceBase(@StdString String nameOrDeviceId) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId);
    }

    private native void allocate(@StdString String var1);

    public DeviceBase(@StdString BytePointer nameOrDeviceId, depthai.UsbSpeed maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId, maxUsbSpeed);
    }

    private native void allocate(@StdString BytePointer var1, depthai.UsbSpeed var2);

    public DeviceBase(@StdString ByteBuffer nameOrDeviceId, @Cast(value={"dai::UsbSpeed"}) int maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId, maxUsbSpeed);
    }

    private native void allocate(@StdString ByteBuffer var1, @Cast(value={"dai::UsbSpeed"}) int var2);

    public DeviceBase(@StdString String nameOrDeviceId, depthai.UsbSpeed maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId, maxUsbSpeed);
    }

    private native void allocate(@StdString String var1, depthai.UsbSpeed var2);

    public DeviceBase(@StdString BytePointer nameOrDeviceId, @Cast(value={"dai::UsbSpeed"}) int maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId, maxUsbSpeed);
    }

    private native void allocate(@StdString BytePointer var1, @Cast(value={"dai::UsbSpeed"}) int var2);

    public DeviceBase(@StdString ByteBuffer nameOrDeviceId, depthai.UsbSpeed maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId, maxUsbSpeed);
    }

    private native void allocate(@StdString ByteBuffer var1, depthai.UsbSpeed var2);

    public DeviceBase(@StdString String nameOrDeviceId, @Cast(value={"dai::UsbSpeed"}) int maxUsbSpeed) {
        super((Pointer)null);
        this.allocate(nameOrDeviceId, maxUsbSpeed);
    }

    private native void allocate(@StdString String var1, @Cast(value={"dai::UsbSpeed"}) int var2);

    @ByVal
    public native VersionOptional getBootloaderVersion();

    @Cast(value={"bool"})
    public native boolean isPipelineRunning();

    @Cast(value={"bool"})
    @Deprecated
    public native boolean startPipeline();

    @Cast(value={"bool"})
    public native boolean startPipeline(@Const @ByRef Pipeline var1);

    public native void setLogLevel(depthai.LogLevel var1);

    public native void setLogLevel(@Cast(value={"dai::LogLevel"}) int var1);

    public native depthai.LogLevel getLogLevel();

    public native void setXLinkChunkSize(int var1);

    public native int getXLinkChunkSize();

    @ByVal
    public native DeviceInfo getDeviceInfo();

    @StdString
    public native BytePointer getDeviceName();

    @StdString
    public native BytePointer getMxId();

    public native void setLogOutputLevel(depthai.LogLevel var1);

    public native void setLogOutputLevel(@Cast(value={"dai::LogLevel"}) int var1);

    public native depthai.LogLevel getLogOutputLevel();

    @Cast(value={"bool"})
    public native boolean setIrLaserDotProjectorBrightness(float var1, int var2);

    @Cast(value={"bool"})
    public native boolean setIrLaserDotProjectorBrightness(float var1);

    @Cast(value={"bool"})
    public native boolean setIrFloodLightBrightness(float var1, int var2);

    @Cast(value={"bool"})
    public native boolean setIrFloodLightBrightness(float var1);

    @StdVector
    public native StringIntIntTuple getIrDrivers();

    @ByVal
    public native CrashDump getCrashDump();

    @Cast(value={"bool"})
    public native boolean hasCrashDump();

    public native int addLogCallback(depthai.LogCallback var1);

    @Cast(value={"bool"})
    public native boolean removeLogCallback(int var1);

    public native void setSystemInformationLoggingRate(float var1);

    public native float getSystemInformationLoggingRate();

    @StdVector
    @Cast(value={"dai::CameraBoardSocket*"})
    public native IntPointer getConnectedCameras();

    @StdVector
    public native CameraFeatures getConnectedCameraFeatures();

    @ByVal
    public native CameraBoardSocketStringMap getCameraSensorNames();

    @StdString
    public native BytePointer getConnectedIMU();

    @ByVal
    public native Version getIMUFirmwareVersion();

    @ByVal
    public native Version getEmbeddedIMUFirmwareVersion();

    @Cast(value={"bool"})
    public native boolean startIMUFirmwareUpdate(@Cast(value={"bool"}) boolean var1);

    @Cast(value={"bool"})
    public native boolean startIMUFirmwareUpdate();

    @ByVal
    public native BoolFloatTuple getIMUFirmwareUpdateStatus();

    @ByVal
    public native MemoryInfo getDdrMemoryUsage();

    @ByVal
    public native MemoryInfo getCmxMemoryUsage();

    @ByVal
    public native MemoryInfo getLeonCssHeapUsage();

    @ByVal
    public native MemoryInfo getLeonMssHeapUsage();

    @ByVal
    public native ChipTemperature getChipTemperature();

    @ByVal
    public native CpuUsage getLeonCssCpuUsage();

    @ByVal
    public native CpuUsage getLeonMssCpuUsage();

    @Cast(value={"bool"})
    public native boolean isEepromAvailable();

    @Cast(value={"bool"})
    public native boolean flashCalibration(@ByVal CalibrationHandler var1);

    public native void flashCalibration2(@ByVal CalibrationHandler var1);

    @ByVal
    public native CalibrationHandler readCalibration();

    @ByVal
    public native CalibrationHandler readCalibration2();

    @ByVal
    public native CalibrationHandler readCalibrationOrDefault();

    public native void factoryResetCalibration();

    public native void flashFactoryCalibration(@ByVal CalibrationHandler var1);

    public native void flashEepromClear();

    public native void flashFactoryEepromClear();

    @ByVal
    public native CalibrationHandler readFactoryCalibration();

    @ByVal
    public native CalibrationHandler readFactoryCalibrationOrDefault();

    @Cast(value={"std::uint8_t*"})
    @StdVector
    public native BytePointer readCalibrationRaw();

    @Cast(value={"std::uint8_t*"})
    @StdVector
    public native BytePointer readFactoryCalibrationRaw();

    public native depthai.UsbSpeed getUsbSpeed();

    public native void setTimesync(@ByVal @Cast(value={"std::chrono::milliseconds*"}) Pointer var1, int var2, @Cast(value={"bool"}) boolean var3);

    public native void setTimesync(@Cast(value={"bool"}) boolean var1);

    @Name(value={"close"})
    public native void _close();

    @Cast(value={"bool"})
    public native boolean isClosed();

    @SharedPtr
    public native XLinkConnection getConnection();

    static {
        Loader.load();
        DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ = DeviceBase.DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ();
        DEFAULT_TIMESYNC_NUM_SAMPLES = DeviceBase.DEFAULT_TIMESYNC_NUM_SAMPLES();
        DEFAULT_TIMESYNC_RANDOM = DeviceBase.DEFAULT_TIMESYNC_RANDOM();
    }

    public static class Config
    extends Pointer {
        public Config() {
            super((Pointer)null);
            this.allocate();
        }

        public Config(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public Config(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public Config position(long position) {
            return (Config)super.position(position);
        }

        public Config getPointer(long i) {
            return (Config)new Config(this).offsetAddress(i);
        }

        @Cast(value={"dai::OpenVINO::Version"})
        public native int version();

        public native Config version(int var1);

        @ByRef
        public native BoardConfig board();

        public native Config board(BoardConfig var1);

        @Cast(value={"bool"})
        public native boolean nonExclusiveMode();

        public native Config nonExclusiveMode(boolean var1);

        static {
            Loader.load();
        }
    }
}

