/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bytedeco.depthai.FloatOptional;
import org.bytedeco.depthai.RawBuffer;
import org.bytedeco.depthai.global.depthai;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdVector;

@Namespace(value="dai")
@NoOffset
@Properties(inherit={depthai.class})
public class RawStereoDepthConfig
extends RawBuffer {
    public RawStereoDepthConfig() {
        super(null);
        this.allocate();
    }

    public RawStereoDepthConfig(long size) {
        super(null);
        this.allocateArray(size);
    }

    public RawStereoDepthConfig(Pointer p) {
        super(p);
    }

    private native void allocate();

    private native void allocateArray(long var1);

    @Override
    public RawStereoDepthConfig position(long position) {
        return (RawStereoDepthConfig)super.position(position);
    }

    @Override
    public RawStereoDepthConfig getPointer(long i) {
        return (RawStereoDepthConfig)new RawStereoDepthConfig(this).offsetAddress(i);
    }

    @ByRef
    public native AlgorithmControl algorithmControl();

    public native RawStereoDepthConfig algorithmControl(AlgorithmControl var1);

    @ByRef
    public native PostProcessing postProcessing();

    public native RawStereoDepthConfig postProcessing(PostProcessing var1);

    @ByRef
    public native CensusTransform censusTransform();

    public native RawStereoDepthConfig censusTransform(CensusTransform var1);

    @ByRef
    public native CostMatching costMatching();

    public native RawStereoDepthConfig costMatching(CostMatching var1);

    @ByRef
    public native CostAggregation costAggregation();

    public native RawStereoDepthConfig costAggregation(CostAggregation var1);

    @Override
    public native void serialize(@Cast(value={"std::uint8_t*"}) @StdVector BytePointer var1, @ByRef @Cast(value={"dai::DatatypeEnum*"}) IntPointer var2);

    @Override
    public native void serialize(@Cast(value={"std::uint8_t*"}) @StdVector ByteBuffer var1, @ByRef @Cast(value={"dai::DatatypeEnum*"}) IntBuffer var2);

    @Override
    public native void serialize(@Cast(value={"std::uint8_t*"}) @StdVector byte[] var1, @ByRef @Cast(value={"dai::DatatypeEnum*"}) int[] var2);

    static {
        Loader.load();
    }

    public static class CostAggregation
    extends Pointer {
        public static final int defaultPenaltyP1;
        public static final int defaultPenaltyP2;

        public CostAggregation() {
            super((Pointer)null);
            this.allocate();
        }

        public CostAggregation(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public CostAggregation(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public CostAggregation position(long position) {
            return (CostAggregation)super.position(position);
        }

        public CostAggregation getPointer(long i) {
            return (CostAggregation)new CostAggregation(this).offsetAddress(i);
        }

        @MemberGetter
        public static native int defaultPenaltyP1();

        @MemberGetter
        public static native int defaultPenaltyP2();

        @Cast(value={"uint8_t"})
        public native byte divisionFactor();

        public native CostAggregation divisionFactor(byte var1);

        @Cast(value={"uint16_t"})
        public native short horizontalPenaltyCostP1();

        public native CostAggregation horizontalPenaltyCostP1(short var1);

        @Cast(value={"uint16_t"})
        public native short horizontalPenaltyCostP2();

        public native CostAggregation horizontalPenaltyCostP2(short var1);

        @Cast(value={"uint16_t"})
        public native short verticalPenaltyCostP1();

        public native CostAggregation verticalPenaltyCostP1(short var1);

        @Cast(value={"uint16_t"})
        public native short verticalPenaltyCostP2();

        public native CostAggregation verticalPenaltyCostP2(short var1);

        static {
            Loader.load();
            defaultPenaltyP1 = CostAggregation.defaultPenaltyP1();
            defaultPenaltyP2 = CostAggregation.defaultPenaltyP2();
        }
    }

    public static class CostMatching
    extends Pointer {
        public CostMatching() {
            super((Pointer)null);
            this.allocate();
        }

        public CostMatching(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public CostMatching(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public CostMatching position(long position) {
            return (CostMatching)super.position(position);
        }

        public CostMatching getPointer(long i) {
            return (CostMatching)new CostMatching(this).offsetAddress(i);
        }

        public native DisparityWidth disparityWidth();

        public native CostMatching disparityWidth(DisparityWidth var1);

        @Cast(value={"bool"})
        public native boolean enableCompanding();

        public native CostMatching enableCompanding(boolean var1);

        @Cast(value={"uint8_t"})
        public native byte invalidDisparityValue();

        public native CostMatching invalidDisparityValue(byte var1);

        @Cast(value={"uint8_t"})
        public native byte confidenceThreshold();

        public native CostMatching confidenceThreshold(byte var1);

        @ByRef
        public native LinearEquationParameters linearEquationParameters();

        public native CostMatching linearEquationParameters(LinearEquationParameters var1);

        static {
            Loader.load();
        }

        public static class LinearEquationParameters
        extends Pointer {
            public LinearEquationParameters() {
                super((Pointer)null);
                this.allocate();
            }

            public LinearEquationParameters(long size) {
                super((Pointer)null);
                this.allocateArray(size);
            }

            public LinearEquationParameters(Pointer p) {
                super(p);
            }

            private native void allocate();

            private native void allocateArray(long var1);

            public LinearEquationParameters position(long position) {
                return (LinearEquationParameters)super.position(position);
            }

            public LinearEquationParameters getPointer(long i) {
                return (LinearEquationParameters)new LinearEquationParameters(this).offsetAddress(i);
            }

            @Cast(value={"uint8_t"})
            public native byte alpha();

            public native LinearEquationParameters alpha(byte var1);

            @Cast(value={"uint8_t"})
            public native byte beta();

            public native LinearEquationParameters beta(byte var1);

            @Cast(value={"uint8_t"})
            public native byte threshold();

            public native LinearEquationParameters threshold(byte var1);

            static {
                Loader.load();
            }
        }

        public static enum DisparityWidth {
            DISPARITY_64(0),
            DISPARITY_96(1);

            public final int value;

            private DisparityWidth(int v) {
                this.value = v;
            }

            private DisparityWidth(DisparityWidth e) {
                this.value = e.value;
            }

            public DisparityWidth intern() {
                for (DisparityWidth e : DisparityWidth.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }
    }

    public static class CensusTransform
    extends Pointer {
        public CensusTransform() {
            super((Pointer)null);
            this.allocate();
        }

        public CensusTransform(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public CensusTransform(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public CensusTransform position(long position) {
            return (CensusTransform)super.position(position);
        }

        public CensusTransform getPointer(long i) {
            return (CensusTransform)new CensusTransform(this).offsetAddress(i);
        }

        public native KernelSize kernelSize();

        public native CensusTransform kernelSize(KernelSize var1);

        @Cast(value={"uint64_t"})
        public native long kernelMask();

        public native CensusTransform kernelMask(long var1);

        @Cast(value={"bool"})
        public native boolean enableMeanMode();

        public native CensusTransform enableMeanMode(boolean var1);

        @Cast(value={"uint32_t"})
        public native int threshold();

        public native CensusTransform threshold(int var1);

        static {
            Loader.load();
        }

        public static enum KernelSize {
            AUTO(-1),
            KERNEL_5x5(0),
            KERNEL_7x7(1),
            KERNEL_7x9(2);

            public final int value;

            private KernelSize(int v) {
                this.value = v;
            }

            private KernelSize(KernelSize e) {
                this.value = e.value;
            }

            public KernelSize intern() {
                for (KernelSize e : KernelSize.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }
    }

    public static class PostProcessing
    extends Pointer {
        public PostProcessing() {
            super((Pointer)null);
            this.allocate();
        }

        public PostProcessing(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public PostProcessing(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public PostProcessing position(long position) {
            return (PostProcessing)super.position(position);
        }

        public PostProcessing getPointer(long i) {
            return (PostProcessing)new PostProcessing(this).offsetAddress(i);
        }

        public native depthai.MedianFilter median();

        public native PostProcessing median(depthai.MedianFilter var1);

        @Cast(value={"std::int16_t"})
        public native short bilateralSigmaValue();

        public native PostProcessing bilateralSigmaValue(short var1);

        @ByRef
        public native SpatialFilter spatialFilter();

        public native PostProcessing spatialFilter(SpatialFilter var1);

        @ByRef
        public native TemporalFilter temporalFilter();

        public native PostProcessing temporalFilter(TemporalFilter var1);

        @ByRef
        public native ThresholdFilter thresholdFilter();

        public native PostProcessing thresholdFilter(ThresholdFilter var1);

        @ByRef
        public native BrightnessFilter brightnessFilter();

        public native PostProcessing brightnessFilter(BrightnessFilter var1);

        @ByRef
        public native SpeckleFilter speckleFilter();

        public native PostProcessing speckleFilter(SpeckleFilter var1);

        @ByRef
        public native DecimationFilter decimationFilter();

        public native PostProcessing decimationFilter(DecimationFilter var1);

        static {
            Loader.load();
        }

        public static class DecimationFilter
        extends Pointer {
            public DecimationFilter() {
                super((Pointer)null);
                this.allocate();
            }

            public DecimationFilter(long size) {
                super((Pointer)null);
                this.allocateArray(size);
            }

            public DecimationFilter(Pointer p) {
                super(p);
            }

            private native void allocate();

            private native void allocateArray(long var1);

            public DecimationFilter position(long position) {
                return (DecimationFilter)super.position(position);
            }

            public DecimationFilter getPointer(long i) {
                return (DecimationFilter)new DecimationFilter(this).offsetAddress(i);
            }

            @Cast(value={"std::uint32_t"})
            public native int decimationFactor();

            public native DecimationFilter decimationFactor(int var1);

            public native DecimationMode decimationMode();

            public native DecimationFilter decimationMode(DecimationMode var1);

            static {
                Loader.load();
            }

            public static enum DecimationMode {
                PIXEL_SKIPPING(0),
                NON_ZERO_MEDIAN(1),
                NON_ZERO_MEAN(2);

                public final int value;

                private DecimationMode(int v) {
                    this.value = v;
                }

                private DecimationMode(DecimationMode e) {
                    this.value = e.value;
                }

                public DecimationMode intern() {
                    for (DecimationMode e : DecimationMode.values()) {
                        if (e.value != this.value) continue;
                        return e;
                    }
                    return this;
                }

                public String toString() {
                    return this.intern().name();
                }
            }
        }

        public static class SpeckleFilter
        extends Pointer {
            public SpeckleFilter() {
                super((Pointer)null);
                this.allocate();
            }

            public SpeckleFilter(long size) {
                super((Pointer)null);
                this.allocateArray(size);
            }

            public SpeckleFilter(Pointer p) {
                super(p);
            }

            private native void allocate();

            private native void allocateArray(long var1);

            public SpeckleFilter position(long position) {
                return (SpeckleFilter)super.position(position);
            }

            public SpeckleFilter getPointer(long i) {
                return (SpeckleFilter)new SpeckleFilter(this).offsetAddress(i);
            }

            @Cast(value={"bool"})
            public native boolean enable();

            public native SpeckleFilter enable(boolean var1);

            @Cast(value={"std::uint32_t"})
            public native int speckleRange();

            public native SpeckleFilter speckleRange(int var1);

            static {
                Loader.load();
            }
        }

        public static class BrightnessFilter
        extends Pointer {
            public BrightnessFilter() {
                super((Pointer)null);
                this.allocate();
            }

            public BrightnessFilter(long size) {
                super((Pointer)null);
                this.allocateArray(size);
            }

            public BrightnessFilter(Pointer p) {
                super(p);
            }

            private native void allocate();

            private native void allocateArray(long var1);

            public BrightnessFilter position(long position) {
                return (BrightnessFilter)super.position(position);
            }

            public BrightnessFilter getPointer(long i) {
                return (BrightnessFilter)new BrightnessFilter(this).offsetAddress(i);
            }

            @Cast(value={"std::int32_t"})
            public native int minBrightness();

            public native BrightnessFilter minBrightness(int var1);

            @Cast(value={"std::int32_t"})
            public native int maxBrightness();

            public native BrightnessFilter maxBrightness(int var1);

            static {
                Loader.load();
            }
        }

        public static class ThresholdFilter
        extends Pointer {
            public ThresholdFilter() {
                super((Pointer)null);
                this.allocate();
            }

            public ThresholdFilter(long size) {
                super((Pointer)null);
                this.allocateArray(size);
            }

            public ThresholdFilter(Pointer p) {
                super(p);
            }

            private native void allocate();

            private native void allocateArray(long var1);

            public ThresholdFilter position(long position) {
                return (ThresholdFilter)super.position(position);
            }

            public ThresholdFilter getPointer(long i) {
                return (ThresholdFilter)new ThresholdFilter(this).offsetAddress(i);
            }

            @Cast(value={"std::int32_t"})
            public native int minRange();

            public native ThresholdFilter minRange(int var1);

            @Cast(value={"std::int32_t"})
            public native int maxRange();

            public native ThresholdFilter maxRange(int var1);

            static {
                Loader.load();
            }
        }

        public static class TemporalFilter
        extends Pointer {
            public static final int DEFAULT_DELTA_VALUE;

            public TemporalFilter() {
                super((Pointer)null);
                this.allocate();
            }

            public TemporalFilter(long size) {
                super((Pointer)null);
                this.allocateArray(size);
            }

            public TemporalFilter(Pointer p) {
                super(p);
            }

            private native void allocate();

            private native void allocateArray(long var1);

            public TemporalFilter position(long position) {
                return (TemporalFilter)super.position(position);
            }

            public TemporalFilter getPointer(long i) {
                return (TemporalFilter)new TemporalFilter(this).offsetAddress(i);
            }

            @MemberGetter
            @Cast(value={"const std::int32_t"})
            public static native int DEFAULT_DELTA_VALUE();

            @Cast(value={"bool"})
            public native boolean enable();

            public native TemporalFilter enable(boolean var1);

            public native PersistencyMode persistencyMode();

            public native TemporalFilter persistencyMode(PersistencyMode var1);

            public native float alpha();

            public native TemporalFilter alpha(float var1);

            @Cast(value={"std::int32_t"})
            public native int delta();

            public native TemporalFilter delta(int var1);

            static {
                Loader.load();
                DEFAULT_DELTA_VALUE = TemporalFilter.DEFAULT_DELTA_VALUE();
            }

            public static enum PersistencyMode {
                PERSISTENCY_OFF(0),
                VALID_8_OUT_OF_8(1),
                VALID_2_IN_LAST_3(2),
                VALID_2_IN_LAST_4(3),
                VALID_2_OUT_OF_8(4),
                VALID_1_IN_LAST_2(5),
                VALID_1_IN_LAST_5(6),
                VALID_1_IN_LAST_8(7),
                PERSISTENCY_INDEFINITELY(8);

                public final int value;

                private PersistencyMode(int v) {
                    this.value = v;
                }

                private PersistencyMode(PersistencyMode e) {
                    this.value = e.value;
                }

                public PersistencyMode intern() {
                    for (PersistencyMode e : PersistencyMode.values()) {
                        if (e.value != this.value) continue;
                        return e;
                    }
                    return this;
                }

                public String toString() {
                    return this.intern().name();
                }
            }
        }

        public static class SpatialFilter
        extends Pointer {
            public static final int DEFAULT_DELTA_VALUE;

            public SpatialFilter() {
                super((Pointer)null);
                this.allocate();
            }

            public SpatialFilter(long size) {
                super((Pointer)null);
                this.allocateArray(size);
            }

            public SpatialFilter(Pointer p) {
                super(p);
            }

            private native void allocate();

            private native void allocateArray(long var1);

            public SpatialFilter position(long position) {
                return (SpatialFilter)super.position(position);
            }

            public SpatialFilter getPointer(long i) {
                return (SpatialFilter)new SpatialFilter(this).offsetAddress(i);
            }

            @MemberGetter
            @Cast(value={"const std::int32_t"})
            public static native int DEFAULT_DELTA_VALUE();

            @Cast(value={"bool"})
            public native boolean enable();

            public native SpatialFilter enable(boolean var1);

            @Cast(value={"std::uint8_t"})
            public native byte holeFillingRadius();

            public native SpatialFilter holeFillingRadius(byte var1);

            public native float alpha();

            public native SpatialFilter alpha(float var1);

            @Cast(value={"std::int32_t"})
            public native int delta();

            public native SpatialFilter delta(int var1);

            @Cast(value={"std::int32_t"})
            public native int numIterations();

            public native SpatialFilter numIterations(int var1);

            static {
                Loader.load();
                DEFAULT_DELTA_VALUE = SpatialFilter.DEFAULT_DELTA_VALUE();
            }
        }
    }

    public static class AlgorithmControl
    extends Pointer {
        public AlgorithmControl() {
            super((Pointer)null);
            this.allocate();
        }

        public AlgorithmControl(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public AlgorithmControl(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public AlgorithmControl position(long position) {
            return (AlgorithmControl)super.position(position);
        }

        public AlgorithmControl getPointer(long i) {
            return (AlgorithmControl)new AlgorithmControl(this).offsetAddress(i);
        }

        public native DepthAlign depthAlign();

        public native AlgorithmControl depthAlign(DepthAlign var1);

        public native DepthUnit depthUnit();

        public native AlgorithmControl depthUnit(DepthUnit var1);

        public native float customDepthUnitMultiplier();

        public native AlgorithmControl customDepthUnitMultiplier(float var1);

        @Cast(value={"bool"})
        public native boolean enableLeftRightCheck();

        public native AlgorithmControl enableLeftRightCheck(boolean var1);

        @Cast(value={"bool"})
        public native boolean enableExtended();

        public native AlgorithmControl enableExtended(boolean var1);

        @Cast(value={"bool"})
        public native boolean enableSubpixel();

        public native AlgorithmControl enableSubpixel(boolean var1);

        @Cast(value={"std::int32_t"})
        public native int leftRightCheckThreshold();

        public native AlgorithmControl leftRightCheckThreshold(int var1);

        @Cast(value={"std::int32_t"})
        public native int subpixelFractionalBits();

        public native AlgorithmControl subpixelFractionalBits(int var1);

        @Cast(value={"std::int32_t"})
        public native int disparityShift();

        public native AlgorithmControl disparityShift(int var1);

        @ByRef
        public native FloatOptional centerAlignmentShiftFactor();

        public native AlgorithmControl centerAlignmentShiftFactor(FloatOptional var1);

        @Cast(value={"std::int32_t"})
        public native int numInvalidateEdgePixels();

        public native AlgorithmControl numInvalidateEdgePixels(int var1);

        static {
            Loader.load();
        }

        public static enum DepthUnit {
            METER(0),
            CENTIMETER(1),
            MILLIMETER(2),
            INCH(3),
            FOOT(4),
            CUSTOM(5);

            public final int value;

            private DepthUnit(int v) {
                this.value = v;
            }

            private DepthUnit(DepthUnit e) {
                this.value = e.value;
            }

            public DepthUnit intern() {
                for (DepthUnit e : DepthUnit.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }

        public static enum DepthAlign {
            RECTIFIED_RIGHT(0),
            RECTIFIED_LEFT(1),
            CENTER(2);

            public final int value;

            private DepthAlign(int v) {
                this.value = v;
            }

            private DepthAlign(DepthAlign e) {
                this.value = e.value;
            }

            public DepthAlign intern() {
                for (DepthAlign e : DepthAlign.values()) {
                    if (e.value != this.value) continue;
                    return e;
                }
                return this;
            }

            public String toString() {
                return this.intern().name();
            }
        }
    }
}

