// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


// Subclass which has its own storage
/**
 * \brief AssetManager can store assets and serialize
 */
@Namespace("dai") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class AssetManager extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AssetManager() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AssetManager(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AssetManager(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AssetManager position(long position) {
        return (AssetManager)super.position(position);
    }
    @Override public AssetManager getPointer(long i) {
        return new AssetManager((Pointer)this).offsetAddress(i);
    }

    /**
     * Adds all assets in an array to the AssetManager
     * @param assets Vector of assets to add
     */
    public native void addExisting(@ByVal AssetVector assets);

    /**
     * Adds an asset object to AssetManager.
     * @param asset Asset to add
     */
    public native void add(@ByVal Asset asset);

    /**
     * Adds an asset object to AssetManager with a specificied key.
     * Key value will be assigned to an Asset as well
     *
     * If asset with key already exists, the function throws an error
     *
     * @param key Key under which the asset should be stored
     * @param asset Asset to store
     */
    public native void add(@StdString BytePointer key, @ByVal Asset asset);
    public native void add(@StdString String key, @ByVal Asset asset);

    /**
     * Adds or overwrites existing asset with a specificied key.
     *
     * @param key Key under which the asset should be stored
     * @param asset Asset to store
     */
    public native void set(@StdString BytePointer key, @ByVal Asset asset);
    public native void set(@StdString String key, @ByVal Asset asset);

    /**
     * @return Asset assigned to the specified key or throws an error otherwise
     */

    /**
     * @return Asset assigned to the specified key or throws an error otherwise
     */
    public native @SharedPtr @ByVal Asset get(@StdString BytePointer key);
    public native @SharedPtr @ByVal Asset get(@StdString String key);

    /**
     * @return All asset stored in the AssetManager
     */

    /**
     * @return All asset stored in the AssetManager
     */
    public native @ByVal AssetVector getAll();

    /**
     * @return Number of asset stored in the AssetManager
     */
    public native @Cast("std::size_t") long size();

    /**
     * Removes asset with key
     * @param key Key of asset to remove
     */
    public native void remove(@StdString BytePointer key);
    public native void remove(@StdString String key);

    /** Serializes */
    public native void serialize(@ByRef Assets serAssets, @Cast("std::uint8_t*") @StdVector BytePointer assetStorage);
    public native void serialize(@ByRef Assets serAssets, @Cast("std::uint8_t*") @StdVector ByteBuffer assetStorage);
    public native void serialize(@ByRef Assets serAssets, @Cast("std::uint8_t*") @StdVector byte[] assetStorage);
}
