// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/**
 * CpuUsage structure
 *
 * Average usage in percent and time span of the average (since last query)
 */
@Namespace("dai") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class CpuUsage extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CpuUsage() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CpuUsage(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CpuUsage(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CpuUsage position(long position) {
        return (CpuUsage)super.position(position);
    }
    @Override public CpuUsage getPointer(long i) {
        return new CpuUsage((Pointer)this).offsetAddress(i);
    }

    /**
     *  Average CPU usage, expressed with a normalized value (0-1)
     */
    public native float average(); public native CpuUsage average(float setter);
    /**
     *  Time span in which the average was calculated in milliseconds
     */
    public native int msTime(); public native CpuUsage msTime(int setter);
}
