// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


// Device (RAII), connects to device and maintains watchdog, timesync, ...

/**
 * Represents the DepthAI device with the methods to interact with it.
 */
@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class Device extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Device(Pointer p) { super(p); }

    // constants

    /** Default search time for constructors which discover devices */
    @MemberGetter public static native @ByRef @Cast("const std::chrono::seconds*") Pointer DEFAULT_SEARCH_TIME();
    /** Maximum number of elements in event queue */
    @MemberGetter public static native @Cast("const std::size_t") long EVENT_QUEUE_MAXIMUM_SIZE();
    public static final long EVENT_QUEUE_MAXIMUM_SIZE = EVENT_QUEUE_MAXIMUM_SIZE();
    /** Default rate at which system information is logged */
    @MemberGetter public static native float DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ();
    public static final float DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ = DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ();

    // static API

    /**
     * Waits for any available device with a timeout
     *
     * @param timeout duration of time to wait for the any device
     * @return Tuple of bool and DeviceInfo. Bool specifies if device was found. DeviceInfo specifies the found device
     */

    /**
     * Gets any available device
     *
     * @return Tuple of bool and DeviceInfo. Bool specifies if device was found. DeviceInfo specifies the found device
     */
    public static native @ByVal @Cast("std::tuple<bool,dai::DeviceInfo>*") Pointer getAnyAvailableDevice();

    /**
     * Gets first available device. Device can be either in XLINK_UNBOOTED or XLINK_BOOTLOADER state
     * @return Tuple of bool and DeviceInfo. Bool specifies if device was found. DeviceInfo specifies the found device
     */
    public static native @ByVal @Cast("std::tuple<bool,dai::DeviceInfo>*") Pointer getFirstAvailableDevice();

    /**
     * Finds a device by MX ID. Example: 14442C10D13EABCE00
     * @param mxId MyraidX ID which uniquely specifies a device
     * @return Tuple of bool and DeviceInfo. Bool specifies if device was found. DeviceInfo specifies the found device
     */
    public static native @ByVal @Cast("std::tuple<bool,dai::DeviceInfo>*") Pointer getDeviceByMxId(@StdString BytePointer mxId);
    public static native @ByVal @Cast("std::tuple<bool,dai::DeviceInfo>*") Pointer getDeviceByMxId(@StdString String mxId);

    /**
     * Returns all connected devices
     * @return Vector of connected devices
     */
    public static native @StdVector DeviceInfo getAllAvailableDevices();

    /**
     * Gets device firmware binary for a specific OpenVINO version
     * @param usb2Mode USB2 mode firmware
     * @param version Version of OpenVINO which firmware will support
     * @return Firmware binary
     */
    public static native @Cast("std::uint8_t*") @StdVector BytePointer getEmbeddedDeviceBinary(@Cast("bool") boolean usb2Mode, @Cast("dai::OpenVINO::Version") int version/*=dai::Pipeline::DEFAULT_OPENVINO_VERSION*/);
    public static native @Cast("std::uint8_t*") @StdVector BytePointer getEmbeddedDeviceBinary(@Cast("bool") boolean usb2Mode);

    /**
     * Connects to any available device with a DEFAULT_SEARCH_TIME timeout.
     * @param pipeline Pipeline to be executed on the device
     */
    public Device(@Const @ByRef Pipeline pipeline) { super((Pointer)null); allocate(pipeline); }
    private native void allocate(@Const @ByRef Pipeline pipeline);

    /**
     * Connects to any available device with a DEFAULT_SEARCH_TIME timeout.
     * @param pipeline Pipeline to be executed on the device
     * @param usb2Mode Boot device using USB2 mode firmware
     */
    public Device(@Const @ByRef Pipeline pipeline, @Cast("bool") boolean usb2Mode) { super((Pointer)null); allocate(pipeline, usb2Mode); }
    private native void allocate(@Const @ByRef Pipeline pipeline, @Cast("bool") boolean usb2Mode);

    /**
     * Connects to any available device with a DEFAULT_SEARCH_TIME timeout.
     * @param pipeline Pipeline to be executed on the device
     * @param pathToCmd Path to custom device firmware
     */
    public Device(@Const @ByRef Pipeline pipeline, @Cast("const char*") BytePointer pathToCmd) { super((Pointer)null); allocate(pipeline, pathToCmd); }
    private native void allocate(@Const @ByRef Pipeline pipeline, @Cast("const char*") BytePointer pathToCmd);
    public Device(@Const @ByRef Pipeline pipeline, String pathToCmd) { super((Pointer)null); allocate(pipeline, pathToCmd); }
    private native void allocate(@Const @ByRef Pipeline pipeline, String pathToCmd);

    /**
     * Connects to any available device with a DEFAULT_SEARCH_TIME timeout.
     * @param pipeline Pipeline to be executed on the device
     * @param pathToCmd Path to custom device firmware
     */

    /**
     * Connects to device specified by devInfo.
     * @param pipeline Pipeline to be executed on the device
     * @param devInfo DeviceInfo which specifies which device to connect to
     * @param usb2Mode Boot device using USB2 mode firmware
     */
    public Device(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, @Cast("bool") boolean usb2Mode/*=false*/) { super((Pointer)null); allocate(pipeline, devInfo, usb2Mode); }
    private native void allocate(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, @Cast("bool") boolean usb2Mode/*=false*/);
    public Device(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo) { super((Pointer)null); allocate(pipeline, devInfo); }
    private native void allocate(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo);

    /**
     * Connects to device specified by devInfo.
     * @param pipeline Pipeline to be executed on the device
     * @param devInfo DeviceInfo which specifies which device to connect to
     * @param pathToCmd Path to custom device firmware
     */
    public Device(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, @Cast("const char*") BytePointer pathToCmd) { super((Pointer)null); allocate(pipeline, devInfo, pathToCmd); }
    private native void allocate(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, @Cast("const char*") BytePointer pathToCmd);
    public Device(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, String pathToCmd) { super((Pointer)null); allocate(pipeline, devInfo, pathToCmd); }
    private native void allocate(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, String pathToCmd);

    /**
     * Connects to device specified by devInfo.
     * @param pipeline Pipeline to be executed on the device
     * @param devInfo DeviceInfo which specifies which device to connect to
     * @param usb2Mode Path to custom device firmware
     */

    /**
     * Connects to any available device with a DEFAULT_SEARCH_TIME timeout.
     * @param version OpenVINO version which the device will be booted with. Default is Pipeline::DEFAULT_OPENVINO_VERSION
     */
    public Device(@Cast("dai::OpenVINO::Version") int version/*=dai::Pipeline::DEFAULT_OPENVINO_VERSION*/) { super((Pointer)null); allocate(version); }
    private native void allocate(@Cast("dai::OpenVINO::Version") int version/*=dai::Pipeline::DEFAULT_OPENVINO_VERSION*/);
    public Device() { super((Pointer)null); allocate(); }
    private native void allocate();

    /**
     * Connects to any available device with a DEFAULT_SEARCH_TIME timeout.
     * @param version OpenVINO version which the device will be booted with
     * @param usb2Mode Boot device using USB2 mode firmware
     */
    public Device(@Cast("dai::OpenVINO::Version") int version, @Cast("bool") boolean usb2Mode) { super((Pointer)null); allocate(version, usb2Mode); }
    private native void allocate(@Cast("dai::OpenVINO::Version") int version, @Cast("bool") boolean usb2Mode);

    /**
     * Connects to any available device with a DEFAULT_SEARCH_TIME timeout.
     * @param version OpenVINO version which the device will be booted with
     * @param pathToCmd Path to custom device firmware
     */
    public Device(@Cast("dai::OpenVINO::Version") int version, @Cast("const char*") BytePointer pathToCmd) { super((Pointer)null); allocate(version, pathToCmd); }
    private native void allocate(@Cast("dai::OpenVINO::Version") int version, @Cast("const char*") BytePointer pathToCmd);
    public Device(@Cast("dai::OpenVINO::Version") int version, String pathToCmd) { super((Pointer)null); allocate(version, pathToCmd); }
    private native void allocate(@Cast("dai::OpenVINO::Version") int version, String pathToCmd);

    /**
     * Connects to any available device with a DEFAULT_SEARCH_TIME timeout.
     * @param version OpenVINO version which the device will be booted with
     * @param pathToCmd Path to custom device firmware
     */

    /**
     * Connects to device specified by devInfo.
     * @param version OpenVINO version which the device will be booted with
     * @param devInfo DeviceInfo which specifies which device to connect to
     * @param usb2Mode Boot device using USB2 mode firmware
     */
    public Device(@Cast("dai::OpenVINO::Version") int version, @Const @ByRef DeviceInfo devInfo, @Cast("bool") boolean usb2Mode/*=false*/) { super((Pointer)null); allocate(version, devInfo, usb2Mode); }
    private native void allocate(@Cast("dai::OpenVINO::Version") int version, @Const @ByRef DeviceInfo devInfo, @Cast("bool") boolean usb2Mode/*=false*/);
    public Device(@Cast("dai::OpenVINO::Version") int version, @Const @ByRef DeviceInfo devInfo) { super((Pointer)null); allocate(version, devInfo); }
    private native void allocate(@Cast("dai::OpenVINO::Version") int version, @Const @ByRef DeviceInfo devInfo);

    /**
     * Connects to device specified by devInfo.
     * @param version OpenVINO version which the device will be booted with
     * @param devInfo DeviceInfo which specifies which device to connect to
     * @param pathToCmd Path to custom device firmware
     */
    public Device(@Cast("dai::OpenVINO::Version") int version, @Const @ByRef DeviceInfo devInfo, @Cast("const char*") BytePointer pathToCmd) { super((Pointer)null); allocate(version, devInfo, pathToCmd); }
    private native void allocate(@Cast("dai::OpenVINO::Version") int version, @Const @ByRef DeviceInfo devInfo, @Cast("const char*") BytePointer pathToCmd);
    public Device(@Cast("dai::OpenVINO::Version") int version, @Const @ByRef DeviceInfo devInfo, String pathToCmd) { super((Pointer)null); allocate(version, devInfo, pathToCmd); }
    private native void allocate(@Cast("dai::OpenVINO::Version") int version, @Const @ByRef DeviceInfo devInfo, String pathToCmd);

    /**
     * Connects to device specified by devInfo.
     * @param version OpenVINO version which the device will be booted with
     * @param devInfo DeviceInfo which specifies which device to connect to
     * @param usb2Mode Path to custom device firmware
     */

    /**
     * Device destructor. Closes the connection and data queues.
     */

    /**
     * Checks if devices pipeline is already running
     *
     * @return True if running, false otherwise
     */
    public native @Cast("bool") boolean isPipelineRunning();

    /**
     * Starts the execution of the devices pipeline
     *
     * @return True if pipeline started, false otherwise
     */
    public native @Cast("bool") @Deprecated boolean startPipeline();

    /**
     * Starts the execution of a given pipeline
     * @param pipeline OpenVINO version of the pipeline must match the one which the device was booted with.
     *
     * @return True if pipeline started, false otherwise
     */
    public native @Cast("bool") boolean startPipeline(@Const @ByRef Pipeline pipeline);

    /**
     * Sets the devices logging severity level. This level affects which logs are transfered from device to host.
     *
     * @param level Logging severity
     */
    public native void setLogLevel(LogLevel level);
    public native void setLogLevel(@Cast("dai::LogLevel") int level);

    /**
     * Gets current logging severity level of the device.
     *
     * @return Logging severity level
     */
    public native LogLevel getLogLevel();

    /**
     * Get the Device Info object o the device which is currently running
     *
     * @return DeviceInfo of the current device in execution
     */
    public native @ByVal DeviceInfo getDeviceInfo();

    /**
     * Sets logging level which decides printing level to standard output.
     * If lower than setLogLevel, no messages will be printed
     *
     * @param level Standard output printing severity
     */
    public native void setLogOutputLevel(LogLevel level);
    public native void setLogOutputLevel(@Cast("dai::LogLevel") int level);

    /**
     * Gets logging level which decides printing level to standard output.
     *
     * @return Standard output printing severity
     */
    public native LogLevel getLogOutputLevel();

    /**
     * Add a callback for device logging. The callback will be called from a separate thread with the LogMessage being passed.
     *
     * @param callback Callback to call whenever a log message arrives
     * @return Id which can be used to later remove the callback
     */
    public native int addLogCallback(LogCallback callback);

    /**
     * Removes a callback
     *
     * @param callbackId Id of callback to be removed
     * @return True if callback was removed, false otherwise
     */
    public native @Cast("bool") boolean removeLogCallback(int callbackId);

    /**
     * Sets rate of system information logging ("info" severity). Default 1Hz
     * If parameter is less or equal to zero, then system information logging will be disabled
     *
     * @param rateHz Logging rate in Hz
     */
    public native void setSystemInformationLoggingRate(float rateHz);

    /**
     * Gets current rate of system information logging ("info" severity) in Hz.
     *
     * @return Logging rate in Hz
     */
    public native float getSystemInformationLoggingRate();

    /**
     * Gets an output queue corresponding to stream name. If it doesn't exist it throws
     *
     * @param name Queue/stream name, created by XLinkOut node
     * @return Smart pointer to DataOutputQueue
     */
    public native @SharedPtr DataOutputQueue getOutputQueue(@StdString BytePointer name);
    public native @SharedPtr DataOutputQueue getOutputQueue(@StdString String name);

    /**
     * Gets a queue corresponding to stream name, if it exists, otherwise it throws. Also sets queue options
     *
     * @param name Queue/stream name, set in XLinkOut node
     * @param maxSize Maximum number of messages in queue
     * @param blocking Queue behavior once full. True specifies blocking and false overwriting of oldest messages. Default: true
     * @return Smart pointer to DataOutputQueue
     */
    public native @SharedPtr DataOutputQueue getOutputQueue(@StdString BytePointer name, @Cast("unsigned int") int maxSize, @Cast("bool") boolean blocking/*=true*/);
    public native @SharedPtr DataOutputQueue getOutputQueue(@StdString BytePointer name, @Cast("unsigned int") int maxSize);
    public native @SharedPtr DataOutputQueue getOutputQueue(@StdString String name, @Cast("unsigned int") int maxSize, @Cast("bool") boolean blocking/*=true*/);
    public native @SharedPtr DataOutputQueue getOutputQueue(@StdString String name, @Cast("unsigned int") int maxSize);

    /**
     * Get all available output queue names
     *
     * @return Vector of output queue names
     */
    public native @ByVal StringVector getOutputQueueNames();

    /**
     * Gets an input queue corresponding to stream name. If it doesn't exist it throws
     *
     * @param name Queue/stream name, set in XLinkIn node
     * @return Smart pointer to DataInputQueue
     */
    public native @SharedPtr DataInputQueue getInputQueue(@StdString BytePointer name);
    public native @SharedPtr DataInputQueue getInputQueue(@StdString String name);

    /**
     * Gets an input queue corresponding to stream name. If it doesn't exist it throws. Also sets queue options
     *
     * @param name Queue/stream name, set in XLinkOut node
     * @param maxSize Maximum number of messages in queue
     * @param blocking Queue behavior once full. True: blocking, false: overwriting of oldest messages. Default: true
     * @return Smart pointer to DataInputQueue
     */
    public native @SharedPtr DataInputQueue getInputQueue(@StdString BytePointer name, @Cast("unsigned int") int maxSize, @Cast("bool") boolean blocking/*=true*/);
    public native @SharedPtr DataInputQueue getInputQueue(@StdString BytePointer name, @Cast("unsigned int") int maxSize);
    public native @SharedPtr DataInputQueue getInputQueue(@StdString String name, @Cast("unsigned int") int maxSize, @Cast("bool") boolean blocking/*=true*/);
    public native @SharedPtr DataInputQueue getInputQueue(@StdString String name, @Cast("unsigned int") int maxSize);

    /**
     * Get all available input queue names
     *
     * @return Vector of input queue names
     */
    public native @ByVal StringVector getInputQueueNames();

    // void setCallback(const std::string& name, std::function<std::shared_ptr<RawBuffer>(std::shared_ptr<RawBuffer>)> cb);

    /**
     * Gets or waits until any of specified queues has received a message
     *
     * @param queueNames Names of queues for which to block
     * @param maxNumEvents Maximum number of events to remove from queue - Default is unlimited
     * @param timeout Timeout after which return regardless. If negative then wait is indefinite - Default is -1
     * @return Names of queues which received messages first
     */
    public native @ByVal StringVector getQueueEvents(@Const @ByRef StringVector queueNames,
                                                @Cast("std::size_t") long maxNumEvents/*=std::numeric_limits<std::size_t>::max()*/,
                                                @ByVal(nullValue = "std::chrono::microseconds(-1)") @Cast("std::chrono::microseconds*") Pointer timeout);
    public native @ByVal StringVector getQueueEvents(@Const @ByRef StringVector queueNames);

    /**
     * Gets or waits until specified queue has received a message
     *
     * @param queueName Name of queues for which to wait for
     * @param maxNumEvents Maximum number of events to remove from queue. Default is unlimited
     * @param timeout Timeout after which return regardless. If negative then wait is indefinite. Default is -1
     * @return Names of queues which received messages first
     */
    public native @ByVal StringVector getQueueEvents(@StdString BytePointer queueName,
                                                @Cast("std::size_t") long maxNumEvents/*=std::numeric_limits<std::size_t>::max()*/,
                                                @ByVal(nullValue = "std::chrono::microseconds(-1)") @Cast("std::chrono::microseconds*") Pointer timeout);
    public native @ByVal StringVector getQueueEvents(@StdString BytePointer queueName);
    public native @ByVal StringVector getQueueEvents(@StdString String queueName,
                                                @Cast("std::size_t") long maxNumEvents/*=std::numeric_limits<std::size_t>::max()*/,
                                                @ByVal(nullValue = "std::chrono::microseconds(-1)") @Cast("std::chrono::microseconds*") Pointer timeout);
    public native @ByVal StringVector getQueueEvents(@StdString String queueName);

    /**
     * Gets or waits until any any queue has received a message
     *
     * @param maxNumEvents Maximum number of events to remove from queue. Default is unlimited
     * @param timeout Timeout after which return regardless. If negative then wait is indefinite. Default is -1
     * @return Names of queues which received messages first
     */
    public native @ByVal StringVector getQueueEvents(@Cast("std::size_t") long maxNumEvents/*=std::numeric_limits<std::size_t>::max()*/,
                                                @ByVal(nullValue = "std::chrono::microseconds(-1)") @Cast("std::chrono::microseconds*") Pointer timeout);
    public native @ByVal StringVector getQueueEvents();

    /**
     * Gets or waits until any of specified queues has received a message
     *
     * @param queueNames Names of queues for which to wait for
     * @param timeout Timeout after which return regardless. If negative then wait is indefinite. Default is -1
     * @return Queue name which received a message first
     */
    public native @StdString BytePointer getQueueEvent(@Const @ByRef StringVector queueNames, @ByVal(nullValue = "std::chrono::microseconds(-1)") @Cast("std::chrono::microseconds*") Pointer timeout);
    public native @StdString BytePointer getQueueEvent(@Const @ByRef StringVector queueNames);

    /**
     * Gets or waits until specified queue has received a message
     *
     * @param queueNames Name of queues for which to wait for
     * @param timeout Timeout after which return regardless. If negative then wait is indefinite. Default is -1
     * @return Queue name which received a message
     */
    public native @StdString BytePointer getQueueEvent(@StdString BytePointer queueName, @ByVal(nullValue = "std::chrono::microseconds(-1)") @Cast("std::chrono::microseconds*") Pointer timeout);
    public native @StdString BytePointer getQueueEvent(@StdString BytePointer queueName);
    public native @StdString String getQueueEvent(@StdString String queueName, @ByVal(nullValue = "std::chrono::microseconds(-1)") @Cast("std::chrono::microseconds*") Pointer timeout);
    public native @StdString String getQueueEvent(@StdString String queueName);

    /**
     * Gets or waits until any queue has received a message
     *
     * @param timeout Timeout after which return regardless. If negative then wait is indefinite. Default is -1
     * @return Queue name which received a message
     */
    public native @StdString BytePointer getQueueEvent(@ByVal(nullValue = "std::chrono::microseconds(-1)") @Cast("std::chrono::microseconds*") Pointer timeout);
    public native @StdString BytePointer getQueueEvent();

    /**
     * Get MxId of device
     *
     * @return MxId of connected device
     */
    public native @StdString BytePointer getMxId();

    /**
     * Get cameras that are connected to the device
     *
     * @return Vector of connected cameras
     */
    public native @StdVector @Cast("dai::CameraBoardSocket*") IntPointer getConnectedCameras();

    /**
     * Retrieves current DDR memory information from device
     *
     * @return Used, remaining and total ddr memory
     */
    public native @ByVal MemoryInfo getDdrMemoryUsage();

    /**
     * Retrieves current CMX memory information from device
     *
     * @return Used, remaining and total cmx memory
     */
    public native @ByVal MemoryInfo getCmxMemoryUsage();

    /**
     * Retrieves current CSS Leon CPU heap information from device
     *
     * @return Used, remaining and total heap memory
     */
    public native @ByVal MemoryInfo getLeonCssHeapUsage();

    /**
     * Retrieves current MSS Leon CPU heap information from device
     *
     * @return Used, remaining and total heap memory
     */
    public native @ByVal MemoryInfo getLeonMssHeapUsage();

    /**
     * Retrieves current chip temperature as measured by device
     *
     * @return Temperature of various onboard sensors
     */
    public native @ByVal ChipTemperature getChipTemperature();

    /**
     * Retrieves average CSS Leon CPU usage
     *
     * @return Average CPU usage and sampling duration
     */
    public native @ByVal CpuUsage getLeonCssCpuUsage();

    /**
     * Retrieves average MSS Leon CPU usage
     *
     * @return Average CPU usage and sampling duration
     */
    public native @ByVal CpuUsage getLeonMssCpuUsage();

    /**
     * Stores the Calibration and Device information to the Device EEPROM
     *
     * @param calibrationObj CalibrationHandler object which is loaded with calibration information.
     *
     * @return true on successful flash, false on failure
     */
    public native @Cast("bool") boolean flashCalibration(@ByVal CalibrationHandler calibrationDataHandler);

    /**
     * Fetches the EEPROM data from the device and loads it into CalibrationHandler object
     *
     * @return The CalibrationHandler object containing the calibration currently flashed on device EEPROM
     */
    public native @ByVal CalibrationHandler readCalibration();

    /**
     * Retrieves USB connection speed
     *
     * @return USB connection speed of connected device if applicable. Unknown otherwise.
     */
    public native UsbSpeed getUsbSpeed();

    /**
     * Explicitly closes connection to device.
     * \note This function does not need to be explicitly called
     * as destructor closes the device automatically
     */
    public native @Name("close") void _close();

    /**
     * Is the device already closed (or disconnected)
     */
    public native @Cast("bool") boolean isClosed();
}
