// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/**
 * \brief ImageManip node. Capability to crop, resize, warp, ... incoming image frames
 */
@Namespace("dai::node") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class ImageManip extends Node {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ImageManip(Pointer p) { super(p); }

    public native @StdString @Override BytePointer getName();

    public ImageManip(@SharedPtr PipelineImpl par, @Cast("int64_t") long nodeId) { super((Pointer)null); allocate(par, nodeId); }
    private native void allocate(@SharedPtr PipelineImpl par, @Cast("int64_t") long nodeId);

    /**
     * Initial config to use when manipulating frames
     */
    @MemberGetter public native @ByRef ImageManipConfig initialConfig();

    /**
     * Input ImageManipConfig message with ability to modify parameters in runtime
     * Default queue is blocking with size 8
     */
    @MemberGetter public native @ByRef Input inputConfig();

    /**
     * Input image to be modified
     * Default queue is blocking with size 8
     */
    @MemberGetter public native @ByRef Input inputImage();

    /**
     * Outputs ImgFrame message that carries modified image.
     */
    @MemberGetter public native @ByRef Output out();

    // Functions to set ImageManipConfig - deprecated
    public native @Deprecated void setCropRect(float xmin, float ymin, float xmax, float ymax);
    public native @Deprecated void setCenterCrop(float ratio, float whRatio/*=1.0f*/);
    public native @Deprecated void setCenterCrop(float ratio);
    public native @Deprecated void setResize(int w, int h);
    public native @Deprecated void setResizeThumbnail(int w, int h, int bgRed/*=0*/, int bgGreen/*=0*/, int bgBlue/*=0*/);
    public native @Deprecated void setResizeThumbnail(int w, int h);
    public native @Deprecated void setFrameType(RawImgFrame.Type name);
    public native @Deprecated void setFrameType(@Cast("dai::RawImgFrame::Type") int name);
    public native @Deprecated void setHorizontalFlip(@Cast("bool") boolean flip);
    public native void setKeepAspectRatio(@Cast("bool") boolean keep);

    // Functions to set properties
    /**
     * Specify whether or not wait until configuration message arrives to inputConfig Input.
     * @param wait True to wait for configuration message, false otherwise
     */
    public native void setWaitForConfigInput(@Cast("bool") boolean _wait);

    /**
     * Specify number of frames in pool.
     * @param numFramesPool How many frames should the pool have
     */
    public native void setNumFramesPool(int numFramesPool);

    /**
     * Specify maximum size of output image.
     * @param maxFrameSize Maximum frame size in bytes
     */
    public native void setMaxOutputFrameSize(int maxFrameSize);
}
