// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/**
 * Specify properties for MonoCamera such as camera ID, ...
 */
@Namespace("dai") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class MonoCameraProperties extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public MonoCameraProperties() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MonoCameraProperties(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MonoCameraProperties(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public MonoCameraProperties position(long position) {
        return (MonoCameraProperties)super.position(position);
    }
    @Override public MonoCameraProperties getPointer(long i) {
        return new MonoCameraProperties((Pointer)this).offsetAddress(i);
    }

    /**
     * Select the camera sensor resolution: 1280??720, 1280??800, 640??400
     */
    public enum SensorResolution { THE_720_P(0), THE_800_P(1), THE_400_P(2);

        public final int value;
        private SensorResolution(int v) { this.value = v; }
        private SensorResolution(SensorResolution e) { this.value = e.value; }
        public SensorResolution intern() { for (SensorResolution e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /*
     * Initial controls applied to MonoCamera node
     */
    public native @ByRef RawCameraControl initialControl(); public native MonoCameraProperties initialControl(RawCameraControl setter);

    /**
     * Which socket will mono camera use
     */
    public native CameraBoardSocket boardSocket(); public native MonoCameraProperties boardSocket(CameraBoardSocket setter);

    /**
     * Camera sensor image orientation / pixel readout
     */
    public native CameraImageOrientation imageOrientation(); public native MonoCameraProperties imageOrientation(CameraImageOrientation setter);

    /**
     * Select the camera sensor resolution
     */
    public native SensorResolution resolution(); public native MonoCameraProperties resolution(SensorResolution setter);
    /**
     * Camera sensor FPS
     */
    public native float fps(); public native MonoCameraProperties fps(float setter);
}
