// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/**
 * Specify properties for NeuralNetwork such as blob path, ...
 */
@Namespace("dai") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class NeuralNetworkProperties extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NeuralNetworkProperties() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NeuralNetworkProperties(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NeuralNetworkProperties(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NeuralNetworkProperties position(long position) {
        return (NeuralNetworkProperties)super.position(position);
    }
    @Override public NeuralNetworkProperties getPointer(long i) {
        return new NeuralNetworkProperties((Pointer)this).offsetAddress(i);
    }

    /**
     * Blob binary size in bytes
     */
    public native @ByRef @Cast("tl::optional<std::uint32_t>*") IntOptional blobSize(); public native NeuralNetworkProperties blobSize(IntOptional setter);
    /**
     * Uri which points to blob
     */
    public native @StdString BytePointer blobUri(); public native NeuralNetworkProperties blobUri(BytePointer setter);
    /**
     * Number of available output tensors in pool
     */
    public native @Cast("std::uint32_t") int numFrames(); public native NeuralNetworkProperties numFrames(int setter);
    /**
     * Number of threads to create for running inference. 0 = auto
     */
    public native @Cast("std::uint32_t") int numThreads(); public native NeuralNetworkProperties numThreads(int setter);
    /**
     * Number of NCE (Neural Compute Engine) per inference thread. 0 = auto
     */
    public native @Cast("std::uint32_t") int numNCEPerThread(); public native NeuralNetworkProperties numNCEPerThread(int setter);
}
