// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/**
 * \brief Abstract Node
 */
@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class Node extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Node(Pointer p) { super(p); }

    /** Node identificator. Unique for every node on a single Pipeline */

    // fwd declare classes

    @MemberGetter public native @Cast("dai::Node::Output**") @StdVector PointerPointer outputs();
    @MemberGetter public native @Cast("dai::Node::Input**") @StdVector PointerPointer inputs();

    @NoOffset public static class DatatypeHierarchy extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public DatatypeHierarchy(Pointer p) { super(p); }
    
        public DatatypeHierarchy(DatatypeEnum d, @Cast("bool") boolean c) { super((Pointer)null); allocate(d, c); }
        private native void allocate(DatatypeEnum d, @Cast("bool") boolean c);
        public DatatypeHierarchy(@Cast("dai::DatatypeEnum") int d, @Cast("bool") boolean c) { super((Pointer)null); allocate(d, c); }
        private native void allocate(@Cast("dai::DatatypeEnum") int d, @Cast("bool") boolean c);
        @MemberGetter public native DatatypeEnum datatype();
        @MemberGetter public native @Cast("bool") boolean descendants();
    }

    @NoOffset public static class Output extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Output(Pointer p) { super(p); }
    
        public enum Type { MSender(0), SSender(1);

            public final int value;
            private Type(int v) { this.value = v; }
            private Type(Type e) { this.value = e.value; }
            public Type intern() { for (Type e : values()) if (e.value == value) return e; return this; }
            @Override public String toString() { return intern().name(); }
        }
        @MemberGetter public native @StdString BytePointer name();
        @MemberGetter public native Type type();
        // Which types and do descendants count as well?
        @MemberGetter public native @StdVector DatatypeHierarchy possibleDatatypes();
        public Output(@ByRef Node par, @StdString BytePointer n, Type t, @StdVector DatatypeHierarchy types) { super((Pointer)null); allocate(par, n, t, types); }
        private native void allocate(@ByRef Node par, @StdString BytePointer n, Type t, @StdVector DatatypeHierarchy types);
        public Output(@ByRef Node par, @StdString String n, @Cast("dai::Node::Output::Type") int t, @StdVector DatatypeHierarchy types) { super((Pointer)null); allocate(par, n, t, types); }
        private native void allocate(@ByRef Node par, @StdString String n, @Cast("dai::Node::Output::Type") int t, @StdVector DatatypeHierarchy types);
        public native @Cast("bool") boolean isSamePipeline(@Const @ByRef Input in);

        public native @ByRef Node getParent();

        /**
         * Check if connection is possible
         * @param in Input to connect to
         * @return True if connection is possible, false otherwise
         */
        public native @Cast("bool") boolean canConnect(@Const @ByRef Input in);

        /**
         * Retrieve all connections from this output
         * @return Vector of connections
         */
        public native @StdVector Connection getConnections();

        /**
         * Link current output to input.
         *
         * Throws an error if this output cannot be linked to given input,
         * or if they are already linked
         *
         * @param in Input to link to
         */
        public native void link(@Const @ByRef Input in);

        /**
         * Unlink a previously linked connection
         *
         * Throws an error if not linked.
         *
         * @param in Input from which to unlink from
         */
        public native void unlink(@Const @ByRef Input in);
    }

    @NoOffset public static class Input extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Input(Pointer p) { super(p); }
    
        public enum Type { SReceiver(0), MReceiver(1);

            public final int value;
            private Type(int v) { this.value = v; }
            private Type(Type e) { this.value = e.value; }
            public Type intern() { for (Type e : values()) if (e.value == value) return e; return this; }
            @Override public String toString() { return intern().name(); }
        }
        @MemberGetter public native @StdString BytePointer name();
        @MemberGetter public native Type type();
        @MemberGetter public native @Cast("bool") boolean defaultBlocking();
        @MemberGetter public native int defaultQueueSize();
        @MemberGetter public native @ByRef BoolOptional blocking();
        @MemberGetter public native @ByRef @Cast("tl::optional<int>*") IntOptional queueSize();
        @MemberGetter public native @StdVector DatatypeHierarchy possibleDatatypes();

        /** Constructs Input with default blocking and queueSize options */
        public Input(@ByRef Node par, @StdString BytePointer n, Type t, @StdVector DatatypeHierarchy types) { super((Pointer)null); allocate(par, n, t, types); }
        private native void allocate(@ByRef Node par, @StdString BytePointer n, Type t, @StdVector DatatypeHierarchy types);
        public Input(@ByRef Node par, @StdString String n, @Cast("dai::Node::Input::Type") int t, @StdVector DatatypeHierarchy types) { super((Pointer)null); allocate(par, n, t, types); }
        private native void allocate(@ByRef Node par, @StdString String n, @Cast("dai::Node::Input::Type") int t, @StdVector DatatypeHierarchy types);

        /** Constructs Input with specified blocking and queueSize options */
        public Input(@ByRef Node par, @StdString BytePointer n, Type t, @Cast("bool") boolean blocking, int queueSize, @StdVector DatatypeHierarchy types) { super((Pointer)null); allocate(par, n, t, blocking, queueSize, types); }
        private native void allocate(@ByRef Node par, @StdString BytePointer n, Type t, @Cast("bool") boolean blocking, int queueSize, @StdVector DatatypeHierarchy types);
        public Input(@ByRef Node par, @StdString String n, @Cast("dai::Node::Input::Type") int t, @Cast("bool") boolean blocking, int queueSize, @StdVector DatatypeHierarchy types) { super((Pointer)null); allocate(par, n, t, blocking, queueSize, types); }
        private native void allocate(@ByRef Node par, @StdString String n, @Cast("dai::Node::Input::Type") int t, @Cast("bool") boolean blocking, int queueSize, @StdVector DatatypeHierarchy types);

        public native @ByRef Node getParent();

        /**
         * Overrides default input queue behavior.
         * @param blocking True blocking, false overwriting
         */
        public native void setBlocking(@Cast("bool") boolean blocking);

        /**
         * Get input queue behavior
         * @return True blocking, false overwriting
         */
        public native @Cast("bool") boolean getBlocking();

        /**
         * Overrides default input queue size.
         * If queue size fills up, behavior depends on {@code blocking} attribute
         * @param size Maximum input queue size
         */
        public native void setQueueSize(int size);

        /**
         * Get input queue size.
         * @return Maximum input queue size
         */
        public native int getQueueSize();
    }

    // when Pipeline tries to serialize and construct on remote, it will check if all connected nodes are on same pipeline
    @MemberGetter public native @ByRef AssetManager assetManager();

    public native @ByVal @Cast("nlohmann::json*") Pointer getProperties();
    public native @ByVal VersionOptional getRequiredOpenVINOVersion();
    public native @SharedPtr @ByVal Node clone();
    /** Id of node */
    @MemberGetter public native @Cast("const dai::Node::Id") long id();

    // access
    public native @ByVal Pipeline getParentPipeline();

    /** Retrieves nodes name */
    public native @StdString BytePointer getName();
    /** Retrieves all nodes outputs */
    public native @StdVector Output getOutputs();
    /** Retrieves all nodes inputs */
    public native @StdVector Input getInputs();
    /** Retrieves all nodes assets */
    public native @ByVal AssetVector getAssets();

    /** Retrieves reference to node outputs */
    public native @Cast("dai::Node::Output**") @StdVector PointerPointer getOutputRefs();
    /** Retrieves reference to node outputs */
    /** Retrieves reference to node inputs */
    public native @Cast("dai::Node::Input**") @StdVector PointerPointer getInputRefs();
    /** Retrieves reference to node inputs */

    /** Connection between an Input and Output */
    @NoOffset public static class Connection extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Connection(Pointer p) { super(p); }
    
        public Connection(@ByVal Output out, @ByVal Input in) { super((Pointer)null); allocate(out, in); }
        private native void allocate(@ByVal Output out, @ByVal Input in);
        @MemberGetter public native @Cast("dai::Node::Id") long outputId();
        @MemberGetter public native @StdString BytePointer outputName();
        @MemberGetter public native @Cast("dai::Node::Id") long inputId();
        @MemberGetter public native @StdString BytePointer inputName();
        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef Connection rhs);
    }
}
