// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;

@Name("std::vector<std::shared_ptr<dai::Node> >") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class NodeVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NodeVector(Pointer p) { super(p); }
    public NodeVector(Node value) { this(1); put(0, value); }
    public NodeVector(Node ... array) { this(array.length); put(array); }
    public NodeVector()       { allocate();  }
    public NodeVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef NodeVector put(@ByRef NodeVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index(function = "at") public native @SharedPtr Node get(@Cast("size_t") long i);
    public native NodeVector put(@Cast("size_t") long i, Node value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, @SharedPtr Node value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator ++") @ByRef Iterator increment();
        public native @Name("operator ==") boolean equals(@ByRef Iterator it);
        public native @Name("operator *") @SharedPtr @Const Node get();
    }

    public Node[] get() {
        Node[] array = new Node[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public Node pop_back() {
        long size = size();
        Node value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public NodeVector push_back(Node value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public NodeVector put(Node value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public NodeVector put(Node ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

