// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/** RawCameraControl structure */
@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class RawCameraControl extends RawBuffer {
    static { Loader.load(); }
    /** Default native constructor. */
    public RawCameraControl() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public RawCameraControl(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RawCameraControl(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public RawCameraControl position(long position) {
        return (RawCameraControl)super.position(position);
    }
    @Override public RawCameraControl getPointer(long i) {
        return new RawCameraControl((Pointer)this).offsetAddress(i);
    }

    public enum Command {
        START_STREAM((byte)(1)),
        STOP_STREAM((byte)(2)),
        STILL_CAPTURE((byte)(3)),
        MOVE_LENS((byte)(4)), /* [1] lens position: 0-255
                        */
        AF_TRIGGER((byte)(5)),
        AE_MANUAL((byte)(6)), /* [1] exposure time [us]
                        * [2] sensitivity [iso]
                        * [3] frame duration [us]
                        */
        AE_AUTO((byte)(7)),
        AWB_MODE((byte)(8)),                  /* [1] awb_mode: AutoWhiteBalanceMode
                                        */
        SCENE_MODE((byte)(9)),                /* [1] scene_mode: SceneMode
                                        */
        ANTIBANDING_MODE((byte)(10)),         /* [1] antibanding_mode: AntiBandingMode
                                        */
        EXPOSURE_COMPENSATION((byte)(11)),    /* [1] value
                                        */
        AE_LOCK((byte)(13)),                  /* [1] ae_lock_mode: bool
                                        */
        AE_TARGET_FPS_RANGE((byte)(14)),      /* [1] min_fps
                                        * [2] max_fps
                                        */
        AWB_LOCK((byte)(16)),                 /* [1] awb_lock_mode: bool
                                        */
        CAPTURE_INTENT((byte)(17)),           /* [1] capture_intent_mode: CaptureIntent
                                        */
        CONTROL_MODE((byte)(18)),             /* [1] control_mode: ControlMode
                                        */
        FRAME_DURATION((byte)(21)),           /* [1] frame_duration
                                        */
        SENSITIVITY((byte)(23)),              /* [1] iso_val
                                        */
        EFFECT_MODE((byte)(24)),              /* [1] effect_mode: EffectMode
                                        */
        AF_MODE((byte)(26)),                  /* [1] af_mode: AutoFocusMode
                                        */
        NOISE_REDUCTION_STRENGTH((byte)(27)), /* [1] value
                                        */
        SATURATION((byte)(28)),               /* [1] value
                                        */
        BRIGHTNESS((byte)(31)),               /* [1] value
                                        */
        STREAM_FORMAT((byte)(33)),            /* [1] format
                                        */
        RESOLUTION((byte)(34)),               /* [1] width
                                        * [2] height
                                        */
        SHARPNESS((byte)(35)),                /* [1] value
                                        */
        CUSTOM_USECASE((byte)(40)),           /* [1] value
                                        */
        CUSTOM_CAPT_MODE((byte)(41)),         /* [1] value
                                        */
        CUSTOM_EXP_BRACKETS((byte)(42)),      /* [1] val1
                                        * [2] val2
                                        * [3] val3
                                        */
        CUSTOM_CAPTURE((byte)(43)),           /* [1] value
                                        */
        CONTRAST((byte)(44)),                 /* [1] value
                                        */
        AE_REGION((byte)(45)),                /* [1] x
                                        * [2] y
                                        * [3] width
                                        * [4] height
                                        * [5] priority
                                        */
        AF_REGION((byte)(46)),                /* [1] x
                                        * [2] y
                                        * [3] width
                                        * [4] height
                                        * [5] priority
                                        */
        LUMA_DENOISE((byte)(47)),             /* [1] value
                                        */
        CHROMA_DENOISE((byte)(48));          /* [1] value
                                        */

        public final byte value;
        private Command(byte v) { this.value = v; }
        private Command(Command e) { this.value = e.value; }
        public Command intern() { for (Command e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum AutoFocusMode {
        /** Autofocus disabled. Suitable for manual focus */
        OFF((byte)(0)),
        /** Runs autofocus once at startup, and at subsequent trigger commands */
        AUTO((byte)(1)),
        /** TODO */
        MACRO((byte)(2)),
        /** Runs autofocus when the scene is detected as out-of-focus */
        CONTINUOUS_VIDEO((byte)(3)),
        CONTINUOUS_PICTURE((byte)(4)),
        EDOF((byte)(5));

        public final byte value;
        private AutoFocusMode(byte v) { this.value = v; }
        private AutoFocusMode(AutoFocusMode e) { this.value = e.value; }
        public AutoFocusMode intern() { for (AutoFocusMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum AutoWhiteBalanceMode {
        OFF((byte)(0)),
        AUTO((byte)(1)),
        INCANDESCENT((byte)(2)),
        FLUORESCENT((byte)(3)),
        WARM_FLUORESCENT((byte)(4)),
        DAYLIGHT((byte)(5)),
        CLOUDY_DAYLIGHT((byte)(6)),
        TWILIGHT((byte)(7)),
        SHADE((byte)(8));

        public final byte value;
        private AutoWhiteBalanceMode(byte v) { this.value = v; }
        private AutoWhiteBalanceMode(AutoWhiteBalanceMode e) { this.value = e.value; }
        public AutoWhiteBalanceMode intern() { for (AutoWhiteBalanceMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum SceneMode {
        UNSUPPORTED((byte)(0)),
        FACE_PRIORITY((byte)(1)),
        ACTION((byte)(2)),
        PORTRAIT((byte)(3)),
        LANDSCAPE((byte)(4)),
        NIGHT((byte)(5)),
        NIGHT_PORTRAIT((byte)(6)),
        THEATRE((byte)(7)),
        BEACH((byte)(8)),
        SNOW((byte)(9)),
        SUNSET((byte)(10)),
        STEADYPHOTO((byte)(11)),
        FIREWORKS((byte)(12)),
        SPORTS((byte)(13)),
        PARTY((byte)(14)),
        CANDLELIGHT((byte)(15)),
        BARCODE((byte)(16));

        public final byte value;
        private SceneMode(byte v) { this.value = v; }
        private SceneMode(SceneMode e) { this.value = e.value; }
        public SceneMode intern() { for (SceneMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum AntiBandingMode {
        OFF((byte)(0)),
        MAINS_50_HZ((byte)(1)),
        MAINS_60_HZ((byte)(2)),
        AUTO((byte)(3));

        public final byte value;
        private AntiBandingMode(byte v) { this.value = v; }
        private AntiBandingMode(AntiBandingMode e) { this.value = e.value; }
        public AntiBandingMode intern() { for (AntiBandingMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum CaptureIntent {
        CUSTOM((byte)(0)),
        PREVIEW((byte)(1)),
        STILL_CAPTURE((byte)(2)),
        VIDEO_RECORD((byte)(3)),
        VIDEO_SNAPSHOT((byte)(4)),
        ZERO_SHUTTER_LAG((byte)(5));

        public final byte value;
        private CaptureIntent(byte v) { this.value = v; }
        private CaptureIntent(CaptureIntent e) { this.value = e.value; }
        public CaptureIntent intern() { for (CaptureIntent e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum ControlMode {
        OFF((byte)(0)),
        AUTO((byte)(1)),
        USE_SCENE_MODE((byte)(2));

        public final byte value;
        private ControlMode(byte v) { this.value = v; }
        private ControlMode(ControlMode e) { this.value = e.value; }
        public ControlMode intern() { for (ControlMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public enum EffectMode {
        OFF((byte)(0)),
        MONO((byte)(1)),
        NEGATIVE((byte)(2)),
        SOLARIZE((byte)(3)),
        SEPIA((byte)(4)),
        POSTERIZE((byte)(5)),
        WHITEBOARD((byte)(6)),
        BLACKBOARD((byte)(7)),
        AQUA((byte)(8));

        public final byte value;
        private EffectMode(byte v) { this.value = v; }
        private EffectMode(EffectMode e) { this.value = e.value; }
        public EffectMode intern() { for (EffectMode e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public static class ManualExposureParams extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public ManualExposureParams() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ManualExposureParams(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ManualExposureParams(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public ManualExposureParams position(long position) {
            return (ManualExposureParams)super.position(position);
        }
        @Override public ManualExposureParams getPointer(long i) {
            return new ManualExposureParams((Pointer)this).offsetAddress(i);
        }
    
        public native @Cast("uint32_t") int exposureTimeUs(); public native ManualExposureParams exposureTimeUs(int setter);
        public native @Cast("uint32_t") int sensitivityIso(); public native ManualExposureParams sensitivityIso(int setter);
        public native @Cast("uint32_t") int frameDurationUs(); public native ManualExposureParams frameDurationUs(int setter);
    }

    // AE_REGION / AF_REGION
    public static class RegionParams extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public RegionParams() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public RegionParams(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public RegionParams(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public RegionParams position(long position) {
            return (RegionParams)super.position(position);
        }
        @Override public RegionParams getPointer(long i) {
            return new RegionParams((Pointer)this).offsetAddress(i);
        }
    
        public native @Cast("uint16_t") short x(); public native RegionParams x(short setter);
        public native @Cast("uint16_t") short y(); public native RegionParams y(short setter);
        public native @Cast("uint16_t") short width(); public native RegionParams width(short setter);
        public native @Cast("uint16_t") short height(); public native RegionParams height(short setter);
        // Set to 1 for now. TODO
        public native @Cast("uint32_t") int priority(); public native RegionParams priority(int setter);
    }

    public native @Cast("uint64_t") long cmdMask(); public native RawCameraControl cmdMask(long setter);

    public native AutoFocusMode autoFocusMode(); public native RawCameraControl autoFocusMode(AutoFocusMode setter);

    /**
     * Lens/VCM position, range: 0..255. Used with {@code autoFocusMode = OFF}.
     * With current IMX378 modules:
     * - max 255: macro focus, at 8cm distance
     * - infinite focus at about 120..130 (may vary from module to module)
     * - lower values lead to out-of-focus (lens too close to the sensor array)
     */
    public native @Cast("uint8_t") byte lensPosition(); public native RawCameraControl lensPosition(byte setter);

    public native @ByRef ManualExposureParams expManual(); public native RawCameraControl expManual(ManualExposureParams setter);
    public native @ByRef RegionParams aeRegion(); public native RawCameraControl aeRegion(RegionParams setter);
    public native @ByRef RegionParams afRegion(); public native RawCameraControl afRegion(RegionParams setter);
    public native AutoWhiteBalanceMode awbMode(); public native RawCameraControl awbMode(AutoWhiteBalanceMode setter);
    public native SceneMode sceneMode(); public native RawCameraControl sceneMode(SceneMode setter);
    public native AntiBandingMode antiBandingMode(); public native RawCameraControl antiBandingMode(AntiBandingMode setter);
    public native EffectMode effectMode(); public native RawCameraControl effectMode(EffectMode setter);
    public native @Cast("bool") boolean aeLockMode(); public native RawCameraControl aeLockMode(boolean setter);
    public native @Cast("bool") boolean awbLockMode(); public native RawCameraControl awbLockMode(boolean setter);
    public native byte expCompensation(); public native RawCameraControl expCompensation(byte setter);  //  -9 ..  9
    public native byte brightness(); public native RawCameraControl brightness(byte setter);       // -10 .. 10
    public native byte contrast(); public native RawCameraControl contrast(byte setter);         // -10 .. 10
    public native byte saturation(); public native RawCameraControl saturation(byte setter);       // -10 .. 10
    public native @Cast("uint8_t") byte sharpness(); public native RawCameraControl sharpness(byte setter);       //   0 ..  4
    public native @Cast("uint8_t") byte lumaDenoise(); public native RawCameraControl lumaDenoise(byte setter);     //   0 ..  4
    public native @Cast("uint8_t") byte chromaDenoise(); public native RawCameraControl chromaDenoise(byte setter);   //   0 ..  4

    public native void setCommand(Command cmd, @Cast("bool") boolean value/*=true*/);
    public native void setCommand(Command cmd);
    public native void setCommand(@Cast("dai::RawCameraControl::Command") byte cmd, @Cast("bool") boolean value/*=true*/);
    public native void setCommand(@Cast("dai::RawCameraControl::Command") byte cmd);
    public native void clearCommand(Command cmd);
    public native void clearCommand(@Cast("dai::RawCameraControl::Command") byte cmd);
    public native @Cast("bool") boolean getCommand(Command cmd);
    public native @Cast("bool") boolean getCommand(@Cast("dai::RawCameraControl::Command") byte cmd);

    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector BytePointer metadata, @ByRef @Cast("dai::DatatypeEnum*") IntPointer datatype);
    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector ByteBuffer metadata, @ByRef @Cast("dai::DatatypeEnum*") IntBuffer datatype);
    public native @Override void serialize(@Cast("std::uint8_t*") @StdVector byte[] metadata, @ByRef @Cast("dai::DatatypeEnum*") int[] datatype);
}
