// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/**
 * SpatialLocationCalculatorConfig message. Carries ROI (region of interest) and threshold for depth calculation
 */
@Namespace("dai") @NoOffset @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class SpatialLocationCalculatorConfig extends Buffer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SpatialLocationCalculatorConfig(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public SpatialLocationCalculatorConfig(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public SpatialLocationCalculatorConfig position(long position) {
        return (SpatialLocationCalculatorConfig)super.position(position);
    }
    @Override public SpatialLocationCalculatorConfig getPointer(long i) {
        return new SpatialLocationCalculatorConfig((Pointer)this).offsetAddress(i);
    }

    /**
     * Construct SpatialLocationCalculatorConfig message.
     */
    public SpatialLocationCalculatorConfig() { super((Pointer)null); allocate(); }
    private native void allocate();
    public SpatialLocationCalculatorConfig(@SharedPtr RawSpatialLocationCalculatorConfig ptr) { super((Pointer)null); allocate(ptr); }
    private native void allocate(@SharedPtr RawSpatialLocationCalculatorConfig ptr);

    /**
     * Set a vector of ROIs as configuration data.
     * @param ROIs Vector of configuration parameters for ROIs (region of interests)
     */
    public native void setROIs(@StdVector SpatialLocationCalculatorConfigData ROIs);
    /**
     * Add a new ROI to configuration data.
     * @param roi Configuration parameters for ROI (region of interest)
     */
    public native void addROI(@ByRef SpatialLocationCalculatorConfigData ROI);

    /**
     * Retrieve configuration data for SpatialLocationCalculator
     * @return Vector of configuration parameters for ROIs (region of interests)
     */
    public native @StdVector SpatialLocationCalculatorConfigData getConfigData();
}
