// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.depthai;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.depthai.global.depthai.*;


/** StereoDepth configuration data structure */
@Namespace("dai") @Properties(inherit = org.bytedeco.depthai.presets.depthai.class)
public class StereoDepthConfigData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public StereoDepthConfigData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public StereoDepthConfigData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StereoDepthConfigData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public StereoDepthConfigData position(long position) {
        return (StereoDepthConfigData)super.position(position);
    }
    @Override public StereoDepthConfigData getPointer(long i) {
        return new StereoDepthConfigData((Pointer)this).offsetAddress(i);
    }


    /**
     * Set kernel size for disparity/depth median filtering, or disable
     */
    public native MedianFilter median(); public native StereoDepthConfigData median(MedianFilter setter);

    /**
     * Confidence threshold for disparity calculation, 0..255
     */
    public native @Cast("std::int32_t") int confidenceThreshold(); public native StereoDepthConfigData confidenceThreshold(int setter);

    /**
     * Sigma value for bilateral filter. 0 means disabled
     * A larger value of the parameter means that farther colors within the pixel neighborhood will be mixed together.
     */
    public native @Cast("std::int16_t") short bilateralSigmaValue(); public native StereoDepthConfigData bilateralSigmaValue(short setter);

    /**
     * Left-right check threshold for left-right, right-left disparity map combine, 0..128
     * Used only when left-right check mode is enabled.
     * Defines the maximum difference between the confidence of pixels from left-right and right-left confidence maps
     */
    public native @Cast("std::int32_t") int leftRightCheckThreshold(); public native StereoDepthConfigData leftRightCheckThreshold(int setter);
}
