/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bytedeco.depthai.RawBuffer;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdVector;

@Namespace(value="dai")
@NoOffset
@Properties(inherit={depthai.class})
public class RawCameraControl
extends RawBuffer {
    public RawCameraControl() {
        super(null);
        this.allocate();
    }

    public RawCameraControl(long size) {
        super(null);
        this.allocateArray(size);
    }

    public RawCameraControl(Pointer p) {
        super(p);
    }

    private native void allocate();

    private native void allocateArray(long var1);

    @Override
    public RawCameraControl position(long position) {
        return (RawCameraControl)super.position(position);
    }

    @Override
    public RawCameraControl getPointer(long i) {
        return (RawCameraControl)new RawCameraControl(this).offsetAddress(i);
    }

    @Cast(value={"uint64_t"})
    public native long cmdMask();

    public native RawCameraControl cmdMask(long var1);

    public native AutoFocusMode autoFocusMode();

    public native RawCameraControl autoFocusMode(AutoFocusMode var1);

    @Cast(value={"uint8_t"})
    public native byte lensPosition();

    public native RawCameraControl lensPosition(byte var1);

    @ByRef
    public native ManualExposureParams expManual();

    public native RawCameraControl expManual(ManualExposureParams var1);

    @ByRef
    public native RegionParams aeRegion();

    public native RawCameraControl aeRegion(RegionParams var1);

    @ByRef
    public native RegionParams afRegion();

    public native RawCameraControl afRegion(RegionParams var1);

    public native AutoWhiteBalanceMode awbMode();

    public native RawCameraControl awbMode(AutoWhiteBalanceMode var1);

    public native SceneMode sceneMode();

    public native RawCameraControl sceneMode(SceneMode var1);

    public native AntiBandingMode antiBandingMode();

    public native RawCameraControl antiBandingMode(AntiBandingMode var1);

    public native EffectMode effectMode();

    public native RawCameraControl effectMode(EffectMode var1);

    @Cast(value={"bool"})
    public native boolean aeLockMode();

    public native RawCameraControl aeLockMode(boolean var1);

    @Cast(value={"bool"})
    public native boolean awbLockMode();

    public native RawCameraControl awbLockMode(boolean var1);

    public native byte expCompensation();

    public native RawCameraControl expCompensation(byte var1);

    public native byte brightness();

    public native RawCameraControl brightness(byte var1);

    public native byte contrast();

    public native RawCameraControl contrast(byte var1);

    public native byte saturation();

    public native RawCameraControl saturation(byte var1);

    @Cast(value={"uint8_t"})
    public native byte sharpness();

    public native RawCameraControl sharpness(byte var1);

    @Cast(value={"uint8_t"})
    public native byte lumaDenoise();

    public native RawCameraControl lumaDenoise(byte var1);

    @Cast(value={"uint8_t"})
    public native byte chromaDenoise();

    public native RawCameraControl chromaDenoise(byte var1);

    public native void setCommand(Command var1, @Cast(value={"bool"}) boolean var2);

    public native void setCommand(Command var1);

    public native void setCommand(@Cast(value={"dai::RawCameraControl::Command"}) byte var1, @Cast(value={"bool"}) boolean var2);

    public native void setCommand(@Cast(value={"dai::RawCameraControl::Command"}) byte var1);

    public native void clearCommand(Command var1);

    public native void clearCommand(@Cast(value={"dai::RawCameraControl::Command"}) byte var1);

    @Cast(value={"bool"})
    public native boolean getCommand(Command var1);

    @Cast(value={"bool"})
    public native boolean getCommand(@Cast(value={"dai::RawCameraControl::Command"}) byte var1);

    @Override
    public native void serialize(@Cast(value={"std::uint8_t*"}) @StdVector BytePointer var1, @ByRef @Cast(value={"dai::DatatypeEnum*"}) IntPointer var2);

    @Override
    public native void serialize(@Cast(value={"std::uint8_t*"}) @StdVector ByteBuffer var1, @ByRef @Cast(value={"dai::DatatypeEnum*"}) IntBuffer var2);

    @Override
    public native void serialize(@Cast(value={"std::uint8_t*"}) @StdVector byte[] var1, @ByRef @Cast(value={"dai::DatatypeEnum*"}) int[] var2);

    static {
        Loader.load();
    }

    public static class RegionParams
    extends Pointer {
        public RegionParams() {
            super((Pointer)null);
            this.allocate();
        }

        public RegionParams(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public RegionParams(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public RegionParams position(long position) {
            return (RegionParams)super.position(position);
        }

        public RegionParams getPointer(long i) {
            return (RegionParams)new RegionParams(this).offsetAddress(i);
        }

        @Cast(value={"uint16_t"})
        public native short x();

        public native RegionParams x(short var1);

        @Cast(value={"uint16_t"})
        public native short y();

        public native RegionParams y(short var1);

        @Cast(value={"uint16_t"})
        public native short width();

        public native RegionParams width(short var1);

        @Cast(value={"uint16_t"})
        public native short height();

        public native RegionParams height(short var1);

        @Cast(value={"uint32_t"})
        public native int priority();

        public native RegionParams priority(int var1);

        static {
            Loader.load();
        }
    }

    public static class ManualExposureParams
    extends Pointer {
        public ManualExposureParams() {
            super((Pointer)null);
            this.allocate();
        }

        public ManualExposureParams(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public ManualExposureParams(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public ManualExposureParams position(long position) {
            return (ManualExposureParams)super.position(position);
        }

        public ManualExposureParams getPointer(long i) {
            return (ManualExposureParams)new ManualExposureParams(this).offsetAddress(i);
        }

        @Cast(value={"uint32_t"})
        public native int exposureTimeUs();

        public native ManualExposureParams exposureTimeUs(int var1);

        @Cast(value={"uint32_t"})
        public native int sensitivityIso();

        public native ManualExposureParams sensitivityIso(int var1);

        @Cast(value={"uint32_t"})
        public native int frameDurationUs();

        public native ManualExposureParams frameDurationUs(int var1);

        static {
            Loader.load();
        }
    }

    public static enum EffectMode {
        OFF(0),
        MONO(1),
        NEGATIVE(2),
        SOLARIZE(3),
        SEPIA(4),
        POSTERIZE(5),
        WHITEBOARD(6),
        BLACKBOARD(7),
        AQUA(8);

        public final byte value;

        private EffectMode(byte v) {
            this.value = v;
        }

        private EffectMode(EffectMode e) {
            this.value = e.value;
        }

        public EffectMode intern() {
            for (EffectMode e : EffectMode.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }

    public static enum ControlMode {
        OFF(0),
        AUTO(1),
        USE_SCENE_MODE(2);

        public final byte value;

        private ControlMode(byte v) {
            this.value = v;
        }

        private ControlMode(ControlMode e) {
            this.value = e.value;
        }

        public ControlMode intern() {
            for (ControlMode e : ControlMode.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }

    public static enum CaptureIntent {
        CUSTOM(0),
        PREVIEW(1),
        STILL_CAPTURE(2),
        VIDEO_RECORD(3),
        VIDEO_SNAPSHOT(4),
        ZERO_SHUTTER_LAG(5);

        public final byte value;

        private CaptureIntent(byte v) {
            this.value = v;
        }

        private CaptureIntent(CaptureIntent e) {
            this.value = e.value;
        }

        public CaptureIntent intern() {
            for (CaptureIntent e : CaptureIntent.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }

    public static enum AntiBandingMode {
        OFF(0),
        MAINS_50_HZ(1),
        MAINS_60_HZ(2),
        AUTO(3);

        public final byte value;

        private AntiBandingMode(byte v) {
            this.value = v;
        }

        private AntiBandingMode(AntiBandingMode e) {
            this.value = e.value;
        }

        public AntiBandingMode intern() {
            for (AntiBandingMode e : AntiBandingMode.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }

    public static enum SceneMode {
        UNSUPPORTED(0),
        FACE_PRIORITY(1),
        ACTION(2),
        PORTRAIT(3),
        LANDSCAPE(4),
        NIGHT(5),
        NIGHT_PORTRAIT(6),
        THEATRE(7),
        BEACH(8),
        SNOW(9),
        SUNSET(10),
        STEADYPHOTO(11),
        FIREWORKS(12),
        SPORTS(13),
        PARTY(14),
        CANDLELIGHT(15),
        BARCODE(16);

        public final byte value;

        private SceneMode(byte v) {
            this.value = v;
        }

        private SceneMode(SceneMode e) {
            this.value = e.value;
        }

        public SceneMode intern() {
            for (SceneMode e : SceneMode.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }

    public static enum AutoWhiteBalanceMode {
        OFF(0),
        AUTO(1),
        INCANDESCENT(2),
        FLUORESCENT(3),
        WARM_FLUORESCENT(4),
        DAYLIGHT(5),
        CLOUDY_DAYLIGHT(6),
        TWILIGHT(7),
        SHADE(8);

        public final byte value;

        private AutoWhiteBalanceMode(byte v) {
            this.value = v;
        }

        private AutoWhiteBalanceMode(AutoWhiteBalanceMode e) {
            this.value = e.value;
        }

        public AutoWhiteBalanceMode intern() {
            for (AutoWhiteBalanceMode e : AutoWhiteBalanceMode.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }

    public static enum AutoFocusMode {
        OFF(0),
        AUTO(1),
        MACRO(2),
        CONTINUOUS_VIDEO(3),
        CONTINUOUS_PICTURE(4),
        EDOF(5);

        public final byte value;

        private AutoFocusMode(byte v) {
            this.value = v;
        }

        private AutoFocusMode(AutoFocusMode e) {
            this.value = e.value;
        }

        public AutoFocusMode intern() {
            for (AutoFocusMode e : AutoFocusMode.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }

    public static enum Command {
        START_STREAM(1),
        STOP_STREAM(2),
        STILL_CAPTURE(3),
        MOVE_LENS(4),
        AF_TRIGGER(5),
        AE_MANUAL(6),
        AE_AUTO(7),
        AWB_MODE(8),
        SCENE_MODE(9),
        ANTIBANDING_MODE(10),
        EXPOSURE_COMPENSATION(11),
        AE_LOCK(13),
        AE_TARGET_FPS_RANGE(14),
        AWB_LOCK(16),
        CAPTURE_INTENT(17),
        CONTROL_MODE(18),
        FRAME_DURATION(21),
        SENSITIVITY(23),
        EFFECT_MODE(24),
        AF_MODE(26),
        NOISE_REDUCTION_STRENGTH(27),
        SATURATION(28),
        BRIGHTNESS(31),
        STREAM_FORMAT(33),
        RESOLUTION(34),
        SHARPNESS(35),
        CUSTOM_USECASE(40),
        CUSTOM_CAPT_MODE(41),
        CUSTOM_EXP_BRACKETS(42),
        CUSTOM_CAPTURE(43),
        CONTRAST(44),
        AE_REGION(45),
        AF_REGION(46),
        LUMA_DENOISE(47),
        CHROMA_DENOISE(48);

        public final byte value;

        private Command(byte v) {
            this.value = v;
        }

        private Command(Command e) {
            this.value = e.value;
        }

        public Command intern() {
            for (Command e : Command.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }
}

