// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.dnnl;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.dnnl.global.dnnl.*;


/** \} dnnl_api_stream
 <p>
 *  \addtogroup dnnl_api_memory Memory
 * 
 *  A container that describes and stores data. Memory objects can contain
 *  data of various types and formats. There are two levels of abstraction:
 * 
 *  1. **Memory descriptor** -- engine-agnostic logical description of data
 *      (number of dimensions, dimension sizes, and data type), and,
 *      optionally, the information about the physical format of data in
 *      memory. If this information is not known yet, a memory descriptor can
 *      be created with #dnnl::memory::format_tag::any. This allows
 *      compute-intensive primitives to choose the best format for
 *      computation. The user is responsible for reordering the data into the
 *      chosen format when formats do not match.
 * 
 *      A memory descriptor can be initialized either by specifying dimensions
 *      and a memory format tag or strides for each of them, or by
 *      manipulating the dnnl_memory_desc_t structure directly.
 * 
 *      \warning
 *          The latter approach requires understanding how the physical data
 *          representation is mapped to the structure and is discouraged. This
 *          topic is discussed in \ref dev_guide_understanding_memory_formats.
 * 
 *      The user can query the amount of memory required by a memory
 *      descriptor using the #dnnl::memory::desc::get_size() function. The
 *      size of data in general cannot be computed as the product of
 *      dimensions multiplied by the size of the data type. So users are
 *      required to use this function for better code portability.
 * 
 *      Two memory descriptors can be compared using the equality and
 *      inequality operators.  The comparison is especially useful when
 *      checking whether it is necessary to reorder data from the user's data
 *      format to a primitive's format.
 * 
 *  2. **Memory object** -- an engine-specific object that handles the data
 *      and its description (a memory descriptor). For the CPU aengine, the
 *      data handle is simply a pointer to \c void. The data handle can be
 *      queried using #dnnl::memory::get_data_handle() and set using
 *      #dnnl::memory::set_data_handle(). A memory object can also be
 *      queried for the underlying memory descriptor and for its engine using
 *      #dnnl::memory::get_desc() and dnnl::memory::get_engine().
 * 
 *  Along with ordinary memory descriptors with all dimensions being positive,
 *  the library supports *zero-volume*  memory descriptors with one or more
 *  dimensions set to zero. This is used to support the NumPy\* convention.
 *  If a zero-volume memory is passed to a primitive, the primitive typically
 *  does not perform any computations with this memory. For example:
 * 
 *  - A concatenation primitive would ignore all memory object with zeroes in
 *    the concat dimension / axis.
 * 
 *  - A forward convolution with a source memory object with zero in the
 *    minibatch dimension would always produce a destination memory object
 *    with a zero in the minibatch dimension and perform no computations.
 * 
 *  - However, a forward convolution with a zero in one of the weights
 *    dimensions is ill-defined and is considered to be an error by the
 *    library because there is no clear definition of what the output values
 *    should be.
 * 
 *  Data handle of a zero-volume memory is never accessed.
 * 
 *  \{
 <p>
 *  Memory object.
 * 
 *  A memory object encapsulates a handle to a memory buffer allocated on a
 *  specific aengine, tensor dimensions, data type, and memory format, which is
 *  the way tensor indices map to offsets in linear memory space. Memory
 *  objects are passed to primitives during execution. */
@Namespace("dnnl") @Properties(inherit = org.bytedeco.dnnl.presets.dnnl.class)
public class memory extends dnnl_memory_handle {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public memory(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public memory(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public memory position(long position) {
        return (memory)super.position(position);
    }
    @Override public memory getPointer(long i) {
        return new memory(this).position(position + i);
    }

    /** Integer type for representing dimension sizes and indices. */
    /** Vector of dimensions. Implementations are free to force a limit on the
     *  vector's length. */
    
    ///

    /** Helper function that validates that an {@code std::vector} of dimensions can
     *  be safely converted to the C API array ::dnnl_dims_t. Throws if
     *  validation fails.
     * 
     *  @param v Vector of dimensions.
     *  @param min_size Minimum expected size of the vector. */

    /** Data type specification. */
    public enum data_type {
        /** Undefined data type (used for empty memory descriptors). */
        undef(dnnl_data_type_undef),
        /** 16-bit/half-precision floating point. */
        f16(dnnl_f16),
        /** non-standard 16-bit floating point with 7-bit mantissa. */
        bf16(dnnl_bf16),
        /** 32-bit/single-precision floating point. */
        f32(dnnl_f32),
        /** 32-bit signed integer. */
        s32(dnnl_s32),
        /** 8-bit signed integer. */
        s8(dnnl_s8),
        /** 8-bit unsigned integer. */
        u8(dnnl_u8);

        public final int value;
        private data_type(int v) { this.value = v; }
        private data_type(data_type e) { this.value = e.value; }
        public data_type intern() { for (data_type e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /** Memory format kind */
    public enum format_kind {
        /** Undefined memory format kind, used for empty memory descriptors. */
        undef(dnnl_format_kind_undef),
        /** Unspecified format kind.
         *  The primitive selects a format automatically. */
        any(dnnl_format_kind_any),
        /** A tensor in a generic format described by the stride and blocking
         *  values in each dimension. See \ref dnnl_blocking_desc_t for more
         *  information. */
        blocked(dnnl_blocked),
        /** Weights format used in 8-bit Winograd convolution. */
        wino(dnnl_format_kind_wino),
        /** Packed weights format used in RNN. */
        packed(dnnl_format_kind_rnn_packed);

        public final int value;
        private format_kind(int v) { this.value = v; }
        private format_kind(format_kind e) { this.value = e.value; }
        public format_kind intern() { for (format_kind e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /** Memory format tag specification.
     * 
     *  Memory format tags can be further divided into two categories:
     * 
     *   - Domain-agnostic names, i.e. names that do not depend on the tensor
     *     usage in the specific primitive. These names use letters from {@code a}
     *     to {@code l} to denote logical dimensions and form the order in which the
     *     dimensions are laid in memory. For example,
     *     #dnnl::memory::format_tag::ab is used to denote a 2D tensor where the
     *     second logical dimension (denoted as {@code b}) is the innermost, i.e.
     *     has stride = 1, and the first logical dimension ({@code a}) is laid out in
     *     memory with stride equal to the size of the second dimension. On the
     *     other hand, #dnnl::memory::format_tag::ba is the transposed version
     *     of the same tensor: the outermost dimension ({@code a}) becomes the
     *     innermost one.
     * 
     *   - Domain-specific names, i.e. names that make sense only in the
     *     context of a certain domain, such as CNN. These names are
     *     aliases to the corresponding domain-agnostic tags and used mostly
     *     for convenience. For example, #dnnl::memory::format_tag::nc
     *     is used to denote 2D CNN activations tensor memory format, where
     *     the channels dimension is the innermost one and the batch dimension
     *     is the outermost one. Moreover, #dnnl::memory::format_tag::nc is
     *     an alias for #dnnl::memory::format_tag::ab, because for
     *     CNN primitives the logical dimensions of activations tensors come
     *     in order: batch, channels, spatial.  In other words, batch
     *     corresponds to the first logical dimension ({@code a}), and channels
     *     correspond to the second one ({@code b}).
     * 
     *  The following domain-specific notation applies to memory format tags:
     *   - \c 'n' denotes the mini-batch dimension
     *   - \c 'c' denotes a channels dimension
     *   - When there are multiple channel dimensions (for example,
     *     in convolution weights tensor), \c 'i' and \c 'o' denote dimensions
     *     of input and output channels
     *   - \c 'g' denotes a groups dimension for convolution weights
     *   - \c 'd', \c 'h', and \c 'w' denote spatial depth, height, and width
     *     respectively
     * 
     *  See \ref dnnl_format_tag_t for a detailed description. */
    public enum format_tag {
        /** Undefined memory format tag */
        undef(dnnl_format_tag_undef),
        /** Placeholder memory format tag. Used to instruct the primitive to
         *  select a format automatically. */
        any(dnnl_format_tag_any),

        /** plain 1D tensor */
        a(dnnl_a),

        /** plain 2D tensor */
        ab(dnnl_ab),
        /** permuted 2D tensor */
        ba(dnnl_ba),

        /** plain 3D tensor */
        abc(dnnl_abc),
        /** permuted 3D tensor */
        acb(dnnl_acb),
        /** permuted 3D tensor */
        bac(dnnl_bac),
        /** permuted 3D tensor */
        bca(dnnl_bca),
        /** permuted 3D tensor */
        cba(dnnl_cba),

        /** plain 4D tensor */
        abcd(dnnl_abcd),
        /** permuted 4D tensor */
        abdc(dnnl_abdc),
        /** permuted 4D tensor */
        acdb(dnnl_acdb),
        /** permuted 4D tensor */
        bacd(dnnl_bacd),
        /** permuted 4D tensor */
        bcda(dnnl_bcda),
        /** permuted 4D tensor */
        cdba(dnnl_cdba),
        /** permuted 4D tensor */
        dcab(dnnl_dcab),

        /** plain 5D tensor */
        abcde(dnnl_abcde),
        /** permuted 5D tensor */
        abdec(dnnl_abdec),
        /** permuted 5D tensor */
        acbde(dnnl_acbde),
        /** permuted 5D tensor */
        acdeb(dnnl_acdeb),
        /** permuted 5D tensor */
        bacde(dnnl_bacde),
        /** permuted 5D tensor */
        bcdea(dnnl_bcdea),
        /** permuted 5D tensor */
        cdeba(dnnl_cdeba),
        /** permuted 5D tensor */
        decab(dnnl_decab),
        /** plain 6D tensor */
        abcdef(dnnl_abcdef),
        /** plain 6D tensor */
        acbdef(dnnl_acbdef),
        /** plain 6D tensor */
        defcab(dnnl_defcab),

        /** 1D tensor; an alias for #dnnl::memory::format_tag::a */
        x(a),
        /** 2D CNN activations tensor; an alias for #dnnl::memory::format_tag::ab */
        nc(ab),
        /** 2D CNN activations tensor; an alias for #dnnl::memory::format_tag::ba */
        cn(ba),
        /** 2D RNN statistics tensor; an alias for #dnnl::memory::format_tag::ab */
        tn(ab),
        /** 2D RNN statistics tensor; an alias for #dnnl::memory::format_tag::ba */
        nt(ba),
        /** 3D CNN activations tensor; an alias for #dnnl::memory::format_tag::abc */
        ncw(abc),
        /** 3D CNN activations tensor; an alias for #dnnl::memory::format_tag::acb */
        nwc(acb),
        /** 4D CNN activations tensor; an alias for #dnnl::memory::format_tag::abcd */
        nchw(abcd),
        /** 4D CNN activations tensor; an alias for #dnnl::memory::format_tag::acdb */
        nhwc(acdb),
        /** 4D CNN activations tensor; an alias for #dnnl::memory::format_tag::bcda */
        chwn(bcda),
        /** 5D CNN activations tensor; an alias for #dnnl::memory::format_tag::abcde */
        ncdhw(abcde),
        /** 5D CNN activations tensor; an alias for #dnnl::memory::format_tag::acdeb */
        ndhwc(acdeb),

        /** 2D CNN weights tensor; an alias for #dnnl::memory::format_tag::ab */
        oi(ab),
        /** 2D CNN weights tensor; an alias for #dnnl::memory::format_tag::ba */
        io(ba),
        /** 3D CNN weights tensor; an alias for #dnnl::memory::format_tag::abc */
        oiw(abc),
        /** 3D CNN weights tensor; an alias for #dnnl::memory::format_tag::acb */
        owi(acb),
        /** 3D CNN weights tensor; an alias for #dnnl::memory::format_tag::cba */
        wio(cba),
        /** 3D CNN weights tensor; an alias for #dnnl::memory::format_tag::bca */
        iwo(bca),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::abcd */
        oihw(abcd),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::cdba */
        hwio(cdba),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::acdb */
        ohwi(acdb),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::bcda */
        ihwo(bcda),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::bacd */
        iohw(bacd),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::abcde */
        oidhw(abcde),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::cdeba */
        dhwio(cdeba),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::acdeb */
        odhwi(acdeb),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::bacde */
        iodhw(bacde),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::bcdea */
        idhwo(bcdea),

        /** 4D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abcd */
        goiw(abcd),
        /** 4D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::dcab */
        wigo(dcab),
        /** 5D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abcde */
        goihw(abcde),
        /** 5D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::decab */
        hwigo(decab),
        /** 5D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::acbde */
        giohw(acbde),
        /** 6D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abcdef */
        goidhw(abcdef),
        /** 6D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abcdef */
        giodhw(acbdef),
        /** 6D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::defcab */
        dhwigo(defcab),

        /** 3D RNN data tensor in the format (seq_length, batch, input channels). */
        tnc(abc),
        /** 3D RNN data tensor in the format (batch, seq_length, input channels). */
        ntc(bac),
        /** 4D RNN states tensor in the format (num_layers, num_directions,
         *  batch, state channels). */
        
///
        ldnc(abcd),
        /** 5D RNN weights tensor in the format (num_layers, num_directions,
         *   input_channels, num_gates, output_channels).
         * 
         *   - For LSTM cells, the gates order is input, forget, candidate
         *     and output gate.
         *   - For GRU cells, the gates order is update, reset and output gate. */
        
///
        ldigo(abcde),
        /** 5D RNN weights tensor in the format (num_layers, num_directions,
         *  num_gates, output_channels, input_channels).
         * 
         *   - For LSTM cells, the gates order is input, forget, candidate
         *     and output gate.
         *   - For GRU cells, the gates order is update, reset and output gate. */
        ldgoi(abdec),
        /** 4D LSTM projection tensor in the format (num_layers, num_directions,
         *  num_channels_in_hidden_state, num_channels_in_recurrent_projection). */
        ldio(abcd),
        /** 4D LSTM projection tensor in the format (num_layers, num_directions,
         *  num_channels_in_recurrent_projection, num_channels_in_hidden_state). */
        
///
        ldoi(abdc),
        /** 4D RNN bias tensor in the format (num_layers, num_directions,
         *  num_gates, output_channels).
         * 
         *   - For LSTM cells, the gates order is input, forget, candidate
         *     and output gate.
         *   - For GRU cells, the gates order is update, reset and output gate. */
        ldgo(abcd),

        // Opaque blocked formats

        Abc16a(dnnl_Abc16a),
        ABc16a16b(dnnl_ABc16a16b),
        ABc4a4b(dnnl_ABc4a4b),
        aBc16b(dnnl_aBc16b),
        aBc32b(dnnl_aBc32b),
        ABc16b16a(dnnl_ABc16b16a),
        Abc4a(dnnl_Abc4a),
        aBc4b(dnnl_aBc4b),
        ABc4b16a4b(dnnl_ABc4b16a4b),
        ABc2b8a4b(dnnl_ABc2b8a4b),
        ABc16b16a4b(dnnl_ABc16b16a4b),
        ABc16b16a2b(dnnl_ABc16b16a2b),
        ABc4b4a(dnnl_ABc4b4a),
        ABc8a16b2a(dnnl_ABc8a16b2a),
        ABc8a8b(dnnl_ABc8a8b),
        ABc8a4b(dnnl_ABc8a4b),
        aBc8b(dnnl_aBc8b),
        ABc8b16a2b(dnnl_ABc8b16a2b),
        ABc8b8a(dnnl_ABc8b8a),
        Abcd8a(dnnl_Abcd8a),
        Abcd16a(dnnl_Abcd16a),
        Abcd32a(dnnl_Abcd32a),
        ABcd16a16b(dnnl_ABcd16a16b),
        aBcd16b(dnnl_aBcd16b),
        aBcd32b(dnnl_aBcd32b),
        ABcd16b16a(dnnl_ABcd16b16a),
        aBCd16b16c(dnnl_aBCd16b16c),
        aBCd16c16b(dnnl_aBCd16c16b),
        Abcd4a(dnnl_Abcd4a),
        aBcd4b(dnnl_aBcd4b),
        ABcd4b16a4b(dnnl_ABcd4b16a4b),
        ABcd2b8a4b(dnnl_ABcd2b8a4b),
        ABcd4b4a(dnnl_ABcd4b4a),
        ABcd4a4b(dnnl_ABcd4a4b),
        aBCd4c16b4c(dnnl_aBCd4c16b4c),
        aBCd2c8b4c(dnnl_aBCd2c8b4c),
        ABcd16b16a4b(dnnl_ABcd16b16a4b),
        ABcd16b16a2b(dnnl_ABcd16b16a2b),
        aBCd16c16b4c(dnnl_aBCd16c16b4c),
        aBCd16c16b2c(dnnl_aBCd16c16b2c),
        aBCd4c4b(dnnl_aBCd4c4b),
        aBCd4b4c(dnnl_aBCd4b4c),
        ABcd8a16b2a(dnnl_ABcd8a16b2a),
        ABcd8a8b(dnnl_ABcd8a8b),
        ABcd8a4b(dnnl_ABcd8a4b),
        /** 4D tensor blocked by 2nd dimension with block size 8 */
        aBcd8b(dnnl_aBcd8b),
        ABcd8b16a2b(dnnl_ABcd8b16a2b),
        aBCd8b16c2b(dnnl_aBCd8b16c2b),
        /** 4D tensor blocked by 1st and 2nd dimension with block size 8 */
        ABcd8b8a(dnnl_ABcd8b8a),
        aBCd8b8c(dnnl_aBCd8b8c),
        aBCd8b4c(dnnl_aBCd8b4c),
        aBCd8c16b2c(dnnl_aBCd8c16b2c),
        aBCd8c8b(dnnl_aBCd8c8b),
        Abcde16a(dnnl_Abcde16a),
        Abcde32a(dnnl_Abcde32a),
        ABcde16a16b(dnnl_ABcde16a16b),
        aBcde16b(dnnl_aBcde16b),
        aBcde32b(dnnl_aBcde32b),
        ABcde16b16a(dnnl_ABcde16b16a),
        aBCde16b16c(dnnl_aBCde16b16c),
        aBCde16c16b(dnnl_aBCde16c16b),
        aBCde2c8b4c(dnnl_aBCde2c8b4c),
        Abcde4a(dnnl_Abcde4a),
        aBcde4b(dnnl_aBcde4b),
        ABcde4b4a(dnnl_ABcde4b4a),
        ABcde4a4b(dnnl_ABcde4a4b),
        aBCde4b4c(dnnl_aBCde4b4c),
        aBCde4c16b4c(dnnl_aBCde4c16b4c),
        aBCde16c16b4c(dnnl_aBCde16c16b4c),
        aBCde16c16b2c(dnnl_aBCde16c16b2c),
        aBCde4c4b(dnnl_aBCde4c4b),
        Abcde8a(dnnl_Abcde8a),
        ABcde8a8b(dnnl_ABcde8a8b),
        ABcde8a4b(dnnl_ABcde8a4b),
        aBcde8b(dnnl_aBcde8b),
        ABcde8b16a2b(dnnl_ABcde8b16a2b),
        ABcde4b16a4b(dnnl_ABcde4b16a4b),
        ABcde2b8a4b(dnnl_ABcde2b8a4b),
        aBCde8b16c2b(dnnl_aBCde8b16c2b),
        ABcde8b8a(dnnl_ABcde8b8a),
        aBCde8b8c(dnnl_aBCde8b8c),
        aBCde8b4c(dnnl_aBCde8b4c),
        ABcd4a8b8a4b(dnnl_ABcd4a8b8a4b),
        ABcd2a8b8a2b(dnnl_ABcd2a8b8a2b),
        aBCde4b8c8b4c(dnnl_aBCde4b8c8b4c),
        aBCde2b8c8b2c(dnnl_aBCde2b8c8b2c),
        aBCde8c16b2c(dnnl_aBCde8c16b2c),
        aBCde8c8b(dnnl_aBCde8c8b),
        aBcdef16b(dnnl_aBcdef16b),
        aBCdef16b16c(dnnl_aBCdef16b16c),
        aBCdef16c16b(dnnl_aBCdef16c16b),
        aBcdef4b(dnnl_aBcdef4b),
        aBCdef2c8b4c(dnnl_aBCdef2c8b4c),
        aBCdef4c4b(dnnl_aBCdef4c4b),
        aBCdef4b4c(dnnl_aBCdef4b4c),
        aBCdef8b8c(dnnl_aBCdef8b8c),
        aBCdef8b4c(dnnl_aBCdef8b4c),
        aBCdef8c16b2c(dnnl_aBCdef8c16b2c),
        aBCdef4c16b4c(dnnl_aBCdef4c16b4c),
        aBCdef8c8b(dnnl_aBCdef8c8b),
        aBdc16b(dnnl_aBdc16b),
        aBdc4b(dnnl_aBdc4b),
        aBdc8b(dnnl_aBdc8b),
        aBdec16b(dnnl_aBdec16b),
        aBdec4b(dnnl_aBdec4b),
        aBdec8b(dnnl_aBdec8b),
        aBdefc16b(dnnl_aBdefc16b),
        aCBdef16c16b(dnnl_aCBdef16c16b),
        aCBdef16b16c(dnnl_aCBdef16b16c),
        aBdefc4b(dnnl_aBdefc4b),
        aBdefc8b(dnnl_aBdefc8b),
        Acb16a(dnnl_Acb16a),
        Acb4a(dnnl_Acb4a),
        Acb8a(dnnl_Acb8a),
        aCBd16b16c(dnnl_aCBd16b16c),
        aCBd16c16b(dnnl_aCBd16c16b),
        aCBde16b16c(dnnl_aCBde16b16c),
        aCBde16c16b(dnnl_aCBde16c16b),
        Acdb16a(dnnl_Acdb16a),
        Acdb4a(dnnl_Acdb4a),
        Acdb8a(dnnl_Acdb8a),
        Acdeb16a(dnnl_Acdeb16a),
        Acdeb4a(dnnl_Acdeb4a),
        Acdeb8a(dnnl_Acdeb8a),
        BAc16a16b(dnnl_BAc16a16b),
        BAc16b16a(dnnl_BAc16b16a),
        BAcd16a16b(dnnl_BAcd16a16b),
        BAcd16b16a(dnnl_BAcd16b16a),
        ABcd32a32b(dnnl_ABcd32a32b),
        BAcde16b16a(dnnl_BAcde16b16a),
        BAcde16a16b(dnnl_BAcde16a16b),
        aBdec32b(dnnl_aBdec32b),
        Abcdef16a(dnnl_Abcdef16a),
        Abcdef32a(dnnl_Abcdef32a),
        Acdb32a(dnnl_Acdb32a),
        aBCd2b4c2b(dnnl_aBCd2b4c2b),
        aBCde2b4c2b(dnnl_aBCde2b4c2b),
        aBCdef2b4c2b(dnnl_aBCdef2b4c2b),
        aBCd2c4b2c(dnnl_aBCd2c4b2c),
        aBCde2c4b2c(dnnl_aBCde2c4b2c),
        aBCdef2c4b2c(dnnl_aBCdef2c4b2c),
        aBCd4b8c2b(dnnl_aBCd4b8c2b),
        aBCde4b8c2b(dnnl_aBCde4b8c2b),
        aBCdef4b8c2b(dnnl_aBCdef4b8c2b),
        aBCd4c8b2c(dnnl_aBCd4c8b2c),
        aBCde4c8b2c(dnnl_aBCde4c8b2c),
        aBCdef4c8b2c(dnnl_aBCdef4c8b2c),

        format_tag_last(dnnl_format_tag_last),

        nCdhw16c(dnnl_nCdhw16c),
        nCdhw4c(dnnl_nCdhw4c),
        nCdhw8c(dnnl_nCdhw8c),
        nChw16c(dnnl_nChw16c),
        nChw4c(dnnl_nChw4c),
        nChw8c(dnnl_nChw8c),
        nCw16c(dnnl_nCw16c),
        nCw4c(dnnl_nCw4c),
        nCw8c(dnnl_nCw8c),
        NCw16n16c(dnnl_NCw16n16c),
        NChw16n16c(dnnl_NChw16n16c),
        NCdhw16n16c(dnnl_NCdhw16n16c),
        NCdhw32n32c(dnnl_NCdhw32n32c),
        NChw32n32c(dnnl_NChw32n32c),
        IOhw16i16o(dnnl_IOhw16i16o),
        Ohwi32o(dnnl_Ohwi32o),
        IOdhw16i16o(dnnl_IOdhw16i16o),
        gIOhw16i16o(dnnl_gIOhw16i16o),
        gOhwi32o(dnnl_gOhwi32o),
        Goidhw16g(dnnl_Goidhw16g),
        IOw16o16i(dnnl_IOw16o16i),
        OIw16i16o(dnnl_OIw16i16o),
        IOw16i16o(dnnl_IOw16i16o),
        gIOw16i16o(dnnl_gIOw16i16o),
        OIw16o16i(dnnl_OIw16o16i),
        Oiw16o(dnnl_Oiw16o),
        OIw4i16o4i(dnnl_OIw4i16o4i),
        OIw2i8o4i(dnnl_OIw2i8o4i),
        OIw4i4o(dnnl_OIw4i4o),
        OIw4o4i(dnnl_OIw4o4i),
        Oiw4o(dnnl_Oiw4o),
        OIw8i16o2i(dnnl_OIw8i16o2i),
        OIw8i8o(dnnl_OIw8i8o),
        OIw8o16i2o(dnnl_OIw8o16i2o),
        OIw8o8i(dnnl_OIw8o8i),
        OIw8o4i(dnnl_OIw8o4i),
        Owi16o(dnnl_Owi16o),
        OwI16o2i(dnnl_OwI16o2i),
        Owi4o(dnnl_Owi4o),
        Owi8o(dnnl_Owi8o),
        IOhw16o16i(dnnl_IOhw16o16i),
        Ohwi16o(dnnl_Ohwi16o),
        OhwI16o2i(dnnl_OhwI16o2i),
        Ohwi4o(dnnl_Ohwi4o),
        Ohwi8o(dnnl_Ohwi8o),
        OIhw16i16o(dnnl_OIhw16i16o),
        OIhw16o16i(dnnl_OIhw16o16i),
        Oihw16o(dnnl_Oihw16o),
        OIhw4i16o4i(dnnl_OIhw4i16o4i),
        OIhw4i4o(dnnl_OIhw4i4o),
        OIhw4o4i(dnnl_OIhw4o4i),
        Oihw4o(dnnl_Oihw4o),
        OIhw8i16o2i(dnnl_OIhw8i16o2i),
        OIhw8i8o(dnnl_OIhw8i8o),
        OIhw8o16i2o(dnnl_OIhw8o16i2o),
        OIhw8o8i(dnnl_OIhw8o8i),
        OIhw8o4i(dnnl_OIhw8o4i),
        OIhw2i8o4i(dnnl_OIhw2i8o4i),
        IOdhw16o16i(dnnl_IOdhw16o16i),
        Odhwi16o(dnnl_Odhwi16o),
        OdhwI16o2i(dnnl_OdhwI16o2i),
        Odhwi4o(dnnl_Odhwi4o),
        Odhwi8o(dnnl_Odhwi8o),
        OIdhw16i16o(dnnl_OIdhw16i16o),
        OIdhw16o16i(dnnl_OIdhw16o16i),
        Oidhw16o(dnnl_Oidhw16o),
        OIdhw4i4o(dnnl_OIdhw4i4o),
        OIdhw4o4i(dnnl_OIdhw4o4i),
        Oidhw4o(dnnl_Oidhw4o),
        OIdhw8i16o2i(dnnl_OIdhw8i16o2i),
        OIdhw4i16o4i(dnnl_OIdhw4i16o4i),
        OIdhw2i8o4i(dnnl_OIdhw2i8o4i),
        OIdhw8i8o(dnnl_OIdhw8i8o),
        OIdhw8o8i(dnnl_OIdhw8o8i),
        OIdhw8o4i(dnnl_OIdhw8o4i),
        gIOw16o16i(dnnl_gIOw16o16i),
        gOIw16i16o(dnnl_gOIw16i16o),
        gOIw16o16i(dnnl_gOIw16o16i),
        gOiw16o(dnnl_gOiw16o),
        gOIw4i16o4i(dnnl_gOIw4i16o4i),
        gOIw2i8o4i(dnnl_gOIw2i8o4i),
        gOIw4i4o(dnnl_gOIw4i4o),
        gOIw4o4i(dnnl_gOIw4o4i),
        gOiw4o(dnnl_gOiw4o),
        gOIw8i16o2i(dnnl_gOIw8i16o2i),
        gOIw8i8o(dnnl_gOIw8i8o),
        gOIw8o16i2o(dnnl_gOIw8o16i2o),
        gOIw8o8i(dnnl_gOIw8o8i),
        gOIw8o4i(dnnl_gOIw8o4i),
        gOwi16o(dnnl_gOwi16o),
        gOwI16o2i(dnnl_gOwI16o2i),
        gOwi4o(dnnl_gOwi4o),
        gOwi8o(dnnl_gOwi8o),
        Goiw8g(dnnl_Goiw8g),
        Goiw16g(dnnl_Goiw16g),
        gIOhw16o16i(dnnl_gIOhw16o16i),
        gOhwi16o(dnnl_gOhwi16o),
        gOhwI16o2i(dnnl_gOhwI16o2i),
        gOhwi4o(dnnl_gOhwi4o),
        gOhwi8o(dnnl_gOhwi8o),
        Goihw16g(dnnl_Goihw16g),
        gOIhw16i16o(dnnl_gOIhw16i16o),
        gOIhw16o16i(dnnl_gOIhw16o16i),
        gOihw16o(dnnl_gOihw16o),
        gOIhw4i16o4i(dnnl_gOIhw4i16o4i),
        gOIhw2i8o4i(dnnl_gOIhw2i8o4i),
        gOIhw4i4o(dnnl_gOIhw4i4o),
        gOIhw4o4i(dnnl_gOIhw4o4i),
        gOihw4o(dnnl_gOihw4o),
        Goihw8g(dnnl_Goihw8g),
        gOIhw8i16o2i(dnnl_gOIhw8i16o2i),
        gOIhw8i8o(dnnl_gOIhw8i8o),
        gOIhw8o16i2o(dnnl_gOIhw8o16i2o),
        OIw4o8i8o4i(dnnl_OIw4o8i8o4i),
        OIdhw4o8i8o4i(dnnl_OIdhw4o8i8o4i),
        OIhw4o8i8o4i(dnnl_OIhw4o8i8o4i),
        OIhw2o8i8o2i(dnnl_OIhw2o8i8o2i),
        gOIw4o8i8o4i(dnnl_gOIw4o8i8o4i),
        gOIdhw4o8i8o4i(dnnl_gOIdhw4o8i8o4i),
        gOIhw4o8i8o4i(dnnl_gOIhw4o8i8o4i),
        gOIhw2o8i8o2i(dnnl_gOIhw2o8i8o2i),
        OIhw16i16o4i(dnnl_OIhw16i16o4i),
        OIhw16i16o2i(dnnl_OIhw16i16o2i),
        gOIhw16i16o4i(dnnl_gOIhw16i16o4i),
        gOIhw16i16o2i(dnnl_gOIhw16i16o2i),
        gOIhw8o8i(dnnl_gOIhw8o8i),
        gOIhw8o4i(dnnl_gOIhw8o4i),
        gIOdhw16i16o(dnnl_gIOdhw16i16o),
        gIOdhw16o16i(dnnl_gIOdhw16o16i),
        gOdhwi16o(dnnl_gOdhwi16o),
        gOdhwI16o2i(dnnl_gOdhwI16o2i),
        gOdhwi4o(dnnl_gOdhwi4o),
        gOdhwi8o(dnnl_gOdhwi8o),
        gOIdhw16i16o(dnnl_gOIdhw16i16o),
        gOIdhw16o16i(dnnl_gOIdhw16o16i),
        gOidhw16o(dnnl_gOidhw16o),
        gOIdhw4i4o(dnnl_gOIdhw4i4o),
        gOIdhw4o4i(dnnl_gOIdhw4o4i),
        gOidhw4o(dnnl_gOidhw4o),
        gOIdhw8i16o2i(dnnl_gOIdhw8i16o2i),
        gOIdhw4i16o4i(dnnl_gOIdhw4i16o4i),
        gOIdhw2i8o4i(dnnl_gOIdhw2i8o4i),
        gOIdhw8i8o(dnnl_gOIdhw8i8o),
        gOIdhw8o8i(dnnl_gOIdhw8o8i),
        gOIdhw8o4i(dnnl_gOIdhw8o4i),
        gOIw2i4o2i(dnnl_gOIw2i4o2i),
        gOIhw2i4o2i(dnnl_gOIhw2i4o2i),
        gOIdhw2i4o2i(dnnl_gOIdhw2i4o2i),
        gOIw2o4i2o(dnnl_gOIw2o4i2o),
        gOIhw2o4i2o(dnnl_gOIhw2o4i2o),
        gOIdhw2o4i2o(dnnl_gOIdhw2o4i2o),
        gOIw4i8o2i(dnnl_gOIw4i8o2i),
        gOIhw4i8o2i(dnnl_gOIhw4i8o2i),
        gOIdhw4i8o2i(dnnl_gOIdhw4i8o2i),
        gOIw4o8i2o(dnnl_gOIw4o8i2o),
        gOIhw4o8i2o(dnnl_gOIhw4o8i2o),
        gOIdhw4o8i2o(dnnl_gOIdhw4o8i2o);

        public final int value;
        private format_tag(int v) { this.value = v; }
        private format_tag(format_tag e) { this.value = e.value; }
        public format_tag intern() { for (format_tag e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /** A memory descriptor. */
    @NoOffset public static class desc extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public desc(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public desc(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public desc position(long position) {
            return (desc)super.position(position);
        }
        @Override public desc getPointer(long i) {
            return new desc(this).position(position + i);
        }
    
        /** The underlying C API data structure. */
        public native @ByRef dnnl_memory_desc_t data(); public native desc data(dnnl_memory_desc_t setter);

        /** Constructs a zero (empty) memory descriptor. Such a memory
         *  descriptor can be used to indicate absence of an argument. */
        
        ///
        ///
        public desc() { super((Pointer)null); allocate(); }
        private native void allocate();

        /** Constructs a memory descriptor.
         * 
         *  \note
         *      The logical order of dimensions corresponds to the {@code abc...}
         *      format tag, and the physical meaning of the dimensions depends
         *      both on the primitive that would operate on this memory and
         *      the operation context.
         * 
         *  @param adims Tensor dimensions.
         *  @param adata_type Data precision/type.
         *  @param aformat_tag Memory format tag.
         *  @param allow_empty A flag signifying whether construction is
         *      allowed to fail without throwing an exception. In this case a
         *      zero memory descriptor will be constructed. This flag is
         *      optional and defaults to false. */
        
        ///
        ///
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, aformat_tag, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, format_tag aformat_tag) { super((Pointer)null); allocate(adims, adata_type, aformat_tag); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, format_tag aformat_tag);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, aformat_tag, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, format_tag aformat_tag) { super((Pointer)null); allocate(adims, adata_type, aformat_tag); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, format_tag aformat_tag);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, aformat_tag, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, format_tag aformat_tag) { super((Pointer)null); allocate(adims, adata_type, aformat_tag); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, format_tag aformat_tag);

        /** Constructs a memory descriptor by strides.
         * 
         *  \note
         *      The logical order of dimensions corresponds to the {@code abc...}
         *      format tag, and the physical meaning of the dimensions depends
         *      both on the primitive that would operate on this memory and
         *      the operation context.
         * 
         *  @param adims Tensor dimensions.
         *  @param adata_type Data precision/type.
         *  @param strides Strides for each dimension.
         *  @param allow_empty A flag signifying whether construction is
         *      allowed to fail without throwing an exception. In this case a
         *      zero memory descriptor will be constructed. This flag is
         *      optional and defaults to false. */
        
        ///
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer strides,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, strides, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer strides,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer strides) { super((Pointer)null); allocate(adims, adata_type, strides); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer strides);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer strides,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, strides, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer strides,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer strides) { super((Pointer)null); allocate(adims, adata_type, strides); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer strides);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] strides,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, strides, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] strides,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] strides) { super((Pointer)null); allocate(adims, adata_type, strides); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] strides);

        /** Constructs a memory descriptor from a C API data structure.
         * 
         *  @param data A C API ::dnnl_memory_desc_t structure. */
        public desc(@Const @ByRef dnnl_memory_desc_t data) { super((Pointer)null); allocate(data); }
        private native void allocate(@Const @ByRef dnnl_memory_desc_t data);

        /** Constructs a memory descriptor for a region inside an area
         *  described by this memory descriptor. */
        //
        /** @param adims Sizes of the region.
        /** @param offsets Offsets to the region from the encompassing
        /**     memory object in each dimension.
        /** @param allow_empty A flag signifying whether construction is
        /**     allowed to fail without throwing an exception. In this case a
        /**     zero memory descriptor will be returned. This flag is optional
        /**     and defaults to false.
        /** @return A memory descriptor for the region. */
        
        ///
        ///
        ///
        ///
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer offsets,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer offsets);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer offsets,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer offsets);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] offsets,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] offsets);

        /** Constructs a memory descriptor by reshaping an existing one. The
         *  new memory descriptor inherits the data type. This operation is
         *  valid only for memory descriptors that have format_kind set to
         *  #dnnl::memory::format_kind::blocked or
         *  #dnnl::memory::format_kind::any.
         * 
         *  The operation ensures that the transformation of the physical memory
         *  format corresponds to the transformation of the logical dimensions.
         *  If such transformation is impossible, the function either throws an
         *  exception (default) or returns a zero memory descriptor depending on
         *  the {@code allow_empty} flag.
         * 
         *  The reshape operation can be described as a combination of the
         *  following basic operations:
         *  1. Add a dimension of size {@code 1}. This is always possible.
         *  2. Remove a dimension of size {@code 1}. This is possible only if the
         *     dimension has no padding (i.e.
         *     {@code padded_dims[dim] == dims[dim] && dims[dim] == 1}).
         *  3. Split a dimension into multiple ones. This is possible only if
         *     the product of all tensor diumensions stays constant and the
         *     dimension being split does not have padding (i.e.
         *     {@code padded_dims[dim] = dims[dim]}).
         *  4. Join multiple consecutive dimensions into a single one. As in
         *     the cases above, this requires that the dimensions do not have
         *     padding and that the memory format is such that in physical
         *     memory these dimensions are dense and have the same order as
         *     their logical counterparts. This also assumes that these
         *     dimensions are not blocked.
         *     - Here, dense means:
         *       {@code stride for dim[i] == (stride for dim[i + 1]) * dim[i + 1]};
         *     - And same order means:
         *       {@code i < j} if and only if {@code stride for dim[j] <= stride for dim[i]}.
         * 
         *  \warning
         *      Some combinations of physical memory layout and/or offsets or
         *      dimensions may result in a failure to make a reshape.
         * 
         *  @param adims New dimensions. The product of dimensions must
         *      remain constant.
         *  @param allow_empty A flag signifying whether construction is
         *      allowed to fail without throwing an exception. In this case a
         *      zero memory descriptor will be returned. This flag is optional
         *      and defaults to false.
         *  @return A new memory descriptor with new dimensions. */
        
        ///
        ///
        ///
        ///
        ///
        ///
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims);

        /** Constructs a memory descriptor by permuting axes in an existing
         *  one.
         * 
         *  The physical memory layout representation is adjusted accordingly
         *  to maintain the consistency between the logical and physical parts
         *  of the memory descriptor.
         * 
         *  The new memory descriptor inherits the data type. This operation is
         *  valid only for memory descriptors that have format_kind set to
         *  #dnnl::memory::format_kind::blocked or
         *  #dnnl::memory::format_kind::any.
         * 
         *  The logical axes will be permuted in the following manner:
         *  <pre>{@code
         *  for (i = 0; i < ndims(); i++)
         *      new_desc.dims()[permutation[i]] = dims()[i];
         *  }</pre>
         * 
         *  Example:
         *  <pre>{@code
         *      std::vector<int> permutation = {1, 0}; // swap the first and
         *                                             // the second axes
         *      dnnl::memory::desc in_md(
         *              {2, 3}, data_type, memory::format_tag::ab);
         *      dnnl::memory::desc expect_out_md(
         *              {3, 2}, data_type, memory::format_tag::ba);
         * 
         *      assert(in_md.permute_axes(permutation) == expect_out_md);
         *  }</pre>
         * 
         *  @param permutation Axes permutation.
         *  @param allow_empty A flag signifying whether construction is
         *      allowed to fail without throwing an exception. In this case a
         *      zero memory descriptor will be returned. This flag is optional
         *      and defaults to false.
         *  @return A new memory descriptor with new dimensions. */
        
        ///
        public native @ByVal desc permute_axes(@StdVector IntPointer permutation,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc permute_axes(@StdVector IntPointer permutation);
        public native @ByVal desc permute_axes(@StdVector IntBuffer permutation,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc permute_axes(@StdVector IntBuffer permutation);
        public native @ByVal desc permute_axes(@StdVector int[] permutation,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc permute_axes(@StdVector int[] permutation);

        /** Returns dimensions of the memory descriptor.
         * 
         *  Potentially expensive due to the data copy involved.
         *  @return A copy of the dimensions vector. */
        public native @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByVal LongPointer dims();

        /** Returns the data type of the memory descriptor.
         *  @return The data type. */
        public native data_type data_type();

        /** Returns size of the memory descriptor in bytes.
         *  @return The number of bytes required to allocate a memory buffer
         *      for the memory object described by this memory descriptor
         *      including the padding area. */
        public native @Cast("size_t") long get_size();

        /** Checks whether the memory descriptor is zero (empty).
         *  @return \c true if the memory descriptor describes an empty
         *      memory and \c false otherwise. */
        public native @Cast("bool") boolean is_zero();

        /** An equality operator.
         *  @param other Another memory descriptor.
         *  @return Whether this and the other memory descriptors have
         *      the same format tag, dimensions, strides, blocking, etc. */
        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef desc other);

        /** An inequality operator.
         *  @param other Another memory descriptor.
         *  @return Whether this and the other memory descriptors describe
         *      different memory. */
        
        ///
        public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef desc other);

        /** Checks whether the object is not empty.
         * 
         *  @return Whether the object is not empty. */
        public native @Cast("bool") @Name("operator bool") boolean asBoolean();
    }

    /** Default constructor.
     * 
     *  Constructs an empty memory object, which can be used to indicate
     *  absence of a parameter. */
    
    ///
    ///
    ///
    public memory() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** Constructs a memory object.
     * 
     *  Unless \p handle is equal to DNNL_MEMORY_NONE, the constructed memory
     *  object will have the underlying buffer set. In this case, the buffer
     *  will be initialized as if #dnnl::memory::set_data_handle() had been
     *  called.
     * 
     *  @see memory::set_data_handle()
     * 
     *  @param md Memory descriptor.
     *  @param aengine Engine to store the data on.
     *  @param handle Handle of the memory buffer to use as an underlying
     *      storage.
     *      - A pointer to the user-allocated buffer. In this case the library
     *        doesn't own the buffer.
     *      - The DNNL_MEMORY_ALLOCATE special value. Instructs the library to
     *        allocate the buffer for the memory object. In this case the
     *        library owns the buffer.
     *      - DNNL_MEMORY_NONE to create dnnl_memory without an underlying
     *        buffer. */
    
    ///
    ///
    public memory(@Const @ByRef desc md, @Const @ByRef engine aengine, Pointer handle) { super((Pointer)null); allocate(md, aengine, handle); }
    private native void allocate(@Const @ByRef desc md, @Const @ByRef engine aengine, Pointer handle);

    /** Constructs a memory object.
     * 
     *  The underlying storage for the memory will be allocated by the library.
     * 
     *  @param md Memory descriptor.
     *  @param aengine Engine to store the data on. */
    public memory(@Const @ByRef desc md, @Const @ByRef engine aengine) { super((Pointer)null); allocate(md, aengine); }
    private native void allocate(@Const @ByRef desc md, @Const @ByRef engine aengine);

    /** Returns the associated memory descriptor. */
    public native @ByVal desc get_desc();

    /** Returns the associated engine. */
    
    ///
    public native @ByVal engine get_engine();

    /** Returns the underlying memory buffer.
     * 
     *  On the CPU engine this is a pointer to the allocated memory. */
    
    ///
    ///
    ///
    ///
    public native Pointer get_data_handle();

    /** Sets the underlying memory buffer.
     * 
     *  This function may write zero values to the memory specified by the \p
     *  handle if the memory object has a zero padding area. This may be time
     *  consuming and happens each time this function is called. The
     *  operation is always blocking and the stream parameter is a hint.
     * 
     *  \note
     *      The zero padding is required by memory objects created with
     *      blocked memory format tags like #dnnl_aBcd8b when any of the
     *      dimensions is not a multiple of the corresponding block size. For
     *      "plain" formats like #dnnl::memory::format_tag::nchw or
     *      #dnnl::memory::format_tag::nhwc zero padding area needs to be set
     *      up explicitly when creating the corresponding memory descriptors.
     *      See \ref dev_guide_understanding_memory_formats for more details.
     * 
     *  \note
     *      Even when the memory object is used to hold values that stay
     *      constant during the execution of the program (pre-packed weights
     *      during inference, for example), the function will still write
     *      zeroes to the padding area if it exists. Hence, the \p handle
     *      parameter cannot and does not have a const qualifier.
     * 
     *  @param handle Data handle. For the CPU aengine, the data handle
     *      is a pointer to the actual data. For OpenCL it is a cl_mem.
     *  @param astream Stream to use to execute padding in. */
    
    ///
    ///
    public native void set_data_handle(Pointer handle, @Const @ByRef stream astream);

    /** Sets the underlying memory buffer.
     * 
     *  See documentation for
     *  #dnnl::memory::set_data_handle(void *, const stream &) const
     *  for more information.
     * 
     *  @param handle Data handle. For the CPU aengine, the data handle
     *      is a pointer to the actual data. For OpenCL it is a cl_mem. */
    
    ///
    ///
    ///
    ///
    ///
    public native void set_data_handle(Pointer handle);

    /** Maps a memory object and returns a host-side pointer to a memory
     *  buffer with a copy of its contents.
     * 
     *  Mapping enables read/write directly from/to the memory contents for
     *  engines that do not support direct memory access.
     * 
     *  Mapping is an exclusive operation - a memory object cannot be used in
     *  other operations until it is unmapped via memory::unmap_data() call.
     * 
     *  \note
     *      Any primitives working with the memory should be completed before
     *      the memory is mapped. Use stream::wait() to synchronize the
     *      corresponding execution stream.
     * 
     *  \note
     *      The map_data and unmap_data functions are provided mainly for
     *      debug and testing purposes and their performance may be suboptimal.
     * 
     *  \tparam T Data type to return a pointer to.
     *  @return Pointer to the mapped memory. */

    /** Unmaps a memory object and writes back any changes made to the
     *  previously mapped memory buffer. The pointer to the mapped buffer
     *  must be obtained via the dnnl::memory::map_data() call.
     * 
     *  \note
     *      The map_data and unmap_data functions are provided mainly for
     *      debug and testing purposes and their performance may be suboptimal.
     * 
     *  @param mapped_ptr A pointer previously returned by map_data(). */
    public native void unmap_data(Pointer mapped_ptr);

// #if DNNL_GPU_RUNTIME == DNNL_RUNTIME_OCL
// #endif

    public static native @Cast("dnnl_data_type_t") int convert_to_c(data_type adata_type);
    public static native @Cast("dnnl_format_tag_t") int convert_to_c(format_tag format);
}
