// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.dnnl;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.opencl.*;
import static org.bytedeco.opencl.global.OpenCL.*;

import static org.bytedeco.dnnl.global.dnnl.*;


/** \} dnnl_api_stream
 <p>
 *  \addtogroup dnnl_api_memory Memory
 * 
 *  A container that describes and stores data. Memory objects can contain
 *  data of various types and formats. There are two levels of abstraction:
 * 
 *  1. **Memory descriptor** -- engine-agnostic logical description of data
 *      (number of dimensions, dimension sizes, and data type), and,
 *      optionally, the information about the physical format of data in
 *      memory. If this information is not known yet, a memory descriptor can
 *      be created with #dnnl::memory::format_tag::any. This allows
 *      compute-intensive primitives to choose the best format for
 *      computation. The user is responsible for reordering the data into the
 *      chosen format when formats do not match.
 * 
 *      A memory descriptor can be initialized either by specifying dimensions
 *      and a memory format tag or strides for each of them, or by
 *      manipulating the dnnl_memory_desc_t structure directly.
 * 
 *      \warning
 *          The latter approach requires understanding how the physical data
 *          representation is mapped to the structure and is discouraged. This
 *          topic is discussed in \ref dev_guide_understanding_memory_formats.
 * 
 *      The user can query the amount of memory required by a memory
 *      descriptor using the #dnnl::memory::desc::get_size() function. The
 *      size of data in general cannot be computed as the product of
 *      dimensions multiplied by the size of the data type. So users are
 *      required to use this function for better code portability.
 * 
 *      Two memory descriptors can be compared using the equality and
 *      inequality operators.  The comparison is especially useful when
 *      checking whether it is necessary to reorder data from the user's data
 *      format to a primitive's format.
 * 
 *  2. **Memory object** -- an engine-specific object that handles the memory
 *      buffer and its description (a memory descriptor). For the CPU engine or
 *      with USM, the memory buffer handle is simply a pointer to \c void. The
 *      memory buffer can be queried using #dnnl::memory::get_data_handle() and
 *      set using #dnnl::memory::set_data_handle(). The underlying SYCL buffer,
 *      when used, can be queried using #dnnl::sycl_interop::get_buffer and set
 *      using #dnnl::sycl_interop::set_buffer. A memory object can also be
 *      queried for the underlying memory descriptor and for its engine using
 *      #dnnl::memory::get_desc() and dnnl::memory::get_engine().
 * 
 *  Along with ordinary memory descriptors with all dimensions being positive,
 *  the library supports *zero-volume*  memory descriptors with one or more
 *  dimensions set to zero. This is used to support the NumPy\* convention.
 *  If a zero-volume memory is passed to a primitive, the primitive typically
 *  does not perform any computations with this memory. For example:
 * 
 *  - A concatenation primitive would ignore all memory object with zeroes in
 *    the concat dimension / axis.
 * 
 *  - A forward convolution with a source memory object with zero in the
 *    minibatch dimension would always produce a destination memory object
 *    with a zero in the minibatch dimension and perform no computations.
 * 
 *  - However, a forward convolution with a zero in one of the weights
 *    dimensions is ill-defined and is considered to be an error by the
 *    library because there is no clear definition of what the output values
 *    should be.
 * 
 *  Memory buffer of a zero-volume memory is never accessed.
 * 
 *  \{
 <p>
 *  Memory object.
 * 
 *  A memory object encapsulates a handle to a memory buffer allocated on a
 *  specific engine, tensor dimensions, data type, and memory format, which is
 *  the way tensor indices map to offsets in linear memory space. Memory
 *  objects are passed to primitives during execution. */
@Namespace("dnnl") @Properties(inherit = org.bytedeco.dnnl.presets.dnnl.class)
public class memory extends dnnl_memory_handle {
    static { Loader.load(); }

    
        public memory() { super((Pointer)null); allocate(); }
        private native void allocate();
        public memory(@Const @ByRef memory arg0) { super((Pointer)null); allocate(arg0); }
        private native void allocate(@Const @ByRef memory arg0);
        
        ///
        public memory(dnnl_memory t, @Cast("bool") boolean weak/*=false*/) { super((Pointer)null); allocate(t, weak); }
        private native void allocate(dnnl_memory t, @Cast("bool") boolean weak/*=false*/);
        public memory(dnnl_memory t) { super((Pointer)null); allocate(t); }
        private native void allocate(dnnl_memory t);
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public memory(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public memory(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public memory position(long position) {
        return (memory)super.position(position);
    }
    @Override public memory getPointer(long i) {
        return new memory((Pointer)this).offsetAddress(i);
    }


    /** Integer type for representing dimension sizes and indices. */
    /** Vector of dimensions. Implementations are free to force a limit on the
     *  vector's length. */
    
    ///

    /** Helper function that validates that an {@code std::vector} of dimensions can
     *  be safely converted to the C API array ::dnnl_dims_t. Throws if
     *  validation fails.
     * 
     *  @param v Vector of dimensions.
     *  @param min_size Minimum expected size of the vector. */

    /** Data type specification. */
    public enum data_type {
        /** Undefined data type (used for empty memory descriptors). */
        undef(dnnl_data_type_undef),
        /** [16-bit/half-precision floating point](https://en.wikipedia.org/wiki/Half-precision_floating-point_format). */
        f16(dnnl_f16),
        /** non-standard
         *  [16-bit floating point with 7-bit mantissa](https://en.wikipedia.org/wiki/Bfloat16_floating-point_format). */
        bf16(dnnl_bf16),
        /** [32-bit/single-precision floating point](https://en.wikipedia.org/wiki/Single-precision_floating-point_format). */
        f32(dnnl_f32),
        //// [64-bit/double-precision floating point](https://en.wikipedia.org/wiki/Double-precision_floating-point_format).
        f64(dnnl_f64),
        /** 32-bit signed integer. */
        s32(dnnl_s32),
        /** 8-bit signed integer. */
        s8(dnnl_s8),
        /** 8-bit unsigned integer. */
        u8(dnnl_u8);

        public final int value;
        private data_type(int v) { this.value = v; }
        private data_type(data_type e) { this.value = e.value; }
        public data_type intern() { for (data_type e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /** Returns size of data type in bytes.
     *  @return The number of bytes occupied by data type. */
    public static native @Cast("size_t") long data_type_size(data_type adata_type);

    /** Memory format kind */
    public enum format_kind {
        /** Undefined memory format kind, used for empty memory descriptors. */
        undef(dnnl_format_kind_undef),
        /** Unspecified format kind.
         *  The primitive selects a format automatically. */
        any(dnnl_format_kind_any),
        /** A tensor in a generic format described by the stride and blocking
         *  values in each dimension. See \ref dnnl_blocking_desc_t for more
         *  information. */
        blocked(dnnl_blocked),
        /** Weights format used in 8-bit Winograd convolution. */
        wino(dnnl_format_kind_wino),
        /** Packed weights format used in RNN. */
        packed(dnnl_format_kind_rnn_packed);

        public final int value;
        private format_kind(int v) { this.value = v; }
        private format_kind(format_kind e) { this.value = e.value; }
        public format_kind intern() { for (format_kind e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /** Memory format tag specification.
     * 
     *  Memory format tags can be further divided into two categories:
     * 
     *   - Domain-agnostic names, i.e. names that do not depend on the tensor
     *     usage in the specific primitive. These names use letters from {@code a}
     *     to {@code f} to denote logical dimensions and form the order in which the
     *     dimensions are laid in memory. For example,
     *     #dnnl::memory::format_tag::ab is used to denote a 2D tensor where the
     *     second logical dimension (denoted as {@code b}) is the innermost, i.e.
     *     has stride = 1, and the first logical dimension ({@code a}) is laid out in
     *     memory with stride equal to the size of the second dimension. On the
     *     other hand, #dnnl::memory::format_tag::ba is the transposed version
     *     of the same tensor: the outermost dimension ({@code a}) becomes the
     *     innermost one.
     * 
     *   - Domain-specific names, i.e. names that make sense only in the
     *     context of a certain domain, such as CNN. These names are
     *     aliases to the corresponding domain-agnostic tags and used mostly
     *     for convenience. For example, #dnnl::memory::format_tag::nc
     *     is used to denote 2D CNN activations tensor memory format, where
     *     the channels dimension is the innermost one and the batch dimension
     *     is the outermost one. Moreover, #dnnl::memory::format_tag::nc is
     *     an alias for #dnnl::memory::format_tag::ab, because for
     *     CNN primitives the logical dimensions of activations tensors come
     *     in order: batch, channels, spatial.  In other words, batch
     *     corresponds to the first logical dimension ({@code a}), and channels
     *     correspond to the second one ({@code b}).
     * 
     *  The following domain-specific notation applies to memory format tags:
     *   - \c 'n' denotes the mini-batch dimension
     *   - \c 'c' denotes a channels dimension
     *   - When there are multiple channel dimensions (for example,
     *     in convolution weights tensor), \c 'i' and \c 'o' denote dimensions
     *     of input and output channels
     *   - \c 'g' denotes a groups dimension for convolution weights
     *   - \c 'd', \c 'h', and \c 'w' denote spatial depth, height, and width
     *     respectively
     * 
     *  See \ref dnnl_format_tag_t for a detailed description. */
    public enum format_tag {
        /** Undefined memory format tag */
        undef(dnnl_format_tag_undef),
        /** Placeholder memory format tag. Used to instruct the primitive to
         *  select a format automatically. */
        any(dnnl_format_tag_any),

        /** plain 1D tensor */
        a(dnnl_a),

        /** plain 2D tensor */
        ab(dnnl_ab),
        /** permuted 2D tensor */
        ba(dnnl_ba),

        /** plain 3D tensor */
        abc(dnnl_abc),
        /** permuted 3D tensor */
        acb(dnnl_acb),
        /** permuted 3D tensor */
        bac(dnnl_bac),
        /** permuted 3D tensor */
        bca(dnnl_bca),
        /** permuted 3D tensor */
        cba(dnnl_cba),

        /** plain 4D tensor */
        abcd(dnnl_abcd),
        /** permuted 4D tensor */
        abdc(dnnl_abdc),
        /** permuted 4D tensor */
        acbd(dnnl_acbd),
        /** permuted 4D tensor */
        acdb(dnnl_acdb),
        /** permuted 4D tensor */
        adbc(dnnl_adbc),
        /** permuted 4D tensor */
        bacd(dnnl_bacd),
        /** permuted 4D tensor */
        bcda(dnnl_bcda),
        /** permuted 4D tensor */
        cdba(dnnl_cdba),
        /** permuted 4D tensor */
        dcab(dnnl_dcab),

        /** plain 5D tensor */
        abcde(dnnl_abcde),
        /** permuted 5D tensor */
        abdec(dnnl_abdec),
        /** permuted 5D tensor */
        acbde(dnnl_acbde),
        /** permuted 5D tensor */
        acdeb(dnnl_acdeb),
        /** permuted 5D tensor */
        bacde(dnnl_bacde),
        /** permuted 5D tensor */
        bcdea(dnnl_bcdea),
        /** permuted 5D tensor */
        cdeba(dnnl_cdeba),
        /** permuted 5D tensor */
        decab(dnnl_decab),
        /** permuted 5D tensor */
        abced(dnnl_abced),

        /** plain 6D tensor */
        abcdef(dnnl_abcdef),
        /** permuted 6D tensor */
        abdfce(dnnl_abdfce),
        /** permuted 6D tensor */
        acbdef(dnnl_acbdef),
        /** permuted 6D tensor */
        abdefc(dnnl_abdefc),
        /** permuted 6D tensor */
        defcab(dnnl_defcab),
        /** permuted 6D tensor */
        abcdfe(dnnl_abcdfe),

        /** plain 7D tensor */
        abcdefg(dnnl_abcdefg),
        /** permuted 7D tensor */
        abcdegf(dnnl_abcdegf),

        /** plain 8D tensor */
        abcdefgh(dnnl_abcdefgh),
        /** permuted 8D tensor */
        abcdefhg(dnnl_abcdefhg),

        /** plain 9D tensor */
        abcdefghi(dnnl_abcdefghi),
        /** permuted 9D tensor */
        abcdefgih(dnnl_abcdefgih),

        /** plain 10D tensor */
        abcdefghij(dnnl_abcdefghij),
        /** permuted 10D tensor */
        abcdefghji(dnnl_abcdefghji),

        /** plain 11D tensor */
        abcdefghijk(dnnl_abcdefghijk),
        /** permuted 11D tensor */
        abcdefghikj(dnnl_abcdefghikj),

        /** plain 12D tensor */
        abcdefghijkl(dnnl_abcdefghijkl),
        /** permuted 12D tensor */
        abcdefghijlk(dnnl_abcdefghijlk),

        /** 1D tensor; an alias for #dnnl::memory::format_tag::a */
        x(a.value),
        /** 2D CNN activations tensor; an alias for #dnnl::memory::format_tag::ab */
        nc(ab.value),
        /** 2D CNN activations tensor; an alias for #dnnl::memory::format_tag::ba */
        cn(ba.value),
        /** 2D RNN statistics tensor; an alias for #dnnl::memory::format_tag::ab */
        tn(ab.value),
        /** 2D RNN statistics tensor; an alias for #dnnl::memory::format_tag::ba */
        nt(ba.value),
        /** 3D CNN activations tensor; an alias for #dnnl::memory::format_tag::abc */
        ncw(abc.value),
        /** 3D CNN activations tensor; an alias for #dnnl::memory::format_tag::acb */
        nwc(acb.value),
        /** 4D CNN activations tensor; an alias for #dnnl::memory::format_tag::abcd */
        nchw(abcd.value),
        /** 4D CNN activations tensor; an alias for #dnnl::memory::format_tag::acdb */
        nhwc(acdb.value),
        /** 4D CNN activations tensor; an alias for #dnnl::memory::format_tag::bcda */
        chwn(bcda.value),
        /** 5D CNN activations tensor; an alias for #dnnl::memory::format_tag::abcde */
        ncdhw(abcde.value),
        /** 5D CNN activations tensor; an alias for #dnnl::memory::format_tag::acdeb */
        ndhwc(acdeb.value),

        /** 2D CNN weights tensor; an alias for #dnnl::memory::format_tag::ab */
        oi(ab.value),
        /** 2D CNN weights tensor; an alias for #dnnl::memory::format_tag::ba */
        io(ba.value),
        /** 3D CNN weights tensor; an alias for #dnnl::memory::format_tag::abc */
        oiw(abc.value),
        /** 3D CNN weights tensor; an alias for #dnnl::memory::format_tag::acb */
        owi(acb.value),
        /** 3D CNN weights tensor; an alias for #dnnl::memory::format_tag::cba */
        wio(cba.value),
        /** 3D CNN weights tensor; an alias for #dnnl::memory::format_tag::bca */
        iwo(bca.value),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::abcd */
        oihw(abcd.value),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::cdba */
        hwio(cdba.value),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::acdb */
        ohwi(acdb.value),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::bcda */
        ihwo(bcda.value),
        /** 4D CNN weights tensor; an alias for #dnnl::memory::format_tag::bacd */
        iohw(bacd.value),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::abcde */
        oidhw(abcde.value),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::cdeba */
        dhwio(cdeba.value),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::acdeb */
        odhwi(acdeb.value),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::bacde */
        iodhw(bacde.value),
        /** 5D CNN weights tensor; an alias for #dnnl::memory::format_tag::bcdea */
        idhwo(bcdea.value),

        /** 4D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abcd */
        goiw(abcd.value),
        /** 4D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abdc */
        gowi(abdc.value),
        /** 4D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::dcab */
        wigo(dcab.value),
        /** 5D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abdec */
        gohwi(abdec.value),
        /** 5D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abcde */
        goihw(abcde.value),
        /** 5D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::decab */
        hwigo(decab.value),
        /** 5D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::acbde */
        giohw(acbde.value),
        /** 6D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abcdef */
        goidhw(abcdef.value),
        /** 6D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abcdef */
        giodhw(acbdef.value),
        /** 6D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::abdefc */
        godhwi(abdefc.value),
        /** 6D CNN weights tensor with groups; an alias for #dnnl::memory::format_tag::defcab */
        dhwigo(defcab.value),

        /** 3D RNN data tensor in the format (seq_length, batch, input
         *  channels); an alias for #dnnl::memory::format_tag::abc. */
        tnc(abc.value),
        /** 3D RNN data tensor in the format (batch, seq_length, input
         *  channels); an alias for #dnnl::memory::format_tag::bac. */
        ntc(bac.value),
        /** 4D RNN states tensor in the format (num_layers, num_directions,
         *  batch, state channels); an alias for #dnnl::memory::format_tag::abcd. */
        
///
        ldnc(abcd.value),
        /** 5D RNN weights tensor in the format (num_layers, num_directions,
         *  input_channels, num_gates, output_channels);
         *  an alias for #dnnl::memory::format_tag::abcde.
         * 
         *   - For LSTM cells, the gates order is input, forget, candidate
         *     and output gate.
         *   - For GRU cells, the gates order is update, reset and output gate. */
        
///
        ldigo(abcde.value),
        /** 5D RNN weights tensor in the format (num_layers, num_directions,
         *  num_gates, output_channels, input_channels);
         *  an alias for #dnnl::memory::format_tag::abdec.
         * 
         *   - For LSTM cells, the gates order is input, forget, candidate
         *     and output gate.
         *   - For GRU cells, the gates order is update, reset and output gate. */
        ldgoi(abdec.value),
        /** 4D LSTM projection tensor in the format (num_layers, num_directions,
         *  num_channels_in_hidden_state, num_channels_in_recurrent_projection);
         *  an alias for #dnnl::memory::format_tag::abcd. */
        ldio(abcd.value),
        /** 4D LSTM projection tensor in the format (num_layers, num_directions,
         *  num_channels_in_recurrent_projection, num_channels_in_hidden_state);
         *  an alias for #dnnl::memory::format_tag::abdc. */
        
///
        ldoi(abdc.value),
        /** 4D RNN bias tensor in the format (num_layers, num_directions,
         *  num_gates, output_channels);
         *  an alias for #dnnl::memory::format_tag::abcd.
         * 
         *   - For LSTM cells, the gates order is input, forget, candidate
         *     and output gate.
         *   - For GRU cells, the gates order is update, reset and output gate. */
        ldgo(abcd.value),

        // Opaque blocked formats

        AB16b16a(dnnl_AB16b16a),
        AB16b32a(dnnl_AB16b32a),
        AB16b64a(dnnl_AB16b64a),
        AB8b16a2b(dnnl_AB8b16a2b),
        AB8b32a2b(dnnl_AB8b32a2b),
        AB8b64a2b(dnnl_AB8b64a2b),
        AB4b16a4b(dnnl_AB4b16a4b),
        AB4b32a4b(dnnl_AB4b32a4b),
        AB4b64a4b(dnnl_AB4b64a4b),
        AB16b16a4b(dnnl_AB16b16a4b),
        AB16b32a4b(dnnl_AB16b32a4b),
        AB16b48a4b(dnnl_AB16b48a4b),
        AB16b64a4b(dnnl_AB16b64a4b),
        AB16b16a2b(dnnl_AB16b16a2b),
        AB16b32a2b(dnnl_AB16b32a2b),
        AB16b48a2b(dnnl_AB16b48a2b),
        AB16b64a2b(dnnl_AB16b64a2b),
        Abc16a(dnnl_Abc16a),
        ABc16a16b(dnnl_ABc16a16b),
        ABc4a4b(dnnl_ABc4a4b),
        aBc16b(dnnl_aBc16b),
        aBc32b(dnnl_aBc32b),
        ABc16b16a(dnnl_ABc16b16a),
        ABc16b32a(dnnl_ABc16b32a),
        ABc16b64a(dnnl_ABc16b64a),
        Abc4a(dnnl_Abc4a),
        aBc4b(dnnl_aBc4b),
        ABc4b16a4b(dnnl_ABc4b16a4b),
        ABc4b32a4b(dnnl_ABc4b32a4b),
        ABc4b64a4b(dnnl_ABc4b64a4b),
        ABc2b8a4b(dnnl_ABc2b8a4b),
        ABc16a16b2a(dnnl_ABc16a16b2a),
        ABc16b16a4b(dnnl_ABc16b16a4b),
        ABc16b32a4b(dnnl_ABc16b32a4b),
        ABc16b48a4b(dnnl_ABc16b48a4b),
        ABc16b64a4b(dnnl_ABc16b64a4b),
        ABc16b16a2b(dnnl_ABc16b16a2b),
        ABc16b32a2b(dnnl_ABc16b32a2b),
        ABc16b48a2b(dnnl_ABc16b48a2b),
        ABc16b64a2b(dnnl_ABc16b64a2b),
        ABc4b4a(dnnl_ABc4b4a),
        ABc8a16b2a(dnnl_ABc8a16b2a),
        ABc8a8b(dnnl_ABc8a8b),
        ABc8a4b(dnnl_ABc8a4b),
        aBc8b(dnnl_aBc8b),
        ABc8b16a2b(dnnl_ABc8b16a2b),
        ABc8b32a2b(dnnl_ABc8b32a2b),
        ABc8b64a2b(dnnl_ABc8b64a2b),
        ABc8b8a(dnnl_ABc8b8a),
        Abcd8a(dnnl_Abcd8a),
        Abcd16a(dnnl_Abcd16a),
        Abcd32a(dnnl_Abcd32a),
        ABcd16a16b(dnnl_ABcd16a16b),
        aBcd16b(dnnl_aBcd16b),
        aBcd32b(dnnl_aBcd32b),
        ABcd16b16a(dnnl_ABcd16b16a),
        ABcd16b32a(dnnl_ABcd16b32a),
        ABcd16b64a(dnnl_ABcd16b64a),
        aBCd16b16c(dnnl_aBCd16b16c),
        aBCd16c16b(dnnl_aBCd16c16b),
        Abcd4a(dnnl_Abcd4a),
        aBcd4b(dnnl_aBcd4b),
        ABcd4b16a4b(dnnl_ABcd4b16a4b),
        ABcd4b32a4b(dnnl_ABcd4b32a4b),
        ABcd4b64a4b(dnnl_ABcd4b64a4b),
        ABcd2b8a4b(dnnl_ABcd2b8a4b),
        ABcd4b4a(dnnl_ABcd4b4a),
        ABcd4a4b(dnnl_ABcd4a4b),
        aBCd4c16b4c(dnnl_aBCd4c16b4c),
        aBCd2c8b4c(dnnl_aBCd2c8b4c),
        ABcd16a16b2a(dnnl_ABcd16a16b2a),
        ABcd16b16a4b(dnnl_ABcd16b16a4b),
        ABcd16b32a4b(dnnl_ABcd16b32a4b),
        ABcd16b48a4b(dnnl_ABcd16b48a4b),
        ABcd16b64a4b(dnnl_ABcd16b64a4b),
        ABcd16b16a2b(dnnl_ABcd16b16a2b),
        ABcd16b32a2b(dnnl_ABcd16b32a2b),
        ABcd16b48a2b(dnnl_ABcd16b48a2b),
        ABcd16b64a2b(dnnl_ABcd16b64a2b),
        aBCd16b16c2b(dnnl_aBCd16b16c2b),
        aBCd16c16b4c(dnnl_aBCd16c16b4c),
        aBCd16c16b2c(dnnl_aBCd16c16b2c),
        aBCd4c4b(dnnl_aBCd4c4b),
        aBCd4b4c(dnnl_aBCd4b4c),
        ABcd8a16b2a(dnnl_ABcd8a16b2a),
        ABcd8a8b(dnnl_ABcd8a8b),
        ABcd8a4b(dnnl_ABcd8a4b),
        ABcd8a2b(dnnl_ABcd8a2b),
        /** 4D tensor blocked by 2nd dimension with block size 8 */
        aBcd8b(dnnl_aBcd8b),
        ABcd8b16a2b(dnnl_ABcd8b16a2b),
        ABcd8b32a2b(dnnl_ABcd8b32a2b),
        ABcd8b64a2b(dnnl_ABcd8b64a2b),
        aBCd8b16c2b(dnnl_aBCd8b16c2b),
        /** 4D tensor blocked by 1st and 2nd dimension with block size 8 */
        ABcd8b8a(dnnl_ABcd8b8a),
        aBCd8b8c(dnnl_aBCd8b8c),
        aBCd8b4c(dnnl_aBCd8b4c),
        aBCd8c16b2c(dnnl_aBCd8c16b2c),
        aBCd8c8b(dnnl_aBCd8c8b),
        Abcde16a(dnnl_Abcde16a),
        Abcde32a(dnnl_Abcde32a),
        ABcde16a16b(dnnl_ABcde16a16b),
        aBcde16b(dnnl_aBcde16b),
        aBcde32b(dnnl_aBcde32b),
        ABcde16b16a(dnnl_ABcde16b16a),
        ABcde16b32a(dnnl_ABcde16b32a),
        ABcde16b64a(dnnl_ABcde16b64a),
        aBCde16b16c(dnnl_aBCde16b16c),
        aBCde16c16b(dnnl_aBCde16c16b),
        aBCde2c8b4c(dnnl_aBCde2c8b4c),
        Abcde4a(dnnl_Abcde4a),
        aBcde4b(dnnl_aBcde4b),
        ABcde4b4a(dnnl_ABcde4b4a),
        ABcde4a4b(dnnl_ABcde4a4b),
        aBCde4b4c(dnnl_aBCde4b4c),
        aBCde4c16b4c(dnnl_aBCde4c16b4c),
        aBCde16b16c2b(dnnl_aBCde16b16c2b),
        aBCde16c16b4c(dnnl_aBCde16c16b4c),
        aBCde16c16b2c(dnnl_aBCde16c16b2c),
        aBCdef16c16b2c(dnnl_aBCdef16c16b2c),
        aBCde4c4b(dnnl_aBCde4c4b),
        Abcde8a(dnnl_Abcde8a),
        ABcde8a8b(dnnl_ABcde8a8b),
        ABcde8a4b(dnnl_ABcde8a4b),
        aBcde8b(dnnl_aBcde8b),
        ABcde8b16a2b(dnnl_ABcde8b16a2b),
        ABcde8b32a2b(dnnl_ABcde8b32a2b),
        ABcde8b64a2b(dnnl_ABcde8b64a2b),
        ABcde4b16a4b(dnnl_ABcde4b16a4b),
        ABcde4b32a4b(dnnl_ABcde4b32a4b),
        ABcde4b64a4b(dnnl_ABcde4b64a4b),
        ABcde16b16a4b(dnnl_ABcde16b16a4b),
        ABcde16b32a4b(dnnl_ABcde16b32a4b),
        ABcde16b48a4b(dnnl_ABcde16b48a4b),
        ABcde16b64a4b(dnnl_ABcde16b64a4b),
        ABcde16b16a2b(dnnl_ABcde16b16a2b),
        ABcde16b32a2b(dnnl_ABcde16b32a2b),
        ABcde16b48a2b(dnnl_ABcde16b48a2b),
        ABcde16b64a2b(dnnl_ABcde16b64a2b),
        ABcde2b8a4b(dnnl_ABcde2b8a4b),
        aBCde8b16c2b(dnnl_aBCde8b16c2b),
        ABcde8b8a(dnnl_ABcde8b8a),
        aBCde8b8c(dnnl_aBCde8b8c),
        aBCde8b4c(dnnl_aBCde8b4c),
        ABcd4a8b8a4b(dnnl_ABcd4a8b8a4b),
        ABcd2a8b8a2b(dnnl_ABcd2a8b8a2b),
        aBCde4b8c8b4c(dnnl_aBCde4b8c8b4c),
        aBCde2b8c8b2c(dnnl_aBCde2b8c8b2c),
        aBCde8c16b2c(dnnl_aBCde8c16b2c),
        aBCde8c8b(dnnl_aBCde8c8b),
        aBcdef16b(dnnl_aBcdef16b),
        aBCdef16b16c(dnnl_aBCdef16b16c),
        aBCdef16c16b(dnnl_aBCdef16c16b),
        aBcdef4b(dnnl_aBcdef4b),
        aBCdef2c8b4c(dnnl_aBCdef2c8b4c),
        aBCdef4c4b(dnnl_aBCdef4c4b),
        aBCdef4b4c(dnnl_aBCdef4b4c),
        aBCdef8b8c(dnnl_aBCdef8b8c),
        aBCdef8b4c(dnnl_aBCdef8b4c),
        aBCdef8c16b2c(dnnl_aBCdef8c16b2c),
        aBCdef4c16b4c(dnnl_aBCdef4c16b4c),
        aBCdef8c8b(dnnl_aBCdef8c8b),
        aBdc16b(dnnl_aBdc16b),
        aBdc4b(dnnl_aBdc4b),
        aBdc8b(dnnl_aBdc8b),
        aBdec16b(dnnl_aBdec16b),
        aBdec4b(dnnl_aBdec4b),
        aBdec8b(dnnl_aBdec8b),
        aBdefc16b(dnnl_aBdefc16b),
        aCBdef16c16b(dnnl_aCBdef16c16b),
        aCBdef16b16c(dnnl_aCBdef16b16c),
        aBdefc4b(dnnl_aBdefc4b),
        aBdefc8b(dnnl_aBdefc8b),
        Acb16a(dnnl_Acb16a),
        Acb4a(dnnl_Acb4a),
        Acb8a(dnnl_Acb8a),
        aCBd16b16c(dnnl_aCBd16b16c),
        aCBd16c16b(dnnl_aCBd16c16b),
        aCBde16b16c(dnnl_aCBde16b16c),
        aCBde16c16b(dnnl_aCBde16c16b),
        Acdb16a(dnnl_Acdb16a),
        Acdb4a(dnnl_Acdb4a),
        Acdb8a(dnnl_Acdb8a),
        Acdeb16a(dnnl_Acdeb16a),
        Acdeb4a(dnnl_Acdeb4a),
        Acdeb8a(dnnl_Acdeb8a),
        BAc16a16b(dnnl_BAc16a16b),
        BAc16b16a(dnnl_BAc16b16a),
        BAcd16a16b(dnnl_BAcd16a16b),
        BAcd16b16a(dnnl_BAcd16b16a),
        ABcd32a32b(dnnl_ABcd32a32b),
        BAcde16b16a(dnnl_BAcde16b16a),
        BAcde16a16b(dnnl_BAcde16a16b),
        aBdec32b(dnnl_aBdec32b),
        Abcdef16a(dnnl_Abcdef16a),
        Abcdef32a(dnnl_Abcdef32a),
        Acdb32a(dnnl_Acdb32a),
        aBCd2b4c2b(dnnl_aBCd2b4c2b),
        aBCde2b4c2b(dnnl_aBCde2b4c2b),
        aBCdef2b4c2b(dnnl_aBCdef2b4c2b),
        aBCd2c4b2c(dnnl_aBCd2c4b2c),
        aBCde2c4b2c(dnnl_aBCde2c4b2c),
        aBCdef2c4b2c(dnnl_aBCdef2c4b2c),
        aBCd4b8c2b(dnnl_aBCd4b8c2b),
        aBCde4b8c2b(dnnl_aBCde4b8c2b),
        aBCdef4b8c2b(dnnl_aBCdef4b8c2b),
        aBCd4c8b2c(dnnl_aBCd4c8b2c),
        aBCde4c8b2c(dnnl_aBCde4c8b2c),
        aBCdef4c8b2c(dnnl_aBCdef4c8b2c),
        AB32a32b8a4b(dnnl_AB32a32b8a4b),
        AB32a32b8a2b(dnnl_AB32a32b8a2b),
        AB8a4b(dnnl_AB8a4b),
        AB8a2b(dnnl_AB8a2b),
        abDc32d(dnnl_abDc32d),
        abDC32d4c(dnnl_abDC32d4c),
        abCd32c(dnnl_abCd32c),
        abdEc32e(dnnl_abdEc32e),
        abdEC32e2c(dnnl_abdEC32e2c),
        abdEC32e4c(dnnl_abdEC32e4c),
        abdCe32c(dnnl_abdCe32c),
        abdCE32c2e(dnnl_abdCE32c2e),
        aBCdef16c16b4c(dnnl_aBCdef16c16b4c),
        aBdC16b4c(dnnl_aBdC16b4c),
        aBdeC16b4c(dnnl_aBdeC16b4c),
        AcB16a4b(dnnl_AcB16a4b),
        AcdB16a2b(dnnl_AcdB16a2b),
        aBdefC16b4c(dnnl_aBdefC16b4c),
        AcdeB16a4b(dnnl_AcdeB16a4b),

        Acb32a(dnnl_Acb32a),
        AcB32a2b(dnnl_AcB32a2b),
        AcB32a4b(dnnl_AcB32a4b),
        Acb48a(dnnl_Acb48a),
        AcB48a2b(dnnl_AcB48a2b),
        AcB48a4b(dnnl_AcB48a4b),
        Acb64a(dnnl_Acb64a),
        AcB64a2b(dnnl_AcB64a2b),
        AcB64a4b(dnnl_AcB64a4b),
        cBa2b(dnnl_cBa2b),
        cBa4b(dnnl_cBa4b),
        aBdc32b(dnnl_aBdc32b),
        aBdC32b2c(dnnl_aBdC32b2c),
        aBdC32b4c(dnnl_aBdC32b4c),
        aBdc48b(dnnl_aBdc48b),
        aBdC48b2c(dnnl_aBdC48b2c),
        aBdC48b4c(dnnl_aBdC48b4c),
        aBdc64b(dnnl_aBdc64b),
        aBdC64b2c(dnnl_aBdC64b2c),
        aBdC64b4c(dnnl_aBdC64b4c),
        adcb(dnnl_adcb),
        adCb2c(dnnl_adCb2c),
        adCb4c(dnnl_adCb4c),
        AcdB32a2b(dnnl_AcdB32a2b),
        AcdB32a4b(dnnl_AcdB32a4b),
        Acdb48a(dnnl_Acdb48a),
        AcdB48a2b(dnnl_AcdB48a2b),
        AcdB48a4b(dnnl_AcdB48a4b),
        Acdb64a(dnnl_Acdb64a),
        AcdB64a2b(dnnl_AcdB64a2b),
        AcdB64a4b(dnnl_AcdB64a4b),
        cdBa2b(dnnl_cdBa2b),
        cdBa4b(dnnl_cdBa4b),
        aBdeC32b2c(dnnl_aBdeC32b2c),
        aBdeC32b4c(dnnl_aBdeC32b4c),
        aBdec48b(dnnl_aBdec48b),
        aBdeC48b2c(dnnl_aBdeC48b2c),
        aBdeC48b4c(dnnl_aBdeC48b4c),
        aBdec64b(dnnl_aBdec64b),
        aBdeC64b2c(dnnl_aBdeC64b2c),
        aBdeC64b4c(dnnl_aBdeC64b4c),
        adecb(dnnl_adecb),
        adeCb2c(dnnl_adeCb2c),
        adeCb4c(dnnl_adeCb4c),
        Acdeb32a(dnnl_Acdeb32a),
        AcdeB32a2b(dnnl_AcdeB32a2b),
        AcdeB32a4b(dnnl_AcdeB32a4b),
        Acdeb48a(dnnl_Acdeb48a),
        AcdeB48a2b(dnnl_AcdeB48a2b),
        AcdeB48a4b(dnnl_AcdeB48a4b),
        Acdeb64a(dnnl_Acdeb64a),
        AcdeB64a2b(dnnl_AcdeB64a2b),
        AcdeB64a4b(dnnl_AcdeB64a4b),
        cdeBa2b(dnnl_cdeBa2b),
        cdeBa4b(dnnl_cdeBa4b),
        aBdefc32b(dnnl_aBdefc32b),
        aBdefC32b2c(dnnl_aBdefC32b2c),
        aBdefC32b4c(dnnl_aBdefC32b4c),
        aBdefc48b(dnnl_aBdefc48b),
        aBdefC48b2c(dnnl_aBdefC48b2c),
        aBdefC48b4c(dnnl_aBdefC48b4c),
        aBdefc64b(dnnl_aBdefc64b),
        aBdefC64b2c(dnnl_aBdefC64b2c),
        aBdefC64b4c(dnnl_aBdefC64b4c),
        adefcb(dnnl_adefcb),
        adefCb2c(dnnl_adefCb2c),
        adefCb4c(dnnl_adefCb4c),
        ABc32a32b(dnnl_ABc32a32b),
        BAc8a16b2a(dnnl_BAc8a16b2a),
        BAcd8a16b2a(dnnl_BAcd8a16b2a),
        ABcde8a16b2a(dnnl_ABcde8a16b2a),
        aCBd8b16c2b(dnnl_aCBd8b16c2b),
        BAcde8a16b2a(dnnl_BAcde8a16b2a),
        aCBde8b16c2b(dnnl_aCBde8b16c2b),
        ABcde32a32b(dnnl_ABcde32a32b),
        ABc4a8b8a4b(dnnl_ABc4a8b8a4b),
        ABcde4a8b8a4b(dnnl_ABcde4a8b8a4b),
        BAc4b8a8b4a(dnnl_BAc4b8a8b4a),
        BAcd4b8a8b4a(dnnl_BAcd4b8a8b4a),
        BAcde4b8a8b4a(dnnl_BAcde4b8a8b4a),
        aBCd4b8c8b4c(dnnl_aBCd4b8c8b4c),
        aBCdef4b8c8b4c(dnnl_aBCdef4b8c8b4c),
        aBCdef8b16c2b(dnnl_aBCdef8b16c2b),
        aCBdef8b16c2b(dnnl_aCBdef8b16c2b),
        aBdC16b2c(dnnl_aBdC16b2c),
        aBdeC16b2c(dnnl_aBdeC16b2c),
        aBdefC16b2c(dnnl_aBdefC16b2c),
        aBedc16b(dnnl_aBedc16b),
        AcB16a2b(dnnl_AcB16a2b),
        AcdB16a4b(dnnl_AcdB16a4b),
        AcdeB16a2b(dnnl_AcdeB16a2b),
        Adcb16a(dnnl_Adcb16a),
        aCBd4c8b8c4b(dnnl_aCBd4c8b8c4b),
        aCBde4c8b8c4b(dnnl_aCBde4c8b8c4b),
        aCBdef4c8b8c4b(dnnl_aCBdef4c8b8c4b),
        ABc32a16b(dnnl_ABc32a16b),
        ABcd32a16b(dnnl_ABcd32a16b),
        ABcde32a16b(dnnl_ABcde32a16b),
        AB48a16b(dnnl_AB48a16b),
        AB48a32b(dnnl_AB48a32b),
        ABc40a16b(dnnl_ABc40a16b),
        ABc40a32b(dnnl_ABc40a32b),
        aBC48b16c(dnnl_aBC48b16c),
        aBC48b32c(dnnl_aBC48b32c),
        ABcd40a16b(dnnl_ABcd40a16b),
        ABcd40a32b(dnnl_ABcd40a32b),
        BA16a16b(dnnl_BA16a16b),
        BA16a32b(dnnl_BA16a32b),
        BA16a48b(dnnl_BA16a48b),
        BA16a64b(dnnl_BA16a64b),
        BA16a16b2a(dnnl_BA16a16b2a),
        BA16a32b2a(dnnl_BA16a32b2a),
        BA16a48b2a(dnnl_BA16a48b2a),
        BA16a64b2a(dnnl_BA16a64b2a),
        BA16a16b4a(dnnl_BA16a16b4a),
        BA16a32b4a(dnnl_BA16a32b4a),
        BA16a48b4a(dnnl_BA16a48b4a),
        BA16a64b4a(dnnl_BA16a64b4a),
        decbA16a(dnnl_decbA16a),

        format_tag_last(dnnl_format_tag_last),

        nCdhw16c(dnnl_nCdhw16c),
        nCdhw4c(dnnl_nCdhw4c),
        nCdhw8c(dnnl_nCdhw8c),
        nChw16c(dnnl_nChw16c),
        nChw4c(dnnl_nChw4c),
        nChw8c(dnnl_nChw8c),
        nCw16c(dnnl_nCw16c),
        nCw4c(dnnl_nCw4c),
        nCw8c(dnnl_nCw8c),
        NCw16n16c(dnnl_NCw16n16c),
        NChw16n16c(dnnl_NChw16n16c),
        NCdhw16n16c(dnnl_NCdhw16n16c),
        NCdhw32n32c(dnnl_NCdhw32n32c),
        NChw32n32c(dnnl_NChw32n32c),
        IOhw16i16o(dnnl_IOhw16i16o),
        OI16i16o(dnnl_OI16i16o),
        OI16i32o(dnnl_OI16i32o),
        OI16i64o(dnnl_OI16i64o),
        OI8i16o2i(dnnl_OI8i16o2i),
        OI8i32o2i(dnnl_OI8i32o2i),
        OI8i64o2i(dnnl_OI8i64o2i),
        OI4i16o4i(dnnl_OI4i16o4i),
        OI4i32o4i(dnnl_OI4i32o4i),
        OI4i64o4i(dnnl_OI4i64o4i),
        Ohwi32o(dnnl_Ohwi32o),
        IOdhw16i16o(dnnl_IOdhw16i16o),
        gIOhw16i16o(dnnl_gIOhw16i16o),
        gOhwi32o(dnnl_gOhwi32o),
        Goidhw16g(dnnl_Goidhw16g),
        IOw16o16i(dnnl_IOw16o16i),
        OIw16i16o(dnnl_OIw16i16o),
        OIw16i32o(dnnl_OIw16i32o),
        OIw16i64o(dnnl_OIw16i64o),
        IOw16i16o(dnnl_IOw16i16o),
        gIOw16i16o(dnnl_gIOw16i16o),
        OIw16o16i(dnnl_OIw16o16i),
        Oiw16o(dnnl_Oiw16o),
        OIw4i16o4i(dnnl_OIw4i16o4i),
        OIw4i32o4i(dnnl_OIw4i32o4i),
        OIw4i64o4i(dnnl_OIw4i64o4i),
        OIw2i8o4i(dnnl_OIw2i8o4i),
        OIw4i4o(dnnl_OIw4i4o),
        OIw4o4i(dnnl_OIw4o4i),
        Oiw4o(dnnl_Oiw4o),
        OIw8i16o2i(dnnl_OIw8i16o2i),
        OIw8i32o2i(dnnl_OIw8i32o2i),
        OIw8i64o2i(dnnl_OIw8i64o2i),
        OIw8i8o(dnnl_OIw8i8o),
        OIw8o16i2o(dnnl_OIw8o16i2o),
        OIw8o8i(dnnl_OIw8o8i),
        OIw8o4i(dnnl_OIw8o4i),
        OIw16i16o4i(dnnl_OIw16i16o4i),
        OIw16i32o4i(dnnl_OIw16i32o4i),
        OIw16i48o4i(dnnl_OIw16i48o4i),
        OIw16i64o4i(dnnl_OIw16i64o4i),
        OIw16i16o2i(dnnl_OIw16i16o2i),
        OIw16i32o2i(dnnl_OIw16i32o2i),
        OIw16i48o2i(dnnl_OIw16i48o2i),
        OIw16i64o2i(dnnl_OIw16i64o2i),
        OIw16o16i2o(dnnl_OIw16o16i2o),
        Owi16o(dnnl_Owi16o),
        OwI16o2i(dnnl_OwI16o2i),
        Owi4o(dnnl_Owi4o),
        Owi8o(dnnl_Owi8o),
        IOhw16o16i(dnnl_IOhw16o16i),
        Ohwi16o(dnnl_Ohwi16o),
        OhwI16o2i(dnnl_OhwI16o2i),
        Ohwi4o(dnnl_Ohwi4o),
        Ohwi8o(dnnl_Ohwi8o),
        OIhw16i16o(dnnl_OIhw16i16o),
        OIhw16i32o(dnnl_OIhw16i32o),
        OIhw16i64o(dnnl_OIhw16i64o),
        OIhw16o16i(dnnl_OIhw16o16i),
        Oihw16o(dnnl_Oihw16o),
        OIhw4i16o4i(dnnl_OIhw4i16o4i),
        OIhw4i32o4i(dnnl_OIhw4i32o4i),
        OIhw4i64o4i(dnnl_OIhw4i64o4i),
        OIhw4i4o(dnnl_OIhw4i4o),
        OIhw4o4i(dnnl_OIhw4o4i),
        Oihw4o(dnnl_Oihw4o),
        OIhw8i16o2i(dnnl_OIhw8i16o2i),
        OIhw8i32o2i(dnnl_OIhw8i32o2i),
        OIhw8i64o2i(dnnl_OIhw8i64o2i),
        OIhw8i8o(dnnl_OIhw8i8o),
        OIhw8o16i2o(dnnl_OIhw8o16i2o),
        OIhw8o8i(dnnl_OIhw8o8i),
        OIhw8o4i(dnnl_OIhw8o4i),
        OIhw2i8o4i(dnnl_OIhw2i8o4i),
        IOdhw16o16i(dnnl_IOdhw16o16i),
        Odhwi16o(dnnl_Odhwi16o),
        OdhwI16o2i(dnnl_OdhwI16o2i),
        Odhwi4o(dnnl_Odhwi4o),
        Odhwi8o(dnnl_Odhwi8o),
        OIdhw16i16o(dnnl_OIdhw16i16o),
        OIdhw16i32o(dnnl_OIdhw16i32o),
        OIdhw16i64o(dnnl_OIdhw16i64o),
        OIdhw16o16i(dnnl_OIdhw16o16i),
        OIdhw16o16i2o(dnnl_OIdhw16o16i2o),
        Oidhw16o(dnnl_Oidhw16o),
        OIdhw4i4o(dnnl_OIdhw4i4o),
        OIdhw4o4i(dnnl_OIdhw4o4i),
        Oidhw4o(dnnl_Oidhw4o),
        OIdhw8i16o2i(dnnl_OIdhw8i16o2i),
        OIdhw8i32o2i(dnnl_OIdhw8i32o2i),
        OIdhw8i64o2i(dnnl_OIdhw8i64o2i),
        OIdhw4i16o4i(dnnl_OIdhw4i16o4i),
        OIdhw16i16o4i(dnnl_OIdhw16i16o4i),
        OIdhw16i32o4i(dnnl_OIdhw16i32o4i),
        OIdhw16i48o4i(dnnl_OIdhw16i48o4i),
        OIdhw16i64o4i(dnnl_OIdhw16i64o4i),
        OIdhw16i16o2i(dnnl_OIdhw16i16o2i),
        OIdhw16i32o2i(dnnl_OIdhw16i32o2i),
        OIdhw16i48o2i(dnnl_OIdhw16i48o2i),
        OIdhw16i64o2i(dnnl_OIdhw16i64o2i),
        OIdhw4i32o4i(dnnl_OIdhw4i32o4i),
        OIdhw4i64o4i(dnnl_OIdhw4i64o4i),
        OIdhw2i8o4i(dnnl_OIdhw2i8o4i),
        OIdhw8i8o(dnnl_OIdhw8i8o),
        OIdhw8o8i(dnnl_OIdhw8o8i),
        OIdhw8o4i(dnnl_OIdhw8o4i),
        gIOw16o16i(dnnl_gIOw16o16i),
        gOIw16i16o(dnnl_gOIw16i16o),
        gOIw16o16i(dnnl_gOIw16o16i),
        gOiw16o(dnnl_gOiw16o),
        gOIw4i16o4i(dnnl_gOIw4i16o4i),
        gOIw2i8o4i(dnnl_gOIw2i8o4i),
        gOIw4i4o(dnnl_gOIw4i4o),
        gOIw4o4i(dnnl_gOIw4o4i),
        gOiw4o(dnnl_gOiw4o),
        gOIw8i16o2i(dnnl_gOIw8i16o2i),
        gOIw8i8o(dnnl_gOIw8i8o),
        gOIw8o16i2o(dnnl_gOIw8o16i2o),
        gOIw8o8i(dnnl_gOIw8o8i),
        gOIw8o4i(dnnl_gOIw8o4i),
        gOIw16i16o4i(dnnl_gOIw16i16o4i),
        gOIw16i16o2i(dnnl_gOIw16i16o2i),
        gOIw16o16i2o(dnnl_gOIw16o16i2o),
        gOwi16o(dnnl_gOwi16o),
        gOwI16o2i(dnnl_gOwI16o2i),
        gOwi4o(dnnl_gOwi4o),
        gOwi8o(dnnl_gOwi8o),
        Goiw8g(dnnl_Goiw8g),
        Goiw16g(dnnl_Goiw16g),
        gIOhw16o16i(dnnl_gIOhw16o16i),
        gOhwi16o(dnnl_gOhwi16o),
        gOhwI16o2i(dnnl_gOhwI16o2i),
        gOhwi4o(dnnl_gOhwi4o),
        gOhwi8o(dnnl_gOhwi8o),
        Goihw16g(dnnl_Goihw16g),
        gOIhw16i16o(dnnl_gOIhw16i16o),
        gOIhw16o16i(dnnl_gOIhw16o16i),
        gOihw16o(dnnl_gOihw16o),
        gOIhw4i16o4i(dnnl_gOIhw4i16o4i),
        gOIhw2i8o4i(dnnl_gOIhw2i8o4i),
        gOIhw4i4o(dnnl_gOIhw4i4o),
        gOIhw4o4i(dnnl_gOIhw4o4i),
        gOihw4o(dnnl_gOihw4o),
        Goihw8g(dnnl_Goihw8g),
        gOIhw8i16o2i(dnnl_gOIhw8i16o2i),
        gOIhw8i8o(dnnl_gOIhw8i8o),
        gOIhw8o16i2o(dnnl_gOIhw8o16i2o),
        OIw4o8i8o4i(dnnl_OIw4o8i8o4i),
        OIdhw4o8i8o4i(dnnl_OIdhw4o8i8o4i),
        OIhw4o8i8o4i(dnnl_OIhw4o8i8o4i),
        OIhw2o8i8o2i(dnnl_OIhw2o8i8o2i),
        gOIw4o8i8o4i(dnnl_gOIw4o8i8o4i),
        gOIdhw4o8i8o4i(dnnl_gOIdhw4o8i8o4i),
        gOIhw4o8i8o4i(dnnl_gOIhw4o8i8o4i),
        gOIhw2o8i8o2i(dnnl_gOIhw2o8i8o2i),
        OIhw16i16o4i(dnnl_OIhw16i16o4i),
        OIhw16i32o4i(dnnl_OIhw16i32o4i),
        OIhw16i48o4i(dnnl_OIhw16i48o4i),
        OIhw16i64o4i(dnnl_OIhw16i64o4i),
        OIhw16i16o2i(dnnl_OIhw16i16o2i),
        OIhw16i32o2i(dnnl_OIhw16i32o2i),
        OIhw16i48o2i(dnnl_OIhw16i48o2i),
        OIhw16i64o2i(dnnl_OIhw16i64o2i),
        OIhw16o16i2o(dnnl_OIhw16o16i2o),
        gOIhw16i16o4i(dnnl_gOIhw16i16o4i),
        gOIhw16i16o2i(dnnl_gOIhw16i16o2i),
        gOIhw16o16i2o(dnnl_gOIhw16o16i2o),
        gOIhw8o8i(dnnl_gOIhw8o8i),
        gOIhw8o4i(dnnl_gOIhw8o4i),
        gIOdhw16i16o(dnnl_gIOdhw16i16o),
        gIOdhw16o16i(dnnl_gIOdhw16o16i),
        gOdhwi16o(dnnl_gOdhwi16o),
        gOdhwI16o2i(dnnl_gOdhwI16o2i),
        gOdhwi4o(dnnl_gOdhwi4o),
        gOdhwi8o(dnnl_gOdhwi8o),
        gOIdhw16i16o(dnnl_gOIdhw16i16o),
        gOIdhw16o16i(dnnl_gOIdhw16o16i),
        gOIdhw16o16i2o(dnnl_gOIdhw16o16i2o),
        gOidhw16o(dnnl_gOidhw16o),
        gOIdhw4i4o(dnnl_gOIdhw4i4o),
        gOIdhw4o4i(dnnl_gOIdhw4o4i),
        gOidhw4o(dnnl_gOidhw4o),
        gOIdhw8i16o2i(dnnl_gOIdhw8i16o2i),
        gOIdhw4i16o4i(dnnl_gOIdhw4i16o4i),
        gOIdhw16i16o4i(dnnl_gOIdhw16i16o4i),
        gOIdhw16i16o2i(dnnl_gOIdhw16i16o2i),
        gOIdhw2i8o4i(dnnl_gOIdhw2i8o4i),
        gOIdhw8i8o(dnnl_gOIdhw8i8o),
        gOIdhw8o8i(dnnl_gOIdhw8o8i),
        gOIdhw8o4i(dnnl_gOIdhw8o4i),
        gOIw2i4o2i(dnnl_gOIw2i4o2i),
        gOIhw2i4o2i(dnnl_gOIhw2i4o2i),
        gOIdhw2i4o2i(dnnl_gOIdhw2i4o2i),
        gOIw2o4i2o(dnnl_gOIw2o4i2o),
        gOIhw2o4i2o(dnnl_gOIhw2o4i2o),
        gOIdhw2o4i2o(dnnl_gOIdhw2o4i2o),
        gOIw4i8o2i(dnnl_gOIw4i8o2i),
        gOIhw4i8o2i(dnnl_gOIhw4i8o2i),
        gOIdhw4i8o2i(dnnl_gOIdhw4i8o2i),
        gOIw4o8i2o(dnnl_gOIw4o8i2o),
        gOIhw4o8i2o(dnnl_gOIhw4o8i2o),
        gOIdhw4o8i2o(dnnl_gOIdhw4o8i2o),
        ldOi32o(abDc32d.value),
        ldOI32o4i(abDC32d4c.value),
        ldgOi32o(abdEc32e.value),
        ldgOI32o2i(abdEC32e2c.value),
        ldgOI32o4i(abdEC32e4c.value),
        OwI16o4i(dnnl_OwI16o4i),
        OhwI16o4i(dnnl_OhwI16o4i),
        gOwI16o4i(dnnl_gOwI16o4i),
        gOhwI16o4i(dnnl_gOhwI16o4i),
        OdhwI16o4i(dnnl_OdhwI16o4i),
        gOdhwI16o4i(dnnl_gOdhwI16o4i),

        Owi32o(dnnl_Owi32o),
        OwI32o2i(dnnl_OwI32o2i),
        OwI32o4i(dnnl_OwI32o4i),
        Owi48o(dnnl_Owi48o),
        OwI48o2i(dnnl_OwI48o2i),
        OwI48o4i(dnnl_OwI48o4i),
        Owi64o(dnnl_Owi64o),
        OwI64o2i(dnnl_OwI64o2i),
        OwI64o4i(dnnl_OwI64o4i),
        wIo2i(dnnl_wIo2i),
        wIo4i(dnnl_wIo4i),
        gOwi32o(dnnl_gOwi32o),
        gOwI32o2i(dnnl_gOwI32o2i),
        gOwI32o4i(dnnl_gOwI32o4i),
        gOwi48o(dnnl_gOwi48o),
        gOwI48o2i(dnnl_gOwI48o2i),
        gOwI48o4i(dnnl_gOwI48o4i),
        gOwi64o(dnnl_gOwi64o),
        gOwI64o2i(dnnl_gOwI64o2i),
        gOwI64o4i(dnnl_gOwI64o4i),
        gwio(dnnl_gwio),
        gwIo2i(dnnl_gwIo2i),
        gwIo4i(dnnl_gwIo4i),
        OhwI32o(dnnl_OhwI32o),
        OhwI32o2i(dnnl_OhwI32o2i),
        OhwI32o4i(dnnl_OhwI32o4i),
        Ohwi48o(dnnl_Ohwi48o),
        OhwI48o2i(dnnl_OhwI48o2i),
        OhwI48o4i(dnnl_OhwI48o4i),
        Ohwi64o(dnnl_Ohwi64o),
        OhwI64o2i(dnnl_OhwI64o2i),
        OhwI64o4i(dnnl_OhwI64o4i),
        hwIo2i(dnnl_hwIo2i),
        hwIo4i(dnnl_hwIo4i),
        gOhwI32o(dnnl_gOhwI32o),
        gOhwI32o2i(dnnl_gOhwI32o2i),
        gOhwI32o4i(dnnl_gOhwI32o4i),
        gOhwi48o(dnnl_gOhwi48o),
        gOhwI48o2i(dnnl_gOhwI48o2i),
        gOhwI48o4i(dnnl_gOhwI48o4i),
        gOhwi64o(dnnl_gOhwi64o),
        gOhwI64o2i(dnnl_gOhwI64o2i),
        gOhwI64o4i(dnnl_gOhwI64o4i),
        ghwio(dnnl_ghwio),
        ghwIo2i(dnnl_ghwIo2i),
        ghwIo4i(dnnl_ghwIo4i),
        Odhwi32o(dnnl_Odhwi32o),
        OdhwI32o2i(dnnl_OdhwI32o2i),
        OdhwI32o4i(dnnl_OdhwI32o4i),
        Odhwi48o(dnnl_Odhwi48o),
        OdhwI48o2i(dnnl_OdhwI48o2i),
        OdhwI48o4i(dnnl_OdhwI48o4i),
        Odhwi64o(dnnl_Odhwi64o),
        OdhwI64o2i(dnnl_OdhwI64o2i),
        OdhwI64o4i(dnnl_OdhwI64o4i),
        dhwIo2i(dnnl_dhwIo2i),
        dhwIo4i(dnnl_dhwIo4i),
        gOdhwi32o(dnnl_gOdhwi32o),
        gOdhwI32o2i(dnnl_gOdhwI32o2i),
        gOdhwI32o4i(dnnl_gOdhwI32o4i),
        gOdhwi48o(dnnl_gOdhwi48o),
        gOdhwI48o2i(dnnl_gOdhwI48o2i),
        gOdhwI48o4i(dnnl_gOdhwI48o4i),
        gOdhwi64o(dnnl_gOdhwi64o),
        gOdhwI64o2i(dnnl_gOdhwI64o2i),
        gOdhwI64o4i(dnnl_gOdhwI64o4i),
        gdhwio(dnnl_gdhwio),
        gdhwIo2i(dnnl_gdhwIo2i),
        gdhwIo4i(dnnl_gdhwIo4i),
        ldIo32i(dnnl_ldIo32i),
        ldgIo32i(dnnl_ldgIo32i),
        ldgIO32i2o(dnnl_ldgIO32i2o),
        nCdhw32c(dnnl_nCdhw32c),
        nChw32c(dnnl_nChw32c),
        nCw32c(dnnl_nCw32c),
        NCw32n16c(dnnl_NCw32n16c),
        NChw32n16c(dnnl_NChw32n16c),
        NCdhw32n16c(dnnl_NCdhw32n16c),
        NCw32n32c(dnnl_NCw32n32c),
        OI16i16o4i(dnnl_OI16i16o4i),
        IOw8o16i2o(dnnl_IOw8o16i2o),
        IOhw8o16i2o(dnnl_IOhw8o16i2o),
        Owhi16o(dnnl_Owhi16o),
        OIdhw8o16i2o(dnnl_OIdhw8o16i2o),
        IOdhw8o16i2o(dnnl_IOdhw8o16i2o),
        Goiw4g(dnnl_Goiw4g),
        gIOw8o16i2o(dnnl_gIOw8o16i2o),
        Goiw32g(dnnl_Goiw32g),
        Goihw4g(dnnl_Goihw4g),
        gIOhw8o16i2o(dnnl_gIOhw8o16i2o),
        Goihw32g(dnnl_Goihw32g),
        gOwhi16o(dnnl_gOwhi16o),
        IOw4i8o8i4o(dnnl_IOw4i8o8i4o),
        IOhw4i8o8i4o(dnnl_IOhw4i8o8i4o),
        IOdhw4i8o8i4o(dnnl_IOdhw4i8o8i4o),
        gIOw4i8o8i4o(dnnl_gIOw4i8o8i4o),
        gIOhw4i8o8i4o(dnnl_gIOhw4i8o8i4o),
        gIOdhw4i8o8i4o(dnnl_gIOdhw4i8o8i4o),
        gOIdhw8o16i2o(dnnl_gOIdhw8o16i2o),
        gIOdhw8o16i2o(dnnl_gIOdhw8o16i2o),
        Goidhw32g(dnnl_Goidhw32g),
        OI16i32o4i(dnnl_OI16i32o4i),
        OI16i48o4i(dnnl_OI16i48o4i),
        OI16i64o4i(dnnl_OI16i64o4i),
        OI16i16o2i(dnnl_OI16i16o2i),
        OI16i32o2i(dnnl_OI16i32o2i),
        OI16i48o2i(dnnl_OI16i48o2i),
        OI16i64o2i(dnnl_OI16i64o2i),
        aBdeC16c16b4c(dnnl_aBdeC16c16b4c),
        AcB16b16a2b(dnnl_AcB16b16a2b),
        aBdC16c16b2c(dnnl_aBdC16c16b2c),
        AcB16b16a4b(dnnl_AcB16b16a4b),
        aBdC16c16b4c(dnnl_aBdC16c16b4c),
        AcdB16b16a2b(dnnl_AcdB16b16a2b),
        aBdefC16c16b4c(dnnl_aBdefC16c16b4c),
        AcdeB16b16a4b(dnnl_AcdeB16b16a4b),
        AcB16b32a2b(dnnl_AcB16b32a2b),
        AcB16b32a4b(dnnl_AcB16b32a4b),
        AcB16b48a2b(dnnl_AcB16b48a2b),
        AcB16b48a4b(dnnl_AcB16b48a4b),
        AcB16b64a2b(dnnl_AcB16b64a2b),
        AcB16b64a4b(dnnl_AcB16b64a4b),
        aBdC16c32b2c(dnnl_aBdC16c32b2c),
        aBdC16c32b4c(dnnl_aBdC16c32b4c),
        aBdC16c48b2c(dnnl_aBdC16c48b2c),
        aBdC16c48b4c(dnnl_aBdC16c48b4c),
        aBdC16c64b2c(dnnl_aBdC16c64b2c),
        aBdC16c64b4c(dnnl_aBdC16c64b4c),
        AcdB16b32a2b(dnnl_AcdB16b32a2b),
        AcdB16b32a4b(dnnl_AcdB16b32a4b),
        AcdB16b48a2b(dnnl_AcdB16b48a2b),
        AcdB16b48a4b(dnnl_AcdB16b48a4b),
        AcdB16b64a2b(dnnl_AcdB16b64a2b),
        AcdB16b64a4b(dnnl_AcdB16b64a4b),
        aBdeC16c32b2c(dnnl_aBdeC16c32b2c),
        aBdeC16c32b4c(dnnl_aBdeC16c32b4c),
        aBdeC16c48b2c(dnnl_aBdeC16c48b2c),
        aBdeC16c48b4c(dnnl_aBdeC16c48b4c),
        aBdeC16c64b2c(dnnl_aBdeC16c64b2c),
        aBdeC16c64b4c(dnnl_aBdeC16c64b4c),
        AcdeB16b32a2b(dnnl_AcdeB16b32a2b),
        AcdeB16b32a4b(dnnl_AcdeB16b32a4b),
        AcdeB16b48a2b(dnnl_AcdeB16b48a2b),
        AcdeB16b48a4b(dnnl_AcdeB16b48a4b),
        AcdeB16b64a2b(dnnl_AcdeB16b64a2b),
        AcdeB16b64a4b(dnnl_AcdeB16b64a4b),
        aBdefC16c32b2c(dnnl_aBdefC16c32b2c),
        aBdefC16c32b4c(dnnl_aBdefC16c32b4c),
        aBdefC16c48b2c(dnnl_aBdefC16c48b2c),
        aBdefC16c48b4c(dnnl_aBdefC16c48b4c),
        aBdefC16c64b2c(dnnl_aBdefC16c64b2c),
        aBdefC16c64b4c(dnnl_aBdefC16c64b4c),
        OwI16i16o2i(dnnl_OwI16i16o2i),
        gOwI16i16o2i(dnnl_gOwI16i16o2i),
        OhwI16i16o2i(dnnl_OhwI16i16o2i),
        gOhwI16i16o2i(dnnl_gOhwI16i16o2i),
        OdhwI16i16o2i(dnnl_OdhwI16i16o2i),
        gOdhwI16i16o2i(dnnl_gOdhwI16i16o2i),
        OwI16i16o4i(dnnl_OwI16i16o4i),
        gOwI16i16o4i(dnnl_gOwI16i16o4i),
        OhwI16i16o4i(dnnl_OhwI16i16o4i),
        gOhwI16i16o4i(dnnl_gOhwI16i16o4i),
        OdhwI16i16o4i(dnnl_OdhwI16i16o4i),
        gOdhwI16i16o4i(dnnl_gOdhwI16i16o4i),
        OwI16i32o2i(dnnl_OwI16i32o2i),
        OwI16i32o4i(dnnl_OwI16i32o4i),
        OwI16i48o2i(dnnl_OwI16i48o2i),
        OwI16i48o4i(dnnl_OwI16i48o4i),
        OwI16i64o2i(dnnl_OwI16i64o2i),
        OwI16i64o4i(dnnl_OwI16i64o4i),
        gOwI16i32o2i(dnnl_gOwI16i32o2i),
        gOwI16i32o4i(dnnl_gOwI16i32o4i),
        gOwI16i48o2i(dnnl_gOwI16i48o2i),
        gOwI16i48o4i(dnnl_gOwI16i48o4i),
        gOwI16i64o2i(dnnl_gOwI16i64o2i),
        gOwI16i64o4i(dnnl_gOwI16i64o4i),
        OhwI16i32o2i(dnnl_OhwI16i32o2i),
        OhwI16i32o4i(dnnl_OhwI16i32o4i),
        OhwI16i48o2i(dnnl_OhwI16i48o2i),
        OhwI16i48o4i(dnnl_OhwI16i48o4i),
        OhwI16i64o2i(dnnl_OhwI16i64o2i),
        OhwI16i64o4i(dnnl_OhwI16i64o4i),
        gOhwI16i32o2i(dnnl_gOhwI16i32o2i),
        gOhwI16i32o4i(dnnl_gOhwI16i32o4i),
        gOhwI16i48o2i(dnnl_gOhwI16i48o2i),
        gOhwI16i48o4i(dnnl_gOhwI16i48o4i),
        gOhwI16i64o2i(dnnl_gOhwI16i64o2i),
        gOhwI16i64o4i(dnnl_gOhwI16i64o4i),
        OdhwI16i32o2i(dnnl_OdhwI16i32o2i),
        OdhwI16i32o4i(dnnl_OdhwI16i32o4i),
        OdhwI16i48o2i(dnnl_OdhwI16i48o2i),
        OdhwI16i48o4i(dnnl_OdhwI16i48o4i),
        OdhwI16i64o2i(dnnl_OdhwI16i64o2i),
        OdhwI16i64o4i(dnnl_OdhwI16i64o4i),
        gOdhwI16i32o2i(dnnl_gOdhwI16i32o2i),
        gOdhwI16i32o4i(dnnl_gOdhwI16i32o4i),
        gOdhwI16i48o2i(dnnl_gOdhwI16i48o2i),
        gOdhwI16i48o4i(dnnl_gOdhwI16i48o4i),
        gOdhwI16i64o2i(dnnl_gOdhwI16i64o2i),
        gOdhwI16i64o4i(dnnl_gOdhwI16i64o4i),
        aBdeC16c16b2c(dnnl_aBdeC16c16b2c),
        aBdefC16c16b2c(dnnl_aBdefC16c16b2c),
        AcdB16b16a4b(dnnl_AcdB16b16a4b),
        AcdeB16b16a2b(dnnl_AcdeB16b16a2b),
        hwioG16g(dnnl_hwioG16g),
        ABc4a2b(dnnl_ABc4a2b),
        ABc8a2b(dnnl_ABc8a2b),
        ABcd4a2b(dnnl_ABcd4a2b),
        ABcde4a2b(dnnl_ABcde4a2b),
        ABcde8a2b(dnnl_ABcde8a2b),
        ABcd4a8b8a2b(dnnl_ABcd4a8b8a2b),
        NCdhw40n32c(dnnl_NCdhw40n32c),
        NChw40n32c(dnnl_NChw40n32c),
        NCw40n32c(dnnl_NCw40n32c),
        OIdhw4o8i8o2i(dnnl_OIdhw4o8i8o2i),
        OIhw4o8i8o2i(dnnl_OIhw4o8i8o2i),
        OIw4o8i8o2i(dnnl_OIw4o8i8o2i),
        gOIdhw4o8i8o2i(dnnl_gOIdhw4o8i8o2i),
        gOIhw4o8i8o2i(dnnl_gOIhw4o8i8o2i),
        gOIw4o8i8o2i(dnnl_gOIw4o8i8o2i),
        IOdhw4i8o8i2o(dnnl_IOdhw4i8o8i2o),
        IOhw4i8o8i2o(dnnl_IOhw4i8o8i2o),
        IOw4i8o8i2o(dnnl_IOw4i8o8i2o),
        gIOdhw4i8o8i2o(dnnl_gIOdhw4i8o8i2o),
        gIOhw4i8o8i2o(dnnl_gIOhw4i8o8i2o),
        gIOw4i8o8i2o(dnnl_gIOw4i8o8i2o),
        aBCd8b2c(dnnl_aBCd8b2c),
        ABcde40a16b(dnnl_ABcde40a16b),
        ABcde40a32b(dnnl_ABcde40a32b),
        aBCde8b2c(dnnl_aBCde8b2c),
        ABcde4a8b8a2b(dnnl_ABcde4a8b8a2b),
        ABc4a8b8a2b(dnnl_ABc4a8b8a2b),
        aBCdef4b8c8b2c(dnnl_aBCdef4b8c8b2c),
        aBCde4b8c8b2c(dnnl_aBCde4b8c8b2c),
        aBCd4b8c8b2c(dnnl_aBCd4b8c8b2c),
        BAcde4b8a8b2a(dnnl_BAcde4b8a8b2a),
        BAcd4b8a8b2a(dnnl_BAcd4b8a8b2a),
        BAc4b8a8b2a(dnnl_BAc4b8a8b2a),
        aCBdef4c8b8c2b(dnnl_aCBdef4c8b8c2b),
        aCBde4c8b8c2b(dnnl_aCBde4c8b8c2b),
        aCBd4c8b8c2b(dnnl_aCBd4c8b8c2b),
        aBCdef8b2c(dnnl_aBCdef8b2c),
        AB32a16b(dnnl_AB32a16b),
        AB32a32b(dnnl_AB32a32b),
        BA4b8a8b2a(dnnl_BA4b8a8b2a),
        BA4b8a8b4a(dnnl_BA4b8a8b4a),
        aBC32b16c(dnnl_aBC32b16c),
        aBC32b32c(dnnl_aBC32b32c),
        aCB4c8b8c2b(dnnl_aCB4c8b8c2b),
        aCB4c8b8c4b(dnnl_aCB4c8b8c4b),
        ABc2b8a16b4a(dnnl_ABc2b8a16b4a),
        ABcd2b8a16b4a(dnnl_ABcd2b8a16b4a),
        ABcde2b8a16b4a(dnnl_ABcde2b8a16b4a),
        ABc2a8b16a4b(dnnl_ABc2a8b16a4b),
        ABc2a8b16a2b(dnnl_ABc2a8b16a2b),
        ABc2b32a8b(dnnl_ABc2b32a8b),
        ABcd2a8b16a4b(dnnl_ABcd2a8b16a4b),
        ABcd2a8b16a2b(dnnl_ABcd2a8b16a2b),
        aCBd2c8b16c2b(dnnl_aCBd2c8b16c2b),
        ABcd2b32a8b(dnnl_ABcd2b32a8b),
        aBCd2c8b16c2b(dnnl_aBCd2c8b16c2b),
        ABcde2a8b16a4b(dnnl_ABcde2a8b16a4b),
        ABcde2a8b16a2b(dnnl_ABcde2a8b16a2b),
        aCBde2c8b16c2b(dnnl_aCBde2c8b16c2b),
        ABcde2b32a8b(dnnl_ABcde2b32a8b),
        aBC2b8c16b2c(dnnl_aBC2b8c16b2c),
        aBCd2b8c16b2c(dnnl_aBCd2b8c16b2c),
        aBCde2b8c16b2c(dnnl_aBCde2b8c16b2c),
        aBCdef2b8c16b2c(dnnl_aBCdef2b8c16b2c),
        BAcde2b8a16b4a(dnnl_BAcde2b8a16b4a),
        BAcd2b8a16b4a(dnnl_BAcd2b8a16b4a),
        BAc2b8a16b4a(dnnl_BAc2b8a16b4a),
        BAcde2b8a16b2a(dnnl_BAcde2b8a16b2a),
        BAcd2b8a16b2a(dnnl_BAcd2b8a16b2a),
        BAc2b8a16b2a(dnnl_BAc2b8a16b2a),
        aBCde2c8b16c2b(dnnl_aBCde2c8b16c2b),
        aBCdef2c8b16c2b(dnnl_aBCdef2c8b16c2b),
        aCBdef2c8b16c2b(dnnl_aCBdef2c8b16c2b),
        aBCd2b8c16b4c(dnnl_aBCd2b8c16b4c),
        aBCde2b8c16b4c(dnnl_aBCde2b8c16b4c),
        NCdhw40n16c(dnnl_NCdhw40n16c),
        NCw40n16c(dnnl_NCw40n16c),
        NChw40n16c(dnnl_NChw40n16c),
        NCw2c32n8c(dnnl_NCw2c32n8c),
        NChw2c32n8c(dnnl_NChw2c32n8c),
        NCdhw2c32n8c(dnnl_NCdhw2c32n8c),
        OIw2i8o16i4o(dnnl_OIw2i8o16i4o),
        OIhw2i8o16i4o(dnnl_OIhw2i8o16i4o),
        OIdhw2i8o16i4o(dnnl_OIdhw2i8o16i4o),
        OIw2o8i16o4i(dnnl_OIw2o8i16o4i),
        OIw2o8i16o2i(dnnl_OIw2o8i16o2i),
        IOw2i8o16i4o(dnnl_IOw2i8o16i4o),
        IOw2i8o16i2o(dnnl_IOw2i8o16i2o),
        OIhw2o8i16o4i(dnnl_OIhw2o8i16o4i),
        OIhw2o8i16o2i(dnnl_OIhw2o8i16o2i),
        IOhw2i8o16i4o(dnnl_IOhw2i8o16i4o),
        IOhw2i8o16i2o(dnnl_IOhw2i8o16i2o),
        OIdhw2o8i16o4i(dnnl_OIdhw2o8i16o4i),
        OIdhw2o8i16o2i(dnnl_OIdhw2o8i16o2i),
        IOdhw2i8o16i4o(dnnl_IOdhw2i8o16i4o),
        IOdhw2i8o16i2o(dnnl_IOdhw2i8o16i2o),
        gOIw2o8i16o2i(dnnl_gOIw2o8i16o2i),
        gIOw2i8o16i2o(dnnl_gIOw2i8o16i2o),
        gIOhw2i8o16i2o(dnnl_gIOhw2i8o16i2o),
        gIOdhw2i8o16i2o(dnnl_gIOdhw2i8o16i2o),
        gOIhw2o8i16o2i(dnnl_gOIhw2o8i16o2i),
        gOIdhw2o8i16o2i(dnnl_gOIdhw2o8i16o2i),
        gOIw2o8i16o4i(dnnl_gOIw2o8i16o4i),
        gOIhw2o8i16o4i(dnnl_gOIhw2o8i16o4i),
        BA4b8a16b2a(dnnl_BA4b8a16b2a),
        BA4b8a16b4a(dnnl_BA4b8a16b4a),
        aCB4c8b16c2b(dnnl_aCB4c8b16c2b),
        aCB4c8b16c4b(dnnl_aCB4c8b16c4b),
        aCB16c2b(dnnl_aCB16c2b),
        aCB16c4b(dnnl_aCB16c4b),
        BA16b2a(dnnl_BA16b2a),
        BA16b4a(dnnl_BA16b4a),
        aBC16b16c(dnnl_aBC16b16c),
        aBC16b32c(dnnl_aBC16b32c),
        AB16a16b(dnnl_AB16a16b),
        AB16a32b(dnnl_AB16a32b),
        ABcde16a16b2a(dnnl_ABcde16a16b2a),
        aBCdef16b16c2b(dnnl_aBCdef16b16c2b),
        Acedb16a(dnnl_Acedb16a),
        aBdfec16b(dnnl_aBdfec16b),
        Odwhi16o(dnnl_Odwhi16o),
        gOdwhi16o(dnnl_gOdwhi16o),
        abdEC64e2c(dnnl_abdEC64e2c),
        abdEC64e4c(dnnl_abdEC64e4c),
        ldgOI64o2i(abdEC64e2c.value),
        ldgOI64o4i(abdEC64e4c.value);

        public final int value;
        private format_tag(int v) { this.value = v; }
        private format_tag(format_tag e) { this.value = e.value; }
        public format_tag intern() { for (format_tag e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /** A memory descriptor. */
    @NoOffset public static class desc extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public desc(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public desc(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public desc position(long position) {
            return (desc)super.position(position);
        }
        @Override public desc getPointer(long i) {
            return new desc((Pointer)this).offsetAddress(i);
        }
    
        /** The underlying C API data structure. */
        public native @ByRef dnnl_memory_desc_t data(); public native desc data(dnnl_memory_desc_t setter);

        /** Constructs a zero (empty) memory descriptor. Such a memory
         *  descriptor can be used to indicate absence of an argument. */
        
        ///
        ///
        public desc() { super((Pointer)null); allocate(); }
        private native void allocate();

        /** Constructs a memory descriptor.
         * 
         *  \note
         *      The logical order of dimensions corresponds to the {@code abc...}
         *      format tag, and the physical meaning of the dimensions depends
         *      both on the primitive that would operate on this memory and
         *      the operation context.
         * 
         *  @param adims Tensor dimensions.
         *  @param adata_type Data precision/type.
         *  @param aformat_tag Memory format tag.
         *  @param allow_empty A flag signifying whether construction is
         *      allowed to fail without throwing an exception. In this case a
         *      zero memory descriptor will be constructed. This flag is
         *      optional and defaults to false. */
        
        ///
        ///
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, aformat_tag, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, format_tag aformat_tag) { super((Pointer)null); allocate(adims, adata_type, aformat_tag); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, format_tag aformat_tag);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, aformat_tag, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, format_tag aformat_tag) { super((Pointer)null); allocate(adims, adata_type, aformat_tag); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, format_tag aformat_tag);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, aformat_tag, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, format_tag aformat_tag,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, format_tag aformat_tag) { super((Pointer)null); allocate(adims, adata_type, aformat_tag); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, format_tag aformat_tag);

        /** Constructs a memory descriptor by strides.
         * 
         *  \note
         *      The logical order of dimensions corresponds to the {@code abc...}
         *      format tag, and the physical meaning of the dimensions depends
         *      both on the primitive that would operate on this memory and
         *      the operation context.
         * 
         *  @param adims Tensor dimensions.
         *  @param adata_type Data precision/type.
         *  @param strides Strides for each dimension.
         *  @param allow_empty A flag signifying whether construction is
         *      allowed to fail without throwing an exception. In this case a
         *      zero memory descriptor will be constructed. This flag is
         *      optional and defaults to false. */
        
        ///
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer strides,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, strides, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer strides,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer strides) { super((Pointer)null); allocate(adims, adata_type, strides); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer strides);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer strides,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, strides, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer strides,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer strides) { super((Pointer)null); allocate(adims, adata_type, strides); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer strides);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] strides,
                        @Cast("bool") boolean allow_empty/*=false*/) { super((Pointer)null); allocate(adims, adata_type, strides, allow_empty); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] strides,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] strides) { super((Pointer)null); allocate(adims, adata_type, strides); }
        private native void allocate(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, data_type adata_type, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] strides);

        /** Constructs a memory descriptor from a C API data structure.
         * 
         *  @param data A C API ::dnnl_memory_desc_t structure. */
        public desc(@Const @ByRef dnnl_memory_desc_t data) { super((Pointer)null); allocate(data); }
        private native void allocate(@Const @ByRef dnnl_memory_desc_t data);

        /** Constructs a memory descriptor for a region inside an area
         *  described by this memory descriptor. */
        //
        /** @param adims Sizes of the region.
        /** @param offsets Offsets to the region from the encompassing
        /**     memory object in each dimension.
        /** @param allow_empty A flag signifying whether construction is
        /**     allowed to fail without throwing an exception. In this case a
        /**     zero memory descriptor will be returned. This flag is optional
        /**     and defaults to false.
        /** @return A memory descriptor for the region. */
        
        ///
        ///
        ///
        ///
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer offsets,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer offsets);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer offsets,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer offsets);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] offsets,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc submemory_desc(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, @Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] offsets);

        /** Constructs a memory descriptor by reshaping an existing one. The
         *  new memory descriptor inherits the data type. This operation is
         *  valid only for memory descriptors that have format_kind set to
         *  #dnnl::memory::format_kind::blocked or
         *  #dnnl::memory::format_kind::any.
         * 
         *  The operation ensures that the transformation of the physical memory
         *  format corresponds to the transformation of the logical dimensions.
         *  If such transformation is impossible, the function either throws an
         *  exception (default) or returns a zero memory descriptor depending on
         *  the {@code allow_empty} flag.
         * 
         *  The reshape operation can be described as a combination of the
         *  following basic operations:
         *  1. Add a dimension of size {@code 1}. This is always possible.
         *  2. Remove a dimension of size {@code 1}. This is possible only if the
         *     dimension has no padding (i.e.
         *     {@code padded_dims[dim] == dims[dim] && dims[dim] == 1}).
         *  3. Split a dimension into multiple ones. This is possible only if
         *     the product of all tensor dimensions stays constant and the
         *     dimension being split does not have padding (i.e.
         *     {@code padded_dims[dim] = dims[dim]}).
         *  4. Join multiple consecutive dimensions into a single one. As in
         *     the cases above, this requires that the dimensions do not have
         *     padding and that the memory format is such that in physical
         *     memory these dimensions are dense and have the same order as
         *     their logical counterparts. This also assumes that these
         *     dimensions are not blocked.
         *     - Here, 'dense' means:
         *       {@code stride for dim[i] == (stride for dim[i + 1]) * dim[i + 1]};
         *     - And 'same order' means:
         *       {@code i < j} if and only if {@code stride for dim[j] <= stride for dim[i]}.
         * 
         *  \warning
         *      Some combinations of physical memory layout and/or offsets or
         *      dimensions may result in a failure to make a reshape.
         * 
         *  @param adims New dimensions. The product of dimensions must
         *      remain constant.
         *  @param allow_empty A flag signifying whether construction is
         *      allowed to fail without throwing an exception. In this case a
         *      zero memory descriptor will be returned. This flag is optional
         *      and defaults to false.
         *  @return A new memory descriptor with new dimensions. */
        
        ///
        ///
        ///
        ///
        ///
        ///
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims, @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongPointer adims);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims, @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef LongBuffer adims);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims, @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc reshape(@Const @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByRef long[] adims);

        /** Constructs a memory descriptor by permuting axes in an existing
         *  one.
         * 
         *  The physical memory layout representation is adjusted accordingly
         *  to maintain the consistency between the logical and physical parts
         *  of the memory descriptor. The new memory descriptor inherits the
         *  data type.
         * 
         *  The new memory descriptor inherits the data type. This operation is
         *  valid only for memory descriptors that have format_kind set to
         *  #dnnl::memory::format_kind::blocked or
         *  #dnnl::memory::format_kind::any.
         * 
         *  The logical axes will be permuted in the following manner:
         *  <pre>{@code
         *  for (i = 0; i < ndims(); i++)
         *      new_desc.dims()[permutation[i]] = dims()[i];
         *  }</pre>
         * 
         *  Example:
         *  <pre>{@code
         *      std::vector<int> permutation = {1, 0}; // swap the first and
         *                                             // the second axes
         *      dnnl::memory::desc in_md(
         *              {2, 3}, data_type, memory::format_tag::ab);
         *      dnnl::memory::desc expect_out_md(
         *              {3, 2}, data_type, memory::format_tag::ba);
         * 
         *      assert(in_md.permute_axes(permutation) == expect_out_md);
         *  }</pre>
         * 
         *  @param permutation Axes permutation.
         *  @param allow_empty A flag signifying whether construction is
         *      allowed to fail without throwing an exception. In this case a
         *      zero memory descriptor will be returned. This flag is optional
         *      and defaults to false.
         *  @return A new memory descriptor with new dimensions. */
        public native @ByVal desc permute_axes(@StdVector IntPointer permutation,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc permute_axes(@StdVector IntPointer permutation);
        public native @ByVal desc permute_axes(@StdVector IntBuffer permutation,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc permute_axes(@StdVector IntBuffer permutation);
        public native @ByVal desc permute_axes(@StdVector int[] permutation,
                        @Cast("bool") boolean allow_empty/*=false*/);
        public native @ByVal desc permute_axes(@StdVector int[] permutation);

        /** Returns the data type of the memory descriptor.
         *  @return The data type. */
        
        ///
        public native data_type data_type();

        /** Returns dimensions of the memory descriptor.
         * 
         *  Potentially expensive due to the data copy involved.
         *  @return A copy of the dimensions vector. */
        public native @Cast({"dnnl_dim_t*", "std::vector<dnnl_dim_t>&"}) @StdVector("dnnl_dim_t") @ByVal LongPointer dims();

        /** Returns size of the memory descriptor in bytes.
         *  @return The number of bytes required to allocate a memory buffer
         *      for the memory object described by this memory descriptor
         *      including the padding area. */
        public native @Cast("size_t") long get_size();

        /** Checks whether the memory descriptor is zero (empty).
         *  @return \c true if the memory descriptor describes an empty
         *      memory and \c false otherwise. */
        public native @Cast("bool") boolean is_zero();

        /** An equality operator.
         *  @param other Another memory descriptor.
         *  @return Whether this and the other memory descriptors have
         *      the same format tag, dimensions, strides, blocking, etc. */
        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef desc other);

        /** An inequality operator.
         *  @param other Another memory descriptor.
         *  @return Whether this and the other memory descriptors describe
         *      different memory. */
        
        ///
        public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef desc other);

        /** Checks whether the object is not empty.
         * 
         *  @return Whether the object is not empty. */
        public native @Cast("bool") @Name("operator bool") boolean asBoolean();
    }

    /** Default constructor.
     * 
     *  Constructs an empty memory object, which can be used to indicate
     *  absence of a parameter. */

    /** Constructs a memory object.
     * 
     *  Unless \p handle is equal to #DNNL_MEMORY_NONE, the constructed memory
     *  object will have the underlying buffer set. In this case, the buffer
     *  will be initialized as if #dnnl::memory::set_data_handle() had been
     *  called.
     * 
     *  @see memory::set_data_handle()
     * 
     *  @param md Memory descriptor.
     *  @param aengine Engine to store the data on.
     *  @param handle Handle of the memory buffer to use.
     *      - A pointer to the user-allocated buffer. In this case the library
     *        doesn't own the buffer.
     *      - The #DNNL_MEMORY_ALLOCATE special value. Instructs the library to
     *        allocate the buffer for the memory object. In this case the
     *        library owns the buffer.
     *      - #DNNL_MEMORY_NONE to create dnnl::memory without an underlying
     *        buffer. */
    
    ///
    ///
    public memory(@Const @ByRef desc md, @Const @ByRef engine aengine, Pointer handle) { super((Pointer)null); allocate(md, aengine, handle); }
    private native void allocate(@Const @ByRef desc md, @Const @ByRef engine aengine, Pointer handle);

    /** Constructs a memory object.
     * 
     *  The underlying buffer for the memory will be allocated by the library.
     * 
     *  @param md Memory descriptor.
     *  @param aengine Engine to store the data on. */
    public memory(@Const @ByRef desc md, @Const @ByRef engine aengine) { super((Pointer)null); allocate(md, aengine); }
    private native void allocate(@Const @ByRef desc md, @Const @ByRef engine aengine);

    /** Returns the associated memory descriptor. */
    public native @ByVal desc get_desc();

    /** Returns the associated engine. */
    
    ///
    public native @ByVal engine get_engine();

    /** Returns the underlying memory buffer.
     * 
     *  On the CPU engine, or when using USM, this is a pointer to the
     *  allocated memory. */
    
    ///
    ///
    ///
    ///
    public native Pointer get_data_handle();

    /** Sets the underlying memory buffer.
     * 
     *  This function may write zero values to the memory specified by the \p
     *  handle if the memory object has a zero padding area. This may be time
     *  consuming and happens each time this function is called. The
     *  operation is always blocking and the stream parameter is a hint.
     * 
     *  \note
     *      The zero padding is required by memory objects created with
     *      blocked memory format tags like #dnnl_aBcd8b when any of the
     *      dimensions is not a multiple of the corresponding block size. For
     *      "plain" formats like #dnnl::memory::format_tag::nchw or
     *      #dnnl::memory::format_tag::nhwc zero padding area needs to be set
     *      up explicitly when creating the corresponding memory descriptors.
     *      See \ref dev_guide_understanding_memory_formats for more details.
     * 
     *  \note
     *      Even when the memory object is used to hold values that stay
     *      constant during the execution of the program (pre-packed weights
     *      during inference, for example), the function will still write
     *      zeroes to the padding area if it exists. Hence, the \p handle
     *      parameter cannot and does not have a const qualifier.
     * 
     *  @param handle Memory buffer to use. On the CPU engine or when USM is
     *      used, the memory buffer is a pointer to the actual data. For OpenCL
     *      it is a cl_mem. It must have at least
     *      #dnnl::memory::desc::get_size() bytes allocated.
     *  @param astream Stream to use to execute padding in. */
    
    ///
    ///
    public native void set_data_handle(Pointer handle, @Const @ByRef stream astream);

    /** Sets the underlying memory buffer.
     * 
     *  See documentation for
     *  #dnnl::memory::set_data_handle(void *, const stream &) const
     *  for more information.
     * 
     *  @param handle Memory buffer to use. For the CPU engine, the memory
     *      buffer is a pointer to the actual data. For OpenCL it is a cl_mem.
     *      It must have at least #dnnl::memory::desc::get_size() bytes
     *      allocated. */
    
    ///
    ///
    ///
    ///
    ///
    public native void set_data_handle(Pointer handle);

    /** Maps a memory object and returns a host-side pointer to a memory
     *  buffer with a copy of its contents.
     * 
     *  Mapping enables read/write directly from/to the memory contents for
     *  engines that do not support direct memory access.
     * 
     *  Mapping is an exclusive operation - a memory object cannot be used in
     *  other operations until it is unmapped via #dnnl::memory::unmap_data()
     *  call.
     * 
     *  \note
     *      Any primitives working with the memory should be completed before
     *      the memory is mapped. Use #dnnl::stream::wait() to synchronize the
     *      corresponding execution stream.
     * 
     *  \note
     *      The map_data and unmap_data functions are provided mainly for
     *      debug and testing purposes and their performance may be suboptimal.
     * 
     *  \tparam T Data type to return a pointer to.
     *  @return Pointer to the mapped memory. */

    /** Unmaps a memory object and writes back any changes made to the
     *  previously mapped memory buffer.
     * 
     *  \note
     *      The map_data and unmap_data functions are provided mainly for
     *      debug and testing purposes and their performance may be
     *      suboptimal.
     * 
     *  @param mapped_ptr A pointer previously returned by
     *      #dnnl::memory::map_data(). */
    public native void unmap_data(Pointer mapped_ptr);

    public static native @Cast("dnnl_data_type_t") int convert_to_c(data_type adata_type);
    public static native @Cast("dnnl_format_tag_t") int convert_to_c(format_tag format);
}
