// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.flycapture.FlyCapture2;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.flycapture.global.FlyCapture2.*;


    /**
     * The CameraBase class is an abstract base class that defines a general
     * interface to a camera.
     *
     * \nosubgrouping
     */
    @Namespace("FlyCapture2") @NoOffset @Properties(inherit = org.bytedeco.flycapture.presets.FlyCapture2.class)
public class CameraBase extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public CameraBase(Pointer p) { super(p); }
    

            /**
             * Default constructor.
             */

            /**
             * Default destructor.
             */

            /**
             * \name Connection and Image Retrieval
             *
             * These functions deal with connections and image retrieval from
             * the camera.
             */
            /*@{*/

            /**
             * Connects the camera object to the camera specified by the GUID.
             * If the guid is omitted or set to NULL, the connection will be made
             * to the first camera detected on the PC (i.e. index = 0).
             *
             * @param pGuid The unique identifier for a specific camera on the PC.
             *
             * @see BusManager::GetCameraFromIndex()
             * @see BusManager::GetCameraFromSerialNumber()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error Connect( PGRGuid pGuid/*=NULL*/ );
            public native @ByVal Error Connect( );

            /**
             * Disconnects the camera object from the camera. This allows another
             * physical camera specified by a GUID to be connected to the camera
             * object.
             *
             * @see Connect()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error Disconnect();

            /**
             * Checks if the camera object is connected to a physical camera
             * specified by a GUID.
             *
             * @see Connect()
             * @see Disconnect()
             *
             * @return Whether Connect() was called on the camera object.
             */
            public native @Cast("bool") boolean IsConnected();

            /**
             * Sets the callback data to be used on completion of image transfer.
             * To clear the current stored callback data, pass in NULL for both
             * arguments.
             *
             * @param callbackFn A function to be called when a new image is
             *                   received.
             * @param pCallbackData A pointer to data that can be passed to the
             *                      callback function.
             *
             * @see StartCapture()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetCallback(
                                ImageEventCallback callbackFn,
                                @Const Pointer pCallbackData/*=NULL*/ );
            public native @ByVal Error SetCallback(
                                ImageEventCallback callbackFn );

            /**
             * Starts isochronous image capture. It will use either the current
             * video mode or the most recently set video mode of the camera.
             * The optional callback function parameter is called on completion of
             * image transfer.
             * When a callback function is specified, the grab mode will determine how
             * images are delivered.
             * If the grab mode has not been set, or has been set to DROP_FRAMES
             * the default behavior is to requeue images for DMA if they have
             * not been delivered by the time the next image transfer completes.
             * If BUFFER_FRAMES is specified, the next image in the sequence will
             * be delivered. Note that for the BUFFER_FRAMES case, if delivery
             * does not keep up with the DMA process, images will be lost.
             * The default behavior is to perform DROP_FRAMES image delivery
             * Alternatively, the callback parameter can be set to NULL
             * and RetrieveBuffer() can be called as a blocking call to get
             * the image data.
             *
             * @param callbackFn A function to be called when a new image is
             *                   received.
             * @param pCallbackData A pointer to data that can be passed to the
             *                      callback function.
             *
             * @see RetrieveBuffer()
             * @see StartSyncCapture()
             * @see StopCapture()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error StartCapture(
                                ImageEventCallback callbackFn/*=NULL*/,
                                @Const Pointer pCallbackData/*=NULL*/ );
            public native @ByVal Error StartCapture( );

            /**
             * Starts isochronous image capture on multiple cameras. On each frame,
             * the time stamps across the cameras are aligned which means the frames
             * are synchronized. Note that the cameras must be synchronized by
             * external means in order for this function to work. This means that
             * the cameras should either be on the same bus, hardware synchronized
             * (e.g. through triggering) or Multisync is running.
             * This function is only used with firewire cameras.
             *
             * @param numCameras Number of Camera objects in the ppCameras array.
             * @param ppCameras Array of pointers to Camera objects containing the
             *                  cameras to be started and synchronized.
             * @param pCallbackFns Array of callback functions for each camera.
             * @param pCallbackDataArray Array of callback data pointers.
             *
             * @see RetrieveBuffer()
             * @see StartCapture()
             * @see StopCapture()
             *
             * @return An Error indicating the success or failure of the function.
             */
            

            /**
             * Retrieves the the next image object containing the next image.
             * If the grab mode has not been set, or has been set to DROP_FRAMES
             * the default behavior is to requeue images for DMA if they have
             * not been retrieved by the time the next image transfer completes.
             * If BUFFER_FRAMES is specified, the next image in the sequence will
             * be retrieved.  Note that for the BUFFER_FRAMES case, if retrieval
             * does not keep up with the DMA process, images will be lost.
             * The default behavior is to perform DROP_FRAMES image retrieval.
             *
             * @param pImage Pointer to Image object to store image data.
             *
             * @see StartCapture()
             * @see StopCapture()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error RetrieveBuffer( Image pImage );

            /**
             * Stops isochronous image transfer and cleans up all associated
             * resources.
             * If an image callback function (specified in the StartCapture() call)
             * is currently executing, StopCapture() will not return until after
             * the callback has completed.
             *
             * @see StartCapture()
             * @see RetrieveBuffer()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error StopCapture();

            /**
             * Retrieves the next image event containing the next part of the image.
             *
             * @param pImage Pointer to Image object to store image data.
             * @param eventNumber The event number to wait for.
             *
             * @see StartCapture()
             * @see RetrieveBuffer()
             * @see StopCapture()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error WaitForBufferEvent( Image pImage, @Cast("unsigned int") int eventNumber );

            /**
             * Specify user allocated buffers to use as image data buffers.
             * To prevent image tearing, the size of each buffer should be equal to
             * ((unsigned int)(bufferSize + packetSize - 1)/packetSize) * packetSize.
             * The total size should be (size * numBuffers) or larger.
             * The packet Size that should be used differs between interfaces:
             *  Firewire:   Use the Format7 packet size.
             *  Usb2:       First round to Format7 packet size then round to 512 bytes.
             *  Usb3:       Use a packet size of 1024 bytes.
             *  GigE:       No need to do any rounding on GigE
             *
             * @param pMemBuffers Pointer to memory buffers to be written to.
             * @param size The size of each buffer (in bytes).
             * @param numBuffers Number of buffers in the array.
             *
             * @see StartCapture()
             * @see RetrieveBuffer()
             * @see StopCapture()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetUserBuffers(
                                @Cast("unsigned char*const") BytePointer pMemBuffers,
                                int size,
                                int numBuffers );
            public native @ByVal Error SetUserBuffers(
                                @Cast("unsigned char*const") ByteBuffer pMemBuffers,
                                int size,
                                int numBuffers );
            public native @ByVal Error SetUserBuffers(
                                @Cast("unsigned char*const") byte[] pMemBuffers,
                                int size,
                                int numBuffers );

            /**
             * Get the configuration associated with the camera object.
             *
             * @param pConfig Pointer to the configuration structure to be filled.
             *
             * @see SetConfiguration()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetConfiguration( FC2Config pConfig );

            /**
             * Set the configuration associated with the camera object.
             *
             * @param pConfig Pointer to the configuration structure to be used.
             *
             * @see GetConfiguration()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetConfiguration( @Const FC2Config pConfig );

            /*@}*/

            /**
             * \name Information and Properties
             *
             * These functions deal with information and properties can be
             * retrieved from the camera.
             */
            /*@{*/

            /**
             * Retrieves information from the camera such as serial number, model
             * name and other camera information.
             *
             * @param pCameraInfo Pointer to the camera information structure
             *                    to be filled.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetCameraInfo( CameraInfo pCameraInfo );

            /**
             * Retrieves information about the specified camera property. The
             * property type must be specified in the PropertyInfo structure
             * passed into the function in order for the function to succeed.
             *
             * @param pPropInfo Pointer to the PropertyInfo structure to be filled.
             *
             * @see GetProperty()
             * @see SetProperty()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetPropertyInfo( PropertyInfo pPropInfo );

            /**
             * Reads the settings for the specified property from the camera. The
             * property type must be specified in the Property structure passed
             * into the function in order for the function to succeed. If auto
             * is on, the integer and abs values returned may not be consistent
             * with each other.
             *
             * @param pProp Pointer to the Property structure to be filled.
             *
             * @see GetPropertyInfo()
             * @see SetProperty()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetProperty( Property pProp );

            /**
             * Writes the settings for the specified property to the camera. The
             * property type must be specified in the Property structure passed
             * into the function in order for the function to succeed.
             * The absControl flag controls whether the absolute or integer value
             * is written to the camera. Use GetPropertyInfo() to query which 
             * options are available for a specific property.
             *
             * @param pProp Pointer to the Property structure to be used.
             * @param broadcast Whether the action should be broadcast.
             *
             * @see GetPropertyInfo()
             * @see GetProperty()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetProperty(
                                @Const Property pProp,
                                @Cast("bool") boolean broadcast/*=false*/ );
            public native @ByVal Error SetProperty(
                                @Const Property pProp );

            /*@}*/

            /**
             * \name General Purpose Input / Output
             *
             * These functions deal with general GPIO pin control on the camera.
             */
            /*@{*/

            /**
             * Get the GPIO pin direction for the specified pin. This is not a
             * required call when using the trigger or strobe functions as
             * the pin direction is set automatically internally.
             *
             * @param pin Pin to get the direction for.
             * @param pDirection Direction of the pin. 0 for input, 1 for output.
             *
             * @see SetGPIOPinDirection()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetGPIOPinDirection( @Cast("unsigned int") int pin, @Cast("unsigned int*") IntPointer pDirection);
            public native @ByVal Error GetGPIOPinDirection( @Cast("unsigned int") int pin, @Cast("unsigned int*") IntBuffer pDirection);
            public native @ByVal Error GetGPIOPinDirection( @Cast("unsigned int") int pin, @Cast("unsigned int*") int[] pDirection);

            /**
             * Set the GPIO pin direction for the specified pin. This is useful if
             * there is a need to set the pin into an input pin (i.e. to read the
             * voltage) off the pin without setting it as a trigger source. This
             * is not a required call when using the trigger or strobe functions as
             * the pin direction is set automatically internally.
             *
             * @param pin Pin to get the direction for.
             * @param direction Direction of the pin. 0 for input, 1 for output.
             * @param broadcast Whether the action should be broadcast.
             *
             * @see GetGPIOPinDirection()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetGPIOPinDirection( @Cast("unsigned int") int pin, @Cast("unsigned int") int direction, @Cast("bool") boolean broadcast/*=false*/ );
            public native @ByVal Error SetGPIOPinDirection( @Cast("unsigned int") int pin, @Cast("unsigned int") int direction );

            /*@}*/

            /**
             * \name Trigger
             *
             * These functions deal with trigger control on the camera.
             */
            /*@{*/

            /**
             * Retrieve trigger information from the camera.
             *
             * @param pTriggerModeInfo Structure to receive trigger information.
             *
             * @see GetTriggerMode()
             * @see SetTriggerMode()
             * @see GetTriggerDelayInfo()
             * @see GetTriggerDelay()
             * @see SetTriggerDelay()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetTriggerModeInfo( TriggerModeInfo pTriggerModeInfo );

            /**
             * Retrieve current trigger settings from the camera.
             *
             * @param pTriggerMode Structure to receive trigger mode settings.
             *
             * @see GetTriggerModeInfo()
             * @see SetTriggerMode()
             * @see GetTriggerDelayInfo()
             * @see GetTriggerDelay()
             * @see SetTriggerDelay()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetTriggerMode( TriggerMode pTriggerMode );

            /**
             * Set the specified trigger settings to the camera.
             *
             * @param pTriggerMode Structure providing trigger mode settings.
             * @param broadcast Whether the action should be broadcast.
             *
             * @see GetTriggerModeInfo()
             * @see GetTriggerMode()
             * @see GetTriggerDelayInfo()
             * @see GetTriggerDelay()
             * @see SetTriggerDelay()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetTriggerMode(
                                @Const TriggerMode pTriggerMode,
                                @Cast("bool") boolean broadcast/*=false*/ );
            public native @ByVal Error SetTriggerMode(
                                @Const TriggerMode pTriggerMode );

            /**
             * Fire the software trigger according to the DCAM specifications.
             *
             * @param broadcast Whether the action should be broadcast.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error FireSoftwareTrigger( @Cast("bool") boolean broadcast/*=false*/ );
            public native @ByVal Error FireSoftwareTrigger( );

            /**
             * Retrieve trigger delay information from the camera.
             *
             * @param pTriggerDelayInfo Structure to receive trigger delay information.
             *
             * @see GetTriggerModeInfo()
             * @see GetTriggerMode()
             * @see SetTriggerMode()
             * @see GetTriggerDelay()
             * @see SetTriggerDelay()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetTriggerDelayInfo( @Cast("FlyCapture2::TriggerDelayInfo*") PropertyInfo pTriggerDelayInfo );

            /**
             * Retrieve current trigger delay settings from the camera.
             *
             * @param pTriggerDelay Structure to receive trigger delay settings.
             *
             * @see GetTriggerModeInfo()
             * @see GetTriggerMode()
             * @see SetTriggerMode()
             * @see GetTriggerDelayInfo()
             * @see SetTriggerDelay()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetTriggerDelay( @Cast("FlyCapture2::TriggerDelay*") Property pTriggerDelay );

            /**
             * Set the specified trigger delay settings to the camera.
             *
             * @param pTriggerDelay Structure providing trigger delay settings.
             * @param broadcast Whether the action should be broadcast.
             *
             * @see GetTriggerModeInfo()
             * @see GetTriggerMode()
             * @see SetTriggerMode()
             * @see GetTriggerDelayInfo()
             * @see GetTriggerDelay()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetTriggerDelay(
                                @Cast("const FlyCapture2::TriggerDelay*") Property pTriggerDelay,
                                @Cast("bool") boolean broadcast/*=false*/ );
            public native @ByVal Error SetTriggerDelay(
                                @Cast("const FlyCapture2::TriggerDelay*") Property pTriggerDelay );

            /*@}*/

            /**
             * \name Strobe
             *
             * These functions deal with strobe control on the camera.
             */
            /*@{*/

            /**
             * Retrieve strobe information from the camera.
             *
             * @param pStrobeInfo Structure to receive strobe information.
             *
             * @see GetStrobe()
             * @see SetStrobe()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetStrobeInfo( StrobeInfo pStrobeInfo );

            /**
             * Retrieve current strobe settings from the camera. The strobe pin
             * must be specified in the structure before being passed in to
             * the function.
             *
             * @param pStrobeControl Structure to receive strobe settings.
             *
             * @see GetStrobeInfo()
             * @see SetStrobe()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetStrobe( StrobeControl pStrobeControl );

            /**
             * Set current strobe settings to the camera. The strobe pin
             * must be specified in the structure before being passed in to
             * the function.
             *
             * @param pStrobeControl Structure providing strobe settings.
             * @param broadcast Whether the action should be broadcast.
             *
             * @see GetStrobeInfo()
             * @see GetStrobe()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetStrobe(
                                @Const StrobeControl pStrobeControl,
                                @Cast("bool") boolean broadcast/*=false*/ );
            public native @ByVal Error SetStrobe(
                                @Const StrobeControl pStrobeControl );

            /*@}*/

            /**
             * \name Look Up Table
             *
             * These functions deal with Look Up Table control on the camera.
             */
            /*@{*/

            /**
             * Query if LUT support is available on the camera. Note that some cameras
             * may report support for the LUT and return an inputBitDepth of 0. In these
             * cases use log2(numEntries) for the inputBitDepth.
             *
             * @param pData The LUT structure to be filled.
             *
             * @see EnableLUT()
             * @see GetLUTChannel()
             * @see SetLUTChannel()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetLUTInfo( LUTData pData );

            /**
             * Query the read/write status of a single LUT bank.
             *
             * @param bank The bank to query.
             * @param pReadSupported Whether reading from the bank is supported.
             * @param pWriteSupported Whether writing to the bank is supported.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetLUTBankInfo(
                                @Cast("unsigned int") int bank,
                                @Cast("bool*") BoolPointer pReadSupported,
                                @Cast("bool*") BoolPointer pWriteSupported );
            public native @ByVal Error GetLUTBankInfo(
                                @Cast("unsigned int") int bank,
                                @Cast("bool*") boolean[] pReadSupported,
                                @Cast("bool*") boolean[] pWriteSupported );

            /**
             * Get the LUT bank that is currently being used. For cameras with
             * PGR LUT, the active bank is always 0.
             *
             * @param pActiveBank The currently active bank.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetActiveLUTBank( @Cast("unsigned int*") IntPointer pActiveBank );
            public native @ByVal Error GetActiveLUTBank( @Cast("unsigned int*") IntBuffer pActiveBank );
            public native @ByVal Error GetActiveLUTBank( @Cast("unsigned int*") int[] pActiveBank );

            /**
             * Set the LUT bank that will be used.
             *
             * @param activeBank The bank to be set as active.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetActiveLUTBank( @Cast("unsigned int") int activeBank );

            /**
             * Enable or disable LUT functionality on the camera.
             *
             * @param on Whether to enable or disable LUT.
             *
             * @see GetLUTInfo()
             * @see GetLUTChannel()
             * @see SetLUTChannel()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error EnableLUT( @Cast("bool") boolean on );

            /**
             * Get the LUT channel settings from the camera.
             *
             * @param bank Bank to retrieve.
             * @param channel Channel to retrieve.
             * @param sizeEntries Number of entries in LUT table to read.
             * @param pEntries Array to store LUT entries.
             *
             * @see GetLUTInfo()
             * @see EnableLUT()
             * @see SetLUTChannel()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetLUTChannel(
                                @Cast("unsigned int") int bank,
                                @Cast("unsigned int") int channel,
                                @Cast("unsigned int") int sizeEntries,
                                @Cast("unsigned int*") IntPointer pEntries );
            public native @ByVal Error GetLUTChannel(
                                @Cast("unsigned int") int bank,
                                @Cast("unsigned int") int channel,
                                @Cast("unsigned int") int sizeEntries,
                                @Cast("unsigned int*") IntBuffer pEntries );
            public native @ByVal Error GetLUTChannel(
                                @Cast("unsigned int") int bank,
                                @Cast("unsigned int") int channel,
                                @Cast("unsigned int") int sizeEntries,
                                @Cast("unsigned int*") int[] pEntries );

            /**
             * Set the LUT channel settings to the camera.
             *
             * @param bank Bank to set.
             * @param channel Channel to set.
             * @param sizeEntries Number of entries in LUT table to write. This must be the
             *                    same size as numEntries returned by GetLutInfo().
             * @param pEntries Array containing LUT entries to write.
             *
             * @see GetLUTInfo()
             * @see EnableLUT()
             * @see GetLUTChannel()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetLUTChannel(
                                @Cast("unsigned int") int bank,
                                @Cast("unsigned int") int channel,
                                @Cast("unsigned int") int sizeEntries,
                                @Cast("const unsigned int*") IntPointer pEntries );
            public native @ByVal Error SetLUTChannel(
                                @Cast("unsigned int") int bank,
                                @Cast("unsigned int") int channel,
                                @Cast("unsigned int") int sizeEntries,
                                @Cast("const unsigned int*") IntBuffer pEntries );
            public native @ByVal Error SetLUTChannel(
                                @Cast("unsigned int") int bank,
                                @Cast("unsigned int") int channel,
                                @Cast("unsigned int") int sizeEntries,
                                @Cast("const unsigned int*") int[] pEntries );

            /*@}*/

            /**
             * \name Memory Channels
             *
             * These functions deal with memory channel control on the camera.
             */
            /*@{*/

            /**
             * Retrieve the current memory channel from the camera.
             *
             * @param pCurrentChannel Current memory channel.
             *
             * @see SaveToMemoryChannel()
             * @see RestoreFromMemoryChannel()
             * @see GetMemoryChannelInfo()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetMemoryChannel( @Cast("unsigned int*") IntPointer pCurrentChannel );
            public native @ByVal Error GetMemoryChannel( @Cast("unsigned int*") IntBuffer pCurrentChannel );
            public native @ByVal Error GetMemoryChannel( @Cast("unsigned int*") int[] pCurrentChannel );

            /**
             * Save the current settings to the specfied current memory channel.
             *
             * @param channel Memory channel to save to.
             *
             * @see GetMemoryChannel()
             * @see RestoreFromMemoryChannel()
             * @see GetMemoryChannelInfo()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SaveToMemoryChannel( @Cast("unsigned int") int channel );

            /**
             * Restore the specfied current memory channel.
             *
             * @param channel Memory channel to restore from.
             *
             * @see GetMemoryChannel()
             * @see SaveToMemoryChannel()
             * @see GetMemoryChannelInfo()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error RestoreFromMemoryChannel( @Cast("unsigned int") int channel );

            /**
             * Query the camera for memory channel support. If the number of
             * channels is 0, then memory channel support is not available.
             *
             * @param pNumChannels Number of memory channels supported.
             *
             * @see GetMemoryChannel()
             * @see SaveToMemoryChannel()
             * @see RestoreFromMemoryChannel()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetMemoryChannelInfo( @Cast("unsigned int*") IntPointer pNumChannels );
            public native @ByVal Error GetMemoryChannelInfo( @Cast("unsigned int*") IntBuffer pNumChannels );
            public native @ByVal Error GetMemoryChannelInfo( @Cast("unsigned int*") int[] pNumChannels );

            /*@}*/

            /**
             * \name Embedded Image Information
             *
             * These functions deal with embedded image information control
             * on the camera.
             */
            /*@{*/

            /**
             * Get the current status of the embedded image information register,
             * as well as the availability of each embedded property.
             *
             * @param pInfo Structure to be filled.
             *
             * @see SetEmbeddedImageInfo()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetEmbeddedImageInfo( EmbeddedImageInfo pInfo );

            /**
             * Sets the on/off values of the embedded image information structure
             * to the camera.
             *
             * @param pInfo Structure to be used.
             *
             * @see GetEmbeddedImageInfo()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error SetEmbeddedImageInfo( EmbeddedImageInfo pInfo );

            /*@}*/

            /**
             * \name Register Operation
             *
             * These functions deal with register operation on the camera.
             */
            /*@{*/

            /**
             * Write to the specified register on the camera.
             *
             * @param address DCAM address to be written to.
             * @param value The value to be written.
             * @param broadcast Whether the action should be broadcast.
             *
             * @see ReadRegister()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error WriteRegister(
                                @Cast("unsigned int") int address,
                                @Cast("unsigned int") int value,
                                @Cast("bool") boolean broadcast/*=false*/);
            public native @ByVal Error WriteRegister(
                                @Cast("unsigned int") int address,
                                @Cast("unsigned int") int value);

            /**
             * Read the specified register from the camera.
             *
             * @param address DCAM address to be read from.
             * @param pValue The value that is read.
             *
             * @see WriteRegister()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error ReadRegister(
                                @Cast("unsigned int") int address,
                                @Cast("unsigned int*") IntPointer pValue );
            public native @ByVal Error ReadRegister(
                                @Cast("unsigned int") int address,
                                @Cast("unsigned int*") IntBuffer pValue );
            public native @ByVal Error ReadRegister(
                                @Cast("unsigned int") int address,
                                @Cast("unsigned int*") int[] pValue );

            /**
             * Write to the specified register block on the camera.
             *
             * @param addressHigh Top 16 bits of the 48 bit absolute address to
             *                    write to.
             * @param addressLow Bottom 32 bits of the 48 bits absolute address to
             *                   write to.
             * @param pBuffer Array containing data to be written.
             * @param length Size of array, in quadlets.
             *
             * @see ReadRegisterBlock()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error WriteRegisterBlock(
                                @Cast("unsigned short") short addressHigh,
                                @Cast("unsigned int") int addressLow,
                                @Cast("const unsigned int*") IntPointer pBuffer,
                                @Cast("unsigned int") int length );
            public native @ByVal Error WriteRegisterBlock(
                                @Cast("unsigned short") short addressHigh,
                                @Cast("unsigned int") int addressLow,
                                @Cast("const unsigned int*") IntBuffer pBuffer,
                                @Cast("unsigned int") int length );
            public native @ByVal Error WriteRegisterBlock(
                                @Cast("unsigned short") short addressHigh,
                                @Cast("unsigned int") int addressLow,
                                @Cast("const unsigned int*") int[] pBuffer,
                                @Cast("unsigned int") int length );

            /**
             * Read from the specified register block on the camera.
             *
             * @param addressHigh Top 16 bits of the 48 bit absolute address to
             *                    read from.
             * @param addressLow Bottom 32 bits of the 48 bits absolute address to
             *                   read from.
             * @param pBuffer Array to store read data.
             * @param length Size of array, in quadlets.
             *
             * @see WriteRegisterBlock()
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error ReadRegisterBlock(
                                @Cast("unsigned short") short addressHigh,
                                @Cast("unsigned int") int addressLow,
                                @Cast("unsigned int*") IntPointer pBuffer,
                                @Cast("unsigned int") int length );
            public native @ByVal Error ReadRegisterBlock(
                                @Cast("unsigned short") short addressHigh,
                                @Cast("unsigned int") int addressLow,
                                @Cast("unsigned int*") IntBuffer pBuffer,
                                @Cast("unsigned int") int length );
            public native @ByVal Error ReadRegisterBlock(
                                @Cast("unsigned short") short addressHigh,
                                @Cast("unsigned int") int addressLow,
                                @Cast("unsigned int*") int[] pBuffer,
                                @Cast("unsigned int") int length );

            /**
             * Returns a text representation of the register value.
             *
             * @param registerVal The register value to query.
             *
             * @return The text representation of the register.
             */
            

            /**
             * Returns a Timestamp struct containing 1394 CYCLE_TIME information
             *
             * @param registerVal The register value to query.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetCycleTime(TimeStamp timeStamp);

            /*
             * Returns the camera diagnostic infomation.
             *
             * @param pStats Pointer to the CameraStats structure.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error GetStats( CameraStats pStats );

            /*
             * Reset the camera diagnostic infomation.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error ResetStats();

            /*
             * Register the camera to issue a custom callback function call for a
             * specific device event.
             *
             * @param pOpts Pointer to the EventOptions structure which defines the
             *              callback function to use, the event for which to register
             *              the device, and a pointer to user data (optional) to be
             *              passed to the callback function.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error RegisterEvent( EventOptions pOpts );

            /*
             * De-register an event previously registered with the camera.
             *
             * @param pOpts Pointer to the EventOptions structure which defines the
             *              callback function to use, the event for which to register
             *              the device, and a pointer to user data (optional) to be
             *              passed to the callback function. The callback function and
             *              user data elements of the EventOptions structure are ignored
             *              in this call, and just the event name within the structure is
             *              used with this function call.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error DeregisterEvent( EventOptions pOpts );
            
            /*
             * Register the camera to issue a custom callback function call for a
             * specific device event.
             *
             * @param pOpts Pointer to the EventOptions structure which defines the
             *              callback function to use, the event for which to register
             *              the device, and a pointer to user data (optional) to be
             *              passed to the callback function. The event name element of
             *              the structure is ignored with this function call. If a single
             *              event has already been registered via RegisterEvent(), this
             *              call will fail, as the user could accidentally change the
             *              the internal callback function pointer for a queued event.
             *              The user will need to de-register all registered events,
             *              then call this function again.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error RegisterAllEvents( EventOptions pOpts );

            /*
             * De-register all events registered with the camera.
             *
             * @return An Error indicating the success or failure of the function.
             */
            public native @ByVal Error DeregisterAllEvents( );
    }
