// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.flycapture.FlyCapture2;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.flycapture.global.FlyCapture2.*;


    /**
     * Configuration for a GigE camera.  These options are options that are
     * generally should be set before starting isochronous transfer.
     */
    @Namespace("FlyCapture2") @NoOffset @Properties(inherit = org.bytedeco.flycapture.presets.FlyCapture2.class)
public class GigEConfig extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public GigEConfig(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public GigEConfig(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public GigEConfig position(long position) {
            return (GigEConfig)super.position(position);
        }
        @Override public GigEConfig getPointer(long i) {
            return new GigEConfig((Pointer)this).offsetAddress(i);
        }
    
        /** Turn on/off packet resend functionality */
        public native @Cast("bool") boolean enablePacketResend(); public native GigEConfig enablePacketResend(boolean setter);

        /**
         * Number of retries to perform when a register read/write timeout
         * is received by the library. The default value is 0.
         */
        public native @Cast("unsigned int") int registerTimeoutRetries(); public native GigEConfig registerTimeoutRetries(int setter);

        /**
         * Register read/write timeout value, in microseconds.
         * The default value is dependent on the interface type.
         */
        public native @Cast("unsigned int") int registerTimeout(); public native GigEConfig registerTimeout(int setter);

        public GigEConfig() { super((Pointer)null); allocate(); }
        private native void allocate();
    }
